/*********************************************************************/
/* from regdef.v by regdef2h auto-generated C-header file            */
/* please see the regdef.html file for detailed register description */
/*********************************************************************/

#ifndef __regdef_NX500_h
#define __regdef_NX500_h


/* ===================================================================== */

/* Area of sram0_ahbls0 */

/* ===================================================================== */

#define Addr_NX500_sram0_ahbls0         0x00000000U
#define NX500_NETX_MEM_INTRN_SRAM0_AREA 0x00000000U

/* --------------------------------------------------------------------- */
/* Register intram0_base */
/* => internal SRAM AHBL slave 0 start address */
/*    Area size: 32kB */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    Write accesses in this memory area: 0WS, byte accessable */
/*    Offset 0x0 is ROM Boot-vector */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_intram0_base          0x00000004U
#define Adr_NX500_sram0_ahbls0_intram0_base 0x00000004U
#define Adr_NX500_intram0_base              0x00000004U

/* --------------------------------------------------------------------- */
/* Register intram0_end */
/* => internal SRAM AHBL slave 0 end address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_intram0_end          0x00007FFCU
#define Adr_NX500_sram0_ahbls0_intram0_end 0x00007FFCU
#define Adr_NX500_intram0_end              0x00007FFCU


/* ===================================================================== */

/* Area of sram1_ahbls1 */

/* ===================================================================== */

#define Addr_NX500_sram1_ahbls1         0x00008000U
#define NX500_NETX_MEM_INTRN_SRAM1_AREA 0x00008000U

/* --------------------------------------------------------------------- */
/* Register intram1_base */
/* => internal SRAM AHBL slave 1 start address */
/*    Area size: 32kB */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    Write accesses in this memory area: 0WS, byte accessable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_intram1_base          0x00000000U
#define Adr_NX500_sram1_ahbls1_intram1_base 0x00008000U
#define Adr_NX500_intram1_base              0x00008000U

/* --------------------------------------------------------------------- */
/* Register intram1_end */
/* => internal SRAM AHBL slave 1 end address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_intram1_end          0x00007FFCU
#define Adr_NX500_sram1_ahbls1_intram1_end 0x0000FFFCU
#define Adr_NX500_intram1_end              0x0000FFFCU


/* ===================================================================== */

/* Area of sram2_ahbls2 */

/* ===================================================================== */

#define Addr_NX500_sram2_ahbls2         0x00010000U
#define NX500_NETX_MEM_INTRN_SRAM2_AREA 0x00010000U

/* --------------------------------------------------------------------- */
/* Register intram2_base */
/* => internal SRAM AHBL slave 2 start address */
/*    Area size: 32kB */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    Write accesses in this memory area: 0WS, byte accessable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_intram2_base          0x00000000U
#define Adr_NX500_sram2_ahbls2_intram2_base 0x00010000U
#define Adr_NX500_intram2_base              0x00010000U

/* --------------------------------------------------------------------- */
/* Register intram2_end */
/* => internal SRAM AHBL slave 2 end address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_intram2_end          0x00007FFCU
#define Adr_NX500_sram2_ahbls2_intram2_end 0x00017FFCU
#define Adr_NX500_intram2_end              0x00017FFCU


/* ===================================================================== */

/* Area of sram3_ahbls3 */

/* ===================================================================== */

#define Addr_NX500_sram3_ahbls3         0x00018000U
#define NX500_NETX_MEM_INTRN_SRAM3_AREA 0x00018000U

/* --------------------------------------------------------------------- */
/* Register intram3_base */
/* => internal SRAM AHBL slave 3 start address */
/*    Area size: 32kB */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    Write accesses in this memory area: 0WS, byte accessable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_intram3_base          0x00000000U
#define Adr_NX500_sram3_ahbls3_intram3_base 0x00018000U
#define Adr_NX500_intram3_base              0x00018000U

/* --------------------------------------------------------------------- */
/* Register intram3_end */
/* => internal SRAM AHBL slave 3 end address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_intram3_end          0x00007FFCU
#define Adr_NX500_sram3_ahbls3_intram3_end 0x0001FFFCU
#define Adr_NX500_intram3_end              0x0001FFFCU


/* ===================================================================== */

/* Area of intlogic_ahbls5 */

/* ===================================================================== */

#define Addr_NX500_intlogic_ahbls5 0x00100000U

/* ===================================================================== */

/* Area of asic_ctrl */

/* ===================================================================== */

#define Addr_NX500_asic_ctrl 0x00100000U
#define NX500_NETX_CTRL_AREA 0x00100000U

/* --------------------------------------------------------------------- */
/* Register io_status */
/* => Bondout Out Option Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_io_status       0x00000000U
#define Adr_NX500_asic_ctrl_io_status 0x00100000U
#define Adr_NX500_io_status           0x00100000U

#define MSK_NX500_io_status_bond_option0 0x00000007U
#define SRT_NX500_io_status_bond_option0 0
#define MSK_NX500_io_status_quick_count  0x00000008U
#define SRT_NX500_io_status_quick_count  3
#define MSK_NX500_io_status_arm100       0x00000010U
#define SRT_NX500_io_status_arm100       4
#define MSK_NX500_io_status_pll_bypass   0x00000020U
#define SRT_NX500_io_status_pll_bypass   5

enum {
	BFW_NX500_io_status_bond_option0 = 3,  /* [2:0] */
	BFW_NX500_io_status_quick_count  = 1,  /* [3] */
	BFW_NX500_io_status_arm100       = 1,  /* [4] */
	BFW_NX500_io_status_pll_bypass   = 1,  /* [5] */
	BFW_NX500_io_status_reserved1    = 26  /* [31:6] */
};

typedef struct NX500_IO_STATUS_BIT_Ttag {
	unsigned int bond_option0 : BFW_NX500_io_status_bond_option0; /* Value of Bond-Option Pin2 - Pin0                                                        */
	                                                              /* BO2 BO1 BO0  Function                                                                   */
	unsigned int quick_count  : BFW_NX500_io_status_quick_count;  /* Testmode 'quick_count' is activated by external pins                                    */
	                                                              /* -> diverse internal counters count faster (RTC-clock-divider, PLL-stby-controller,...)  */
	unsigned int arm100       : BFW_NX500_io_status_arm100;       /* Testmode 'arm100' is activated by external pins                                         */
	                                                              /* -> ARM926 runs on system frequency (100MHz) instead of double system frequency (200MHz) */
	unsigned int pll_bypass   : BFW_NX500_io_status_pll_bypass;   /* Testmode 'pll_bypass' is activated by external pins                                     */
	                                                              /* -> 400MHz-PLL is bypassed, PLL output is directly connected to XTALIN                   */
	unsigned int reserved1    : BFW_NX500_io_status_reserved1;    /* reserved                                                                                */
} NX500_IO_STATUS_BIT_T;

typedef union {
	unsigned int          val;
	NX500_IO_STATUS_BIT_T bf;
} NX500_IO_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register io_config */
/* => IO Config Register: */
/*    Selects of output pin multiplexing. */
/*    See Excel pinning sheet for details. */
/*    Selects can only be activated, if appropriate bit of io_config_mask is set. */
/*    Bits will be reset according to the io_config_mask-register register if a new mask is correctly written (netX locking algorithm). */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_io_config       0x00000004U
#define Adr_NX500_asic_ctrl_io_config 0x00100004U
#define Adr_NX500_io_config           0x00100004U
#define DFLT_VAL_NX500_io_config      0x00000000U

#define MSK_NX500_io_config_sel_lcd_bw            0x00000001U
#define SRT_NX500_io_config_sel_lcd_bw            0
#define DFLT_VAL_NX500_io_config_sel_lcd_bw       0x00000000U
#define MSK_NX500_io_config_sel_lcd_col           0x00000002U
#define SRT_NX500_io_config_sel_lcd_col           1
#define DFLT_VAL_NX500_io_config_sel_lcd_col      0x00000000U
#define MSK_NX500_io_config_sel_mii2              0x00000004U
#define SRT_NX500_io_config_sel_mii2              2
#define DFLT_VAL_NX500_io_config_sel_mii2         0x00000000U
#define MSK_NX500_io_config_sel_mii3              0x00000008U
#define SRT_NX500_io_config_sel_mii3              3
#define DFLT_VAL_NX500_io_config_sel_mii3         0x00000000U
#define MSK_NX500_io_config_sel_mii23             0x00000010U
#define SRT_NX500_io_config_sel_mii23             4
#define DFLT_VAL_NX500_io_config_sel_mii23        0x00000000U
#define MSK_NX500_io_config_sel_mii3pwm           0x00000020U
#define SRT_NX500_io_config_sel_mii3pwm           5
#define DFLT_VAL_NX500_io_config_sel_mii3pwm      0x00000000U
#define MSK_NX500_io_config_sel_fo0               0x00000040U
#define SRT_NX500_io_config_sel_fo0               6
#define DFLT_VAL_NX500_io_config_sel_fo0          0x00000000U
#define MSK_NX500_io_config_sel_fo1               0x00000080U
#define SRT_NX500_io_config_sel_fo1               7
#define DFLT_VAL_NX500_io_config_sel_fo1          0x00000000U
#define MSK_NX500_io_config_sel_f0_pwm3           0x00000100U
#define SRT_NX500_io_config_sel_f0_pwm3           8
#define DFLT_VAL_NX500_io_config_sel_f0_pwm3      0x00000000U
#define MSK_NX500_io_config_sel_f0_failure3       0x00000200U
#define SRT_NX500_io_config_sel_f0_failure3       9
#define DFLT_VAL_NX500_io_config_sel_f0_failure3  0x00000000U
#define MSK_NX500_io_config_sel_f1_pwm3           0x00000400U
#define SRT_NX500_io_config_sel_f1_pwm3           10
#define DFLT_VAL_NX500_io_config_sel_f1_pwm3      0x00000000U
#define MSK_NX500_io_config_sel_f1_rpwm3          0x00000800U
#define SRT_NX500_io_config_sel_f1_rpwm3          11
#define DFLT_VAL_NX500_io_config_sel_f1_rpwm3     0x00000000U
#define MSK_NX500_io_config_sel_f2_failure3       0x00001000U
#define SRT_NX500_io_config_sel_f2_failure3       12
#define DFLT_VAL_NX500_io_config_sel_f2_failure3  0x00000000U
#define MSK_NX500_io_config_sel_f2_rpwm3          0x00002000U
#define SRT_NX500_io_config_sel_f2_rpwm3          13
#define DFLT_VAL_NX500_io_config_sel_f2_rpwm3     0x00000000U
#define MSK_NX500_io_config_sel_f3_pwm3           0x00004000U
#define SRT_NX500_io_config_sel_f3_pwm3           14
#define DFLT_VAL_NX500_io_config_sel_f3_pwm3      0x00000000U
#define MSK_NX500_io_config_sel_e_pwm2            0x00008000U
#define SRT_NX500_io_config_sel_e_pwm2            15
#define DFLT_VAL_NX500_io_config_sel_e_pwm2       0x00000000U
#define MSK_NX500_io_config_sel_e_failure2        0x00010000U
#define SRT_NX500_io_config_sel_e_failure2        16
#define DFLT_VAL_NX500_io_config_sel_e_failure2   0x00000000U
#define MSK_NX500_io_config_sel_e_rpwm2           0x00020000U
#define SRT_NX500_io_config_sel_e_rpwm2           17
#define DFLT_VAL_NX500_io_config_sel_e_rpwm2      0x00000000U
#define MSK_NX500_io_config_sel_enc0              0x00040000U
#define SRT_NX500_io_config_sel_enc0              18
#define DFLT_VAL_NX500_io_config_sel_enc0         0x00000000U
#define MSK_NX500_io_config_sel_enc1              0x00080000U
#define SRT_NX500_io_config_sel_enc1              19
#define DFLT_VAL_NX500_io_config_sel_enc1         0x00000000U
#define MSK_NX500_io_config_sel_mp                0x00100000U
#define SRT_NX500_io_config_sel_mp                20
#define DFLT_VAL_NX500_io_config_sel_mp           0x00000000U
#define MSK_NX500_io_config_sel_led_mii2          0x00200000U
#define SRT_NX500_io_config_sel_led_mii2          21
#define DFLT_VAL_NX500_io_config_sel_led_mii2     0x00000000U
#define MSK_NX500_io_config_sel_led_mii3          0x00400000U
#define SRT_NX500_io_config_sel_led_mii3          22
#define DFLT_VAL_NX500_io_config_sel_led_mii3     0x00000000U
#define MSK_NX500_io_config_sel_etm               0x00800000U
#define SRT_NX500_io_config_sel_etm               23
#define DFLT_VAL_NX500_io_config_sel_etm          0x00000000U
#define MSK_NX500_io_config_sel_wdg               0x01000000U
#define SRT_NX500_io_config_sel_wdg               24
#define DFLT_VAL_NX500_io_config_sel_wdg          0x00000000U
#define MSK_NX500_io_config_sel_f0_pwm3_eclk      0x02000000U
#define SRT_NX500_io_config_sel_f0_pwm3_eclk      25
#define DFLT_VAL_NX500_io_config_sel_f0_pwm3_eclk 0x00000000U
#define MSK_NX500_io_config_sel_f1_pwm3_eclk      0x04000000U
#define SRT_NX500_io_config_sel_f1_pwm3_eclk      26
#define DFLT_VAL_NX500_io_config_sel_f1_pwm3_eclk 0x00000000U
#define MSK_NX500_io_config_sel_f3_pwm3_eclk      0x08000000U
#define SRT_NX500_io_config_sel_f3_pwm3_eclk      27
#define DFLT_VAL_NX500_io_config_sel_f3_pwm3_eclk 0x00000000U
#define MSK_NX500_io_config_sel_e_pwm2_eclk       0x10000000U
#define SRT_NX500_io_config_sel_e_pwm2_eclk       28
#define DFLT_VAL_NX500_io_config_sel_e_pwm2_eclk  0x00000000U
#define MSK_NX500_io_config_if_select_n           0x80000000U
#define SRT_NX500_io_config_if_select_n           31
#define DFLT_VAL_NX500_io_config_if_select_n      0x00000000U

enum {
	BFW_NX500_io_config_sel_lcd_bw       = 1, /* [0] */
	BFW_NX500_io_config_sel_lcd_col      = 1, /* [1] */
	BFW_NX500_io_config_sel_mii2         = 1, /* [2] */
	BFW_NX500_io_config_sel_mii3         = 1, /* [3] */
	BFW_NX500_io_config_sel_mii23        = 1, /* [4] */
	BFW_NX500_io_config_sel_mii3pwm      = 1, /* [5] */
	BFW_NX500_io_config_sel_fo0          = 1, /* [6] */
	BFW_NX500_io_config_sel_fo1          = 1, /* [7] */
	BFW_NX500_io_config_sel_f0_pwm3      = 1, /* [8] */
	BFW_NX500_io_config_sel_f0_failure3  = 1, /* [9] */
	BFW_NX500_io_config_sel_f1_pwm3      = 1, /* [10] */
	BFW_NX500_io_config_sel_f1_rpwm3     = 1, /* [11] */
	BFW_NX500_io_config_sel_f2_failure3  = 1, /* [12] */
	BFW_NX500_io_config_sel_f2_rpwm3     = 1, /* [13] */
	BFW_NX500_io_config_sel_f3_pwm3      = 1, /* [14] */
	BFW_NX500_io_config_sel_e_pwm2       = 1, /* [15] */
	BFW_NX500_io_config_sel_e_failure2   = 1, /* [16] */
	BFW_NX500_io_config_sel_e_rpwm2      = 1, /* [17] */
	BFW_NX500_io_config_sel_enc0         = 1, /* [18] */
	BFW_NX500_io_config_sel_enc1         = 1, /* [19] */
	BFW_NX500_io_config_sel_mp           = 1, /* [20] */
	BFW_NX500_io_config_sel_led_mii2     = 1, /* [21] */
	BFW_NX500_io_config_sel_led_mii3     = 1, /* [22] */
	BFW_NX500_io_config_sel_etm          = 1, /* [23] */
	BFW_NX500_io_config_sel_wdg          = 1, /* [24] */
	BFW_NX500_io_config_sel_f0_pwm3_eclk = 1, /* [25] */
	BFW_NX500_io_config_sel_f1_pwm3_eclk = 1, /* [26] */
	BFW_NX500_io_config_sel_f3_pwm3_eclk = 1, /* [27] */
	BFW_NX500_io_config_sel_e_pwm2_eclk  = 1, /* [28] */
	BFW_NX500_io_config_reserved1        = 2, /* [30:29] */
	BFW_NX500_io_config_if_select_n      = 1  /* [31] */
};

typedef struct NX500_IO_CONFIG_BIT_Ttag {
	unsigned int sel_lcd_bw       : BFW_NX500_io_config_sel_lcd_bw;       /* select outputs for Black and White LCD Display                            */
	unsigned int sel_lcd_col      : BFW_NX500_io_config_sel_lcd_col;      /* select outputs for Couloured LCD Display                                  */
	unsigned int sel_mii2         : BFW_NX500_io_config_sel_mii2;         /* select outputs for MII interface of xMAC2                                 */
	unsigned int sel_mii3         : BFW_NX500_io_config_sel_mii3;         /* select outputs for MII interface of xMAC2                                 */
	unsigned int sel_mii23        : BFW_NX500_io_config_sel_mii23;        /* select outputs for MDIO signals                                           */
	unsigned int sel_mii3pwm      : BFW_NX500_io_config_sel_mii3pwm;      /* select outputs for PWM output of xMAC3                                    */
	unsigned int sel_fo0          : BFW_NX500_io_config_sel_fo0;          /* select Fiber Optics of PHY0:                                              */
	                                                                      /* 1: use Fiber Optics of PHY0                                               */
	unsigned int sel_fo1          : BFW_NX500_io_config_sel_fo1;          /* select Fiber Optics of PHY1:                                              */
	                                                                      /* 1: use Fiber Optics of PHY1                                               */
	unsigned int sel_f0_pwm3      : BFW_NX500_io_config_sel_f0_pwm3;      /* select outputs for PWM-siganls at Fieldbus0 pads                          */
	unsigned int sel_f0_failure3  : BFW_NX500_io_config_sel_f0_failure3;  /* select output  for PWM-failure at Fieldbus0 pads                          */
	unsigned int sel_f1_pwm3      : BFW_NX500_io_config_sel_f1_pwm3;      /* select outputs for PWM-signals at Fieldbus1 pads                          */
	unsigned int sel_f1_rpwm3     : BFW_NX500_io_config_sel_f1_rpwm3;     /* select output  for rpwm signal at Fieldbus1 pads                          */
	unsigned int sel_f2_failure3  : BFW_NX500_io_config_sel_f2_failure3;  /* select output  for PWM-failure at Fieldbus2 pads                          */
	unsigned int sel_f2_rpwm3     : BFW_NX500_io_config_sel_f2_rpwm3;     /* select output  for rpwm signal at Fieldbus2 pads                          */
	unsigned int sel_f3_pwm3      : BFW_NX500_io_config_sel_f3_pwm3;      /* select outputs for PWM-signals at Fieldbus3 pads                          */
	unsigned int sel_e_pwm2       : BFW_NX500_io_config_sel_e_pwm2;       /* select outputs for PWM-signals at PIO pads                                */
	unsigned int sel_e_failure2   : BFW_NX500_io_config_sel_e_failure2;   /* select output  for PWM-failure at PIO pads                                */
	unsigned int sel_e_rpwm2      : BFW_NX500_io_config_sel_e_rpwm2;      /* select output  for rpwm signal at PIO pads                                */
	unsigned int sel_enc0         : BFW_NX500_io_config_sel_enc0;         /* select outputs for enc0                                                   */
	unsigned int sel_enc1         : BFW_NX500_io_config_sel_enc1;         /* select outputs for enc1                                                   */
	unsigned int sel_mp           : BFW_NX500_io_config_sel_mp;           /* select outputs for mp                                                     */
	unsigned int sel_led_mii2     : BFW_NX500_io_config_sel_led_mii2;     /* select inputs for leds of mii2                                            */
	unsigned int sel_led_mii3     : BFW_NX500_io_config_sel_led_mii3;     /* select inputs for leds of mii3                                            */
	unsigned int sel_etm          : BFW_NX500_io_config_sel_etm;          /* select pins for ETM9 of ARM926                                            */
	unsigned int sel_wdg          : BFW_NX500_io_config_sel_wdg;          /* select pins for clk watchdoq / system watchdog                            */
	unsigned int sel_f0_pwm3_eclk : BFW_NX500_io_config_sel_f0_pwm3_eclk; /* select outputs for PWM-siganls clocked by xmac3_eclk_in at Fieldbus0 pads */
	                                                                      /* usually used for xmac3 fiber-optic mode with low clock jitter             */
	unsigned int sel_f1_pwm3_eclk : BFW_NX500_io_config_sel_f1_pwm3_eclk; /* select outputs for PWM-signals clocked by xmac3_eclk_in at Fieldbus1 pads */
	                                                                      /* usually used for xmac3 fiber-optic mode with low clock jitter             */
	unsigned int sel_f3_pwm3_eclk : BFW_NX500_io_config_sel_f3_pwm3_eclk; /* select outputs for PWM-signals clocked by xmac3_eclk_in at Fieldbus3 pads */
	                                                                      /* usually used for xmac3 fiber-optic mode with low clock jitter             */
	unsigned int sel_e_pwm2_eclk  : BFW_NX500_io_config_sel_e_pwm2_eclk;  /* select outputs for PWM-signals clocked by xmac2_eclk_in at PIO pads       */
	                                                                      /* usually used for xmac2 fiber-optic mode with low clock jitter             */
	unsigned int reserved1        : BFW_NX500_io_config_reserved1;        /* reserved                                                                  */
	unsigned int if_select_n      : BFW_NX500_io_config_if_select_n;      /* inverted HIF interace-select signal:                                      */
	                                                                      /* 1: PCI-Mode                                                               */
} NX500_IO_CONFIG_BIT_T;

typedef union {
	unsigned int          val;
	NX500_IO_CONFIG_BIT_T bf;
} NX500_IO_CONFIG_T;

/* --------------------------------------------------------------------- */
/* Register io_config_mask */
/* => IO Config Mask Register: */
/*    The IO_CFG_MASK register might be used to lock special IO configurations for restricted netX devices. \ */
/*    Any bit of the IO_CFG register can only be set, if the corresponding mask bit in the IO_CFG_MSK register is set either. */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    The io_config-register will change according to this register if a new mask is correctly written (netX locking algorithm). */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_io_config_mask       0x00000008U
#define Adr_NX500_asic_ctrl_io_config_mask 0x00100008U
#define Adr_NX500_io_config_mask           0x00100008U
#define DFLT_VAL_NX500_io_config_mask      0x9fffffffU

#define MSK_NX500_io_config_mask_sel_lcd_bw            0x00000001U
#define SRT_NX500_io_config_mask_sel_lcd_bw            0
#define DFLT_VAL_NX500_io_config_mask_sel_lcd_bw       0x00000001U
#define MSK_NX500_io_config_mask_sel_lcd_col           0x00000002U
#define SRT_NX500_io_config_mask_sel_lcd_col           1
#define DFLT_VAL_NX500_io_config_mask_sel_lcd_col      0x00000002U
#define MSK_NX500_io_config_mask_sel_mii2              0x00000004U
#define SRT_NX500_io_config_mask_sel_mii2              2
#define DFLT_VAL_NX500_io_config_mask_sel_mii2         0x00000004U
#define MSK_NX500_io_config_mask_sel_mii3              0x00000008U
#define SRT_NX500_io_config_mask_sel_mii3              3
#define DFLT_VAL_NX500_io_config_mask_sel_mii3         0x00000008U
#define MSK_NX500_io_config_mask_sel_mii23             0x00000010U
#define SRT_NX500_io_config_mask_sel_mii23             4
#define DFLT_VAL_NX500_io_config_mask_sel_mii23        0x00000010U
#define MSK_NX500_io_config_mask_sel_mii3pwm           0x00000020U
#define SRT_NX500_io_config_mask_sel_mii3pwm           5
#define DFLT_VAL_NX500_io_config_mask_sel_mii3pwm      0x00000020U
#define MSK_NX500_io_config_mask_sel_fo0               0x00000040U
#define SRT_NX500_io_config_mask_sel_fo0               6
#define DFLT_VAL_NX500_io_config_mask_sel_fo0          0x00000040U
#define MSK_NX500_io_config_mask_sel_fo1               0x00000080U
#define SRT_NX500_io_config_mask_sel_fo1               7
#define DFLT_VAL_NX500_io_config_mask_sel_fo1          0x00000080U
#define MSK_NX500_io_config_mask_sel_f0_pwm3           0x00000100U
#define SRT_NX500_io_config_mask_sel_f0_pwm3           8
#define DFLT_VAL_NX500_io_config_mask_sel_f0_pwm3      0x00000100U
#define MSK_NX500_io_config_mask_sel_f0_failure3       0x00000200U
#define SRT_NX500_io_config_mask_sel_f0_failure3       9
#define DFLT_VAL_NX500_io_config_mask_sel_f0_failure3  0x00000200U
#define MSK_NX500_io_config_mask_sel_f1_pwm3           0x00000400U
#define SRT_NX500_io_config_mask_sel_f1_pwm3           10
#define DFLT_VAL_NX500_io_config_mask_sel_f1_pwm3      0x00000400U
#define MSK_NX500_io_config_mask_sel_f1_rpwm3          0x00000800U
#define SRT_NX500_io_config_mask_sel_f1_rpwm3          11
#define DFLT_VAL_NX500_io_config_mask_sel_f1_rpwm3     0x00000800U
#define MSK_NX500_io_config_mask_sel_f2_failure3       0x00001000U
#define SRT_NX500_io_config_mask_sel_f2_failure3       12
#define DFLT_VAL_NX500_io_config_mask_sel_f2_failure3  0x00001000U
#define MSK_NX500_io_config_mask_sel_f2_rpwm3          0x00002000U
#define SRT_NX500_io_config_mask_sel_f2_rpwm3          13
#define DFLT_VAL_NX500_io_config_mask_sel_f2_rpwm3     0x00002000U
#define MSK_NX500_io_config_mask_sel_f3_pwm3           0x00004000U
#define SRT_NX500_io_config_mask_sel_f3_pwm3           14
#define DFLT_VAL_NX500_io_config_mask_sel_f3_pwm3      0x00004000U
#define MSK_NX500_io_config_mask_sel_e_pwm2            0x00008000U
#define SRT_NX500_io_config_mask_sel_e_pwm2            15
#define DFLT_VAL_NX500_io_config_mask_sel_e_pwm2       0x00008000U
#define MSK_NX500_io_config_mask_sel_e_failure2        0x00010000U
#define SRT_NX500_io_config_mask_sel_e_failure2        16
#define DFLT_VAL_NX500_io_config_mask_sel_e_failure2   0x00010000U
#define MSK_NX500_io_config_mask_sel_e_rpwm2           0x00020000U
#define SRT_NX500_io_config_mask_sel_e_rpwm2           17
#define DFLT_VAL_NX500_io_config_mask_sel_e_rpwm2      0x00020000U
#define MSK_NX500_io_config_mask_sel_enc0              0x00040000U
#define SRT_NX500_io_config_mask_sel_enc0              18
#define DFLT_VAL_NX500_io_config_mask_sel_enc0         0x00040000U
#define MSK_NX500_io_config_mask_sel_enc1              0x00080000U
#define SRT_NX500_io_config_mask_sel_enc1              19
#define DFLT_VAL_NX500_io_config_mask_sel_enc1         0x00080000U
#define MSK_NX500_io_config_mask_sel_mp                0x00100000U
#define SRT_NX500_io_config_mask_sel_mp                20
#define DFLT_VAL_NX500_io_config_mask_sel_mp           0x00100000U
#define MSK_NX500_io_config_mask_sel_led_mii2          0x00200000U
#define SRT_NX500_io_config_mask_sel_led_mii2          21
#define DFLT_VAL_NX500_io_config_mask_sel_led_mii2     0x00200000U
#define MSK_NX500_io_config_mask_sel_led_mii3          0x00400000U
#define SRT_NX500_io_config_mask_sel_led_mii3          22
#define DFLT_VAL_NX500_io_config_mask_sel_led_mii3     0x00400000U
#define MSK_NX500_io_config_mask_sel_etm               0x00800000U
#define SRT_NX500_io_config_mask_sel_etm               23
#define DFLT_VAL_NX500_io_config_mask_sel_etm          0x00800000U
#define MSK_NX500_io_config_mask_sel_wdg               0x01000000U
#define SRT_NX500_io_config_mask_sel_wdg               24
#define DFLT_VAL_NX500_io_config_mask_sel_wdg          0x01000000U
#define MSK_NX500_io_config_mask_sel_f0_pwm3_eclk      0x02000000U
#define SRT_NX500_io_config_mask_sel_f0_pwm3_eclk      25
#define DFLT_VAL_NX500_io_config_mask_sel_f0_pwm3_eclk 0x02000000U
#define MSK_NX500_io_config_mask_sel_f1_pwm3_eclk      0x04000000U
#define SRT_NX500_io_config_mask_sel_f1_pwm3_eclk      26
#define DFLT_VAL_NX500_io_config_mask_sel_f1_pwm3_eclk 0x04000000U
#define MSK_NX500_io_config_mask_sel_f3_pwm3_eclk      0x08000000U
#define SRT_NX500_io_config_mask_sel_f3_pwm3_eclk      27
#define DFLT_VAL_NX500_io_config_mask_sel_f3_pwm3_eclk 0x08000000U
#define MSK_NX500_io_config_mask_sel_e_pwm2_eclk       0x10000000U
#define SRT_NX500_io_config_mask_sel_e_pwm2_eclk       28
#define DFLT_VAL_NX500_io_config_mask_sel_e_pwm2_eclk  0x10000000U
#define MSK_NX500_io_config_mask_if_select_n           0x80000000U
#define SRT_NX500_io_config_mask_if_select_n           31
#define DFLT_VAL_NX500_io_config_mask_if_select_n      0x80000000U

enum {
	BFW_NX500_io_config_mask_sel_lcd_bw       = 1, /* [0] */
	BFW_NX500_io_config_mask_sel_lcd_col      = 1, /* [1] */
	BFW_NX500_io_config_mask_sel_mii2         = 1, /* [2] */
	BFW_NX500_io_config_mask_sel_mii3         = 1, /* [3] */
	BFW_NX500_io_config_mask_sel_mii23        = 1, /* [4] */
	BFW_NX500_io_config_mask_sel_mii3pwm      = 1, /* [5] */
	BFW_NX500_io_config_mask_sel_fo0          = 1, /* [6] */
	BFW_NX500_io_config_mask_sel_fo1          = 1, /* [7] */
	BFW_NX500_io_config_mask_sel_f0_pwm3      = 1, /* [8] */
	BFW_NX500_io_config_mask_sel_f0_failure3  = 1, /* [9] */
	BFW_NX500_io_config_mask_sel_f1_pwm3      = 1, /* [10] */
	BFW_NX500_io_config_mask_sel_f1_rpwm3     = 1, /* [11] */
	BFW_NX500_io_config_mask_sel_f2_failure3  = 1, /* [12] */
	BFW_NX500_io_config_mask_sel_f2_rpwm3     = 1, /* [13] */
	BFW_NX500_io_config_mask_sel_f3_pwm3      = 1, /* [14] */
	BFW_NX500_io_config_mask_sel_e_pwm2       = 1, /* [15] */
	BFW_NX500_io_config_mask_sel_e_failure2   = 1, /* [16] */
	BFW_NX500_io_config_mask_sel_e_rpwm2      = 1, /* [17] */
	BFW_NX500_io_config_mask_sel_enc0         = 1, /* [18] */
	BFW_NX500_io_config_mask_sel_enc1         = 1, /* [19] */
	BFW_NX500_io_config_mask_sel_mp           = 1, /* [20] */
	BFW_NX500_io_config_mask_sel_led_mii2     = 1, /* [21] */
	BFW_NX500_io_config_mask_sel_led_mii3     = 1, /* [22] */
	BFW_NX500_io_config_mask_sel_etm          = 1, /* [23] */
	BFW_NX500_io_config_mask_sel_wdg          = 1, /* [24] */
	BFW_NX500_io_config_mask_sel_f0_pwm3_eclk = 1, /* [25] */
	BFW_NX500_io_config_mask_sel_f1_pwm3_eclk = 1, /* [26] */
	BFW_NX500_io_config_mask_sel_f3_pwm3_eclk = 1, /* [27] */
	BFW_NX500_io_config_mask_sel_e_pwm2_eclk  = 1, /* [28] */
	BFW_NX500_io_config_mask_reserved1        = 2, /* [30:29] */
	BFW_NX500_io_config_mask_if_select_n      = 1  /* [31] */
};

typedef struct NX500_IO_CONFIG_MASK_BIT_Ttag {
	unsigned int sel_lcd_bw       : BFW_NX500_io_config_mask_sel_lcd_bw;       /* mask of select outputs for Black and White LCD Display                            */
	unsigned int sel_lcd_col      : BFW_NX500_io_config_mask_sel_lcd_col;      /* mask of select outputs for Couloured LCD Display                                  */
	unsigned int sel_mii2         : BFW_NX500_io_config_mask_sel_mii2;         /* mask of select outputs for MII interface of xMAC2                                 */
	unsigned int sel_mii3         : BFW_NX500_io_config_mask_sel_mii3;         /* mask of select outputs for MII interface of xMAC2                                 */
	unsigned int sel_mii23        : BFW_NX500_io_config_mask_sel_mii23;        /* mask of select outputs for MDIO signals                                           */
	unsigned int sel_mii3pwm      : BFW_NX500_io_config_mask_sel_mii3pwm;      /* mask of select outputs for PWM output of xMAC3                                    */
	unsigned int sel_fo0          : BFW_NX500_io_config_mask_sel_fo0;          /* mask of select outputs for Fiber Optics of Phy0                                   */
	unsigned int sel_fo1          : BFW_NX500_io_config_mask_sel_fo1;          /* mask of select outputs for Fiber Optics of Phy1                                   */
	unsigned int sel_f0_pwm3      : BFW_NX500_io_config_mask_sel_f0_pwm3;      /* mask of select outputs for PWM-siganls at Fieldbus0 pads                          */
	unsigned int sel_f0_failure3  : BFW_NX500_io_config_mask_sel_f0_failure3;  /* mask of select output  for PWM-failure at Fieldbus0 pads                          */
	unsigned int sel_f1_pwm3      : BFW_NX500_io_config_mask_sel_f1_pwm3;      /* mask of select outputs for PWM-signals at Fieldbus1 pads                          */
	unsigned int sel_f1_rpwm3     : BFW_NX500_io_config_mask_sel_f1_rpwm3;     /* mask of select output  for rpwm signal at Fieldbus1 pads                          */
	unsigned int sel_f2_failure3  : BFW_NX500_io_config_mask_sel_f2_failure3;  /* mask of select output  for PWM-failure at Fieldbus2 pads                          */
	unsigned int sel_f2_rpwm3     : BFW_NX500_io_config_mask_sel_f2_rpwm3;     /* mask of select output  for rpwm signal at Fieldbus2 pads                          */
	unsigned int sel_f3_pwm3      : BFW_NX500_io_config_mask_sel_f3_pwm3;      /* mask of select outputs for PWM-signals at Fieldbus3 pads                          */
	unsigned int sel_e_pwm2       : BFW_NX500_io_config_mask_sel_e_pwm2;       /* mask of select outputs for PWM-signals at PIO pads                                */
	unsigned int sel_e_failure2   : BFW_NX500_io_config_mask_sel_e_failure2;   /* mask of select output  for PWM-failure at PIO pads                                */
	unsigned int sel_e_rpwm2      : BFW_NX500_io_config_mask_sel_e_rpwm2;      /* mask of select output  for rpwm signal at PIO pads                                */
	unsigned int sel_enc0         : BFW_NX500_io_config_mask_sel_enc0;         /* mask of select outputs for enc0                                                   */
	unsigned int sel_enc1         : BFW_NX500_io_config_mask_sel_enc1;         /* mask of select outputs for enc1                                                   */
	unsigned int sel_mp           : BFW_NX500_io_config_mask_sel_mp;           /* mask of select outputs for mp                                                     */
	unsigned int sel_led_mii2     : BFW_NX500_io_config_mask_sel_led_mii2;     /* mask of select inputs for leds of mii2                                            */
	unsigned int sel_led_mii3     : BFW_NX500_io_config_mask_sel_led_mii3;     /* mask of select inputs for leds of mii3                                            */
	unsigned int sel_etm          : BFW_NX500_io_config_mask_sel_etm;          /* mask of select pins for ETM9 of ARM926                                            */
	unsigned int sel_wdg          : BFW_NX500_io_config_mask_sel_wdg;          /* mask of select pins for clk watchdoq / system watchdog                            */
	unsigned int sel_f0_pwm3_eclk : BFW_NX500_io_config_mask_sel_f0_pwm3_eclk; /* mask of select outputs for PWM-siganls clocked by xmac3_eclk_in at Fieldbus0 pads */
	unsigned int sel_f1_pwm3_eclk : BFW_NX500_io_config_mask_sel_f1_pwm3_eclk; /* mask of select outputs for PWM-signals clocked by xmac3_eclk_in at Fieldbus1 pads */
	unsigned int sel_f3_pwm3_eclk : BFW_NX500_io_config_mask_sel_f3_pwm3_eclk; /* mask of select outputs for PWM-signals clocked by xmac3_eclk_in at Fieldbus3 pads */
	unsigned int sel_e_pwm2_eclk  : BFW_NX500_io_config_mask_sel_e_pwm2_eclk;  /* mask of select outputs for PWM-signals clocked by xmac2_eclk_in at PIO pads       */
	unsigned int reserved1        : BFW_NX500_io_config_mask_reserved1;        /* reserved                                                                          */
	unsigned int if_select_n      : BFW_NX500_io_config_mask_if_select_n;      /* mask of inverted HIF if-select signal:                                            */
} NX500_IO_CONFIG_MASK_BIT_T;

typedef union {
	unsigned int               val;
	NX500_IO_CONFIG_MASK_BIT_T bf;
} NX500_IO_CONFIG_MASK_T;

/* --------------------------------------------------------------------- */
/* Register reset_ctrl */
/* => Reset Control Register: */
/*    This register controls the reset functions of the netX chip and indicates the reset state. The reset state */
/*    shows which resets have occurred, allowing the firmware to detect which resets were active. In order to */
/*    determine the source of the last reset, the firmware should evaluate and reset these bits during its start */
/*    sequence. After a power on reset, the RESET_CTRL register is cleared completely. */
/*     */
/*    This register is NOT protected by the netX access key mechanism yet. To keep software compatible */
/*    for later netX versions, read-write-accesskey-procedure should be done before accessing this register anyhow as followed: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/*    It is recomended to dummy-read another ASIC_CTRL-register (e.g. io_status) to avoid this address area being unprotected after */
/*    read-write-accesskey-procedure was done for reset_ctrl-register. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_reset_ctrl       0x0000000CU
#define Adr_NX500_asic_ctrl_reset_ctrl 0x0010000CU
#define Adr_NX500_reset_ctrl           0x0010000CU
#define DFLT_VAL_NX500_reset_ctrl      0x00000000U

#define MSK_NX500_reset_ctrl_RES_IN                0x00000001U
#define SRT_NX500_reset_ctrl_RES_IN                0
#define DFLT_VAL_NX500_reset_ctrl_RES_IN           0x00000000U
#define MSK_NX500_reset_ctrl_RES_WDOG              0x00000002U
#define SRT_NX500_reset_ctrl_RES_WDOG              1
#define DFLT_VAL_NX500_reset_ctrl_RES_WDOG         0x00000000U
#define MSK_NX500_reset_ctrl_RES_HOST              0x00000004U
#define SRT_NX500_reset_ctrl_RES_HOST              2
#define DFLT_VAL_NX500_reset_ctrl_RES_HOST         0x00000000U
#define MSK_NX500_reset_ctrl_RES_FIRMWARE          0x00000008U
#define SRT_NX500_reset_ctrl_RES_FIRMWARE          3
#define DFLT_VAL_NX500_reset_ctrl_RES_FIRMWARE     0x00000000U
#define MSK_NX500_reset_ctrl_RES_XPEC0             0x00000010U
#define SRT_NX500_reset_ctrl_RES_XPEC0             4
#define DFLT_VAL_NX500_reset_ctrl_RES_XPEC0        0x00000000U
#define MSK_NX500_reset_ctrl_RES_XPEC1             0x00000020U
#define SRT_NX500_reset_ctrl_RES_XPEC1             5
#define DFLT_VAL_NX500_reset_ctrl_RES_XPEC1        0x00000000U
#define MSK_NX500_reset_ctrl_RES_XPEC2             0x00000040U
#define SRT_NX500_reset_ctrl_RES_XPEC2             6
#define DFLT_VAL_NX500_reset_ctrl_RES_XPEC2        0x00000000U
#define MSK_NX500_reset_ctrl_RES_XPEC3             0x00000080U
#define SRT_NX500_reset_ctrl_RES_XPEC3             7
#define DFLT_VAL_NX500_reset_ctrl_RES_XPEC3        0x00000000U
#define MSK_NX500_reset_ctrl_DIS_RES_XPEC0         0x00010000U
#define SRT_NX500_reset_ctrl_DIS_RES_XPEC0         16
#define DFLT_VAL_NX500_reset_ctrl_DIS_RES_XPEC0    0x00000000U
#define MSK_NX500_reset_ctrl_DIS_RES_XPEC1         0x00020000U
#define SRT_NX500_reset_ctrl_DIS_RES_XPEC1         17
#define DFLT_VAL_NX500_reset_ctrl_DIS_RES_XPEC1    0x00000000U
#define MSK_NX500_reset_ctrl_DIS_RES_XPEC2         0x00040000U
#define SRT_NX500_reset_ctrl_DIS_RES_XPEC2         18
#define DFLT_VAL_NX500_reset_ctrl_DIS_RES_XPEC2    0x00000000U
#define MSK_NX500_reset_ctrl_DIS_RES_XPEC3         0x00080000U
#define SRT_NX500_reset_ctrl_DIS_RES_XPEC3         19
#define DFLT_VAL_NX500_reset_ctrl_DIS_RES_XPEC3    0x00000000U
#define MSK_NX500_reset_ctrl_FIRMWARE_STATUS0      0x00100000U
#define SRT_NX500_reset_ctrl_FIRMWARE_STATUS0      20
#define DFLT_VAL_NX500_reset_ctrl_FIRMWARE_STATUS0 0x00000000U
#define MSK_NX500_reset_ctrl_FIRMWARE_STATUS1      0x00200000U
#define SRT_NX500_reset_ctrl_FIRMWARE_STATUS1      21
#define DFLT_VAL_NX500_reset_ctrl_FIRMWARE_STATUS1 0x00000000U
#define MSK_NX500_reset_ctrl_FIRMWARE_STATUS2      0x00400000U
#define SRT_NX500_reset_ctrl_FIRMWARE_STATUS2      22
#define DFLT_VAL_NX500_reset_ctrl_FIRMWARE_STATUS2 0x00000000U
#define MSK_NX500_reset_ctrl_FIRMWARE_STATUS3      0x00800000U
#define SRT_NX500_reset_ctrl_FIRMWARE_STATUS3      23
#define DFLT_VAL_NX500_reset_ctrl_FIRMWARE_STATUS3 0x00000000U
#define MSK_NX500_reset_ctrl_RES_REQ_FIRMWARE      0x01000000U
#define SRT_NX500_reset_ctrl_RES_REQ_FIRMWARE      24
#define DFLT_VAL_NX500_reset_ctrl_RES_REQ_FIRMWARE 0x00000000U
#define MSK_NX500_reset_ctrl_RES_REQ_OUT           0x02000000U
#define SRT_NX500_reset_ctrl_RES_REQ_OUT           25
#define DFLT_VAL_NX500_reset_ctrl_RES_REQ_OUT      0x00000000U
#define MSK_NX500_reset_ctrl_EN_RES_REQ_OUT        0x04000000U
#define SRT_NX500_reset_ctrl_EN_RES_REQ_OUT        26
#define DFLT_VAL_NX500_reset_ctrl_EN_RES_REQ_OUT   0x00000000U

enum {
	BFW_NX500_reset_ctrl_RES_IN           = 1, /* [0] */
	BFW_NX500_reset_ctrl_RES_WDOG         = 1, /* [1] */
	BFW_NX500_reset_ctrl_RES_HOST         = 1, /* [2] */
	BFW_NX500_reset_ctrl_RES_FIRMWARE     = 1, /* [3] */
	BFW_NX500_reset_ctrl_RES_XPEC0        = 1, /* [4] */
	BFW_NX500_reset_ctrl_RES_XPEC1        = 1, /* [5] */
	BFW_NX500_reset_ctrl_RES_XPEC2        = 1, /* [6] */
	BFW_NX500_reset_ctrl_RES_XPEC3        = 1, /* [7] */
	BFW_NX500_reset_ctrl_reserved1        = 8, /* [15:8] */
	BFW_NX500_reset_ctrl_DIS_RES_XPEC0    = 1, /* [16] */
	BFW_NX500_reset_ctrl_DIS_RES_XPEC1    = 1, /* [17] */
	BFW_NX500_reset_ctrl_DIS_RES_XPEC2    = 1, /* [18] */
	BFW_NX500_reset_ctrl_DIS_RES_XPEC3    = 1, /* [19] */
	BFW_NX500_reset_ctrl_FIRMWARE_STATUS0 = 1, /* [20] */
	BFW_NX500_reset_ctrl_FIRMWARE_STATUS1 = 1, /* [21] */
	BFW_NX500_reset_ctrl_FIRMWARE_STATUS2 = 1, /* [22] */
	BFW_NX500_reset_ctrl_FIRMWARE_STATUS3 = 1, /* [23] */
	BFW_NX500_reset_ctrl_RES_REQ_FIRMWARE = 1, /* [24] */
	BFW_NX500_reset_ctrl_RES_REQ_OUT      = 1, /* [25] */
	BFW_NX500_reset_ctrl_EN_RES_REQ_OUT   = 1, /* [26] */
	BFW_NX500_reset_ctrl_reserved2        = 5  /* [31:27] */
};

typedef struct NX500_RESET_CTRL_BIT_Ttag {
	unsigned int RES_IN           : BFW_NX500_reset_ctrl_RES_IN;           /* reset from external pin, after reading write back a "1" to clear the status bit                 */
	unsigned int RES_WDOG         : BFW_NX500_reset_ctrl_RES_WDOG;         /* reset from System WDG, after reading write back a "1" to clear the status bit                   */
	unsigned int RES_HOST         : BFW_NX500_reset_ctrl_RES_HOST;         /* reset from Hostinterface, after reading write back a "1" to clear the status bit                */
	unsigned int RES_FIRMWARE     : BFW_NX500_reset_ctrl_RES_FIRMWARE;     /* reset from FIRMWARE (software reset), after reading write back a "1" to clear the status bit    */
	unsigned int RES_XPEC0        : BFW_NX500_reset_ctrl_RES_XPEC0;        /* reset from RES_XPEC0, after reading write back a "1" to clear the status bit                    */
	unsigned int RES_XPEC1        : BFW_NX500_reset_ctrl_RES_XPEC1;        /* reset from RES_XPEC1, after reading write back a "1" to clear the status bit                    */
	unsigned int RES_XPEC2        : BFW_NX500_reset_ctrl_RES_XPEC2;        /* reset from RES_XPEC2, after reading write back a "1" to clear the status bit                    */
	unsigned int RES_XPEC3        : BFW_NX500_reset_ctrl_RES_XPEC3;        /* reset from RES_XPEC3, after reading write back a "1" to clear the status bit                    */
	unsigned int reserved1        : BFW_NX500_reset_ctrl_reserved1;        /* reserved                                                                                        */
	unsigned int DIS_RES_XPEC0    : BFW_NX500_reset_ctrl_DIS_RES_XPEC0;    /* reset from RES_XPEC0 is disabled (read only)                                                    */
	unsigned int DIS_RES_XPEC1    : BFW_NX500_reset_ctrl_DIS_RES_XPEC1;    /* reset from RES_XPEC1 is disabled (read only)                                                    */
	unsigned int DIS_RES_XPEC2    : BFW_NX500_reset_ctrl_DIS_RES_XPEC2;    /* reset from RES_XPEC2 is disabled (read only)                                                    */
	unsigned int DIS_RES_XPEC3    : BFW_NX500_reset_ctrl_DIS_RES_XPEC3;    /* reset from RES_XPEC3 is disabled (read only)                                                    */
	unsigned int FIRMWARE_STATUS0 : BFW_NX500_reset_ctrl_FIRMWARE_STATUS0; /* readable and writable bit to save the firmware status; only a PowerOn Reset will clear this bit */
	unsigned int FIRMWARE_STATUS1 : BFW_NX500_reset_ctrl_FIRMWARE_STATUS1; /* readable and writable bit to save the firmware status; only a PowerOn Reset will clear this bit */
	unsigned int FIRMWARE_STATUS2 : BFW_NX500_reset_ctrl_FIRMWARE_STATUS2; /* readable and writable bit to save the firmware status; only a PowerOn Reset will clear this bit */
	unsigned int FIRMWARE_STATUS3 : BFW_NX500_reset_ctrl_FIRMWARE_STATUS3; /* readable and writable bit to save the firmware status; only a PowerOn Reset will clear this bit */
	unsigned int RES_REQ_FIRMWARE : BFW_NX500_reset_ctrl_RES_REQ_FIRMWARE; /* (software reset) writing a "1" sets the reset request to reset the hole system (write only)     */
	unsigned int RES_REQ_OUT      : BFW_NX500_reset_ctrl_RES_REQ_OUT;      /* (software reset) programmable reset sets the reset on the external pin                          */
	unsigned int EN_RES_REQ_OUT   : BFW_NX500_reset_ctrl_EN_RES_REQ_OUT;   /* this bit enables the programmable reset                                                         */
	unsigned int reserved2        : BFW_NX500_reset_ctrl_reserved2;        /* reserved                                                                                        */
} NX500_RESET_CTRL_BIT_T;

typedef union {
	unsigned int           val;
	NX500_RESET_CTRL_BIT_T bf;
} NX500_RESET_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register phy_control */
/* => PHY Control Register: */
/*    This register contains all static connectors of the NEC Ethernet PHY. \ */
/*    Usually the PHY reads these values only during reset, which can be controlled by Bit31. \ */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/*    In total the programming sequence should be: */
/*     */
/*    a: read access key, write access key, write new value with bit phy_reset=1 */
/*    b: wait for proper reset of PHY(~100µs) */
/*    c: read access key, write access key, write new value with bit phy_reset=0 */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_phy_control       0x00000010U
#define Adr_NX500_asic_ctrl_phy_control 0x00100010U
#define Adr_NX500_phy_control           0x00100010U
#define DFLT_VAL_NX500_phy_control      0x4000c060U

#define MSK_NX500_phy_control_phy_address           0x0000000fU
#define SRT_NX500_phy_control_phy_address           0
#define DFLT_VAL_NX500_phy_control_phy_address      0x00000000U
#define MSK_NX500_phy_control_phy0_mode             0x00000070U
#define SRT_NX500_phy_control_phy0_mode             4
#define DFLT_VAL_NX500_phy_control_phy0_mode        0x00000060U
#define MSK_NX500_phy_control_phy0_fxmode           0x00000080U
#define SRT_NX500_phy_control_phy0_fxmode           7
#define DFLT_VAL_NX500_phy_control_phy0_fxmode      0x00000000U
#define MSK_NX500_phy_control_phy0_automdix         0x00000100U
#define SRT_NX500_phy_control_phy0_automdix         8
#define DFLT_VAL_NX500_phy_control_phy0_automdix    0x00000000U
#define MSK_NX500_phy_control_phy0_np_msg_code      0x00000e00U
#define SRT_NX500_phy_control_phy0_np_msg_code      9
#define DFLT_VAL_NX500_phy_control_phy0_np_msg_code 0x00000000U
#define MSK_NX500_phy_control_phy0_enable           0x00001000U
#define SRT_NX500_phy_control_phy0_enable           12
#define DFLT_VAL_NX500_phy_control_phy0_enable      0x00000000U
#define MSK_NX500_phy_control_phy1_mode             0x0000e000U
#define SRT_NX500_phy_control_phy1_mode             13
#define DFLT_VAL_NX500_phy_control_phy1_mode        0x0000c000U
#define MSK_NX500_phy_control_phy1_fxmode           0x00010000U
#define SRT_NX500_phy_control_phy1_fxmode           16
#define DFLT_VAL_NX500_phy_control_phy1_fxmode      0x00000000U
#define MSK_NX500_phy_control_phy1_automdix         0x00020000U
#define SRT_NX500_phy_control_phy1_automdix         17
#define DFLT_VAL_NX500_phy_control_phy1_automdix    0x00000000U
#define MSK_NX500_phy_control_phy1_np_msg_code      0x001c0000U
#define SRT_NX500_phy_control_phy1_np_msg_code      18
#define DFLT_VAL_NX500_phy_control_phy1_np_msg_code 0x00000000U
#define MSK_NX500_phy_control_phy1_enable           0x00200000U
#define SRT_NX500_phy_control_phy1_enable           21
#define DFLT_VAL_NX500_phy_control_phy1_enable      0x00000000U
#define MSK_NX500_phy_control_phy_sim_byp           0x40000000U
#define SRT_NX500_phy_control_phy_sim_byp           30
#define DFLT_VAL_NX500_phy_control_phy_sim_byp      0x40000000U
#define MSK_NX500_phy_control_phy_reset             0x80000000U
#define SRT_NX500_phy_control_phy_reset             31
#define DFLT_VAL_NX500_phy_control_phy_reset        0x00000000U

enum {
	BFW_NX500_phy_control_phy_address      = 4, /* [3:0] */
	BFW_NX500_phy_control_phy0_mode        = 3, /* [6:4] */
	BFW_NX500_phy_control_phy0_fxmode      = 1, /* [7] */
	BFW_NX500_phy_control_phy0_automdix    = 1, /* [8] */
	BFW_NX500_phy_control_phy0_np_msg_code = 3, /* [11:9] */
	BFW_NX500_phy_control_phy0_enable      = 1, /* [12] */
	BFW_NX500_phy_control_phy1_mode        = 3, /* [15:13] */
	BFW_NX500_phy_control_phy1_fxmode      = 1, /* [16] */
	BFW_NX500_phy_control_phy1_automdix    = 1, /* [17] */
	BFW_NX500_phy_control_phy1_np_msg_code = 3, /* [20:18] */
	BFW_NX500_phy_control_phy1_enable      = 1, /* [21] */
	BFW_NX500_phy_control_reserved1        = 8, /* [29:22] */
	BFW_NX500_phy_control_phy_sim_byp      = 1, /* [30] */
	BFW_NX500_phy_control_phy_reset        = 1  /* [31] */
};

typedef struct NX500_PHY_CONTROL_BIT_Ttag {
	unsigned int phy_address      : BFW_NX500_phy_control_phy_address;      /* Bits 4:1 of PHY mdio-address.                         */
	                                                                        /* Bit0 defines 1st or 2nd internal PHY                  */
	unsigned int phy0_mode        : BFW_NX500_phy_control_phy0_mode;        /* PHY0 Mode:                                            */
	                                                                        /* 000: 10BASE-T Half Duplex, Auto Negotiation disabled. */
	unsigned int phy0_fxmode      : BFW_NX500_phy_control_phy0_fxmode;      /* PHY0 100BASE-FX mode (phy_mode must be 01x)           */
	unsigned int phy0_automdix    : BFW_NX500_phy_control_phy0_automdix;    /* PHY0 Enables AutoMDIX state machine                   */
	unsigned int phy0_np_msg_code : BFW_NX500_phy_control_phy0_np_msg_code; /* PHY0 Next Page Message Code (auto negotiation)        */
	unsigned int phy0_enable      : BFW_NX500_phy_control_phy0_enable;      /* PHY0 enable                                           */
	unsigned int phy1_mode        : BFW_NX500_phy_control_phy1_mode;        /* PHY1 Mode:                                            */
	                                                                        /* 000: 10BASE-T Half Duplex, Auto Negotiation disabled. */
	unsigned int phy1_fxmode      : BFW_NX500_phy_control_phy1_fxmode;      /* PHY1 100BASE-FX mode (phy_mode must be 01x)           */
	unsigned int phy1_automdix    : BFW_NX500_phy_control_phy1_automdix;    /* PHY1 Enables AutoMDIX state machine                   */
	unsigned int phy1_np_msg_code : BFW_NX500_phy_control_phy1_np_msg_code; /* PHY1 Next Page Message Code (auto negotiation)        */
	unsigned int phy1_enable      : BFW_NX500_phy_control_phy1_enable;      /* PHY1 enable                                           */
	unsigned int reserved1        : BFW_NX500_phy_control_reserved1;        /* reserved                                              */
	unsigned int phy_sim_byp      : BFW_NX500_phy_control_phy_sim_byp;      /* PHY Power up Bypass (only used for simulation issues) */
	                                                                        /* 0: normal                                             */
	unsigned int phy_reset        : BFW_NX500_phy_control_phy_reset;        /* Hardware reset for PHY                                */
	                                                                        /* 1: reset                                              */
} NX500_PHY_CONTROL_BIT_T;

typedef union {
	unsigned int            val;
	NX500_PHY_CONTROL_BIT_T bf;
} NX500_PHY_CONTROL_T;

/* --------------------------------------------------------------------- */
/* Register armclk_rate_mul_add */
/* => Rate Multiplier Add Value of System Clock: */
/*    This register might be used to change internal system frequency (200MHz of ARM and 100MHz of system). */
/*    Be careful when changing this value, as proper netX functionality is only qualified for the default value. */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out Locking Access Key */
/*    2.: write back Locking Access Key */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_armclk_rate_mul_add       0x00000014U
#define Adr_NX500_asic_ctrl_armclk_rate_mul_add 0x00100014U
#define Adr_NX500_armclk_rate_mul_add           0x00100014U
#define DFLT_VAL_NX500_armclk_rate_mul_add      0x00000100U

#define MSK_NX500_armclk_rate_mul_add_armclk_rate_mul_add      0x000001ffU
#define SRT_NX500_armclk_rate_mul_add_armclk_rate_mul_add      0
#define DFLT_VAL_NX500_armclk_rate_mul_add_armclk_rate_mul_add 0x00000100U

enum {
	BFW_NX500_armclk_rate_mul_add_armclk_rate_mul_add = 9,  /* [8:0] */
	BFW_NX500_armclk_rate_mul_add_reserved1           = 23  /* [31:9] */
};

typedef struct NX500_ARMCLK_RATE_MUL_ADD_BIT_Ttag {
	unsigned int armclk_rate_mul_add : BFW_NX500_armclk_rate_mul_add_armclk_rate_mul_add; /* This value is added each clk400 cycle to armclk_rate_mul to generate armclk. */
	                                                                                      /* Change value according to formula:                                           */
	unsigned int reserved1           : BFW_NX500_armclk_rate_mul_add_reserved1;           /* reserved                                                                     */
} NX500_ARMCLK_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int                    val;
	NX500_ARMCLK_RATE_MUL_ADD_BIT_T bf;
} NX500_ARMCLK_RATE_MUL_ADD_T;

/* --------------------------------------------------------------------- */
/* Register usbclk_rate_mul_add */
/* => Rate Multiplier Add Value of USB clock: */
/*    This register might be used to change internal system frequency (200MHz of ARM and 100MHz of system). */
/*    Be careful when changing this value, as proper netX functionality is only qualified for the default value. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out Locking Access Key */
/*    2.: write back Locking Access Key */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_usbclk_rate_mul_add       0x00000018U
#define Adr_NX500_asic_ctrl_usbclk_rate_mul_add 0x00100018U
#define Adr_NX500_usbclk_rate_mul_add           0x00100018U
#define DFLT_VAL_NX500_usbclk_rate_mul_add      0x1eb851ecU

#define MSK_NX500_usbclk_rate_mul_add_unused                   0x0000ffffU
#define SRT_NX500_usbclk_rate_mul_add_unused                   0
#define DFLT_VAL_NX500_usbclk_rate_mul_add_unused              0x000051ecU
#define MSK_NX500_usbclk_rate_mul_add_usbclk_rate_mul_add      0xffff0000U
#define SRT_NX500_usbclk_rate_mul_add_usbclk_rate_mul_add      16
#define DFLT_VAL_NX500_usbclk_rate_mul_add_usbclk_rate_mul_add 0x1eb80000U

enum {
	BFW_NX500_usbclk_rate_mul_add_unused              = 16, /* [15:0] */
	BFW_NX500_usbclk_rate_mul_add_usbclk_rate_mul_add = 16  /* [31:16] */
};

typedef struct NX500_USBCLK_RATE_MUL_ADD_BIT_Ttag {
	unsigned int unused              : BFW_NX500_usbclk_rate_mul_add_unused;              /* unused                                                                       */
	unsigned int usbclk_rate_mul_add : BFW_NX500_usbclk_rate_mul_add_usbclk_rate_mul_add; /* This value is added each clk400 cycle to usbclk_rate_mul to generate usbclk. */
	                                                                                      /* Change value according to formula:                                           */
} NX500_USBCLK_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int                    val;
	NX500_USBCLK_RATE_MUL_ADD_BIT_T bf;
} NX500_USBCLK_RATE_MUL_ADD_T;

/* --------------------------------------------------------------------- */
/* Register adcclk_rate_mul_add */
/* => Rate Multiplier Add Value: */
/*    The ADC clock is derived from clk200 using a rate multiplier. */
/*    Changing this register is only possible by the following sequence: */
/*    1.: read out Locking Access Key */
/*    2.: write back Locking Access Key */
/*    3.: write desired value to this register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_adcclk_rate_mul_add       0x0000001CU
#define Adr_NX500_asic_ctrl_adcclk_rate_mul_add 0x0010001CU
#define Adr_NX500_adcclk_rate_mul_add           0x0010001CU
#define DFLT_VAL_NX500_adcclk_rate_mul_add      0x0a3d70a4U

#define MSK_NX500_adcclk_rate_mul_add_adcclk_rate_mul_add      0x7fffffffU
#define SRT_NX500_adcclk_rate_mul_add_adcclk_rate_mul_add      0
#define DFLT_VAL_NX500_adcclk_rate_mul_add_adcclk_rate_mul_add 0x0a3d70a4U

enum {
	BFW_NX500_adcclk_rate_mul_add_adcclk_rate_mul_add = 31, /* [30:0] */
	BFW_NX500_adcclk_rate_mul_add_reserved1           = 1   /* [31] */
};

typedef struct NX500_ADCCLK_RATE_MUL_ADD_BIT_Ttag {
	unsigned int adcclk_rate_mul_add : BFW_NX500_adcclk_rate_mul_add_adcclk_rate_mul_add; /* This value is added each clk200 cycle to adcclk_rate_mul to generate adcclk.        */
	                                                                                      /* Change value according to formula: adcclk_rate_mul_add = [freq in MHz] / 200 * 2^31 */
	unsigned int reserved1           : BFW_NX500_adcclk_rate_mul_add_reserved1;           /* reserved                                                                            */
} NX500_ADCCLK_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int                    val;
	NX500_ADCCLK_RATE_MUL_ADD_BIT_T bf;
} NX500_ADCCLK_RATE_MUL_ADD_T;

/* --------------------------------------------------------------------- */
/* Register phyclk_rate_mul_add */
/* => Not used in any version of netx. */
/*    netX integrated Ethernet PHYs work always on external 25MHz Xtal. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_phyclk_rate_mul_add       0x00000020U
#define Adr_NX500_asic_ctrl_phyclk_rate_mul_add 0x00100020U
#define Adr_NX500_phyclk_rate_mul_add           0x00100020U

/* --------------------------------------------------------------------- */
/* Register clock_enable */
/* => Global Clock Enable Register: */
/*    Use this registers to disable modules completely for power saving purposes. */
/*    Changes will only have effect if according bit in clock_enable_mask-register is set. \ */
/*    Bits will be reset according to the clock_enable_mask-register register, if a new mask is correctly written (netX locking algorithm). */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_clock_enable       0x00000024U
#define Adr_NX500_asic_ctrl_clock_enable 0x00100024U
#define Adr_NX500_clock_enable           0x00100024U
#define DFLT_VAL_NX500_clock_enable      0x000003ffU

#define MSK_NX500_clock_enable_xpec0      0x00000001U
#define SRT_NX500_clock_enable_xpec0      0
#define DFLT_VAL_NX500_clock_enable_xpec0 0x00000001U
#define MSK_NX500_clock_enable_xpec1      0x00000002U
#define SRT_NX500_clock_enable_xpec1      1
#define DFLT_VAL_NX500_clock_enable_xpec1 0x00000002U
#define MSK_NX500_clock_enable_xpec2      0x00000004U
#define SRT_NX500_clock_enable_xpec2      2
#define DFLT_VAL_NX500_clock_enable_xpec2 0x00000004U
#define MSK_NX500_clock_enable_xpec3      0x00000008U
#define SRT_NX500_clock_enable_xpec3      3
#define DFLT_VAL_NX500_clock_enable_xpec3 0x00000008U
#define MSK_NX500_clock_enable_xmac0      0x00000010U
#define SRT_NX500_clock_enable_xmac0      4
#define DFLT_VAL_NX500_clock_enable_xmac0 0x00000010U
#define MSK_NX500_clock_enable_xmac1      0x00000020U
#define SRT_NX500_clock_enable_xmac1      5
#define DFLT_VAL_NX500_clock_enable_xmac1 0x00000020U
#define MSK_NX500_clock_enable_xmac2      0x00000040U
#define SRT_NX500_clock_enable_xmac2      6
#define DFLT_VAL_NX500_clock_enable_xmac2 0x00000040U
#define MSK_NX500_clock_enable_xmac3      0x00000080U
#define SRT_NX500_clock_enable_xmac3      7
#define DFLT_VAL_NX500_clock_enable_xmac3 0x00000080U
#define MSK_NX500_clock_enable_hif        0x00000100U
#define SRT_NX500_clock_enable_hif        8
#define DFLT_VAL_NX500_clock_enable_hif   0x00000100U
#define MSK_NX500_clock_enable_lcd        0x00000200U
#define SRT_NX500_clock_enable_lcd        9
#define DFLT_VAL_NX500_clock_enable_lcd   0x00000200U

enum {
	BFW_NX500_clock_enable_xpec0     = 1,  /* [0] */
	BFW_NX500_clock_enable_xpec1     = 1,  /* [1] */
	BFW_NX500_clock_enable_xpec2     = 1,  /* [2] */
	BFW_NX500_clock_enable_xpec3     = 1,  /* [3] */
	BFW_NX500_clock_enable_xmac0     = 1,  /* [4] */
	BFW_NX500_clock_enable_xmac1     = 1,  /* [5] */
	BFW_NX500_clock_enable_xmac2     = 1,  /* [6] */
	BFW_NX500_clock_enable_xmac3     = 1,  /* [7] */
	BFW_NX500_clock_enable_hif       = 1,  /* [8] */
	BFW_NX500_clock_enable_lcd       = 1,  /* [9] */
	BFW_NX500_clock_enable_reserved1 = 22  /* [31:10] */
};

typedef struct NX500_CLOCK_ENABLE_BIT_Ttag {
	unsigned int xpec0     : BFW_NX500_clock_enable_xpec0;     /* enables clock for xPEC0    */
	unsigned int xpec1     : BFW_NX500_clock_enable_xpec1;     /* enables clock for xPEC1    */
	unsigned int xpec2     : BFW_NX500_clock_enable_xpec2;     /* enables clock for xPEC2    */
	unsigned int xpec3     : BFW_NX500_clock_enable_xpec3;     /* enables clock for xPEC3    */
	unsigned int xmac0     : BFW_NX500_clock_enable_xmac0;     /* enables clock for xMAC0    */
	unsigned int xmac1     : BFW_NX500_clock_enable_xmac1;     /* enables clock for xMAC1    */
	unsigned int xmac2     : BFW_NX500_clock_enable_xmac2;     /* enables clock for xMAC2    */
	unsigned int xmac3     : BFW_NX500_clock_enable_xmac3;     /* enables clock for xMAC3    */
	unsigned int hif       : BFW_NX500_clock_enable_hif;       /* enables clock for HIF      */
	unsigned int lcd       : BFW_NX500_clock_enable_lcd;       /* enables clock for LCD Ctrl */
	unsigned int reserved1 : BFW_NX500_clock_enable_reserved1; /* reserved                   */
} NX500_CLOCK_ENABLE_BIT_T;

typedef union {
	unsigned int             val;
	NX500_CLOCK_ENABLE_BIT_T bf;
} NX500_CLOCK_ENABLE_T;

/* --------------------------------------------------------------------- */
/* Register clock_enable_mask */
/* => Global Clock Enable Mask Register: */
/*    allows to disable modules for different netX-versions */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    The clock_enable-register will change according to this register if a new mask is correctly written (netX locking algorithm). */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_clock_enable_mask       0x00000028U
#define Adr_NX500_asic_ctrl_clock_enable_mask 0x00100028U
#define Adr_NX500_clock_enable_mask           0x00100028U
#define DFLT_VAL_NX500_clock_enable_mask      0x000003ffU

#define MSK_NX500_clock_enable_mask_xpec0      0x00000001U
#define SRT_NX500_clock_enable_mask_xpec0      0
#define DFLT_VAL_NX500_clock_enable_mask_xpec0 0x00000001U
#define MSK_NX500_clock_enable_mask_xpec1      0x00000002U
#define SRT_NX500_clock_enable_mask_xpec1      1
#define DFLT_VAL_NX500_clock_enable_mask_xpec1 0x00000002U
#define MSK_NX500_clock_enable_mask_xpec2      0x00000004U
#define SRT_NX500_clock_enable_mask_xpec2      2
#define DFLT_VAL_NX500_clock_enable_mask_xpec2 0x00000004U
#define MSK_NX500_clock_enable_mask_xpec3      0x00000008U
#define SRT_NX500_clock_enable_mask_xpec3      3
#define DFLT_VAL_NX500_clock_enable_mask_xpec3 0x00000008U
#define MSK_NX500_clock_enable_mask_xmac0      0x00000010U
#define SRT_NX500_clock_enable_mask_xmac0      4
#define DFLT_VAL_NX500_clock_enable_mask_xmac0 0x00000010U
#define MSK_NX500_clock_enable_mask_xmac1      0x00000020U
#define SRT_NX500_clock_enable_mask_xmac1      5
#define DFLT_VAL_NX500_clock_enable_mask_xmac1 0x00000020U
#define MSK_NX500_clock_enable_mask_xmac2      0x00000040U
#define SRT_NX500_clock_enable_mask_xmac2      6
#define DFLT_VAL_NX500_clock_enable_mask_xmac2 0x00000040U
#define MSK_NX500_clock_enable_mask_xmac3      0x00000080U
#define SRT_NX500_clock_enable_mask_xmac3      7
#define DFLT_VAL_NX500_clock_enable_mask_xmac3 0x00000080U
#define MSK_NX500_clock_enable_mask_hif        0x00000100U
#define SRT_NX500_clock_enable_mask_hif        8
#define DFLT_VAL_NX500_clock_enable_mask_hif   0x00000100U
#define MSK_NX500_clock_enable_mask_lcd        0x00000200U
#define SRT_NX500_clock_enable_mask_lcd        9
#define DFLT_VAL_NX500_clock_enable_mask_lcd   0x00000200U

enum {
	BFW_NX500_clock_enable_mask_xpec0     = 1,  /* [0] */
	BFW_NX500_clock_enable_mask_xpec1     = 1,  /* [1] */
	BFW_NX500_clock_enable_mask_xpec2     = 1,  /* [2] */
	BFW_NX500_clock_enable_mask_xpec3     = 1,  /* [3] */
	BFW_NX500_clock_enable_mask_xmac0     = 1,  /* [4] */
	BFW_NX500_clock_enable_mask_xmac1     = 1,  /* [5] */
	BFW_NX500_clock_enable_mask_xmac2     = 1,  /* [6] */
	BFW_NX500_clock_enable_mask_xmac3     = 1,  /* [7] */
	BFW_NX500_clock_enable_mask_hif       = 1,  /* [8] */
	BFW_NX500_clock_enable_mask_lcd       = 1,  /* [9] */
	BFW_NX500_clock_enable_mask_reserved1 = 22  /* [31:10] */
};

typedef struct NX500_CLOCK_ENABLE_MASK_BIT_Ttag {
	unsigned int xpec0     : BFW_NX500_clock_enable_mask_xpec0;     /* 0: xPEC0 is disabled  1: clock can be enabled/disabled by clock_enable-register for xPEC0       */
	unsigned int xpec1     : BFW_NX500_clock_enable_mask_xpec1;     /* 0: xPEC1 is disabled  1: clock can be enabled/disabled by clock_enable-register for xPEC1       */
	unsigned int xpec2     : BFW_NX500_clock_enable_mask_xpec2;     /* 0: xPEC2 is disabled  1: clock can be enabled/disabled by clock_enable-register for xPEC2       */
	unsigned int xpec3     : BFW_NX500_clock_enable_mask_xpec3;     /* 0: xPEC3 is disabled  1: clock can be enabled/disabled by clock_enable-register for xPEC3       */
	unsigned int xmac0     : BFW_NX500_clock_enable_mask_xmac0;     /* 0: xMAC0 is disabled  1: clock can be enabled/disabled by clock_enable-register for xMAC0       */
	unsigned int xmac1     : BFW_NX500_clock_enable_mask_xmac1;     /* 0: xMAC1 is disabled  1: clock can be enabled/disabled by clock_enable-register for xMAC1       */
	unsigned int xmac2     : BFW_NX500_clock_enable_mask_xmac2;     /* 0: xMAC2 is disabled  1: clock can be enabled/disabled by clock_enable-register for xMAC2       */
	unsigned int xmac3     : BFW_NX500_clock_enable_mask_xmac3;     /* 0: xMAC3 is disabled  1: clock can be enabled/disabled by clock_enable-register for xMAC3       */
	unsigned int hif       : BFW_NX500_clock_enable_mask_hif;       /* 0: HIF is disabled  1: clock can be enabled/disabled by clock_enable-register for HIF           */
	unsigned int lcd       : BFW_NX500_clock_enable_mask_lcd;       /* 0: LCD Ctrl is disabled  1: clock can be enabled/disabled by clock_enable-register for LCD Ctrl */
	unsigned int reserved1 : BFW_NX500_clock_enable_mask_reserved1; /* reserved                                                                                        */
} NX500_CLOCK_ENABLE_MASK_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_CLOCK_ENABLE_MASK_BIT_T bf;
} NX500_CLOCK_ENABLE_MASK_T;

/* --------------------------------------------------------------------- */
/* Register misc_asic_ctrl */
/* => Miscellaneous ASIC Control Register: */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_misc_asic_ctrl       0x0000002CU
#define Adr_NX500_asic_ctrl_misc_asic_ctrl 0x0010002CU
#define Adr_NX500_misc_asic_ctrl           0x0010002CU
#define DFLT_VAL_NX500_misc_asic_ctrl      0x00000007U

#define MSK_NX500_misc_asic_ctrl_arm_dbgen          0x00000001U
#define SRT_NX500_misc_asic_ctrl_arm_dbgen          0
#define DFLT_VAL_NX500_misc_asic_ctrl_arm_dbgen     0x00000001U
#define MSK_NX500_misc_asic_ctrl_arm_dtcm_ws        0x00000002U
#define SRT_NX500_misc_asic_ctrl_arm_dtcm_ws        1
#define DFLT_VAL_NX500_misc_asic_ctrl_arm_dtcm_ws   0x00000002U
#define MSK_NX500_misc_asic_ctrl_arm_extmem_ws      0x00000004U
#define SRT_NX500_misc_asic_ctrl_arm_extmem_ws      2
#define DFLT_VAL_NX500_misc_asic_ctrl_arm_extmem_ws 0x00000004U

enum {
	BFW_NX500_misc_asic_ctrl_arm_dbgen     = 1,  /* [0] */
	BFW_NX500_misc_asic_ctrl_arm_dtcm_ws   = 1,  /* [1] */
	BFW_NX500_misc_asic_ctrl_arm_extmem_ws = 1,  /* [2] */
	BFW_NX500_misc_asic_ctrl_reserved1     = 29  /* [31:3] */
};

typedef struct NX500_MISC_ASIC_CTRL_BIT_Ttag {
	unsigned int arm_dbgen     : BFW_NX500_misc_asic_ctrl_arm_dbgen;     /* 1: ARM debug features are enabled                                                                                                                                          */
	                                                                     /* 0: ARM debug features are disabled                                                                                                                                         */
	unsigned int arm_dtcm_ws   : BFW_NX500_misc_asic_ctrl_arm_dtcm_ws;   /* 1: ARM data TCM runs with 1 ARM-clock Waitstate                                                                                                                            */
	                                                                     /* 0: ARM data TCM runs with 0 ARM-clock Waitstate                                                                                                                            */
	unsigned int arm_extmem_ws : BFW_NX500_misc_asic_ctrl_arm_extmem_ws; /* 1: 1 additional arbiter Waitstate for ARM (instr. and data) accesses to addr_extmemory_ahbls7 - chipselect area                                                            */
	                                                                     /* 0: 0 additional arbiter Waitstate for ARM (instr. and data) accesses to addr_extmemory_ahbls7 - chipselect area # default 10: ARM data TCM runs with 0 ARM-clock Waitstate */
	unsigned int reserved1     : BFW_NX500_misc_asic_ctrl_reserved1;     /* reserved                                                                                                                                                                   */
} NX500_MISC_ASIC_CTRL_BIT_T;

typedef union {
	unsigned int               val;
	NX500_MISC_ASIC_CTRL_BIT_T bf;
} NX500_MISC_ASIC_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register exmem_priority_lock */
/* => External Memory Priority Control Mask Register: */
/*    Set bits to lock the registers extmem_prio_timslot_ctrl and extmem_prio_accesstime_ctrl */
/*    in address area extmem_priority_ctrl. */
/*    allows to disable modules completely for power saving reasons */
/*    This register is lockable by netX locking algorithm. It will only be reset by Power on Reset (PORn), not by other system resets. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_exmem_priority_lock       0x00000030U
#define Adr_NX500_asic_ctrl_exmem_priority_lock 0x00100030U
#define Adr_NX500_exmem_priority_lock           0x00100030U
#define DFLT_VAL_NX500_exmem_priority_lock      0x00000000U

#define MSK_NX500_exmem_priority_lock_lock_HIF_priority       0x00000001U
#define SRT_NX500_exmem_priority_lock_lock_HIF_priority       0
#define DFLT_VAL_NX500_exmem_priority_lock_lock_HIF_priority  0x00000000U
#define MSK_NX500_exmem_priority_lock_lock_XC_priority        0x00000002U
#define SRT_NX500_exmem_priority_lock_lock_XC_priority        1
#define DFLT_VAL_NX500_exmem_priority_lock_lock_XC_priority   0x00000000U
#define MSK_NX500_exmem_priority_lock_lock_LCD_priority       0x00000004U
#define SRT_NX500_exmem_priority_lock_lock_LCD_priority       2
#define DFLT_VAL_NX500_exmem_priority_lock_lock_LCD_priority  0x00000000U
#define MSK_NX500_exmem_priority_lock_lock_ARMI_priority      0x00000008U
#define SRT_NX500_exmem_priority_lock_lock_ARMI_priority      3
#define DFLT_VAL_NX500_exmem_priority_lock_lock_ARMI_priority 0x00000000U
#define MSK_NX500_exmem_priority_lock_lock_ARMD_priority      0x00000010U
#define SRT_NX500_exmem_priority_lock_lock_ARMD_priority      4
#define DFLT_VAL_NX500_exmem_priority_lock_lock_ARMD_priority 0x00000000U

enum {
	BFW_NX500_exmem_priority_lock_lock_HIF_priority  = 1,  /* [0] */
	BFW_NX500_exmem_priority_lock_lock_XC_priority   = 1,  /* [1] */
	BFW_NX500_exmem_priority_lock_lock_LCD_priority  = 1,  /* [2] */
	BFW_NX500_exmem_priority_lock_lock_ARMI_priority = 1,  /* [3] */
	BFW_NX500_exmem_priority_lock_lock_ARMD_priority = 1,  /* [4] */
	BFW_NX500_exmem_priority_lock_reserved1          = 27  /* [31:5] */
};

typedef struct NX500_EXMEM_PRIORITY_LOCK_BIT_Ttag {
	unsigned int lock_HIF_priority  : BFW_NX500_exmem_priority_lock_lock_HIF_priority;  /* 1 HIF settings in registers extmem_prio_timslot_ctrl and extmem_prio_accesstime_ctrl will be locked  */
	unsigned int lock_XC_priority   : BFW_NX500_exmem_priority_lock_lock_XC_priority;   /* 1 XC settings in registers extmem_prio_timslot_ctrl and extmem_prio_accesstime_ctrl will be locked   */
	unsigned int lock_LCD_priority  : BFW_NX500_exmem_priority_lock_lock_LCD_priority;  /* 1 LCD settings in registers extmem_prio_timslot_ctrl and extmem_prio_accesstime_ctrl will be locked  */
	unsigned int lock_ARMI_priority : BFW_NX500_exmem_priority_lock_lock_ARMI_priority; /* 1 ARMI settings in registers extmem_prio_timslot_ctrl and extmem_prio_accesstime_ctrl will be locked */
	unsigned int lock_ARMD_priority : BFW_NX500_exmem_priority_lock_lock_ARMD_priority; /* 1 ARMD settings in registers extmem_prio_timslot_ctrl and extmem_prio_accesstime_ctrl will be locked */
	unsigned int reserved1          : BFW_NX500_exmem_priority_lock_reserved1;          /* reserved                                                                                             */
} NX500_EXMEM_PRIORITY_LOCK_BIT_T;

typedef union {
	unsigned int                    val;
	NX500_EXMEM_PRIORITY_LOCK_BIT_T bf;
} NX500_EXMEM_PRIORITY_LOCK_T;

/* --------------------------------------------------------------------- */
/* Register netx_version */
/* => netX Revision Register: */
/*    This register contains information about netX hardware and bootloader revision. */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_version       0x00000034U
#define Adr_NX500_asic_ctrl_netx_version 0x00100034U
#define Adr_NX500_netx_version           0x00100034U
#define DFLT_VAL_NX500_netx_version      0x00000000U

#define MSK_NX500_netx_version_netx_version      0x000000ffU
#define SRT_NX500_netx_version_netx_version      0
#define DFLT_VAL_NX500_netx_version_netx_version 0x00000000U

enum {
	BFW_NX500_netx_version_netx_version = 8,  /* [7:0] */
	BFW_NX500_netx_version_reserved1    = 24  /* [31:8] */
};

typedef struct NX500_NETX_VERSION_BIT_Ttag {
	unsigned int netx_version : BFW_NX500_netx_version_netx_version; /* netX revision number: */
	                                                                 /* 0x41: netx500         */
	unsigned int reserved1    : BFW_NX500_netx_version_reserved1;    /* reserved              */
} NX500_NETX_VERSION_BIT_T;

typedef union {
	unsigned int             val;
	NX500_NETX_VERSION_BIT_T bf;
} NX500_NETX_VERSION_T;

/* --------------------------------------------------------------------- */
/* Register asic_ctrl_access_key */
/* => ASIC Control Locking Access Key Register: */
/*    Writing to any register in the asic_ctrl address area is only possible after */
/*    setting the correct key here to avoid unmeant changes e.g. by crashed software. */
/*    ---- */
/*    Changing a control register in the asic_ctrl address area is only possible by the following sequence: */
/*    1.: Read out the Locking Access Key from this register. */
/*    2.: Write back this Locking Access Key to this register. */
/*    3.: Write desired value to the control register. */
/*    ---- */
/*    The Locking Access Key will become invalid after each access to any register in the asic_ctrl address area */
/*    and has to be read out and set again for sequent accesses. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_asic_ctrl_access_key       0x00000070U
#define Adr_NX500_asic_ctrl_asic_ctrl_access_key 0x00100070U
#define Adr_NX500_asic_ctrl_access_key           0x00100070U
#define DFLT_VAL_NX500_asic_ctrl_access_key      0x00000000U

#define MSK_NX500_asic_ctrl_access_key_access_key      0x0000ffffU
#define SRT_NX500_asic_ctrl_access_key_access_key      0
#define DFLT_VAL_NX500_asic_ctrl_access_key_access_key 0x00000000U

enum {
	BFW_NX500_asic_ctrl_access_key_access_key = 16, /* [15:0] */
	BFW_NX500_asic_ctrl_access_key_reserved1  = 16  /* [31:16] */
};

typedef struct NX500_ASIC_CTRL_ACCESS_KEY_BIT_Ttag {
	unsigned int access_key : BFW_NX500_asic_ctrl_access_key_access_key; /* Locking Access Key for next write access. */
	unsigned int reserved1  : BFW_NX500_asic_ctrl_access_key_reserved1;  /* reserved                                  */
} NX500_ASIC_CTRL_ACCESS_KEY_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_ASIC_CTRL_ACCESS_KEY_BIT_T bf;
} NX500_ASIC_CTRL_ACCESS_KEY_T;

/* --------------------------------------------------------------------- */
/* Register netx_lock_reserved00 */
/* => reserved address for netX locking purpose */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_lock_reserved00       0x00000074U
#define Adr_NX500_asic_ctrl_netx_lock_reserved00 0x00100074U
#define Adr_NX500_netx_lock_reserved00           0x00100074U

#define MSK_NX500_netx_lock_reserved00_lock 0xffffffffU
#define SRT_NX500_netx_lock_reserved00_lock 0

enum {
	BFW_NX500_netx_lock_reserved00_lock = 32  /* [31:0] */
};

typedef struct NX500_NETX_LOCK_RESERVED00_BIT_Ttag {
	unsigned int lock : BFW_NX500_netx_lock_reserved00_lock; /* locking purpose */
} NX500_NETX_LOCK_RESERVED00_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_NETX_LOCK_RESERVED00_BIT_T bf;
} NX500_NETX_LOCK_RESERVED00_T;

/* --------------------------------------------------------------------- */
/* Register netx_lock_reserved01 */
/* => reserved address for netX locking purpose */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_lock_reserved01       0x00000078U
#define Adr_NX500_asic_ctrl_netx_lock_reserved01 0x00100078U
#define Adr_NX500_netx_lock_reserved01           0x00100078U

#define MSK_NX500_netx_lock_reserved01_lock 0xffffffffU
#define SRT_NX500_netx_lock_reserved01_lock 0

enum {
	BFW_NX500_netx_lock_reserved01_lock = 32  /* [31:0] */
};

typedef struct NX500_NETX_LOCK_RESERVED01_BIT_Ttag {
	unsigned int lock : BFW_NX500_netx_lock_reserved01_lock; /* locking purpose */
} NX500_NETX_LOCK_RESERVED01_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_NETX_LOCK_RESERVED01_BIT_T bf;
} NX500_NETX_LOCK_RESERVED01_T;

/* --------------------------------------------------------------------- */
/* Register netx_lock_reserved_start */
/* => Reserved start address for netX locking purpose address area */
/*    Don't implement other registers at 0x80 .. 0xfc! */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_lock_reserved_start       0x00000080U
#define Adr_NX500_asic_ctrl_netx_lock_reserved_start 0x00100080U
#define Adr_NX500_netx_lock_reserved_start           0x00100080U

#define MSK_NX500_netx_lock_reserved_start_lock 0xffffffffU
#define SRT_NX500_netx_lock_reserved_start_lock 0

enum {
	BFW_NX500_netx_lock_reserved_start_lock = 32  /* [31:0] */
};

typedef struct NX500_NETX_LOCK_RESERVED_START_BIT_Ttag {
	unsigned int lock : BFW_NX500_netx_lock_reserved_start_lock; /* locking purpose */
} NX500_NETX_LOCK_RESERVED_START_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_NETX_LOCK_RESERVED_START_BIT_T bf;
} NX500_NETX_LOCK_RESERVED_START_T;

/* --------------------------------------------------------------------- */
/* Register netx_lock_reserved_end */
/* => Reserved end address for netX locking purpose address area */
/*    Don't implement other registers at 0x80 .. 0xfc! */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_lock_reserved_end       0x000000FCU
#define Adr_NX500_asic_ctrl_netx_lock_reserved_end 0x001000FCU
#define Adr_NX500_netx_lock_reserved_end           0x001000FCU

#define MSK_NX500_netx_lock_reserved_end_lock 0xffffffffU
#define SRT_NX500_netx_lock_reserved_end_lock 0

enum {
	BFW_NX500_netx_lock_reserved_end_lock = 32  /* [31:0] */
};

typedef struct NX500_NETX_LOCK_RESERVED_END_BIT_Ttag {
	unsigned int lock : BFW_NX500_netx_lock_reserved_end_lock; /* locking purpose */
} NX500_NETX_LOCK_RESERVED_END_BIT_T;

typedef union {
	unsigned int                       val;
	NX500_NETX_LOCK_RESERVED_END_BIT_T bf;
} NX500_NETX_LOCK_RESERVED_END_T;


/* ===================================================================== */

/* Area of extmemctrl */

/* ===================================================================== */

#define Addr_NX500_extmemctrl 0x00100100U

/* ===================================================================== */

/* Area of ext_asyncmem_ctrl */

/* ===================================================================== */

#define Addr_NX500_ext_asyncmem_ctrl  0x00100100U
#define NX500_NETX_MEM_SRAM_CTRL_AREA 0x00100100U

/* --------------------------------------------------------------------- */
/* Register extsram0_ctrl */
/* => Control Register for external bus interface and Waitstates for ExtMem0 chip select area */
/*    memory width coding like ARM-signals MAS / HSIZE[1:0]: */
/*        00=8bit */
/*        01=16bit */
/*        10=32bit */
/*        11=reserved */
/*    external addresses will be alligned (right shifted) according to the selected memory width */
/*        8 bit  -> no right shift of Aext */
/*        16 bit -> right shift Aext 1 bit */
/*        32 bit -> right shift Aext 2 bits */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_extsram0_ctrl               0x00000000U
#define Adr_NX500_ext_asyncmem_ctrl_extsram0_ctrl 0x00100100U
#define Adr_NX500_extsram0_ctrl                   0x00100100U
#define DFLT_VAL_NX500_extsram0_ctrl              0x0003033fU

#define MSK_NX500_extsram0_ctrl_WSExtMem0               0x0000003fU
#define SRT_NX500_extsram0_ctrl_WSExtMem0               0
#define DFLT_VAL_NX500_extsram0_ctrl_WSExtMem0          0x0000003fU
#define MSK_NX500_extsram0_ctrl_WSPrePauseExtMem0       0x00000300U
#define SRT_NX500_extsram0_ctrl_WSPrePauseExtMem0       8
#define DFLT_VAL_NX500_extsram0_ctrl_WSPrePauseExtMem0  0x00000300U
#define MSK_NX500_extsram0_ctrl_WSPostPauseExtMem0      0x00030000U
#define SRT_NX500_extsram0_ctrl_WSPostPauseExtMem0      16
#define DFLT_VAL_NX500_extsram0_ctrl_WSPostPauseExtMem0 0x00030000U
#define MSK_NX500_extsram0_ctrl_WidthExtMem0            0x03000000U
#define SRT_NX500_extsram0_ctrl_WidthExtMem0            24
#define DFLT_VAL_NX500_extsram0_ctrl_WidthExtMem0       0x00000000U

enum {
	BFW_NX500_extsram0_ctrl_WSExtMem0          = 6, /* [5:0] */
	BFW_NX500_extsram0_ctrl_reserved1          = 2, /* [7:6] */
	BFW_NX500_extsram0_ctrl_WSPrePauseExtMem0  = 2, /* [9:8] */
	BFW_NX500_extsram0_ctrl_reserved2          = 6, /* [15:10] */
	BFW_NX500_extsram0_ctrl_WSPostPauseExtMem0 = 2, /* [17:16] */
	BFW_NX500_extsram0_ctrl_reserved3          = 6, /* [23:18] */
	BFW_NX500_extsram0_ctrl_WidthExtMem0       = 2, /* [25:24] */
	BFW_NX500_extsram0_ctrl_reserved4          = 6  /* [31:26] */
};

typedef struct NX500_EXTSRAM0_CTRL_BIT_Ttag {
	unsigned int WSExtMem0          : BFW_NX500_extsram0_ctrl_WSExtMem0;          /* Waitstates 0 - 63 cycles                                             */
	unsigned int reserved1          : BFW_NX500_extsram0_ctrl_reserved1;          /* reserved                                                             */
	unsigned int WSPrePauseExtMem0  : BFW_NX500_extsram0_ctrl_WSPrePauseExtMem0;  /* additional Waitstates for setuptime nCS,Aext to nOE,nWE 0 - 3 cycles */
	unsigned int reserved2          : BFW_NX500_extsram0_ctrl_reserved2;          /* reserved                                                             */
	unsigned int WSPostPauseExtMem0 : BFW_NX500_extsram0_ctrl_WSPostPauseExtMem0; /* additional Waitstates after access 0 - 3 cycles                      */
	unsigned int reserved3          : BFW_NX500_extsram0_ctrl_reserved3;          /* reserved                                                             */
	unsigned int WidthExtMem0       : BFW_NX500_extsram0_ctrl_WidthExtMem0;       /* Datapath width of ExtMem0 area                                       */
	unsigned int reserved4          : BFW_NX500_extsram0_ctrl_reserved4;          /* reserved                                                             */
} NX500_EXTSRAM0_CTRL_BIT_T;

typedef union {
	unsigned int              val;
	NX500_EXTSRAM0_CTRL_BIT_T bf;
} NX500_EXTSRAM0_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register extsram1_ctrl */
/* => Control Register for external bus interface and Waitstates for ExtMem1 chip select area */
/*    memory width coding like ARM-signals MAS / HSIZE[1:0]: */
/*        00=8bit */
/*        01=16bit */
/*        10=32bit */
/*        11=reserved */
/*    external addresses will be alligned (right shifted) according to the selected memory width */
/*        8 bit  -> no right shift of Aext */
/*        16 bit -> right shift Aext 1 bit */
/*        32 bit -> right shift Aext 2 bits */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_extsram1_ctrl               0x00000004U
#define Adr_NX500_ext_asyncmem_ctrl_extsram1_ctrl 0x00100104U
#define Adr_NX500_extsram1_ctrl                   0x00100104U
#define DFLT_VAL_NX500_extsram1_ctrl              0x0003033fU

#define MSK_NX500_extsram1_ctrl_WSExtMem1               0x0000003fU
#define SRT_NX500_extsram1_ctrl_WSExtMem1               0
#define DFLT_VAL_NX500_extsram1_ctrl_WSExtMem1          0x0000003fU
#define MSK_NX500_extsram1_ctrl_WSPrePauseExtMem1       0x00000300U
#define SRT_NX500_extsram1_ctrl_WSPrePauseExtMem1       8
#define DFLT_VAL_NX500_extsram1_ctrl_WSPrePauseExtMem1  0x00000300U
#define MSK_NX500_extsram1_ctrl_WSPostPauseExtMem1      0x00030000U
#define SRT_NX500_extsram1_ctrl_WSPostPauseExtMem1      16
#define DFLT_VAL_NX500_extsram1_ctrl_WSPostPauseExtMem1 0x00030000U
#define MSK_NX500_extsram1_ctrl_WidthExtMem1            0x03000000U
#define SRT_NX500_extsram1_ctrl_WidthExtMem1            24
#define DFLT_VAL_NX500_extsram1_ctrl_WidthExtMem1       0x00000000U

enum {
	BFW_NX500_extsram1_ctrl_WSExtMem1          = 6, /* [5:0] */
	BFW_NX500_extsram1_ctrl_reserved1          = 2, /* [7:6] */
	BFW_NX500_extsram1_ctrl_WSPrePauseExtMem1  = 2, /* [9:8] */
	BFW_NX500_extsram1_ctrl_reserved2          = 6, /* [15:10] */
	BFW_NX500_extsram1_ctrl_WSPostPauseExtMem1 = 2, /* [17:16] */
	BFW_NX500_extsram1_ctrl_reserved3          = 6, /* [23:18] */
	BFW_NX500_extsram1_ctrl_WidthExtMem1       = 2, /* [25:24] */
	BFW_NX500_extsram1_ctrl_reserved4          = 6  /* [31:26] */
};

typedef struct NX500_EXTSRAM1_CTRL_BIT_Ttag {
	unsigned int WSExtMem1          : BFW_NX500_extsram1_ctrl_WSExtMem1;          /* Waitstates 0 - 63 cycles                                             */
	unsigned int reserved1          : BFW_NX500_extsram1_ctrl_reserved1;          /* reserved                                                             */
	unsigned int WSPrePauseExtMem1  : BFW_NX500_extsram1_ctrl_WSPrePauseExtMem1;  /* additional Waitstates for setuptime nCS,Aext to nOE,nWE 0 - 3 cycles */
	unsigned int reserved2          : BFW_NX500_extsram1_ctrl_reserved2;          /* reserved                                                             */
	unsigned int WSPostPauseExtMem1 : BFW_NX500_extsram1_ctrl_WSPostPauseExtMem1; /* additional Waitstates after access 0 - 3 cycles                      */
	unsigned int reserved3          : BFW_NX500_extsram1_ctrl_reserved3;          /* reserved                                                             */
	unsigned int WidthExtMem1       : BFW_NX500_extsram1_ctrl_WidthExtMem1;       /* Datapath width of ExtMem1 area                                       */
	unsigned int reserved4          : BFW_NX500_extsram1_ctrl_reserved4;          /* reserved                                                             */
} NX500_EXTSRAM1_CTRL_BIT_T;

typedef union {
	unsigned int              val;
	NX500_EXTSRAM1_CTRL_BIT_T bf;
} NX500_EXTSRAM1_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register extsram2_ctrl */
/* => Control Register for external bus interface and Waitstates for ExtMem2 chip select area */
/*    memory width coding like ARM-signals MAS / HSIZE[1:0]: */
/*        00=8bit */
/*        01=16bit */
/*        10=32bit */
/*        11=reserved */
/*    external addresses will be alligned (right shifted) according to the selected memory width */
/*        8 bit  -> no right shift of Aext */
/*        16 bit -> right shift Aext 1 bit */
/*        32 bit -> right shift Aext 2 bits */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_extsram2_ctrl               0x00000008U
#define Adr_NX500_ext_asyncmem_ctrl_extsram2_ctrl 0x00100108U
#define Adr_NX500_extsram2_ctrl                   0x00100108U
#define DFLT_VAL_NX500_extsram2_ctrl              0x0003033fU

#define MSK_NX500_extsram2_ctrl_WSExtMem2               0x0000003fU
#define SRT_NX500_extsram2_ctrl_WSExtMem2               0
#define DFLT_VAL_NX500_extsram2_ctrl_WSExtMem2          0x0000003fU
#define MSK_NX500_extsram2_ctrl_WSPrePauseExtMem2       0x00000300U
#define SRT_NX500_extsram2_ctrl_WSPrePauseExtMem2       8
#define DFLT_VAL_NX500_extsram2_ctrl_WSPrePauseExtMem2  0x00000300U
#define MSK_NX500_extsram2_ctrl_WSPostPauseExtMem2      0x00030000U
#define SRT_NX500_extsram2_ctrl_WSPostPauseExtMem2      16
#define DFLT_VAL_NX500_extsram2_ctrl_WSPostPauseExtMem2 0x00030000U
#define MSK_NX500_extsram2_ctrl_WidthExtMem2            0x03000000U
#define SRT_NX500_extsram2_ctrl_WidthExtMem2            24
#define DFLT_VAL_NX500_extsram2_ctrl_WidthExtMem2       0x00000000U

enum {
	BFW_NX500_extsram2_ctrl_WSExtMem2          = 6, /* [5:0] */
	BFW_NX500_extsram2_ctrl_reserved1          = 2, /* [7:6] */
	BFW_NX500_extsram2_ctrl_WSPrePauseExtMem2  = 2, /* [9:8] */
	BFW_NX500_extsram2_ctrl_reserved2          = 6, /* [15:10] */
	BFW_NX500_extsram2_ctrl_WSPostPauseExtMem2 = 2, /* [17:16] */
	BFW_NX500_extsram2_ctrl_reserved3          = 6, /* [23:18] */
	BFW_NX500_extsram2_ctrl_WidthExtMem2       = 2, /* [25:24] */
	BFW_NX500_extsram2_ctrl_reserved4          = 6  /* [31:26] */
};

typedef struct NX500_EXTSRAM2_CTRL_BIT_Ttag {
	unsigned int WSExtMem2          : BFW_NX500_extsram2_ctrl_WSExtMem2;          /* Waitstates 0 - 63 cycles                                             */
	unsigned int reserved1          : BFW_NX500_extsram2_ctrl_reserved1;          /* reserved                                                             */
	unsigned int WSPrePauseExtMem2  : BFW_NX500_extsram2_ctrl_WSPrePauseExtMem2;  /* additional Waitstates for setuptime nCS,Aext to nOE,nWE 0 - 3 cycles */
	unsigned int reserved2          : BFW_NX500_extsram2_ctrl_reserved2;          /* reserved                                                             */
	unsigned int WSPostPauseExtMem2 : BFW_NX500_extsram2_ctrl_WSPostPauseExtMem2; /* additional Waitstates after access 0 - 3 cycles                      */
	unsigned int reserved3          : BFW_NX500_extsram2_ctrl_reserved3;          /* reserved                                                             */
	unsigned int WidthExtMem2       : BFW_NX500_extsram2_ctrl_WidthExtMem2;       /* Datapath width of ExtMem2 area                                       */
	unsigned int reserved4          : BFW_NX500_extsram2_ctrl_reserved4;          /* reserved                                                             */
} NX500_EXTSRAM2_CTRL_BIT_T;

typedef union {
	unsigned int              val;
	NX500_EXTSRAM2_CTRL_BIT_T bf;
} NX500_EXTSRAM2_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register extsram3_ctrl */
/* => This register exists physically, but corresponding MEM_MCS3_N-Signal is not connected externally. */
/*    Control Register for external bus interface and Waitstates for ExtMem3 chip select area */
/*    memory width coding like ARM-signals MAS / HSIZE[1:0]: */
/*        00=8bit */
/*        01=16bit */
/*        10=32bit */
/*        11=reserved */
/*    external addresses will be alligned (right shifted) according to the selected memory width */
/*        8 bit  -> no right shift of Aext */
/*        16 bit -> right shift Aext 1 bit */
/*        32 bit -> right shift Aext 2 bits */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_extsram3_ctrl               0x0000000CU
#define Adr_NX500_ext_asyncmem_ctrl_extsram3_ctrl 0x0010010CU
#define Adr_NX500_extsram3_ctrl                   0x0010010CU
#define DFLT_VAL_NX500_extsram3_ctrl              0x0003033fU

#define MSK_NX500_extsram3_ctrl_WSExtMem3               0x0000003fU
#define SRT_NX500_extsram3_ctrl_WSExtMem3               0
#define DFLT_VAL_NX500_extsram3_ctrl_WSExtMem3          0x0000003fU
#define MSK_NX500_extsram3_ctrl_WSPrePauseExtMem3       0x00000300U
#define SRT_NX500_extsram3_ctrl_WSPrePauseExtMem3       8
#define DFLT_VAL_NX500_extsram3_ctrl_WSPrePauseExtMem3  0x00000300U
#define MSK_NX500_extsram3_ctrl_WSPostPauseExtMem3      0x00030000U
#define SRT_NX500_extsram3_ctrl_WSPostPauseExtMem3      16
#define DFLT_VAL_NX500_extsram3_ctrl_WSPostPauseExtMem3 0x00030000U
#define MSK_NX500_extsram3_ctrl_WidthExtMem3            0x03000000U
#define SRT_NX500_extsram3_ctrl_WidthExtMem3            24
#define DFLT_VAL_NX500_extsram3_ctrl_WidthExtMem3       0x00000000U

enum {
	BFW_NX500_extsram3_ctrl_WSExtMem3          = 6, /* [5:0] */
	BFW_NX500_extsram3_ctrl_reserved1          = 2, /* [7:6] */
	BFW_NX500_extsram3_ctrl_WSPrePauseExtMem3  = 2, /* [9:8] */
	BFW_NX500_extsram3_ctrl_reserved2          = 6, /* [15:10] */
	BFW_NX500_extsram3_ctrl_WSPostPauseExtMem3 = 2, /* [17:16] */
	BFW_NX500_extsram3_ctrl_reserved3          = 6, /* [23:18] */
	BFW_NX500_extsram3_ctrl_WidthExtMem3       = 2, /* [25:24] */
	BFW_NX500_extsram3_ctrl_reserved4          = 6  /* [31:26] */
};

typedef struct NX500_EXTSRAM3_CTRL_BIT_Ttag {
	unsigned int WSExtMem3          : BFW_NX500_extsram3_ctrl_WSExtMem3;          /* Waitstates 0 - 63 cycles                                             */
	unsigned int reserved1          : BFW_NX500_extsram3_ctrl_reserved1;          /* reserved                                                             */
	unsigned int WSPrePauseExtMem3  : BFW_NX500_extsram3_ctrl_WSPrePauseExtMem3;  /* additional Waitstates for setuptime nCS,Aext to nOE,nWE 0 - 3 cycles */
	unsigned int reserved2          : BFW_NX500_extsram3_ctrl_reserved2;          /* reserved                                                             */
	unsigned int WSPostPauseExtMem3 : BFW_NX500_extsram3_ctrl_WSPostPauseExtMem3; /* additional Waitstates after access 0 - 3 cycles                      */
	unsigned int reserved3          : BFW_NX500_extsram3_ctrl_reserved3;          /* reserved                                                             */
	unsigned int WidthExtMem3       : BFW_NX500_extsram3_ctrl_WidthExtMem3;       /* Datapath width of ExtMem3 area                                       */
	unsigned int reserved4          : BFW_NX500_extsram3_ctrl_reserved4;          /* reserved                                                             */
} NX500_EXTSRAM3_CTRL_BIT_T;

typedef union {
	unsigned int              val;
	NX500_EXTSRAM3_CTRL_BIT_T bf;
} NX500_EXTSRAM3_CTRL_T;


/* ===================================================================== */

/* Area of ext_sdram_ctrl */

/* ===================================================================== */

#define Addr_NX500_ext_sdram_ctrl      0x00100140U
#define NX500_NETX_MEM_SDRAM_CTRL_AREA 0x00100140U

/* --------------------------------------------------------------------- */
/* Register sdram_general_ctrl */
/* => Control Register for external SDRAM access. */
/*    ---------------------------------------------------------- */
/*    No DDR/DDR2 support in netX! Don't regard DDR/DDR2 options */
/*    ---------------------------------------------------------- */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_sdram_general_ctrl            0x00000000U
#define Adr_NX500_ext_sdram_ctrl_sdram_general_ctrl 0x00100140U
#define Adr_NX500_sdram_general_ctrl                0x00100140U
#define DFLT_VAL_NX500_sdram_general_ctrl           0x01000001U

#define MSK_NX500_sdram_general_ctrl_banks                0x00000003U
#define SRT_NX500_sdram_general_ctrl_banks                0
#define DFLT_VAL_NX500_sdram_general_ctrl_banks           0x00000001U
#define MSK_NX500_sdram_general_ctrl_rows                 0x00000070U
#define SRT_NX500_sdram_general_ctrl_rows                 4
#define DFLT_VAL_NX500_sdram_general_ctrl_rows            0x00000000U
#define MSK_NX500_sdram_general_ctrl_columns              0x00000700U
#define SRT_NX500_sdram_general_ctrl_columns              8
#define DFLT_VAL_NX500_sdram_general_ctrl_columns         0x00000000U
#define MSK_NX500_sdram_general_ctrl_dbus32               0x00010000U
#define SRT_NX500_sdram_general_ctrl_dbus32               16
#define DFLT_VAL_NX500_sdram_general_ctrl_dbus32          0x00000000U
#define MSK_NX500_sdram_general_ctrl_sdram_pwdn           0x00020000U
#define SRT_NX500_sdram_general_ctrl_sdram_pwdn           17
#define DFLT_VAL_NX500_sdram_general_ctrl_sdram_pwdn      0x00000000U
#define MSK_NX500_sdram_general_ctrl_extclk_en            0x00040000U
#define SRT_NX500_sdram_general_ctrl_extclk_en            18
#define DFLT_VAL_NX500_sdram_general_ctrl_extclk_en       0x00000000U
#define MSK_NX500_sdram_general_ctrl_ctrl_en              0x00080000U
#define SRT_NX500_sdram_general_ctrl_ctrl_en              19
#define DFLT_VAL_NX500_sdram_general_ctrl_ctrl_en         0x00000000U
#define MSK_NX500_sdram_general_ctrl_refresh_mode         0x03000000U
#define SRT_NX500_sdram_general_ctrl_refresh_mode         24
#define DFLT_VAL_NX500_sdram_general_ctrl_refresh_mode    0x01000000U
#define MSK_NX500_sdram_general_ctrl_sdram_ready          0x40000000U
#define SRT_NX500_sdram_general_ctrl_sdram_ready          30
#define DFLT_VAL_NX500_sdram_general_ctrl_sdram_ready     0x00000000U
#define MSK_NX500_sdram_general_ctrl_refresh_request      0x80000000U
#define SRT_NX500_sdram_general_ctrl_refresh_request      31
#define DFLT_VAL_NX500_sdram_general_ctrl_refresh_request 0x00000000U

enum {
	BFW_NX500_sdram_general_ctrl_banks           = 2, /* [1:0] */
	BFW_NX500_sdram_general_ctrl_reserved1       = 2, /* [3:2] */
	BFW_NX500_sdram_general_ctrl_rows            = 3, /* [6:4] */
	BFW_NX500_sdram_general_ctrl_reserved2       = 1, /* [7] */
	BFW_NX500_sdram_general_ctrl_columns         = 3, /* [10:8] */
	BFW_NX500_sdram_general_ctrl_reserved3       = 5, /* [15:11] */
	BFW_NX500_sdram_general_ctrl_dbus32          = 1, /* [16] */
	BFW_NX500_sdram_general_ctrl_sdram_pwdn      = 1, /* [17] */
	BFW_NX500_sdram_general_ctrl_extclk_en       = 1, /* [18] */
	BFW_NX500_sdram_general_ctrl_ctrl_en         = 1, /* [19] */
	BFW_NX500_sdram_general_ctrl_reserved4       = 4, /* [23:20] */
	BFW_NX500_sdram_general_ctrl_refresh_mode    = 2, /* [25:24] */
	BFW_NX500_sdram_general_ctrl_reserved5       = 4, /* [29:26] */
	BFW_NX500_sdram_general_ctrl_sdram_ready     = 1, /* [30] */
	BFW_NX500_sdram_general_ctrl_refresh_request = 1  /* [31] */
};

typedef struct NX500_SDRAM_GENERAL_CTRL_BIT_Ttag {
	unsigned int banks           : BFW_NX500_sdram_general_ctrl_banks;           /* Bank address coding.                                                                              */
	                                                                             /* 00 : 2                                                                                            */
	unsigned int reserved1       : BFW_NX500_sdram_general_ctrl_reserved1;       /* reserved                                                                                          */
	unsigned int rows            : BFW_NX500_sdram_general_ctrl_rows;            /* Row address coding.                                                                               */
	                                                                             /* 000 : 2k  (A0..A10) (default)                                                                     */
	unsigned int reserved2       : BFW_NX500_sdram_general_ctrl_reserved2;       /* reserved                                                                                          */
	unsigned int columns         : BFW_NX500_sdram_general_ctrl_columns;         /* Column address coding.                                                                            */
	                                                                             /* 000 : 256 (A0..A7) (default)                                                                      */
	unsigned int reserved3       : BFW_NX500_sdram_general_ctrl_reserved3;       /* reserved                                                                                          */
	unsigned int dbus32          : BFW_NX500_sdram_general_ctrl_dbus32;          /* SDRAM data bus width                                                                              */
	                                                                             /* 0: SDRAM data bus is 16 bit wide.  (default)                                                      */
	unsigned int sdram_pwdn      : BFW_NX500_sdram_general_ctrl_sdram_pwdn;      /* SDRAM power down                                                                                  */
	                                                                             /* If this bit is set, the Controller will move SDRAM to power down self refresh mode (no data loss) */
	unsigned int extclk_en       : BFW_NX500_sdram_general_ctrl_extclk_en;       /* external SDRAM clock enable                                                                       */
	                                                                             /* 0: SDRAM clock disabled.  (default)                                                               */
	unsigned int ctrl_en         : BFW_NX500_sdram_general_ctrl_ctrl_en;         /*  SDRAM controller enable                                                                          */
	                                                                             /*  The sdram_timing_ctrl-register can only be changed while this bit is 0.                          */
	unsigned int reserved4       : BFW_NX500_sdram_general_ctrl_reserved4;       /* reserved                                                                                          */
	unsigned int refresh_mode    : BFW_NX500_sdram_general_ctrl_refresh_mode;    /* Refresh request generation mode.                                                                  */
	                                                                             /* Refresh generation has always lower priority than accesses on external memory interface.          */
	unsigned int reserved5       : BFW_NX500_sdram_general_ctrl_reserved5;       /* reserved                                                                                          */
	unsigned int sdram_ready     : BFW_NX500_sdram_general_ctrl_sdram_ready;     /* SDRAM ready.                                                                                      */
	                                                                             /* This bit is set to 1 if SDRAM is ready for access. If sdram_general_ctrl.ctrl_en == 0 or          */
	unsigned int refresh_request : BFW_NX500_sdram_general_ctrl_refresh_request; /* Refresh request flag.                                                                             */
	                                                                             /* Refresh generation has always lower priority than accesses on external memory interface.          */
} NX500_SDRAM_GENERAL_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_SDRAM_GENERAL_CTRL_BIT_T bf;
} NX500_SDRAM_GENERAL_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register sdram_timing_ctrl */
/* => Control Register for external SDRAM access. */
/*    Changes can only be done, if the SDRAM-Controller is disabled (sdram_general_ctrl.ctrl_en == 0) */
/*    to avoid configuration problems. */
/*    ---------------------------------------------------------- */
/*    No DDR/DDR2 support in netX! Don't regard DDR/DDR2 options */
/*    ---------------------------------------------------------- */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_sdram_timing_ctrl            0x00000004U
#define Adr_NX500_ext_sdram_ctrl_sdram_timing_ctrl 0x00100144U
#define Adr_NX500_sdram_timing_ctrl                0x00100144U
#define DFLT_VAL_NX500_sdram_timing_ctrl           0x0381f7f3U

#define MSK_NX500_sdram_timing_ctrl_t_RCD                  0x00000003U
#define SRT_NX500_sdram_timing_ctrl_t_RCD                  0
#define DFLT_VAL_NX500_sdram_timing_ctrl_t_RCD             0x00000003U
#define MSK_NX500_sdram_timing_ctrl_t_WR                   0x00000030U
#define SRT_NX500_sdram_timing_ctrl_t_WR                   4
#define DFLT_VAL_NX500_sdram_timing_ctrl_t_WR              0x00000030U
#define MSK_NX500_sdram_timing_ctrl_t_RP                   0x000000c0U
#define SRT_NX500_sdram_timing_ctrl_t_RP                   6
#define DFLT_VAL_NX500_sdram_timing_ctrl_t_RP              0x000000c0U
#define MSK_NX500_sdram_timing_ctrl_t_RAS                  0x00000700U
#define SRT_NX500_sdram_timing_ctrl_t_RAS                  8
#define DFLT_VAL_NX500_sdram_timing_ctrl_t_RAS             0x00000700U
#define MSK_NX500_sdram_timing_ctrl_t_RFC                  0x0000f000U
#define SRT_NX500_sdram_timing_ctrl_t_RFC                  12
#define DFLT_VAL_NX500_sdram_timing_ctrl_t_RFC             0x0000f000U
#define MSK_NX500_sdram_timing_ctrl_t_REFI                 0x00030000U
#define SRT_NX500_sdram_timing_ctrl_t_REFI                 16
#define DFLT_VAL_NX500_sdram_timing_ctrl_t_REFI            0x00010000U
#define MSK_NX500_sdram_timing_ctrl_mem_sdclk_phase        0x00700000U
#define SRT_NX500_sdram_timing_ctrl_mem_sdclk_phase        20
#define DFLT_VAL_NX500_sdram_timing_ctrl_mem_sdclk_phase   0x00000000U
#define MSK_NX500_sdram_timing_ctrl_mem_sdclk_ssneg        0x00800000U
#define SRT_NX500_sdram_timing_ctrl_mem_sdclk_ssneg        23
#define DFLT_VAL_NX500_sdram_timing_ctrl_mem_sdclk_ssneg   0x00800000U
#define MSK_NX500_sdram_timing_ctrl_data_sample_phase      0x07000000U
#define SRT_NX500_sdram_timing_ctrl_data_sample_phase      24
#define DFLT_VAL_NX500_sdram_timing_ctrl_data_sample_phase 0x03000000U
#define MSK_NX500_sdram_timing_ctrl_bypass_neg_delay       0x10000000U
#define SRT_NX500_sdram_timing_ctrl_bypass_neg_delay       28
#define DFLT_VAL_NX500_sdram_timing_ctrl_bypass_neg_delay  0x00000000U

enum {
	BFW_NX500_sdram_timing_ctrl_t_RCD             = 2, /* [1:0] */
	BFW_NX500_sdram_timing_ctrl_reserved1         = 2, /* [3:2] */
	BFW_NX500_sdram_timing_ctrl_t_WR              = 2, /* [5:4] */
	BFW_NX500_sdram_timing_ctrl_t_RP              = 2, /* [7:6] */
	BFW_NX500_sdram_timing_ctrl_t_RAS             = 3, /* [10:8] */
	BFW_NX500_sdram_timing_ctrl_reserved2         = 1, /* [11] */
	BFW_NX500_sdram_timing_ctrl_t_RFC             = 4, /* [15:12] */
	BFW_NX500_sdram_timing_ctrl_t_REFI            = 2, /* [17:16] */
	BFW_NX500_sdram_timing_ctrl_reserved3         = 2, /* [19:18] */
	BFW_NX500_sdram_timing_ctrl_mem_sdclk_phase   = 3, /* [22:20] */
	BFW_NX500_sdram_timing_ctrl_mem_sdclk_ssneg   = 1, /* [23] */
	BFW_NX500_sdram_timing_ctrl_data_sample_phase = 3, /* [26:24] */
	BFW_NX500_sdram_timing_ctrl_reserved4         = 1, /* [27] */
	BFW_NX500_sdram_timing_ctrl_bypass_neg_delay  = 1, /* [28] */
	BFW_NX500_sdram_timing_ctrl_reserved5         = 3  /* [31:29] */
};

typedef struct NX500_SDRAM_TIMING_CTRL_BIT_Ttag {
	unsigned int t_RCD             : BFW_NX500_sdram_timing_ctrl_t_RCD;             /* ACTIVE to READ or WRITE time (RAS to CAS, clk = t_RCD)                                       */
	                                                                                /* This value will be also taken as t_RRD (ACTIVE bank A to ACTIVE bank B time)                 */
	unsigned int reserved1         : BFW_NX500_sdram_timing_ctrl_reserved1;         /* reserved                                                                                     */
	unsigned int t_WR              : BFW_NX500_sdram_timing_ctrl_t_WR;              /* Write recovery time (last write data to PRECHARGE)                                           */
	                                                                                /* 00 : 1 clk                                                                                   */
	unsigned int t_RP              : BFW_NX500_sdram_timing_ctrl_t_RP;              /* Precharge command period time (PRECHARGE to next command)                                    */
	                                                                                /* 00 : 1 clk                                                                                   */
	unsigned int t_RAS             : BFW_NX500_sdram_timing_ctrl_t_RAS;             /* ACTIVE to PRECHARGE command time (clk = t_RAS + 3)                                           */
	                                                                                /* 000 :  3 clks                                                                                */
	unsigned int reserved2         : BFW_NX500_sdram_timing_ctrl_reserved2;         /* reserved                                                                                     */
	unsigned int t_RFC             : BFW_NX500_sdram_timing_ctrl_t_RFC;             /* REFRESH to next command time (clk = tRFC + 4)                                                */
	                                                                                /* 0000 :  4 clks                                                                               */
	unsigned int t_REFI            : BFW_NX500_sdram_timing_ctrl_t_REFI;            /* Average periodic refresh interval (3.90 us * 2^t_REFI                                        */
	                                                                                /* 00 :   3.90 us                                                                               */
	unsigned int reserved3         : BFW_NX500_sdram_timing_ctrl_reserved3;         /* reserved                                                                                     */
	unsigned int mem_sdclk_phase   : BFW_NX500_sdram_timing_ctrl_mem_sdclk_phase;   /* MEM_SDCLK phase shift.                                                                       */
	                                                                                /* 0..5: adjustable phase-shift for external SDRAM clock depending on external capacitive       */
	unsigned int mem_sdclk_ssneg   : BFW_NX500_sdram_timing_ctrl_mem_sdclk_ssneg;   /* MEM_SDCLK start sample with negative clk400 edge for MEM_SDCLK phase shift                   */
	                                                                                /* 1: clk_memsig will be sampled for MEM_SDCLK-generation internally first on negedge of clk400 */
	unsigned int data_sample_phase : BFW_NX500_sdram_timing_ctrl_data_sample_phase; /* Data sample clock phase shift.                                                               */
	                                                                                /* 0..5: adjustable phase-shift for data sampling SDRAM loopback clock (clk_sdloopback)         */
	unsigned int reserved4         : BFW_NX500_sdram_timing_ctrl_reserved4;         /* reserved                                                                                     */
	unsigned int bypass_neg_delay  : BFW_NX500_sdram_timing_ctrl_bypass_neg_delay;  /* Bypass data sample clock phase shift.                                                        */
	                                                                                /* 0: use phase shifted (negative delayed) SDRAM loopback clock for data sampling.              */
	unsigned int reserved5         : BFW_NX500_sdram_timing_ctrl_reserved5;         /* reserved                                                                                     */
} NX500_SDRAM_TIMING_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_SDRAM_TIMING_CTRL_BIT_T bf;
} NX500_SDRAM_TIMING_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register sdram_mr */
/* => Mode Register for all SDRAM device types and Extended Mode Register for DDR/DDR2-SDRAM-devices. */
/*    Changes can only be done, if the SDRAM-Controller is disabled (sdram_general_ctrl.ctrl_en == 0) */
/*    to avoid configuration problems. */
/*    The SDRAM Mode Registers will be set after enabling the SDRAM Controller in the 200us */
/*    SDRAM memory initialisation procedure. */
/*    ---------------------------------------------------------- */
/*    No DDR/DDR2 support in netX! Don't regard DDR/DDR2 options */
/*    ---------------------------------------------------------- */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_sdram_mr            0x00000008U
#define Adr_NX500_ext_sdram_ctrl_sdram_mr 0x00100148U
#define Adr_NX500_sdram_mr                0x00100148U
#define DFLT_VAL_NX500_sdram_mr           0x00000033U

#define MSK_NX500_sdram_mr_MR       0x00003fffU
#define SRT_NX500_sdram_mr_MR       0
#define DFLT_VAL_NX500_sdram_mr_MR  0x00000033U
#define MSK_NX500_sdram_mr_EMR      0x3fff0000U
#define SRT_NX500_sdram_mr_EMR      16
#define DFLT_VAL_NX500_sdram_mr_EMR 0x00000000U

enum {
	BFW_NX500_sdram_mr_MR        = 14, /* [13:0] */
	BFW_NX500_sdram_mr_reserved1 = 2,  /* [15:14] */
	BFW_NX500_sdram_mr_EMR       = 14, /* [29:16] */
	BFW_NX500_sdram_mr_reserved2 = 2   /* [31:30] */
};

typedef struct NX500_SDRAM_MR_BIT_Ttag {
	unsigned int MR        : BFW_NX500_sdram_mr_MR;        /* SDRAM Mode Register.                                                                        */
	                                                       /* CAS latency bits in modereg[6:4], only CL2 and CL3 are supported, not CL1; default is CL3   */
	unsigned int reserved1 : BFW_NX500_sdram_mr_reserved1; /* reserved                                                                                    */
	unsigned int EMR       : BFW_NX500_sdram_mr_EMR;       /* Extended Mode Register for DDR/DDR2 - SDRAM devices                                         */
	                                                       /* The following settings must not be changed because tey are not supported by the Controller: */
	unsigned int reserved2 : BFW_NX500_sdram_mr_reserved2; /* reserved                                                                                    */
} NX500_SDRAM_MR_BIT_T;

typedef union {
	unsigned int         val;
	NX500_SDRAM_MR_BIT_T bf;
} NX500_SDRAM_MR_T;

/* --------------------------------------------------------------------- */
/* Register sdram_emr2 */
/* => Extended Mode Registers EMR2 and EMR3 for DDR2 - SDRAM devices. */
/*    Changes can only be done, if the SDRAM-Controller is disabled (sdram_general_ctrl.ctrl_en == 0) */
/*    to avoid configuration problems. */
/*    The SDRAM Mode Registers will be set after enabling the SDRAM Controller in the 200us */
/*    SDRAM memory initialisation procedure. */
/*    ---------------------------------------------------------- */
/*    No DDR/DDR2 support in netX! Don't regard DDR/DDR2 options */
/*    ---------------------------------------------------------- */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_sdram_emr2            0x0000000CU
#define Adr_NX500_ext_sdram_ctrl_sdram_emr2 0x0010014CU
#define Adr_NX500_sdram_emr2                0x0010014CU
#define DFLT_VAL_NX500_sdram_emr2           0x00000000U

#define MSK_NX500_sdram_emr2_EMR2      0x00003fffU
#define SRT_NX500_sdram_emr2_EMR2      0
#define DFLT_VAL_NX500_sdram_emr2_EMR2 0x00000000U
#define MSK_NX500_sdram_emr2_EMR3      0x3fff0000U
#define SRT_NX500_sdram_emr2_EMR3      16
#define DFLT_VAL_NX500_sdram_emr2_EMR3 0x00000000U

enum {
	BFW_NX500_sdram_emr2_EMR2      = 14, /* [13:0] */
	BFW_NX500_sdram_emr2_reserved1 = 2,  /* [15:14] */
	BFW_NX500_sdram_emr2_EMR3      = 14, /* [29:16] */
	BFW_NX500_sdram_emr2_reserved2 = 2   /* [31:30] */
};

typedef struct NX500_SDRAM_EMR2_BIT_Ttag {
	unsigned int EMR2      : BFW_NX500_sdram_emr2_EMR2;      /* Extended Mode Register 2 for DDR2 - SDRAM devices                            */
	                                                         /* For further extensions. No Settings must be done, which affect non supported */
	unsigned int reserved1 : BFW_NX500_sdram_emr2_reserved1; /* reserved                                                                     */
	unsigned int EMR3      : BFW_NX500_sdram_emr2_EMR3;      /* Extended Mode Register 3 for DDR2 - SDRAM devices                            */
	                                                         /* For further extensions. No Settings must be done, which affect non supported */
	unsigned int reserved2 : BFW_NX500_sdram_emr2_reserved2; /* reserved                                                                     */
} NX500_SDRAM_EMR2_BIT_T;

typedef union {
	unsigned int           val;
	NX500_SDRAM_EMR2_BIT_T bf;
} NX500_SDRAM_EMR2_T;


/* ===================================================================== */

/* Area of extmem_priority_ctrl */

/* ===================================================================== */

#define Addr_NX500_extmem_priority_ctrl 0x00100180U
#define NX500_NETX_MEM_PRIO_CTRL_AREA   0x00100180U

/* --------------------------------------------------------------------- */
/* Register extmem_prio_timslot_ctrl */
/* =>  Memory interface master timeslot priority control register. */
/*     This register may be partially locked by the exmem_priority_lock-register in asic_ctrl-address area. */
/*     Note: */
/*     Any master can access in one timeslot ((ts_accessrate_mX*ts_length_mX)/64) + 1 times (i.e. at */
/*     maximum (ts_accessrate_mX)/64 bandwidth on external memory bus, ts_accessrate_mX is programmed */
/*     by extmem_prio_accesstime_ctrl-register). */
/*     Priority control will watch data accesses on external memory data bus (SDRAM and non SDRAM), */
/*     including pauses on non SDRAM-accesses, not including control commands to SDRAM. */
/*     Any master requesting more accesses will be forced to wait for the remaining timeslot. */
/*    -------------------------------------------------------- */
/*     Programmable timeslots are: */
/*        ts_length =  0 :             64 systen clock cycles (i.e  0.64us at 100MHz) */
/*        ts_length =  1 :            128 systen clock cycles (i.e  1.28us at 100MHz) */
/*        ts_length =  2 :            256 systen clock cycles (i.e  2.56us at 100MHz) */
/*        ts_length =  3 :            512 systen clock cycles (i.e  5.12us at 100MHz) */
/*        ts_length =  4 :           1024 systen clock cycles (i.e 10.24us at 100MHz) */
/*        ts_length =  5 :           2048 systen clock cycles (i.e 20.48us at 100MHz) */
/*        ts_length =  6 :           4096 systen clock cycles (i.e 40.96us at 100MHz) */
/*        ts_length =  7 :           8192 systen clock cycles (i.e 81.92us at 100MHz) */
/*    -------------------------------------------------------- */
/*     master channel m0: Host Bus Interface  (highest priority) */
/*     master channel m1: XC */
/*     master channel m2: LCD-Controller */
/*     master channel m3: ARM instruction channel */
/*     master channel m4: ARM data channel  (lowest priority) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_extmem_prio_timslot_ctrl                  0x00000000U
#define Adr_NX500_extmem_priority_ctrl_extmem_prio_timslot_ctrl 0x00100180U
#define Adr_NX500_extmem_prio_timslot_ctrl                      0x00100180U
#define DFLT_VAL_NX500_extmem_prio_timslot_ctrl                 0x00077777U

#define MSK_NX500_extmem_prio_timslot_ctrl_ts_length_HIF_mi       0x00000007U
#define SRT_NX500_extmem_prio_timslot_ctrl_ts_length_HIF_mi       0
#define DFLT_VAL_NX500_extmem_prio_timslot_ctrl_ts_length_HIF_mi  0x00000007U
#define MSK_NX500_extmem_prio_timslot_ctrl_ts_length_XC_mi        0x00000070U
#define SRT_NX500_extmem_prio_timslot_ctrl_ts_length_XC_mi        4
#define DFLT_VAL_NX500_extmem_prio_timslot_ctrl_ts_length_XC_mi   0x00000070U
#define MSK_NX500_extmem_prio_timslot_ctrl_ts_length_LCD_mi       0x00000700U
#define SRT_NX500_extmem_prio_timslot_ctrl_ts_length_LCD_mi       8
#define DFLT_VAL_NX500_extmem_prio_timslot_ctrl_ts_length_LCD_mi  0x00000700U
#define MSK_NX500_extmem_prio_timslot_ctrl_ts_length_ARMI_mi      0x00007000U
#define SRT_NX500_extmem_prio_timslot_ctrl_ts_length_ARMI_mi      12
#define DFLT_VAL_NX500_extmem_prio_timslot_ctrl_ts_length_ARMI_mi 0x00007000U
#define MSK_NX500_extmem_prio_timslot_ctrl_ts_length_ARMD_mi      0x00070000U
#define SRT_NX500_extmem_prio_timslot_ctrl_ts_length_ARMD_mi      16
#define DFLT_VAL_NX500_extmem_prio_timslot_ctrl_ts_length_ARMD_mi 0x00070000U

enum {
	BFW_NX500_extmem_prio_timslot_ctrl_ts_length_HIF_mi  = 3,  /* [2:0] */
	BFW_NX500_extmem_prio_timslot_ctrl_reserved1         = 1,  /* [3] */
	BFW_NX500_extmem_prio_timslot_ctrl_ts_length_XC_mi   = 3,  /* [6:4] */
	BFW_NX500_extmem_prio_timslot_ctrl_reserved2         = 1,  /* [7] */
	BFW_NX500_extmem_prio_timslot_ctrl_ts_length_LCD_mi  = 3,  /* [10:8] */
	BFW_NX500_extmem_prio_timslot_ctrl_reserved3         = 1,  /* [11] */
	BFW_NX500_extmem_prio_timslot_ctrl_ts_length_ARMI_mi = 3,  /* [14:12] */
	BFW_NX500_extmem_prio_timslot_ctrl_reserved4         = 1,  /* [15] */
	BFW_NX500_extmem_prio_timslot_ctrl_ts_length_ARMD_mi = 3,  /* [18:16] */
	BFW_NX500_extmem_prio_timslot_ctrl_reserved5         = 13  /* [31:19] */
};

typedef struct NX500_EXTMEM_PRIO_TIMSLOT_CTRL_BIT_Ttag {
	unsigned int ts_length_HIF_mi  : BFW_NX500_extmem_prio_timslot_ctrl_ts_length_HIF_mi;  /* 0..7: the timeslot of master m0 is on external memory interface 64*2^ts_length_HIF_mi systen clock cycles  */
	unsigned int reserved1         : BFW_NX500_extmem_prio_timslot_ctrl_reserved1;         /* reserved                                                                                                   */
	unsigned int ts_length_XC_mi   : BFW_NX500_extmem_prio_timslot_ctrl_ts_length_XC_mi;   /* 0..7: the timeslot of master m1 is on external memory interface 64*2^ts_length_XC_mi systen clock cycles   */
	unsigned int reserved2         : BFW_NX500_extmem_prio_timslot_ctrl_reserved2;         /* reserved                                                                                                   */
	unsigned int ts_length_LCD_mi  : BFW_NX500_extmem_prio_timslot_ctrl_ts_length_LCD_mi;  /* 0..7: the timeslot of master m2 is on external memory interface 64*2^ts_length_LCD_mi systen clock cycles  */
	unsigned int reserved3         : BFW_NX500_extmem_prio_timslot_ctrl_reserved3;         /* reserved                                                                                                   */
	unsigned int ts_length_ARMI_mi : BFW_NX500_extmem_prio_timslot_ctrl_ts_length_ARMI_mi; /* 0..7: the timeslot of master m3 is on external memory interface 64*2^ts_length_ARMI_mi systen clock cycles */
	unsigned int reserved4         : BFW_NX500_extmem_prio_timslot_ctrl_reserved4;         /* reserved                                                                                                   */
	unsigned int ts_length_ARMD_mi : BFW_NX500_extmem_prio_timslot_ctrl_ts_length_ARMD_mi; /* 0..7: the timeslot of master m4 is on external memory interface 64*2^ts_length_ARMD_mi systen clock cycles */
	unsigned int reserved5         : BFW_NX500_extmem_prio_timslot_ctrl_reserved5;         /* reserved                                                                                                   */
} NX500_EXTMEM_PRIO_TIMSLOT_CTRL_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_EXTMEM_PRIO_TIMSLOT_CTRL_BIT_T bf;
} NX500_EXTMEM_PRIO_TIMSLOT_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register extmem_prio_accesstime_ctrl */
/* =>  Control Register for master channel accesses per timeslot on external meory interface. */
/*     This register may be partially locked by the exmem_priority_lock-register in asic_ctrl-address area. */
/*     For detailed priority controlling read note at extmem_prio_timslot_ctrl-register description. */
/*    -------------------------------------------------------- */
/*     master channel m0: Host Bus Interface  (highest priority) */
/*     master channel m1: XC */
/*     master channel m2: LCD-Controller */
/*     master channel m3: ARM instruction channel */
/*     master channel m4: ARM data channel  (lowest priority) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_extmem_prio_accesstime_ctrl                  0x00000004U
#define Adr_NX500_extmem_priority_ctrl_extmem_prio_accesstime_ctrl 0x00100184U
#define Adr_NX500_extmem_prio_accesstime_ctrl                      0x00100184U
#define DFLT_VAL_NX500_extmem_prio_accesstime_ctrl                 0x3fffffffU

#define MSK_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_HIF_mi       0x0000003fU
#define SRT_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_HIF_mi       0
#define DFLT_VAL_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_HIF_mi  0x0000003fU
#define MSK_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_XC_mi        0x00000fc0U
#define SRT_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_XC_mi        6
#define DFLT_VAL_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_XC_mi   0x00000fc0U
#define MSK_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_LCD_mi       0x0003f000U
#define SRT_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_LCD_mi       12
#define DFLT_VAL_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_LCD_mi  0x0003f000U
#define MSK_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_ARMI_mi      0x00fc0000U
#define SRT_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_ARMI_mi      18
#define DFLT_VAL_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_ARMI_mi 0x00fc0000U
#define MSK_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_ARMD_mi      0x3f000000U
#define SRT_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_ARMD_mi      24
#define DFLT_VAL_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_ARMD_mi 0x3f000000U

enum {
	BFW_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_HIF_mi  = 6, /* [5:0] */
	BFW_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_XC_mi   = 6, /* [11:6] */
	BFW_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_LCD_mi  = 6, /* [17:12] */
	BFW_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_ARMI_mi = 6, /* [23:18] */
	BFW_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_ARMD_mi = 6, /* [29:24] */
	BFW_NX500_extmem_prio_accesstime_ctrl_reserved1             = 2  /* [31:30] */
};

typedef struct NX500_EXTMEM_PRIO_ACCESSTIME_CTRL_BIT_Ttag {
	unsigned int ts_accessrate_HIF_mi  : BFW_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_HIF_mi;  /* 0..63: master m0 is alowed to request ((ts_accessrate_HIF_mi*ts_length_HIF_mi)/64) + 1 accesses on external memory   */
	unsigned int ts_accessrate_XC_mi   : BFW_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_XC_mi;   /* 0..63: master m1 is alowed to request ((ts_accessrate_XC_mi*ts_length_XC_mi)/64) + 1 accesses on external memory     */
	unsigned int ts_accessrate_LCD_mi  : BFW_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_LCD_mi;  /* 0..63: master m2 is alowed to request ((ts_accessrate_LCD_mi*ts_length_LCD_mi)/64) + 1 accesses on external memory   */
	unsigned int ts_accessrate_ARMI_mi : BFW_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_ARMI_mi; /* 0..63: master m3 is alowed to request ((ts_accessrate_ARMI_mi*ts_length_ARMI_mi)/64) + 1 accesses on external memory */
	unsigned int ts_accessrate_ARMD_mi : BFW_NX500_extmem_prio_accesstime_ctrl_ts_accessrate_ARMD_mi; /* 0..63: master m4 is alowed to request ((ts_accessrate_ARMD_mi*ts_length_ARMD_mi)/64) + 1 accesses on external memory */
	unsigned int reserved1             : BFW_NX500_extmem_prio_accesstime_ctrl_reserved1;             /* reserved                                                                                                             */
} NX500_EXTMEM_PRIO_ACCESSTIME_CTRL_BIT_T;

typedef union {
	unsigned int                            val;
	NX500_EXTMEM_PRIO_ACCESSTIME_CTRL_BIT_T bf;
} NX500_EXTMEM_PRIO_ACCESSTIME_CTRL_T;


/* ===================================================================== */

/* Area of watchdog */

/* ===================================================================== */

#define Addr_NX500_watchdog 0x00100200U
#define NX500_NETX_WDG_AREA 0x00100200U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl */
/* => netX System Watchdog Trigger Register. */
/*    The watchdog access code is generated by a pseudo random generator. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_ctrl      0x00000000U
#define Adr_NX500_watchdog_netx_sys_wdg_ctrl 0x00100200U
#define Adr_NX500_netx_sys_wdg_ctrl          0x00100200U
#define DFLT_VAL_NX500_netx_sys_wdg_ctrl     0x00000000U

#define MSK_NX500_netx_sys_wdg_ctrl_wdg_access_code            0x000fffffU
#define SRT_NX500_netx_sys_wdg_ctrl_wdg_access_code            0
#define DFLT_VAL_NX500_netx_sys_wdg_ctrl_wdg_access_code       0x00000000U
#define MSK_NX500_netx_sys_wdg_ctrl_irq_req_watchdog           0x01000000U
#define SRT_NX500_netx_sys_wdg_ctrl_irq_req_watchdog           24
#define DFLT_VAL_NX500_netx_sys_wdg_ctrl_irq_req_watchdog      0x00000000U
#define MSK_NX500_netx_sys_wdg_ctrl_wdg_counter_trigger_w      0x10000000U
#define SRT_NX500_netx_sys_wdg_ctrl_wdg_counter_trigger_w      28
#define DFLT_VAL_NX500_netx_sys_wdg_ctrl_wdg_counter_trigger_w 0x00000000U
#define MSK_NX500_netx_sys_wdg_ctrl_wdg_active_enable_w        0x20000000U
#define SRT_NX500_netx_sys_wdg_ctrl_wdg_active_enable_w        29
#define DFLT_VAL_NX500_netx_sys_wdg_ctrl_wdg_active_enable_w   0x00000000U
#define MSK_NX500_netx_sys_wdg_ctrl_write_enable               0x80000000U
#define SRT_NX500_netx_sys_wdg_ctrl_write_enable               31
#define DFLT_VAL_NX500_netx_sys_wdg_ctrl_write_enable          0x00000000U

enum {
	BFW_NX500_netx_sys_wdg_ctrl_wdg_access_code       = 20, /* [19:0] */
	BFW_NX500_netx_sys_wdg_ctrl_reserved1             = 4,  /* [23:20] */
	BFW_NX500_netx_sys_wdg_ctrl_irq_req_watchdog      = 1,  /* [24] */
	BFW_NX500_netx_sys_wdg_ctrl_reserved2             = 3,  /* [27:25] */
	BFW_NX500_netx_sys_wdg_ctrl_wdg_counter_trigger_w = 1,  /* [28] */
	BFW_NX500_netx_sys_wdg_ctrl_wdg_active_enable_w   = 1,  /* [29] */
	BFW_NX500_netx_sys_wdg_ctrl_reserved3             = 1,  /* [30] */
	BFW_NX500_netx_sys_wdg_ctrl_write_enable          = 1   /* [31] */
};

typedef struct NX500_NETX_SYS_WDG_CTRL_BIT_Ttag {
	unsigned int wdg_access_code       : BFW_NX500_netx_sys_wdg_ctrl_wdg_access_code;       /* Watchdog access code for triggering. A read access gives the next 16 bit code for trigger. */
	                                                                                        /* A write access with correct access code will trigger the watchdog counter.                 */
	unsigned int reserved1             : BFW_NX500_netx_sys_wdg_ctrl_reserved1;             /* reserved                                                                                   */
	unsigned int irq_req_watchdog      : BFW_NX500_netx_sys_wdg_ctrl_irq_req_watchdog;      /* IRQ request of watchdog, writing 1 deletes IRQ                                             */
	unsigned int reserved2             : BFW_NX500_netx_sys_wdg_ctrl_reserved2;             /* reserved                                                                                   */
	unsigned int wdg_counter_trigger_w : BFW_NX500_netx_sys_wdg_ctrl_wdg_counter_trigger_w; /* ???, write only register bit                                                               */
	unsigned int wdg_active_enable_w   : BFW_NX500_netx_sys_wdg_ctrl_wdg_active_enable_w;   /* ???, write only register bit                                                               */
	unsigned int reserved3             : BFW_NX500_netx_sys_wdg_ctrl_reserved3;             /* reserved                                                                                   */
	unsigned int write_enable          : BFW_NX500_netx_sys_wdg_ctrl_write_enable;          /* ???                                                                                        */
} NX500_NETX_SYS_WDG_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_NETX_SYS_WDG_CTRL_BIT_T bf;
} NX500_NETX_SYS_WDG_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg */
/* => netX System Watchdog Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg      0x00000004U
#define Adr_NX500_watchdog_netx_sys_wdg 0x00100204U
#define Adr_NX500_netx_sys_wdg          0x00100204U

#define MSK_NX500_netx_sys_wdg_wdg_counter 0x0001ffffU
#define SRT_NX500_netx_sys_wdg_wdg_counter 0

enum {
	BFW_NX500_netx_sys_wdg_wdg_counter = 17, /* [16:0] */
	BFW_NX500_netx_sys_wdg_reserved1   = 15  /* [31:17] */
};

typedef struct NX500_NETX_SYS_WDG_BIT_Ttag {
	unsigned int wdg_counter : BFW_NX500_netx_sys_wdg_wdg_counter; /* Actual watchdog counter value */
	unsigned int reserved1   : BFW_NX500_netx_sys_wdg_reserved1;   /* reserved                      */
} NX500_NETX_SYS_WDG_BIT_T;

typedef union {
	unsigned int             val;
	NX500_NETX_SYS_WDG_BIT_T bf;
} NX500_NETX_SYS_WDG_T;

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout */
/* => netX System Wachtdog Interrupt Timout Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_irq_timeout      0x00000008U
#define Adr_NX500_watchdog_netx_sys_wdg_irq_timeout 0x00100208U
#define Adr_NX500_netx_sys_wdg_irq_timeout          0x00100208U
#define DFLT_VAL_NX500_netx_sys_wdg_irq_timeout     0x00000000U

#define MSK_NX500_netx_sys_wdg_irq_timeout_wdg_irq_timeout      0x0000ffffU
#define SRT_NX500_netx_sys_wdg_irq_timeout_wdg_irq_timeout      0
#define DFLT_VAL_NX500_netx_sys_wdg_irq_timeout_wdg_irq_timeout 0x00000000U

enum {
	BFW_NX500_netx_sys_wdg_irq_timeout_wdg_irq_timeout = 16, /* [15:0] */
	BFW_NX500_netx_sys_wdg_irq_timeout_reserved1       = 16  /* [31:16] */
};

typedef struct NX500_NETX_SYS_WDG_IRQ_TIMEOUT_BIT_Ttag {
	unsigned int wdg_irq_timeout : BFW_NX500_netx_sys_wdg_irq_timeout_wdg_irq_timeout; /* Watchdog interrupt timeout */
	unsigned int reserved1       : BFW_NX500_netx_sys_wdg_irq_timeout_reserved1;       /* reserved                   */
} NX500_NETX_SYS_WDG_IRQ_TIMEOUT_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_NETX_SYS_WDG_IRQ_TIMEOUT_BIT_T bf;
} NX500_NETX_SYS_WDG_IRQ_TIMEOUT_T;

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout */
/* => netX System Watchdog Reset Timeout Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_res_timeout      0x0000000CU
#define Adr_NX500_watchdog_netx_sys_wdg_res_timeout 0x0010020CU
#define Adr_NX500_netx_sys_wdg_res_timeout          0x0010020CU
#define DFLT_VAL_NX500_netx_sys_wdg_res_timeout     0x00000000U

#define MSK_NX500_netx_sys_wdg_res_timeout_wdg_res_timeout      0x0000ffffU
#define SRT_NX500_netx_sys_wdg_res_timeout_wdg_res_timeout      0
#define DFLT_VAL_NX500_netx_sys_wdg_res_timeout_wdg_res_timeout 0x00000000U

enum {
	BFW_NX500_netx_sys_wdg_res_timeout_wdg_res_timeout = 16, /* [15:0] */
	BFW_NX500_netx_sys_wdg_res_timeout_reserved1       = 16  /* [31:16] */
};

typedef struct NX500_NETX_SYS_WDG_RES_TIMEOUT_BIT_Ttag {
	unsigned int wdg_res_timeout : BFW_NX500_netx_sys_wdg_res_timeout_wdg_res_timeout; /* Watchdog Reset Request Timeout */
	unsigned int reserved1       : BFW_NX500_netx_sys_wdg_res_timeout_reserved1;       /* reserved                       */
} NX500_NETX_SYS_WDG_RES_TIMEOUT_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_NETX_SYS_WDG_RES_TIMEOUT_BIT_T bf;
} NX500_NETX_SYS_WDG_RES_TIMEOUT_T;

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror1 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_ctrl_mirror1      0x00000010U
#define Adr_NX500_watchdog_netx_sys_wdg_ctrl_mirror1 0x00100210U
#define Adr_NX500_netx_sys_wdg_ctrl_mirror1          0x00100210U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror1 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_mirror1      0x00000014U
#define Adr_NX500_watchdog_netx_sys_wdg_mirror1 0x00100214U
#define Adr_NX500_netx_sys_wdg_mirror1          0x00100214U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror1 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_irq_timeout_mirror1      0x00000018U
#define Adr_NX500_watchdog_netx_sys_wdg_irq_timeout_mirror1 0x00100218U
#define Adr_NX500_netx_sys_wdg_irq_timeout_mirror1          0x00100218U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror1 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_res_timeout_mirror1      0x0000001CU
#define Adr_NX500_watchdog_netx_sys_wdg_res_timeout_mirror1 0x0010021CU
#define Adr_NX500_netx_sys_wdg_res_timeout_mirror1          0x0010021CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror2 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_ctrl_mirror2      0x00000020U
#define Adr_NX500_watchdog_netx_sys_wdg_ctrl_mirror2 0x00100220U
#define Adr_NX500_netx_sys_wdg_ctrl_mirror2          0x00100220U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror2 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_mirror2      0x00000024U
#define Adr_NX500_watchdog_netx_sys_wdg_mirror2 0x00100224U
#define Adr_NX500_netx_sys_wdg_mirror2          0x00100224U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror2 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_irq_timeout_mirror2      0x00000028U
#define Adr_NX500_watchdog_netx_sys_wdg_irq_timeout_mirror2 0x00100228U
#define Adr_NX500_netx_sys_wdg_irq_timeout_mirror2          0x00100228U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror2 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_res_timeout_mirror2      0x0000002CU
#define Adr_NX500_watchdog_netx_sys_wdg_res_timeout_mirror2 0x0010022CU
#define Adr_NX500_netx_sys_wdg_res_timeout_mirror2          0x0010022CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror3 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_ctrl_mirror3      0x00000030U
#define Adr_NX500_watchdog_netx_sys_wdg_ctrl_mirror3 0x00100230U
#define Adr_NX500_netx_sys_wdg_ctrl_mirror3          0x00100230U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror3 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_mirror3      0x00000034U
#define Adr_NX500_watchdog_netx_sys_wdg_mirror3 0x00100234U
#define Adr_NX500_netx_sys_wdg_mirror3          0x00100234U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror3 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_irq_timeout_mirror3      0x00000038U
#define Adr_NX500_watchdog_netx_sys_wdg_irq_timeout_mirror3 0x00100238U
#define Adr_NX500_netx_sys_wdg_irq_timeout_mirror3          0x00100238U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror3 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_res_timeout_mirror3      0x0000003CU
#define Adr_NX500_watchdog_netx_sys_wdg_res_timeout_mirror3 0x0010023CU
#define Adr_NX500_netx_sys_wdg_res_timeout_mirror3          0x0010023CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror4 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_ctrl_mirror4      0x00000040U
#define Adr_NX500_watchdog_netx_sys_wdg_ctrl_mirror4 0x00100240U
#define Adr_NX500_netx_sys_wdg_ctrl_mirror4          0x00100240U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror4 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_mirror4      0x00000044U
#define Adr_NX500_watchdog_netx_sys_wdg_mirror4 0x00100244U
#define Adr_NX500_netx_sys_wdg_mirror4          0x00100244U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror4 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_irq_timeout_mirror4      0x00000048U
#define Adr_NX500_watchdog_netx_sys_wdg_irq_timeout_mirror4 0x00100248U
#define Adr_NX500_netx_sys_wdg_irq_timeout_mirror4          0x00100248U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror4 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_res_timeout_mirror4      0x0000004CU
#define Adr_NX500_watchdog_netx_sys_wdg_res_timeout_mirror4 0x0010024CU
#define Adr_NX500_netx_sys_wdg_res_timeout_mirror4          0x0010024CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror5 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_ctrl_mirror5      0x00000050U
#define Adr_NX500_watchdog_netx_sys_wdg_ctrl_mirror5 0x00100250U
#define Adr_NX500_netx_sys_wdg_ctrl_mirror5          0x00100250U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror5 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_mirror5      0x00000054U
#define Adr_NX500_watchdog_netx_sys_wdg_mirror5 0x00100254U
#define Adr_NX500_netx_sys_wdg_mirror5          0x00100254U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror5 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_irq_timeout_mirror5      0x00000058U
#define Adr_NX500_watchdog_netx_sys_wdg_irq_timeout_mirror5 0x00100258U
#define Adr_NX500_netx_sys_wdg_irq_timeout_mirror5          0x00100258U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror5 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_res_timeout_mirror5      0x0000005CU
#define Adr_NX500_watchdog_netx_sys_wdg_res_timeout_mirror5 0x0010025CU
#define Adr_NX500_netx_sys_wdg_res_timeout_mirror5          0x0010025CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror6 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_ctrl_mirror6      0x00000060U
#define Adr_NX500_watchdog_netx_sys_wdg_ctrl_mirror6 0x00100260U
#define Adr_NX500_netx_sys_wdg_ctrl_mirror6          0x00100260U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror6 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_mirror6      0x00000064U
#define Adr_NX500_watchdog_netx_sys_wdg_mirror6 0x00100264U
#define Adr_NX500_netx_sys_wdg_mirror6          0x00100264U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror6 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_irq_timeout_mirror6      0x00000068U
#define Adr_NX500_watchdog_netx_sys_wdg_irq_timeout_mirror6 0x00100268U
#define Adr_NX500_netx_sys_wdg_irq_timeout_mirror6          0x00100268U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror6 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_res_timeout_mirror6      0x0000006CU
#define Adr_NX500_watchdog_netx_sys_wdg_res_timeout_mirror6 0x0010026CU
#define Adr_NX500_netx_sys_wdg_res_timeout_mirror6          0x0010026CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror7 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_ctrl_mirror7      0x00000070U
#define Adr_NX500_watchdog_netx_sys_wdg_ctrl_mirror7 0x00100270U
#define Adr_NX500_netx_sys_wdg_ctrl_mirror7          0x00100270U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror7 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_mirror7      0x00000074U
#define Adr_NX500_watchdog_netx_sys_wdg_mirror7 0x00100274U
#define Adr_NX500_netx_sys_wdg_mirror7          0x00100274U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror7 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_irq_timeout_mirror7      0x00000078U
#define Adr_NX500_watchdog_netx_sys_wdg_irq_timeout_mirror7 0x00100278U
#define Adr_NX500_netx_sys_wdg_irq_timeout_mirror7          0x00100278U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror7 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_res_timeout_mirror7      0x0000007CU
#define Adr_NX500_watchdog_netx_sys_wdg_res_timeout_mirror7 0x0010027CU
#define Adr_NX500_netx_sys_wdg_res_timeout_mirror7          0x0010027CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror8 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_ctrl_mirror8      0x00000080U
#define Adr_NX500_watchdog_netx_sys_wdg_ctrl_mirror8 0x00100280U
#define Adr_NX500_netx_sys_wdg_ctrl_mirror8          0x00100280U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror8 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_mirror8      0x00000084U
#define Adr_NX500_watchdog_netx_sys_wdg_mirror8 0x00100284U
#define Adr_NX500_netx_sys_wdg_mirror8          0x00100284U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror8 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_irq_timeout_mirror8      0x00000088U
#define Adr_NX500_watchdog_netx_sys_wdg_irq_timeout_mirror8 0x00100288U
#define Adr_NX500_netx_sys_wdg_irq_timeout_mirror8          0x00100288U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror8 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_res_timeout_mirror8      0x0000008CU
#define Adr_NX500_watchdog_netx_sys_wdg_res_timeout_mirror8 0x0010028CU
#define Adr_NX500_netx_sys_wdg_res_timeout_mirror8          0x0010028CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror9 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_ctrl_mirror9      0x00000090U
#define Adr_NX500_watchdog_netx_sys_wdg_ctrl_mirror9 0x00100290U
#define Adr_NX500_netx_sys_wdg_ctrl_mirror9          0x00100290U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror9 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_mirror9      0x00000094U
#define Adr_NX500_watchdog_netx_sys_wdg_mirror9 0x00100294U
#define Adr_NX500_netx_sys_wdg_mirror9          0x00100294U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror9 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_irq_timeout_mirror9      0x00000098U
#define Adr_NX500_watchdog_netx_sys_wdg_irq_timeout_mirror9 0x00100298U
#define Adr_NX500_netx_sys_wdg_irq_timeout_mirror9          0x00100298U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror9 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_res_timeout_mirror9      0x0000009CU
#define Adr_NX500_watchdog_netx_sys_wdg_res_timeout_mirror9 0x0010029CU
#define Adr_NX500_netx_sys_wdg_res_timeout_mirror9          0x0010029CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror10 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_ctrl_mirror10      0x000000A0U
#define Adr_NX500_watchdog_netx_sys_wdg_ctrl_mirror10 0x001002A0U
#define Adr_NX500_netx_sys_wdg_ctrl_mirror10          0x001002A0U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror10 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_mirror10      0x000000A4U
#define Adr_NX500_watchdog_netx_sys_wdg_mirror10 0x001002A4U
#define Adr_NX500_netx_sys_wdg_mirror10          0x001002A4U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror10 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_irq_timeout_mirror10      0x000000A8U
#define Adr_NX500_watchdog_netx_sys_wdg_irq_timeout_mirror10 0x001002A8U
#define Adr_NX500_netx_sys_wdg_irq_timeout_mirror10          0x001002A8U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror10 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_res_timeout_mirror10      0x000000ACU
#define Adr_NX500_watchdog_netx_sys_wdg_res_timeout_mirror10 0x001002ACU
#define Adr_NX500_netx_sys_wdg_res_timeout_mirror10          0x001002ACU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror11 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_ctrl_mirror11      0x000000B0U
#define Adr_NX500_watchdog_netx_sys_wdg_ctrl_mirror11 0x001002B0U
#define Adr_NX500_netx_sys_wdg_ctrl_mirror11          0x001002B0U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror11 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_mirror11      0x000000B4U
#define Adr_NX500_watchdog_netx_sys_wdg_mirror11 0x001002B4U
#define Adr_NX500_netx_sys_wdg_mirror11          0x001002B4U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror11 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_irq_timeout_mirror11      0x000000B8U
#define Adr_NX500_watchdog_netx_sys_wdg_irq_timeout_mirror11 0x001002B8U
#define Adr_NX500_netx_sys_wdg_irq_timeout_mirror11          0x001002B8U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror11 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_res_timeout_mirror11      0x000000BCU
#define Adr_NX500_watchdog_netx_sys_wdg_res_timeout_mirror11 0x001002BCU
#define Adr_NX500_netx_sys_wdg_res_timeout_mirror11          0x001002BCU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror12 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_ctrl_mirror12      0x000000C0U
#define Adr_NX500_watchdog_netx_sys_wdg_ctrl_mirror12 0x001002C0U
#define Adr_NX500_netx_sys_wdg_ctrl_mirror12          0x001002C0U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror12 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_mirror12      0x000000C4U
#define Adr_NX500_watchdog_netx_sys_wdg_mirror12 0x001002C4U
#define Adr_NX500_netx_sys_wdg_mirror12          0x001002C4U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror12 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_irq_timeout_mirror12      0x000000C8U
#define Adr_NX500_watchdog_netx_sys_wdg_irq_timeout_mirror12 0x001002C8U
#define Adr_NX500_netx_sys_wdg_irq_timeout_mirror12          0x001002C8U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror12 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_res_timeout_mirror12      0x000000CCU
#define Adr_NX500_watchdog_netx_sys_wdg_res_timeout_mirror12 0x001002CCU
#define Adr_NX500_netx_sys_wdg_res_timeout_mirror12          0x001002CCU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror13 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_ctrl_mirror13      0x000000D0U
#define Adr_NX500_watchdog_netx_sys_wdg_ctrl_mirror13 0x001002D0U
#define Adr_NX500_netx_sys_wdg_ctrl_mirror13          0x001002D0U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror13 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_mirror13      0x000000D4U
#define Adr_NX500_watchdog_netx_sys_wdg_mirror13 0x001002D4U
#define Adr_NX500_netx_sys_wdg_mirror13          0x001002D4U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror13 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_irq_timeout_mirror13      0x000000D8U
#define Adr_NX500_watchdog_netx_sys_wdg_irq_timeout_mirror13 0x001002D8U
#define Adr_NX500_netx_sys_wdg_irq_timeout_mirror13          0x001002D8U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror13 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_res_timeout_mirror13      0x000000DCU
#define Adr_NX500_watchdog_netx_sys_wdg_res_timeout_mirror13 0x001002DCU
#define Adr_NX500_netx_sys_wdg_res_timeout_mirror13          0x001002DCU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror14 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_ctrl_mirror14      0x000000E0U
#define Adr_NX500_watchdog_netx_sys_wdg_ctrl_mirror14 0x001002E0U
#define Adr_NX500_netx_sys_wdg_ctrl_mirror14          0x001002E0U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror14 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_mirror14      0x000000E4U
#define Adr_NX500_watchdog_netx_sys_wdg_mirror14 0x001002E4U
#define Adr_NX500_netx_sys_wdg_mirror14          0x001002E4U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror14 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_irq_timeout_mirror14      0x000000E8U
#define Adr_NX500_watchdog_netx_sys_wdg_irq_timeout_mirror14 0x001002E8U
#define Adr_NX500_netx_sys_wdg_irq_timeout_mirror14          0x001002E8U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror14 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_res_timeout_mirror14      0x000000ECU
#define Adr_NX500_watchdog_netx_sys_wdg_res_timeout_mirror14 0x001002ECU
#define Adr_NX500_netx_sys_wdg_res_timeout_mirror14          0x001002ECU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror15 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_ctrl_mirror15      0x000000F0U
#define Adr_NX500_watchdog_netx_sys_wdg_ctrl_mirror15 0x001002F0U
#define Adr_NX500_netx_sys_wdg_ctrl_mirror15          0x001002F0U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror15 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_mirror15      0x000000F4U
#define Adr_NX500_watchdog_netx_sys_wdg_mirror15 0x001002F4U
#define Adr_NX500_netx_sys_wdg_mirror15          0x001002F4U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror15 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_irq_timeout_mirror15      0x000000F8U
#define Adr_NX500_watchdog_netx_sys_wdg_irq_timeout_mirror15 0x001002F8U
#define Adr_NX500_netx_sys_wdg_irq_timeout_mirror15          0x001002F8U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror15 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_netx_sys_wdg_res_timeout_mirror15      0x000000FCU
#define Adr_NX500_watchdog_netx_sys_wdg_res_timeout_mirror15 0x001002FCU
#define Adr_NX500_netx_sys_wdg_res_timeout_mirror15          0x001002FCU


/* ===================================================================== */

/* Area of abort */

/* ===================================================================== */

#define Addr_NX500_abort      0x00100300U
#define NX500_NETX_ABORT_AREA 0x00100300U

/* ===================================================================== */

/* Area of gpio */

/* ===================================================================== */

#define Addr_NX500_gpio      0x00100800U
#define NX500_NETX_GPIO_AREA 0x00100800U

/* --------------------------------------------------------------------- */
/* Register gpio_cfg0 */
/* => GPIO pin 0 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_cfg0  0x00000000U
#define Adr_NX500_gpio_gpio_cfg0 0x00100800U
#define Adr_NX500_gpio_cfg0      0x00100800U
#define DFLT_VAL_NX500_gpio_cfg0 0x00000000U

#define MSK_NX500_gpio_cfg0_iocfg          0x00000003U
#define SRT_NX500_gpio_cfg0_iocfg          0
#define DFLT_VAL_NX500_gpio_cfg0_iocfg     0x00000000U
#define MSK_NX500_gpio_cfg0_inv            0x00000004U
#define SRT_NX500_gpio_cfg0_inv            2
#define DFLT_VAL_NX500_gpio_cfg0_inv       0x00000000U
#define MSK_NX500_gpio_cfg0_mode           0x00000018U
#define SRT_NX500_gpio_cfg0_mode           3
#define DFLT_VAL_NX500_gpio_cfg0_mode      0x00000000U
#define MSK_NX500_gpio_cfg0_count_ref      0x000000e0U
#define SRT_NX500_gpio_cfg0_count_ref      5
#define DFLT_VAL_NX500_gpio_cfg0_count_ref 0x00000000U

enum {
	BFW_NX500_gpio_cfg0_iocfg     = 2,  /* [1:0] */
	BFW_NX500_gpio_cfg0_inv       = 1,  /* [2] */
	BFW_NX500_gpio_cfg0_mode      = 2,  /* [4:3] */
	BFW_NX500_gpio_cfg0_count_ref = 3,  /* [7:5] */
	BFW_NX500_gpio_cfg0_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_GPIO_CFG0_BIT_Ttag {
	unsigned int iocfg     : BFW_NX500_gpio_cfg0_iocfg;     /* defines the input/output configuration                 */
	                                                        /* 00 : gp input mode                                     */
	unsigned int inv       : BFW_NX500_gpio_cfg0_inv;       /* 0 : don't invert, 1 : invert input/output value        */
	unsigned int mode      : BFW_NX500_gpio_cfg0_mode;      /* defines the gp input or output mode - depends on iocfg */
	                                                        /* gp input modi :                                        */
	unsigned int count_ref : BFW_NX500_gpio_cfg0_count_ref; /* counter reference                                      */
	                                                        /* 000 : counter 0                                        */
	unsigned int reserved1 : BFW_NX500_gpio_cfg0_reserved1; /* reserved                                               */
} NX500_GPIO_CFG0_BIT_T;

typedef union {
	unsigned int          val;
	NX500_GPIO_CFG0_BIT_T bf;
} NX500_GPIO_CFG0_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg1 */
/* => GPIO pin 1 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_cfg1  0x00000004U
#define Adr_NX500_gpio_gpio_cfg1 0x00100804U
#define Adr_NX500_gpio_cfg1      0x00100804U
#define DFLT_VAL_NX500_gpio_cfg1 0x00000000U

#define MSK_NX500_gpio_cfg1_iocfg          0x00000003U
#define SRT_NX500_gpio_cfg1_iocfg          0
#define DFLT_VAL_NX500_gpio_cfg1_iocfg     0x00000000U
#define MSK_NX500_gpio_cfg1_inv            0x00000004U
#define SRT_NX500_gpio_cfg1_inv            2
#define DFLT_VAL_NX500_gpio_cfg1_inv       0x00000000U
#define MSK_NX500_gpio_cfg1_mode           0x00000018U
#define SRT_NX500_gpio_cfg1_mode           3
#define DFLT_VAL_NX500_gpio_cfg1_mode      0x00000000U
#define MSK_NX500_gpio_cfg1_count_ref      0x000000e0U
#define SRT_NX500_gpio_cfg1_count_ref      5
#define DFLT_VAL_NX500_gpio_cfg1_count_ref 0x00000000U

enum {
	BFW_NX500_gpio_cfg1_iocfg     = 2,  /* [1:0] */
	BFW_NX500_gpio_cfg1_inv       = 1,  /* [2] */
	BFW_NX500_gpio_cfg1_mode      = 2,  /* [4:3] */
	BFW_NX500_gpio_cfg1_count_ref = 3,  /* [7:5] */
	BFW_NX500_gpio_cfg1_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_GPIO_CFG1_BIT_Ttag {
	unsigned int iocfg     : BFW_NX500_gpio_cfg1_iocfg;     /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX500_gpio_cfg1_inv;       /* analog to gpio_cfg0 */
	unsigned int mode      : BFW_NX500_gpio_cfg1_mode;      /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX500_gpio_cfg1_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX500_gpio_cfg1_reserved1; /* reserved            */
} NX500_GPIO_CFG1_BIT_T;

typedef union {
	unsigned int          val;
	NX500_GPIO_CFG1_BIT_T bf;
} NX500_GPIO_CFG1_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg2 */
/* => GPIO pin 2 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_cfg2  0x00000008U
#define Adr_NX500_gpio_gpio_cfg2 0x00100808U
#define Adr_NX500_gpio_cfg2      0x00100808U
#define DFLT_VAL_NX500_gpio_cfg2 0x00000000U

#define MSK_NX500_gpio_cfg2_iocfg          0x00000003U
#define SRT_NX500_gpio_cfg2_iocfg          0
#define DFLT_VAL_NX500_gpio_cfg2_iocfg     0x00000000U
#define MSK_NX500_gpio_cfg2_inv            0x00000004U
#define SRT_NX500_gpio_cfg2_inv            2
#define DFLT_VAL_NX500_gpio_cfg2_inv       0x00000000U
#define MSK_NX500_gpio_cfg2_mode           0x00000018U
#define SRT_NX500_gpio_cfg2_mode           3
#define DFLT_VAL_NX500_gpio_cfg2_mode      0x00000000U
#define MSK_NX500_gpio_cfg2_count_ref      0x000000e0U
#define SRT_NX500_gpio_cfg2_count_ref      5
#define DFLT_VAL_NX500_gpio_cfg2_count_ref 0x00000000U

enum {
	BFW_NX500_gpio_cfg2_iocfg     = 2,  /* [1:0] */
	BFW_NX500_gpio_cfg2_inv       = 1,  /* [2] */
	BFW_NX500_gpio_cfg2_mode      = 2,  /* [4:3] */
	BFW_NX500_gpio_cfg2_count_ref = 3,  /* [7:5] */
	BFW_NX500_gpio_cfg2_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_GPIO_CFG2_BIT_Ttag {
	unsigned int iocfg     : BFW_NX500_gpio_cfg2_iocfg;     /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX500_gpio_cfg2_inv;       /* analog to gpio_cfg0 */
	unsigned int mode      : BFW_NX500_gpio_cfg2_mode;      /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX500_gpio_cfg2_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX500_gpio_cfg2_reserved1; /* reserved            */
} NX500_GPIO_CFG2_BIT_T;

typedef union {
	unsigned int          val;
	NX500_GPIO_CFG2_BIT_T bf;
} NX500_GPIO_CFG2_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg3 */
/* => GPIO pin 3 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_cfg3  0x0000000CU
#define Adr_NX500_gpio_gpio_cfg3 0x0010080CU
#define Adr_NX500_gpio_cfg3      0x0010080CU
#define DFLT_VAL_NX500_gpio_cfg3 0x00000000U

#define MSK_NX500_gpio_cfg3_iocfg          0x00000003U
#define SRT_NX500_gpio_cfg3_iocfg          0
#define DFLT_VAL_NX500_gpio_cfg3_iocfg     0x00000000U
#define MSK_NX500_gpio_cfg3_inv            0x00000004U
#define SRT_NX500_gpio_cfg3_inv            2
#define DFLT_VAL_NX500_gpio_cfg3_inv       0x00000000U
#define MSK_NX500_gpio_cfg3_mode           0x00000018U
#define SRT_NX500_gpio_cfg3_mode           3
#define DFLT_VAL_NX500_gpio_cfg3_mode      0x00000000U
#define MSK_NX500_gpio_cfg3_count_ref      0x000000e0U
#define SRT_NX500_gpio_cfg3_count_ref      5
#define DFLT_VAL_NX500_gpio_cfg3_count_ref 0x00000000U

enum {
	BFW_NX500_gpio_cfg3_iocfg     = 2,  /* [1:0] */
	BFW_NX500_gpio_cfg3_inv       = 1,  /* [2] */
	BFW_NX500_gpio_cfg3_mode      = 2,  /* [4:3] */
	BFW_NX500_gpio_cfg3_count_ref = 3,  /* [7:5] */
	BFW_NX500_gpio_cfg3_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_GPIO_CFG3_BIT_Ttag {
	unsigned int iocfg     : BFW_NX500_gpio_cfg3_iocfg;     /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX500_gpio_cfg3_inv;       /* analog to gpio_cfg0 */
	unsigned int mode      : BFW_NX500_gpio_cfg3_mode;      /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX500_gpio_cfg3_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX500_gpio_cfg3_reserved1; /* reserved            */
} NX500_GPIO_CFG3_BIT_T;

typedef union {
	unsigned int          val;
	NX500_GPIO_CFG3_BIT_T bf;
} NX500_GPIO_CFG3_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg4 */
/* => GPIO pin 4 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_cfg4  0x00000010U
#define Adr_NX500_gpio_gpio_cfg4 0x00100810U
#define Adr_NX500_gpio_cfg4      0x00100810U
#define DFLT_VAL_NX500_gpio_cfg4 0x00000000U

#define MSK_NX500_gpio_cfg4_iocfg          0x00000003U
#define SRT_NX500_gpio_cfg4_iocfg          0
#define DFLT_VAL_NX500_gpio_cfg4_iocfg     0x00000000U
#define MSK_NX500_gpio_cfg4_inv            0x00000004U
#define SRT_NX500_gpio_cfg4_inv            2
#define DFLT_VAL_NX500_gpio_cfg4_inv       0x00000000U
#define MSK_NX500_gpio_cfg4_mode           0x00000018U
#define SRT_NX500_gpio_cfg4_mode           3
#define DFLT_VAL_NX500_gpio_cfg4_mode      0x00000000U
#define MSK_NX500_gpio_cfg4_count_ref      0x000000e0U
#define SRT_NX500_gpio_cfg4_count_ref      5
#define DFLT_VAL_NX500_gpio_cfg4_count_ref 0x00000000U

enum {
	BFW_NX500_gpio_cfg4_iocfg     = 2,  /* [1:0] */
	BFW_NX500_gpio_cfg4_inv       = 1,  /* [2] */
	BFW_NX500_gpio_cfg4_mode      = 2,  /* [4:3] */
	BFW_NX500_gpio_cfg4_count_ref = 3,  /* [7:5] */
	BFW_NX500_gpio_cfg4_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_GPIO_CFG4_BIT_Ttag {
	unsigned int iocfg     : BFW_NX500_gpio_cfg4_iocfg;     /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX500_gpio_cfg4_inv;       /* analog to gpio_cfg0 */
	unsigned int mode      : BFW_NX500_gpio_cfg4_mode;      /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX500_gpio_cfg4_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX500_gpio_cfg4_reserved1; /* reserved            */
} NX500_GPIO_CFG4_BIT_T;

typedef union {
	unsigned int          val;
	NX500_GPIO_CFG4_BIT_T bf;
} NX500_GPIO_CFG4_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg5 */
/* => GPIO pin 5 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_cfg5  0x00000014U
#define Adr_NX500_gpio_gpio_cfg5 0x00100814U
#define Adr_NX500_gpio_cfg5      0x00100814U
#define DFLT_VAL_NX500_gpio_cfg5 0x00000000U

#define MSK_NX500_gpio_cfg5_iocfg          0x00000003U
#define SRT_NX500_gpio_cfg5_iocfg          0
#define DFLT_VAL_NX500_gpio_cfg5_iocfg     0x00000000U
#define MSK_NX500_gpio_cfg5_inv            0x00000004U
#define SRT_NX500_gpio_cfg5_inv            2
#define DFLT_VAL_NX500_gpio_cfg5_inv       0x00000000U
#define MSK_NX500_gpio_cfg5_mode           0x00000018U
#define SRT_NX500_gpio_cfg5_mode           3
#define DFLT_VAL_NX500_gpio_cfg5_mode      0x00000000U
#define MSK_NX500_gpio_cfg5_count_ref      0x000000e0U
#define SRT_NX500_gpio_cfg5_count_ref      5
#define DFLT_VAL_NX500_gpio_cfg5_count_ref 0x00000000U

enum {
	BFW_NX500_gpio_cfg5_iocfg     = 2,  /* [1:0] */
	BFW_NX500_gpio_cfg5_inv       = 1,  /* [2] */
	BFW_NX500_gpio_cfg5_mode      = 2,  /* [4:3] */
	BFW_NX500_gpio_cfg5_count_ref = 3,  /* [7:5] */
	BFW_NX500_gpio_cfg5_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_GPIO_CFG5_BIT_Ttag {
	unsigned int iocfg     : BFW_NX500_gpio_cfg5_iocfg;     /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX500_gpio_cfg5_inv;       /* analog to gpio_cfg0 */
	unsigned int mode      : BFW_NX500_gpio_cfg5_mode;      /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX500_gpio_cfg5_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX500_gpio_cfg5_reserved1; /* reserved            */
} NX500_GPIO_CFG5_BIT_T;

typedef union {
	unsigned int          val;
	NX500_GPIO_CFG5_BIT_T bf;
} NX500_GPIO_CFG5_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg6 */
/* => GPIO pin 6 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_cfg6  0x00000018U
#define Adr_NX500_gpio_gpio_cfg6 0x00100818U
#define Adr_NX500_gpio_cfg6      0x00100818U
#define DFLT_VAL_NX500_gpio_cfg6 0x00000000U

#define MSK_NX500_gpio_cfg6_iocfg          0x00000003U
#define SRT_NX500_gpio_cfg6_iocfg          0
#define DFLT_VAL_NX500_gpio_cfg6_iocfg     0x00000000U
#define MSK_NX500_gpio_cfg6_inv            0x00000004U
#define SRT_NX500_gpio_cfg6_inv            2
#define DFLT_VAL_NX500_gpio_cfg6_inv       0x00000000U
#define MSK_NX500_gpio_cfg6_mode           0x00000018U
#define SRT_NX500_gpio_cfg6_mode           3
#define DFLT_VAL_NX500_gpio_cfg6_mode      0x00000000U
#define MSK_NX500_gpio_cfg6_count_ref      0x000000e0U
#define SRT_NX500_gpio_cfg6_count_ref      5
#define DFLT_VAL_NX500_gpio_cfg6_count_ref 0x00000000U

enum {
	BFW_NX500_gpio_cfg6_iocfg     = 2,  /* [1:0] */
	BFW_NX500_gpio_cfg6_inv       = 1,  /* [2] */
	BFW_NX500_gpio_cfg6_mode      = 2,  /* [4:3] */
	BFW_NX500_gpio_cfg6_count_ref = 3,  /* [7:5] */
	BFW_NX500_gpio_cfg6_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_GPIO_CFG6_BIT_Ttag {
	unsigned int iocfg     : BFW_NX500_gpio_cfg6_iocfg;     /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX500_gpio_cfg6_inv;       /* analog to gpio_cfg0 */
	unsigned int mode      : BFW_NX500_gpio_cfg6_mode;      /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX500_gpio_cfg6_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX500_gpio_cfg6_reserved1; /* reserved            */
} NX500_GPIO_CFG6_BIT_T;

typedef union {
	unsigned int          val;
	NX500_GPIO_CFG6_BIT_T bf;
} NX500_GPIO_CFG6_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg7 */
/* => GPIO pin 7 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_cfg7  0x0000001CU
#define Adr_NX500_gpio_gpio_cfg7 0x0010081CU
#define Adr_NX500_gpio_cfg7      0x0010081CU
#define DFLT_VAL_NX500_gpio_cfg7 0x00000000U

#define MSK_NX500_gpio_cfg7_iocfg          0x00000003U
#define SRT_NX500_gpio_cfg7_iocfg          0
#define DFLT_VAL_NX500_gpio_cfg7_iocfg     0x00000000U
#define MSK_NX500_gpio_cfg7_inv            0x00000004U
#define SRT_NX500_gpio_cfg7_inv            2
#define DFLT_VAL_NX500_gpio_cfg7_inv       0x00000000U
#define MSK_NX500_gpio_cfg7_mode           0x00000018U
#define SRT_NX500_gpio_cfg7_mode           3
#define DFLT_VAL_NX500_gpio_cfg7_mode      0x00000000U
#define MSK_NX500_gpio_cfg7_count_ref      0x000000e0U
#define SRT_NX500_gpio_cfg7_count_ref      5
#define DFLT_VAL_NX500_gpio_cfg7_count_ref 0x00000000U

enum {
	BFW_NX500_gpio_cfg7_iocfg     = 2,  /* [1:0] */
	BFW_NX500_gpio_cfg7_inv       = 1,  /* [2] */
	BFW_NX500_gpio_cfg7_mode      = 2,  /* [4:3] */
	BFW_NX500_gpio_cfg7_count_ref = 3,  /* [7:5] */
	BFW_NX500_gpio_cfg7_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_GPIO_CFG7_BIT_Ttag {
	unsigned int iocfg     : BFW_NX500_gpio_cfg7_iocfg;     /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX500_gpio_cfg7_inv;       /* analog to gpio_cfg0 */
	unsigned int mode      : BFW_NX500_gpio_cfg7_mode;      /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX500_gpio_cfg7_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX500_gpio_cfg7_reserved1; /* reserved            */
} NX500_GPIO_CFG7_BIT_T;

typedef union {
	unsigned int          val;
	NX500_GPIO_CFG7_BIT_T bf;
} NX500_GPIO_CFG7_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg8 */
/* => GPIO pin 8 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_cfg8  0x00000020U
#define Adr_NX500_gpio_gpio_cfg8 0x00100820U
#define Adr_NX500_gpio_cfg8      0x00100820U
#define DFLT_VAL_NX500_gpio_cfg8 0x00000000U

#define MSK_NX500_gpio_cfg8_iocfg          0x00000003U
#define SRT_NX500_gpio_cfg8_iocfg          0
#define DFLT_VAL_NX500_gpio_cfg8_iocfg     0x00000000U
#define MSK_NX500_gpio_cfg8_inv            0x00000004U
#define SRT_NX500_gpio_cfg8_inv            2
#define DFLT_VAL_NX500_gpio_cfg8_inv       0x00000000U
#define MSK_NX500_gpio_cfg8_mode           0x00000018U
#define SRT_NX500_gpio_cfg8_mode           3
#define DFLT_VAL_NX500_gpio_cfg8_mode      0x00000000U
#define MSK_NX500_gpio_cfg8_count_ref      0x000000e0U
#define SRT_NX500_gpio_cfg8_count_ref      5
#define DFLT_VAL_NX500_gpio_cfg8_count_ref 0x00000000U

enum {
	BFW_NX500_gpio_cfg8_iocfg     = 2,  /* [1:0] */
	BFW_NX500_gpio_cfg8_inv       = 1,  /* [2] */
	BFW_NX500_gpio_cfg8_mode      = 2,  /* [4:3] */
	BFW_NX500_gpio_cfg8_count_ref = 3,  /* [7:5] */
	BFW_NX500_gpio_cfg8_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_GPIO_CFG8_BIT_Ttag {
	unsigned int iocfg     : BFW_NX500_gpio_cfg8_iocfg;     /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX500_gpio_cfg8_inv;       /* analog to gpio_cfg0 */
	unsigned int mode      : BFW_NX500_gpio_cfg8_mode;      /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX500_gpio_cfg8_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX500_gpio_cfg8_reserved1; /* reserved            */
} NX500_GPIO_CFG8_BIT_T;

typedef union {
	unsigned int          val;
	NX500_GPIO_CFG8_BIT_T bf;
} NX500_GPIO_CFG8_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg9 */
/* => GPIO pin 9 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_cfg9  0x00000024U
#define Adr_NX500_gpio_gpio_cfg9 0x00100824U
#define Adr_NX500_gpio_cfg9      0x00100824U
#define DFLT_VAL_NX500_gpio_cfg9 0x00000000U

#define MSK_NX500_gpio_cfg9_iocfg          0x00000003U
#define SRT_NX500_gpio_cfg9_iocfg          0
#define DFLT_VAL_NX500_gpio_cfg9_iocfg     0x00000000U
#define MSK_NX500_gpio_cfg9_inv            0x00000004U
#define SRT_NX500_gpio_cfg9_inv            2
#define DFLT_VAL_NX500_gpio_cfg9_inv       0x00000000U
#define MSK_NX500_gpio_cfg9_mode           0x00000018U
#define SRT_NX500_gpio_cfg9_mode           3
#define DFLT_VAL_NX500_gpio_cfg9_mode      0x00000000U
#define MSK_NX500_gpio_cfg9_count_ref      0x000000e0U
#define SRT_NX500_gpio_cfg9_count_ref      5
#define DFLT_VAL_NX500_gpio_cfg9_count_ref 0x00000000U

enum {
	BFW_NX500_gpio_cfg9_iocfg     = 2,  /* [1:0] */
	BFW_NX500_gpio_cfg9_inv       = 1,  /* [2] */
	BFW_NX500_gpio_cfg9_mode      = 2,  /* [4:3] */
	BFW_NX500_gpio_cfg9_count_ref = 3,  /* [7:5] */
	BFW_NX500_gpio_cfg9_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_GPIO_CFG9_BIT_Ttag {
	unsigned int iocfg     : BFW_NX500_gpio_cfg9_iocfg;     /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX500_gpio_cfg9_inv;       /* analog to gpio_cfg0 */
	unsigned int mode      : BFW_NX500_gpio_cfg9_mode;      /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX500_gpio_cfg9_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX500_gpio_cfg9_reserved1; /* reserved            */
} NX500_GPIO_CFG9_BIT_T;

typedef union {
	unsigned int          val;
	NX500_GPIO_CFG9_BIT_T bf;
} NX500_GPIO_CFG9_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg10 */
/* => GPIO pin 10 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_cfg10  0x00000028U
#define Adr_NX500_gpio_gpio_cfg10 0x00100828U
#define Adr_NX500_gpio_cfg10      0x00100828U
#define DFLT_VAL_NX500_gpio_cfg10 0x00000000U

#define MSK_NX500_gpio_cfg10_iocfg          0x00000003U
#define SRT_NX500_gpio_cfg10_iocfg          0
#define DFLT_VAL_NX500_gpio_cfg10_iocfg     0x00000000U
#define MSK_NX500_gpio_cfg10_inv            0x00000004U
#define SRT_NX500_gpio_cfg10_inv            2
#define DFLT_VAL_NX500_gpio_cfg10_inv       0x00000000U
#define MSK_NX500_gpio_cfg10_mode           0x00000018U
#define SRT_NX500_gpio_cfg10_mode           3
#define DFLT_VAL_NX500_gpio_cfg10_mode      0x00000000U
#define MSK_NX500_gpio_cfg10_count_ref      0x000000e0U
#define SRT_NX500_gpio_cfg10_count_ref      5
#define DFLT_VAL_NX500_gpio_cfg10_count_ref 0x00000000U

enum {
	BFW_NX500_gpio_cfg10_iocfg     = 2,  /* [1:0] */
	BFW_NX500_gpio_cfg10_inv       = 1,  /* [2] */
	BFW_NX500_gpio_cfg10_mode      = 2,  /* [4:3] */
	BFW_NX500_gpio_cfg10_count_ref = 3,  /* [7:5] */
	BFW_NX500_gpio_cfg10_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_GPIO_CFG10_BIT_Ttag {
	unsigned int iocfg     : BFW_NX500_gpio_cfg10_iocfg;     /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX500_gpio_cfg10_inv;       /* analog to gpio_cfg0 */
	unsigned int mode      : BFW_NX500_gpio_cfg10_mode;      /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX500_gpio_cfg10_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX500_gpio_cfg10_reserved1; /* reserved            */
} NX500_GPIO_CFG10_BIT_T;

typedef union {
	unsigned int           val;
	NX500_GPIO_CFG10_BIT_T bf;
} NX500_GPIO_CFG10_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg11 */
/* => GPIO pin 11 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_cfg11  0x0000002CU
#define Adr_NX500_gpio_gpio_cfg11 0x0010082CU
#define Adr_NX500_gpio_cfg11      0x0010082CU
#define DFLT_VAL_NX500_gpio_cfg11 0x00000000U

#define MSK_NX500_gpio_cfg11_iocfg          0x00000003U
#define SRT_NX500_gpio_cfg11_iocfg          0
#define DFLT_VAL_NX500_gpio_cfg11_iocfg     0x00000000U
#define MSK_NX500_gpio_cfg11_inv            0x00000004U
#define SRT_NX500_gpio_cfg11_inv            2
#define DFLT_VAL_NX500_gpio_cfg11_inv       0x00000000U
#define MSK_NX500_gpio_cfg11_mode           0x00000018U
#define SRT_NX500_gpio_cfg11_mode           3
#define DFLT_VAL_NX500_gpio_cfg11_mode      0x00000000U
#define MSK_NX500_gpio_cfg11_count_ref      0x000000e0U
#define SRT_NX500_gpio_cfg11_count_ref      5
#define DFLT_VAL_NX500_gpio_cfg11_count_ref 0x00000000U

enum {
	BFW_NX500_gpio_cfg11_iocfg     = 2,  /* [1:0] */
	BFW_NX500_gpio_cfg11_inv       = 1,  /* [2] */
	BFW_NX500_gpio_cfg11_mode      = 2,  /* [4:3] */
	BFW_NX500_gpio_cfg11_count_ref = 3,  /* [7:5] */
	BFW_NX500_gpio_cfg11_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_GPIO_CFG11_BIT_Ttag {
	unsigned int iocfg     : BFW_NX500_gpio_cfg11_iocfg;     /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX500_gpio_cfg11_inv;       /* analog to gpio_cfg0 */
	unsigned int mode      : BFW_NX500_gpio_cfg11_mode;      /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX500_gpio_cfg11_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX500_gpio_cfg11_reserved1; /* reserved            */
} NX500_GPIO_CFG11_BIT_T;

typedef union {
	unsigned int           val;
	NX500_GPIO_CFG11_BIT_T bf;
} NX500_GPIO_CFG11_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg12 */
/* => GPIO pin 12 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_cfg12  0x00000030U
#define Adr_NX500_gpio_gpio_cfg12 0x00100830U
#define Adr_NX500_gpio_cfg12      0x00100830U
#define DFLT_VAL_NX500_gpio_cfg12 0x00000000U

#define MSK_NX500_gpio_cfg12_iocfg          0x00000003U
#define SRT_NX500_gpio_cfg12_iocfg          0
#define DFLT_VAL_NX500_gpio_cfg12_iocfg     0x00000000U
#define MSK_NX500_gpio_cfg12_inv            0x00000004U
#define SRT_NX500_gpio_cfg12_inv            2
#define DFLT_VAL_NX500_gpio_cfg12_inv       0x00000000U
#define MSK_NX500_gpio_cfg12_mode           0x00000018U
#define SRT_NX500_gpio_cfg12_mode           3
#define DFLT_VAL_NX500_gpio_cfg12_mode      0x00000000U
#define MSK_NX500_gpio_cfg12_count_ref      0x000000e0U
#define SRT_NX500_gpio_cfg12_count_ref      5
#define DFLT_VAL_NX500_gpio_cfg12_count_ref 0x00000000U

enum {
	BFW_NX500_gpio_cfg12_iocfg     = 2,  /* [1:0] */
	BFW_NX500_gpio_cfg12_inv       = 1,  /* [2] */
	BFW_NX500_gpio_cfg12_mode      = 2,  /* [4:3] */
	BFW_NX500_gpio_cfg12_count_ref = 3,  /* [7:5] */
	BFW_NX500_gpio_cfg12_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_GPIO_CFG12_BIT_Ttag {
	unsigned int iocfg     : BFW_NX500_gpio_cfg12_iocfg;     /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX500_gpio_cfg12_inv;       /* analog to gpio_cfg0 */
	unsigned int mode      : BFW_NX500_gpio_cfg12_mode;      /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX500_gpio_cfg12_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX500_gpio_cfg12_reserved1; /* reserved            */
} NX500_GPIO_CFG12_BIT_T;

typedef union {
	unsigned int           val;
	NX500_GPIO_CFG12_BIT_T bf;
} NX500_GPIO_CFG12_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg13 */
/* => GPIO pin 13 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_cfg13  0x00000034U
#define Adr_NX500_gpio_gpio_cfg13 0x00100834U
#define Adr_NX500_gpio_cfg13      0x00100834U
#define DFLT_VAL_NX500_gpio_cfg13 0x00000000U

#define MSK_NX500_gpio_cfg13_iocfg          0x00000003U
#define SRT_NX500_gpio_cfg13_iocfg          0
#define DFLT_VAL_NX500_gpio_cfg13_iocfg     0x00000000U
#define MSK_NX500_gpio_cfg13_inv            0x00000004U
#define SRT_NX500_gpio_cfg13_inv            2
#define DFLT_VAL_NX500_gpio_cfg13_inv       0x00000000U
#define MSK_NX500_gpio_cfg13_mode           0x00000018U
#define SRT_NX500_gpio_cfg13_mode           3
#define DFLT_VAL_NX500_gpio_cfg13_mode      0x00000000U
#define MSK_NX500_gpio_cfg13_count_ref      0x000000e0U
#define SRT_NX500_gpio_cfg13_count_ref      5
#define DFLT_VAL_NX500_gpio_cfg13_count_ref 0x00000000U

enum {
	BFW_NX500_gpio_cfg13_iocfg     = 2,  /* [1:0] */
	BFW_NX500_gpio_cfg13_inv       = 1,  /* [2] */
	BFW_NX500_gpio_cfg13_mode      = 2,  /* [4:3] */
	BFW_NX500_gpio_cfg13_count_ref = 3,  /* [7:5] */
	BFW_NX500_gpio_cfg13_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_GPIO_CFG13_BIT_Ttag {
	unsigned int iocfg     : BFW_NX500_gpio_cfg13_iocfg;     /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX500_gpio_cfg13_inv;       /* analog to gpio_cfg0 */
	unsigned int mode      : BFW_NX500_gpio_cfg13_mode;      /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX500_gpio_cfg13_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX500_gpio_cfg13_reserved1; /* reserved            */
} NX500_GPIO_CFG13_BIT_T;

typedef union {
	unsigned int           val;
	NX500_GPIO_CFG13_BIT_T bf;
} NX500_GPIO_CFG13_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg14 */
/* => GPIO pin 14 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_cfg14  0x00000038U
#define Adr_NX500_gpio_gpio_cfg14 0x00100838U
#define Adr_NX500_gpio_cfg14      0x00100838U
#define DFLT_VAL_NX500_gpio_cfg14 0x00000000U

#define MSK_NX500_gpio_cfg14_iocfg          0x00000003U
#define SRT_NX500_gpio_cfg14_iocfg          0
#define DFLT_VAL_NX500_gpio_cfg14_iocfg     0x00000000U
#define MSK_NX500_gpio_cfg14_inv            0x00000004U
#define SRT_NX500_gpio_cfg14_inv            2
#define DFLT_VAL_NX500_gpio_cfg14_inv       0x00000000U
#define MSK_NX500_gpio_cfg14_mode           0x00000018U
#define SRT_NX500_gpio_cfg14_mode           3
#define DFLT_VAL_NX500_gpio_cfg14_mode      0x00000000U
#define MSK_NX500_gpio_cfg14_count_ref      0x000000e0U
#define SRT_NX500_gpio_cfg14_count_ref      5
#define DFLT_VAL_NX500_gpio_cfg14_count_ref 0x00000000U

enum {
	BFW_NX500_gpio_cfg14_iocfg     = 2,  /* [1:0] */
	BFW_NX500_gpio_cfg14_inv       = 1,  /* [2] */
	BFW_NX500_gpio_cfg14_mode      = 2,  /* [4:3] */
	BFW_NX500_gpio_cfg14_count_ref = 3,  /* [7:5] */
	BFW_NX500_gpio_cfg14_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_GPIO_CFG14_BIT_Ttag {
	unsigned int iocfg     : BFW_NX500_gpio_cfg14_iocfg;     /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX500_gpio_cfg14_inv;       /* analog to gpio_cfg0 */
	unsigned int mode      : BFW_NX500_gpio_cfg14_mode;      /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX500_gpio_cfg14_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX500_gpio_cfg14_reserved1; /* reserved            */
} NX500_GPIO_CFG14_BIT_T;

typedef union {
	unsigned int           val;
	NX500_GPIO_CFG14_BIT_T bf;
} NX500_GPIO_CFG14_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg15 */
/* => GPIO pin 15 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_cfg15  0x0000003CU
#define Adr_NX500_gpio_gpio_cfg15 0x0010083CU
#define Adr_NX500_gpio_cfg15      0x0010083CU
#define DFLT_VAL_NX500_gpio_cfg15 0x00000000U

#define MSK_NX500_gpio_cfg15_iocfg          0x00000003U
#define SRT_NX500_gpio_cfg15_iocfg          0
#define DFLT_VAL_NX500_gpio_cfg15_iocfg     0x00000000U
#define MSK_NX500_gpio_cfg15_inv            0x00000004U
#define SRT_NX500_gpio_cfg15_inv            2
#define DFLT_VAL_NX500_gpio_cfg15_inv       0x00000000U
#define MSK_NX500_gpio_cfg15_mode           0x00000018U
#define SRT_NX500_gpio_cfg15_mode           3
#define DFLT_VAL_NX500_gpio_cfg15_mode      0x00000000U
#define MSK_NX500_gpio_cfg15_count_ref      0x000000e0U
#define SRT_NX500_gpio_cfg15_count_ref      5
#define DFLT_VAL_NX500_gpio_cfg15_count_ref 0x00000000U

enum {
	BFW_NX500_gpio_cfg15_iocfg     = 2,  /* [1:0] */
	BFW_NX500_gpio_cfg15_inv       = 1,  /* [2] */
	BFW_NX500_gpio_cfg15_mode      = 2,  /* [4:3] */
	BFW_NX500_gpio_cfg15_count_ref = 3,  /* [7:5] */
	BFW_NX500_gpio_cfg15_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_GPIO_CFG15_BIT_Ttag {
	unsigned int iocfg     : BFW_NX500_gpio_cfg15_iocfg;     /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX500_gpio_cfg15_inv;       /* analog to gpio_cfg0 */
	unsigned int mode      : BFW_NX500_gpio_cfg15_mode;      /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX500_gpio_cfg15_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX500_gpio_cfg15_reserved1; /* reserved            */
} NX500_GPIO_CFG15_BIT_T;

typedef union {
	unsigned int           val;
	NX500_GPIO_CFG15_BIT_T bf;
} NX500_GPIO_CFG15_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc0 */
/* => GPIO pin 0 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_tc0  0x00000040U
#define Adr_NX500_gpio_gpio_tc0 0x00100840U
#define Adr_NX500_gpio_tc0      0x00100840U
#define DFLT_VAL_NX500_gpio_tc0 0x00000000U

#define MSK_NX500_gpio_tc0_val      0xffffffffU
#define SRT_NX500_gpio_tc0_val      0
#define DFLT_VAL_NX500_gpio_tc0_val 0x00000000U

enum {
	BFW_NX500_gpio_tc0_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_TC0_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_tc0_val; /* holds the counter threshold value for the pwm mode */
	                                           /* or the captured value in the capture mode          */
} NX500_GPIO_TC0_BIT_T;

typedef union {
	unsigned int         val;
	NX500_GPIO_TC0_BIT_T bf;
} NX500_GPIO_TC0_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc1 */
/* => GPIO pin 1 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_tc1  0x00000044U
#define Adr_NX500_gpio_gpio_tc1 0x00100844U
#define Adr_NX500_gpio_tc1      0x00100844U
#define DFLT_VAL_NX500_gpio_tc1 0x00000000U

#define MSK_NX500_gpio_tc1_val      0xffffffffU
#define SRT_NX500_gpio_tc1_val      0
#define DFLT_VAL_NX500_gpio_tc1_val 0x00000000U

enum {
	BFW_NX500_gpio_tc1_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_TC1_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_tc1_val; /* holds the counter threshold value for the pwm mode */
	                                           /* or the captured value in the capture mode          */
} NX500_GPIO_TC1_BIT_T;

typedef union {
	unsigned int         val;
	NX500_GPIO_TC1_BIT_T bf;
} NX500_GPIO_TC1_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc2 */
/* => GPIO pin 2 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_tc2  0x00000048U
#define Adr_NX500_gpio_gpio_tc2 0x00100848U
#define Adr_NX500_gpio_tc2      0x00100848U
#define DFLT_VAL_NX500_gpio_tc2 0x00000000U

#define MSK_NX500_gpio_tc2_val      0xffffffffU
#define SRT_NX500_gpio_tc2_val      0
#define DFLT_VAL_NX500_gpio_tc2_val 0x00000000U

enum {
	BFW_NX500_gpio_tc2_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_TC2_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_tc2_val; /* holds the counter threshold value for the pwm mode */
	                                           /* or the captured value in the capture mode          */
} NX500_GPIO_TC2_BIT_T;

typedef union {
	unsigned int         val;
	NX500_GPIO_TC2_BIT_T bf;
} NX500_GPIO_TC2_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc3 */
/* => GPIO pin 3 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_tc3  0x0000004CU
#define Adr_NX500_gpio_gpio_tc3 0x0010084CU
#define Adr_NX500_gpio_tc3      0x0010084CU
#define DFLT_VAL_NX500_gpio_tc3 0x00000000U

#define MSK_NX500_gpio_tc3_val      0xffffffffU
#define SRT_NX500_gpio_tc3_val      0
#define DFLT_VAL_NX500_gpio_tc3_val 0x00000000U

enum {
	BFW_NX500_gpio_tc3_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_TC3_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_tc3_val; /* holds the counter threshold value for the pwm mode */
	                                           /* or the captured value in the capture mode          */
} NX500_GPIO_TC3_BIT_T;

typedef union {
	unsigned int         val;
	NX500_GPIO_TC3_BIT_T bf;
} NX500_GPIO_TC3_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc4 */
/* => GPIO pin 4 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_tc4  0x00000050U
#define Adr_NX500_gpio_gpio_tc4 0x00100850U
#define Adr_NX500_gpio_tc4      0x00100850U
#define DFLT_VAL_NX500_gpio_tc4 0x00000000U

#define MSK_NX500_gpio_tc4_val      0xffffffffU
#define SRT_NX500_gpio_tc4_val      0
#define DFLT_VAL_NX500_gpio_tc4_val 0x00000000U

enum {
	BFW_NX500_gpio_tc4_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_TC4_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_tc4_val; /* holds the counter threshold value for the pwm mode */
	                                           /* or the captured value in the capture mode          */
} NX500_GPIO_TC4_BIT_T;

typedef union {
	unsigned int         val;
	NX500_GPIO_TC4_BIT_T bf;
} NX500_GPIO_TC4_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc5 */
/* => GPIO pin 5 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_tc5  0x00000054U
#define Adr_NX500_gpio_gpio_tc5 0x00100854U
#define Adr_NX500_gpio_tc5      0x00100854U
#define DFLT_VAL_NX500_gpio_tc5 0x00000000U

#define MSK_NX500_gpio_tc5_val      0xffffffffU
#define SRT_NX500_gpio_tc5_val      0
#define DFLT_VAL_NX500_gpio_tc5_val 0x00000000U

enum {
	BFW_NX500_gpio_tc5_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_TC5_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_tc5_val; /* holds the counter threshold value for the pwm mode */
	                                           /* or the captured value in the capture mode          */
} NX500_GPIO_TC5_BIT_T;

typedef union {
	unsigned int         val;
	NX500_GPIO_TC5_BIT_T bf;
} NX500_GPIO_TC5_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc6 */
/* => GPIO pin 6 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_tc6  0x00000058U
#define Adr_NX500_gpio_gpio_tc6 0x00100858U
#define Adr_NX500_gpio_tc6      0x00100858U
#define DFLT_VAL_NX500_gpio_tc6 0x00000000U

#define MSK_NX500_gpio_tc6_val      0xffffffffU
#define SRT_NX500_gpio_tc6_val      0
#define DFLT_VAL_NX500_gpio_tc6_val 0x00000000U

enum {
	BFW_NX500_gpio_tc6_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_TC6_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_tc6_val; /* holds the counter threshold value for the pwm mode */
	                                           /* or the captured value in the capture mode          */
} NX500_GPIO_TC6_BIT_T;

typedef union {
	unsigned int         val;
	NX500_GPIO_TC6_BIT_T bf;
} NX500_GPIO_TC6_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc7 */
/* => GPIO pin 7 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_tc7  0x0000005CU
#define Adr_NX500_gpio_gpio_tc7 0x0010085CU
#define Adr_NX500_gpio_tc7      0x0010085CU
#define DFLT_VAL_NX500_gpio_tc7 0x00000000U

#define MSK_NX500_gpio_tc7_val      0xffffffffU
#define SRT_NX500_gpio_tc7_val      0
#define DFLT_VAL_NX500_gpio_tc7_val 0x00000000U

enum {
	BFW_NX500_gpio_tc7_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_TC7_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_tc7_val; /* holds the counter threshold value for the pwm mode */
	                                           /* or the captured value in the capture mode          */
} NX500_GPIO_TC7_BIT_T;

typedef union {
	unsigned int         val;
	NX500_GPIO_TC7_BIT_T bf;
} NX500_GPIO_TC7_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc8 */
/* => GPIO pin 8 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_tc8  0x00000060U
#define Adr_NX500_gpio_gpio_tc8 0x00100860U
#define Adr_NX500_gpio_tc8      0x00100860U
#define DFLT_VAL_NX500_gpio_tc8 0x00000000U

#define MSK_NX500_gpio_tc8_val      0xffffffffU
#define SRT_NX500_gpio_tc8_val      0
#define DFLT_VAL_NX500_gpio_tc8_val 0x00000000U

enum {
	BFW_NX500_gpio_tc8_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_TC8_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_tc8_val; /* holds the counter threshold value for the pwm mode */
	                                           /* or the captured value in the capture mode          */
} NX500_GPIO_TC8_BIT_T;

typedef union {
	unsigned int         val;
	NX500_GPIO_TC8_BIT_T bf;
} NX500_GPIO_TC8_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc9 */
/* => GPIO pin 9 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_tc9  0x00000064U
#define Adr_NX500_gpio_gpio_tc9 0x00100864U
#define Adr_NX500_gpio_tc9      0x00100864U
#define DFLT_VAL_NX500_gpio_tc9 0x00000000U

#define MSK_NX500_gpio_tc9_val      0xffffffffU
#define SRT_NX500_gpio_tc9_val      0
#define DFLT_VAL_NX500_gpio_tc9_val 0x00000000U

enum {
	BFW_NX500_gpio_tc9_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_TC9_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_tc9_val; /* holds the counter threshold value for the pwm mode */
	                                           /* or the captured value in the capture mode          */
} NX500_GPIO_TC9_BIT_T;

typedef union {
	unsigned int         val;
	NX500_GPIO_TC9_BIT_T bf;
} NX500_GPIO_TC9_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc10 */
/* => GPIO pin 10 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_tc10  0x00000068U
#define Adr_NX500_gpio_gpio_tc10 0x00100868U
#define Adr_NX500_gpio_tc10      0x00100868U
#define DFLT_VAL_NX500_gpio_tc10 0x00000000U

#define MSK_NX500_gpio_tc10_val      0xffffffffU
#define SRT_NX500_gpio_tc10_val      0
#define DFLT_VAL_NX500_gpio_tc10_val 0x00000000U

enum {
	BFW_NX500_gpio_tc10_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_TC10_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_tc10_val; /* holds the counter threshold value for the pwm mode */
	                                            /* or the captured value in the capture mode          */
} NX500_GPIO_TC10_BIT_T;

typedef union {
	unsigned int          val;
	NX500_GPIO_TC10_BIT_T bf;
} NX500_GPIO_TC10_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc11 */
/* => GPIO pin 11 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_tc11  0x0000006CU
#define Adr_NX500_gpio_gpio_tc11 0x0010086CU
#define Adr_NX500_gpio_tc11      0x0010086CU
#define DFLT_VAL_NX500_gpio_tc11 0x00000000U

#define MSK_NX500_gpio_tc11_val      0xffffffffU
#define SRT_NX500_gpio_tc11_val      0
#define DFLT_VAL_NX500_gpio_tc11_val 0x00000000U

enum {
	BFW_NX500_gpio_tc11_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_TC11_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_tc11_val; /* holds the counter threshold value for the pwm mode */
	                                            /* or the captured value in the capture mode          */
} NX500_GPIO_TC11_BIT_T;

typedef union {
	unsigned int          val;
	NX500_GPIO_TC11_BIT_T bf;
} NX500_GPIO_TC11_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc12 */
/* => GPIO pin 12 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_tc12  0x00000070U
#define Adr_NX500_gpio_gpio_tc12 0x00100870U
#define Adr_NX500_gpio_tc12      0x00100870U
#define DFLT_VAL_NX500_gpio_tc12 0x00000000U

#define MSK_NX500_gpio_tc12_val      0xffffffffU
#define SRT_NX500_gpio_tc12_val      0
#define DFLT_VAL_NX500_gpio_tc12_val 0x00000000U

enum {
	BFW_NX500_gpio_tc12_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_TC12_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_tc12_val; /* holds the counter threshold value for the pwm mode */
	                                            /* or the captured value in the capture mode          */
} NX500_GPIO_TC12_BIT_T;

typedef union {
	unsigned int          val;
	NX500_GPIO_TC12_BIT_T bf;
} NX500_GPIO_TC12_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc13 */
/* => GPIO pin 13 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_tc13  0x00000074U
#define Adr_NX500_gpio_gpio_tc13 0x00100874U
#define Adr_NX500_gpio_tc13      0x00100874U
#define DFLT_VAL_NX500_gpio_tc13 0x00000000U

#define MSK_NX500_gpio_tc13_val      0xffffffffU
#define SRT_NX500_gpio_tc13_val      0
#define DFLT_VAL_NX500_gpio_tc13_val 0x00000000U

enum {
	BFW_NX500_gpio_tc13_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_TC13_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_tc13_val; /* holds the counter threshold value for the pwm mode */
	                                            /* or the captured value in the capture mode          */
} NX500_GPIO_TC13_BIT_T;

typedef union {
	unsigned int          val;
	NX500_GPIO_TC13_BIT_T bf;
} NX500_GPIO_TC13_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc14 */
/* => GPIO pin 14 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_tc14  0x00000078U
#define Adr_NX500_gpio_gpio_tc14 0x00100878U
#define Adr_NX500_gpio_tc14      0x00100878U
#define DFLT_VAL_NX500_gpio_tc14 0x00000000U

#define MSK_NX500_gpio_tc14_val      0xffffffffU
#define SRT_NX500_gpio_tc14_val      0
#define DFLT_VAL_NX500_gpio_tc14_val 0x00000000U

enum {
	BFW_NX500_gpio_tc14_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_TC14_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_tc14_val; /* holds the counter threshold value for the pwm mode */
	                                            /* or the captured value in the capture mode          */
} NX500_GPIO_TC14_BIT_T;

typedef union {
	unsigned int          val;
	NX500_GPIO_TC14_BIT_T bf;
} NX500_GPIO_TC14_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc15 */
/* => GPIO pin 15 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_tc15  0x0000007CU
#define Adr_NX500_gpio_gpio_tc15 0x0010087CU
#define Adr_NX500_gpio_tc15      0x0010087CU
#define DFLT_VAL_NX500_gpio_tc15 0x00000000U

#define MSK_NX500_gpio_tc15_val      0xffffffffU
#define SRT_NX500_gpio_tc15_val      0
#define DFLT_VAL_NX500_gpio_tc15_val 0x00000000U

enum {
	BFW_NX500_gpio_tc15_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_TC15_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_tc15_val; /* holds the counter threshold value for the pwm mode */
	                                            /* or the captured value in the capture mode          */
} NX500_GPIO_TC15_BIT_T;

typedef union {
	unsigned int          val;
	NX500_GPIO_TC15_BIT_T bf;
} NX500_GPIO_TC15_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter0_ctrl */
/* => GPIO counter0 control register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_counter0_ctrl  0x00000080U
#define Adr_NX500_gpio_gpio_counter0_ctrl 0x00100880U
#define Adr_NX500_gpio_counter0_ctrl      0x00100880U
#define DFLT_VAL_NX500_gpio_counter0_ctrl 0x00000000U

#define MSK_NX500_gpio_counter0_ctrl_run            0x00000001U
#define SRT_NX500_gpio_counter0_ctrl_run            0
#define DFLT_VAL_NX500_gpio_counter0_ctrl_run       0x00000000U
#define MSK_NX500_gpio_counter0_ctrl_sym_nasym      0x00000002U
#define SRT_NX500_gpio_counter0_ctrl_sym_nasym      1
#define DFLT_VAL_NX500_gpio_counter0_ctrl_sym_nasym 0x00000000U
#define MSK_NX500_gpio_counter0_ctrl_once           0x00000004U
#define SRT_NX500_gpio_counter0_ctrl_once           2
#define DFLT_VAL_NX500_gpio_counter0_ctrl_once      0x00000000U
#define MSK_NX500_gpio_counter0_ctrl_irq_en         0x00000008U
#define SRT_NX500_gpio_counter0_ctrl_irq_en         3
#define DFLT_VAL_NX500_gpio_counter0_ctrl_irq_en    0x00000000U
#define MSK_NX500_gpio_counter0_ctrl_cnt_event      0x00000010U
#define SRT_NX500_gpio_counter0_ctrl_cnt_event      4
#define DFLT_VAL_NX500_gpio_counter0_ctrl_cnt_event 0x00000000U
#define SRT_NX500_gpio_counter0_ctrl_rst_en         5
#define MSK_NX500_gpio_counter0_ctrl_rst_en         0x00000020U
#define DFLT_VAL_NX500_gpio_counter0_ctrl_rst_en    0x00000000U
#define MSK_NX500_gpio_counter0_ctrl_sel_event      0x00000040U
#define SRT_NX500_gpio_counter0_ctrl_sel_event      6
#define DFLT_VAL_NX500_gpio_counter0_ctrl_sel_event 0x00000000U
#define MSK_NX500_gpio_counter0_ctrl_gpio_ref       0x00000780U
#define SRT_NX500_gpio_counter0_ctrl_gpio_ref       7
#define DFLT_VAL_NX500_gpio_counter0_ctrl_gpio_ref  0x00000000U

enum {
	BFW_NX500_gpio_counter0_ctrl_run       = 1,  /* [0] */
	BFW_NX500_gpio_counter0_ctrl_sym_nasym = 1,  /* [1] */
	BFW_NX500_gpio_counter0_ctrl_once      = 1,  /* [2] */
	BFW_NX500_gpio_counter0_ctrl_irq_en    = 1,  /* [3] */
	BFW_NX500_gpio_counter0_ctrl_cnt_event = 1,  /* [4] */
	BFW_NX500_gpio_counter0_ctrl_rst_en    = 1,  /* [5] */
	BFW_NX500_gpio_counter0_ctrl_sel_event = 1,  /* [6] */
	BFW_NX500_gpio_counter0_ctrl_gpio_ref  = 4,  /* [10:7] */
	BFW_NX500_gpio_counter0_ctrl_reserved1 = 21  /* [31:11] */
};

typedef struct NX500_GPIO_COUNTER0_CTRL_BIT_Ttag {
	unsigned int run       : BFW_NX500_gpio_counter0_ctrl_run;       /* 1 .. start counter; 0 .. stop counter                                 */
	unsigned int sym_nasym : BFW_NX500_gpio_counter0_ctrl_sym_nasym; /* 1 .. symmetric mode (triangle); 0 .. asymmetric mode (sawtooth)       */
	unsigned int once      : BFW_NX500_gpio_counter0_ctrl_once;      /* 1 .. count once; 0 .. count continue                                  */
	unsigned int irq_en    : BFW_NX500_gpio_counter0_ctrl_irq_en;    /* 1 .. enable interrupt request; 0 .. disable interrupt request         */
	unsigned int cnt_event : BFW_NX500_gpio_counter0_ctrl_cnt_event; /* 1 .. count external event (edge, level); 0 .. count every clock cycle */
	unsigned int rst_en    : BFW_NX500_gpio_counter0_ctrl_rst_en;    /* 1 .. enable automatic reset; 0 .. disable automatic reset             */
	unsigned int sel_event : BFW_NX500_gpio_counter0_ctrl_sel_event; /* select external event                                                 */
	                                                                 /* 0 .. (high) level                                                     */
	unsigned int gpio_ref  : BFW_NX500_gpio_counter0_ctrl_gpio_ref;  /* gpio reference (0 - 15)                                               */
	unsigned int reserved1 : BFW_NX500_gpio_counter0_ctrl_reserved1; /* reserved                                                              */
} NX500_GPIO_COUNTER0_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_GPIO_COUNTER0_CTRL_BIT_T bf;
} NX500_GPIO_COUNTER0_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter1_ctrl */
/* => GPIO counter1 control register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_counter1_ctrl  0x00000084U
#define Adr_NX500_gpio_gpio_counter1_ctrl 0x00100884U
#define Adr_NX500_gpio_counter1_ctrl      0x00100884U
#define DFLT_VAL_NX500_gpio_counter1_ctrl 0x00000000U

#define MSK_NX500_gpio_counter1_ctrl_run            0x00000001U
#define SRT_NX500_gpio_counter1_ctrl_run            0
#define DFLT_VAL_NX500_gpio_counter1_ctrl_run       0x00000000U
#define MSK_NX500_gpio_counter1_ctrl_sym_nasym      0x00000002U
#define SRT_NX500_gpio_counter1_ctrl_sym_nasym      1
#define DFLT_VAL_NX500_gpio_counter1_ctrl_sym_nasym 0x00000000U
#define MSK_NX500_gpio_counter1_ctrl_once           0x00000004U
#define SRT_NX500_gpio_counter1_ctrl_once           2
#define DFLT_VAL_NX500_gpio_counter1_ctrl_once      0x00000000U
#define MSK_NX500_gpio_counter1_ctrl_irq_en         0x00000008U
#define SRT_NX500_gpio_counter1_ctrl_irq_en         3
#define DFLT_VAL_NX500_gpio_counter1_ctrl_irq_en    0x00000000U
#define MSK_NX500_gpio_counter1_ctrl_cnt_event      0x00000010U
#define SRT_NX500_gpio_counter1_ctrl_cnt_event      4
#define DFLT_VAL_NX500_gpio_counter1_ctrl_cnt_event 0x00000000U
#define MSK_NX500_gpio_counter1_ctrl_rst_en         0x00000020U
#define SRT_NX500_gpio_counter1_ctrl_rst_en         5
#define DFLT_VAL_NX500_gpio_counter1_ctrl_rst_en    0x00000000U
#define MSK_NX500_gpio_counter1_ctrl_sel_event      0x00000040U
#define SRT_NX500_gpio_counter1_ctrl_sel_event      6
#define DFLT_VAL_NX500_gpio_counter1_ctrl_sel_event 0x00000000U
#define MSK_NX500_gpio_counter1_ctrl_gpio_ref       0x00000780U
#define SRT_NX500_gpio_counter1_ctrl_gpio_ref       7
#define DFLT_VAL_NX500_gpio_counter1_ctrl_gpio_ref  0x00000000U

enum {
	BFW_NX500_gpio_counter1_ctrl_run       = 1,  /* [0] */
	BFW_NX500_gpio_counter1_ctrl_sym_nasym = 1,  /* [1] */
	BFW_NX500_gpio_counter1_ctrl_once      = 1,  /* [2] */
	BFW_NX500_gpio_counter1_ctrl_irq_en    = 1,  /* [3] */
	BFW_NX500_gpio_counter1_ctrl_cnt_event = 1,  /* [4] */
	BFW_NX500_gpio_counter1_ctrl_rst_en    = 1,  /* [5] */
	BFW_NX500_gpio_counter1_ctrl_sel_event = 1,  /* [6] */
	BFW_NX500_gpio_counter1_ctrl_gpio_ref  = 4,  /* [10:7] */
	BFW_NX500_gpio_counter1_ctrl_reserved1 = 21  /* [31:11] */
};

typedef struct NX500_GPIO_COUNTER1_CTRL_BIT_Ttag {
	unsigned int run       : BFW_NX500_gpio_counter1_ctrl_run;       /* 1 .. start counter; 0 .. stop counter                                 */
	unsigned int sym_nasym : BFW_NX500_gpio_counter1_ctrl_sym_nasym; /* 1 .. symmetric mode (triangle); 0 .. asymmetric mode (sawtooth)       */
	unsigned int once      : BFW_NX500_gpio_counter1_ctrl_once;      /* 1 .. count once; 0 .. count continue                                  */
	unsigned int irq_en    : BFW_NX500_gpio_counter1_ctrl_irq_en;    /* 1 .. enable interrupt request; 0 .. disable interrupt request         */
	unsigned int cnt_event : BFW_NX500_gpio_counter1_ctrl_cnt_event; /* 1 .. count external event (edge, level); 0 .. count every clock cycle */
	unsigned int rst_en    : BFW_NX500_gpio_counter1_ctrl_rst_en;    /* 1 .. enable automatic reset; 0 .. disable automatic reset             */
	unsigned int sel_event : BFW_NX500_gpio_counter1_ctrl_sel_event; /* select external event                                                 */
	                                                                 /* 0 .. (high) level                                                     */
	unsigned int gpio_ref  : BFW_NX500_gpio_counter1_ctrl_gpio_ref;  /* gpio reference (0 - 15)                                               */
	unsigned int reserved1 : BFW_NX500_gpio_counter1_ctrl_reserved1; /* reserved                                                              */
} NX500_GPIO_COUNTER1_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_GPIO_COUNTER1_CTRL_BIT_T bf;
} NX500_GPIO_COUNTER1_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter2_ctrl */
/* => GPIO counter2 control register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_counter2_ctrl  0x00000088U
#define Adr_NX500_gpio_gpio_counter2_ctrl 0x00100888U
#define Adr_NX500_gpio_counter2_ctrl      0x00100888U
#define DFLT_VAL_NX500_gpio_counter2_ctrl 0x00000000U

#define MSK_NX500_gpio_counter2_ctrl_run            0x00000001U
#define SRT_NX500_gpio_counter2_ctrl_run            0
#define DFLT_VAL_NX500_gpio_counter2_ctrl_run       0x00000000U
#define MSK_NX500_gpio_counter2_ctrl_sym_nasym      0x00000002U
#define SRT_NX500_gpio_counter2_ctrl_sym_nasym      1
#define DFLT_VAL_NX500_gpio_counter2_ctrl_sym_nasym 0x00000000U
#define MSK_NX500_gpio_counter2_ctrl_once           0x00000004U
#define SRT_NX500_gpio_counter2_ctrl_once           2
#define DFLT_VAL_NX500_gpio_counter2_ctrl_once      0x00000000U
#define MSK_NX500_gpio_counter2_ctrl_irq_en         0x00000008U
#define SRT_NX500_gpio_counter2_ctrl_irq_en         3
#define DFLT_VAL_NX500_gpio_counter2_ctrl_irq_en    0x00000000U
#define MSK_NX500_gpio_counter2_ctrl_cnt_event      0x00000010U
#define SRT_NX500_gpio_counter2_ctrl_cnt_event      4
#define DFLT_VAL_NX500_gpio_counter2_ctrl_cnt_event 0x00000000U
#define MSK_NX500_gpio_counter2_ctrl_rst_en         0x00000020U
#define SRT_NX500_gpio_counter2_ctrl_rst_en         5
#define DFLT_VAL_NX500_gpio_counter2_ctrl_rst_en    0x00000000U
#define MSK_NX500_gpio_counter2_ctrl_sel_event      0x00000040U
#define SRT_NX500_gpio_counter2_ctrl_sel_event      6
#define DFLT_VAL_NX500_gpio_counter2_ctrl_sel_event 0x00000000U
#define MSK_NX500_gpio_counter2_ctrl_gpio_ref       0x00000780U
#define SRT_NX500_gpio_counter2_ctrl_gpio_ref       7
#define DFLT_VAL_NX500_gpio_counter2_ctrl_gpio_ref  0x00000000U

enum {
	BFW_NX500_gpio_counter2_ctrl_run       = 1,  /* [0] */
	BFW_NX500_gpio_counter2_ctrl_sym_nasym = 1,  /* [1] */
	BFW_NX500_gpio_counter2_ctrl_once      = 1,  /* [2] */
	BFW_NX500_gpio_counter2_ctrl_irq_en    = 1,  /* [3] */
	BFW_NX500_gpio_counter2_ctrl_cnt_event = 1,  /* [4] */
	BFW_NX500_gpio_counter2_ctrl_rst_en    = 1,  /* [5] */
	BFW_NX500_gpio_counter2_ctrl_sel_event = 1,  /* [6] */
	BFW_NX500_gpio_counter2_ctrl_gpio_ref  = 4,  /* [10:7] */
	BFW_NX500_gpio_counter2_ctrl_reserved1 = 21  /* [31:11] */
};

typedef struct NX500_GPIO_COUNTER2_CTRL_BIT_Ttag {
	unsigned int run       : BFW_NX500_gpio_counter2_ctrl_run;       /* 1 .. start counter; 0 .. stop counter                                 */
	unsigned int sym_nasym : BFW_NX500_gpio_counter2_ctrl_sym_nasym; /* 1 .. symmetric mode (triangle); 0 .. asymmetric mode (sawtooth)       */
	unsigned int once      : BFW_NX500_gpio_counter2_ctrl_once;      /* 1 .. count once; 0 .. count continue                                  */
	unsigned int irq_en    : BFW_NX500_gpio_counter2_ctrl_irq_en;    /* 1 .. enable interrupt request; 0 .. disable interrupt request         */
	unsigned int cnt_event : BFW_NX500_gpio_counter2_ctrl_cnt_event; /* 1 .. count external event (edge, level); 0 .. count every clock cycle */
	unsigned int rst_en    : BFW_NX500_gpio_counter2_ctrl_rst_en;    /* 1 .. enable automatic reset; 0 .. disable automatic reset             */
	unsigned int sel_event : BFW_NX500_gpio_counter2_ctrl_sel_event; /* select external event                                                 */
	                                                                 /* 0 .. (high) level                                                     */
	unsigned int gpio_ref  : BFW_NX500_gpio_counter2_ctrl_gpio_ref;  /* gpio reference (0 - 15)                                               */
	unsigned int reserved1 : BFW_NX500_gpio_counter2_ctrl_reserved1; /* reserved                                                              */
} NX500_GPIO_COUNTER2_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_GPIO_COUNTER2_CTRL_BIT_T bf;
} NX500_GPIO_COUNTER2_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter3_ctrl */
/* => GPIO counter3 control register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_counter3_ctrl  0x0000008CU
#define Adr_NX500_gpio_gpio_counter3_ctrl 0x0010088CU
#define Adr_NX500_gpio_counter3_ctrl      0x0010088CU
#define DFLT_VAL_NX500_gpio_counter3_ctrl 0x00000000U

#define MSK_NX500_gpio_counter3_ctrl_run            0x00000001U
#define SRT_NX500_gpio_counter3_ctrl_run            0
#define DFLT_VAL_NX500_gpio_counter3_ctrl_run       0x00000000U
#define MSK_NX500_gpio_counter3_ctrl_sym_nasym      0x00000002U
#define SRT_NX500_gpio_counter3_ctrl_sym_nasym      1
#define DFLT_VAL_NX500_gpio_counter3_ctrl_sym_nasym 0x00000000U
#define MSK_NX500_gpio_counter3_ctrl_once           0x00000004U
#define SRT_NX500_gpio_counter3_ctrl_once           2
#define DFLT_VAL_NX500_gpio_counter3_ctrl_once      0x00000000U
#define MSK_NX500_gpio_counter3_ctrl_irq_en         0x00000008U
#define SRT_NX500_gpio_counter3_ctrl_irq_en         3
#define DFLT_VAL_NX500_gpio_counter3_ctrl_irq_en    0x00000000U
#define MSK_NX500_gpio_counter3_ctrl_cnt_event      0x00000010U
#define SRT_NX500_gpio_counter3_ctrl_cnt_event      4
#define DFLT_VAL_NX500_gpio_counter3_ctrl_cnt_event 0x00000000U
#define MSK_NX500_gpio_counter3_ctrl_rst_en         0x00000020U
#define SRT_NX500_gpio_counter3_ctrl_rst_en         5
#define DFLT_VAL_NX500_gpio_counter3_ctrl_rst_en    0x00000000U
#define MSK_NX500_gpio_counter3_ctrl_sel_event      0x00000040U
#define SRT_NX500_gpio_counter3_ctrl_sel_event      6
#define DFLT_VAL_NX500_gpio_counter3_ctrl_sel_event 0x00000000U
#define MSK_NX500_gpio_counter3_ctrl_gpio_ref       0x00000780U
#define SRT_NX500_gpio_counter3_ctrl_gpio_ref       7
#define DFLT_VAL_NX500_gpio_counter3_ctrl_gpio_ref  0x00000000U

enum {
	BFW_NX500_gpio_counter3_ctrl_run       = 1,  /* [0] */
	BFW_NX500_gpio_counter3_ctrl_sym_nasym = 1,  /* [1] */
	BFW_NX500_gpio_counter3_ctrl_once      = 1,  /* [2] */
	BFW_NX500_gpio_counter3_ctrl_irq_en    = 1,  /* [3] */
	BFW_NX500_gpio_counter3_ctrl_cnt_event = 1,  /* [4] */
	BFW_NX500_gpio_counter3_ctrl_rst_en    = 1,  /* [5] */
	BFW_NX500_gpio_counter3_ctrl_sel_event = 1,  /* [6] */
	BFW_NX500_gpio_counter3_ctrl_gpio_ref  = 4,  /* [10:7] */
	BFW_NX500_gpio_counter3_ctrl_reserved1 = 21  /* [31:11] */
};

typedef struct NX500_GPIO_COUNTER3_CTRL_BIT_Ttag {
	unsigned int run       : BFW_NX500_gpio_counter3_ctrl_run;       /* 1 .. start counter; 0 .. stop counter                                 */
	unsigned int sym_nasym : BFW_NX500_gpio_counter3_ctrl_sym_nasym; /* 1 .. symmetric mode (triangle); 0 .. asymmetric mode (sawtooth)       */
	unsigned int once      : BFW_NX500_gpio_counter3_ctrl_once;      /* 1 .. count once; 0 .. count continue                                  */
	unsigned int irq_en    : BFW_NX500_gpio_counter3_ctrl_irq_en;    /* 1 .. enable interrupt request; 0 .. disable interrupt request         */
	unsigned int cnt_event : BFW_NX500_gpio_counter3_ctrl_cnt_event; /* 1 .. count external event (edge, level); 0 .. count every clock cycle */
	unsigned int rst_en    : BFW_NX500_gpio_counter3_ctrl_rst_en;    /* 1 .. enable automatic reset; 0 .. disable automatic reset             */
	unsigned int sel_event : BFW_NX500_gpio_counter3_ctrl_sel_event; /* select external event                                                 */
	                                                                 /* 0 .. (high) level                                                     */
	unsigned int gpio_ref  : BFW_NX500_gpio_counter3_ctrl_gpio_ref;  /* gpio reference (0 - 15)                                               */
	unsigned int reserved1 : BFW_NX500_gpio_counter3_ctrl_reserved1; /* reserved                                                              */
} NX500_GPIO_COUNTER3_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_GPIO_COUNTER3_CTRL_BIT_T bf;
} NX500_GPIO_COUNTER3_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter4_ctrl */
/* => GPIO counter4 control register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_counter4_ctrl  0x00000090U
#define Adr_NX500_gpio_gpio_counter4_ctrl 0x00100890U
#define Adr_NX500_gpio_counter4_ctrl      0x00100890U
#define DFLT_VAL_NX500_gpio_counter4_ctrl 0x00000000U

#define MSK_NX500_gpio_counter4_ctrl_run            0x00000001U
#define SRT_NX500_gpio_counter4_ctrl_run            0
#define DFLT_VAL_NX500_gpio_counter4_ctrl_run       0x00000000U
#define MSK_NX500_gpio_counter4_ctrl_sym_nasym      0x00000002U
#define SRT_NX500_gpio_counter4_ctrl_sym_nasym      1
#define DFLT_VAL_NX500_gpio_counter4_ctrl_sym_nasym 0x00000000U
#define MSK_NX500_gpio_counter4_ctrl_once           0x00000004U
#define SRT_NX500_gpio_counter4_ctrl_once           2
#define DFLT_VAL_NX500_gpio_counter4_ctrl_once      0x00000000U
#define MSK_NX500_gpio_counter4_ctrl_irq_en         0x00000008U
#define SRT_NX500_gpio_counter4_ctrl_irq_en         3
#define DFLT_VAL_NX500_gpio_counter4_ctrl_irq_en    0x00000000U
#define MSK_NX500_gpio_counter4_ctrl_cnt_event      0x00000010U
#define SRT_NX500_gpio_counter4_ctrl_cnt_event      4
#define DFLT_VAL_NX500_gpio_counter4_ctrl_cnt_event 0x00000000U
#define MSK_NX500_gpio_counter4_ctrl_rst_en         0x00000020U
#define SRT_NX500_gpio_counter4_ctrl_rst_en         5
#define DFLT_VAL_NX500_gpio_counter4_ctrl_rst_en    0x00000000U
#define MSK_NX500_gpio_counter4_ctrl_sel_event      0x00000040U
#define SRT_NX500_gpio_counter4_ctrl_sel_event      6
#define DFLT_VAL_NX500_gpio_counter4_ctrl_sel_event 0x00000000U
#define MSK_NX500_gpio_counter4_ctrl_gpio_ref       0x00000780U
#define SRT_NX500_gpio_counter4_ctrl_gpio_ref       7
#define DFLT_VAL_NX500_gpio_counter4_ctrl_gpio_ref  0x00000000U

enum {
	BFW_NX500_gpio_counter4_ctrl_run       = 1,  /* [0] */
	BFW_NX500_gpio_counter4_ctrl_sym_nasym = 1,  /* [1] */
	BFW_NX500_gpio_counter4_ctrl_once      = 1,  /* [2] */
	BFW_NX500_gpio_counter4_ctrl_irq_en    = 1,  /* [3] */
	BFW_NX500_gpio_counter4_ctrl_cnt_event = 1,  /* [4] */
	BFW_NX500_gpio_counter4_ctrl_rst_en    = 1,  /* [5] */
	BFW_NX500_gpio_counter4_ctrl_sel_event = 1,  /* [6] */
	BFW_NX500_gpio_counter4_ctrl_gpio_ref  = 4,  /* [10:7] */
	BFW_NX500_gpio_counter4_ctrl_reserved1 = 21  /* [31:11] */
};

typedef struct NX500_GPIO_COUNTER4_CTRL_BIT_Ttag {
	unsigned int run       : BFW_NX500_gpio_counter4_ctrl_run;       /* 1 .. start counter; 0 .. stop counter                                 */
	unsigned int sym_nasym : BFW_NX500_gpio_counter4_ctrl_sym_nasym; /* 1 .. symmetric mode (triangle); 0 .. asymmetric mode (sawtooth)       */
	unsigned int once      : BFW_NX500_gpio_counter4_ctrl_once;      /* 1 .. count once; 0 .. count continue                                  */
	unsigned int irq_en    : BFW_NX500_gpio_counter4_ctrl_irq_en;    /* 1 .. enable interrupt request; 0 .. disable interrupt request         */
	unsigned int cnt_event : BFW_NX500_gpio_counter4_ctrl_cnt_event; /* 1 .. count external event (edge, level); 0 .. count every clock cycle */
	unsigned int rst_en    : BFW_NX500_gpio_counter4_ctrl_rst_en;    /* 1 .. enable automatic reset; 0 .. disable automatic reset             */
	unsigned int sel_event : BFW_NX500_gpio_counter4_ctrl_sel_event; /* select external event                                                 */
	                                                                 /* 0 .. (high) level                                                     */
	unsigned int gpio_ref  : BFW_NX500_gpio_counter4_ctrl_gpio_ref;  /* gpio reference (0 - 15)                                               */
	unsigned int reserved1 : BFW_NX500_gpio_counter4_ctrl_reserved1; /* reserved                                                              */
} NX500_GPIO_COUNTER4_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_GPIO_COUNTER4_CTRL_BIT_T bf;
} NX500_GPIO_COUNTER4_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter0_max */
/* => GPIO counter0 max value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_counter0_max  0x00000094U
#define Adr_NX500_gpio_gpio_counter0_max 0x00100894U
#define Adr_NX500_gpio_counter0_max      0x00100894U
#define DFLT_VAL_NX500_gpio_counter0_max 0x00000000U

#define MSK_NX500_gpio_counter0_max_val      0xffffffffU
#define SRT_NX500_gpio_counter0_max_val      0
#define DFLT_VAL_NX500_gpio_counter0_max_val 0x00000000U

enum {
	BFW_NX500_gpio_counter0_max_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_COUNTER0_MAX_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_counter0_max_val; /* max. counter value where the counter switches from upcounting to */
	                                                    /* downcounting (symmetric mode) or jumps to zero (asymmetric mode) */
} NX500_GPIO_COUNTER0_MAX_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_GPIO_COUNTER0_MAX_BIT_T bf;
} NX500_GPIO_COUNTER0_MAX_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter1_max */
/* => GPIO counter1 max value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_counter1_max  0x00000098U
#define Adr_NX500_gpio_gpio_counter1_max 0x00100898U
#define Adr_NX500_gpio_counter1_max      0x00100898U
#define DFLT_VAL_NX500_gpio_counter1_max 0x00000000U

#define MSK_NX500_gpio_counter1_max_val      0xffffffffU
#define SRT_NX500_gpio_counter1_max_val      0
#define DFLT_VAL_NX500_gpio_counter1_max_val 0x00000000U

enum {
	BFW_NX500_gpio_counter1_max_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_COUNTER1_MAX_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_counter1_max_val; /* max. counter value where the counter switches from upcounting to */
	                                                    /* downcounting (symmetric mode) or jumps to zero (asymmetric mode) */
} NX500_GPIO_COUNTER1_MAX_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_GPIO_COUNTER1_MAX_BIT_T bf;
} NX500_GPIO_COUNTER1_MAX_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter2_max */
/* => GPIO counter2 max value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_counter2_max  0x0000009CU
#define Adr_NX500_gpio_gpio_counter2_max 0x0010089CU
#define Adr_NX500_gpio_counter2_max      0x0010089CU
#define DFLT_VAL_NX500_gpio_counter2_max 0x00000000U

#define MSK_NX500_gpio_counter2_max_val      0xffffffffU
#define SRT_NX500_gpio_counter2_max_val      0
#define DFLT_VAL_NX500_gpio_counter2_max_val 0x00000000U

enum {
	BFW_NX500_gpio_counter2_max_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_COUNTER2_MAX_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_counter2_max_val; /* max. counter value where the counter switches from upcounting to */
	                                                    /* downcounting (symmetric mode) or jumps to zero (asymmetric mode) */
} NX500_GPIO_COUNTER2_MAX_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_GPIO_COUNTER2_MAX_BIT_T bf;
} NX500_GPIO_COUNTER2_MAX_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter3_max */
/* => GPIO counter3 max value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_counter3_max  0x000000A0U
#define Adr_NX500_gpio_gpio_counter3_max 0x001008A0U
#define Adr_NX500_gpio_counter3_max      0x001008A0U
#define DFLT_VAL_NX500_gpio_counter3_max 0x00000000U

#define MSK_NX500_gpio_counter3_max_val      0xffffffffU
#define SRT_NX500_gpio_counter3_max_val      0
#define DFLT_VAL_NX500_gpio_counter3_max_val 0x00000000U

enum {
	BFW_NX500_gpio_counter3_max_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_COUNTER3_MAX_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_counter3_max_val; /* max. counter value where the counter switches from upcounting to */
	                                                    /* downcounting (symmetric mode) or jumps to zero (asymmetric mode) */
} NX500_GPIO_COUNTER3_MAX_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_GPIO_COUNTER3_MAX_BIT_T bf;
} NX500_GPIO_COUNTER3_MAX_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter4_max */
/* => GPIO counter4 max value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_counter4_max  0x000000A4U
#define Adr_NX500_gpio_gpio_counter4_max 0x001008A4U
#define Adr_NX500_gpio_counter4_max      0x001008A4U
#define DFLT_VAL_NX500_gpio_counter4_max 0x00000000U

#define MSK_NX500_gpio_counter4_max_val      0xffffffffU
#define SRT_NX500_gpio_counter4_max_val      0
#define DFLT_VAL_NX500_gpio_counter4_max_val 0x00000000U

enum {
	BFW_NX500_gpio_counter4_max_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_COUNTER4_MAX_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_counter4_max_val; /* max. counter value where the counter switches from upcounting to */
	                                                    /* downcounting (symmetric mode) or jumps to zero (asymmetric mode) */
} NX500_GPIO_COUNTER4_MAX_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_GPIO_COUNTER4_MAX_BIT_T bf;
} NX500_GPIO_COUNTER4_MAX_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter0_cnt */
/* => GPIO counter0 current value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_counter0_cnt  0x000000A8U
#define Adr_NX500_gpio_gpio_counter0_cnt 0x001008A8U
#define Adr_NX500_gpio_counter0_cnt      0x001008A8U
#define DFLT_VAL_NX500_gpio_counter0_cnt 0x00000000U

#define MSK_NX500_gpio_counter0_cnt_val      0xffffffffU
#define SRT_NX500_gpio_counter0_cnt_val      0
#define DFLT_VAL_NX500_gpio_counter0_cnt_val 0x00000000U

enum {
	BFW_NX500_gpio_counter0_cnt_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_COUNTER0_CNT_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_counter0_cnt_val; /* curent counter value */
} NX500_GPIO_COUNTER0_CNT_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_GPIO_COUNTER0_CNT_BIT_T bf;
} NX500_GPIO_COUNTER0_CNT_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter1_cnt */
/* => GPIO counter1 current value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_counter1_cnt  0x000000ACU
#define Adr_NX500_gpio_gpio_counter1_cnt 0x001008ACU
#define Adr_NX500_gpio_counter1_cnt      0x001008ACU
#define DFLT_VAL_NX500_gpio_counter1_cnt 0x00000000U

#define MSK_NX500_gpio_counter1_cnt_val      0xffffffffU
#define SRT_NX500_gpio_counter1_cnt_val      0
#define DFLT_VAL_NX500_gpio_counter1_cnt_val 0x00000000U

enum {
	BFW_NX500_gpio_counter1_cnt_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_COUNTER1_CNT_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_counter1_cnt_val; /* curent counter value */
} NX500_GPIO_COUNTER1_CNT_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_GPIO_COUNTER1_CNT_BIT_T bf;
} NX500_GPIO_COUNTER1_CNT_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter2_cnt */
/* => GPIO counter2 current value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_counter2_cnt  0x000000B0U
#define Adr_NX500_gpio_gpio_counter2_cnt 0x001008B0U
#define Adr_NX500_gpio_counter2_cnt      0x001008B0U
#define DFLT_VAL_NX500_gpio_counter2_cnt 0x00000000U

#define MSK_NX500_gpio_counter2_cnt_val      0xffffffffU
#define SRT_NX500_gpio_counter2_cnt_val      0
#define DFLT_VAL_NX500_gpio_counter2_cnt_val 0x00000000U

enum {
	BFW_NX500_gpio_counter2_cnt_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_COUNTER2_CNT_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_counter2_cnt_val; /* curent counter value */
} NX500_GPIO_COUNTER2_CNT_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_GPIO_COUNTER2_CNT_BIT_T bf;
} NX500_GPIO_COUNTER2_CNT_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter3_cnt */
/* => GPIO counter3 current value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_counter3_cnt  0x000000B4U
#define Adr_NX500_gpio_gpio_counter3_cnt 0x001008B4U
#define Adr_NX500_gpio_counter3_cnt      0x001008B4U
#define DFLT_VAL_NX500_gpio_counter3_cnt 0x00000000U

#define MSK_NX500_gpio_counter3_cnt_val      0xffffffffU
#define SRT_NX500_gpio_counter3_cnt_val      0
#define DFLT_VAL_NX500_gpio_counter3_cnt_val 0x00000000U

enum {
	BFW_NX500_gpio_counter3_cnt_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_COUNTER3_CNT_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_counter3_cnt_val; /* curent counter value */
} NX500_GPIO_COUNTER3_CNT_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_GPIO_COUNTER3_CNT_BIT_T bf;
} NX500_GPIO_COUNTER3_CNT_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter4_cnt */
/* => GPIO counter4 current value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_counter4_cnt  0x000000B8U
#define Adr_NX500_gpio_gpio_counter4_cnt 0x001008B8U
#define Adr_NX500_gpio_counter4_cnt      0x001008B8U
#define DFLT_VAL_NX500_gpio_counter4_cnt 0x00000000U

#define MSK_NX500_gpio_counter4_cnt_val      0xffffffffU
#define SRT_NX500_gpio_counter4_cnt_val      0
#define DFLT_VAL_NX500_gpio_counter4_cnt_val 0x00000000U

enum {
	BFW_NX500_gpio_counter4_cnt_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_COUNTER4_CNT_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_counter4_cnt_val; /* curent counter value */
} NX500_GPIO_COUNTER4_CNT_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_GPIO_COUNTER4_CNT_BIT_T bf;
} NX500_GPIO_COUNTER4_CNT_T;

/* --------------------------------------------------------------------- */
/* Register gpio_irq_mask_set */
/* => GPIO interrupt enable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_irq_mask_set  0x000000BCU
#define Adr_NX500_gpio_gpio_irq_mask_set 0x001008BCU
#define Adr_NX500_gpio_irq_mask_set      0x001008BCU
#define DFLT_VAL_NX500_gpio_irq_mask_set 0x00000000U

#define MSK_NX500_gpio_irq_mask_set_gpio         0x0000ffffU
#define SRT_NX500_gpio_irq_mask_set_gpio         0
#define DFLT_VAL_NX500_gpio_irq_mask_set_gpio    0x00000000U
#define MSK_NX500_gpio_irq_mask_set_cnt0         0x00010000U
#define SRT_NX500_gpio_irq_mask_set_cnt0         16
#define DFLT_VAL_NX500_gpio_irq_mask_set_cnt0    0x00000000U
#define MSK_NX500_gpio_irq_mask_set_cnt1         0x00020000U
#define SRT_NX500_gpio_irq_mask_set_cnt1         17
#define DFLT_VAL_NX500_gpio_irq_mask_set_cnt1    0x00000000U
#define MSK_NX500_gpio_irq_mask_set_cnt2         0x00040000U
#define SRT_NX500_gpio_irq_mask_set_cnt2         18
#define DFLT_VAL_NX500_gpio_irq_mask_set_cnt2    0x00000000U
#define MSK_NX500_gpio_irq_mask_set_cnt3         0x00080000U
#define SRT_NX500_gpio_irq_mask_set_cnt3         19
#define DFLT_VAL_NX500_gpio_irq_mask_set_cnt3    0x00000000U
#define MSK_NX500_gpio_irq_mask_set_cnt4         0x00100000U
#define SRT_NX500_gpio_irq_mask_set_cnt4         20
#define DFLT_VAL_NX500_gpio_irq_mask_set_cnt4    0x00000000U
#define MSK_NX500_gpio_irq_mask_set_systime      0x00200000U
#define SRT_NX500_gpio_irq_mask_set_systime      21
#define DFLT_VAL_NX500_gpio_irq_mask_set_systime 0x00000000U

enum {
	BFW_NX500_gpio_irq_mask_set_gpio      = 16, /* [15:0] */
	BFW_NX500_gpio_irq_mask_set_cnt0      = 1,  /* [16] */
	BFW_NX500_gpio_irq_mask_set_cnt1      = 1,  /* [17] */
	BFW_NX500_gpio_irq_mask_set_cnt2      = 1,  /* [18] */
	BFW_NX500_gpio_irq_mask_set_cnt3      = 1,  /* [19] */
	BFW_NX500_gpio_irq_mask_set_cnt4      = 1,  /* [20] */
	BFW_NX500_gpio_irq_mask_set_systime   = 1,  /* [21] */
	BFW_NX500_gpio_irq_mask_set_reserved1 = 10  /* [31:22] */
};

typedef struct NX500_GPIO_IRQ_MASK_SET_BIT_Ttag {
	unsigned int gpio      : BFW_NX500_gpio_irq_mask_set_gpio;      /* enable interrupt request for every gpio                 */
	unsigned int cnt0      : BFW_NX500_gpio_irq_mask_set_cnt0;      /* enable interrupt request for counter0                   */
	unsigned int cnt1      : BFW_NX500_gpio_irq_mask_set_cnt1;      /* enable interrupt request for counter1                   */
	unsigned int cnt2      : BFW_NX500_gpio_irq_mask_set_cnt2;      /* enable interrupt request for counter2                   */
	unsigned int cnt3      : BFW_NX500_gpio_irq_mask_set_cnt3;      /* enable interrupt request for counter3                   */
	unsigned int cnt4      : BFW_NX500_gpio_irq_mask_set_cnt4;      /* enable interrupt request for counter4                   */
	unsigned int systime   : BFW_NX500_gpio_irq_mask_set_systime;   /* enable interrupt request if sys_time = gpio_systime_cmp */
	unsigned int reserved1 : BFW_NX500_gpio_irq_mask_set_reserved1; /* reserved                                                */
} NX500_GPIO_IRQ_MASK_SET_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_GPIO_IRQ_MASK_SET_BIT_T bf;
} NX500_GPIO_IRQ_MASK_SET_T;

/* --------------------------------------------------------------------- */
/* Register gpio_irq_mask_rst */
/* => GPIO interrupt disable */
/* => Mode: W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_irq_mask_rst  0x000000C0U
#define Adr_NX500_gpio_gpio_irq_mask_rst 0x001008C0U
#define Adr_NX500_gpio_irq_mask_rst      0x001008C0U
#define DFLT_VAL_NX500_gpio_irq_mask_rst 0x00000000U

#define MSK_NX500_gpio_irq_mask_rst_gpio         0x0000ffffU
#define SRT_NX500_gpio_irq_mask_rst_gpio         0
#define DFLT_VAL_NX500_gpio_irq_mask_rst_gpio    0x00000000U
#define MSK_NX500_gpio_irq_mask_rst_cnt0         0x00010000U
#define SRT_NX500_gpio_irq_mask_rst_cnt0         16
#define DFLT_VAL_NX500_gpio_irq_mask_rst_cnt0    0x00000000U
#define MSK_NX500_gpio_irq_mask_rst_cnt1         0x00020000U
#define SRT_NX500_gpio_irq_mask_rst_cnt1         17
#define DFLT_VAL_NX500_gpio_irq_mask_rst_cnt1    0x00000000U
#define MSK_NX500_gpio_irq_mask_rst_cnt2         0x00040000U
#define SRT_NX500_gpio_irq_mask_rst_cnt2         18
#define DFLT_VAL_NX500_gpio_irq_mask_rst_cnt2    0x00000000U
#define MSK_NX500_gpio_irq_mask_rst_cnt3         0x00080000U
#define SRT_NX500_gpio_irq_mask_rst_cnt3         19
#define DFLT_VAL_NX500_gpio_irq_mask_rst_cnt3    0x00000000U
#define MSK_NX500_gpio_irq_mask_rst_cnt4         0x00100000U
#define SRT_NX500_gpio_irq_mask_rst_cnt4         20
#define DFLT_VAL_NX500_gpio_irq_mask_rst_cnt4    0x00000000U
#define MSK_NX500_gpio_irq_mask_rst_systime      0x00200000U
#define SRT_NX500_gpio_irq_mask_rst_systime      21
#define DFLT_VAL_NX500_gpio_irq_mask_rst_systime 0x00000000U

enum {
	BFW_NX500_gpio_irq_mask_rst_gpio      = 16, /* [15:0] */
	BFW_NX500_gpio_irq_mask_rst_cnt0      = 1,  /* [16] */
	BFW_NX500_gpio_irq_mask_rst_cnt1      = 1,  /* [17] */
	BFW_NX500_gpio_irq_mask_rst_cnt2      = 1,  /* [18] */
	BFW_NX500_gpio_irq_mask_rst_cnt3      = 1,  /* [19] */
	BFW_NX500_gpio_irq_mask_rst_cnt4      = 1,  /* [20] */
	BFW_NX500_gpio_irq_mask_rst_systime   = 1,  /* [21] */
	BFW_NX500_gpio_irq_mask_rst_reserved1 = 10  /* [31:22] */
};

typedef struct NX500_GPIO_IRQ_MASK_RST_BIT_Ttag {
	unsigned int gpio      : BFW_NX500_gpio_irq_mask_rst_gpio;      /* write access with '1' disables interrupt request for corresponding gpio */
	unsigned int cnt0      : BFW_NX500_gpio_irq_mask_rst_cnt0;      /* write access with '1' disables interrupt request for counter0           */
	unsigned int cnt1      : BFW_NX500_gpio_irq_mask_rst_cnt1;      /* write access with '1' disables interrupt request for counter1           */
	unsigned int cnt2      : BFW_NX500_gpio_irq_mask_rst_cnt2;      /* write access with '1' disables interrupt request for counter2           */
	unsigned int cnt3      : BFW_NX500_gpio_irq_mask_rst_cnt3;      /* write access with '1' disables interrupt request for counter3           */
	unsigned int cnt4      : BFW_NX500_gpio_irq_mask_rst_cnt4;      /* write access with '1' disables interrupt request for counter4           */
	unsigned int systime   : BFW_NX500_gpio_irq_mask_rst_systime;   /* write access with '1' disables interrupt request for sys_time           */
	unsigned int reserved1 : BFW_NX500_gpio_irq_mask_rst_reserved1; /* reserved                                                                */
} NX500_GPIO_IRQ_MASK_RST_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_GPIO_IRQ_MASK_RST_BIT_T bf;
} NX500_GPIO_IRQ_MASK_RST_T;

/* --------------------------------------------------------------------- */
/* Register gpio_systime_cmp */
/* => GPIO sys_time compare value */
/*    compares this value with systime_ns considering incontinous behaviour of systime_ns */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_systime_cmp  0x000000C4U
#define Adr_NX500_gpio_gpio_systime_cmp 0x001008C4U
#define Adr_NX500_gpio_systime_cmp      0x001008C4U
#define DFLT_VAL_NX500_gpio_systime_cmp 0x00000000U

#define MSK_NX500_gpio_systime_cmp_val      0xffffffffU
#define SRT_NX500_gpio_systime_cmp_val      0
#define DFLT_VAL_NX500_gpio_systime_cmp_val 0x00000000U

enum {
	BFW_NX500_gpio_systime_cmp_val = 32  /* [31:0] */
};

typedef struct NX500_GPIO_SYSTIME_CMP_BIT_Ttag {
	unsigned int val : BFW_NX500_gpio_systime_cmp_val; /* compare value for systime */
} NX500_GPIO_SYSTIME_CMP_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_GPIO_SYSTIME_CMP_BIT_T bf;
} NX500_GPIO_SYSTIME_CMP_T;

/* --------------------------------------------------------------------- */
/* Register gpio_line */
/* => GPIO line register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_line  0x000000C8U
#define Adr_NX500_gpio_gpio_line 0x001008C8U
#define Adr_NX500_gpio_line      0x001008C8U
#define DFLT_VAL_NX500_gpio_line 0x00000000U

#define MSK_NX500_gpio_line_val      0x0000ffffU
#define SRT_NX500_gpio_line_val      0
#define DFLT_VAL_NX500_gpio_line_val 0x00000000U

enum {
	BFW_NX500_gpio_line_val       = 16, /* [15:0] */
	BFW_NX500_gpio_line_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_GPIO_LINE_BIT_Ttag {
	unsigned int val       : BFW_NX500_gpio_line_val;       /* gpio output values */
	unsigned int reserved1 : BFW_NX500_gpio_line_reserved1; /* reserved           */
} NX500_GPIO_LINE_BIT_T;

typedef union {
	unsigned int          val;
	NX500_GPIO_LINE_BIT_T bf;
} NX500_GPIO_LINE_T;

/* --------------------------------------------------------------------- */
/* Register gpio_in */
/* => GPIO latched register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_in  0x000000CCU
#define Adr_NX500_gpio_gpio_in 0x001008CCU
#define Adr_NX500_gpio_in      0x001008CCU

#define MSK_NX500_gpio_in_val 0x0000ffffU
#define SRT_NX500_gpio_in_val 0

enum {
	BFW_NX500_gpio_in_val       = 16, /* [15:0] */
	BFW_NX500_gpio_in_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_GPIO_IN_BIT_Ttag {
	unsigned int val       : BFW_NX500_gpio_in_val;       /* gpio input values */
	unsigned int reserved1 : BFW_NX500_gpio_in_reserved1; /* reserved          */
} NX500_GPIO_IN_BIT_T;

typedef union {
	unsigned int        val;
	NX500_GPIO_IN_BIT_T bf;
} NX500_GPIO_IN_T;

/* --------------------------------------------------------------------- */
/* Register gpio_irq */
/* => GPIO irq register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_gpio_irq  0x000000D0U
#define Adr_NX500_gpio_gpio_irq 0x001008D0U
#define Adr_NX500_gpio_irq      0x001008D0U
#define DFLT_VAL_NX500_gpio_irq 0x00000000U

#define MSK_NX500_gpio_irq_gpio          0x0000ffffU
#define SRT_NX500_gpio_irq_gpio          0
#define DFLT_VAL_NX500_gpio_irq_gpio     0x00000000U
#define MSK_NX500_gpio_irq_cnt0          0x00010000U
#define SRT_NX500_gpio_irq_cnt0          16
#define DFLT_VAL_NX500_gpio_irq_cnt0     0x00000000U
#define MSK_NX500_gpio_irq_cnt1          0x00020000U
#define SRT_NX500_gpio_irq_cnt1          17
#define DFLT_VAL_NX500_gpio_irq_cnt1     0x00000000U
#define MSK_NX500_gpio_irq_cnt2          0x00040000U
#define SRT_NX500_gpio_irq_cnt2          18
#define DFLT_VAL_NX500_gpio_irq_cnt2     0x00000000U
#define MSK_NX500_gpio_irq_cnt3          0x00080000U
#define SRT_NX500_gpio_irq_cnt3          19
#define DFLT_VAL_NX500_gpio_irq_cnt3     0x00000000U
#define MSK_NX500_gpio_irq_cnt4          0x00100000U
#define SRT_NX500_gpio_irq_cnt4          20
#define DFLT_VAL_NX500_gpio_irq_cnt4     0x00000000U
#define MSK_NX500_gpio_irq_sys_time      0x00200000U
#define SRT_NX500_gpio_irq_sys_time      21
#define DFLT_VAL_NX500_gpio_irq_sys_time 0x00000000U

enum {
	BFW_NX500_gpio_irq_gpio      = 16, /* [15:0] */
	BFW_NX500_gpio_irq_cnt0      = 1,  /* [16] */
	BFW_NX500_gpio_irq_cnt1      = 1,  /* [17] */
	BFW_NX500_gpio_irq_cnt2      = 1,  /* [18] */
	BFW_NX500_gpio_irq_cnt3      = 1,  /* [19] */
	BFW_NX500_gpio_irq_cnt4      = 1,  /* [20] */
	BFW_NX500_gpio_irq_sys_time  = 1,  /* [21] */
	BFW_NX500_gpio_irq_reserved1 = 10  /* [31:22] */
};

typedef struct NX500_GPIO_IRQ_BIT_Ttag {
	unsigned int gpio      : BFW_NX500_gpio_irq_gpio;      /* holds the interrupt bits for every GPIO          */
	                                                       /* write access with '1' resets the appropriate irq */
	unsigned int cnt0      : BFW_NX500_gpio_irq_cnt0;      /* hold the interrupt bit for counter0              */
	unsigned int cnt1      : BFW_NX500_gpio_irq_cnt1;      /* hold the interrupt bit for counter1              */
	unsigned int cnt2      : BFW_NX500_gpio_irq_cnt2;      /* hold the interrupt bit for counter2              */
	unsigned int cnt3      : BFW_NX500_gpio_irq_cnt3;      /* hold the interrupt bit for counter3              */
	unsigned int cnt4      : BFW_NX500_gpio_irq_cnt4;      /* hold the interrupt bit for counter4              */
	unsigned int sys_time  : BFW_NX500_gpio_irq_sys_time;  /* hold the interrupt bit for sys_time              */
	unsigned int reserved1 : BFW_NX500_gpio_irq_reserved1; /* reserved                                         */
} NX500_GPIO_IRQ_BIT_T;

typedef union {
	unsigned int         val;
	NX500_GPIO_IRQ_BIT_T bf;
} NX500_GPIO_IRQ_T;


/* ===================================================================== */

/* Area of pio */

/* ===================================================================== */

#define Addr_NX500_pio      0x00100900U
#define NX500_NETX_PIO_AREA 0x00100900U

/* --------------------------------------------------------------------- */
/* Register pio_in */
/* => PIO input register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pio_in 0x00000000U
#define Adr_NX500_pio_pio_in 0x00100900U
#define Adr_NX500_pio_in     0x00100900U

#define MSK_NX500_pio_in_val 0xffffffffU
#define SRT_NX500_pio_in_val 0

enum {
	BFW_NX500_pio_in_val = 32  /* [31:0] */
};

typedef struct NX500_PIO_IN_BIT_Ttag {
	unsigned int val : BFW_NX500_pio_in_val; /* pio input values */
} NX500_PIO_IN_BIT_T;

typedef union {
	unsigned int       val;
	NX500_PIO_IN_BIT_T bf;
} NX500_PIO_IN_T;

/* --------------------------------------------------------------------- */
/* Register pio_out */
/* => PIO output register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pio_out  0x00000004U
#define Adr_NX500_pio_pio_out  0x00100904U
#define Adr_NX500_pio_out      0x00100904U
#define DFLT_VAL_NX500_pio_out 0x00000000U

#define MSK_NX500_pio_out_val      0xffffffffU
#define SRT_NX500_pio_out_val      0
#define DFLT_VAL_NX500_pio_out_val 0x00000000U

enum {
	BFW_NX500_pio_out_val = 32  /* [31:0] */
};

typedef struct NX500_PIO_OUT_BIT_Ttag {
	unsigned int val : BFW_NX500_pio_out_val; /* pio output values */
} NX500_PIO_OUT_BIT_T;

typedef union {
	unsigned int        val;
	NX500_PIO_OUT_BIT_T bf;
} NX500_PIO_OUT_T;

/* --------------------------------------------------------------------- */
/* Register pio_oe */
/* => PIO output enable register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pio_oe  0x00000008U
#define Adr_NX500_pio_pio_oe  0x00100908U
#define Adr_NX500_pio_oe      0x00100908U
#define DFLT_VAL_NX500_pio_oe 0x00000000U

#define MSK_NX500_pio_oe_val      0xffffffffU
#define SRT_NX500_pio_oe_val      0
#define DFLT_VAL_NX500_pio_oe_val 0x00000000U

enum {
	BFW_NX500_pio_oe_val = 32  /* [31:0] */
};

typedef struct NX500_PIO_OE_BIT_Ttag {
	unsigned int val : BFW_NX500_pio_oe_val; /* pio output enables */
} NX500_PIO_OE_BIT_T;

typedef union {
	unsigned int       val;
	NX500_PIO_OE_BIT_T bf;
} NX500_PIO_OE_T;


/* ===================================================================== */

/* AREA uart */
/* Area of uart0, uart1, uart2 */

/* ===================================================================== */

#define Addr_NX500_uart0      0x00100A00U
#define NX500_NETX_UART0_AREA 0x00100A00U
#define Addr_NX500_uart1      0x00100A40U
#define NX500_NETX_UART1_AREA 0x00100A40U
#define Addr_NX500_uart2      0x00100A80U
#define NX500_NETX_UART2_AREA 0x00100A80U

/* --------------------------------------------------------------------- */
/* Register uartdr */
/* => data read or written from the interface */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_uartdr   0x00000000U
#define Adr_NX500_uart0_uartdr 0x00100A00U
#define Adr_NX500_uart1_uartdr 0x00100A40U
#define Adr_NX500_uart2_uartdr 0x00100A80U
#define DFLT_VAL_NX500_uartdr  0x00000000U

#define MSK_NX500_uartdr_DATA      0x000000ffU
#define SRT_NX500_uartdr_DATA      0
#define DFLT_VAL_NX500_uartdr_DATA 0x00000000U

enum {
	BFW_NX500_uartdr_DATA      = 8,  /* [7:0] */
	BFW_NX500_uartdr_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_UARTDR_BIT_Ttag {
	unsigned int DATA      : BFW_NX500_uartdr_DATA;      /* data read or written from the interface */
	unsigned int reserved1 : BFW_NX500_uartdr_reserved1; /* reserved                                */
} NX500_UARTDR_BIT_T;

typedef union {
	unsigned int       val;
	NX500_UARTDR_BIT_T bf;
} NX500_UARTDR_T;

/* --------------------------------------------------------------------- */
/* Register uartrsr */
/* => receive status register (read) / Error Clear Register (write) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_uartrsr   0x00000004U
#define Adr_NX500_uart0_uartrsr 0x00100A04U
#define Adr_NX500_uart1_uartrsr 0x00100A44U
#define Adr_NX500_uart2_uartrsr 0x00100A84U
#define DFLT_VAL_NX500_uartrsr  0x00000000U

#define MSK_NX500_uartrsr_FE      0x00000001U
#define SRT_NX500_uartrsr_FE      0
#define DFLT_VAL_NX500_uartrsr_FE 0x00000000U
#define MSK_NX500_uartrsr_PE      0x00000002U
#define SRT_NX500_uartrsr_PE      1
#define DFLT_VAL_NX500_uartrsr_PE 0x00000000U
#define MSK_NX500_uartrsr_BE      0x00000004U
#define SRT_NX500_uartrsr_BE      2
#define DFLT_VAL_NX500_uartrsr_BE 0x00000000U
#define MSK_NX500_uartrsr_OE      0x00000008U
#define SRT_NX500_uartrsr_OE      3
#define DFLT_VAL_NX500_uartrsr_OE 0x00000000U

enum {
	BFW_NX500_uartrsr_FE        = 1,  /* [0] */
	BFW_NX500_uartrsr_PE        = 1,  /* [1] */
	BFW_NX500_uartrsr_BE        = 1,  /* [2] */
	BFW_NX500_uartrsr_OE        = 1,  /* [3] */
	BFW_NX500_uartrsr_reserved1 = 28  /* [31:4] */
};

typedef struct NX500_UARTRSR_BIT_Ttag {
	unsigned int FE        : BFW_NX500_uartrsr_FE;        /* Framing Error */
	unsigned int PE        : BFW_NX500_uartrsr_PE;        /* Parity Error  */
	unsigned int BE        : BFW_NX500_uartrsr_BE;        /* Break Error   */
	unsigned int OE        : BFW_NX500_uartrsr_OE;        /* Overrun Error */
	unsigned int reserved1 : BFW_NX500_uartrsr_reserved1; /* reserved      */
} NX500_UARTRSR_BIT_T;

typedef union {
	unsigned int        val;
	NX500_UARTRSR_BIT_T bf;
} NX500_UARTRSR_T;

/* --------------------------------------------------------------------- */
/* Register uartlcr_h */
/* => Line control Register, high byte */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_uartlcr_h   0x00000008U
#define Adr_NX500_uart0_uartlcr_h 0x00100A08U
#define Adr_NX500_uart1_uartlcr_h 0x00100A48U
#define Adr_NX500_uart2_uartlcr_h 0x00100A88U
#define DFLT_VAL_NX500_uartlcr_h  0x00000000U

#define MSK_NX500_uartlcr_h_BRK       0x00000001U
#define SRT_NX500_uartlcr_h_BRK       0
#define DFLT_VAL_NX500_uartlcr_h_BRK  0x00000000U
#define MSK_NX500_uartlcr_h_PEN       0x00000002U
#define SRT_NX500_uartlcr_h_PEN       1
#define DFLT_VAL_NX500_uartlcr_h_PEN  0x00000000U
#define MSK_NX500_uartlcr_h_EPS       0x00000004U
#define SRT_NX500_uartlcr_h_EPS       2
#define DFLT_VAL_NX500_uartlcr_h_EPS  0x00000000U
#define MSK_NX500_uartlcr_h_STP2      0x00000008U
#define SRT_NX500_uartlcr_h_STP2      3
#define DFLT_VAL_NX500_uartlcr_h_STP2 0x00000000U
#define MSK_NX500_uartlcr_h_FEN       0x00000010U
#define SRT_NX500_uartlcr_h_FEN       4
#define DFLT_VAL_NX500_uartlcr_h_FEN  0x00000000U
#define MSK_NX500_uartlcr_h_WLEN      0x00000060U
#define SRT_NX500_uartlcr_h_WLEN      5
#define DFLT_VAL_NX500_uartlcr_h_WLEN 0x00000000U

enum {
	BFW_NX500_uartlcr_h_BRK       = 1,  /* [0] */
	BFW_NX500_uartlcr_h_PEN       = 1,  /* [1] */
	BFW_NX500_uartlcr_h_EPS       = 1,  /* [2] */
	BFW_NX500_uartlcr_h_STP2      = 1,  /* [3] */
	BFW_NX500_uartlcr_h_FEN       = 1,  /* [4] */
	BFW_NX500_uartlcr_h_WLEN      = 2,  /* [6:5] */
	BFW_NX500_uartlcr_h_reserved1 = 25  /* [31:7] */
};

typedef struct NX500_UARTLCR_H_BIT_Ttag {
	unsigned int BRK       : BFW_NX500_uartlcr_h_BRK;       /* Send Break         */
	unsigned int PEN       : BFW_NX500_uartlcr_h_PEN;       /* Parity Enalble     */
	unsigned int EPS       : BFW_NX500_uartlcr_h_EPS;       /* Even Parity Select */
	unsigned int STP2      : BFW_NX500_uartlcr_h_STP2;      /* 2 Stop Bits Select */
	unsigned int FEN       : BFW_NX500_uartlcr_h_FEN;       /* FIFO Enable        */
	unsigned int WLEN      : BFW_NX500_uartlcr_h_WLEN;      /*  Word Length       */
	                                                        /* "00" 5 bits        */
	unsigned int reserved1 : BFW_NX500_uartlcr_h_reserved1; /* reserved           */
} NX500_UARTLCR_H_BIT_T;

typedef union {
	unsigned int          val;
	NX500_UARTLCR_H_BIT_T bf;
} NX500_UARTLCR_H_T;

/* --------------------------------------------------------------------- */
/* Register uartlcr_m */
/* => Line control Register, middle byte */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_uartlcr_m   0x0000000CU
#define Adr_NX500_uart0_uartlcr_m 0x00100A0CU
#define Adr_NX500_uart1_uartlcr_m 0x00100A4CU
#define Adr_NX500_uart2_uartlcr_m 0x00100A8CU
#define DFLT_VAL_NX500_uartlcr_m  0x00000000U

#define MSK_NX500_uartlcr_m_BAUDDIVMS      0x000000ffU
#define SRT_NX500_uartlcr_m_BAUDDIVMS      0
#define DFLT_VAL_NX500_uartlcr_m_BAUDDIVMS 0x00000000U

enum {
	BFW_NX500_uartlcr_m_BAUDDIVMS = 8,  /* [7:0] */
	BFW_NX500_uartlcr_m_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_UARTLCR_M_BIT_Ttag {
	unsigned int BAUDDIVMS : BFW_NX500_uartlcr_m_BAUDDIVMS; /* bauddiv : Baud Divisor Most Significant Byte                     */
	                                                        /* use higher byte of bauddiv = (system clk / (16 * baud rate)) - 1 */
	unsigned int reserved1 : BFW_NX500_uartlcr_m_reserved1; /* reserved                                                         */
} NX500_UARTLCR_M_BIT_T;

typedef union {
	unsigned int          val;
	NX500_UARTLCR_M_BIT_T bf;
} NX500_UARTLCR_M_T;

/* --------------------------------------------------------------------- */
/* Register uartlcr_l */
/* => Line control Register, low byte */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_uartlcr_l   0x00000010U
#define Adr_NX500_uart0_uartlcr_l 0x00100A10U
#define Adr_NX500_uart1_uartlcr_l 0x00100A50U
#define Adr_NX500_uart2_uartlcr_l 0x00100A90U
#define DFLT_VAL_NX500_uartlcr_l  0x00000000U

#define MSK_NX500_uartlcr_l_BAUDDIVLS      0x000000ffU
#define SRT_NX500_uartlcr_l_BAUDDIVLS      0
#define DFLT_VAL_NX500_uartlcr_l_BAUDDIVLS 0x00000000U

enum {
	BFW_NX500_uartlcr_l_BAUDDIVLS = 8,  /* [7:0] */
	BFW_NX500_uartlcr_l_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_UARTLCR_L_BIT_Ttag {
	unsigned int BAUDDIVLS : BFW_NX500_uartlcr_l_BAUDDIVLS; /* Baud Divisor Least Significant Byte                             */
	                                                        /* use lower byte of bauddiv = (system clk / (16 * baud rate)) - 1 */
	unsigned int reserved1 : BFW_NX500_uartlcr_l_reserved1; /* reserved                                                        */
} NX500_UARTLCR_L_BIT_T;

typedef union {
	unsigned int          val;
	NX500_UARTLCR_L_BIT_T bf;
} NX500_UARTLCR_L_T;

/* --------------------------------------------------------------------- */
/* Register uartcr */
/* => uart control Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_uartcr   0x00000014U
#define Adr_NX500_uart0_uartcr 0x00100A14U
#define Adr_NX500_uart1_uartcr 0x00100A54U
#define Adr_NX500_uart2_uartcr 0x00100A94U
#define DFLT_VAL_NX500_uartcr  0x00000000U

#define MSK_NX500_uartcr_uartEN      0x00000001U
#define SRT_NX500_uartcr_uartEN      0
#define DFLT_VAL_NX500_uartcr_uartEN 0x00000000U
#define MSK_NX500_uartcr_SIREN       0x00000002U
#define SRT_NX500_uartcr_SIREN       1
#define DFLT_VAL_NX500_uartcr_SIREN  0x00000000U
#define MSK_NX500_uartcr_SIRLP       0x00000004U
#define SRT_NX500_uartcr_SIRLP       2
#define DFLT_VAL_NX500_uartcr_SIRLP  0x00000000U
#define MSK_NX500_uartcr_MSIE        0x00000008U
#define SRT_NX500_uartcr_MSIE        3
#define DFLT_VAL_NX500_uartcr_MSIE   0x00000000U
#define MSK_NX500_uartcr_RIE         0x00000010U
#define SRT_NX500_uartcr_RIE         4
#define DFLT_VAL_NX500_uartcr_RIE    0x00000000U
#define MSK_NX500_uartcr_TIE         0x00000020U
#define SRT_NX500_uartcr_TIE         5
#define DFLT_VAL_NX500_uartcr_TIE    0x00000000U
#define MSK_NX500_uartcr_RTIE        0x00000040U
#define SRT_NX500_uartcr_RTIE        6
#define DFLT_VAL_NX500_uartcr_RTIE   0x00000000U
#define MSK_NX500_uartcr_LBE         0x00000080U
#define SRT_NX500_uartcr_LBE         7
#define DFLT_VAL_NX500_uartcr_LBE    0x00000000U

enum {
	BFW_NX500_uartcr_uartEN    = 1,  /* [0] */
	BFW_NX500_uartcr_SIREN     = 1,  /* [1] */
	BFW_NX500_uartcr_SIRLP     = 1,  /* [2] */
	BFW_NX500_uartcr_MSIE      = 1,  /* [3] */
	BFW_NX500_uartcr_RIE       = 1,  /* [4] */
	BFW_NX500_uartcr_TIE       = 1,  /* [5] */
	BFW_NX500_uartcr_RTIE      = 1,  /* [6] */
	BFW_NX500_uartcr_LBE       = 1,  /* [7] */
	BFW_NX500_uartcr_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_UARTCR_BIT_Ttag {
	unsigned int uartEN    : BFW_NX500_uartcr_uartEN;    /* uart Enable                      */
	unsigned int SIREN     : BFW_NX500_uartcr_SIREN;     /* SIR Enable                       */
	unsigned int SIRLP     : BFW_NX500_uartcr_SIRLP;     /* IrDA SIR Low Power Mode          */
	unsigned int MSIE      : BFW_NX500_uartcr_MSIE;      /* Modem Status Interrupt Enable    */
	unsigned int RIE       : BFW_NX500_uartcr_RIE;       /* Receive Interrupt Enable         */
	unsigned int TIE       : BFW_NX500_uartcr_TIE;       /* Transmit Interrupt Enable        */
	unsigned int RTIE      : BFW_NX500_uartcr_RTIE;      /* Receive Timeout Interrupt Enable */
	unsigned int LBE       : BFW_NX500_uartcr_LBE;       /* Loop Back Enable                 */
	unsigned int reserved1 : BFW_NX500_uartcr_reserved1; /* reserved                         */
} NX500_UARTCR_BIT_T;

typedef union {
	unsigned int       val;
	NX500_UARTCR_BIT_T bf;
} NX500_UARTCR_T;

/* --------------------------------------------------------------------- */
/* Register uartfr */
/* => uart Flag Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_uartfr   0x00000018U
#define Adr_NX500_uart0_uartfr 0x00100A18U
#define Adr_NX500_uart1_uartfr 0x00100A58U
#define Adr_NX500_uart2_uartfr 0x00100A98U

#define MSK_NX500_uartfr_CTS  0x00000001U
#define SRT_NX500_uartfr_CTS  0
#define MSK_NX500_uartfr_DSR  0x00000002U
#define SRT_NX500_uartfr_DSR  1
#define MSK_NX500_uartfr_DCD  0x00000004U
#define SRT_NX500_uartfr_DCD  2
#define MSK_NX500_uartfr_BUSY 0x00000008U
#define SRT_NX500_uartfr_BUSY 3
#define MSK_NX500_uartfr_RXFE 0x00000010U
#define SRT_NX500_uartfr_RXFE 4
#define MSK_NX500_uartfr_TXFF 0x00000020U
#define SRT_NX500_uartfr_TXFF 5
#define MSK_NX500_uartfr_RXFF 0x00000040U
#define SRT_NX500_uartfr_RXFF 6
#define MSK_NX500_uartfr_TXFE 0x00000080U
#define SRT_NX500_uartfr_TXFE 7

enum {
	BFW_NX500_uartfr_CTS       = 1,  /* [0] */
	BFW_NX500_uartfr_DSR       = 1,  /* [1] */
	BFW_NX500_uartfr_DCD       = 1,  /* [2] */
	BFW_NX500_uartfr_BUSY      = 1,  /* [3] */
	BFW_NX500_uartfr_RXFE      = 1,  /* [4] */
	BFW_NX500_uartfr_TXFF      = 1,  /* [5] */
	BFW_NX500_uartfr_RXFF      = 1,  /* [6] */
	BFW_NX500_uartfr_TXFE      = 1,  /* [7] */
	BFW_NX500_uartfr_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_UARTFR_BIT_Ttag {
	unsigned int CTS       : BFW_NX500_uartfr_CTS;       /* Clear To Send       */
	unsigned int DSR       : BFW_NX500_uartfr_DSR;       /* Data Set Ready      */
	unsigned int DCD       : BFW_NX500_uartfr_DCD;       /* Data Carrier Detect */
	unsigned int BUSY      : BFW_NX500_uartfr_BUSY;      /* uart BUSY           */
	unsigned int RXFE      : BFW_NX500_uartfr_RXFE;      /* Receive FIFO Empty  */
	unsigned int TXFF      : BFW_NX500_uartfr_TXFF;      /* Transmit FIFO Full  */
	unsigned int RXFF      : BFW_NX500_uartfr_RXFF;      /* Receive FIFO Full   */
	unsigned int TXFE      : BFW_NX500_uartfr_TXFE;      /* Transmit FIFO Empty */
	unsigned int reserved1 : BFW_NX500_uartfr_reserved1; /* reserved            */
} NX500_UARTFR_BIT_T;

typedef union {
	unsigned int       val;
	NX500_UARTFR_BIT_T bf;
} NX500_UARTFR_T;

/* --------------------------------------------------------------------- */
/* Register uartiir */
/* => Interrupt Identification (read) / interrupt clear (write) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_uartiir   0x0000001CU
#define Adr_NX500_uart0_uartiir 0x00100A1CU
#define Adr_NX500_uart1_uartiir 0x00100A5CU
#define Adr_NX500_uart2_uartiir 0x00100A9CU
#define DFLT_VAL_NX500_uartiir  0x00000000U

#define MSK_NX500_uartiir_MIS       0x00000001U
#define SRT_NX500_uartiir_MIS       0
#define DFLT_VAL_NX500_uartiir_MIS  0x00000000U
#define MSK_NX500_uartiir_RIS       0x00000002U
#define SRT_NX500_uartiir_RIS       1
#define DFLT_VAL_NX500_uartiir_RIS  0x00000000U
#define MSK_NX500_uartiir_TIS       0x00000004U
#define SRT_NX500_uartiir_TIS       2
#define DFLT_VAL_NX500_uartiir_TIS  0x00000000U
#define MSK_NX500_uartiir_RTIS      0x00000008U
#define SRT_NX500_uartiir_RTIS      3
#define DFLT_VAL_NX500_uartiir_RTIS 0x00000000U

enum {
	BFW_NX500_uartiir_MIS       = 1,  /* [0] */
	BFW_NX500_uartiir_RIS       = 1,  /* [1] */
	BFW_NX500_uartiir_TIS       = 1,  /* [2] */
	BFW_NX500_uartiir_RTIS      = 1,  /* [3] */
	BFW_NX500_uartiir_reserved1 = 28  /* [31:4] */
};

typedef struct NX500_UARTIIR_BIT_Ttag {
	unsigned int MIS       : BFW_NX500_uartiir_MIS;       /* Modem Interrupt Status           */
	unsigned int RIS       : BFW_NX500_uartiir_RIS;       /* Receive Interrupt Status         */
	unsigned int TIS       : BFW_NX500_uartiir_TIS;       /* Transmit Interrupt Status        */
	unsigned int RTIS      : BFW_NX500_uartiir_RTIS;      /* Receive Timeout Interrupt Status */
	unsigned int reserved1 : BFW_NX500_uartiir_reserved1; /* reserved                         */
} NX500_UARTIIR_BIT_T;

typedef union {
	unsigned int        val;
	NX500_UARTIIR_BIT_T bf;
} NX500_UARTIIR_T;

/* --------------------------------------------------------------------- */
/* Register uartilpr */
/* => IrDA Low Power Counter Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_uartilpr   0x00000020U
#define Adr_NX500_uart0_uartilpr 0x00100A20U
#define Adr_NX500_uart1_uartilpr 0x00100A60U
#define Adr_NX500_uart2_uartilpr 0x00100AA0U
#define DFLT_VAL_NX500_uartilpr  0x00000000U

#define MSK_NX500_uartilpr_ILPDVSR      0x000000ffU
#define SRT_NX500_uartilpr_ILPDVSR      0
#define DFLT_VAL_NX500_uartilpr_ILPDVSR 0x00000000U

enum {
	BFW_NX500_uartilpr_ILPDVSR   = 8,  /* [7:0] */
	BFW_NX500_uartilpr_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_UARTILPR_BIT_Ttag {
	unsigned int ILPDVSR   : BFW_NX500_uartilpr_ILPDVSR;   /* IrDA Low Power Divisor */
	unsigned int reserved1 : BFW_NX500_uartilpr_reserved1; /* reserved               */
} NX500_UARTILPR_BIT_T;

typedef union {
	unsigned int         val;
	NX500_UARTILPR_BIT_T bf;
} NX500_UARTILPR_T;

/* --------------------------------------------------------------------- */
/* Register uartrts */
/* => RTS Control Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_uartrts   0x00000024U
#define Adr_NX500_uart0_uartrts 0x00100A24U
#define Adr_NX500_uart1_uartrts 0x00100A64U
#define Adr_NX500_uart2_uartrts 0x00100AA4U
#define DFLT_VAL_NX500_uartrts  0x00000000U

#define MSK_NX500_uartrts_AUTO         0x00000001U
#define SRT_NX500_uartrts_AUTO         0
#define DFLT_VAL_NX500_uartrts_AUTO    0x00000000U
#define MSK_NX500_uartrts_RTS          0x00000002U
#define SRT_NX500_uartrts_RTS          1
#define DFLT_VAL_NX500_uartrts_RTS     0x00000000U
#define MSK_NX500_uartrts_COUNT        0x00000004U
#define SRT_NX500_uartrts_COUNT        2
#define DFLT_VAL_NX500_uartrts_COUNT   0x00000000U
#define MSK_NX500_uartrts_MOD2         0x00000008U
#define SRT_NX500_uartrts_MOD2         3
#define DFLT_VAL_NX500_uartrts_MOD2    0x00000000U
#define MSK_NX500_uartrts_RTS_pol      0x00000010U
#define SRT_NX500_uartrts_RTS_pol      4
#define DFLT_VAL_NX500_uartrts_RTS_pol 0x00000000U
#define MSK_NX500_uartrts_CTS_ctr      0x00000020U
#define SRT_NX500_uartrts_CTS_ctr      5
#define DFLT_VAL_NX500_uartrts_CTS_ctr 0x00000000U
#define MSK_NX500_uartrts_CTS_pol      0x00000040U
#define SRT_NX500_uartrts_CTS_pol      6
#define DFLT_VAL_NX500_uartrts_CTS_pol 0x00000000U
#define MSK_NX500_uartrts_STICK        0x00000080U
#define SRT_NX500_uartrts_STICK        7
#define DFLT_VAL_NX500_uartrts_STICK   0x00000000U

enum {
	BFW_NX500_uartrts_AUTO      = 1,  /* [0] */
	BFW_NX500_uartrts_RTS       = 1,  /* [1] */
	BFW_NX500_uartrts_COUNT     = 1,  /* [2] */
	BFW_NX500_uartrts_MOD2      = 1,  /* [3] */
	BFW_NX500_uartrts_RTS_pol   = 1,  /* [4] */
	BFW_NX500_uartrts_CTS_ctr   = 1,  /* [5] */
	BFW_NX500_uartrts_CTS_pol   = 1,  /* [6] */
	BFW_NX500_uartrts_STICK     = 1,  /* [7] */
	BFW_NX500_uartrts_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_UARTRTS_BIT_Ttag {
	unsigned int AUTO      : BFW_NX500_uartrts_AUTO;      /* automatic or controlled by the next bit (RTS) */
	unsigned int RTS       : BFW_NX500_uartrts_RTS;       /* if AUTO=0: controlled by this bit             */
	unsigned int COUNT     : BFW_NX500_uartrts_COUNT;     /* count base: 1=system clocks, 0=time in bauds  */
	unsigned int MOD2      : BFW_NX500_uartrts_MOD2;      /* mode1/mode2                                   */
	unsigned int RTS_pol   : BFW_NX500_uartrts_RTS_pol;   /* RTS polarity: 1=active high                   */
	unsigned int CTS_ctr   : BFW_NX500_uartrts_CTS_ctr;   /* nUARTCTS control                              */
	unsigned int CTS_pol   : BFW_NX500_uartrts_CTS_pol;   /* nUARTCTS polarity: 1=active high              */
	unsigned int STICK     : BFW_NX500_uartrts_STICK;     /* stick parity                                  */
	unsigned int reserved1 : BFW_NX500_uartrts_reserved1; /* reserved                                      */
} NX500_UARTRTS_BIT_T;

typedef union {
	unsigned int        val;
	NX500_UARTRTS_BIT_T bf;
} NX500_UARTRTS_T;

/* --------------------------------------------------------------------- */
/* Register uartforerun */
/* => RTS forerun cycles */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_uartforerun   0x00000028U
#define Adr_NX500_uart0_uartforerun 0x00100A28U
#define Adr_NX500_uart1_uartforerun 0x00100A68U
#define Adr_NX500_uart2_uartforerun 0x00100AA8U
#define DFLT_VAL_NX500_uartforerun  0x00000000U

#define MSK_NX500_uartforerun_FORERUN      0x000000ffU
#define SRT_NX500_uartforerun_FORERUN      0
#define DFLT_VAL_NX500_uartforerun_FORERUN 0x00000000U

enum {
	BFW_NX500_uartforerun_FORERUN   = 8,  /* [7:0] */
	BFW_NX500_uartforerun_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_UARTFORERUN_BIT_Ttag {
	unsigned int FORERUN   : BFW_NX500_uartforerun_FORERUN;   /* number of forerun cycles in system clocks or bauds */
	unsigned int reserved1 : BFW_NX500_uartforerun_reserved1; /* reserved                                           */
} NX500_UARTFORERUN_BIT_T;

typedef union {
	unsigned int            val;
	NX500_UARTFORERUN_BIT_T bf;
} NX500_UARTFORERUN_T;

/* --------------------------------------------------------------------- */
/* Register uarttrail */
/* => RTS trail cycles */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_uarttrail   0x0000002CU
#define Adr_NX500_uart0_uarttrail 0x00100A2CU
#define Adr_NX500_uart1_uarttrail 0x00100A6CU
#define Adr_NX500_uart2_uarttrail 0x00100AACU
#define DFLT_VAL_NX500_uarttrail  0x00000000U

#define MSK_NX500_uarttrail_TRAIL      0x000000ffU
#define SRT_NX500_uarttrail_TRAIL      0
#define DFLT_VAL_NX500_uarttrail_TRAIL 0x00000000U

enum {
	BFW_NX500_uarttrail_TRAIL     = 8,  /* [7:0] */
	BFW_NX500_uarttrail_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_UARTTRAIL_BIT_Ttag {
	unsigned int TRAIL     : BFW_NX500_uarttrail_TRAIL;     /* number of trail cycles in system clocks or bauds */
	unsigned int reserved1 : BFW_NX500_uarttrail_reserved1; /* reserved                                         */
} NX500_UARTTRAIL_BIT_T;

typedef union {
	unsigned int          val;
	NX500_UARTTRAIL_BIT_T bf;
} NX500_UARTTRAIL_T;

/* --------------------------------------------------------------------- */
/* Register uartdrvout */
/* => Drive Output */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_uartdrvout   0x00000030U
#define Adr_NX500_uart0_uartdrvout 0x00100A30U
#define Adr_NX500_uart1_uartdrvout 0x00100A70U
#define Adr_NX500_uart2_uartdrvout 0x00100AB0U
#define DFLT_VAL_NX500_uartdrvout  0x00000000U

#define MSK_NX500_uartdrvout_DRVTX       0x00000001U
#define SRT_NX500_uartdrvout_DRVTX       0
#define DFLT_VAL_NX500_uartdrvout_DRVTX  0x00000000U
#define MSK_NX500_uartdrvout_DRVRTS      0x00000002U
#define SRT_NX500_uartdrvout_DRVRTS      1
#define DFLT_VAL_NX500_uartdrvout_DRVRTS 0x00000000U

enum {
	BFW_NX500_uartdrvout_DRVTX     = 1,  /* [0] */
	BFW_NX500_uartdrvout_DRVRTS    = 1,  /* [1] */
	BFW_NX500_uartdrvout_reserved1 = 30  /* [31:2] */
};

typedef struct NX500_UARTDRVOUT_BIT_Ttag {
	unsigned int DRVTX     : BFW_NX500_uartdrvout_DRVTX;     /* enable driver for TX  */
	unsigned int DRVRTS    : BFW_NX500_uartdrvout_DRVRTS;    /* enable driver for RTS */
	unsigned int reserved1 : BFW_NX500_uartdrvout_reserved1; /* reserved              */
} NX500_UARTDRVOUT_BIT_T;

typedef union {
	unsigned int           val;
	NX500_UARTDRVOUT_BIT_T bf;
} NX500_UARTDRVOUT_T;

/* --------------------------------------------------------------------- */
/* Register uartcr_2 */
/* => Control Register 2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_uartcr_2   0x00000034U
#define Adr_NX500_uart0_uartcr_2 0x00100A34U
#define Adr_NX500_uart1_uartcr_2 0x00100A74U
#define Adr_NX500_uart2_uartcr_2 0x00100AB4U
#define DFLT_VAL_NX500_uartcr_2  0x00000000U

#define MSK_NX500_uartcr_2_Baud_Rate_Mode      0x00000001U
#define SRT_NX500_uartcr_2_Baud_Rate_Mode      0
#define DFLT_VAL_NX500_uartcr_2_Baud_Rate_Mode 0x00000000U

enum {
	BFW_NX500_uartcr_2_Baud_Rate_Mode = 1,  /* [0] */
	BFW_NX500_uartcr_2_reserved1      = 31  /* [31:1] */
};

typedef struct NX500_UARTCR_2_BIT_Ttag {
	unsigned int Baud_Rate_Mode : BFW_NX500_uartcr_2_Baud_Rate_Mode; /* If this bit is set the baud rate is generated more exactly by the following formula: */
	                                                                 /* value = ( (Baud Rate * 16) / System Frequency ) * 2^16  .                            */
	unsigned int reserved1      : BFW_NX500_uartcr_2_reserved1;      /* reserved                                                                             */
} NX500_UARTCR_2_BIT_T;

typedef union {
	unsigned int         val;
	NX500_UARTCR_2_BIT_T bf;
} NX500_UARTCR_2_T;

/* --------------------------------------------------------------------- */
/* Register uartrxiflsel */
/* => RX FIFO trigger level */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_uartrxiflsel   0x00000038U
#define Adr_NX500_uart0_uartrxiflsel 0x00100A38U
#define Adr_NX500_uart1_uartrxiflsel 0x00100A78U
#define Adr_NX500_uart2_uartrxiflsel 0x00100AB8U
#define DFLT_VAL_NX500_uartrxiflsel  0x00000008U

#define MSK_NX500_uartrxiflsel_RXIFLSEL      0x0000001fU
#define SRT_NX500_uartrxiflsel_RXIFLSEL      0
#define DFLT_VAL_NX500_uartrxiflsel_RXIFLSEL 0x00000008U

enum {
	BFW_NX500_uartrxiflsel_RXIFLSEL  = 5,  /* [4:0] */
	BFW_NX500_uartrxiflsel_reserved1 = 27  /* [31:5] */
};

typedef struct NX500_UARTRXIFLSEL_BIT_Ttag {
	unsigned int RXIFLSEL  : BFW_NX500_uartrxiflsel_RXIFLSEL;  /* 	Choose a number between 1 and 16. It defines the IRQ trigger level of the receive fifo.                                  */
	                                                           /*  The IRQ (UARTRXINTR) will be set if the number of received bytes in the receive fifo are greater than or equal RXIFLSEL. */
	unsigned int reserved1 : BFW_NX500_uartrxiflsel_reserved1; /* reserved                                                                                                                  */
} NX500_UARTRXIFLSEL_BIT_T;

typedef union {
	unsigned int             val;
	NX500_UARTRXIFLSEL_BIT_T bf;
} NX500_UARTRXIFLSEL_T;

/* --------------------------------------------------------------------- */
/* Register uarttxiflsel */
/* => TX FIFO trigger level */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_uarttxiflsel   0x0000003CU
#define Adr_NX500_uart0_uarttxiflsel 0x00100A3CU
#define Adr_NX500_uart1_uarttxiflsel 0x00100A7CU
#define Adr_NX500_uart2_uarttxiflsel 0x00100ABCU
#define DFLT_VAL_NX500_uarttxiflsel  0x00000008U

#define MSK_NX500_uarttxiflsel_TXIFLSEL      0x0000001fU
#define SRT_NX500_uarttxiflsel_TXIFLSEL      0
#define DFLT_VAL_NX500_uarttxiflsel_TXIFLSEL 0x00000008U

enum {
	BFW_NX500_uarttxiflsel_TXIFLSEL  = 5,  /* [4:0] */
	BFW_NX500_uarttxiflsel_reserved1 = 27  /* [31:5] */
};

typedef struct NX500_UARTTXIFLSEL_BIT_Ttag {
	unsigned int TXIFLSEL  : BFW_NX500_uarttxiflsel_TXIFLSEL;  /* 	Choose a number between 1 and 16. It defines the IRQ trigger level of the transmit fifo.                         */
	                                                           /*  The IRQ (UARTTXINTR) will be set if the number of transmitted bytes in the transmit fifo are less than TXIFLSEL. */
	unsigned int reserved1 : BFW_NX500_uarttxiflsel_reserved1; /* reserved                                                                                                          */
} NX500_UARTTXIFLSEL_BIT_T;

typedef union {
	unsigned int             val;
	NX500_UARTTXIFLSEL_BIT_T bf;
} NX500_UARTTXIFLSEL_T;


/* ===================================================================== */

/* Area of miimu */

/* ===================================================================== */

#define Addr_NX500_miimu      0x00100B00U
#define NX500_NETX_MIIMU_AREA 0x00100B00U

/* --------------------------------------------------------------------- */
/* Register miimu_reg */
/* => MIIMU Receive/Transmit Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_miimu_reg   0x00000000U
#define Adr_NX500_miimu_miimu_reg 0x00100B00U
#define Adr_NX500_miimu_reg       0x00100B00U
#define DFLT_VAL_NX500_miimu_reg  0x00000010U

#define MSK_NX500_miimu_reg_miimu_snrdy           0x00000001U
#define SRT_NX500_miimu_reg_miimu_snrdy           0
#define DFLT_VAL_NX500_miimu_reg_miimu_snrdy      0x00000000U
#define MSK_NX500_miimu_reg_miimu_preamble        0x00000002U
#define SRT_NX500_miimu_reg_miimu_preamble        1
#define DFLT_VAL_NX500_miimu_reg_miimu_preamble   0x00000000U
#define MSK_NX500_miimu_reg_miimu_opmode          0x00000004U
#define SRT_NX500_miimu_reg_miimu_opmode          2
#define DFLT_VAL_NX500_miimu_reg_miimu_opmode     0x00000000U
#define MSK_NX500_miimu_reg_miimu_mdc_period      0x00000008U
#define SRT_NX500_miimu_reg_miimu_mdc_period      3
#define DFLT_VAL_NX500_miimu_reg_miimu_mdc_period 0x00000000U
#define MSK_NX500_miimu_reg_phy_nres              0x00000010U
#define SRT_NX500_miimu_reg_phy_nres              4
#define DFLT_VAL_NX500_miimu_reg_phy_nres         0x00000010U
#define MSK_NX500_miimu_reg_miimu_rta             0x00000020U
#define SRT_NX500_miimu_reg_miimu_rta             5
#define DFLT_VAL_NX500_miimu_reg_miimu_rta        0x00000000U
#define MSK_NX500_miimu_reg_miimu_regaddr         0x000007c0U
#define SRT_NX500_miimu_reg_miimu_regaddr         6
#define DFLT_VAL_NX500_miimu_reg_miimu_regaddr    0x00000000U
#define MSK_NX500_miimu_reg_miimu_phyaddr         0x0000f800U
#define SRT_NX500_miimu_reg_miimu_phyaddr         11
#define DFLT_VAL_NX500_miimu_reg_miimu_phyaddr    0x00000000U
#define MSK_NX500_miimu_reg_miimu_data            0xffff0000U
#define SRT_NX500_miimu_reg_miimu_data            16
#define DFLT_VAL_NX500_miimu_reg_miimu_data       0x00000000U

enum {
	BFW_NX500_miimu_reg_miimu_snrdy      = 1,  /* [0] */
	BFW_NX500_miimu_reg_miimu_preamble   = 1,  /* [1] */
	BFW_NX500_miimu_reg_miimu_opmode     = 1,  /* [2] */
	BFW_NX500_miimu_reg_miimu_mdc_period = 1,  /* [3] */
	BFW_NX500_miimu_reg_phy_nres         = 1,  /* [4] */
	BFW_NX500_miimu_reg_miimu_rta        = 1,  /* [5] */
	BFW_NX500_miimu_reg_miimu_regaddr    = 5,  /* [10:6] */
	BFW_NX500_miimu_reg_miimu_phyaddr    = 5,  /* [15:11] */
	BFW_NX500_miimu_reg_miimu_data       = 16  /* [31:16] */
};

typedef struct NX500_MIIMU_REG_BIT_Ttag {
	unsigned int miimu_snrdy      : BFW_NX500_miimu_reg_miimu_snrdy;      /* Start not ready                                                               */
	unsigned int miimu_preamble   : BFW_NX500_miimu_reg_miimu_preamble;   /* Send preamble                                                                 */
	unsigned int miimu_opmode     : BFW_NX500_miimu_reg_miimu_opmode;     /* Operation mode:                                                               */
	                                                                      /* 1: write                                                                      */
	unsigned int miimu_mdc_period : BFW_NX500_miimu_reg_miimu_mdc_period; /* MDC period:                                                                   */
	                                                                      /* 1: 800ns                                                                      */
	unsigned int phy_nres         : BFW_NX500_miimu_reg_phy_nres;         /* PHY hardware nReset (activ low!):                                             */
	                                                                      /* If this bit and the miimu_snrdy-bit is set, the PHYs will be hardware-reset.  */
	unsigned int miimu_rta        : BFW_NX500_miimu_reg_miimu_rta;        /* Read Turn Around field:                                                       */
	                                                                      /* 0: one bit                                                                    */
	unsigned int miimu_regaddr    : BFW_NX500_miimu_reg_miimu_regaddr;    /* Register address                                                              */
	unsigned int miimu_phyaddr    : BFW_NX500_miimu_reg_miimu_phyaddr;    /* PHY address                                                                   */
	unsigned int miimu_data       : BFW_NX500_miimu_reg_miimu_data;       /* Data to or from PHY register                                                  */
} NX500_MIIMU_REG_BIT_T;

typedef union {
	unsigned int          val;
	NX500_MIIMU_REG_BIT_T bf;
} NX500_MIIMU_REG_T;

/* --------------------------------------------------------------------- */
/* Register miimu_sw_en */
/* => MIIMU Software Mode Enable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_miimu_sw_en   0x00000004U
#define Adr_NX500_miimu_miimu_sw_en 0x00100B04U
#define Adr_NX500_miimu_sw_en       0x00100B04U
#define DFLT_VAL_NX500_miimu_sw_en  0x00000000U

#define MSK_NX500_miimu_sw_en_miimu_sw_en      0x00000001U
#define SRT_NX500_miimu_sw_en_miimu_sw_en      0
#define DFLT_VAL_NX500_miimu_sw_en_miimu_sw_en 0x00000000U

enum {
	BFW_NX500_miimu_sw_en_miimu_sw_en = 1,  /* [0] */
	BFW_NX500_miimu_sw_en_reserved1   = 31  /* [31:1] */
};

typedef struct NX500_MIIMU_SW_EN_BIT_Ttag {
	unsigned int miimu_sw_en : BFW_NX500_miimu_sw_en_miimu_sw_en; /* Enables software mode:                  */
	                                                              /* MDC, MDO and MDOE are set by software.  */
	unsigned int reserved1   : BFW_NX500_miimu_sw_en_reserved1;   /* reserved                                */
} NX500_MIIMU_SW_EN_BIT_T;

typedef union {
	unsigned int            val;
	NX500_MIIMU_SW_EN_BIT_T bf;
} NX500_MIIMU_SW_EN_T;

/* --------------------------------------------------------------------- */
/* Register miimu_sw_mdc */
/* => MIIMU Software Mode MDC Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_miimu_sw_mdc   0x00000008U
#define Adr_NX500_miimu_miimu_sw_mdc 0x00100B08U
#define Adr_NX500_miimu_sw_mdc       0x00100B08U
#define DFLT_VAL_NX500_miimu_sw_mdc  0x00000000U

#define MSK_NX500_miimu_sw_mdc_miimu_sw_mdc      0x00000001U
#define SRT_NX500_miimu_sw_mdc_miimu_sw_mdc      0
#define DFLT_VAL_NX500_miimu_sw_mdc_miimu_sw_mdc 0x00000000U

enum {
	BFW_NX500_miimu_sw_mdc_miimu_sw_mdc = 1,  /* [0] */
	BFW_NX500_miimu_sw_mdc_reserved1    = 31  /* [31:1] */
};

typedef struct NX500_MIIMU_SW_MDC_BIT_Ttag {
	unsigned int miimu_sw_mdc : BFW_NX500_miimu_sw_mdc_miimu_sw_mdc; /* MDC value for software mode */
	unsigned int reserved1    : BFW_NX500_miimu_sw_mdc_reserved1;    /* reserved                    */
} NX500_MIIMU_SW_MDC_BIT_T;

typedef union {
	unsigned int             val;
	NX500_MIIMU_SW_MDC_BIT_T bf;
} NX500_MIIMU_SW_MDC_T;

/* --------------------------------------------------------------------- */
/* Register miimu_sw_mdo */
/* => MIIMU Software Mode MDO Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_miimu_sw_mdo   0x0000000CU
#define Adr_NX500_miimu_miimu_sw_mdo 0x00100B0CU
#define Adr_NX500_miimu_sw_mdo       0x00100B0CU
#define DFLT_VAL_NX500_miimu_sw_mdo  0x00000000U

#define MSK_NX500_miimu_sw_mdo_miimu_sw_mdo      0x00000001U
#define SRT_NX500_miimu_sw_mdo_miimu_sw_mdo      0
#define DFLT_VAL_NX500_miimu_sw_mdo_miimu_sw_mdo 0x00000000U

enum {
	BFW_NX500_miimu_sw_mdo_miimu_sw_mdo = 1,  /* [0] */
	BFW_NX500_miimu_sw_mdo_reserved1    = 31  /* [31:1] */
};

typedef struct NX500_MIIMU_SW_MDO_BIT_Ttag {
	unsigned int miimu_sw_mdo : BFW_NX500_miimu_sw_mdo_miimu_sw_mdo; /* MDO value for software mode */
	unsigned int reserved1    : BFW_NX500_miimu_sw_mdo_reserved1;    /* reserved                    */
} NX500_MIIMU_SW_MDO_BIT_T;

typedef union {
	unsigned int             val;
	NX500_MIIMU_SW_MDO_BIT_T bf;
} NX500_MIIMU_SW_MDO_T;

/* --------------------------------------------------------------------- */
/* Register miimu_sw_mdoe */
/* => MIIMU Software Mode MDOE Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_miimu_sw_mdoe   0x00000010U
#define Adr_NX500_miimu_miimu_sw_mdoe 0x00100B10U
#define Adr_NX500_miimu_sw_mdoe       0x00100B10U
#define DFLT_VAL_NX500_miimu_sw_mdoe  0x00000000U

#define MSK_NX500_miimu_sw_mdoe_miimu_sw_mdoe      0x00000001U
#define SRT_NX500_miimu_sw_mdoe_miimu_sw_mdoe      0
#define DFLT_VAL_NX500_miimu_sw_mdoe_miimu_sw_mdoe 0x00000000U

enum {
	BFW_NX500_miimu_sw_mdoe_miimu_sw_mdoe = 1,  /* [0] */
	BFW_NX500_miimu_sw_mdoe_reserved1     = 31  /* [31:1] */
};

typedef struct NX500_MIIMU_SW_MDOE_BIT_Ttag {
	unsigned int miimu_sw_mdoe : BFW_NX500_miimu_sw_mdoe_miimu_sw_mdoe; /* MDOE value for software mode */
	unsigned int reserved1     : BFW_NX500_miimu_sw_mdoe_reserved1;     /* reserved                     */
} NX500_MIIMU_SW_MDOE_BIT_T;

typedef union {
	unsigned int              val;
	NX500_MIIMU_SW_MDOE_BIT_T bf;
} NX500_MIIMU_SW_MDOE_T;

/* --------------------------------------------------------------------- */
/* Register miimu_sw_mdi */
/* => MIIMU Software Mode MDI Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_miimu_sw_mdi   0x00000014U
#define Adr_NX500_miimu_miimu_sw_mdi 0x00100B14U
#define Adr_NX500_miimu_sw_mdi       0x00100B14U

#define MSK_NX500_miimu_sw_mdi_miimu_sw_mdi 0x00000001U
#define SRT_NX500_miimu_sw_mdi_miimu_sw_mdi 0

enum {
	BFW_NX500_miimu_sw_mdi_miimu_sw_mdi = 1,  /* [0] */
	BFW_NX500_miimu_sw_mdi_reserved1    = 31  /* [31:1] */
};

typedef struct NX500_MIIMU_SW_MDI_BIT_Ttag {
	unsigned int miimu_sw_mdi : BFW_NX500_miimu_sw_mdi_miimu_sw_mdi; /* current MDI value */
	unsigned int reserved1    : BFW_NX500_miimu_sw_mdi_reserved1;    /* reserved          */
} NX500_MIIMU_SW_MDI_BIT_T;

typedef union {
	unsigned int             val;
	NX500_MIIMU_SW_MDI_BIT_T bf;
} NX500_MIIMU_SW_MDI_T;


/* ===================================================================== */

/* Area of spi */

/* ===================================================================== */

#define Addr_NX500_spi      0x00100C00U
#define NX500_NETX_SPI_AREA 0x00100C00U

/* --------------------------------------------------------------------- */
/* Register spi_data_register */
/* => spi data register (DR) */
/*    2 data bytes with valid bits */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_spi_data_register  0x00000000U
#define Adr_NX500_spi_spi_data_register  0x00100C00U
#define Adr_NX500_spi_data_register      0x00100C00U
#define DFLT_VAL_NX500_spi_data_register 0x00000000U

#define MSK_NX500_spi_data_register_data_byte_0      0x000000ffU
#define SRT_NX500_spi_data_register_data_byte_0      0
#define DFLT_VAL_NX500_spi_data_register_data_byte_0 0x00000000U
#define MSK_NX500_spi_data_register_data_byte_1      0x0000ff00U
#define SRT_NX500_spi_data_register_data_byte_1      8
#define DFLT_VAL_NX500_spi_data_register_data_byte_1 0x00000000U
#define MSK_NX500_spi_data_register_dr_valid0        0x00010000U
#define SRT_NX500_spi_data_register_dr_valid0        16
#define DFLT_VAL_NX500_spi_data_register_dr_valid0   0x00000000U
#define MSK_NX500_spi_data_register_dr_valid1        0x00020000U
#define SRT_NX500_spi_data_register_dr_valid1        17
#define DFLT_VAL_NX500_spi_data_register_dr_valid1   0x00000000U

enum {
	BFW_NX500_spi_data_register_data_byte_0 = 8,  /* [7:0] */
	BFW_NX500_spi_data_register_data_byte_1 = 8,  /* [15:8] */
	BFW_NX500_spi_data_register_dr_valid0   = 1,  /* [16] */
	BFW_NX500_spi_data_register_dr_valid1   = 1,  /* [17] */
	BFW_NX500_spi_data_register_reserved1   = 14  /* [31:18] */
};

typedef struct NX500_SPI_DATA_REGISTER_BIT_Ttag {
	unsigned int data_byte_0 : BFW_NX500_spi_data_register_data_byte_0; /* data byte                              */
	unsigned int data_byte_1 : BFW_NX500_spi_data_register_data_byte_1; /* data byte                              */
	unsigned int dr_valid0   : BFW_NX500_spi_data_register_dr_valid0;   /* valid bit for data_byte_0              */
	                                                                    /* This bit shows if data_byte_0 Is valid */
	unsigned int dr_valid1   : BFW_NX500_spi_data_register_dr_valid1;   /* valid bit for data_byte_1              */
	                                                                    /* This bit shows if data_byte_1 Is valid */
	unsigned int reserved1   : BFW_NX500_spi_data_register_reserved1;   /* reserved                               */
} NX500_SPI_DATA_REGISTER_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_SPI_DATA_REGISTER_BIT_T bf;
} NX500_SPI_DATA_REGISTER_T;

/* --------------------------------------------------------------------- */
/* Register spi_status_register */
/* => spi status register (SR): */
/*    Shows the actual status of the spi interface. */
/*    Bits 24..18 show occured interrupts, */
/*    writing ones into these bits deletes the interrupts. */
/*    Writing into other bits has no effect */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_spi_status_register  0x00000004U
#define Adr_NX500_spi_spi_status_register  0x00100C04U
#define Adr_NX500_spi_status_register      0x00100C04U
#define DFLT_VAL_NX500_spi_status_register 0x00000000U

#define MSK_NX500_spi_status_register_SR_in_fuel_val       0x000001ffU
#define SRT_NX500_spi_status_register_SR_in_fuel_val       0
#define DFLT_VAL_NX500_spi_status_register_SR_in_fuel_val  0x00000000U
#define MSK_NX500_spi_status_register_SR_out_fuel_val      0x0003fe00U
#define SRT_NX500_spi_status_register_SR_out_fuel_val      9
#define DFLT_VAL_NX500_spi_status_register_SR_out_fuel_val 0x00000000U
#define MSK_NX500_spi_status_register_SR_in_fuel           0x00040000U
#define SRT_NX500_spi_status_register_SR_in_fuel           18
#define DFLT_VAL_NX500_spi_status_register_SR_in_fuel      0x00000000U
#define MSK_NX500_spi_status_register_SR_in_recdata        0x00080000U
#define SRT_NX500_spi_status_register_SR_in_recdata        19
#define DFLT_VAL_NX500_spi_status_register_SR_in_recdata   0x00000000U
#define MSK_NX500_spi_status_register_SR_in_full           0x00100000U
#define SRT_NX500_spi_status_register_SR_in_full           20
#define DFLT_VAL_NX500_spi_status_register_SR_in_full      0x00000000U
#define MSK_NX500_spi_status_register_SR_out_fuel          0x00200000U
#define SRT_NX500_spi_status_register_SR_out_fuel          21
#define DFLT_VAL_NX500_spi_status_register_SR_out_fuel     0x00000000U
#define MSK_NX500_spi_status_register_SR_out_fw            0x00400000U
#define SRT_NX500_spi_status_register_SR_out_fw            22
#define DFLT_VAL_NX500_spi_status_register_SR_out_fw       0x00000000U
#define MSK_NX500_spi_status_register_SR_out_empty         0x00800000U
#define SRT_NX500_spi_status_register_SR_out_empty         23
#define DFLT_VAL_NX500_spi_status_register_SR_out_empty    0x00000000U
#define MSK_NX500_spi_status_register_SR_out_full          0x01000000U
#define SRT_NX500_spi_status_register_SR_out_full          24
#define DFLT_VAL_NX500_spi_status_register_SR_out_full     0x00000000U
#define MSK_NX500_spi_status_register_SR_selected          0x02000000U
#define SRT_NX500_spi_status_register_SR_selected          25
#define DFLT_VAL_NX500_spi_status_register_SR_selected     0x00000000U

enum {
	BFW_NX500_spi_status_register_SR_in_fuel_val  = 9, /* [8:0] */
	BFW_NX500_spi_status_register_SR_out_fuel_val = 9, /* [17:9] */
	BFW_NX500_spi_status_register_SR_in_fuel      = 1, /* [18] */
	BFW_NX500_spi_status_register_SR_in_recdata   = 1, /* [19] */
	BFW_NX500_spi_status_register_SR_in_full      = 1, /* [20] */
	BFW_NX500_spi_status_register_SR_out_fuel     = 1, /* [21] */
	BFW_NX500_spi_status_register_SR_out_fw       = 1, /* [22] */
	BFW_NX500_spi_status_register_SR_out_empty    = 1, /* [23] */
	BFW_NX500_spi_status_register_SR_out_full     = 1, /* [24] */
	BFW_NX500_spi_status_register_SR_selected     = 1, /* [25] */
	BFW_NX500_spi_status_register_reserved1       = 6  /* [31:26] */
};

typedef struct NX500_SPI_STATUS_REGISTER_BIT_Ttag {
	unsigned int SR_in_fuel_val  : BFW_NX500_spi_status_register_SR_in_fuel_val;  /* input FIFO fuel (number of bytes)               */
	unsigned int SR_out_fuel_val : BFW_NX500_spi_status_register_SR_out_fuel_val; /* output FIFO fuel (number of bytes)              */
	unsigned int SR_in_fuel      : BFW_NX500_spi_status_register_SR_in_fuel;      /* adjustable fuel value of input FIFO reached     */
	unsigned int SR_in_recdata   : BFW_NX500_spi_status_register_SR_in_recdata;   /* valid data bytes in input FIFO                  */
	unsigned int SR_in_full      : BFW_NX500_spi_status_register_SR_in_full;      /* input FIFO is full                              */
	unsigned int SR_out_fuel     : BFW_NX500_spi_status_register_SR_out_fuel;     /* adjustable fuel value of output FIFO reached    */
	unsigned int SR_out_fw       : BFW_NX500_spi_status_register_SR_out_fw;       /* ARM is writing data to fast into output FIFO    */
	unsigned int SR_out_empty    : BFW_NX500_spi_status_register_SR_out_empty;    /* output FIFO is empty and interface sending data */
	                                                                              /* (occures only in slave mode)                    */
	unsigned int SR_out_full     : BFW_NX500_spi_status_register_SR_out_full;     /* output FIFO is full                             */
	unsigned int SR_selected     : BFW_NX500_spi_status_register_SR_selected;     /* external master has access to spi-interface     */
	unsigned int reserved1       : BFW_NX500_spi_status_register_reserved1;       /* reserved                                        */
} NX500_SPI_STATUS_REGISTER_BIT_T;

typedef union {
	unsigned int                    val;
	NX500_SPI_STATUS_REGISTER_BIT_T bf;
} NX500_SPI_STATUS_REGISTER_T;

/* --------------------------------------------------------------------- */
/* Register spi_control_register */
/* => spi control register (CR) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_spi_control_register  0x00000008U
#define Adr_NX500_spi_spi_control_register  0x00100C08U
#define Adr_NX500_spi_control_register      0x00100C08U
#define DFLT_VAL_NX500_spi_control_register 0x00000000U

#define MSK_NX500_spi_control_register_CR_softreset        0x00000001U
#define SRT_NX500_spi_control_register_CR_softreset        0
#define DFLT_VAL_NX500_spi_control_register_CR_softreset   0x00000000U
#define MSK_NX500_spi_control_register_CR_speed            0x0000001eU
#define SRT_NX500_spi_control_register_CR_speed            1
#define DFLT_VAL_NX500_spi_control_register_CR_speed       0x00000000U
#define MSK_NX500_spi_control_register_CR_read             0x00000040U
#define SRT_NX500_spi_control_register_CR_read             6
#define DFLT_VAL_NX500_spi_control_register_CR_read        0x00000000U
#define MSK_NX500_spi_control_register_CR_write            0x00000080U
#define SRT_NX500_spi_control_register_CR_write            7
#define DFLT_VAL_NX500_spi_control_register_CR_write       0x00000000U
#define MSK_NX500_spi_control_register_CR_ss               0x00000700U
#define SRT_NX500_spi_control_register_CR_ss               8
#define DFLT_VAL_NX500_spi_control_register_CR_ss          0x00000000U
#define MSK_NX500_spi_control_register_CS_mode             0x00000800U
#define SRT_NX500_spi_control_register_CS_mode             11
#define DFLT_VAL_NX500_spi_control_register_CS_mode        0x00000000U
#define MSK_NX500_spi_control_register_CR_clr_infifo       0x00100000U
#define SRT_NX500_spi_control_register_CR_clr_infifo       20
#define DFLT_VAL_NX500_spi_control_register_CR_clr_infifo  0x00000000U
#define MSK_NX500_spi_control_register_CR_clr_outfifo      0x00200000U
#define SRT_NX500_spi_control_register_CR_clr_outfifo      21
#define DFLT_VAL_NX500_spi_control_register_CR_clr_outfifo 0x00000000U
#define MSK_NX500_spi_control_register_CR_burstdelay       0x01c00000U
#define SRT_NX500_spi_control_register_CR_burstdelay       22
#define DFLT_VAL_NX500_spi_control_register_CR_burstdelay  0x00000000U
#define MSK_NX500_spi_control_register_CR_burst            0x0e000000U
#define SRT_NX500_spi_control_register_CR_burst            25
#define DFLT_VAL_NX500_spi_control_register_CR_burst       0x00000000U
#define MSK_NX500_spi_control_register_CR_ncpha            0x10000000U
#define SRT_NX500_spi_control_register_CR_ncpha            28
#define DFLT_VAL_NX500_spi_control_register_CR_ncpha       0x00000000U
#define MSK_NX500_spi_control_register_CR_cpol             0x20000000U
#define SRT_NX500_spi_control_register_CR_cpol             29
#define DFLT_VAL_NX500_spi_control_register_CR_cpol        0x00000000U
#define MSK_NX500_spi_control_register_CR_ms               0x40000000U
#define SRT_NX500_spi_control_register_CR_ms               30
#define DFLT_VAL_NX500_spi_control_register_CR_ms          0x00000000U
#define MSK_NX500_spi_control_register_CR_en               0x80000000U
#define SRT_NX500_spi_control_register_CR_en               31
#define DFLT_VAL_NX500_spi_control_register_CR_en          0x00000000U

enum {
	BFW_NX500_spi_control_register_CR_softreset   = 1, /* [0] */
	BFW_NX500_spi_control_register_CR_speed       = 4, /* [4:1] */
	BFW_NX500_spi_control_register_reserved1      = 1, /* [5] */
	BFW_NX500_spi_control_register_CR_read        = 1, /* [6] */
	BFW_NX500_spi_control_register_CR_write       = 1, /* [7] */
	BFW_NX500_spi_control_register_CR_ss          = 3, /* [10:8] */
	BFW_NX500_spi_control_register_CS_mode        = 1, /* [11] */
	BFW_NX500_spi_control_register_reserved2      = 8, /* [19:12] */
	BFW_NX500_spi_control_register_CR_clr_infifo  = 1, /* [20] */
	BFW_NX500_spi_control_register_CR_clr_outfifo = 1, /* [21] */
	BFW_NX500_spi_control_register_CR_burstdelay  = 3, /* [24:22] */
	BFW_NX500_spi_control_register_CR_burst       = 3, /* [27:25] */
	BFW_NX500_spi_control_register_CR_ncpha       = 1, /* [28] */
	BFW_NX500_spi_control_register_CR_cpol        = 1, /* [29] */
	BFW_NX500_spi_control_register_CR_ms          = 1, /* [30] */
	BFW_NX500_spi_control_register_CR_en          = 1  /* [31] */
};

typedef struct NX500_SPI_CONTROL_REGISTER_BIT_Ttag {
	unsigned int CR_softreset   : BFW_NX500_spi_control_register_CR_softreset;   /* TBD                                                                     */
	unsigned int CR_speed       : BFW_NX500_spi_control_register_CR_speed;       /* clock devider for SPI clock (2 - 2^16)                                  */
	                                                                             /* There are 15 different SPI Clocks to choose:                            */
	unsigned int reserved1      : BFW_NX500_spi_control_register_reserved1;      /* reserved                                                                */
	unsigned int CR_read        : BFW_NX500_spi_control_register_CR_read;        /* 1:spi interface read data                                               */
	unsigned int CR_write       : BFW_NX500_spi_control_register_CR_write;       /* 1:spi interface write data                                              */
	unsigned int CR_ss          : BFW_NX500_spi_control_register_CR_ss;          /* external slave select                                                   */
	unsigned int CS_mode        : BFW_NX500_spi_control_register_CS_mode;        /* 1: chip select is generated automatically by the internal state machine */
	                                                                             /* 0: chip select is directly controlled by software (see bits CR_ss).     */
	unsigned int reserved2      : BFW_NX500_spi_control_register_reserved2;      /* reserved                                                                */
	unsigned int CR_clr_infifo  : BFW_NX500_spi_control_register_CR_clr_infifo;  /* clear input FIFO                                                        */
	unsigned int CR_clr_outfifo : BFW_NX500_spi_control_register_CR_clr_outfifo; /* clear output FIFO                                                       */
	unsigned int CR_burstdelay  : BFW_NX500_spi_control_register_CR_burstdelay;  /* delay between transmittion of 2 data bytes                              */
	                                                                             /* (0 to 7 SCK cycles)                                                     */
	unsigned int CR_burst       : BFW_NX500_spi_control_register_CR_burst;       /* burst lenght = 2^CR_burst                                               */
	unsigned int CR_ncpha       : BFW_NX500_spi_control_register_CR_ncpha;       /* relativ to CR_cpol                                                      */
	                                                                             /* 1:change data to primary spi_sck edge                                   */
	unsigned int CR_cpol        : BFW_NX500_spi_control_register_CR_cpol;        /* 1:falling edge of spi_sck is primary                                    */
	                                                                             /* 0:rising edge of spi_sck is primary                                     */
	unsigned int CR_ms          : BFW_NX500_spi_control_register_CR_ms;          /* 1:master mode 0:slave mode                                              */
	unsigned int CR_en          : BFW_NX500_spi_control_register_CR_en;          /* 1:enable 0:disable spi interface                                        */
} NX500_SPI_CONTROL_REGISTER_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_SPI_CONTROL_REGISTER_BIT_T bf;
} NX500_SPI_CONTROL_REGISTER_T;

/* --------------------------------------------------------------------- */
/* Register spi_interrupt_control_register */
/* => spi interrupt control register (IR) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_spi_interrupt_control_register  0x0000000CU
#define Adr_NX500_spi_spi_interrupt_control_register  0x00100C0CU
#define Adr_NX500_spi_interrupt_control_register      0x00100C0CU
#define DFLT_VAL_NX500_spi_interrupt_control_register 0x00000000U

#define MSK_NX500_spi_interrupt_control_register_IR_in_fuel            0x000001ffU
#define SRT_NX500_spi_interrupt_control_register_IR_in_fuel            0
#define DFLT_VAL_NX500_spi_interrupt_control_register_IR_in_fuel       0x00000000U
#define MSK_NX500_spi_interrupt_control_register_IR_out_fuel           0x0003fe00U
#define SRT_NX500_spi_interrupt_control_register_IR_out_fuel           9
#define DFLT_VAL_NX500_spi_interrupt_control_register_IR_out_fuel      0x00000000U
#define MSK_NX500_spi_interrupt_control_register_IR_in_fuel_en         0x00040000U
#define SRT_NX500_spi_interrupt_control_register_IR_in_fuel_en         18
#define DFLT_VAL_NX500_spi_interrupt_control_register_IR_in_fuel_en    0x00000000U
#define MSK_NX500_spi_interrupt_control_register_IR_in_recdata_en      0x00080000U
#define SRT_NX500_spi_interrupt_control_register_IR_in_recdata_en      19
#define DFLT_VAL_NX500_spi_interrupt_control_register_IR_in_recdata_en 0x00000000U
#define MSK_NX500_spi_interrupt_control_register_IR_in_full_en         0x00100000U
#define SRT_NX500_spi_interrupt_control_register_IR_in_full_en         20
#define DFLT_VAL_NX500_spi_interrupt_control_register_IR_in_full_en    0x00000000U
#define MSK_NX500_spi_interrupt_control_register_IR_out_fuel_en        0x00200000U
#define SRT_NX500_spi_interrupt_control_register_IR_out_fuel_en        21
#define DFLT_VAL_NX500_spi_interrupt_control_register_IR_out_fuel_en   0x00000000U
#define MSK_NX500_spi_interrupt_control_register_IR_out_fw_en          0x00400000U
#define SRT_NX500_spi_interrupt_control_register_IR_out_fw_en          22
#define DFLT_VAL_NX500_spi_interrupt_control_register_IR_out_fw_en     0x00000000U
#define MSK_NX500_spi_interrupt_control_register_IR_out_empty_en       0x00800000U
#define SRT_NX500_spi_interrupt_control_register_IR_out_empty_en       23
#define DFLT_VAL_NX500_spi_interrupt_control_register_IR_out_empty_en  0x00000000U
#define MSK_NX500_spi_interrupt_control_register_IR_out_full_en        0x01000000U
#define SRT_NX500_spi_interrupt_control_register_IR_out_full_en        24
#define DFLT_VAL_NX500_spi_interrupt_control_register_IR_out_full_en   0x00000000U

enum {
	BFW_NX500_spi_interrupt_control_register_IR_in_fuel       = 9, /* [8:0] */
	BFW_NX500_spi_interrupt_control_register_IR_out_fuel      = 9, /* [17:9] */
	BFW_NX500_spi_interrupt_control_register_IR_in_fuel_en    = 1, /* [18] */
	BFW_NX500_spi_interrupt_control_register_IR_in_recdata_en = 1, /* [19] */
	BFW_NX500_spi_interrupt_control_register_IR_in_full_en    = 1, /* [20] */
	BFW_NX500_spi_interrupt_control_register_IR_out_fuel_en   = 1, /* [21] */
	BFW_NX500_spi_interrupt_control_register_IR_out_fw_en     = 1, /* [22] */
	BFW_NX500_spi_interrupt_control_register_IR_out_empty_en  = 1, /* [23] */
	BFW_NX500_spi_interrupt_control_register_IR_out_full_en   = 1, /* [24] */
	BFW_NX500_spi_interrupt_control_register_reserved1        = 7  /* [31:25] */
};

typedef struct NX500_SPI_INTERRUPT_CONTROL_REGISTER_BIT_Ttag {
	unsigned int IR_in_fuel       : BFW_NX500_spi_interrupt_control_register_IR_in_fuel;       /* adjustable fuel value of input FIFO  */
	unsigned int IR_out_fuel      : BFW_NX500_spi_interrupt_control_register_IR_out_fuel;      /* adjustable fuel value of output FIFO */
	unsigned int IR_in_fuel_en    : BFW_NX500_spi_interrupt_control_register_IR_in_fuel_en;    /* IRQ enable for irq_spi(0)            */
	unsigned int IR_in_recdata_en : BFW_NX500_spi_interrupt_control_register_IR_in_recdata_en; /* IRQ enable for irq_spi(1)            */
	unsigned int IR_in_full_en    : BFW_NX500_spi_interrupt_control_register_IR_in_full_en;    /* IRQ enable for irq_spi(2)            */
	unsigned int IR_out_fuel_en   : BFW_NX500_spi_interrupt_control_register_IR_out_fuel_en;   /* IRQ enable for irq_spi(3)            */
	unsigned int IR_out_fw_en     : BFW_NX500_spi_interrupt_control_register_IR_out_fw_en;     /* IRQ enable for irq_spi(4)            */
	unsigned int IR_out_empty_en  : BFW_NX500_spi_interrupt_control_register_IR_out_empty_en;  /* IRQ enable for irq_spi(5)            */
	unsigned int IR_out_full_en   : BFW_NX500_spi_interrupt_control_register_IR_out_full_en;   /* IRQ enable for irq_spi(6)            */
	unsigned int reserved1        : BFW_NX500_spi_interrupt_control_register_reserved1;        /* reserved                             */
} NX500_SPI_INTERRUPT_CONTROL_REGISTER_BIT_T;

typedef union {
	unsigned int                               val;
	NX500_SPI_INTERRUPT_CONTROL_REGISTER_BIT_T bf;
} NX500_SPI_INTERRUPT_CONTROL_REGISTER_T;


/* ===================================================================== */

/* Area of i2c */

/* ===================================================================== */

#define Addr_NX500_i2c      0x00100D00U
#define NX500_NETX_I2C_AREA 0x00100D00U

/* --------------------------------------------------------------------- */
/* Register i2c_ctrl */
/* => I2C Control Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_i2c_ctrl  0x00000000U
#define Adr_NX500_i2c_i2c_ctrl  0x00100D00U
#define Adr_NX500_i2c_ctrl      0x00100D00U
#define DFLT_VAL_NX500_i2c_ctrl 0x00000000U

#define MSK_NX500_i2c_ctrl_ENABLE      0x00000001U
#define SRT_NX500_i2c_ctrl_ENABLE      0
#define DFLT_VAL_NX500_i2c_ctrl_ENABLE 0x00000000U
#define MSK_NX500_i2c_ctrl_SPEED       0x0000000eU
#define SRT_NX500_i2c_ctrl_SPEED       1
#define DFLT_VAL_NX500_i2c_ctrl_SPEED  0x00000000U
#define MSK_NX500_i2c_ctrl_ID          0x000007f0U
#define SRT_NX500_i2c_ctrl_ID          4
#define DFLT_VAL_NX500_i2c_ctrl_ID     0x00000000U

enum {
	BFW_NX500_i2c_ctrl_ENABLE    = 1,  /* [0] */
	BFW_NX500_i2c_ctrl_SPEED     = 3,  /* [3:1] */
	BFW_NX500_i2c_ctrl_ID        = 7,  /* [10:4] */
	BFW_NX500_i2c_ctrl_reserved1 = 21  /* [31:11] */
};

typedef struct NX500_I2C_CTRL_BIT_Ttag {
	unsigned int ENABLE    : BFW_NX500_i2c_ctrl_ENABLE;    /* 0: interface disable       */
	                                                       /* 1: interface enable        */
	unsigned int SPEED     : BFW_NX500_i2c_ctrl_SPEED;     /* speed select.              */
	                                                       /* when 100 MHz system clock: */
	unsigned int ID        : BFW_NX500_i2c_ctrl_ID;        /* 7 bit slave device id.     */
	unsigned int reserved1 : BFW_NX500_i2c_ctrl_reserved1; /* reserved                   */
} NX500_I2C_CTRL_BIT_T;

typedef union {
	unsigned int         val;
	NX500_I2C_CTRL_BIT_T bf;
} NX500_I2C_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register i2c_data */
/* => I2c data register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_i2c_data  0x00000004U
#define Adr_NX500_i2c_i2c_data  0x00100D04U
#define Adr_NX500_i2c_data      0x00100D04U
#define DFLT_VAL_NX500_i2c_data 0x00000000U

#define MSK_NX500_i2c_data_DATA      0x000000ffU
#define SRT_NX500_i2c_data_DATA      0
#define DFLT_VAL_NX500_i2c_data_DATA 0x00000000U
#define MSK_NX500_i2c_data_CMD0      0x00000100U
#define SRT_NX500_i2c_data_CMD0      8
#define DFLT_VAL_NX500_i2c_data_CMD0 0x00000000U
#define MSK_NX500_i2c_data_CMD1      0x00000200U
#define SRT_NX500_i2c_data_CMD1      9
#define DFLT_VAL_NX500_i2c_data_CMD1 0x00000000U
#define MSK_NX500_i2c_data_CMD2      0x00000400U
#define SRT_NX500_i2c_data_CMD2      10
#define DFLT_VAL_NX500_i2c_data_CMD2 0x00000000U
#define MSK_NX500_i2c_data_CMD3      0x00000800U
#define SRT_NX500_i2c_data_CMD3      11
#define DFLT_VAL_NX500_i2c_data_CMD3 0x00000000U
#define MSK_NX500_i2c_data_RDF       0x00001000U
#define SRT_NX500_i2c_data_RDF       12
#define DFLT_VAL_NX500_i2c_data_RDF  0x00000000U
#define MSK_NX500_i2c_data_ACK       0x00006000U
#define SRT_NX500_i2c_data_ACK       13
#define DFLT_VAL_NX500_i2c_data_ACK  0x00000000U

enum {
	BFW_NX500_i2c_data_DATA      = 8,  /* [7:0] */
	BFW_NX500_i2c_data_CMD0      = 1,  /* [8] */
	BFW_NX500_i2c_data_CMD1      = 1,  /* [9] */
	BFW_NX500_i2c_data_CMD2      = 1,  /* [10] */
	BFW_NX500_i2c_data_CMD3      = 1,  /* [11] */
	BFW_NX500_i2c_data_RDF       = 1,  /* [12] */
	BFW_NX500_i2c_data_ACK       = 2,  /* [14:13] */
	BFW_NX500_i2c_data_reserved1 = 17  /* [31:15] */
};

typedef struct NX500_I2C_DATA_BIT_Ttag {
	unsigned int DATA      : BFW_NX500_i2c_data_DATA;      /* transmit or receive data byte                                                             */
	unsigned int CMD0      : BFW_NX500_i2c_data_CMD0;      /* Command Bit 0: Stop                                                                       */
	                                                       /*  0 : normal transfer, must be continued or restarted with next command                    */
	unsigned int CMD1      : BFW_NX500_i2c_data_CMD1;      /* Command Bit 1: nWR (transfer direction, bit 8 during start sequence).                     */
	                                                       /*  0 : write Byte                                                                           */
	unsigned int CMD2      : BFW_NX500_i2c_data_CMD2;      /* Command Bit 2: Start                                                                      */
	                                                       /*  0 : normal 1 byte data transfer                                                          */
	unsigned int CMD3      : BFW_NX500_i2c_data_CMD3;      /* Command Bit 3: Execute.                                                                   */
	                                                       /* Poll on this bit to detect end of command.                                                */
	unsigned int RDF       : BFW_NX500_i2c_data_RDF;       /* Read Data Finished:                                                                       */
	                                                       /* Receive data from slave is stored in DATA.                                                */
	unsigned int ACK       : BFW_NX500_i2c_data_ACK;       /* Acknowledge bits send by slave in actual command.                                         */
	                                                       /* (bit-state 1: acknowledged, SDA(bit9) low, bit-state 0: not acknowledged, SDA(bit9) high) */
	unsigned int reserved1 : BFW_NX500_i2c_data_reserved1; /* reserved                                                                                  */
} NX500_I2C_DATA_BIT_T;

typedef union {
	unsigned int         val;
	NX500_I2C_DATA_BIT_T bf;
} NX500_I2C_DATA_T;


/* ===================================================================== */

/* Area of crc */

/* ===================================================================== */

#define Addr_NX500_crc      0x00101000U
#define NX500_NETX_CRC_AREA 0x00101000U

/* --------------------------------------------------------------------- */
/* Register crc_crc */
/* => CRC Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_crc_crc  0x00000000U
#define Adr_NX500_crc_crc_crc  0x00101000U
#define Adr_NX500_crc_crc      0x00101000U
#define DFLT_VAL_NX500_crc_crc 0x00000000U

#define MSK_NX500_crc_crc_crc_val      0xffffffffU
#define SRT_NX500_crc_crc_crc_val      0
#define DFLT_VAL_NX500_crc_crc_crc_val 0x00000000U

enum {
	BFW_NX500_crc_crc_crc_val = 32  /* [31:0] */
};

typedef struct NX500_CRC_CRC_BIT_Ttag {
	unsigned int crc_val : BFW_NX500_crc_crc_crc_val; /* CRC value                                          */
	                                                  /* Upper bits should be masked, if crc_len smaller 31 */
} NX500_CRC_CRC_BIT_T;

typedef union {
	unsigned int        val;
	NX500_CRC_CRC_BIT_T bf;
} NX500_CRC_CRC_T;

/* --------------------------------------------------------------------- */
/* Register crc_data_in */
/* => CRC data in Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_crc_data_in  0x00000004U
#define Adr_NX500_crc_crc_data_in  0x00101004U
#define Adr_NX500_crc_data_in      0x00101004U
#define DFLT_VAL_NX500_crc_data_in 0x00000000U

#define MSK_NX500_crc_data_in_in      0x000000ffU
#define SRT_NX500_crc_data_in_in      0
#define DFLT_VAL_NX500_crc_data_in_in 0x00000000U

enum {
	BFW_NX500_crc_data_in_in        = 8,  /* [7:0] */
	BFW_NX500_crc_data_in_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_CRC_DATA_IN_BIT_Ttag {
	unsigned int in        : BFW_NX500_crc_data_in_in;        /* CRC input bits */
	unsigned int reserved1 : BFW_NX500_crc_data_in_reserved1; /* reserved       */
} NX500_CRC_DATA_IN_BIT_T;

typedef union {
	unsigned int            val;
	NX500_CRC_DATA_IN_BIT_T bf;
} NX500_CRC_DATA_IN_T;

/* --------------------------------------------------------------------- */
/* Register crc_polynomial */
/* => CRC Polynomial Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_crc_polynomial  0x00000008U
#define Adr_NX500_crc_crc_polynomial  0x00101008U
#define Adr_NX500_crc_polynomial      0x00101008U
#define DFLT_VAL_NX500_crc_polynomial 0x04c11db7U

#define MSK_NX500_crc_polynomial_crc_polynomial      0xffffffffU
#define SRT_NX500_crc_polynomial_crc_polynomial      0
#define DFLT_VAL_NX500_crc_polynomial_crc_polynomial 0x04c11db7U

enum {
	BFW_NX500_crc_polynomial_crc_polynomial = 32  /* [31:0] */
};

typedef struct NX500_CRC_POLYNOMIAL_BIT_Ttag {
	unsigned int crc_polynomial : BFW_NX500_crc_polynomial_crc_polynomial; /* crc polynomial (default:Ethenet CRC32)                               */
	                                                                       /* Most significant bit of polynome is always one, thus not considered. */
} NX500_CRC_POLYNOMIAL_BIT_T;

typedef union {
	unsigned int               val;
	NX500_CRC_POLYNOMIAL_BIT_T bf;
} NX500_CRC_POLYNOMIAL_T;

/* --------------------------------------------------------------------- */
/* Register crc_config */
/* => CRC config Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_crc_config  0x0000000CU
#define Adr_NX500_crc_crc_config  0x0010100CU
#define Adr_NX500_crc_config      0x0010100CU
#define DFLT_VAL_NX500_crc_config 0x00000000U

#define MSK_NX500_crc_config_crc_len              0x0000003fU
#define SRT_NX500_crc_config_crc_len              0
#define DFLT_VAL_NX500_crc_config_crc_len         0x00000000U
#define MSK_NX500_crc_config_crc_shift_right      0x00000040U
#define SRT_NX500_crc_config_crc_shift_right      6
#define DFLT_VAL_NX500_crc_config_crc_shift_right 0x00000000U
#define MSK_NX500_crc_config_crc_direct_div       0x00000080U
#define SRT_NX500_crc_config_crc_direct_div       7
#define DFLT_VAL_NX500_crc_config_crc_direct_div  0x00000000U
#define MSK_NX500_crc_config_crc_nof_bits         0x00000300U
#define SRT_NX500_crc_config_crc_nof_bits         8
#define DFLT_VAL_NX500_crc_config_crc_nof_bits    0x00000000U
#define MSK_NX500_crc_config_crc_in_msb_low       0x00000400U
#define SRT_NX500_crc_config_crc_in_msb_low       10
#define DFLT_VAL_NX500_crc_config_crc_in_msb_low  0x00000000U

enum {
	BFW_NX500_crc_config_crc_len         = 6,  /* [5:0] */
	BFW_NX500_crc_config_crc_shift_right = 1,  /* [6] */
	BFW_NX500_crc_config_crc_direct_div  = 1,  /* [7] */
	BFW_NX500_crc_config_crc_nof_bits    = 2,  /* [9:8] */
	BFW_NX500_crc_config_crc_in_msb_low  = 1,  /* [10] */
	BFW_NX500_crc_config_reserved1       = 21  /* [31:11] */
};

typedef struct NX500_CRC_CONFIG_BIT_Ttag {
	unsigned int crc_len         : BFW_NX500_crc_config_crc_len;         /* Length of CRC - 1                                                                                   */
	unsigned int crc_shift_right : BFW_NX500_crc_config_crc_shift_right; /* 1: shift crc right                                                                                  */
	unsigned int crc_direct_div  : BFW_NX500_crc_config_crc_direct_div;  /* 1: calculate direct polynolial division without n zeros after frame, usefull for parity calculation */
	unsigned int crc_nof_bits    : BFW_NX500_crc_config_crc_nof_bits;    /* number of bits to be calculated in parallel (00: 1, 01: 2, 10; 4, 11: 8)                            */
	unsigned int crc_in_msb_low  : BFW_NX500_crc_config_crc_in_msb_low;  /* swap crc_data_in, only usefull when calculating multiple bits in parallel (crc_nof_bits > 0):       */
	                                                                     /* 1: msb of incoming bits is data_in[0],                                                              */
	unsigned int reserved1       : BFW_NX500_crc_config_reserved1;       /* reserved                                                                                            */
} NX500_CRC_CONFIG_BIT_T;

typedef union {
	unsigned int           val;
	NX500_CRC_CONFIG_BIT_T bf;
} NX500_CRC_CONFIG_T;


/* ===================================================================== */

/* Area of systime */

/* ===================================================================== */

#define Addr_NX500_systime       0x00101100U
#define NX500_NETX_SYS_TIME_AREA 0x00101100U

/* --------------------------------------------------------------------- */
/* Register systime_ns */
/* => lower SYSTIME register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_systime_ns     0x00000000U
#define Adr_NX500_systime_systime_ns 0x00101100U
#define Adr_NX500_systime_ns         0x00101100U
#define DFLT_VAL_NX500_systime_ns    0x00000000U

#define MSK_NX500_systime_ns_systime_ns      0xffffffffU
#define SRT_NX500_systime_ns_systime_ns      0
#define DFLT_VAL_NX500_systime_ns_systime_ns 0x00000000U

enum {
	BFW_NX500_systime_ns_systime_ns = 32  /* [31:0] */
};

typedef struct NX500_SYSTIME_NS_BIT_Ttag {
	unsigned int systime_ns : BFW_NX500_systime_ns_systime_ns; /* Systime low (used for counting nanoseconds in IEEE15888) */
} NX500_SYSTIME_NS_BIT_T;

typedef union {
	unsigned int           val;
	NX500_SYSTIME_NS_BIT_T bf;
} NX500_SYSTIME_NS_T;

/* --------------------------------------------------------------------- */
/* Register systime_s */
/* => upper SYSTIME register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_systime_s     0x00000004U
#define Adr_NX500_systime_systime_s 0x00101104U
#define Adr_NX500_systime_s         0x00101104U
#define DFLT_VAL_NX500_systime_s    0x00000000U

#define MSK_NX500_systime_s_systime_s      0xffffffffU
#define SRT_NX500_systime_s_systime_s      0
#define DFLT_VAL_NX500_systime_s_systime_s 0x00000000U

enum {
	BFW_NX500_systime_s_systime_s = 32  /* [31:0] */
};

typedef struct NX500_SYSTIME_S_BIT_Ttag {
	unsigned int systime_s : BFW_NX500_systime_s_systime_s; /* systime high (used for counting seconds in IEEE 1588)      */
	                                                        /* value is incremented, if systime_ns reaches systime_border */
} NX500_SYSTIME_S_BIT_T;

typedef union {
	unsigned int          val;
	NX500_SYSTIME_S_BIT_T bf;
} NX500_SYSTIME_S_T;

/* --------------------------------------------------------------------- */
/* Register systime_border */
/* => SYSTIME border register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_systime_border     0x00000008U
#define Adr_NX500_systime_systime_border 0x00101108U
#define Adr_NX500_systime_border         0x00101108U
#define DFLT_VAL_NX500_systime_border    0x3b9ac9ffU

#define MSK_NX500_systime_border_systime_border      0xffffffffU
#define SRT_NX500_systime_border_systime_border      0
#define DFLT_VAL_NX500_systime_border_systime_border 0x3b9ac9ffU

enum {
	BFW_NX500_systime_border_systime_border = 32  /* [31:0] */
};

typedef struct NX500_SYSTIME_BORDER_BIT_Ttag {
	unsigned int systime_border : BFW_NX500_systime_border_systime_border; /* Systime border for lower systime:                  */
	                                                                       /* systime_ns counts from 0 to this value (inlcuded), */
} NX500_SYSTIME_BORDER_BIT_T;

typedef union {
	unsigned int               val;
	NX500_SYSTIME_BORDER_BIT_T bf;
} NX500_SYSTIME_BORDER_T;

/* --------------------------------------------------------------------- */
/* Register systime_count_value */
/* => SYSTIME count register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_systime_count_value     0x0000000CU
#define Adr_NX500_systime_systime_count_value 0x0010110CU
#define Adr_NX500_systime_count_value         0x0010110CU
#define DFLT_VAL_NX500_systime_count_value    0xa0000000U

#define MSK_NX500_systime_count_value_systime_count_value      0xffffffffU
#define SRT_NX500_systime_count_value_systime_count_value      0
#define DFLT_VAL_NX500_systime_count_value_systime_count_value 0xa0000000U

enum {
	BFW_NX500_systime_count_value_systime_count_value = 32  /* [31:0] */
};

typedef struct NX500_SYSTIME_COUNT_VALUE_BIT_Ttag {
	unsigned int systime_count_value : BFW_NX500_systime_count_value_systime_count_value; /* Each clock cycle (systime_count_value >> 28)             */
	                                                                                      /* will be added to systime (rate multiplier for IEEE1588). */
} NX500_SYSTIME_COUNT_VALUE_BIT_T;

typedef union {
	unsigned int                    val;
	NX500_SYSTIME_COUNT_VALUE_BIT_T bf;
} NX500_SYSTIME_COUNT_VALUE_T;

/* --------------------------------------------------------------------- */
/* Register systime_s_compare_value */
/* => SYSTIME sec compare register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_systime_s_compare_value     0x00000010U
#define Adr_NX500_systime_systime_s_compare_value 0x00101110U
#define Adr_NX500_systime_s_compare_value         0x00101110U
#define DFLT_VAL_NX500_systime_s_compare_value    0x00000000U

#define MSK_NX500_systime_s_compare_value_systime_s_compare_value      0xffffffffU
#define SRT_NX500_systime_s_compare_value_systime_s_compare_value      0
#define DFLT_VAL_NX500_systime_s_compare_value_systime_s_compare_value 0x00000000U

enum {
	BFW_NX500_systime_s_compare_value_systime_s_compare_value = 32  /* [31:0] */
};

typedef struct NX500_SYSTIME_S_COMPARE_VALUE_BIT_Ttag {
	unsigned int systime_s_compare_value : BFW_NX500_systime_s_compare_value_systime_s_compare_value; /* compare value with systime_s (seconds)                                */
	                                                                                                  /* set systime_s_compare_irq register if systime_s_compare_enable is set */
} NX500_SYSTIME_S_COMPARE_VALUE_BIT_T;

typedef union {
	unsigned int                        val;
	NX500_SYSTIME_S_COMPARE_VALUE_BIT_T bf;
} NX500_SYSTIME_S_COMPARE_VALUE_T;

/* --------------------------------------------------------------------- */
/* Register systime_s_compare_enable */
/* => SYSTIME sec compare enable register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_systime_s_compare_enable     0x00000014U
#define Adr_NX500_systime_systime_s_compare_enable 0x00101114U
#define Adr_NX500_systime_s_compare_enable         0x00101114U
#define DFLT_VAL_NX500_systime_s_compare_enable    0x00000000U

#define MSK_NX500_systime_s_compare_enable_systime_s_compare_enable      0x00000001U
#define SRT_NX500_systime_s_compare_enable_systime_s_compare_enable      0
#define DFLT_VAL_NX500_systime_s_compare_enable_systime_s_compare_enable 0x00000000U

enum {
	BFW_NX500_systime_s_compare_enable_systime_s_compare_enable = 1,  /* [0] */
	BFW_NX500_systime_s_compare_enable_reserved1                = 31  /* [31:1] */
};

typedef struct NX500_SYSTIME_S_COMPARE_ENABLE_BIT_Ttag {
	unsigned int systime_s_compare_enable : BFW_NX500_systime_s_compare_enable_systime_s_compare_enable; /* enable compare with systime_s (seconds)        */
	                                                                                                     /* automatic set with set systime_s_compare_value */
	unsigned int reserved1                : BFW_NX500_systime_s_compare_enable_reserved1;                /* reserved                                       */
} NX500_SYSTIME_S_COMPARE_ENABLE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_SYSTIME_S_COMPARE_ENABLE_BIT_T bf;
} NX500_SYSTIME_S_COMPARE_ENABLE_T;

/* --------------------------------------------------------------------- */
/* Register systime_s_compare_irq */
/* => SYSTIME sec compare irq register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_systime_s_compare_irq     0x00000018U
#define Adr_NX500_systime_systime_s_compare_irq 0x00101118U
#define Adr_NX500_systime_s_compare_irq         0x00101118U
#define DFLT_VAL_NX500_systime_s_compare_irq    0x00000000U

#define MSK_NX500_systime_s_compare_irq_systime_s_compare_irq      0x00000001U
#define SRT_NX500_systime_s_compare_irq_systime_s_compare_irq      0
#define DFLT_VAL_NX500_systime_s_compare_irq_systime_s_compare_irq 0x00000000U

enum {
	BFW_NX500_systime_s_compare_irq_systime_s_compare_irq = 1,  /* [0] */
	BFW_NX500_systime_s_compare_irq_reserved1             = 31  /* [31:1] */
};

typedef struct NX500_SYSTIME_S_COMPARE_IRQ_BIT_Ttag {
	unsigned int systime_s_compare_irq : BFW_NX500_systime_s_compare_irq_systime_s_compare_irq; /* compare with systime_s (seconds) irq           */
	                                                                                            /* set if systime_s equal systime_s_compare_value */
	unsigned int reserved1             : BFW_NX500_systime_s_compare_irq_reserved1;             /* reserved                                       */
} NX500_SYSTIME_S_COMPARE_IRQ_BIT_T;

typedef union {
	unsigned int                      val;
	NX500_SYSTIME_S_COMPARE_IRQ_BIT_T bf;
} NX500_SYSTIME_S_COMPARE_IRQ_T;


/* ===================================================================== */

/* Area of rtc */

/* ===================================================================== */

#define Addr_NX500_rtc      0x00101200U
#define NX500_NETX_RTC_AREA 0x00101200U

/* --------------------------------------------------------------------- */
/* Register rtc_val */
/* => RTC 1Hz based value register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_rtc_val  0x00000000U
#define Adr_NX500_rtc_rtc_val  0x00101200U
#define Adr_NX500_rtc_val      0x00101200U
#define DFLT_VAL_NX500_rtc_val 0x00000000U

#define MSK_NX500_rtc_val_VAL      0xffffffffU
#define SRT_NX500_rtc_val_VAL      0
#define DFLT_VAL_NX500_rtc_val_VAL 0x00000000U

enum {
	BFW_NX500_rtc_val_VAL = 32  /* [31:0] */
};

typedef struct NX500_RTC_VAL_BIT_Ttag {
	unsigned int VAL : BFW_NX500_rtc_val_VAL; /* 1Hz counter value:                                           */
	                                          /* This value always counts up with 1/32k of external RTC-Xtal. */
} NX500_RTC_VAL_BIT_T;

typedef union {
	unsigned int        val;
	NX500_RTC_VAL_BIT_T bf;
} NX500_RTC_VAL_T;

/* --------------------------------------------------------------------- */
/* Register rtc_32k */
/* => RTC 32KHz based value register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_rtc_32k 0x00000004U
#define Adr_NX500_rtc_rtc_32k 0x00101204U
#define Adr_NX500_rtc_32k     0x00101204U

#define MSK_NX500_rtc_32k_VAL 0xffffffffU
#define SRT_NX500_rtc_32k_VAL 0

enum {
	BFW_NX500_rtc_32k_VAL = 32  /* [31:0] */
};

typedef struct NX500_RTC_32K_BIT_Ttag {
	unsigned int VAL : BFW_NX500_rtc_32k_VAL; /* 32KHz counter value:                                */
	                                          /* This value always counts up with external RTC-Xtal. */
} NX500_RTC_32K_BIT_T;

typedef union {
	unsigned int        val;
	NX500_RTC_32K_BIT_T bf;
} NX500_RTC_32K_T;

/* --------------------------------------------------------------------- */
/* Register rtc_32ks */
/* => Sampled RTC 32KHz based value register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_rtc_32ks 0x00000008U
#define Adr_NX500_rtc_rtc_32ks 0x00101208U
#define Adr_NX500_rtc_32ks     0x00101208U

#define MSK_NX500_rtc_32ks_VAL 0xffffffffU
#define SRT_NX500_rtc_32ks_VAL 0

enum {
	BFW_NX500_rtc_32ks_VAL = 32  /* [31:0] */
};

typedef struct NX500_RTC_32KS_BIT_Ttag {
	unsigned int VAL : BFW_NX500_rtc_32ks_VAL; /* 32KHz counter value sampled on read last read access to rtc_val:              */
	                                           /* This value might be used to get information about exact phase of 32kHz clock. */
} NX500_RTC_32KS_BIT_T;

typedef union {
	unsigned int         val;
	NX500_RTC_32KS_BIT_T bf;
} NX500_RTC_32KS_T;

/* --------------------------------------------------------------------- */
/* Register rtc_irq2isolate_cycles */
/* => Number of clock_32kHz cycles, between powergood goes low and activation of isolation of RTC and buffered SRAM. */
/*    During this time, ARM-software must write all data to buffered SRAM and deactivate outputs to isolated area. */
/*    As this value is stored inside the isolated area (that has no reset), the default value has to be programmed during startup. */
/*    After powergood goes low, the remaining 32kHz-clock-cycles until enter to isolation-mode can be read out. */
/* => Mode: W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_rtc_irq2isolate_cycles  0x0000000CU
#define Adr_NX500_rtc_rtc_irq2isolate_cycles  0x0010120CU
#define Adr_NX500_rtc_irq2isolate_cycles      0x0010120CU
#define DFLT_VAL_NX500_rtc_irq2isolate_cycles 0x000000a0U

#define MSK_NX500_rtc_irq2isolate_cycles_irq2iso      0x000000ffU
#define SRT_NX500_rtc_irq2isolate_cycles_irq2iso      0
#define DFLT_VAL_NX500_rtc_irq2isolate_cycles_irq2iso 0x000000a0U

enum {
	BFW_NX500_rtc_irq2isolate_cycles_irq2iso   = 8,  /* [7:0] */
	BFW_NX500_rtc_irq2isolate_cycles_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_RTC_IRQ2ISOLATE_CYCLES_BIT_Ttag {
	unsigned int irq2iso   : BFW_NX500_rtc_irq2isolate_cycles_irq2iso;   /* number of clock_32kHz cycles */
	unsigned int reserved1 : BFW_NX500_rtc_irq2isolate_cycles_reserved1; /* reserved                     */
} NX500_RTC_IRQ2ISOLATE_CYCLES_BIT_T;

typedef union {
	unsigned int                       val;
	NX500_RTC_IRQ2ISOLATE_CYCLES_BIT_T bf;
} NX500_RTC_IRQ2ISOLATE_CYCLES_T;

/* --------------------------------------------------------------------- */
/* Register rtc_irq_mask */
/* => Isolated Area interrupt mask register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_rtc_irq_mask  0x00000010U
#define Adr_NX500_rtc_rtc_irq_mask  0x00101210U
#define Adr_NX500_rtc_irq_mask      0x00101210U
#define DFLT_VAL_NX500_rtc_irq_mask 0x00000000U

#define MSK_NX500_rtc_irq_mask_en_power_down        0x00000001U
#define SRT_NX500_rtc_irq_mask_en_power_down        0
#define DFLT_VAL_NX500_rtc_irq_mask_en_power_down   0x00000000U
#define MSK_NX500_rtc_irq_mask_en_clk32_fault1      0x00000002U
#define SRT_NX500_rtc_irq_mask_en_clk32_fault1      1
#define DFLT_VAL_NX500_rtc_irq_mask_en_clk32_fault1 0x00000000U
#define MSK_NX500_rtc_irq_mask_en_clk32_fault2      0x00000004U
#define SRT_NX500_rtc_irq_mask_en_clk32_fault2      2
#define DFLT_VAL_NX500_rtc_irq_mask_en_clk32_fault2 0x00000000U

enum {
	BFW_NX500_rtc_irq_mask_en_power_down   = 1,  /* [0] */
	BFW_NX500_rtc_irq_mask_en_clk32_fault1 = 1,  /* [1] */
	BFW_NX500_rtc_irq_mask_en_clk32_fault2 = 1,  /* [2] */
	BFW_NX500_rtc_irq_mask_reserved1       = 29  /* [31:3] */
};

typedef struct NX500_RTC_IRQ_MASK_BIT_Ttag {
	unsigned int en_power_down   : BFW_NX500_rtc_irq_mask_en_power_down;   /* enable power_good interrupt   */
	unsigned int en_clk32_fault1 : BFW_NX500_rtc_irq_mask_en_clk32_fault1; /* enable clk32_fault1 interrupt */
	unsigned int en_clk32_fault2 : BFW_NX500_rtc_irq_mask_en_clk32_fault2; /* enable clk32_fault2 interrupt */
	unsigned int reserved1       : BFW_NX500_rtc_irq_mask_reserved1;       /* reserved                      */
} NX500_RTC_IRQ_MASK_BIT_T;

typedef union {
	unsigned int             val;
	NX500_RTC_IRQ_MASK_BIT_T bf;
} NX500_RTC_IRQ_MASK_T;

/* --------------------------------------------------------------------- */
/* Register rtc_irq_stat */
/* => Isolated Area interrupt status register */
/*    writing 1 to a bit resets the Interrupt */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_rtc_irq_stat  0x00000014U
#define Adr_NX500_rtc_rtc_irq_stat  0x00101214U
#define Adr_NX500_rtc_irq_stat      0x00101214U
#define DFLT_VAL_NX500_rtc_irq_stat 0x00000000U

#define MSK_NX500_rtc_irq_stat_power_down        0x00000001U
#define SRT_NX500_rtc_irq_stat_power_down        0
#define DFLT_VAL_NX500_rtc_irq_stat_power_down   0x00000000U
#define MSK_NX500_rtc_irq_stat_clk32_fault1      0x00000002U
#define SRT_NX500_rtc_irq_stat_clk32_fault1      1
#define DFLT_VAL_NX500_rtc_irq_stat_clk32_fault1 0x00000000U
#define MSK_NX500_rtc_irq_stat_clk32_fault2      0x00000004U
#define SRT_NX500_rtc_irq_stat_clk32_fault2      2
#define DFLT_VAL_NX500_rtc_irq_stat_clk32_fault2 0x00000000U

enum {
	BFW_NX500_rtc_irq_stat_power_down   = 1,  /* [0] */
	BFW_NX500_rtc_irq_stat_clk32_fault1 = 1,  /* [1] */
	BFW_NX500_rtc_irq_stat_clk32_fault2 = 1,  /* [2] */
	BFW_NX500_rtc_irq_stat_reserved1    = 29  /* [31:3] */
};

typedef struct NX500_RTC_IRQ_STAT_BIT_Ttag {
	unsigned int power_down   : BFW_NX500_rtc_irq_stat_power_down;   /* power_good signal from external became 0,                                                               */
	unsigned int clk32_fault1 : BFW_NX500_rtc_irq_stat_clk32_fault1; /* if clk32 is not running, this bit will be set all 4096 system clock cycles (100MHz: 40,96us)            */
	                                                                 /* After resetting this bit, the next interrupt will be generated not befor 4096 system clk cycles passed. */
	unsigned int clk32_fault2 : BFW_NX500_rtc_irq_stat_clk32_fault2; /* if clk32 is not running, this bit will be set all 131072 (128k) system clock cycles (100MHz: 1.31ms)    */
	                                                                 /* After resetting this bit, the next interrupt will be generated not befor 128k system clk cycles passed. */
	unsigned int reserved1    : BFW_NX500_rtc_irq_stat_reserved1;    /* reserved                                                                                                */
} NX500_RTC_IRQ_STAT_BIT_T;

typedef union {
	unsigned int             val;
	NX500_RTC_IRQ_STAT_BIT_T bf;
} NX500_RTC_IRQ_STAT_T;

/* --------------------------------------------------------------------- */
/* Register rtc_isolated */
/* => Isolated Area is currently isolated: */
/*    write accesses to registers of RTC or BACKUP_RAM have no effect, */
/*    read accesses to registers of RTC will deliver 0, to BACKUP_RAM an abort */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_rtc_isolated 0x00000018U
#define Adr_NX500_rtc_rtc_isolated 0x00101218U
#define Adr_NX500_rtc_isolated     0x00101218U

#define MSK_NX500_rtc_isolated_not_isolated 0x00000001U
#define SRT_NX500_rtc_isolated_not_isolated 0

enum {
	BFW_NX500_rtc_isolated_not_isolated = 1,  /* [0] */
	BFW_NX500_rtc_isolated_reserved1    = 31  /* [31:1] */
};

typedef struct NX500_RTC_ISOLATED_BIT_Ttag {
	unsigned int not_isolated : BFW_NX500_rtc_isolated_not_isolated; /* 0 : Isolated Area is currently isolated     */
	                                                                 /* 1 : Isolated Area is currently not isolated */
	unsigned int reserved1    : BFW_NX500_rtc_isolated_reserved1;    /* reserved                                    */
} NX500_RTC_ISOLATED_BIT_T;

typedef union {
	unsigned int             val;
	NX500_RTC_ISOLATED_BIT_T bf;
} NX500_RTC_ISOLATED_T;


/* ===================================================================== */

/* Area of hif */

/* ===================================================================== */

#define Addr_NX500_hif 0x00103000U

/* ===================================================================== */

/* Area of host_controlled_dma_register_block */

/* ===================================================================== */

#define Addr_NX500_host_controlled_dma_register_block 0x00103000U
#define NX500_NETX_DPM_HOST_DMA_AREA                  0x00103000U

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch0_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch0_host_start                                0x00000000U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch0_host_start 0x00103000U
#define Adr_NX500_dpmhs_ch0_host_start                                    0x00103000U
#define DFLT_VAL_NX500_dpmhs_ch0_host_start                               0x00000000U

#define MSK_NX500_dpmhs_ch0_host_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch0_host_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch0_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch0_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH0_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch0_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH0_HOST_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMHS_CH0_HOST_START_BIT_T bf;
} NX500_DPMHS_CH0_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch0_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch0_netx_start                                0x00000004U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch0_netx_start 0x00103004U
#define Adr_NX500_dpmhs_ch0_netx_start                                    0x00103004U
#define DFLT_VAL_NX500_dpmhs_ch0_netx_start                               0x00000000U

#define MSK_NX500_dpmhs_ch0_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch0_netx_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch0_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch0_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH0_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch0_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH0_NETX_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMHS_CH0_NETX_START_BIT_T bf;
} NX500_DPMHS_CH0_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch0_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch0_dma_ctrl                                0x00000008U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch0_dma_ctrl 0x00103008U
#define Adr_NX500_dpmhs_ch0_dma_ctrl                                    0x00103008U
#define DFLT_VAL_NX500_dpmhs_ch0_dma_ctrl                               0x00000000U

#define MSK_NX500_dpmhs_ch0_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch0_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch0_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch0_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH0_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch0_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH0_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMHS_CH0_DMA_CTRL_BIT_T bf;
} NX500_DPMHS_CH0_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch0_host_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch0_host_mbx_base                                0x0000000CU
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch0_host_mbx_base 0x0010300CU
#define Adr_NX500_dpmhs_ch0_host_mbx_base                                    0x0010300CU
#define DFLT_VAL_NX500_dpmhs_ch0_host_mbx_base                               0x00000000U

#define MSK_NX500_dpmhs_ch0_host_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch0_host_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch0_host_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch0_host_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH0_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch0_host_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH0_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX500_DPMHS_CH0_HOST_MBX_BASE_BIT_T bf;
} NX500_DPMHS_CH0_HOST_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch0_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch0_buf_ctrl                                0x00000010U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch0_buf_ctrl 0x00103010U
#define Adr_NX500_dpmhs_ch0_buf_ctrl                                    0x00103010U
#define DFLT_VAL_NX500_dpmhs_ch0_buf_ctrl                               0x00000000U

#define MSK_NX500_dpmhs_ch0_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch0_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch0_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch0_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH0_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch0_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH0_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMHS_CH0_BUF_CTRL_BIT_T bf;
} NX500_DPMHS_CH0_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch0_host_buf3_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch0_host_buf3_base                                0x00000014U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch0_host_buf3_base 0x00103014U
#define Adr_NX500_dpmhs_ch0_host_buf3_base                                    0x00103014U
#define DFLT_VAL_NX500_dpmhs_ch0_host_buf3_base                               0x00000000U

#define MSK_NX500_dpmhs_ch0_host_buf3_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch0_host_buf3_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch0_host_buf3_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch0_host_buf3_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH0_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch0_host_buf3_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH0_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH0_HOST_BUF3_BASE_BIT_T bf;
} NX500_DPMHS_CH0_HOST_BUF3_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch0_host_buf2_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch0_host_buf2_base                                0x00000018U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch0_host_buf2_base 0x00103018U
#define Adr_NX500_dpmhs_ch0_host_buf2_base                                    0x00103018U
#define DFLT_VAL_NX500_dpmhs_ch0_host_buf2_base                               0x00000000U

#define MSK_NX500_dpmhs_ch0_host_buf2_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch0_host_buf2_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch0_host_buf2_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch0_host_buf2_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH0_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch0_host_buf2_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH0_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH0_HOST_BUF2_BASE_BIT_T bf;
} NX500_DPMHS_CH0_HOST_BUF2_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch0_host_buf1_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch0_host_buf1_base                                0x0000001CU
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch0_host_buf1_base 0x0010301CU
#define Adr_NX500_dpmhs_ch0_host_buf1_base                                    0x0010301CU
#define DFLT_VAL_NX500_dpmhs_ch0_host_buf1_base                               0x00000000U

#define MSK_NX500_dpmhs_ch0_host_buf1_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch0_host_buf1_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch0_host_buf1_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch0_host_buf1_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH0_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch0_host_buf1_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH0_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH0_HOST_BUF1_BASE_BIT_T bf;
} NX500_DPMHS_CH0_HOST_BUF1_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch1_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch1_host_start                                0x00000020U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch1_host_start 0x00103020U
#define Adr_NX500_dpmhs_ch1_host_start                                    0x00103020U
#define DFLT_VAL_NX500_dpmhs_ch1_host_start                               0x00000000U

#define MSK_NX500_dpmhs_ch1_host_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch1_host_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch1_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch1_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH1_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch1_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH1_HOST_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMHS_CH1_HOST_START_BIT_T bf;
} NX500_DPMHS_CH1_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch1_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch1_netx_start                                0x00000024U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch1_netx_start 0x00103024U
#define Adr_NX500_dpmhs_ch1_netx_start                                    0x00103024U
#define DFLT_VAL_NX500_dpmhs_ch1_netx_start                               0x00000000U

#define MSK_NX500_dpmhs_ch1_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch1_netx_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch1_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch1_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH1_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch1_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH1_NETX_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMHS_CH1_NETX_START_BIT_T bf;
} NX500_DPMHS_CH1_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch1_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch1_dma_ctrl                                0x00000028U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch1_dma_ctrl 0x00103028U
#define Adr_NX500_dpmhs_ch1_dma_ctrl                                    0x00103028U
#define DFLT_VAL_NX500_dpmhs_ch1_dma_ctrl                               0x00000000U

#define MSK_NX500_dpmhs_ch1_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch1_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch1_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch1_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH1_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch1_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH1_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMHS_CH1_DMA_CTRL_BIT_T bf;
} NX500_DPMHS_CH1_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch1_host_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch1_host_mbx_base                                0x0000002CU
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch1_host_mbx_base 0x0010302CU
#define Adr_NX500_dpmhs_ch1_host_mbx_base                                    0x0010302CU
#define DFLT_VAL_NX500_dpmhs_ch1_host_mbx_base                               0x00000000U

#define MSK_NX500_dpmhs_ch1_host_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch1_host_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch1_host_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch1_host_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH1_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch1_host_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH1_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX500_DPMHS_CH1_HOST_MBX_BASE_BIT_T bf;
} NX500_DPMHS_CH1_HOST_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch1_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch1_buf_ctrl                                0x00000030U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch1_buf_ctrl 0x00103030U
#define Adr_NX500_dpmhs_ch1_buf_ctrl                                    0x00103030U
#define DFLT_VAL_NX500_dpmhs_ch1_buf_ctrl                               0x00000000U

#define MSK_NX500_dpmhs_ch1_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch1_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch1_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch1_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH1_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch1_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH1_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMHS_CH1_BUF_CTRL_BIT_T bf;
} NX500_DPMHS_CH1_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch1_host_buf3_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch1_host_buf3_base                                0x00000034U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch1_host_buf3_base 0x00103034U
#define Adr_NX500_dpmhs_ch1_host_buf3_base                                    0x00103034U
#define DFLT_VAL_NX500_dpmhs_ch1_host_buf3_base                               0x00000000U

#define MSK_NX500_dpmhs_ch1_host_buf3_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch1_host_buf3_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch1_host_buf3_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch1_host_buf3_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH1_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch1_host_buf3_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH1_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH1_HOST_BUF3_BASE_BIT_T bf;
} NX500_DPMHS_CH1_HOST_BUF3_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch1_host_buf2_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch1_host_buf2_base                                0x00000038U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch1_host_buf2_base 0x00103038U
#define Adr_NX500_dpmhs_ch1_host_buf2_base                                    0x00103038U
#define DFLT_VAL_NX500_dpmhs_ch1_host_buf2_base                               0x00000000U

#define MSK_NX500_dpmhs_ch1_host_buf2_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch1_host_buf2_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch1_host_buf2_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch1_host_buf2_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH1_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch1_host_buf2_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH1_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH1_HOST_BUF2_BASE_BIT_T bf;
} NX500_DPMHS_CH1_HOST_BUF2_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch1_host_buf1_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch1_host_buf1_base                                0x0000003CU
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch1_host_buf1_base 0x0010303CU
#define Adr_NX500_dpmhs_ch1_host_buf1_base                                    0x0010303CU
#define DFLT_VAL_NX500_dpmhs_ch1_host_buf1_base                               0x00000000U

#define MSK_NX500_dpmhs_ch1_host_buf1_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch1_host_buf1_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch1_host_buf1_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch1_host_buf1_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH1_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch1_host_buf1_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH1_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH1_HOST_BUF1_BASE_BIT_T bf;
} NX500_DPMHS_CH1_HOST_BUF1_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch2_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch2_host_start                                0x00000040U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch2_host_start 0x00103040U
#define Adr_NX500_dpmhs_ch2_host_start                                    0x00103040U
#define DFLT_VAL_NX500_dpmhs_ch2_host_start                               0x00000000U

#define MSK_NX500_dpmhs_ch2_host_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch2_host_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch2_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch2_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH2_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch2_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH2_HOST_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMHS_CH2_HOST_START_BIT_T bf;
} NX500_DPMHS_CH2_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch2_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch2_netx_start                                0x00000044U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch2_netx_start 0x00103044U
#define Adr_NX500_dpmhs_ch2_netx_start                                    0x00103044U
#define DFLT_VAL_NX500_dpmhs_ch2_netx_start                               0x00000000U

#define MSK_NX500_dpmhs_ch2_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch2_netx_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch2_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch2_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH2_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch2_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH2_NETX_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMHS_CH2_NETX_START_BIT_T bf;
} NX500_DPMHS_CH2_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch2_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch2_dma_ctrl                                0x00000048U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch2_dma_ctrl 0x00103048U
#define Adr_NX500_dpmhs_ch2_dma_ctrl                                    0x00103048U
#define DFLT_VAL_NX500_dpmhs_ch2_dma_ctrl                               0x00000000U

#define MSK_NX500_dpmhs_ch2_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch2_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch2_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch2_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH2_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch2_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH2_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMHS_CH2_DMA_CTRL_BIT_T bf;
} NX500_DPMHS_CH2_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch2_host_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch2_host_mbx_base                                0x0000004CU
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch2_host_mbx_base 0x0010304CU
#define Adr_NX500_dpmhs_ch2_host_mbx_base                                    0x0010304CU
#define DFLT_VAL_NX500_dpmhs_ch2_host_mbx_base                               0x00000000U

#define MSK_NX500_dpmhs_ch2_host_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch2_host_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch2_host_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch2_host_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH2_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch2_host_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH2_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX500_DPMHS_CH2_HOST_MBX_BASE_BIT_T bf;
} NX500_DPMHS_CH2_HOST_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch2_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch2_buf_ctrl                                0x00000050U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch2_buf_ctrl 0x00103050U
#define Adr_NX500_dpmhs_ch2_buf_ctrl                                    0x00103050U
#define DFLT_VAL_NX500_dpmhs_ch2_buf_ctrl                               0x00000000U

#define MSK_NX500_dpmhs_ch2_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch2_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch2_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch2_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH2_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch2_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH2_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMHS_CH2_BUF_CTRL_BIT_T bf;
} NX500_DPMHS_CH2_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch2_host_buf3_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch2_host_buf3_base                                0x00000054U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch2_host_buf3_base 0x00103054U
#define Adr_NX500_dpmhs_ch2_host_buf3_base                                    0x00103054U
#define DFLT_VAL_NX500_dpmhs_ch2_host_buf3_base                               0x00000000U

#define MSK_NX500_dpmhs_ch2_host_buf3_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch2_host_buf3_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch2_host_buf3_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch2_host_buf3_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH2_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch2_host_buf3_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH2_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH2_HOST_BUF3_BASE_BIT_T bf;
} NX500_DPMHS_CH2_HOST_BUF3_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch2_host_buf2_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch2_host_buf2_base                                0x00000058U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch2_host_buf2_base 0x00103058U
#define Adr_NX500_dpmhs_ch2_host_buf2_base                                    0x00103058U
#define DFLT_VAL_NX500_dpmhs_ch2_host_buf2_base                               0x00000000U

#define MSK_NX500_dpmhs_ch2_host_buf2_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch2_host_buf2_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch2_host_buf2_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch2_host_buf2_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH2_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch2_host_buf2_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH2_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH2_HOST_BUF2_BASE_BIT_T bf;
} NX500_DPMHS_CH2_HOST_BUF2_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch2_host_buf1_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch2_host_buf1_base                                0x0000005CU
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch2_host_buf1_base 0x0010305CU
#define Adr_NX500_dpmhs_ch2_host_buf1_base                                    0x0010305CU
#define DFLT_VAL_NX500_dpmhs_ch2_host_buf1_base                               0x00000000U

#define MSK_NX500_dpmhs_ch2_host_buf1_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch2_host_buf1_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch2_host_buf1_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch2_host_buf1_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH2_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch2_host_buf1_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH2_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH2_HOST_BUF1_BASE_BIT_T bf;
} NX500_DPMHS_CH2_HOST_BUF1_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch3_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch3_host_start                                0x00000060U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch3_host_start 0x00103060U
#define Adr_NX500_dpmhs_ch3_host_start                                    0x00103060U
#define DFLT_VAL_NX500_dpmhs_ch3_host_start                               0x00000000U

#define MSK_NX500_dpmhs_ch3_host_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch3_host_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch3_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch3_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH3_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch3_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH3_HOST_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMHS_CH3_HOST_START_BIT_T bf;
} NX500_DPMHS_CH3_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch3_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch3_netx_start                                0x00000064U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch3_netx_start 0x00103064U
#define Adr_NX500_dpmhs_ch3_netx_start                                    0x00103064U
#define DFLT_VAL_NX500_dpmhs_ch3_netx_start                               0x00000000U

#define MSK_NX500_dpmhs_ch3_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch3_netx_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch3_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch3_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH3_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch3_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH3_NETX_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMHS_CH3_NETX_START_BIT_T bf;
} NX500_DPMHS_CH3_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch3_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch3_dma_ctrl                                0x00000068U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch3_dma_ctrl 0x00103068U
#define Adr_NX500_dpmhs_ch3_dma_ctrl                                    0x00103068U
#define DFLT_VAL_NX500_dpmhs_ch3_dma_ctrl                               0x00000000U

#define MSK_NX500_dpmhs_ch3_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch3_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch3_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch3_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH3_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch3_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH3_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMHS_CH3_DMA_CTRL_BIT_T bf;
} NX500_DPMHS_CH3_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch3_host_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch3_host_mbx_base                                0x0000006CU
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch3_host_mbx_base 0x0010306CU
#define Adr_NX500_dpmhs_ch3_host_mbx_base                                    0x0010306CU
#define DFLT_VAL_NX500_dpmhs_ch3_host_mbx_base                               0x00000000U

#define MSK_NX500_dpmhs_ch3_host_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch3_host_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch3_host_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch3_host_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH3_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch3_host_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH3_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX500_DPMHS_CH3_HOST_MBX_BASE_BIT_T bf;
} NX500_DPMHS_CH3_HOST_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch3_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch3_buf_ctrl                                0x00000070U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch3_buf_ctrl 0x00103070U
#define Adr_NX500_dpmhs_ch3_buf_ctrl                                    0x00103070U
#define DFLT_VAL_NX500_dpmhs_ch3_buf_ctrl                               0x00000000U

#define MSK_NX500_dpmhs_ch3_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch3_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch3_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch3_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH3_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch3_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH3_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMHS_CH3_BUF_CTRL_BIT_T bf;
} NX500_DPMHS_CH3_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch3_host_buf3_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch3_host_buf3_base                                0x00000074U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch3_host_buf3_base 0x00103074U
#define Adr_NX500_dpmhs_ch3_host_buf3_base                                    0x00103074U
#define DFLT_VAL_NX500_dpmhs_ch3_host_buf3_base                               0x00000000U

#define MSK_NX500_dpmhs_ch3_host_buf3_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch3_host_buf3_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch3_host_buf3_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch3_host_buf3_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH3_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch3_host_buf3_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH3_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH3_HOST_BUF3_BASE_BIT_T bf;
} NX500_DPMHS_CH3_HOST_BUF3_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch3_host_buf2_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch3_host_buf2_base                                0x00000078U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch3_host_buf2_base 0x00103078U
#define Adr_NX500_dpmhs_ch3_host_buf2_base                                    0x00103078U
#define DFLT_VAL_NX500_dpmhs_ch3_host_buf2_base                               0x00000000U

#define MSK_NX500_dpmhs_ch3_host_buf2_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch3_host_buf2_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch3_host_buf2_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch3_host_buf2_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH3_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch3_host_buf2_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH3_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH3_HOST_BUF2_BASE_BIT_T bf;
} NX500_DPMHS_CH3_HOST_BUF2_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch3_host_buf1_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch3_host_buf1_base                                0x0000007CU
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch3_host_buf1_base 0x0010307CU
#define Adr_NX500_dpmhs_ch3_host_buf1_base                                    0x0010307CU
#define DFLT_VAL_NX500_dpmhs_ch3_host_buf1_base                               0x00000000U

#define MSK_NX500_dpmhs_ch3_host_buf1_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch3_host_buf1_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch3_host_buf1_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch3_host_buf1_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH3_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch3_host_buf1_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH3_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH3_HOST_BUF1_BASE_BIT_T bf;
} NX500_DPMHS_CH3_HOST_BUF1_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch4_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch4_host_start                                0x00000080U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch4_host_start 0x00103080U
#define Adr_NX500_dpmhs_ch4_host_start                                    0x00103080U
#define DFLT_VAL_NX500_dpmhs_ch4_host_start                               0x00000000U

#define MSK_NX500_dpmhs_ch4_host_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch4_host_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch4_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch4_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH4_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch4_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH4_HOST_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMHS_CH4_HOST_START_BIT_T bf;
} NX500_DPMHS_CH4_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch4_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch4_netx_start                                0x00000084U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch4_netx_start 0x00103084U
#define Adr_NX500_dpmhs_ch4_netx_start                                    0x00103084U
#define DFLT_VAL_NX500_dpmhs_ch4_netx_start                               0x00000000U

#define MSK_NX500_dpmhs_ch4_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch4_netx_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch4_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch4_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH4_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch4_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH4_NETX_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMHS_CH4_NETX_START_BIT_T bf;
} NX500_DPMHS_CH4_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch4_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch4_dma_ctrl                                0x00000088U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch4_dma_ctrl 0x00103088U
#define Adr_NX500_dpmhs_ch4_dma_ctrl                                    0x00103088U
#define DFLT_VAL_NX500_dpmhs_ch4_dma_ctrl                               0x00000000U

#define MSK_NX500_dpmhs_ch4_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch4_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch4_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch4_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH4_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch4_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH4_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMHS_CH4_DMA_CTRL_BIT_T bf;
} NX500_DPMHS_CH4_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch4_host_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch4_host_mbx_base                                0x0000008CU
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch4_host_mbx_base 0x0010308CU
#define Adr_NX500_dpmhs_ch4_host_mbx_base                                    0x0010308CU
#define DFLT_VAL_NX500_dpmhs_ch4_host_mbx_base                               0x00000000U

#define MSK_NX500_dpmhs_ch4_host_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch4_host_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch4_host_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch4_host_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH4_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch4_host_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH4_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX500_DPMHS_CH4_HOST_MBX_BASE_BIT_T bf;
} NX500_DPMHS_CH4_HOST_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch4_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch4_buf_ctrl                                0x00000090U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch4_buf_ctrl 0x00103090U
#define Adr_NX500_dpmhs_ch4_buf_ctrl                                    0x00103090U
#define DFLT_VAL_NX500_dpmhs_ch4_buf_ctrl                               0x00000000U

#define MSK_NX500_dpmhs_ch4_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch4_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch4_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch4_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH4_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch4_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH4_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMHS_CH4_BUF_CTRL_BIT_T bf;
} NX500_DPMHS_CH4_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch4_host_buf3_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch4_host_buf3_base                                0x00000094U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch4_host_buf3_base 0x00103094U
#define Adr_NX500_dpmhs_ch4_host_buf3_base                                    0x00103094U
#define DFLT_VAL_NX500_dpmhs_ch4_host_buf3_base                               0x00000000U

#define MSK_NX500_dpmhs_ch4_host_buf3_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch4_host_buf3_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch4_host_buf3_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch4_host_buf3_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH4_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch4_host_buf3_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH4_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH4_HOST_BUF3_BASE_BIT_T bf;
} NX500_DPMHS_CH4_HOST_BUF3_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch4_host_buf2_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch4_host_buf2_base                                0x00000098U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch4_host_buf2_base 0x00103098U
#define Adr_NX500_dpmhs_ch4_host_buf2_base                                    0x00103098U
#define DFLT_VAL_NX500_dpmhs_ch4_host_buf2_base                               0x00000000U

#define MSK_NX500_dpmhs_ch4_host_buf2_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch4_host_buf2_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch4_host_buf2_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch4_host_buf2_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH4_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch4_host_buf2_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH4_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH4_HOST_BUF2_BASE_BIT_T bf;
} NX500_DPMHS_CH4_HOST_BUF2_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch4_host_buf1_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch4_host_buf1_base                                0x0000009CU
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch4_host_buf1_base 0x0010309CU
#define Adr_NX500_dpmhs_ch4_host_buf1_base                                    0x0010309CU
#define DFLT_VAL_NX500_dpmhs_ch4_host_buf1_base                               0x00000000U

#define MSK_NX500_dpmhs_ch4_host_buf1_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch4_host_buf1_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch4_host_buf1_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch4_host_buf1_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH4_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch4_host_buf1_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH4_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH4_HOST_BUF1_BASE_BIT_T bf;
} NX500_DPMHS_CH4_HOST_BUF1_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch5_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch5_host_start                                0x000000A0U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch5_host_start 0x001030A0U
#define Adr_NX500_dpmhs_ch5_host_start                                    0x001030A0U
#define DFLT_VAL_NX500_dpmhs_ch5_host_start                               0x00000000U

#define MSK_NX500_dpmhs_ch5_host_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch5_host_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch5_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch5_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH5_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch5_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH5_HOST_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMHS_CH5_HOST_START_BIT_T bf;
} NX500_DPMHS_CH5_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch5_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch5_netx_start                                0x000000A4U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch5_netx_start 0x001030A4U
#define Adr_NX500_dpmhs_ch5_netx_start                                    0x001030A4U
#define DFLT_VAL_NX500_dpmhs_ch5_netx_start                               0x00000000U

#define MSK_NX500_dpmhs_ch5_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch5_netx_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch5_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch5_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH5_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch5_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH5_NETX_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMHS_CH5_NETX_START_BIT_T bf;
} NX500_DPMHS_CH5_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch5_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch5_dma_ctrl                                0x000000A8U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch5_dma_ctrl 0x001030A8U
#define Adr_NX500_dpmhs_ch5_dma_ctrl                                    0x001030A8U
#define DFLT_VAL_NX500_dpmhs_ch5_dma_ctrl                               0x00000000U

#define MSK_NX500_dpmhs_ch5_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch5_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch5_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch5_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH5_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch5_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH5_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMHS_CH5_DMA_CTRL_BIT_T bf;
} NX500_DPMHS_CH5_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch5_host_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch5_host_mbx_base                                0x000000ACU
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch5_host_mbx_base 0x001030ACU
#define Adr_NX500_dpmhs_ch5_host_mbx_base                                    0x001030ACU
#define DFLT_VAL_NX500_dpmhs_ch5_host_mbx_base                               0x00000000U

#define MSK_NX500_dpmhs_ch5_host_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch5_host_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch5_host_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch5_host_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH5_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch5_host_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH5_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX500_DPMHS_CH5_HOST_MBX_BASE_BIT_T bf;
} NX500_DPMHS_CH5_HOST_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch5_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch5_buf_ctrl                                0x000000B0U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch5_buf_ctrl 0x001030B0U
#define Adr_NX500_dpmhs_ch5_buf_ctrl                                    0x001030B0U
#define DFLT_VAL_NX500_dpmhs_ch5_buf_ctrl                               0x00000000U

#define MSK_NX500_dpmhs_ch5_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch5_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch5_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch5_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH5_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch5_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH5_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMHS_CH5_BUF_CTRL_BIT_T bf;
} NX500_DPMHS_CH5_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch5_host_buf3_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch5_host_buf3_base                                0x000000B4U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch5_host_buf3_base 0x001030B4U
#define Adr_NX500_dpmhs_ch5_host_buf3_base                                    0x001030B4U
#define DFLT_VAL_NX500_dpmhs_ch5_host_buf3_base                               0x00000000U

#define MSK_NX500_dpmhs_ch5_host_buf3_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch5_host_buf3_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch5_host_buf3_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch5_host_buf3_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH5_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch5_host_buf3_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH5_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH5_HOST_BUF3_BASE_BIT_T bf;
} NX500_DPMHS_CH5_HOST_BUF3_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch5_host_buf2_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch5_host_buf2_base                                0x000000B8U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch5_host_buf2_base 0x001030B8U
#define Adr_NX500_dpmhs_ch5_host_buf2_base                                    0x001030B8U
#define DFLT_VAL_NX500_dpmhs_ch5_host_buf2_base                               0x00000000U

#define MSK_NX500_dpmhs_ch5_host_buf2_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch5_host_buf2_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch5_host_buf2_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch5_host_buf2_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH5_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch5_host_buf2_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH5_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH5_HOST_BUF2_BASE_BIT_T bf;
} NX500_DPMHS_CH5_HOST_BUF2_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch5_host_buf1_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch5_host_buf1_base                                0x000000BCU
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch5_host_buf1_base 0x001030BCU
#define Adr_NX500_dpmhs_ch5_host_buf1_base                                    0x001030BCU
#define DFLT_VAL_NX500_dpmhs_ch5_host_buf1_base                               0x00000000U

#define MSK_NX500_dpmhs_ch5_host_buf1_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch5_host_buf1_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch5_host_buf1_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch5_host_buf1_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH5_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch5_host_buf1_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH5_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH5_HOST_BUF1_BASE_BIT_T bf;
} NX500_DPMHS_CH5_HOST_BUF1_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch6_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch6_host_start                                0x000000C0U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch6_host_start 0x001030C0U
#define Adr_NX500_dpmhs_ch6_host_start                                    0x001030C0U
#define DFLT_VAL_NX500_dpmhs_ch6_host_start                               0x00000000U

#define MSK_NX500_dpmhs_ch6_host_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch6_host_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch6_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch6_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH6_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch6_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH6_HOST_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMHS_CH6_HOST_START_BIT_T bf;
} NX500_DPMHS_CH6_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch6_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch6_netx_start                                0x000000C4U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch6_netx_start 0x001030C4U
#define Adr_NX500_dpmhs_ch6_netx_start                                    0x001030C4U
#define DFLT_VAL_NX500_dpmhs_ch6_netx_start                               0x00000000U

#define MSK_NX500_dpmhs_ch6_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch6_netx_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch6_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch6_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH6_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch6_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH6_NETX_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMHS_CH6_NETX_START_BIT_T bf;
} NX500_DPMHS_CH6_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch6_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch6_dma_ctrl                                0x000000C8U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch6_dma_ctrl 0x001030C8U
#define Adr_NX500_dpmhs_ch6_dma_ctrl                                    0x001030C8U
#define DFLT_VAL_NX500_dpmhs_ch6_dma_ctrl                               0x00000000U

#define MSK_NX500_dpmhs_ch6_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch6_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch6_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch6_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH6_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch6_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH6_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMHS_CH6_DMA_CTRL_BIT_T bf;
} NX500_DPMHS_CH6_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch6_host_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch6_host_mbx_base                                0x000000CCU
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch6_host_mbx_base 0x001030CCU
#define Adr_NX500_dpmhs_ch6_host_mbx_base                                    0x001030CCU
#define DFLT_VAL_NX500_dpmhs_ch6_host_mbx_base                               0x00000000U

#define MSK_NX500_dpmhs_ch6_host_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch6_host_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch6_host_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch6_host_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH6_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch6_host_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH6_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX500_DPMHS_CH6_HOST_MBX_BASE_BIT_T bf;
} NX500_DPMHS_CH6_HOST_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch6_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch6_buf_ctrl                                0x000000D0U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch6_buf_ctrl 0x001030D0U
#define Adr_NX500_dpmhs_ch6_buf_ctrl                                    0x001030D0U
#define DFLT_VAL_NX500_dpmhs_ch6_buf_ctrl                               0x00000000U

#define MSK_NX500_dpmhs_ch6_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch6_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch6_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch6_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH6_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch6_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH6_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMHS_CH6_BUF_CTRL_BIT_T bf;
} NX500_DPMHS_CH6_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch6_host_buf3_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch6_host_buf3_base                                0x000000D4U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch6_host_buf3_base 0x001030D4U
#define Adr_NX500_dpmhs_ch6_host_buf3_base                                    0x001030D4U
#define DFLT_VAL_NX500_dpmhs_ch6_host_buf3_base                               0x00000000U

#define MSK_NX500_dpmhs_ch6_host_buf3_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch6_host_buf3_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch6_host_buf3_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch6_host_buf3_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH6_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch6_host_buf3_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH6_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH6_HOST_BUF3_BASE_BIT_T bf;
} NX500_DPMHS_CH6_HOST_BUF3_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch6_host_buf2_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch6_host_buf2_base                                0x000000D8U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch6_host_buf2_base 0x001030D8U
#define Adr_NX500_dpmhs_ch6_host_buf2_base                                    0x001030D8U
#define DFLT_VAL_NX500_dpmhs_ch6_host_buf2_base                               0x00000000U

#define MSK_NX500_dpmhs_ch6_host_buf2_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch6_host_buf2_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch6_host_buf2_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch6_host_buf2_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH6_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch6_host_buf2_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH6_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH6_HOST_BUF2_BASE_BIT_T bf;
} NX500_DPMHS_CH6_HOST_BUF2_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch6_host_buf1_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch6_host_buf1_base                                0x000000DCU
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch6_host_buf1_base 0x001030DCU
#define Adr_NX500_dpmhs_ch6_host_buf1_base                                    0x001030DCU
#define DFLT_VAL_NX500_dpmhs_ch6_host_buf1_base                               0x00000000U

#define MSK_NX500_dpmhs_ch6_host_buf1_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch6_host_buf1_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch6_host_buf1_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch6_host_buf1_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH6_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch6_host_buf1_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH6_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH6_HOST_BUF1_BASE_BIT_T bf;
} NX500_DPMHS_CH6_HOST_BUF1_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch7_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch7_host_start                                0x000000E0U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch7_host_start 0x001030E0U
#define Adr_NX500_dpmhs_ch7_host_start                                    0x001030E0U
#define DFLT_VAL_NX500_dpmhs_ch7_host_start                               0x00000000U

#define MSK_NX500_dpmhs_ch7_host_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch7_host_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch7_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch7_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH7_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch7_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH7_HOST_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMHS_CH7_HOST_START_BIT_T bf;
} NX500_DPMHS_CH7_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch7_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch7_netx_start                                0x000000E4U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch7_netx_start 0x001030E4U
#define Adr_NX500_dpmhs_ch7_netx_start                                    0x001030E4U
#define DFLT_VAL_NX500_dpmhs_ch7_netx_start                               0x00000000U

#define MSK_NX500_dpmhs_ch7_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch7_netx_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch7_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch7_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH7_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch7_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH7_NETX_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMHS_CH7_NETX_START_BIT_T bf;
} NX500_DPMHS_CH7_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch7_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch7_dma_ctrl                                0x000000E8U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch7_dma_ctrl 0x001030E8U
#define Adr_NX500_dpmhs_ch7_dma_ctrl                                    0x001030E8U
#define DFLT_VAL_NX500_dpmhs_ch7_dma_ctrl                               0x00000000U

#define MSK_NX500_dpmhs_ch7_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch7_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch7_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch7_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH7_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch7_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH7_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMHS_CH7_DMA_CTRL_BIT_T bf;
} NX500_DPMHS_CH7_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch7_host_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch7_host_mbx_base                                0x000000ECU
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch7_host_mbx_base 0x001030ECU
#define Adr_NX500_dpmhs_ch7_host_mbx_base                                    0x001030ECU
#define DFLT_VAL_NX500_dpmhs_ch7_host_mbx_base                               0x00000000U

#define MSK_NX500_dpmhs_ch7_host_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch7_host_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch7_host_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch7_host_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH7_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch7_host_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH7_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX500_DPMHS_CH7_HOST_MBX_BASE_BIT_T bf;
} NX500_DPMHS_CH7_HOST_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch7_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch7_buf_ctrl                                0x000000F0U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch7_buf_ctrl 0x001030F0U
#define Adr_NX500_dpmhs_ch7_buf_ctrl                                    0x001030F0U
#define DFLT_VAL_NX500_dpmhs_ch7_buf_ctrl                               0x00000000U

#define MSK_NX500_dpmhs_ch7_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch7_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch7_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch7_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH7_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch7_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH7_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMHS_CH7_BUF_CTRL_BIT_T bf;
} NX500_DPMHS_CH7_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch7_host_buf3_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch7_host_buf3_base                                0x000000F4U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch7_host_buf3_base 0x001030F4U
#define Adr_NX500_dpmhs_ch7_host_buf3_base                                    0x001030F4U
#define DFLT_VAL_NX500_dpmhs_ch7_host_buf3_base                               0x00000000U

#define MSK_NX500_dpmhs_ch7_host_buf3_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch7_host_buf3_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch7_host_buf3_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch7_host_buf3_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH7_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch7_host_buf3_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH7_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH7_HOST_BUF3_BASE_BIT_T bf;
} NX500_DPMHS_CH7_HOST_BUF3_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch7_host_buf2_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch7_host_buf2_base                                0x000000F8U
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch7_host_buf2_base 0x001030F8U
#define Adr_NX500_dpmhs_ch7_host_buf2_base                                    0x001030F8U
#define DFLT_VAL_NX500_dpmhs_ch7_host_buf2_base                               0x00000000U

#define MSK_NX500_dpmhs_ch7_host_buf2_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch7_host_buf2_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch7_host_buf2_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch7_host_buf2_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH7_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch7_host_buf2_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH7_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH7_HOST_BUF2_BASE_BIT_T bf;
} NX500_DPMHS_CH7_HOST_BUF2_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch7_host_buf1_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_ch7_host_buf1_base                                0x000000FCU
#define Adr_NX500_host_controlled_dma_register_block_dpmhs_ch7_host_buf1_base 0x001030FCU
#define Adr_NX500_dpmhs_ch7_host_buf1_base                                    0x001030FCU
#define DFLT_VAL_NX500_dpmhs_ch7_host_buf1_base                               0x00000000U

#define MSK_NX500_dpmhs_ch7_host_buf1_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_ch7_host_buf1_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_ch7_host_buf1_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_ch7_host_buf1_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_CH7_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_ch7_host_buf1_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_CH7_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMHS_CH7_HOST_BUF1_BASE_BIT_T bf;
} NX500_DPMHS_CH7_HOST_BUF1_BASE_T;


/* ===================================================================== */

/* Area of host_controlled_global_register_block */

/* ===================================================================== */

#define Addr_NX500_host_controlled_global_register_block 0x00103100U
#define NX500_NETX_DPM_HOST_GLOB_AREA                    0x00103100U

/* --------------------------------------------------------------------- */
/* Register pci_base */
/* => dpmhs_pci_targ2_mem_base */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pci_base                                   0x000000BCU
#define Adr_NX500_host_controlled_global_register_block_pci_base 0x001031BCU
#define Adr_NX500_pci_base                                       0x001031BCU
#define DFLT_VAL_NX500_pci_base                                  0x00000000U

#define MSK_NX500_pci_base_keine_ahnung      0xffffffffU
#define SRT_NX500_pci_base_keine_ahnung      0
#define DFLT_VAL_NX500_pci_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_pci_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_PCI_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_pci_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_PCI_BASE_BIT_T;

typedef union {
	unsigned int         val;
	NX500_PCI_BASE_BIT_T bf;
} NX500_PCI_BASE_T;

/* --------------------------------------------------------------------- */
/* Register wdg_host */
/* => dpmhs_wdg_host_timeout */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_wdg_host                                   0x000000C0U
#define Adr_NX500_host_controlled_global_register_block_wdg_host 0x001031C0U
#define Adr_NX500_wdg_host                                       0x001031C0U
#define DFLT_VAL_NX500_wdg_host                                  0x00000000U

#define MSK_NX500_wdg_host_keine_ahnung      0xffffffffU
#define SRT_NX500_wdg_host_keine_ahnung      0
#define DFLT_VAL_NX500_wdg_host_keine_ahnung 0x00000000U

enum {
	BFW_NX500_wdg_host_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_WDG_HOST_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_wdg_host_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_WDG_HOST_BIT_T;

typedef union {
	unsigned int         val;
	NX500_WDG_HOST_BIT_T bf;
} NX500_WDG_HOST_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_wdg_host_trig */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_wdg_host_trig                                   0x000000C4U
#define Adr_NX500_host_controlled_global_register_block_dpmhs_wdg_host_trig 0x001031C4U
#define Adr_NX500_dpmhs_wdg_host_trig                                       0x001031C4U
#define DFLT_VAL_NX500_dpmhs_wdg_host_trig                                  0x00000000U

#define MSK_NX500_dpmhs_wdg_host_trig_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_wdg_host_trig_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_wdg_host_trig_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_wdg_host_trig_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_WDG_HOST_TRIG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_wdg_host_trig_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_WDG_HOST_TRIG_BIT_T;

typedef union {
	unsigned int                    val;
	NX500_DPMHS_WDG_HOST_TRIG_BIT_T bf;
} NX500_DPMHS_WDG_HOST_TRIG_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_wdg_arm_timeout */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_wdg_arm_timeout                                   0x000000C8U
#define Adr_NX500_host_controlled_global_register_block_dpmhs_wdg_arm_timeout 0x001031C8U
#define Adr_NX500_dpmhs_wdg_arm_timeout                                       0x001031C8U
#define DFLT_VAL_NX500_dpmhs_wdg_arm_timeout                                  0x00000000U

#define MSK_NX500_dpmhs_wdg_arm_timeout_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_wdg_arm_timeout_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_wdg_arm_timeout_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_wdg_arm_timeout_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_WDG_ARM_TIMEOUT_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_wdg_arm_timeout_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_WDG_ARM_TIMEOUT_BIT_T;

typedef union {
	unsigned int                      val;
	NX500_DPMHS_WDG_ARM_TIMEOUT_BIT_T bf;
} NX500_DPMHS_WDG_ARM_TIMEOUT_T;

/* --------------------------------------------------------------------- */
/* Register cyclic_tmr_control */
/* => dpmhs_tmr_ctrl */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_cyclic_tmr_control                                   0x000000D0U
#define Adr_NX500_host_controlled_global_register_block_cyclic_tmr_control 0x001031D0U
#define Adr_NX500_cyclic_tmr_control                                       0x001031D0U
#define DFLT_VAL_NX500_cyclic_tmr_control                                  0x00000000U

#define MSK_NX500_cyclic_tmr_control_keine_ahnung      0xffffffffU
#define SRT_NX500_cyclic_tmr_control_keine_ahnung      0
#define DFLT_VAL_NX500_cyclic_tmr_control_keine_ahnung 0x00000000U

enum {
	BFW_NX500_cyclic_tmr_control_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_CYCLIC_TMR_CONTROL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_cyclic_tmr_control_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_CYCLIC_TMR_CONTROL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_CYCLIC_TMR_CONTROL_BIT_T bf;
} NX500_CYCLIC_TMR_CONTROL_T;

/* --------------------------------------------------------------------- */
/* Register cyclic_tmr_reload */
/* => dpmhs_tmr_start_value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_cyclic_tmr_reload                                   0x000000D4U
#define Adr_NX500_host_controlled_global_register_block_cyclic_tmr_reload 0x001031D4U
#define Adr_NX500_cyclic_tmr_reload                                       0x001031D4U
#define DFLT_VAL_NX500_cyclic_tmr_reload                                  0x00000000U

#define MSK_NX500_cyclic_tmr_reload_keine_ahnung      0xffffffffU
#define SRT_NX500_cyclic_tmr_reload_keine_ahnung      0
#define DFLT_VAL_NX500_cyclic_tmr_reload_keine_ahnung 0x00000000U

enum {
	BFW_NX500_cyclic_tmr_reload_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_CYCLIC_TMR_RELOAD_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_cyclic_tmr_reload_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_CYCLIC_TMR_RELOAD_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_CYCLIC_TMR_RELOAD_BIT_T bf;
} NX500_CYCLIC_TMR_RELOAD_T;

/* --------------------------------------------------------------------- */
/* Register sta_host */
/* => dpmhs_sys_sta */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_sta_host                                   0x000000D8U
#define Adr_NX500_host_controlled_global_register_block_sta_host 0x001031D8U
#define Adr_NX500_sta_host                                       0x001031D8U
#define DFLT_VAL_NX500_sta_host                                  0x00000000U

#define MSK_NX500_sta_host_keine_ahnung      0xffffffffU
#define SRT_NX500_sta_host_keine_ahnung      0
#define DFLT_VAL_NX500_sta_host_keine_ahnung 0x00000000U

enum {
	BFW_NX500_sta_host_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_STA_HOST_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_sta_host_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_STA_HOST_BIT_T;

typedef union {
	unsigned int         val;
	NX500_STA_HOST_BIT_T bf;
} NX500_STA_HOST_T;

/* --------------------------------------------------------------------- */
/* Register res_reg */
/* => dpmhs_res_req */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_res_reg                                   0x000000DCU
#define Adr_NX500_host_controlled_global_register_block_res_reg 0x001031DCU
#define Adr_NX500_res_reg                                       0x001031DCU
#define DFLT_VAL_NX500_res_reg                                  0x00000000U

#define MSK_NX500_res_reg_keine_ahnung      0xffffffffU
#define SRT_NX500_res_reg_keine_ahnung      0
#define DFLT_VAL_NX500_res_reg_keine_ahnung 0x00000000U

enum {
	BFW_NX500_res_reg_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_RES_REG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_res_reg_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_RES_REG_BIT_T;

typedef union {
	unsigned int        val;
	NX500_RES_REG_BIT_T bf;
} NX500_RES_REG_T;

/* --------------------------------------------------------------------- */
/* Register irq_status_0_host */
/* => dpmhs_int_sta0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_irq_status_0_host                                   0x000000E0U
#define Adr_NX500_host_controlled_global_register_block_irq_status_0_host 0x001031E0U
#define Adr_NX500_irq_status_0_host                                       0x001031E0U
#define DFLT_VAL_NX500_irq_status_0_host                                  0x00000000U

#define MSK_NX500_irq_status_0_host_keine_ahnung      0xffffffffU
#define SRT_NX500_irq_status_0_host_keine_ahnung      0
#define DFLT_VAL_NX500_irq_status_0_host_keine_ahnung 0x00000000U

enum {
	BFW_NX500_irq_status_0_host_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IRQ_STATUS_0_HOST_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_irq_status_0_host_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IRQ_STATUS_0_HOST_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_IRQ_STATUS_0_HOST_BIT_T bf;
} NX500_IRQ_STATUS_0_HOST_T;

/* --------------------------------------------------------------------- */
/* Register irq_status_1_host */
/* => dpmhs_int_sta1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_irq_status_1_host                                   0x000000E4U
#define Adr_NX500_host_controlled_global_register_block_irq_status_1_host 0x001031E4U
#define Adr_NX500_irq_status_1_host                                       0x001031E4U
#define DFLT_VAL_NX500_irq_status_1_host                                  0x00000000U

#define MSK_NX500_irq_status_1_host_keine_ahnung      0xffffffffU
#define SRT_NX500_irq_status_1_host_keine_ahnung      0
#define DFLT_VAL_NX500_irq_status_1_host_keine_ahnung 0x00000000U

enum {
	BFW_NX500_irq_status_1_host_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IRQ_STATUS_1_HOST_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_irq_status_1_host_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IRQ_STATUS_1_HOST_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_IRQ_STATUS_1_HOST_BIT_T bf;
} NX500_IRQ_STATUS_1_HOST_T;

/* --------------------------------------------------------------------- */
/* Register irq_status_2_host */
/* => dpmhs_int_sta2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_irq_status_2_host                                   0x000000E8U
#define Adr_NX500_host_controlled_global_register_block_irq_status_2_host 0x001031E8U
#define Adr_NX500_irq_status_2_host                                       0x001031E8U
#define DFLT_VAL_NX500_irq_status_2_host                                  0x00000000U

#define MSK_NX500_irq_status_2_host_keine_ahnung      0xffffffffU
#define SRT_NX500_irq_status_2_host_keine_ahnung      0
#define DFLT_VAL_NX500_irq_status_2_host_keine_ahnung 0x00000000U

enum {
	BFW_NX500_irq_status_2_host_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IRQ_STATUS_2_HOST_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_irq_status_2_host_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IRQ_STATUS_2_HOST_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_IRQ_STATUS_2_HOST_BIT_T bf;
} NX500_IRQ_STATUS_2_HOST_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_int_sta3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_int_sta3                                   0x000000ECU
#define Adr_NX500_host_controlled_global_register_block_dpmhs_int_sta3 0x001031ECU
#define Adr_NX500_dpmhs_int_sta3                                       0x001031ECU
#define DFLT_VAL_NX500_dpmhs_int_sta3                                  0x00000000U

#define MSK_NX500_dpmhs_int_sta3_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_int_sta3_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_int_sta3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_int_sta3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_INT_STA3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_int_sta3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_INT_STA3_BIT_T;

typedef union {
	unsigned int               val;
	NX500_DPMHS_INT_STA3_BIT_T bf;
} NX500_DPMHS_INT_STA3_T;

/* --------------------------------------------------------------------- */
/* Register irq_mask_0_host */
/* => dpmhs_int_en0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_irq_mask_0_host                                   0x000000F0U
#define Adr_NX500_host_controlled_global_register_block_irq_mask_0_host 0x001031F0U
#define Adr_NX500_irq_mask_0_host                                       0x001031F0U
#define DFLT_VAL_NX500_irq_mask_0_host                                  0x00000000U

#define MSK_NX500_irq_mask_0_host_keine_ahnung      0xffffffffU
#define SRT_NX500_irq_mask_0_host_keine_ahnung      0
#define DFLT_VAL_NX500_irq_mask_0_host_keine_ahnung 0x00000000U

enum {
	BFW_NX500_irq_mask_0_host_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IRQ_MASK_0_HOST_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_irq_mask_0_host_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IRQ_MASK_0_HOST_BIT_T;

typedef union {
	unsigned int                val;
	NX500_IRQ_MASK_0_HOST_BIT_T bf;
} NX500_IRQ_MASK_0_HOST_T;

/* --------------------------------------------------------------------- */
/* Register irq_mask_1_host */
/* => dpmhs_int_en1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_irq_mask_1_host                                   0x000000F4U
#define Adr_NX500_host_controlled_global_register_block_irq_mask_1_host 0x001031F4U
#define Adr_NX500_irq_mask_1_host                                       0x001031F4U
#define DFLT_VAL_NX500_irq_mask_1_host                                  0x00000000U

#define MSK_NX500_irq_mask_1_host_keine_ahnung      0xffffffffU
#define SRT_NX500_irq_mask_1_host_keine_ahnung      0
#define DFLT_VAL_NX500_irq_mask_1_host_keine_ahnung 0x00000000U

enum {
	BFW_NX500_irq_mask_1_host_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IRQ_MASK_1_HOST_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_irq_mask_1_host_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IRQ_MASK_1_HOST_BIT_T;

typedef union {
	unsigned int                val;
	NX500_IRQ_MASK_1_HOST_BIT_T bf;
} NX500_IRQ_MASK_1_HOST_T;

/* --------------------------------------------------------------------- */
/* Register irq_mask_2_host */
/* => dpmhs_int_en2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_irq_mask_2_host                                   0x000000F8U
#define Adr_NX500_host_controlled_global_register_block_irq_mask_2_host 0x001031F8U
#define Adr_NX500_irq_mask_2_host                                       0x001031F8U
#define DFLT_VAL_NX500_irq_mask_2_host                                  0x00000000U

#define MSK_NX500_irq_mask_2_host_keine_ahnung      0xffffffffU
#define SRT_NX500_irq_mask_2_host_keine_ahnung      0
#define DFLT_VAL_NX500_irq_mask_2_host_keine_ahnung 0x00000000U

enum {
	BFW_NX500_irq_mask_2_host_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IRQ_MASK_2_HOST_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_irq_mask_2_host_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IRQ_MASK_2_HOST_BIT_T;

typedef union {
	unsigned int                val;
	NX500_IRQ_MASK_2_HOST_BIT_T bf;
} NX500_IRQ_MASK_2_HOST_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_int_en3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_int_en3                                   0x000000FCU
#define Adr_NX500_host_controlled_global_register_block_dpmhs_int_en3 0x001031FCU
#define Adr_NX500_dpmhs_int_en3                                       0x001031FCU
#define DFLT_VAL_NX500_dpmhs_int_en3                                  0x00000000U

#define MSK_NX500_dpmhs_int_en3_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_int_en3_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_int_en3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_int_en3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_INT_EN3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_int_en3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_INT_EN3_BIT_T;

typedef union {
	unsigned int              val;
	NX500_DPMHS_INT_EN3_BIT_T bf;
} NX500_DPMHS_INT_EN3_T;


/* ===================================================================== */

/* Area of host_controlled_handshake_register_block */

/* ===================================================================== */

#define Addr_NX500_host_controlled_handshake_register_block 0x00103200U
#define NX500_NETX_DPM_HOST_HS_AREA                         0x00103200U

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data0 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_hs_data0                                      0x00000000U
#define Adr_NX500_host_controlled_handshake_register_block_dpmhs_hs_data0 0x00103200U
#define Adr_NX500_dpmhs_hs_data0                                          0x00103200U
#define DFLT_VAL_NX500_dpmhs_hs_data0                                     0x00000000U

#define MSK_NX500_dpmhs_hs_data0_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_hs_data0_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_hs_data0_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_hs_data0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_HS_DATA0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_hs_data0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_HS_DATA0_BIT_T;

typedef union {
	unsigned int               val;
	NX500_DPMHS_HS_DATA0_BIT_T bf;
} NX500_DPMHS_HS_DATA0_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_hs_data1                                      0x00000004U
#define Adr_NX500_host_controlled_handshake_register_block_dpmhs_hs_data1 0x00103204U
#define Adr_NX500_dpmhs_hs_data1                                          0x00103204U
#define DFLT_VAL_NX500_dpmhs_hs_data1                                     0x00000000U

#define MSK_NX500_dpmhs_hs_data1_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_hs_data1_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_hs_data1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_hs_data1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_HS_DATA1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_hs_data1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_HS_DATA1_BIT_T;

typedef union {
	unsigned int               val;
	NX500_DPMHS_HS_DATA1_BIT_T bf;
} NX500_DPMHS_HS_DATA1_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_hs_data2                                      0x00000008U
#define Adr_NX500_host_controlled_handshake_register_block_dpmhs_hs_data2 0x00103208U
#define Adr_NX500_dpmhs_hs_data2                                          0x00103208U
#define DFLT_VAL_NX500_dpmhs_hs_data2                                     0x00000000U

#define MSK_NX500_dpmhs_hs_data2_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_hs_data2_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_hs_data2_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_hs_data2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_HS_DATA2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_hs_data2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_HS_DATA2_BIT_T;

typedef union {
	unsigned int               val;
	NX500_DPMHS_HS_DATA2_BIT_T bf;
} NX500_DPMHS_HS_DATA2_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_hs_data3                                      0x0000000CU
#define Adr_NX500_host_controlled_handshake_register_block_dpmhs_hs_data3 0x0010320CU
#define Adr_NX500_dpmhs_hs_data3                                          0x0010320CU
#define DFLT_VAL_NX500_dpmhs_hs_data3                                     0x00000000U

#define MSK_NX500_dpmhs_hs_data3_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_hs_data3_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_hs_data3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_hs_data3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_HS_DATA3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_hs_data3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_HS_DATA3_BIT_T;

typedef union {
	unsigned int               val;
	NX500_DPMHS_HS_DATA3_BIT_T bf;
} NX500_DPMHS_HS_DATA3_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data4 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_hs_data4                                      0x00000010U
#define Adr_NX500_host_controlled_handshake_register_block_dpmhs_hs_data4 0x00103210U
#define Adr_NX500_dpmhs_hs_data4                                          0x00103210U
#define DFLT_VAL_NX500_dpmhs_hs_data4                                     0x00000000U

#define MSK_NX500_dpmhs_hs_data4_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_hs_data4_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_hs_data4_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_hs_data4_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_HS_DATA4_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_hs_data4_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_HS_DATA4_BIT_T;

typedef union {
	unsigned int               val;
	NX500_DPMHS_HS_DATA4_BIT_T bf;
} NX500_DPMHS_HS_DATA4_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data5 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_hs_data5                                      0x00000014U
#define Adr_NX500_host_controlled_handshake_register_block_dpmhs_hs_data5 0x00103214U
#define Adr_NX500_dpmhs_hs_data5                                          0x00103214U
#define DFLT_VAL_NX500_dpmhs_hs_data5                                     0x00000000U

#define MSK_NX500_dpmhs_hs_data5_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_hs_data5_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_hs_data5_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_hs_data5_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_HS_DATA5_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_hs_data5_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_HS_DATA5_BIT_T;

typedef union {
	unsigned int               val;
	NX500_DPMHS_HS_DATA5_BIT_T bf;
} NX500_DPMHS_HS_DATA5_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data6 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_hs_data6                                      0x00000018U
#define Adr_NX500_host_controlled_handshake_register_block_dpmhs_hs_data6 0x00103218U
#define Adr_NX500_dpmhs_hs_data6                                          0x00103218U
#define DFLT_VAL_NX500_dpmhs_hs_data6                                     0x00000000U

#define MSK_NX500_dpmhs_hs_data6_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_hs_data6_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_hs_data6_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_hs_data6_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_HS_DATA6_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_hs_data6_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_HS_DATA6_BIT_T;

typedef union {
	unsigned int               val;
	NX500_DPMHS_HS_DATA6_BIT_T bf;
} NX500_DPMHS_HS_DATA6_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data7 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_hs_data7                                      0x0000001CU
#define Adr_NX500_host_controlled_handshake_register_block_dpmhs_hs_data7 0x0010321CU
#define Adr_NX500_dpmhs_hs_data7                                          0x0010321CU
#define DFLT_VAL_NX500_dpmhs_hs_data7                                     0x00000000U

#define MSK_NX500_dpmhs_hs_data7_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_hs_data7_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_hs_data7_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_hs_data7_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_HS_DATA7_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_hs_data7_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_HS_DATA7_BIT_T;

typedef union {
	unsigned int               val;
	NX500_DPMHS_HS_DATA7_BIT_T bf;
} NX500_DPMHS_HS_DATA7_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data8 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_hs_data8                                      0x00000020U
#define Adr_NX500_host_controlled_handshake_register_block_dpmhs_hs_data8 0x00103220U
#define Adr_NX500_dpmhs_hs_data8                                          0x00103220U
#define DFLT_VAL_NX500_dpmhs_hs_data8                                     0x00000000U

#define MSK_NX500_dpmhs_hs_data8_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_hs_data8_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_hs_data8_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_hs_data8_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_HS_DATA8_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_hs_data8_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_HS_DATA8_BIT_T;

typedef union {
	unsigned int               val;
	NX500_DPMHS_HS_DATA8_BIT_T bf;
} NX500_DPMHS_HS_DATA8_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data9 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_hs_data9                                      0x00000024U
#define Adr_NX500_host_controlled_handshake_register_block_dpmhs_hs_data9 0x00103224U
#define Adr_NX500_dpmhs_hs_data9                                          0x00103224U
#define DFLT_VAL_NX500_dpmhs_hs_data9                                     0x00000000U

#define MSK_NX500_dpmhs_hs_data9_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_hs_data9_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_hs_data9_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_hs_data9_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_HS_DATA9_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_hs_data9_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_HS_DATA9_BIT_T;

typedef union {
	unsigned int               val;
	NX500_DPMHS_HS_DATA9_BIT_T bf;
} NX500_DPMHS_HS_DATA9_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data10 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_hs_data10                                      0x00000028U
#define Adr_NX500_host_controlled_handshake_register_block_dpmhs_hs_data10 0x00103228U
#define Adr_NX500_dpmhs_hs_data10                                          0x00103228U
#define DFLT_VAL_NX500_dpmhs_hs_data10                                     0x00000000U

#define MSK_NX500_dpmhs_hs_data10_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_hs_data10_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_hs_data10_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_hs_data10_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_HS_DATA10_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_hs_data10_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_HS_DATA10_BIT_T;

typedef union {
	unsigned int                val;
	NX500_DPMHS_HS_DATA10_BIT_T bf;
} NX500_DPMHS_HS_DATA10_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data11 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_hs_data11                                      0x0000002CU
#define Adr_NX500_host_controlled_handshake_register_block_dpmhs_hs_data11 0x0010322CU
#define Adr_NX500_dpmhs_hs_data11                                          0x0010322CU
#define DFLT_VAL_NX500_dpmhs_hs_data11                                     0x00000000U

#define MSK_NX500_dpmhs_hs_data11_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_hs_data11_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_hs_data11_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_hs_data11_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_HS_DATA11_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_hs_data11_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_HS_DATA11_BIT_T;

typedef union {
	unsigned int                val;
	NX500_DPMHS_HS_DATA11_BIT_T bf;
} NX500_DPMHS_HS_DATA11_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data12 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_hs_data12                                      0x00000030U
#define Adr_NX500_host_controlled_handshake_register_block_dpmhs_hs_data12 0x00103230U
#define Adr_NX500_dpmhs_hs_data12                                          0x00103230U
#define DFLT_VAL_NX500_dpmhs_hs_data12                                     0x00000000U

#define MSK_NX500_dpmhs_hs_data12_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_hs_data12_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_hs_data12_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_hs_data12_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_HS_DATA12_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_hs_data12_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_HS_DATA12_BIT_T;

typedef union {
	unsigned int                val;
	NX500_DPMHS_HS_DATA12_BIT_T bf;
} NX500_DPMHS_HS_DATA12_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data13 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_hs_data13                                      0x00000034U
#define Adr_NX500_host_controlled_handshake_register_block_dpmhs_hs_data13 0x00103234U
#define Adr_NX500_dpmhs_hs_data13                                          0x00103234U
#define DFLT_VAL_NX500_dpmhs_hs_data13                                     0x00000000U

#define MSK_NX500_dpmhs_hs_data13_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_hs_data13_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_hs_data13_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_hs_data13_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_HS_DATA13_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_hs_data13_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_HS_DATA13_BIT_T;

typedef union {
	unsigned int                val;
	NX500_DPMHS_HS_DATA13_BIT_T bf;
} NX500_DPMHS_HS_DATA13_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data14 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_hs_data14                                      0x00000038U
#define Adr_NX500_host_controlled_handshake_register_block_dpmhs_hs_data14 0x00103238U
#define Adr_NX500_dpmhs_hs_data14                                          0x00103238U
#define DFLT_VAL_NX500_dpmhs_hs_data14                                     0x00000000U

#define MSK_NX500_dpmhs_hs_data14_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_hs_data14_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_hs_data14_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_hs_data14_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_HS_DATA14_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_hs_data14_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_HS_DATA14_BIT_T;

typedef union {
	unsigned int                val;
	NX500_DPMHS_HS_DATA14_BIT_T bf;
} NX500_DPMHS_HS_DATA14_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data15 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmhs_hs_data15                                      0x0000003CU
#define Adr_NX500_host_controlled_handshake_register_block_dpmhs_hs_data15 0x0010323CU
#define Adr_NX500_dpmhs_hs_data15                                          0x0010323CU
#define DFLT_VAL_NX500_dpmhs_hs_data15                                     0x00000000U

#define MSK_NX500_dpmhs_hs_data15_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmhs_hs_data15_keine_ahnung      0
#define DFLT_VAL_NX500_dpmhs_hs_data15_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmhs_hs_data15_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMHS_HS_DATA15_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmhs_hs_data15_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMHS_HS_DATA15_BIT_T;

typedef union {
	unsigned int                val;
	NX500_DPMHS_HS_DATA15_BIT_T bf;
} NX500_DPMHS_HS_DATA15_T;


/* ===================================================================== */

/* Area of netx_controlled_dma_register_block */

/* ===================================================================== */

#define Addr_NX500_netx_controlled_dma_register_block 0x00103300U
#define NX500_NETX_DPM_ARM_DMA_AREA                   0x00103300U

/* --------------------------------------------------------------------- */
/* Register dpmas_ch0_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch0_host_start                                0x00000000U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch0_host_start 0x00103300U
#define Adr_NX500_dpmas_ch0_host_start                                    0x00103300U
#define DFLT_VAL_NX500_dpmas_ch0_host_start                               0x00000000U

#define MSK_NX500_dpmas_ch0_host_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch0_host_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch0_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch0_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH0_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch0_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH0_HOST_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMAS_CH0_HOST_START_BIT_T bf;
} NX500_DPMAS_CH0_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch0_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch0_netx_start                                0x00000004U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch0_netx_start 0x00103304U
#define Adr_NX500_dpmas_ch0_netx_start                                    0x00103304U
#define DFLT_VAL_NX500_dpmas_ch0_netx_start                               0x00000000U

#define MSK_NX500_dpmas_ch0_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch0_netx_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch0_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch0_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH0_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch0_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH0_NETX_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMAS_CH0_NETX_START_BIT_T bf;
} NX500_DPMAS_CH0_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch0_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch0_dma_ctrl                                0x00000008U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch0_dma_ctrl 0x00103308U
#define Adr_NX500_dpmas_ch0_dma_ctrl                                    0x00103308U
#define DFLT_VAL_NX500_dpmas_ch0_dma_ctrl                               0x00000000U

#define MSK_NX500_dpmas_ch0_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch0_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch0_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch0_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH0_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch0_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH0_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH0_DMA_CTRL_BIT_T bf;
} NX500_DPMAS_CH0_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch0_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch0_mbx_base                                0x0000000CU
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch0_mbx_base 0x0010330CU
#define Adr_NX500_dpmas_ch0_mbx_base                                    0x0010330CU
#define DFLT_VAL_NX500_dpmas_ch0_mbx_base                               0x00000000U

#define MSK_NX500_dpmas_ch0_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch0_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch0_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch0_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH0_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch0_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH0_MBX_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH0_MBX_BASE_BIT_T bf;
} NX500_DPMAS_CH0_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch0_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch0_buf_ctrl                                0x00000010U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch0_buf_ctrl 0x00103310U
#define Adr_NX500_dpmas_ch0_buf_ctrl                                    0x00103310U
#define DFLT_VAL_NX500_dpmas_ch0_buf_ctrl                               0x00000000U

#define MSK_NX500_dpmas_ch0_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch0_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch0_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch0_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH0_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch0_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH0_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH0_BUF_CTRL_BIT_T bf;
} NX500_DPMAS_CH0_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch0_netx_buf_base3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch0_netx_buf_base3                                0x00000014U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch0_netx_buf_base3 0x00103314U
#define Adr_NX500_dpmas_ch0_netx_buf_base3                                    0x00103314U
#define DFLT_VAL_NX500_dpmas_ch0_netx_buf_base3                               0x00000000U

#define MSK_NX500_dpmas_ch0_netx_buf_base3_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch0_netx_buf_base3_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch0_netx_buf_base3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch0_netx_buf_base3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH0_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch0_netx_buf_base3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH0_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH0_NETX_BUF_BASE3_BIT_T bf;
} NX500_DPMAS_CH0_NETX_BUF_BASE3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch0_netx_buf_base2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch0_netx_buf_base2                                0x00000018U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch0_netx_buf_base2 0x00103318U
#define Adr_NX500_dpmas_ch0_netx_buf_base2                                    0x00103318U
#define DFLT_VAL_NX500_dpmas_ch0_netx_buf_base2                               0x00000000U

#define MSK_NX500_dpmas_ch0_netx_buf_base2_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch0_netx_buf_base2_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch0_netx_buf_base2_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch0_netx_buf_base2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH0_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch0_netx_buf_base2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH0_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH0_NETX_BUF_BASE2_BIT_T bf;
} NX500_DPMAS_CH0_NETX_BUF_BASE2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch0_netx_buf_base1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch0_netx_buf_base1                                0x0000001CU
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch0_netx_buf_base1 0x0010331CU
#define Adr_NX500_dpmas_ch0_netx_buf_base1                                    0x0010331CU
#define DFLT_VAL_NX500_dpmas_ch0_netx_buf_base1                               0x00000000U

#define MSK_NX500_dpmas_ch0_netx_buf_base1_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch0_netx_buf_base1_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch0_netx_buf_base1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch0_netx_buf_base1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH0_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch0_netx_buf_base1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH0_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH0_NETX_BUF_BASE1_BIT_T bf;
} NX500_DPMAS_CH0_NETX_BUF_BASE1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch1_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch1_host_start                                0x00000020U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch1_host_start 0x00103320U
#define Adr_NX500_dpmas_ch1_host_start                                    0x00103320U
#define DFLT_VAL_NX500_dpmas_ch1_host_start                               0x00000000U

#define MSK_NX500_dpmas_ch1_host_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch1_host_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch1_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch1_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH1_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch1_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH1_HOST_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMAS_CH1_HOST_START_BIT_T bf;
} NX500_DPMAS_CH1_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch1_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch1_netx_start                                0x00000024U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch1_netx_start 0x00103324U
#define Adr_NX500_dpmas_ch1_netx_start                                    0x00103324U
#define DFLT_VAL_NX500_dpmas_ch1_netx_start                               0x00000000U

#define MSK_NX500_dpmas_ch1_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch1_netx_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch1_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch1_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH1_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch1_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH1_NETX_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMAS_CH1_NETX_START_BIT_T bf;
} NX500_DPMAS_CH1_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch1_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch1_dma_ctrl                                0x00000028U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch1_dma_ctrl 0x00103328U
#define Adr_NX500_dpmas_ch1_dma_ctrl                                    0x00103328U
#define DFLT_VAL_NX500_dpmas_ch1_dma_ctrl                               0x00000000U

#define MSK_NX500_dpmas_ch1_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch1_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch1_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch1_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH1_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch1_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH1_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH1_DMA_CTRL_BIT_T bf;
} NX500_DPMAS_CH1_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch1_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch1_mbx_base                                0x0000002CU
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch1_mbx_base 0x0010332CU
#define Adr_NX500_dpmas_ch1_mbx_base                                    0x0010332CU
#define DFLT_VAL_NX500_dpmas_ch1_mbx_base                               0x00000000U

#define MSK_NX500_dpmas_ch1_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch1_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch1_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch1_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH1_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch1_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH1_MBX_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH1_MBX_BASE_BIT_T bf;
} NX500_DPMAS_CH1_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch1_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch1_buf_ctrl                                0x00000030U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch1_buf_ctrl 0x00103330U
#define Adr_NX500_dpmas_ch1_buf_ctrl                                    0x00103330U
#define DFLT_VAL_NX500_dpmas_ch1_buf_ctrl                               0x00000000U

#define MSK_NX500_dpmas_ch1_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch1_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch1_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch1_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH1_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch1_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH1_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH1_BUF_CTRL_BIT_T bf;
} NX500_DPMAS_CH1_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch1_netx_buf_base3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch1_netx_buf_base3                                0x00000034U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch1_netx_buf_base3 0x00103334U
#define Adr_NX500_dpmas_ch1_netx_buf_base3                                    0x00103334U
#define DFLT_VAL_NX500_dpmas_ch1_netx_buf_base3                               0x00000000U

#define MSK_NX500_dpmas_ch1_netx_buf_base3_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch1_netx_buf_base3_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch1_netx_buf_base3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch1_netx_buf_base3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH1_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch1_netx_buf_base3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH1_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH1_NETX_BUF_BASE3_BIT_T bf;
} NX500_DPMAS_CH1_NETX_BUF_BASE3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch1_netx_buf_base2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch1_netx_buf_base2                                0x00000038U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch1_netx_buf_base2 0x00103338U
#define Adr_NX500_dpmas_ch1_netx_buf_base2                                    0x00103338U
#define DFLT_VAL_NX500_dpmas_ch1_netx_buf_base2                               0x00000000U

#define MSK_NX500_dpmas_ch1_netx_buf_base2_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch1_netx_buf_base2_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch1_netx_buf_base2_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch1_netx_buf_base2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH1_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch1_netx_buf_base2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH1_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH1_NETX_BUF_BASE2_BIT_T bf;
} NX500_DPMAS_CH1_NETX_BUF_BASE2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch1_netx_buf_base1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch1_netx_buf_base1                                0x0000003CU
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch1_netx_buf_base1 0x0010333CU
#define Adr_NX500_dpmas_ch1_netx_buf_base1                                    0x0010333CU
#define DFLT_VAL_NX500_dpmas_ch1_netx_buf_base1                               0x00000000U

#define MSK_NX500_dpmas_ch1_netx_buf_base1_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch1_netx_buf_base1_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch1_netx_buf_base1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch1_netx_buf_base1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH1_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch1_netx_buf_base1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH1_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH1_NETX_BUF_BASE1_BIT_T bf;
} NX500_DPMAS_CH1_NETX_BUF_BASE1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch2_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch2_host_start                                0x00000040U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch2_host_start 0x00103340U
#define Adr_NX500_dpmas_ch2_host_start                                    0x00103340U
#define DFLT_VAL_NX500_dpmas_ch2_host_start                               0x00000000U

#define MSK_NX500_dpmas_ch2_host_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch2_host_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch2_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch2_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH2_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch2_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH2_HOST_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMAS_CH2_HOST_START_BIT_T bf;
} NX500_DPMAS_CH2_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch2_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch2_netx_start                                0x00000044U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch2_netx_start 0x00103344U
#define Adr_NX500_dpmas_ch2_netx_start                                    0x00103344U
#define DFLT_VAL_NX500_dpmas_ch2_netx_start                               0x00000000U

#define MSK_NX500_dpmas_ch2_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch2_netx_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch2_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch2_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH2_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch2_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH2_NETX_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMAS_CH2_NETX_START_BIT_T bf;
} NX500_DPMAS_CH2_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch2_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch2_dma_ctrl                                0x00000048U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch2_dma_ctrl 0x00103348U
#define Adr_NX500_dpmas_ch2_dma_ctrl                                    0x00103348U
#define DFLT_VAL_NX500_dpmas_ch2_dma_ctrl                               0x00000000U

#define MSK_NX500_dpmas_ch2_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch2_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch2_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch2_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH2_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch2_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH2_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH2_DMA_CTRL_BIT_T bf;
} NX500_DPMAS_CH2_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch2_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch2_mbx_base                                0x0000004CU
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch2_mbx_base 0x0010334CU
#define Adr_NX500_dpmas_ch2_mbx_base                                    0x0010334CU
#define DFLT_VAL_NX500_dpmas_ch2_mbx_base                               0x00000000U

#define MSK_NX500_dpmas_ch2_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch2_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch2_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch2_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH2_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch2_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH2_MBX_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH2_MBX_BASE_BIT_T bf;
} NX500_DPMAS_CH2_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch2_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch2_buf_ctrl                                0x00000050U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch2_buf_ctrl 0x00103350U
#define Adr_NX500_dpmas_ch2_buf_ctrl                                    0x00103350U
#define DFLT_VAL_NX500_dpmas_ch2_buf_ctrl                               0x00000000U

#define MSK_NX500_dpmas_ch2_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch2_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch2_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch2_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH2_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch2_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH2_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH2_BUF_CTRL_BIT_T bf;
} NX500_DPMAS_CH2_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch2_netx_buf_base3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch2_netx_buf_base3                                0x00000054U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch2_netx_buf_base3 0x00103354U
#define Adr_NX500_dpmas_ch2_netx_buf_base3                                    0x00103354U
#define DFLT_VAL_NX500_dpmas_ch2_netx_buf_base3                               0x00000000U

#define MSK_NX500_dpmas_ch2_netx_buf_base3_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch2_netx_buf_base3_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch2_netx_buf_base3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch2_netx_buf_base3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH2_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch2_netx_buf_base3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH2_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH2_NETX_BUF_BASE3_BIT_T bf;
} NX500_DPMAS_CH2_NETX_BUF_BASE3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch2_netx_buf_base2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch2_netx_buf_base2                                0x00000058U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch2_netx_buf_base2 0x00103358U
#define Adr_NX500_dpmas_ch2_netx_buf_base2                                    0x00103358U
#define DFLT_VAL_NX500_dpmas_ch2_netx_buf_base2                               0x00000000U

#define MSK_NX500_dpmas_ch2_netx_buf_base2_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch2_netx_buf_base2_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch2_netx_buf_base2_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch2_netx_buf_base2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH2_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch2_netx_buf_base2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH2_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH2_NETX_BUF_BASE2_BIT_T bf;
} NX500_DPMAS_CH2_NETX_BUF_BASE2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch2_netx_buf_base1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch2_netx_buf_base1                                0x0000005CU
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch2_netx_buf_base1 0x0010335CU
#define Adr_NX500_dpmas_ch2_netx_buf_base1                                    0x0010335CU
#define DFLT_VAL_NX500_dpmas_ch2_netx_buf_base1                               0x00000000U

#define MSK_NX500_dpmas_ch2_netx_buf_base1_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch2_netx_buf_base1_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch2_netx_buf_base1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch2_netx_buf_base1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH2_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch2_netx_buf_base1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH2_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH2_NETX_BUF_BASE1_BIT_T bf;
} NX500_DPMAS_CH2_NETX_BUF_BASE1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch3_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch3_host_start                                0x00000060U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch3_host_start 0x00103360U
#define Adr_NX500_dpmas_ch3_host_start                                    0x00103360U
#define DFLT_VAL_NX500_dpmas_ch3_host_start                               0x00000000U

#define MSK_NX500_dpmas_ch3_host_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch3_host_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch3_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch3_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH3_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch3_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH3_HOST_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMAS_CH3_HOST_START_BIT_T bf;
} NX500_DPMAS_CH3_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch3_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch3_netx_start                                0x00000064U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch3_netx_start 0x00103364U
#define Adr_NX500_dpmas_ch3_netx_start                                    0x00103364U
#define DFLT_VAL_NX500_dpmas_ch3_netx_start                               0x00000000U

#define MSK_NX500_dpmas_ch3_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch3_netx_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch3_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch3_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH3_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch3_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH3_NETX_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMAS_CH3_NETX_START_BIT_T bf;
} NX500_DPMAS_CH3_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch3_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch3_dma_ctrl                                0x00000068U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch3_dma_ctrl 0x00103368U
#define Adr_NX500_dpmas_ch3_dma_ctrl                                    0x00103368U
#define DFLT_VAL_NX500_dpmas_ch3_dma_ctrl                               0x00000000U

#define MSK_NX500_dpmas_ch3_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch3_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch3_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch3_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH3_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch3_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH3_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH3_DMA_CTRL_BIT_T bf;
} NX500_DPMAS_CH3_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch3_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch3_mbx_base                                0x0000006CU
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch3_mbx_base 0x0010336CU
#define Adr_NX500_dpmas_ch3_mbx_base                                    0x0010336CU
#define DFLT_VAL_NX500_dpmas_ch3_mbx_base                               0x00000000U

#define MSK_NX500_dpmas_ch3_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch3_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch3_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch3_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH3_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch3_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH3_MBX_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH3_MBX_BASE_BIT_T bf;
} NX500_DPMAS_CH3_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch3_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch3_buf_ctrl                                0x00000070U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch3_buf_ctrl 0x00103370U
#define Adr_NX500_dpmas_ch3_buf_ctrl                                    0x00103370U
#define DFLT_VAL_NX500_dpmas_ch3_buf_ctrl                               0x00000000U

#define MSK_NX500_dpmas_ch3_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch3_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch3_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch3_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH3_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch3_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH3_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH3_BUF_CTRL_BIT_T bf;
} NX500_DPMAS_CH3_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch3_netx_buf_base3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch3_netx_buf_base3                                0x00000074U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch3_netx_buf_base3 0x00103374U
#define Adr_NX500_dpmas_ch3_netx_buf_base3                                    0x00103374U
#define DFLT_VAL_NX500_dpmas_ch3_netx_buf_base3                               0x00000000U

#define MSK_NX500_dpmas_ch3_netx_buf_base3_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch3_netx_buf_base3_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch3_netx_buf_base3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch3_netx_buf_base3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH3_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch3_netx_buf_base3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH3_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH3_NETX_BUF_BASE3_BIT_T bf;
} NX500_DPMAS_CH3_NETX_BUF_BASE3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch3_netx_buf_base2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch3_netx_buf_base2                                0x00000078U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch3_netx_buf_base2 0x00103378U
#define Adr_NX500_dpmas_ch3_netx_buf_base2                                    0x00103378U
#define DFLT_VAL_NX500_dpmas_ch3_netx_buf_base2                               0x00000000U

#define MSK_NX500_dpmas_ch3_netx_buf_base2_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch3_netx_buf_base2_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch3_netx_buf_base2_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch3_netx_buf_base2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH3_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch3_netx_buf_base2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH3_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH3_NETX_BUF_BASE2_BIT_T bf;
} NX500_DPMAS_CH3_NETX_BUF_BASE2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch3_netx_buf_base1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch3_netx_buf_base1                                0x0000007CU
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch3_netx_buf_base1 0x0010337CU
#define Adr_NX500_dpmas_ch3_netx_buf_base1                                    0x0010337CU
#define DFLT_VAL_NX500_dpmas_ch3_netx_buf_base1                               0x00000000U

#define MSK_NX500_dpmas_ch3_netx_buf_base1_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch3_netx_buf_base1_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch3_netx_buf_base1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch3_netx_buf_base1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH3_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch3_netx_buf_base1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH3_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH3_NETX_BUF_BASE1_BIT_T bf;
} NX500_DPMAS_CH3_NETX_BUF_BASE1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch4_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch4_host_start                                0x00000080U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch4_host_start 0x00103380U
#define Adr_NX500_dpmas_ch4_host_start                                    0x00103380U
#define DFLT_VAL_NX500_dpmas_ch4_host_start                               0x00000000U

#define MSK_NX500_dpmas_ch4_host_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch4_host_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch4_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch4_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH4_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch4_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH4_HOST_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMAS_CH4_HOST_START_BIT_T bf;
} NX500_DPMAS_CH4_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch4_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch4_netx_start                                0x00000084U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch4_netx_start 0x00103384U
#define Adr_NX500_dpmas_ch4_netx_start                                    0x00103384U
#define DFLT_VAL_NX500_dpmas_ch4_netx_start                               0x00000000U

#define MSK_NX500_dpmas_ch4_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch4_netx_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch4_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch4_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH4_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch4_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH4_NETX_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMAS_CH4_NETX_START_BIT_T bf;
} NX500_DPMAS_CH4_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch4_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch4_dma_ctrl                                0x00000088U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch4_dma_ctrl 0x00103388U
#define Adr_NX500_dpmas_ch4_dma_ctrl                                    0x00103388U
#define DFLT_VAL_NX500_dpmas_ch4_dma_ctrl                               0x00000000U

#define MSK_NX500_dpmas_ch4_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch4_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch4_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch4_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH4_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch4_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH4_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH4_DMA_CTRL_BIT_T bf;
} NX500_DPMAS_CH4_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch4_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch4_mbx_base                                0x0000008CU
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch4_mbx_base 0x0010338CU
#define Adr_NX500_dpmas_ch4_mbx_base                                    0x0010338CU
#define DFLT_VAL_NX500_dpmas_ch4_mbx_base                               0x00000000U

#define MSK_NX500_dpmas_ch4_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch4_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch4_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch4_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH4_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch4_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH4_MBX_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH4_MBX_BASE_BIT_T bf;
} NX500_DPMAS_CH4_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch4_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch4_buf_ctrl                                0x00000090U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch4_buf_ctrl 0x00103390U
#define Adr_NX500_dpmas_ch4_buf_ctrl                                    0x00103390U
#define DFLT_VAL_NX500_dpmas_ch4_buf_ctrl                               0x00000000U

#define MSK_NX500_dpmas_ch4_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch4_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch4_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch4_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH4_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch4_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH4_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH4_BUF_CTRL_BIT_T bf;
} NX500_DPMAS_CH4_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch4_netx_buf_base3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch4_netx_buf_base3                                0x00000094U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch4_netx_buf_base3 0x00103394U
#define Adr_NX500_dpmas_ch4_netx_buf_base3                                    0x00103394U
#define DFLT_VAL_NX500_dpmas_ch4_netx_buf_base3                               0x00000000U

#define MSK_NX500_dpmas_ch4_netx_buf_base3_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch4_netx_buf_base3_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch4_netx_buf_base3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch4_netx_buf_base3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH4_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch4_netx_buf_base3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH4_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH4_NETX_BUF_BASE3_BIT_T bf;
} NX500_DPMAS_CH4_NETX_BUF_BASE3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch4_netx_buf_base2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch4_netx_buf_base2                                0x00000098U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch4_netx_buf_base2 0x00103398U
#define Adr_NX500_dpmas_ch4_netx_buf_base2                                    0x00103398U
#define DFLT_VAL_NX500_dpmas_ch4_netx_buf_base2                               0x00000000U

#define MSK_NX500_dpmas_ch4_netx_buf_base2_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch4_netx_buf_base2_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch4_netx_buf_base2_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch4_netx_buf_base2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH4_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch4_netx_buf_base2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH4_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH4_NETX_BUF_BASE2_BIT_T bf;
} NX500_DPMAS_CH4_NETX_BUF_BASE2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch4_netx_buf_base1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch4_netx_buf_base1                                0x0000009CU
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch4_netx_buf_base1 0x0010339CU
#define Adr_NX500_dpmas_ch4_netx_buf_base1                                    0x0010339CU
#define DFLT_VAL_NX500_dpmas_ch4_netx_buf_base1                               0x00000000U

#define MSK_NX500_dpmas_ch4_netx_buf_base1_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch4_netx_buf_base1_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch4_netx_buf_base1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch4_netx_buf_base1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH4_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch4_netx_buf_base1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH4_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH4_NETX_BUF_BASE1_BIT_T bf;
} NX500_DPMAS_CH4_NETX_BUF_BASE1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch5_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch5_host_start                                0x000000A0U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch5_host_start 0x001033A0U
#define Adr_NX500_dpmas_ch5_host_start                                    0x001033A0U
#define DFLT_VAL_NX500_dpmas_ch5_host_start                               0x00000000U

#define MSK_NX500_dpmas_ch5_host_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch5_host_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch5_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch5_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH5_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch5_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH5_HOST_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMAS_CH5_HOST_START_BIT_T bf;
} NX500_DPMAS_CH5_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch5_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch5_netx_start                                0x000000A4U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch5_netx_start 0x001033A4U
#define Adr_NX500_dpmas_ch5_netx_start                                    0x001033A4U
#define DFLT_VAL_NX500_dpmas_ch5_netx_start                               0x00000000U

#define MSK_NX500_dpmas_ch5_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch5_netx_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch5_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch5_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH5_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch5_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH5_NETX_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMAS_CH5_NETX_START_BIT_T bf;
} NX500_DPMAS_CH5_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch5_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch5_dma_ctrl                                0x000000A8U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch5_dma_ctrl 0x001033A8U
#define Adr_NX500_dpmas_ch5_dma_ctrl                                    0x001033A8U
#define DFLT_VAL_NX500_dpmas_ch5_dma_ctrl                               0x00000000U

#define MSK_NX500_dpmas_ch5_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch5_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch5_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch5_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH5_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch5_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH5_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH5_DMA_CTRL_BIT_T bf;
} NX500_DPMAS_CH5_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch5_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch5_mbx_base                                0x000000ACU
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch5_mbx_base 0x001033ACU
#define Adr_NX500_dpmas_ch5_mbx_base                                    0x001033ACU
#define DFLT_VAL_NX500_dpmas_ch5_mbx_base                               0x00000000U

#define MSK_NX500_dpmas_ch5_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch5_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch5_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch5_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH5_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch5_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH5_MBX_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH5_MBX_BASE_BIT_T bf;
} NX500_DPMAS_CH5_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch5_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch5_buf_ctrl                                0x000000B0U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch5_buf_ctrl 0x001033B0U
#define Adr_NX500_dpmas_ch5_buf_ctrl                                    0x001033B0U
#define DFLT_VAL_NX500_dpmas_ch5_buf_ctrl                               0x00000000U

#define MSK_NX500_dpmas_ch5_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch5_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch5_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch5_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH5_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch5_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH5_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH5_BUF_CTRL_BIT_T bf;
} NX500_DPMAS_CH5_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch5_netx_buf_base3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch5_netx_buf_base3                                0x000000B4U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch5_netx_buf_base3 0x001033B4U
#define Adr_NX500_dpmas_ch5_netx_buf_base3                                    0x001033B4U
#define DFLT_VAL_NX500_dpmas_ch5_netx_buf_base3                               0x00000000U

#define MSK_NX500_dpmas_ch5_netx_buf_base3_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch5_netx_buf_base3_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch5_netx_buf_base3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch5_netx_buf_base3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH5_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch5_netx_buf_base3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH5_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH5_NETX_BUF_BASE3_BIT_T bf;
} NX500_DPMAS_CH5_NETX_BUF_BASE3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch5_netx_buf_base2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch5_netx_buf_base2                                0x000000B8U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch5_netx_buf_base2 0x001033B8U
#define Adr_NX500_dpmas_ch5_netx_buf_base2                                    0x001033B8U
#define DFLT_VAL_NX500_dpmas_ch5_netx_buf_base2                               0x00000000U

#define MSK_NX500_dpmas_ch5_netx_buf_base2_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch5_netx_buf_base2_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch5_netx_buf_base2_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch5_netx_buf_base2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH5_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch5_netx_buf_base2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH5_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH5_NETX_BUF_BASE2_BIT_T bf;
} NX500_DPMAS_CH5_NETX_BUF_BASE2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch5_netx_buf_base1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch5_netx_buf_base1                                0x000000BCU
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch5_netx_buf_base1 0x001033BCU
#define Adr_NX500_dpmas_ch5_netx_buf_base1                                    0x001033BCU
#define DFLT_VAL_NX500_dpmas_ch5_netx_buf_base1                               0x00000000U

#define MSK_NX500_dpmas_ch5_netx_buf_base1_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch5_netx_buf_base1_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch5_netx_buf_base1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch5_netx_buf_base1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH5_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch5_netx_buf_base1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH5_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH5_NETX_BUF_BASE1_BIT_T bf;
} NX500_DPMAS_CH5_NETX_BUF_BASE1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch6_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch6_host_start                                0x000000C0U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch6_host_start 0x001033C0U
#define Adr_NX500_dpmas_ch6_host_start                                    0x001033C0U
#define DFLT_VAL_NX500_dpmas_ch6_host_start                               0x00000000U

#define MSK_NX500_dpmas_ch6_host_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch6_host_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch6_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch6_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH6_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch6_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH6_HOST_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMAS_CH6_HOST_START_BIT_T bf;
} NX500_DPMAS_CH6_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch6_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch6_netx_start                                0x000000C4U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch6_netx_start 0x001033C4U
#define Adr_NX500_dpmas_ch6_netx_start                                    0x001033C4U
#define DFLT_VAL_NX500_dpmas_ch6_netx_start                               0x00000000U

#define MSK_NX500_dpmas_ch6_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch6_netx_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch6_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch6_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH6_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch6_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH6_NETX_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMAS_CH6_NETX_START_BIT_T bf;
} NX500_DPMAS_CH6_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch6_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch6_dma_ctrl                                0x000000C8U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch6_dma_ctrl 0x001033C8U
#define Adr_NX500_dpmas_ch6_dma_ctrl                                    0x001033C8U
#define DFLT_VAL_NX500_dpmas_ch6_dma_ctrl                               0x00000000U

#define MSK_NX500_dpmas_ch6_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch6_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch6_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch6_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH6_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch6_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH6_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH6_DMA_CTRL_BIT_T bf;
} NX500_DPMAS_CH6_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch6_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch6_mbx_base                                0x000000CCU
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch6_mbx_base 0x001033CCU
#define Adr_NX500_dpmas_ch6_mbx_base                                    0x001033CCU
#define DFLT_VAL_NX500_dpmas_ch6_mbx_base                               0x00000000U

#define MSK_NX500_dpmas_ch6_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch6_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch6_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch6_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH6_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch6_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH6_MBX_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH6_MBX_BASE_BIT_T bf;
} NX500_DPMAS_CH6_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch6_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch6_buf_ctrl                                0x000000D0U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch6_buf_ctrl 0x001033D0U
#define Adr_NX500_dpmas_ch6_buf_ctrl                                    0x001033D0U
#define DFLT_VAL_NX500_dpmas_ch6_buf_ctrl                               0x00000000U

#define MSK_NX500_dpmas_ch6_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch6_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch6_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch6_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH6_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch6_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH6_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH6_BUF_CTRL_BIT_T bf;
} NX500_DPMAS_CH6_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch6_netx_buf_base3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch6_netx_buf_base3                                0x000000D4U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch6_netx_buf_base3 0x001033D4U
#define Adr_NX500_dpmas_ch6_netx_buf_base3                                    0x001033D4U
#define DFLT_VAL_NX500_dpmas_ch6_netx_buf_base3                               0x00000000U

#define MSK_NX500_dpmas_ch6_netx_buf_base3_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch6_netx_buf_base3_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch6_netx_buf_base3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch6_netx_buf_base3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH6_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch6_netx_buf_base3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH6_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH6_NETX_BUF_BASE3_BIT_T bf;
} NX500_DPMAS_CH6_NETX_BUF_BASE3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch6_netx_buf_base2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch6_netx_buf_base2                                0x000000D8U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch6_netx_buf_base2 0x001033D8U
#define Adr_NX500_dpmas_ch6_netx_buf_base2                                    0x001033D8U
#define DFLT_VAL_NX500_dpmas_ch6_netx_buf_base2                               0x00000000U

#define MSK_NX500_dpmas_ch6_netx_buf_base2_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch6_netx_buf_base2_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch6_netx_buf_base2_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch6_netx_buf_base2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH6_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch6_netx_buf_base2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH6_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH6_NETX_BUF_BASE2_BIT_T bf;
} NX500_DPMAS_CH6_NETX_BUF_BASE2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch6_netx_buf_base1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch6_netx_buf_base1                                0x000000DCU
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch6_netx_buf_base1 0x001033DCU
#define Adr_NX500_dpmas_ch6_netx_buf_base1                                    0x001033DCU
#define DFLT_VAL_NX500_dpmas_ch6_netx_buf_base1                               0x00000000U

#define MSK_NX500_dpmas_ch6_netx_buf_base1_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch6_netx_buf_base1_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch6_netx_buf_base1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch6_netx_buf_base1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH6_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch6_netx_buf_base1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH6_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH6_NETX_BUF_BASE1_BIT_T bf;
} NX500_DPMAS_CH6_NETX_BUF_BASE1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch7_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch7_host_start                                0x000000E0U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch7_host_start 0x001033E0U
#define Adr_NX500_dpmas_ch7_host_start                                    0x001033E0U
#define DFLT_VAL_NX500_dpmas_ch7_host_start                               0x00000000U

#define MSK_NX500_dpmas_ch7_host_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch7_host_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch7_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch7_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH7_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch7_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH7_HOST_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMAS_CH7_HOST_START_BIT_T bf;
} NX500_DPMAS_CH7_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch7_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch7_netx_start                                0x000000E4U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch7_netx_start 0x001033E4U
#define Adr_NX500_dpmas_ch7_netx_start                                    0x001033E4U
#define DFLT_VAL_NX500_dpmas_ch7_netx_start                               0x00000000U

#define MSK_NX500_dpmas_ch7_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch7_netx_start_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch7_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch7_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH7_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch7_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH7_NETX_START_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_DPMAS_CH7_NETX_START_BIT_T bf;
} NX500_DPMAS_CH7_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch7_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch7_dma_ctrl                                0x000000E8U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch7_dma_ctrl 0x001033E8U
#define Adr_NX500_dpmas_ch7_dma_ctrl                                    0x001033E8U
#define DFLT_VAL_NX500_dpmas_ch7_dma_ctrl                               0x00000000U

#define MSK_NX500_dpmas_ch7_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch7_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch7_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch7_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH7_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch7_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH7_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH7_DMA_CTRL_BIT_T bf;
} NX500_DPMAS_CH7_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch7_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch7_mbx_base                                0x000000ECU
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch7_mbx_base 0x001033ECU
#define Adr_NX500_dpmas_ch7_mbx_base                                    0x001033ECU
#define DFLT_VAL_NX500_dpmas_ch7_mbx_base                               0x00000000U

#define MSK_NX500_dpmas_ch7_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch7_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch7_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch7_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH7_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch7_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH7_MBX_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH7_MBX_BASE_BIT_T bf;
} NX500_DPMAS_CH7_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch7_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch7_buf_ctrl                                0x000000F0U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch7_buf_ctrl 0x001033F0U
#define Adr_NX500_dpmas_ch7_buf_ctrl                                    0x001033F0U
#define DFLT_VAL_NX500_dpmas_ch7_buf_ctrl                               0x00000000U

#define MSK_NX500_dpmas_ch7_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch7_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch7_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch7_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH7_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch7_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH7_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_CH7_BUF_CTRL_BIT_T bf;
} NX500_DPMAS_CH7_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch7_netx_buf_base3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch7_netx_buf_base3                                0x000000F4U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch7_netx_buf_base3 0x001033F4U
#define Adr_NX500_dpmas_ch7_netx_buf_base3                                    0x001033F4U
#define DFLT_VAL_NX500_dpmas_ch7_netx_buf_base3                               0x00000000U

#define MSK_NX500_dpmas_ch7_netx_buf_base3_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch7_netx_buf_base3_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch7_netx_buf_base3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch7_netx_buf_base3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH7_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch7_netx_buf_base3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH7_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH7_NETX_BUF_BASE3_BIT_T bf;
} NX500_DPMAS_CH7_NETX_BUF_BASE3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch7_netx_buf_base2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch7_netx_buf_base2                                0x000000F8U
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch7_netx_buf_base2 0x001033F8U
#define Adr_NX500_dpmas_ch7_netx_buf_base2                                    0x001033F8U
#define DFLT_VAL_NX500_dpmas_ch7_netx_buf_base2                               0x00000000U

#define MSK_NX500_dpmas_ch7_netx_buf_base2_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch7_netx_buf_base2_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch7_netx_buf_base2_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch7_netx_buf_base2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH7_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch7_netx_buf_base2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH7_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH7_NETX_BUF_BASE2_BIT_T bf;
} NX500_DPMAS_CH7_NETX_BUF_BASE2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch7_netx_buf_base1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ch7_netx_buf_base1                                0x000000FCU
#define Adr_NX500_netx_controlled_dma_register_block_dpmas_ch7_netx_buf_base1 0x001033FCU
#define Adr_NX500_dpmas_ch7_netx_buf_base1                                    0x001033FCU
#define DFLT_VAL_NX500_dpmas_ch7_netx_buf_base1                               0x00000000U

#define MSK_NX500_dpmas_ch7_netx_buf_base1_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ch7_netx_buf_base1_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ch7_netx_buf_base1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ch7_netx_buf_base1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_CH7_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ch7_netx_buf_base1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_CH7_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_DPMAS_CH7_NETX_BUF_BASE1_BIT_T bf;
} NX500_DPMAS_CH7_NETX_BUF_BASE1_T;


/* ===================================================================== */

/* Area of netx_controlled_global_register_block_1 */

/* ===================================================================== */

#define Addr_NX500_netx_controlled_global_register_block_1 0x00103400U

/* --------------------------------------------------------------------- */
/* Register pci_window_low0 */
/* => dpmas_mem_win_start0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pci_window_low0                                     0x00000080U
#define Adr_NX500_netx_controlled_global_register_block_1_pci_window_low0 0x00103480U
#define Adr_NX500_pci_window_low0                                         0x00103480U
#define DFLT_VAL_NX500_pci_window_low0                                    0x00000000U

#define MSK_NX500_pci_window_low0_keine_ahnung      0xffffffffU
#define SRT_NX500_pci_window_low0_keine_ahnung      0
#define DFLT_VAL_NX500_pci_window_low0_keine_ahnung 0x00000000U

enum {
	BFW_NX500_pci_window_low0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_PCI_WINDOW_LOW0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_pci_window_low0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_PCI_WINDOW_LOW0_BIT_T;

typedef union {
	unsigned int                val;
	NX500_PCI_WINDOW_LOW0_BIT_T bf;
} NX500_PCI_WINDOW_LOW0_T;

/* --------------------------------------------------------------------- */
/* Register pci_window_high0 */
/* => dpmas_mem_win_end0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pci_window_high0                                     0x00000084U
#define Adr_NX500_netx_controlled_global_register_block_1_pci_window_high0 0x00103484U
#define Adr_NX500_pci_window_high0                                         0x00103484U
#define DFLT_VAL_NX500_pci_window_high0                                    0x00000000U

#define MSK_NX500_pci_window_high0_keine_ahnung      0xffffffffU
#define SRT_NX500_pci_window_high0_keine_ahnung      0
#define DFLT_VAL_NX500_pci_window_high0_keine_ahnung 0x00000000U

enum {
	BFW_NX500_pci_window_high0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_PCI_WINDOW_HIGH0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_pci_window_high0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_PCI_WINDOW_HIGH0_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_PCI_WINDOW_HIGH0_BIT_T bf;
} NX500_PCI_WINDOW_HIGH0_T;

/* --------------------------------------------------------------------- */
/* Register pci_window_low1 */
/* => dpmas_mem_win_start1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pci_window_low1                                     0x00000088U
#define Adr_NX500_netx_controlled_global_register_block_1_pci_window_low1 0x00103488U
#define Adr_NX500_pci_window_low1                                         0x00103488U
#define DFLT_VAL_NX500_pci_window_low1                                    0x00000000U

#define MSK_NX500_pci_window_low1_keine_ahnung      0xffffffffU
#define SRT_NX500_pci_window_low1_keine_ahnung      0
#define DFLT_VAL_NX500_pci_window_low1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_pci_window_low1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_PCI_WINDOW_LOW1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_pci_window_low1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_PCI_WINDOW_LOW1_BIT_T;

typedef union {
	unsigned int                val;
	NX500_PCI_WINDOW_LOW1_BIT_T bf;
} NX500_PCI_WINDOW_LOW1_T;

/* --------------------------------------------------------------------- */
/* Register pci_window_high1 */
/* => dpmas_mem_win_end1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pci_window_high1                                     0x0000008CU
#define Adr_NX500_netx_controlled_global_register_block_1_pci_window_high1 0x0010348CU
#define Adr_NX500_pci_window_high1                                         0x0010348CU
#define DFLT_VAL_NX500_pci_window_high1                                    0x00000000U

#define MSK_NX500_pci_window_high1_keine_ahnung      0xffffffffU
#define SRT_NX500_pci_window_high1_keine_ahnung      0
#define DFLT_VAL_NX500_pci_window_high1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_pci_window_high1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_PCI_WINDOW_HIGH1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_pci_window_high1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_PCI_WINDOW_HIGH1_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_PCI_WINDOW_HIGH1_BIT_T bf;
} NX500_PCI_WINDOW_HIGH1_T;

/* --------------------------------------------------------------------- */
/* Register pci_window_low2 */
/* => dpmas_mem_win_start2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pci_window_low2                                     0x00000090U
#define Adr_NX500_netx_controlled_global_register_block_1_pci_window_low2 0x00103490U
#define Adr_NX500_pci_window_low2                                         0x00103490U
#define DFLT_VAL_NX500_pci_window_low2                                    0x00000000U

#define MSK_NX500_pci_window_low2_keine_ahnung      0xffffffffU
#define SRT_NX500_pci_window_low2_keine_ahnung      0
#define DFLT_VAL_NX500_pci_window_low2_keine_ahnung 0x00000000U

enum {
	BFW_NX500_pci_window_low2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_PCI_WINDOW_LOW2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_pci_window_low2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_PCI_WINDOW_LOW2_BIT_T;

typedef union {
	unsigned int                val;
	NX500_PCI_WINDOW_LOW2_BIT_T bf;
} NX500_PCI_WINDOW_LOW2_T;

/* --------------------------------------------------------------------- */
/* Register pci_window_high2 */
/* => dpmas_mem_win_end2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pci_window_high2                                     0x00000094U
#define Adr_NX500_netx_controlled_global_register_block_1_pci_window_high2 0x00103494U
#define Adr_NX500_pci_window_high2                                         0x00103494U
#define DFLT_VAL_NX500_pci_window_high2                                    0x00000000U

#define MSK_NX500_pci_window_high2_keine_ahnung      0xffffffffU
#define SRT_NX500_pci_window_high2_keine_ahnung      0
#define DFLT_VAL_NX500_pci_window_high2_keine_ahnung 0x00000000U

enum {
	BFW_NX500_pci_window_high2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_PCI_WINDOW_HIGH2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_pci_window_high2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_PCI_WINDOW_HIGH2_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_PCI_WINDOW_HIGH2_BIT_T bf;
} NX500_PCI_WINDOW_HIGH2_T;

/* --------------------------------------------------------------------- */
/* Register pci_window_low3 */
/* => dpmas_mem_win_start3 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pci_window_low3                                     0x00000098U
#define Adr_NX500_netx_controlled_global_register_block_1_pci_window_low3 0x00103498U
#define Adr_NX500_pci_window_low3                                         0x00103498U
#define DFLT_VAL_NX500_pci_window_low3                                    0x00000000U

#define MSK_NX500_pci_window_low3_keine_ahnung      0xffffffffU
#define SRT_NX500_pci_window_low3_keine_ahnung      0
#define DFLT_VAL_NX500_pci_window_low3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_pci_window_low3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_PCI_WINDOW_LOW3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_pci_window_low3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_PCI_WINDOW_LOW3_BIT_T;

typedef union {
	unsigned int                val;
	NX500_PCI_WINDOW_LOW3_BIT_T bf;
} NX500_PCI_WINDOW_LOW3_T;

/* --------------------------------------------------------------------- */
/* Register pci_window_high3 */
/* => dpmas_mem_win_end3 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pci_window_high3                                     0x0000009CU
#define Adr_NX500_netx_controlled_global_register_block_1_pci_window_high3 0x0010349CU
#define Adr_NX500_pci_window_high3                                         0x0010349CU
#define DFLT_VAL_NX500_pci_window_high3                                    0x00000000U

#define MSK_NX500_pci_window_high3_keine_ahnung      0xffffffffU
#define SRT_NX500_pci_window_high3_keine_ahnung      0
#define DFLT_VAL_NX500_pci_window_high3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_pci_window_high3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_PCI_WINDOW_HIGH3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_pci_window_high3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_PCI_WINDOW_HIGH3_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_PCI_WINDOW_HIGH3_BIT_T bf;
} NX500_PCI_WINDOW_HIGH3_T;

/* --------------------------------------------------------------------- */
/* Register pci_io_base */
/* => dpmas_pci_io_base */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pci_io_base                                     0x000000A0U
#define Adr_NX500_netx_controlled_global_register_block_1_pci_io_base 0x001034A0U
#define Adr_NX500_pci_io_base                                         0x001034A0U
#define DFLT_VAL_NX500_pci_io_base                                    0x00000000U

#define MSK_NX500_pci_io_base_keine_ahnung      0xffffffffU
#define SRT_NX500_pci_io_base_keine_ahnung      0
#define DFLT_VAL_NX500_pci_io_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_pci_io_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_PCI_IO_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_pci_io_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_PCI_IO_BASE_BIT_T;

typedef union {
	unsigned int            val;
	NX500_PCI_IO_BASE_BIT_T bf;
} NX500_PCI_IO_BASE_T;

/* --------------------------------------------------------------------- */
/* Register pci_rom_base */
/* => dpmas_pci_rom_base */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pci_rom_base                                     0x000000A4U
#define Adr_NX500_netx_controlled_global_register_block_1_pci_rom_base 0x001034A4U
#define Adr_NX500_pci_rom_base                                         0x001034A4U
#define DFLT_VAL_NX500_pci_rom_base                                    0x00000000U

#define MSK_NX500_pci_rom_base_keine_ahnung      0xffffffffU
#define SRT_NX500_pci_rom_base_keine_ahnung      0
#define DFLT_VAL_NX500_pci_rom_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_pci_rom_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_PCI_ROM_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_pci_rom_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_PCI_ROM_BASE_BIT_T;

typedef union {
	unsigned int             val;
	NX500_PCI_ROM_BASE_BIT_T bf;
} NX500_PCI_ROM_BASE_T;

/* --------------------------------------------------------------------- */
/* Register arb_ctrl */
/* => dpmas_arb_ctrl */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_arb_ctrl                                     0x000000A8U
#define Adr_NX500_netx_controlled_global_register_block_1_arb_ctrl 0x001034A8U
#define Adr_NX500_arb_ctrl                                         0x001034A8U
#define DFLT_VAL_NX500_arb_ctrl                                    0x00000000U

#define MSK_NX500_arb_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_arb_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_arb_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_arb_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_ARB_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_arb_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_ARB_CTRL_BIT_T;

typedef union {
	unsigned int         val;
	NX500_ARB_CTRL_BIT_T bf;
} NX500_ARB_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register pci_config */
/* => dpmas_pci_cntrl */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pci_config                                     0x000000ACU
#define Adr_NX500_netx_controlled_global_register_block_1_pci_config 0x001034ACU
#define Adr_NX500_pci_config                                         0x001034ACU
#define DFLT_VAL_NX500_pci_config                                    0x00000000U

#define MSK_NX500_pci_config_keine_ahnung      0xffffffffU
#define SRT_NX500_pci_config_keine_ahnung      0
#define DFLT_VAL_NX500_pci_config_keine_ahnung 0x00000000U

enum {
	BFW_NX500_pci_config_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_PCI_CONFIG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_pci_config_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_PCI_CONFIG_BIT_T;

typedef union {
	unsigned int           val;
	NX500_PCI_CONFIG_BIT_T bf;
} NX500_PCI_CONFIG_T;

/* --------------------------------------------------------------------- */
/* Register cis_base */
/* => dpmas_cis_base */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_cis_base                                     0x000000BCU
#define Adr_NX500_netx_controlled_global_register_block_1_cis_base 0x001034BCU
#define Adr_NX500_cis_base                                         0x001034BCU
#define DFLT_VAL_NX500_cis_base                                    0x00000000U

#define MSK_NX500_cis_base_keine_ahnung      0xffffffffU
#define SRT_NX500_cis_base_keine_ahnung      0
#define DFLT_VAL_NX500_cis_base_keine_ahnung 0x00000000U

enum {
	BFW_NX500_cis_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_CIS_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_cis_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_CIS_BASE_BIT_T;

typedef union {
	unsigned int         val;
	NX500_CIS_BASE_BIT_T bf;
} NX500_CIS_BASE_T;

/* --------------------------------------------------------------------- */
/* Register wdg_netx */
/* => dpmas_wdg_host_timeout */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_wdg_netx                                     0x000000C0U
#define Adr_NX500_netx_controlled_global_register_block_1_wdg_netx 0x001034C0U
#define Adr_NX500_wdg_netx                                         0x001034C0U
#define DFLT_VAL_NX500_wdg_netx                                    0x00000000U

#define MSK_NX500_wdg_netx_keine_ahnung      0xffffffffU
#define SRT_NX500_wdg_netx_keine_ahnung      0
#define DFLT_VAL_NX500_wdg_netx_keine_ahnung 0x00000000U

enum {
	BFW_NX500_wdg_netx_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_WDG_NETX_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_wdg_netx_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_WDG_NETX_BIT_T;

typedef union {
	unsigned int         val;
	NX500_WDG_NETX_BIT_T bf;
} NX500_WDG_NETX_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_wdg_arm_timeout */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_wdg_arm_timeout                                     0x000000C8U
#define Adr_NX500_netx_controlled_global_register_block_1_dpmas_wdg_arm_timeout 0x001034C8U
#define Adr_NX500_dpmas_wdg_arm_timeout                                         0x001034C8U
#define DFLT_VAL_NX500_dpmas_wdg_arm_timeout                                    0x00000000U

#define MSK_NX500_dpmas_wdg_arm_timeout_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_wdg_arm_timeout_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_wdg_arm_timeout_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_wdg_arm_timeout_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_WDG_ARM_TIMEOUT_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_wdg_arm_timeout_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_WDG_ARM_TIMEOUT_BIT_T;

typedef union {
	unsigned int                      val;
	NX500_DPMAS_WDG_ARM_TIMEOUT_BIT_T bf;
} NX500_DPMAS_WDG_ARM_TIMEOUT_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_wdg_arm_trig */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_wdg_arm_trig                                     0x000000CCU
#define Adr_NX500_netx_controlled_global_register_block_1_dpmas_wdg_arm_trig 0x001034CCU
#define Adr_NX500_dpmas_wdg_arm_trig                                         0x001034CCU
#define DFLT_VAL_NX500_dpmas_wdg_arm_trig                                    0x00000000U

#define MSK_NX500_dpmas_wdg_arm_trig_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_wdg_arm_trig_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_wdg_arm_trig_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_wdg_arm_trig_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_WDG_ARM_TRIG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_wdg_arm_trig_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_WDG_ARM_TRIG_BIT_T;

typedef union {
	unsigned int                   val;
	NX500_DPMAS_WDG_ARM_TRIG_BIT_T bf;
} NX500_DPMAS_WDG_ARM_TRIG_T;

/* --------------------------------------------------------------------- */
/* Register sta_netx */
/* => dpmas_sys_sta */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_sta_netx                                     0x000000D8U
#define Adr_NX500_netx_controlled_global_register_block_1_sta_netx 0x001034D8U
#define Adr_NX500_sta_netx                                         0x001034D8U
#define DFLT_VAL_NX500_sta_netx                                    0x00000000U

#define MSK_NX500_sta_netx_keine_ahnung      0xffffffffU
#define SRT_NX500_sta_netx_keine_ahnung      0
#define DFLT_VAL_NX500_sta_netx_keine_ahnung 0x00000000U

enum {
	BFW_NX500_sta_netx_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_STA_NETX_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_sta_netx_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_STA_NETX_BIT_T;

typedef union {
	unsigned int         val;
	NX500_STA_NETX_BIT_T bf;
} NX500_STA_NETX_T;

/* --------------------------------------------------------------------- */
/* Register irq_status_0_netx */
/* => dpmas_int_sta0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_irq_status_0_netx                                     0x000000E0U
#define Adr_NX500_netx_controlled_global_register_block_1_irq_status_0_netx 0x001034E0U
#define Adr_NX500_irq_status_0_netx                                         0x001034E0U
#define DFLT_VAL_NX500_irq_status_0_netx                                    0x00000000U

#define MSK_NX500_irq_status_0_netx_keine_ahnung      0xffffffffU
#define SRT_NX500_irq_status_0_netx_keine_ahnung      0
#define DFLT_VAL_NX500_irq_status_0_netx_keine_ahnung 0x00000000U

enum {
	BFW_NX500_irq_status_0_netx_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IRQ_STATUS_0_NETX_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_irq_status_0_netx_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IRQ_STATUS_0_NETX_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_IRQ_STATUS_0_NETX_BIT_T bf;
} NX500_IRQ_STATUS_0_NETX_T;

/* --------------------------------------------------------------------- */
/* Register irq_status_1_netx */
/* => dpmas_int_sta1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_irq_status_1_netx                                     0x000000E4U
#define Adr_NX500_netx_controlled_global_register_block_1_irq_status_1_netx 0x001034E4U
#define Adr_NX500_irq_status_1_netx                                         0x001034E4U
#define DFLT_VAL_NX500_irq_status_1_netx                                    0x00000000U

#define MSK_NX500_irq_status_1_netx_keine_ahnung      0xffffffffU
#define SRT_NX500_irq_status_1_netx_keine_ahnung      0
#define DFLT_VAL_NX500_irq_status_1_netx_keine_ahnung 0x00000000U

enum {
	BFW_NX500_irq_status_1_netx_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IRQ_STATUS_1_NETX_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_irq_status_1_netx_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IRQ_STATUS_1_NETX_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_IRQ_STATUS_1_NETX_BIT_T bf;
} NX500_IRQ_STATUS_1_NETX_T;

/* --------------------------------------------------------------------- */
/* Register irq_status_2_netx */
/* => dpmas_int_sta2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_irq_status_2_netx                                     0x000000E8U
#define Adr_NX500_netx_controlled_global_register_block_1_irq_status_2_netx 0x001034E8U
#define Adr_NX500_irq_status_2_netx                                         0x001034E8U
#define DFLT_VAL_NX500_irq_status_2_netx                                    0x00000000U

#define MSK_NX500_irq_status_2_netx_keine_ahnung      0xffffffffU
#define SRT_NX500_irq_status_2_netx_keine_ahnung      0
#define DFLT_VAL_NX500_irq_status_2_netx_keine_ahnung 0x00000000U

enum {
	BFW_NX500_irq_status_2_netx_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IRQ_STATUS_2_NETX_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_irq_status_2_netx_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IRQ_STATUS_2_NETX_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_IRQ_STATUS_2_NETX_BIT_T bf;
} NX500_IRQ_STATUS_2_NETX_T;

/* --------------------------------------------------------------------- */
/* Register irq_status_3_netx */
/* => dpmas_int_sta3 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_irq_status_3_netx                                     0x000000ECU
#define Adr_NX500_netx_controlled_global_register_block_1_irq_status_3_netx 0x001034ECU
#define Adr_NX500_irq_status_3_netx                                         0x001034ECU
#define DFLT_VAL_NX500_irq_status_3_netx                                    0x00000000U

#define MSK_NX500_irq_status_3_netx_keine_ahnung      0xffffffffU
#define SRT_NX500_irq_status_3_netx_keine_ahnung      0
#define DFLT_VAL_NX500_irq_status_3_netx_keine_ahnung 0x00000000U

enum {
	BFW_NX500_irq_status_3_netx_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IRQ_STATUS_3_NETX_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_irq_status_3_netx_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IRQ_STATUS_3_NETX_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_IRQ_STATUS_3_NETX_BIT_T bf;
} NX500_IRQ_STATUS_3_NETX_T;

/* --------------------------------------------------------------------- */
/* Register irq_mask_0_netx */
/* => dpmas_int_en0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_irq_mask_0_netx                                     0x000000F0U
#define Adr_NX500_netx_controlled_global_register_block_1_irq_mask_0_netx 0x001034F0U
#define Adr_NX500_irq_mask_0_netx                                         0x001034F0U
#define DFLT_VAL_NX500_irq_mask_0_netx                                    0x00000000U

#define MSK_NX500_irq_mask_0_netx_keine_ahnung      0xffffffffU
#define SRT_NX500_irq_mask_0_netx_keine_ahnung      0
#define DFLT_VAL_NX500_irq_mask_0_netx_keine_ahnung 0x00000000U

enum {
	BFW_NX500_irq_mask_0_netx_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IRQ_MASK_0_NETX_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_irq_mask_0_netx_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IRQ_MASK_0_NETX_BIT_T;

typedef union {
	unsigned int                val;
	NX500_IRQ_MASK_0_NETX_BIT_T bf;
} NX500_IRQ_MASK_0_NETX_T;

/* --------------------------------------------------------------------- */
/* Register irq_mask_1_netx */
/* => dpmas_int_en1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_irq_mask_1_netx                                     0x000000F4U
#define Adr_NX500_netx_controlled_global_register_block_1_irq_mask_1_netx 0x001034F4U
#define Adr_NX500_irq_mask_1_netx                                         0x001034F4U
#define DFLT_VAL_NX500_irq_mask_1_netx                                    0x00000000U

#define MSK_NX500_irq_mask_1_netx_keine_ahnung      0xffffffffU
#define SRT_NX500_irq_mask_1_netx_keine_ahnung      0
#define DFLT_VAL_NX500_irq_mask_1_netx_keine_ahnung 0x00000000U

enum {
	BFW_NX500_irq_mask_1_netx_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IRQ_MASK_1_NETX_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_irq_mask_1_netx_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IRQ_MASK_1_NETX_BIT_T;

typedef union {
	unsigned int                val;
	NX500_IRQ_MASK_1_NETX_BIT_T bf;
} NX500_IRQ_MASK_1_NETX_T;

/* --------------------------------------------------------------------- */
/* Register irq_mask_2_netx */
/* => dpmas_int_en2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_irq_mask_2_netx                                     0x000000F8U
#define Adr_NX500_netx_controlled_global_register_block_1_irq_mask_2_netx 0x001034F8U
#define Adr_NX500_irq_mask_2_netx                                         0x001034F8U
#define DFLT_VAL_NX500_irq_mask_2_netx                                    0x00000000U

#define MSK_NX500_irq_mask_2_netx_keine_ahnung      0xffffffffU
#define SRT_NX500_irq_mask_2_netx_keine_ahnung      0
#define DFLT_VAL_NX500_irq_mask_2_netx_keine_ahnung 0x00000000U

enum {
	BFW_NX500_irq_mask_2_netx_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IRQ_MASK_2_NETX_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_irq_mask_2_netx_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IRQ_MASK_2_NETX_BIT_T;

typedef union {
	unsigned int                val;
	NX500_IRQ_MASK_2_NETX_BIT_T bf;
} NX500_IRQ_MASK_2_NETX_T;

/* --------------------------------------------------------------------- */
/* Register irq_mask_3_netx */
/* => dpmas_int_en3 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_irq_mask_3_netx                                     0x000000FCU
#define Adr_NX500_netx_controlled_global_register_block_1_irq_mask_3_netx 0x001034FCU
#define Adr_NX500_irq_mask_3_netx                                         0x001034FCU
#define DFLT_VAL_NX500_irq_mask_3_netx                                    0x00000000U

#define MSK_NX500_irq_mask_3_netx_keine_ahnung      0xffffffffU
#define SRT_NX500_irq_mask_3_netx_keine_ahnung      0
#define DFLT_VAL_NX500_irq_mask_3_netx_keine_ahnung 0x00000000U

enum {
	BFW_NX500_irq_mask_3_netx_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IRQ_MASK_3_NETX_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_irq_mask_3_netx_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IRQ_MASK_3_NETX_BIT_T;

typedef union {
	unsigned int                val;
	NX500_IRQ_MASK_3_NETX_BIT_T bf;
} NX500_IRQ_MASK_3_NETX_T;


/* ===================================================================== */

/* Area of netx_controlled_handshake_register_block */

/* ===================================================================== */

#define Addr_NX500_netx_controlled_handshake_register_block 0x00103500U
#define NX500_NETX_DPM_ARM_HS_AREA                          0x00103500U

/* --------------------------------------------------------------------- */
/* Register handshake_ch0 */
/* => dpmas_hs_data0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_handshake_ch0                                      0x00000000U
#define Adr_NX500_netx_controlled_handshake_register_block_handshake_ch0 0x00103500U
#define Adr_NX500_handshake_ch0                                          0x00103500U
#define DFLT_VAL_NX500_handshake_ch0                                     0x00000000U

#define MSK_NX500_handshake_ch0_keine_ahnung      0xffffffffU
#define SRT_NX500_handshake_ch0_keine_ahnung      0
#define DFLT_VAL_NX500_handshake_ch0_keine_ahnung 0x00000000U

enum {
	BFW_NX500_handshake_ch0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_HANDSHAKE_CH0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_handshake_ch0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_HANDSHAKE_CH0_BIT_T;

typedef union {
	unsigned int              val;
	NX500_HANDSHAKE_CH0_BIT_T bf;
} NX500_HANDSHAKE_CH0_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch1 */
/* => dpmas_hs_data1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_handshake_ch1                                      0x00000004U
#define Adr_NX500_netx_controlled_handshake_register_block_handshake_ch1 0x00103504U
#define Adr_NX500_handshake_ch1                                          0x00103504U
#define DFLT_VAL_NX500_handshake_ch1                                     0x00000000U

#define MSK_NX500_handshake_ch1_keine_ahnung      0xffffffffU
#define SRT_NX500_handshake_ch1_keine_ahnung      0
#define DFLT_VAL_NX500_handshake_ch1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_handshake_ch1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_HANDSHAKE_CH1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_handshake_ch1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_HANDSHAKE_CH1_BIT_T;

typedef union {
	unsigned int              val;
	NX500_HANDSHAKE_CH1_BIT_T bf;
} NX500_HANDSHAKE_CH1_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch2 */
/* => dpmas_hs_data2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_handshake_ch2                                      0x00000008U
#define Adr_NX500_netx_controlled_handshake_register_block_handshake_ch2 0x00103508U
#define Adr_NX500_handshake_ch2                                          0x00103508U
#define DFLT_VAL_NX500_handshake_ch2                                     0x00000000U

#define MSK_NX500_handshake_ch2_keine_ahnung      0xffffffffU
#define SRT_NX500_handshake_ch2_keine_ahnung      0
#define DFLT_VAL_NX500_handshake_ch2_keine_ahnung 0x00000000U

enum {
	BFW_NX500_handshake_ch2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_HANDSHAKE_CH2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_handshake_ch2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_HANDSHAKE_CH2_BIT_T;

typedef union {
	unsigned int              val;
	NX500_HANDSHAKE_CH2_BIT_T bf;
} NX500_HANDSHAKE_CH2_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch3 */
/* => dpmas_hs_data3 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_handshake_ch3                                      0x0000000CU
#define Adr_NX500_netx_controlled_handshake_register_block_handshake_ch3 0x0010350CU
#define Adr_NX500_handshake_ch3                                          0x0010350CU
#define DFLT_VAL_NX500_handshake_ch3                                     0x00000000U

#define MSK_NX500_handshake_ch3_keine_ahnung      0xffffffffU
#define SRT_NX500_handshake_ch3_keine_ahnung      0
#define DFLT_VAL_NX500_handshake_ch3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_handshake_ch3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_HANDSHAKE_CH3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_handshake_ch3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_HANDSHAKE_CH3_BIT_T;

typedef union {
	unsigned int              val;
	NX500_HANDSHAKE_CH3_BIT_T bf;
} NX500_HANDSHAKE_CH3_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch4 */
/* => dpmas_hs_data4 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_handshake_ch4                                      0x00000010U
#define Adr_NX500_netx_controlled_handshake_register_block_handshake_ch4 0x00103510U
#define Adr_NX500_handshake_ch4                                          0x00103510U
#define DFLT_VAL_NX500_handshake_ch4                                     0x00000000U

#define MSK_NX500_handshake_ch4_keine_ahnung      0xffffffffU
#define SRT_NX500_handshake_ch4_keine_ahnung      0
#define DFLT_VAL_NX500_handshake_ch4_keine_ahnung 0x00000000U

enum {
	BFW_NX500_handshake_ch4_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_HANDSHAKE_CH4_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_handshake_ch4_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_HANDSHAKE_CH4_BIT_T;

typedef union {
	unsigned int              val;
	NX500_HANDSHAKE_CH4_BIT_T bf;
} NX500_HANDSHAKE_CH4_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch5 */
/* => dpmas_hs_data5 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_handshake_ch5                                      0x00000014U
#define Adr_NX500_netx_controlled_handshake_register_block_handshake_ch5 0x00103514U
#define Adr_NX500_handshake_ch5                                          0x00103514U
#define DFLT_VAL_NX500_handshake_ch5                                     0x00000000U

#define MSK_NX500_handshake_ch5_keine_ahnung      0xffffffffU
#define SRT_NX500_handshake_ch5_keine_ahnung      0
#define DFLT_VAL_NX500_handshake_ch5_keine_ahnung 0x00000000U

enum {
	BFW_NX500_handshake_ch5_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_HANDSHAKE_CH5_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_handshake_ch5_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_HANDSHAKE_CH5_BIT_T;

typedef union {
	unsigned int              val;
	NX500_HANDSHAKE_CH5_BIT_T bf;
} NX500_HANDSHAKE_CH5_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch6 */
/* => dpmas_hs_data6 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_handshake_ch6                                      0x00000018U
#define Adr_NX500_netx_controlled_handshake_register_block_handshake_ch6 0x00103518U
#define Adr_NX500_handshake_ch6                                          0x00103518U
#define DFLT_VAL_NX500_handshake_ch6                                     0x00000000U

#define MSK_NX500_handshake_ch6_keine_ahnung      0xffffffffU
#define SRT_NX500_handshake_ch6_keine_ahnung      0
#define DFLT_VAL_NX500_handshake_ch6_keine_ahnung 0x00000000U

enum {
	BFW_NX500_handshake_ch6_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_HANDSHAKE_CH6_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_handshake_ch6_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_HANDSHAKE_CH6_BIT_T;

typedef union {
	unsigned int              val;
	NX500_HANDSHAKE_CH6_BIT_T bf;
} NX500_HANDSHAKE_CH6_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch7 */
/* => dpmas_hs_data7 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_handshake_ch7                                      0x0000001CU
#define Adr_NX500_netx_controlled_handshake_register_block_handshake_ch7 0x0010351CU
#define Adr_NX500_handshake_ch7                                          0x0010351CU
#define DFLT_VAL_NX500_handshake_ch7                                     0x00000000U

#define MSK_NX500_handshake_ch7_keine_ahnung      0xffffffffU
#define SRT_NX500_handshake_ch7_keine_ahnung      0
#define DFLT_VAL_NX500_handshake_ch7_keine_ahnung 0x00000000U

enum {
	BFW_NX500_handshake_ch7_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_HANDSHAKE_CH7_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_handshake_ch7_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_HANDSHAKE_CH7_BIT_T;

typedef union {
	unsigned int              val;
	NX500_HANDSHAKE_CH7_BIT_T bf;
} NX500_HANDSHAKE_CH7_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch8 */
/* => dpmas_hs_data8 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_handshake_ch8                                      0x00000020U
#define Adr_NX500_netx_controlled_handshake_register_block_handshake_ch8 0x00103520U
#define Adr_NX500_handshake_ch8                                          0x00103520U
#define DFLT_VAL_NX500_handshake_ch8                                     0x00000000U

#define MSK_NX500_handshake_ch8_keine_ahnung      0xffffffffU
#define SRT_NX500_handshake_ch8_keine_ahnung      0
#define DFLT_VAL_NX500_handshake_ch8_keine_ahnung 0x00000000U

enum {
	BFW_NX500_handshake_ch8_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_HANDSHAKE_CH8_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_handshake_ch8_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_HANDSHAKE_CH8_BIT_T;

typedef union {
	unsigned int              val;
	NX500_HANDSHAKE_CH8_BIT_T bf;
} NX500_HANDSHAKE_CH8_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch9 */
/* => dpmas_hs_data9 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_handshake_ch9                                      0x00000024U
#define Adr_NX500_netx_controlled_handshake_register_block_handshake_ch9 0x00103524U
#define Adr_NX500_handshake_ch9                                          0x00103524U
#define DFLT_VAL_NX500_handshake_ch9                                     0x00000000U

#define MSK_NX500_handshake_ch9_keine_ahnung      0xffffffffU
#define SRT_NX500_handshake_ch9_keine_ahnung      0
#define DFLT_VAL_NX500_handshake_ch9_keine_ahnung 0x00000000U

enum {
	BFW_NX500_handshake_ch9_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_HANDSHAKE_CH9_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_handshake_ch9_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_HANDSHAKE_CH9_BIT_T;

typedef union {
	unsigned int              val;
	NX500_HANDSHAKE_CH9_BIT_T bf;
} NX500_HANDSHAKE_CH9_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch10 */
/* => dpmas_hs_data10 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_handshake_ch10                                      0x00000028U
#define Adr_NX500_netx_controlled_handshake_register_block_handshake_ch10 0x00103528U
#define Adr_NX500_handshake_ch10                                          0x00103528U
#define DFLT_VAL_NX500_handshake_ch10                                     0x00000000U

#define MSK_NX500_handshake_ch10_keine_ahnung      0xffffffffU
#define SRT_NX500_handshake_ch10_keine_ahnung      0
#define DFLT_VAL_NX500_handshake_ch10_keine_ahnung 0x00000000U

enum {
	BFW_NX500_handshake_ch10_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_HANDSHAKE_CH10_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_handshake_ch10_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_HANDSHAKE_CH10_BIT_T;

typedef union {
	unsigned int               val;
	NX500_HANDSHAKE_CH10_BIT_T bf;
} NX500_HANDSHAKE_CH10_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch11 */
/* => dpmas_hs_data11 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_handshake_ch11                                      0x0000002CU
#define Adr_NX500_netx_controlled_handshake_register_block_handshake_ch11 0x0010352CU
#define Adr_NX500_handshake_ch11                                          0x0010352CU
#define DFLT_VAL_NX500_handshake_ch11                                     0x00000000U

#define MSK_NX500_handshake_ch11_keine_ahnung      0xffffffffU
#define SRT_NX500_handshake_ch11_keine_ahnung      0
#define DFLT_VAL_NX500_handshake_ch11_keine_ahnung 0x00000000U

enum {
	BFW_NX500_handshake_ch11_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_HANDSHAKE_CH11_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_handshake_ch11_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_HANDSHAKE_CH11_BIT_T;

typedef union {
	unsigned int               val;
	NX500_HANDSHAKE_CH11_BIT_T bf;
} NX500_HANDSHAKE_CH11_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch12 */
/* => dpmas_hs_data12 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_handshake_ch12                                      0x00000030U
#define Adr_NX500_netx_controlled_handshake_register_block_handshake_ch12 0x00103530U
#define Adr_NX500_handshake_ch12                                          0x00103530U
#define DFLT_VAL_NX500_handshake_ch12                                     0x00000000U

#define MSK_NX500_handshake_ch12_keine_ahnung      0xffffffffU
#define SRT_NX500_handshake_ch12_keine_ahnung      0
#define DFLT_VAL_NX500_handshake_ch12_keine_ahnung 0x00000000U

enum {
	BFW_NX500_handshake_ch12_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_HANDSHAKE_CH12_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_handshake_ch12_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_HANDSHAKE_CH12_BIT_T;

typedef union {
	unsigned int               val;
	NX500_HANDSHAKE_CH12_BIT_T bf;
} NX500_HANDSHAKE_CH12_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch13 */
/* => dpmas_hs_data13 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_handshake_ch13                                      0x00000034U
#define Adr_NX500_netx_controlled_handshake_register_block_handshake_ch13 0x00103534U
#define Adr_NX500_handshake_ch13                                          0x00103534U
#define DFLT_VAL_NX500_handshake_ch13                                     0x00000000U

#define MSK_NX500_handshake_ch13_keine_ahnung      0xffffffffU
#define SRT_NX500_handshake_ch13_keine_ahnung      0
#define DFLT_VAL_NX500_handshake_ch13_keine_ahnung 0x00000000U

enum {
	BFW_NX500_handshake_ch13_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_HANDSHAKE_CH13_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_handshake_ch13_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_HANDSHAKE_CH13_BIT_T;

typedef union {
	unsigned int               val;
	NX500_HANDSHAKE_CH13_BIT_T bf;
} NX500_HANDSHAKE_CH13_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch14 */
/* => dpmas_hs_data14 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_handshake_ch14                                      0x00000038U
#define Adr_NX500_netx_controlled_handshake_register_block_handshake_ch14 0x00103538U
#define Adr_NX500_handshake_ch14                                          0x00103538U
#define DFLT_VAL_NX500_handshake_ch14                                     0x00000000U

#define MSK_NX500_handshake_ch14_keine_ahnung      0xffffffffU
#define SRT_NX500_handshake_ch14_keine_ahnung      0
#define DFLT_VAL_NX500_handshake_ch14_keine_ahnung 0x00000000U

enum {
	BFW_NX500_handshake_ch14_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_HANDSHAKE_CH14_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_handshake_ch14_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_HANDSHAKE_CH14_BIT_T;

typedef union {
	unsigned int               val;
	NX500_HANDSHAKE_CH14_BIT_T bf;
} NX500_HANDSHAKE_CH14_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch15 */
/* => dpmas_hs_data15 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_handshake_ch15                                      0x0000003CU
#define Adr_NX500_netx_controlled_handshake_register_block_handshake_ch15 0x0010353CU
#define Adr_NX500_handshake_ch15                                          0x0010353CU
#define DFLT_VAL_NX500_handshake_ch15                                     0x00000000U

#define MSK_NX500_handshake_ch15_keine_ahnung      0xffffffffU
#define SRT_NX500_handshake_ch15_keine_ahnung      0
#define DFLT_VAL_NX500_handshake_ch15_keine_ahnung 0x00000000U

enum {
	BFW_NX500_handshake_ch15_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_HANDSHAKE_CH15_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_handshake_ch15_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_HANDSHAKE_CH15_BIT_T;

typedef union {
	unsigned int               val;
	NX500_HANDSHAKE_CH15_BIT_T bf;
} NX500_HANDSHAKE_CH15_T;


/* ===================================================================== */

/* Area of netx_controlled_global_register_block_2 */

/* ===================================================================== */

#define Addr_NX500_netx_controlled_global_register_block_2 0x00103600U
#define NX500_NETX_DPM_ARM_GLOB_AREA                       0x00103600U

/* --------------------------------------------------------------------- */
/* Register clk_reg */
/* => dpmas_clkout_conf */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_clk_reg                                     0x00000004U
#define Adr_NX500_netx_controlled_global_register_block_2_clk_reg 0x00103604U
#define Adr_NX500_clk_reg                                         0x00103604U
#define DFLT_VAL_NX500_clk_reg                                    0x00000000U

#define MSK_NX500_clk_reg_keine_ahnung      0xffffffffU
#define SRT_NX500_clk_reg_keine_ahnung      0
#define DFLT_VAL_NX500_clk_reg_keine_ahnung 0x00000000U

enum {
	BFW_NX500_clk_reg_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_CLK_REG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_clk_reg_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_CLK_REG_BIT_T;

typedef union {
	unsigned int        val;
	NX500_CLK_REG_BIT_T bf;
} NX500_CLK_REG_T;

/* --------------------------------------------------------------------- */
/* Register if_conf1 */
/* => dpmas_if_conf0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_if_conf1                                     0x00000008U
#define Adr_NX500_netx_controlled_global_register_block_2_if_conf1 0x00103608U
#define Adr_NX500_if_conf1                                         0x00103608U
#define DFLT_VAL_NX500_if_conf1                                    0x00000000U

#define MSK_NX500_if_conf1_keine_ahnung      0xffffffffU
#define SRT_NX500_if_conf1_keine_ahnung      0
#define DFLT_VAL_NX500_if_conf1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_if_conf1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IF_CONF1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_if_conf1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IF_CONF1_BIT_T;

typedef union {
	unsigned int         val;
	NX500_IF_CONF1_BIT_T bf;
} NX500_IF_CONF1_T;

/* --------------------------------------------------------------------- */
/* Register if_conf2 */
/* => dpmas_if_conf1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_if_conf2                                     0x0000000CU
#define Adr_NX500_netx_controlled_global_register_block_2_if_conf2 0x0010360CU
#define Adr_NX500_if_conf2                                         0x0010360CU
#define DFLT_VAL_NX500_if_conf2                                    0x00000000U

#define MSK_NX500_if_conf2_keine_ahnung      0xffffffffU
#define SRT_NX500_if_conf2_keine_ahnung      0
#define DFLT_VAL_NX500_if_conf2_keine_ahnung 0x00000000U

enum {
	BFW_NX500_if_conf2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IF_CONF2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_if_conf2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IF_CONF2_BIT_T;

typedef union {
	unsigned int         val;
	NX500_IF_CONF2_BIT_T bf;
} NX500_IF_CONF2_T;

/* --------------------------------------------------------------------- */
/* Register exp_bus_reg */
/* => dpmas_ext_config0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_exp_bus_reg                                     0x00000010U
#define Adr_NX500_netx_controlled_global_register_block_2_exp_bus_reg 0x00103610U
#define Adr_NX500_exp_bus_reg                                         0x00103610U
#define DFLT_VAL_NX500_exp_bus_reg                                    0x00000000U

#define MSK_NX500_exp_bus_reg_keine_ahnung      0xffffffffU
#define SRT_NX500_exp_bus_reg_keine_ahnung      0
#define DFLT_VAL_NX500_exp_bus_reg_keine_ahnung 0x00000000U

enum {
	BFW_NX500_exp_bus_reg_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_EXP_BUS_REG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_exp_bus_reg_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_EXP_BUS_REG_BIT_T;

typedef union {
	unsigned int            val;
	NX500_EXP_BUS_REG_BIT_T bf;
} NX500_EXP_BUS_REG_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ext_config1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ext_config1                                     0x00000014U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_ext_config1 0x00103614U
#define Adr_NX500_dpmas_ext_config1                                         0x00103614U
#define DFLT_VAL_NX500_dpmas_ext_config1                                    0x00000000U

#define MSK_NX500_dpmas_ext_config1_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ext_config1_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ext_config1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ext_config1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_EXT_CONFIG1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ext_config1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_EXT_CONFIG1_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_DPMAS_EXT_CONFIG1_BIT_T bf;
} NX500_DPMAS_EXT_CONFIG1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ext_config2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ext_config2                                     0x00000018U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_ext_config2 0x00103618U
#define Adr_NX500_dpmas_ext_config2                                         0x00103618U
#define DFLT_VAL_NX500_dpmas_ext_config2                                    0x00000000U

#define MSK_NX500_dpmas_ext_config2_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ext_config2_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ext_config2_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ext_config2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_EXT_CONFIG2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ext_config2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_EXT_CONFIG2_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_DPMAS_EXT_CONFIG2_BIT_T bf;
} NX500_DPMAS_EXT_CONFIG2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ext_config3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_ext_config3                                     0x0000001CU
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_ext_config3 0x0010361CU
#define Adr_NX500_dpmas_ext_config3                                         0x0010361CU
#define DFLT_VAL_NX500_dpmas_ext_config3                                    0x00000000U

#define MSK_NX500_dpmas_ext_config3_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_ext_config3_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_ext_config3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_ext_config3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_EXT_CONFIG3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_ext_config3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_EXT_CONFIG3_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_DPMAS_EXT_CONFIG3_BIT_T bf;
} NX500_DPMAS_EXT_CONFIG3_T;

/* --------------------------------------------------------------------- */
/* Register io_reg_mode0 */
/* => dpmas_io_mode0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_io_reg_mode0                                     0x00000020U
#define Adr_NX500_netx_controlled_global_register_block_2_io_reg_mode0 0x00103620U
#define Adr_NX500_io_reg_mode0                                         0x00103620U
#define DFLT_VAL_NX500_io_reg_mode0                                    0x00000000U

#define MSK_NX500_io_reg_mode0_keine_ahnung      0xffffffffU
#define SRT_NX500_io_reg_mode0_keine_ahnung      0
#define DFLT_VAL_NX500_io_reg_mode0_keine_ahnung 0x00000000U

enum {
	BFW_NX500_io_reg_mode0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IO_REG_MODE0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_io_reg_mode0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IO_REG_MODE0_BIT_T;

typedef union {
	unsigned int             val;
	NX500_IO_REG_MODE0_BIT_T bf;
} NX500_IO_REG_MODE0_T;

/* --------------------------------------------------------------------- */
/* Register io_reg_drv_en0 */
/* => dpmas_io_drv_en0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_io_reg_drv_en0                                     0x00000024U
#define Adr_NX500_netx_controlled_global_register_block_2_io_reg_drv_en0 0x00103624U
#define Adr_NX500_io_reg_drv_en0                                         0x00103624U
#define DFLT_VAL_NX500_io_reg_drv_en0                                    0x00000000U

#define MSK_NX500_io_reg_drv_en0_keine_ahnung      0xffffffffU
#define SRT_NX500_io_reg_drv_en0_keine_ahnung      0
#define DFLT_VAL_NX500_io_reg_drv_en0_keine_ahnung 0x00000000U

enum {
	BFW_NX500_io_reg_drv_en0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IO_REG_DRV_EN0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_io_reg_drv_en0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IO_REG_DRV_EN0_BIT_T;

typedef union {
	unsigned int               val;
	NX500_IO_REG_DRV_EN0_BIT_T bf;
} NX500_IO_REG_DRV_EN0_T;

/* --------------------------------------------------------------------- */
/* Register io_reg_data0 */
/* => dpmas_io_data0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_io_reg_data0                                     0x00000028U
#define Adr_NX500_netx_controlled_global_register_block_2_io_reg_data0 0x00103628U
#define Adr_NX500_io_reg_data0                                         0x00103628U
#define DFLT_VAL_NX500_io_reg_data0                                    0x00000000U

#define MSK_NX500_io_reg_data0_keine_ahnung      0xffffffffU
#define SRT_NX500_io_reg_data0_keine_ahnung      0
#define DFLT_VAL_NX500_io_reg_data0_keine_ahnung 0x00000000U

enum {
	BFW_NX500_io_reg_data0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IO_REG_DATA0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_io_reg_data0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IO_REG_DATA0_BIT_T;

typedef union {
	unsigned int             val;
	NX500_IO_REG_DATA0_BIT_T bf;
} NX500_IO_REG_DATA0_T;

/* --------------------------------------------------------------------- */
/* Register io_reg_reserved0 */
/* => reserved */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_io_reg_reserved0                                     0x0000002CU
#define Adr_NX500_netx_controlled_global_register_block_2_io_reg_reserved0 0x0010362CU
#define Adr_NX500_io_reg_reserved0                                         0x0010362CU
#define DFLT_VAL_NX500_io_reg_reserved0                                    0x00000000U

#define MSK_NX500_io_reg_reserved0_keine_ahnung      0xffffffffU
#define SRT_NX500_io_reg_reserved0_keine_ahnung      0
#define DFLT_VAL_NX500_io_reg_reserved0_keine_ahnung 0x00000000U

enum {
	BFW_NX500_io_reg_reserved0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IO_REG_RESERVED0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_io_reg_reserved0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IO_REG_RESERVED0_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_IO_REG_RESERVED0_BIT_T bf;
} NX500_IO_REG_RESERVED0_T;

/* --------------------------------------------------------------------- */
/* Register io_reg_mode1 */
/* => dpmas_io_mode1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_io_reg_mode1                                     0x00000030U
#define Adr_NX500_netx_controlled_global_register_block_2_io_reg_mode1 0x00103630U
#define Adr_NX500_io_reg_mode1                                         0x00103630U
#define DFLT_VAL_NX500_io_reg_mode1                                    0x00000000U

#define MSK_NX500_io_reg_mode1_keine_ahnung      0xffffffffU
#define SRT_NX500_io_reg_mode1_keine_ahnung      0
#define DFLT_VAL_NX500_io_reg_mode1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_io_reg_mode1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IO_REG_MODE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_io_reg_mode1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IO_REG_MODE1_BIT_T;

typedef union {
	unsigned int             val;
	NX500_IO_REG_MODE1_BIT_T bf;
} NX500_IO_REG_MODE1_T;

/* --------------------------------------------------------------------- */
/* Register io_reg_drv_en1 */
/* => dpmas_io_drv_en1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_io_reg_drv_en1                                     0x00000034U
#define Adr_NX500_netx_controlled_global_register_block_2_io_reg_drv_en1 0x00103634U
#define Adr_NX500_io_reg_drv_en1                                         0x00103634U
#define DFLT_VAL_NX500_io_reg_drv_en1                                    0x00000000U

#define MSK_NX500_io_reg_drv_en1_keine_ahnung      0xffffffffU
#define SRT_NX500_io_reg_drv_en1_keine_ahnung      0
#define DFLT_VAL_NX500_io_reg_drv_en1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_io_reg_drv_en1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IO_REG_DRV_EN1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_io_reg_drv_en1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IO_REG_DRV_EN1_BIT_T;

typedef union {
	unsigned int               val;
	NX500_IO_REG_DRV_EN1_BIT_T bf;
} NX500_IO_REG_DRV_EN1_T;

/* --------------------------------------------------------------------- */
/* Register io_reg_data1 */
/* => dpmas_io_data1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_io_reg_data1                                     0x00000038U
#define Adr_NX500_netx_controlled_global_register_block_2_io_reg_data1 0x00103638U
#define Adr_NX500_io_reg_data1                                         0x00103638U
#define DFLT_VAL_NX500_io_reg_data1                                    0x00000000U

#define MSK_NX500_io_reg_data1_keine_ahnung      0xffffffffU
#define SRT_NX500_io_reg_data1_keine_ahnung      0
#define DFLT_VAL_NX500_io_reg_data1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_io_reg_data1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IO_REG_DATA1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_io_reg_data1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IO_REG_DATA1_BIT_T;

typedef union {
	unsigned int             val;
	NX500_IO_REG_DATA1_BIT_T bf;
} NX500_IO_REG_DATA1_T;

/* --------------------------------------------------------------------- */
/* Register io_reg_reserved1 */
/* => reserved */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_io_reg_reserved1                                     0x0000003CU
#define Adr_NX500_netx_controlled_global_register_block_2_io_reg_reserved1 0x0010363CU
#define Adr_NX500_io_reg_reserved1                                         0x0010363CU
#define DFLT_VAL_NX500_io_reg_reserved1                                    0x00000000U

#define MSK_NX500_io_reg_reserved1_keine_ahnung      0xffffffffU
#define SRT_NX500_io_reg_reserved1_keine_ahnung      0
#define DFLT_VAL_NX500_io_reg_reserved1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_io_reg_reserved1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_IO_REG_RESERVED1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_io_reg_reserved1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_IO_REG_RESERVED1_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_IO_REG_RESERVED1_BIT_T bf;
} NX500_IO_REG_RESERVED1_T;

/* --------------------------------------------------------------------- */
/* Register mb_ctrl */
/* => dpmas_db_end0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_mb_ctrl                                     0x00000040U
#define Adr_NX500_netx_controlled_global_register_block_2_mb_ctrl 0x00103640U
#define Adr_NX500_mb_ctrl                                         0x00103640U
#define DFLT_VAL_NX500_mb_ctrl                                    0x00000000U

#define MSK_NX500_mb_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_mb_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_mb_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_mb_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_MB_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_mb_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_MB_CTRL_BIT_T;

typedef union {
	unsigned int        val;
	NX500_MB_CTRL_BIT_T bf;
} NX500_MB_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_mapping0 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_db_mapping0                                     0x00000044U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_db_mapping0 0x00103644U
#define Adr_NX500_dpmas_db_mapping0                                         0x00103644U
#define DFLT_VAL_NX500_dpmas_db_mapping0                                    0x00000000U

#define MSK_NX500_dpmas_db_mapping0_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_db_mapping0_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_db_mapping0_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_db_mapping0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_DB_MAPPING0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_db_mapping0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_DB_MAPPING0_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_DPMAS_DB_MAPPING0_BIT_T bf;
} NX500_DPMAS_DB_MAPPING0_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_end1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_db_end1                                     0x00000048U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_db_end1 0x00103648U
#define Adr_NX500_dpmas_db_end1                                         0x00103648U
#define DFLT_VAL_NX500_dpmas_db_end1                                    0x00000000U

#define MSK_NX500_dpmas_db_end1_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_db_end1_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_db_end1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_db_end1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_DB_END1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_db_end1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_DB_END1_BIT_T;

typedef union {
	unsigned int              val;
	NX500_DPMAS_DB_END1_BIT_T bf;
} NX500_DPMAS_DB_END1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_mapping1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_db_mapping1                                     0x0000004CU
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_db_mapping1 0x0010364CU
#define Adr_NX500_dpmas_db_mapping1                                         0x0010364CU
#define DFLT_VAL_NX500_dpmas_db_mapping1                                    0x00000000U

#define MSK_NX500_dpmas_db_mapping1_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_db_mapping1_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_db_mapping1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_db_mapping1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_DB_MAPPING1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_db_mapping1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_DB_MAPPING1_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_DPMAS_DB_MAPPING1_BIT_T bf;
} NX500_DPMAS_DB_MAPPING1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_end2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_db_end2                                     0x00000050U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_db_end2 0x00103650U
#define Adr_NX500_dpmas_db_end2                                         0x00103650U
#define DFLT_VAL_NX500_dpmas_db_end2                                    0x00000000U

#define MSK_NX500_dpmas_db_end2_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_db_end2_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_db_end2_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_db_end2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_DB_END2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_db_end2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_DB_END2_BIT_T;

typedef union {
	unsigned int              val;
	NX500_DPMAS_DB_END2_BIT_T bf;
} NX500_DPMAS_DB_END2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_mapping2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_db_mapping2                                     0x00000054U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_db_mapping2 0x00103654U
#define Adr_NX500_dpmas_db_mapping2                                         0x00103654U
#define DFLT_VAL_NX500_dpmas_db_mapping2                                    0x00000000U

#define MSK_NX500_dpmas_db_mapping2_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_db_mapping2_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_db_mapping2_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_db_mapping2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_DB_MAPPING2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_db_mapping2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_DB_MAPPING2_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_DPMAS_DB_MAPPING2_BIT_T bf;
} NX500_DPMAS_DB_MAPPING2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_end3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_db_end3                                     0x00000058U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_db_end3 0x00103658U
#define Adr_NX500_dpmas_db_end3                                         0x00103658U
#define DFLT_VAL_NX500_dpmas_db_end3                                    0x00000000U

#define MSK_NX500_dpmas_db_end3_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_db_end3_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_db_end3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_db_end3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_DB_END3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_db_end3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_DB_END3_BIT_T;

typedef union {
	unsigned int              val;
	NX500_DPMAS_DB_END3_BIT_T bf;
} NX500_DPMAS_DB_END3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_mapping3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_db_mapping3                                     0x0000005CU
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_db_mapping3 0x0010365CU
#define Adr_NX500_dpmas_db_mapping3                                         0x0010365CU
#define DFLT_VAL_NX500_dpmas_db_mapping3                                    0x00000000U

#define MSK_NX500_dpmas_db_mapping3_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_db_mapping3_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_db_mapping3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_db_mapping3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_DB_MAPPING3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_db_mapping3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_DB_MAPPING3_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_DPMAS_DB_MAPPING3_BIT_T bf;
} NX500_DPMAS_DB_MAPPING3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_end4 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_db_end4                                     0x00000060U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_db_end4 0x00103660U
#define Adr_NX500_dpmas_db_end4                                         0x00103660U
#define DFLT_VAL_NX500_dpmas_db_end4                                    0x00000000U

#define MSK_NX500_dpmas_db_end4_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_db_end4_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_db_end4_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_db_end4_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_DB_END4_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_db_end4_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_DB_END4_BIT_T;

typedef union {
	unsigned int              val;
	NX500_DPMAS_DB_END4_BIT_T bf;
} NX500_DPMAS_DB_END4_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_mapping4 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_db_mapping4                                     0x00000064U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_db_mapping4 0x00103664U
#define Adr_NX500_dpmas_db_mapping4                                         0x00103664U
#define DFLT_VAL_NX500_dpmas_db_mapping4                                    0x00000000U

#define MSK_NX500_dpmas_db_mapping4_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_db_mapping4_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_db_mapping4_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_db_mapping4_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_DB_MAPPING4_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_db_mapping4_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_DB_MAPPING4_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_DPMAS_DB_MAPPING4_BIT_T bf;
} NX500_DPMAS_DB_MAPPING4_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_end5 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_db_end5                                     0x00000068U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_db_end5 0x00103668U
#define Adr_NX500_dpmas_db_end5                                         0x00103668U
#define DFLT_VAL_NX500_dpmas_db_end5                                    0x00000000U

#define MSK_NX500_dpmas_db_end5_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_db_end5_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_db_end5_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_db_end5_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_DB_END5_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_db_end5_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_DB_END5_BIT_T;

typedef union {
	unsigned int              val;
	NX500_DPMAS_DB_END5_BIT_T bf;
} NX500_DPMAS_DB_END5_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_mapping5 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_db_mapping5                                     0x0000006CU
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_db_mapping5 0x0010366CU
#define Adr_NX500_dpmas_db_mapping5                                         0x0010366CU
#define DFLT_VAL_NX500_dpmas_db_mapping5                                    0x00000000U

#define MSK_NX500_dpmas_db_mapping5_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_db_mapping5_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_db_mapping5_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_db_mapping5_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_DB_MAPPING5_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_db_mapping5_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_DB_MAPPING5_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_DPMAS_DB_MAPPING5_BIT_T bf;
} NX500_DPMAS_DB_MAPPING5_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_end6 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_db_end6                                     0x00000070U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_db_end6 0x00103670U
#define Adr_NX500_dpmas_db_end6                                         0x00103670U
#define DFLT_VAL_NX500_dpmas_db_end6                                    0x00000000U

#define MSK_NX500_dpmas_db_end6_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_db_end6_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_db_end6_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_db_end6_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_DB_END6_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_db_end6_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_DB_END6_BIT_T;

typedef union {
	unsigned int              val;
	NX500_DPMAS_DB_END6_BIT_T bf;
} NX500_DPMAS_DB_END6_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_mapping6 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_db_mapping6                                     0x00000074U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_db_mapping6 0x00103674U
#define Adr_NX500_dpmas_db_mapping6                                         0x00103674U
#define DFLT_VAL_NX500_dpmas_db_mapping6                                    0x00000000U

#define MSK_NX500_dpmas_db_mapping6_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_db_mapping6_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_db_mapping6_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_db_mapping6_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_DB_MAPPING6_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_db_mapping6_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_DB_MAPPING6_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_DPMAS_DB_MAPPING6_BIT_T bf;
} NX500_DPMAS_DB_MAPPING6_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_end7 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_db_end7                                     0x00000078U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_db_end7 0x00103678U
#define Adr_NX500_dpmas_db_end7                                         0x00103678U
#define DFLT_VAL_NX500_dpmas_db_end7                                    0x00000000U

#define MSK_NX500_dpmas_db_end7_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_db_end7_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_db_end7_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_db_end7_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_DB_END7_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_db_end7_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_DB_END7_BIT_T;

typedef union {
	unsigned int              val;
	NX500_DPMAS_DB_END7_BIT_T bf;
} NX500_DPMAS_DB_END7_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_mapping7 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_db_mapping7                                     0x0000007CU
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_db_mapping7 0x0010367CU
#define Adr_NX500_dpmas_db_mapping7                                         0x0010367CU
#define DFLT_VAL_NX500_dpmas_db_mapping7                                    0x00000000U

#define MSK_NX500_dpmas_db_mapping7_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_db_mapping7_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_db_mapping7_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_db_mapping7_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_DB_MAPPING7_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_db_mapping7_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_DB_MAPPING7_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_DPMAS_DB_MAPPING7_BIT_T bf;
} NX500_DPMAS_DB_MAPPING7_T;

/* --------------------------------------------------------------------- */
/* Register hs_ctrl */
/* => dpmas_hscr0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_hs_ctrl                                     0x00000080U
#define Adr_NX500_netx_controlled_global_register_block_2_hs_ctrl 0x00103680U
#define Adr_NX500_hs_ctrl                                         0x00103680U
#define DFLT_VAL_NX500_hs_ctrl                                    0x00000000U

#define MSK_NX500_hs_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_hs_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_hs_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_hs_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_HS_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_hs_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_HS_CTRL_BIT_T;

typedef union {
	unsigned int        val;
	NX500_HS_CTRL_BIT_T bf;
} NX500_HS_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_hscr1                                     0x00000084U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_hscr1 0x00103684U
#define Adr_NX500_dpmas_hscr1                                         0x00103684U
#define DFLT_VAL_NX500_dpmas_hscr1                                    0x00000000U

#define MSK_NX500_dpmas_hscr1_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_hscr1_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_hscr1_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_hscr1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_HSCR1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_hscr1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_HSCR1_BIT_T;

typedef union {
	unsigned int            val;
	NX500_DPMAS_HSCR1_BIT_T bf;
} NX500_DPMAS_HSCR1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_hscr2                                     0x00000088U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_hscr2 0x00103688U
#define Adr_NX500_dpmas_hscr2                                         0x00103688U
#define DFLT_VAL_NX500_dpmas_hscr2                                    0x00000000U

#define MSK_NX500_dpmas_hscr2_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_hscr2_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_hscr2_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_hscr2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_HSCR2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_hscr2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_HSCR2_BIT_T;

typedef union {
	unsigned int            val;
	NX500_DPMAS_HSCR2_BIT_T bf;
} NX500_DPMAS_HSCR2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_hscr3                                     0x0000008CU
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_hscr3 0x0010368CU
#define Adr_NX500_dpmas_hscr3                                         0x0010368CU
#define DFLT_VAL_NX500_dpmas_hscr3                                    0x00000000U

#define MSK_NX500_dpmas_hscr3_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_hscr3_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_hscr3_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_hscr3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_HSCR3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_hscr3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_HSCR3_BIT_T;

typedef union {
	unsigned int            val;
	NX500_DPMAS_HSCR3_BIT_T bf;
} NX500_DPMAS_HSCR3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr4 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_hscr4                                     0x00000090U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_hscr4 0x00103690U
#define Adr_NX500_dpmas_hscr4                                         0x00103690U
#define DFLT_VAL_NX500_dpmas_hscr4                                    0x00000000U

#define MSK_NX500_dpmas_hscr4_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_hscr4_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_hscr4_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_hscr4_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_HSCR4_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_hscr4_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_HSCR4_BIT_T;

typedef union {
	unsigned int            val;
	NX500_DPMAS_HSCR4_BIT_T bf;
} NX500_DPMAS_HSCR4_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr5 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_hscr5                                     0x00000094U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_hscr5 0x00103694U
#define Adr_NX500_dpmas_hscr5                                         0x00103694U
#define DFLT_VAL_NX500_dpmas_hscr5                                    0x00000000U

#define MSK_NX500_dpmas_hscr5_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_hscr5_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_hscr5_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_hscr5_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_HSCR5_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_hscr5_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_HSCR5_BIT_T;

typedef union {
	unsigned int            val;
	NX500_DPMAS_HSCR5_BIT_T bf;
} NX500_DPMAS_HSCR5_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr6 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_hscr6                                     0x00000098U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_hscr6 0x00103698U
#define Adr_NX500_dpmas_hscr6                                         0x00103698U
#define DFLT_VAL_NX500_dpmas_hscr6                                    0x00000000U

#define MSK_NX500_dpmas_hscr6_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_hscr6_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_hscr6_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_hscr6_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_HSCR6_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_hscr6_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_HSCR6_BIT_T;

typedef union {
	unsigned int            val;
	NX500_DPMAS_HSCR6_BIT_T bf;
} NX500_DPMAS_HSCR6_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr7 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_hscr7                                     0x0000009CU
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_hscr7 0x0010369CU
#define Adr_NX500_dpmas_hscr7                                         0x0010369CU
#define DFLT_VAL_NX500_dpmas_hscr7                                    0x00000000U

#define MSK_NX500_dpmas_hscr7_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_hscr7_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_hscr7_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_hscr7_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_HSCR7_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_hscr7_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_HSCR7_BIT_T;

typedef union {
	unsigned int            val;
	NX500_DPMAS_HSCR7_BIT_T bf;
} NX500_DPMAS_HSCR7_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr8 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_hscr8                                     0x000000A0U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_hscr8 0x001036A0U
#define Adr_NX500_dpmas_hscr8                                         0x001036A0U
#define DFLT_VAL_NX500_dpmas_hscr8                                    0x00000000U

#define MSK_NX500_dpmas_hscr8_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_hscr8_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_hscr8_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_hscr8_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_HSCR8_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_hscr8_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_HSCR8_BIT_T;

typedef union {
	unsigned int            val;
	NX500_DPMAS_HSCR8_BIT_T bf;
} NX500_DPMAS_HSCR8_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr9 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_hscr9                                     0x000000A4U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_hscr9 0x001036A4U
#define Adr_NX500_dpmas_hscr9                                         0x001036A4U
#define DFLT_VAL_NX500_dpmas_hscr9                                    0x00000000U

#define MSK_NX500_dpmas_hscr9_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_hscr9_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_hscr9_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_hscr9_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_HSCR9_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_hscr9_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_HSCR9_BIT_T;

typedef union {
	unsigned int            val;
	NX500_DPMAS_HSCR9_BIT_T bf;
} NX500_DPMAS_HSCR9_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr10 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_hscr10                                     0x000000A8U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_hscr10 0x001036A8U
#define Adr_NX500_dpmas_hscr10                                         0x001036A8U
#define DFLT_VAL_NX500_dpmas_hscr10                                    0x00000000U

#define MSK_NX500_dpmas_hscr10_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_hscr10_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_hscr10_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_hscr10_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_HSCR10_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_hscr10_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_HSCR10_BIT_T;

typedef union {
	unsigned int             val;
	NX500_DPMAS_HSCR10_BIT_T bf;
} NX500_DPMAS_HSCR10_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr11 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_hscr11                                     0x000000ACU
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_hscr11 0x001036ACU
#define Adr_NX500_dpmas_hscr11                                         0x001036ACU
#define DFLT_VAL_NX500_dpmas_hscr11                                    0x00000000U

#define MSK_NX500_dpmas_hscr11_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_hscr11_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_hscr11_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_hscr11_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_HSCR11_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_hscr11_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_HSCR11_BIT_T;

typedef union {
	unsigned int             val;
	NX500_DPMAS_HSCR11_BIT_T bf;
} NX500_DPMAS_HSCR11_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr12 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_hscr12                                     0x000000B0U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_hscr12 0x001036B0U
#define Adr_NX500_dpmas_hscr12                                         0x001036B0U
#define DFLT_VAL_NX500_dpmas_hscr12                                    0x00000000U

#define MSK_NX500_dpmas_hscr12_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_hscr12_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_hscr12_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_hscr12_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_HSCR12_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_hscr12_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_HSCR12_BIT_T;

typedef union {
	unsigned int             val;
	NX500_DPMAS_HSCR12_BIT_T bf;
} NX500_DPMAS_HSCR12_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr13 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_hscr13                                     0x000000B4U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_hscr13 0x001036B4U
#define Adr_NX500_dpmas_hscr13                                         0x001036B4U
#define DFLT_VAL_NX500_dpmas_hscr13                                    0x00000000U

#define MSK_NX500_dpmas_hscr13_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_hscr13_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_hscr13_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_hscr13_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_HSCR13_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_hscr13_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_HSCR13_BIT_T;

typedef union {
	unsigned int             val;
	NX500_DPMAS_HSCR13_BIT_T bf;
} NX500_DPMAS_HSCR13_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr14 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_hscr14                                     0x000000B8U
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_hscr14 0x001036B8U
#define Adr_NX500_dpmas_hscr14                                         0x001036B8U
#define DFLT_VAL_NX500_dpmas_hscr14                                    0x00000000U

#define MSK_NX500_dpmas_hscr14_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_hscr14_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_hscr14_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_hscr14_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_HSCR14_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_hscr14_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_HSCR14_BIT_T;

typedef union {
	unsigned int             val;
	NX500_DPMAS_HSCR14_BIT_T bf;
} NX500_DPMAS_HSCR14_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr15 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_hscr15                                     0x000000BCU
#define Adr_NX500_netx_controlled_global_register_block_2_dpmas_hscr15 0x001036BCU
#define Adr_NX500_dpmas_hscr15                                         0x001036BCU
#define DFLT_VAL_NX500_dpmas_hscr15                                    0x00000000U

#define MSK_NX500_dpmas_hscr15_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_hscr15_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_hscr15_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_hscr15_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_HSCR15_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_hscr15_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_HSCR15_BIT_T;

typedef union {
	unsigned int             val;
	NX500_DPMAS_HSCR15_BIT_T bf;
} NX500_DPMAS_HSCR15_T;


/* ===================================================================== */

/* Area of netx_controlled_pci_configuration_shadow_register_block */

/* ===================================================================== */

#define Addr_NX500_netx_controlled_pci_configuration_shadow_register_block 0x00103700U

/* --------------------------------------------------------------------- */
/* Register pci_regs_addr */
/* => dpmas_pci_conf_rd_ctrl */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pci_regs_addr                                                     0x00000000U
#define Adr_NX500_netx_controlled_pci_configuration_shadow_register_block_pci_regs_addr 0x00103700U
#define Adr_NX500_pci_regs_addr                                                         0x00103700U
#define DFLT_VAL_NX500_pci_regs_addr                                                    0x00000000U

#define MSK_NX500_pci_regs_addr_keine_ahnung      0xffffffffU
#define SRT_NX500_pci_regs_addr_keine_ahnung      0
#define DFLT_VAL_NX500_pci_regs_addr_keine_ahnung 0x00000000U

enum {
	BFW_NX500_pci_regs_addr_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_PCI_REGS_ADDR_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_pci_regs_addr_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_PCI_REGS_ADDR_BIT_T;

typedef union {
	unsigned int              val;
	NX500_PCI_REGS_ADDR_BIT_T bf;
} NX500_PCI_REGS_ADDR_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_pci_conf_rd_data */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_pci_conf_rd_data                                                     0x00000004U
#define Adr_NX500_netx_controlled_pci_configuration_shadow_register_block_dpmas_pci_conf_rd_data 0x00103704U
#define Adr_NX500_dpmas_pci_conf_rd_data                                                         0x00103704U
#define DFLT_VAL_NX500_dpmas_pci_conf_rd_data                                                    0x00000000U

#define MSK_NX500_dpmas_pci_conf_rd_data_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_pci_conf_rd_data_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_pci_conf_rd_data_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_pci_conf_rd_data_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_PCI_CONF_RD_DATA_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_pci_conf_rd_data_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_PCI_CONF_RD_DATA_BIT_T;

typedef union {
	unsigned int                       val;
	NX500_DPMAS_PCI_CONF_RD_DATA_BIT_T bf;
} NX500_DPMAS_PCI_CONF_RD_DATA_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_pci_conf_wr_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_pci_conf_wr_ctrl                                                     0x00000008U
#define Adr_NX500_netx_controlled_pci_configuration_shadow_register_block_dpmas_pci_conf_wr_ctrl 0x00103708U
#define Adr_NX500_dpmas_pci_conf_wr_ctrl                                                         0x00103708U
#define DFLT_VAL_NX500_dpmas_pci_conf_wr_ctrl                                                    0x00000000U

#define MSK_NX500_dpmas_pci_conf_wr_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_pci_conf_wr_ctrl_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_pci_conf_wr_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_pci_conf_wr_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_PCI_CONF_WR_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_pci_conf_wr_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_PCI_CONF_WR_CTRL_BIT_T;

typedef union {
	unsigned int                       val;
	NX500_DPMAS_PCI_CONF_WR_CTRL_BIT_T bf;
} NX500_DPMAS_PCI_CONF_WR_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_pci_conf_wr_data */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_dpmas_pci_conf_wr_data                                                     0x0000000CU
#define Adr_NX500_netx_controlled_pci_configuration_shadow_register_block_dpmas_pci_conf_wr_data 0x0010370CU
#define Adr_NX500_dpmas_pci_conf_wr_data                                                         0x0010370CU
#define DFLT_VAL_NX500_dpmas_pci_conf_wr_data                                                    0x00000000U

#define MSK_NX500_dpmas_pci_conf_wr_data_keine_ahnung      0xffffffffU
#define SRT_NX500_dpmas_pci_conf_wr_data_keine_ahnung      0
#define DFLT_VAL_NX500_dpmas_pci_conf_wr_data_keine_ahnung 0x00000000U

enum {
	BFW_NX500_dpmas_pci_conf_wr_data_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX500_DPMAS_PCI_CONF_WR_DATA_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX500_dpmas_pci_conf_wr_data_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX500_DPMAS_PCI_CONF_WR_DATA_BIT_T;

typedef union {
	unsigned int                       val;
	NX500_DPMAS_PCI_CONF_WR_DATA_BIT_T bf;
} NX500_DPMAS_PCI_CONF_WR_DATA_T;


/* ===================================================================== */

/* Area of lcd_ctrl */

/* ===================================================================== */

#define Addr_NX500_lcd_ctrl 0x00104000U
#define NX500_NETX_LCD_AREA 0x00104000U

/* --------------------------------------------------------------------- */
/* Register LCDTiming0 */
/* => LCD Timing 0 Register */
/*    This register controls the Horizontal Sync width, Horizontal Front porch and Horizontal */
/*    Back porch period. The data path latency forces some restrictions on the usable minimum */
/*    values for horizontal porch width in STN mode. The minimum values are HSW = 2 and HBP = 2. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_LCDTiming0      0x00000000U
#define Adr_NX500_lcd_ctrl_LCDTiming0 0x00104000U
#define Adr_NX500_LCDTiming0          0x00104000U
#define DFLT_VAL_NX500_LCDTiming0     0x00000000U

#define MSK_NX500_LCDTiming0_unused      0x00000003U
#define SRT_NX500_LCDTiming0_unused      0
#define DFLT_VAL_NX500_LCDTiming0_unused 0x00000000U
#define MSK_NX500_LCDTiming0_PPL         0x000000fcU
#define SRT_NX500_LCDTiming0_PPL         2
#define DFLT_VAL_NX500_LCDTiming0_PPL    0x00000000U
#define MSK_NX500_LCDTiming0_HSW         0x0000ff00U
#define SRT_NX500_LCDTiming0_HSW         8
#define DFLT_VAL_NX500_LCDTiming0_HSW    0x00000000U
#define MSK_NX500_LCDTiming0_HFP         0x00ff0000U
#define SRT_NX500_LCDTiming0_HFP         16
#define DFLT_VAL_NX500_LCDTiming0_HFP    0x00000000U
#define MSK_NX500_LCDTiming0_HBP         0xff000000U
#define SRT_NX500_LCDTiming0_HBP         24
#define DFLT_VAL_NX500_LCDTiming0_HBP    0x00000000U

enum {
	BFW_NX500_LCDTiming0_unused = 2, /* [1:0] */
	BFW_NX500_LCDTiming0_PPL    = 6, /* [7:2] */
	BFW_NX500_LCDTiming0_HSW    = 8, /* [15:8] */
	BFW_NX500_LCDTiming0_HFP    = 8, /* [23:16] */
	BFW_NX500_LCDTiming0_HBP    = 8  /* [31:24] */
};

typedef struct NX500_LCDTIMING0_BIT_Ttag {
	unsigned int unused : BFW_NX500_LCDTiming0_unused; /* reserved                                                                              */
	unsigned int PPL    : BFW_NX500_LCDTiming0_PPL;    /* Pixels per line                                                                       */
	                                                   /* Actual Pixels-per-line = 16 (PPL+1)                                                   */
	unsigned int HSW    : BFW_NX500_LCDTiming0_HSW;    /* Horizontal Sync Pulse Width                                                           */
	                                                   /* Width of the LLP signal in CLCP periods. Program with value minus 1.                  */
	unsigned int HFP    : BFW_NX500_LCDTiming0_HFP;    /* Horizontal Front Porch                                                                */
	                                                   /* Number of CLCP periods between the end of active data and the rising edge of CLCP.    */
	unsigned int HBP    : BFW_NX500_LCDTiming0_HBP;    /* Horizontal Back Porch                                                                 */
	                                                   /* Number of CLCP periods between the falling edge of CLCP and the start of active data. */
} NX500_LCDTIMING0_BIT_T;

typedef union {
	unsigned int           val;
	NX500_LCDTIMING0_BIT_T bf;
} NX500_LCDTIMING0_T;

/* --------------------------------------------------------------------- */
/* Register LCDTiming1 */
/* => LCD Timing 1 Register */
/*    This register controls the Lines per screen, Vertical Sync width, Vertical Front porch and Vertical */
/*    Back porch period. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_LCDTiming1      0x00000004U
#define Adr_NX500_lcd_ctrl_LCDTiming1 0x00104004U
#define Adr_NX500_LCDTiming1          0x00104004U
#define DFLT_VAL_NX500_LCDTiming1     0x00000000U

#define MSK_NX500_LCDTiming1_LPP      0x000003ffU
#define SRT_NX500_LCDTiming1_LPP      0
#define DFLT_VAL_NX500_LCDTiming1_LPP 0x00000000U
#define MSK_NX500_LCDTiming1_VSW      0x0000fc00U
#define SRT_NX500_LCDTiming1_VSW      10
#define DFLT_VAL_NX500_LCDTiming1_VSW 0x00000000U
#define MSK_NX500_LCDTiming1_VFP      0x00ff0000U
#define SRT_NX500_LCDTiming1_VFP      16
#define DFLT_VAL_NX500_LCDTiming1_VFP 0x00000000U
#define MSK_NX500_LCDTiming1_VBP      0xff000000U
#define SRT_NX500_LCDTiming1_VBP      24
#define DFLT_VAL_NX500_LCDTiming1_VBP 0x00000000U

enum {
	BFW_NX500_LCDTiming1_LPP = 10, /* [9:0] */
	BFW_NX500_LCDTiming1_VSW = 6,  /* [15:10] */
	BFW_NX500_LCDTiming1_VFP = 8,  /* [23:16] */
	BFW_NX500_LCDTiming1_VBP = 8   /* [31:24] */
};

typedef struct NX500_LCDTIMING1_BIT_Ttag {
	unsigned int LPP : BFW_NX500_LCDTiming1_LPP; /* Lines per panel                                                                     */
	                                             /* Number of active lines per screen. Program to number of lines required minus 1.     */
	unsigned int VSW : BFW_NX500_LCDTiming1_VSW; /* Vertical Sync Pulse Width                                                           */
	                                             /* Number of Hsync lines. Should be small (e.g. program to zero) for passive STN LCDs. */
	unsigned int VFP : BFW_NX500_LCDTiming1_VFP; /* Vertical Front Porch                                                                */
	                                             /* Number of inactive lines at the end of the frame, before Vsync period.              */
	unsigned int VBP : BFW_NX500_LCDTiming1_VBP; /* Vertical Back Porch                                                                 */
	                                             /* Number of inactive lines at the start of the frame, after Vsync period.             */
} NX500_LCDTIMING1_BIT_T;

typedef union {
	unsigned int           val;
	NX500_LCDTIMING1_BIT_T bf;
} NX500_LCDTIMING1_T;

/* --------------------------------------------------------------------- */
/* Register LCDTiming2 */
/* => LCD Timing 2 Register */
/*    The data path latency forces some restrictions on the usable minimum values for the panel clock */
/*    divider in STN modes. */
/*     Single panel colour mode:               PCD =  1 (CLCP = CLCDCLK/3) */
/*     Dual panel colour mode:                 PCD =  4 (CLCP = CLCDCLK/6) */
/*     Single panel mono 4-bit interface mode: PCD =  2 (CLCP = CLCDCLK/4) */
/*     Dual panel mono 4-bit interface mode:   PCD =  6 (CLCP = CLCDCLK/8) */
/*     Single panel mono 8-bit interface mode: PCD =  6 (CLCP = CLCDCLK/8) */
/*     Dual panel mono 8-bit interface mode:   PCD = 14 (CLCP = CLCDCLK/16) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_LCDTiming2      0x00000008U
#define Adr_NX500_lcd_ctrl_LCDTiming2 0x00104008U
#define Adr_NX500_LCDTiming2          0x00104008U
#define DFLT_VAL_NX500_LCDTiming2     0x00000000U

#define MSK_NX500_LCDTiming2_PCD_LO      0x0000001fU
#define SRT_NX500_LCDTiming2_PCD_LO      0
#define DFLT_VAL_NX500_LCDTiming2_PCD_LO 0x00000000U
#define MSK_NX500_LCDTiming2_CLKSEL      0x00000020U
#define SRT_NX500_LCDTiming2_CLKSEL      5
#define DFLT_VAL_NX500_LCDTiming2_CLKSEL 0x00000000U
#define MSK_NX500_LCDTiming2_ACB         0x000007c0U
#define SRT_NX500_LCDTiming2_ACB         6
#define DFLT_VAL_NX500_LCDTiming2_ACB    0x00000000U
#define MSK_NX500_LCDTiming2_IVS         0x00000800U
#define SRT_NX500_LCDTiming2_IVS         11
#define DFLT_VAL_NX500_LCDTiming2_IVS    0x00000000U
#define MSK_NX500_LCDTiming2_IHS         0x00001000U
#define SRT_NX500_LCDTiming2_IHS         12
#define DFLT_VAL_NX500_LCDTiming2_IHS    0x00000000U
#define MSK_NX500_LCDTiming2_IPC         0x00002000U
#define SRT_NX500_LCDTiming2_IPC         13
#define DFLT_VAL_NX500_LCDTiming2_IPC    0x00000000U
#define MSK_NX500_LCDTiming2_IEO         0x00004000U
#define SRT_NX500_LCDTiming2_IEO         14
#define DFLT_VAL_NX500_LCDTiming2_IEO    0x00000000U
#define MSK_NX500_LCDTiming2_CPL         0x03ff0000U
#define SRT_NX500_LCDTiming2_CPL         16
#define DFLT_VAL_NX500_LCDTiming2_CPL    0x00000000U
#define MSK_NX500_LCDTiming2_BCD         0x04000000U
#define SRT_NX500_LCDTiming2_BCD         26
#define DFLT_VAL_NX500_LCDTiming2_BCD    0x00000000U
#define MSK_NX500_LCDTiming2_PCD_HI      0xf8000000U
#define SRT_NX500_LCDTiming2_PCD_HI      27
#define DFLT_VAL_NX500_LCDTiming2_PCD_HI 0x00000000U

enum {
	BFW_NX500_LCDTiming2_PCD_LO    = 5,  /* [4:0] */
	BFW_NX500_LCDTiming2_CLKSEL    = 1,  /* [5] */
	BFW_NX500_LCDTiming2_ACB       = 5,  /* [10:6] */
	BFW_NX500_LCDTiming2_IVS       = 1,  /* [11] */
	BFW_NX500_LCDTiming2_IHS       = 1,  /* [12] */
	BFW_NX500_LCDTiming2_IPC       = 1,  /* [13] */
	BFW_NX500_LCDTiming2_IEO       = 1,  /* [14] */
	BFW_NX500_LCDTiming2_reserved1 = 1,  /* [15] */
	BFW_NX500_LCDTiming2_CPL       = 10, /* [25:16] */
	BFW_NX500_LCDTiming2_BCD       = 1,  /* [26] */
	BFW_NX500_LCDTiming2_PCD_HI    = 5   /* [31:27] */
};

typedef struct NX500_LCDTIMING2_BIT_Ttag {
	unsigned int PCD_LO    : BFW_NX500_LCDTiming2_PCD_LO;    /* Panel clock divisor - lower 5-bits                                                              */
	                                                         /* Used to specify the frequency of the LCD panel (CLCP) clock based on the LCD clock              */
	unsigned int CLKSEL    : BFW_NX500_LCDTiming2_CLKSEL;    /* This bit drives the CLCDCLKSEL signal, which is used as a select     # default 0                */
	                                                         /* signal for the external LCD clock MUX.                                                          */
	unsigned int ACB       : BFW_NX500_LCDTiming2_ACB;       /* AC Bias Pin Frequency                                                                           */
	                                                         /* Number of line clocks to count before toggling the AC Bias pin. This pin is used to             */
	unsigned int IVS       : BFW_NX500_LCDTiming2_IVS;       /* Invert Vsync                                                                                    */
	                                                         /*  0 : CLFP pin is active HIGH and inactive LOW.                                                  */
	unsigned int IHS       : BFW_NX500_LCDTiming2_IHS;       /* Invert Hsync                                                                                    */
	                                                         /*  0 : CLLP pin is active HIGH and inactive LOW.                                                  */
	unsigned int IPC       : BFW_NX500_LCDTiming2_IPC;       /* Invert Panel clock                                                                              */
	                                                         /*  0 : Data is driven on the LCDs data lines on the rising-edge of CLCP.                          */
	unsigned int IEO       : BFW_NX500_LCDTiming2_IEO;       /* Invert Output Enable                                                                            */
	                                                         /*  0 : CLAC pin is active HIGH in TFT mode.                                                       */
	unsigned int reserved1 : BFW_NX500_LCDTiming2_reserved1; /* reserved                                                                                        */
	unsigned int CPL       : BFW_NX500_LCDTiming2_CPL;       /* Clocks Per Line                                                                                 */
	                                                         /* This field specifies the number of actual CLCP clocks to the LCD panel on each line.            */
	unsigned int BCD       : BFW_NX500_LCDTiming2_BCD;       /* Bypass Pixel Clock Divider                                                                      */
	                                                         /* Setting this to 1 bypasses the pixel clock divider logic. This is mainly used for TFT displays. */
	unsigned int PCD_HI    : BFW_NX500_LCDTiming2_PCD_HI;    /* Panel clock divisor - upper 5-bits                                                              */
	                                                         /* Used to specify the frequency of the LCD panel (CLCP) clock based on the LCD clock              */
} NX500_LCDTIMING2_BIT_T;

typedef union {
	unsigned int           val;
	NX500_LCDTIMING2_BIT_T bf;
} NX500_LCDTIMING2_T;

/* --------------------------------------------------------------------- */
/* Register LCDTiming3 */
/* => LCD Timing 3 Register */
/*    This register controls the Line-End signal. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_LCDTiming3      0x0000000CU
#define Adr_NX500_lcd_ctrl_LCDTiming3 0x0010400CU
#define Adr_NX500_LCDTiming3          0x0010400CU
#define DFLT_VAL_NX500_LCDTiming3     0x00000000U

#define MSK_NX500_LCDTiming3_LED      0x0000007fU
#define SRT_NX500_LCDTiming3_LED      0
#define DFLT_VAL_NX500_LCDTiming3_LED 0x00000000U
#define MSK_NX500_LCDTiming3_LEE      0x00010000U
#define SRT_NX500_LCDTiming3_LEE      16
#define DFLT_VAL_NX500_LCDTiming3_LEE 0x00000000U

enum {
	BFW_NX500_LCDTiming3_LED       = 7,  /* [6:0] */
	BFW_NX500_LCDTiming3_reserved1 = 9,  /* [15:7] */
	BFW_NX500_LCDTiming3_LEE       = 1,  /* [16] */
	BFW_NX500_LCDTiming3_reserved2 = 15  /* [31:17] */
};

typedef struct NX500_LCDTIMING3_BIT_Ttag {
	unsigned int LED       : BFW_NX500_LCDTiming3_LED;       /* Line-End signal delay from the rising edge of the last panel clock (CLCP) */
	unsigned int reserved1 : BFW_NX500_LCDTiming3_reserved1; /* reserved                                                                  */
	unsigned int LEE       : BFW_NX500_LCDTiming3_LEE;       /* LCD Line end enable                                                       */
	                                                         /*  0 : CLLE disabled (held low)                                             */
	unsigned int reserved2 : BFW_NX500_LCDTiming3_reserved2; /* reserved                                                                  */
} NX500_LCDTIMING3_BIT_T;

typedef union {
	unsigned int           val;
	NX500_LCDTIMING3_BIT_T bf;
} NX500_LCDTIMING3_T;

/* --------------------------------------------------------------------- */
/* Register LCDUPBASE */
/* => LCD Upper panel DMA Channel Base Address */
/*    This is a register to program the upper base address of the frame buffer. The base address is word aligned, hence only */
/*    the bits 31:2 are used. LCDUPBASE is used for TFT and single panel STN displays, and also the upper panel of dual panel */
/*    STN displays. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_LCDUPBASE      0x00000010U
#define Adr_NX500_lcd_ctrl_LCDUPBASE 0x00104010U
#define Adr_NX500_LCDUPBASE          0x00104010U
#define DFLT_VAL_NX500_LCDUPBASE     0x00000000U

#define MSK_NX500_LCDUPBASE_LCDUPBASE      0xfffffffcU
#define SRT_NX500_LCDUPBASE_LCDUPBASE      2
#define DFLT_VAL_NX500_LCDUPBASE_LCDUPBASE 0x00000000U

enum {
	BFW_NX500_LCDUPBASE_reserved1 = 2,  /* [1:0] */
	BFW_NX500_LCDUPBASE_LCDUPBASE = 30  /* [31:2] */
};

typedef struct NX500_LCDUPBASE_BIT_Ttag {
	unsigned int reserved1 : BFW_NX500_LCDUPBASE_reserved1; /* reserved                         */
	unsigned int LCDUPBASE : BFW_NX500_LCDUPBASE_LCDUPBASE; /* Upper panel channel base address */
} NX500_LCDUPBASE_BIT_T;

typedef union {
	unsigned int          val;
	NX500_LCDUPBASE_BIT_T bf;
} NX500_LCDUPBASE_T;

/* --------------------------------------------------------------------- */
/* Register LCDLPBASE */
/* => LCD Lower panel DMA Channel Base Address */
/*    This is a register to program the lower base address of the frame buffer. The base address is word aligned, hence only */
/*    the bits 31:2 are used. LCDLPBASE is used for the lower panel of dual panel STN displays. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_LCDLPBASE      0x00000014U
#define Adr_NX500_lcd_ctrl_LCDLPBASE 0x00104014U
#define Adr_NX500_LCDLPBASE          0x00104014U
#define DFLT_VAL_NX500_LCDLPBASE     0x00000000U

#define MSK_NX500_LCDLPBASE_LCDLPBASE      0xfffffffcU
#define SRT_NX500_LCDLPBASE_LCDLPBASE      2
#define DFLT_VAL_NX500_LCDLPBASE_LCDLPBASE 0x00000000U

enum {
	BFW_NX500_LCDLPBASE_reserved1 = 2,  /* [1:0] */
	BFW_NX500_LCDLPBASE_LCDLPBASE = 30  /* [31:2] */
};

typedef struct NX500_LCDLPBASE_BIT_Ttag {
	unsigned int reserved1 : BFW_NX500_LCDLPBASE_reserved1; /* reserved                         */
	unsigned int LCDLPBASE : BFW_NX500_LCDLPBASE_LCDLPBASE; /* Lower panel channel base address */
} NX500_LCDLPBASE_BIT_T;

typedef union {
	unsigned int          val;
	NX500_LCDLPBASE_BIT_T bf;
} NX500_LCDLPBASE_T;

/* --------------------------------------------------------------------- */
/* Register LCDIMSC */
/* => LCD Interrupt Mask Set/Clear Register */
/*    The interrupt enable register contains bits, which corresponds directly to those in the interrupt status register. */
/*    If a bit is set in this register than the colour LCD interrupt bit in the system interrupt controller will be asserted */
/*    if the corresponding bit is set in the status register. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_LCDIMSC      0x00000018U
#define Adr_NX500_lcd_ctrl_LCDIMSC 0x00104018U
#define Adr_NX500_LCDIMSC          0x00104018U
#define DFLT_VAL_NX500_LCDIMSC     0x00000000U

#define MSK_NX500_LCDIMSC_Unused               0x00000001U
#define SRT_NX500_LCDIMSC_Unused               0
#define DFLT_VAL_NX500_LCDIMSC_Unused          0x00000000U
#define MSK_NX500_LCDIMSC_CLCDFUFINTREN        0x00000002U
#define SRT_NX500_LCDIMSC_CLCDFUFINTREN        1
#define DFLT_VAL_NX500_LCDIMSC_CLCDFUFINTREN   0x00000000U
#define MSK_NX500_LCDIMSC_CLCDLNBUINTREN       0x00000004U
#define SRT_NX500_LCDIMSC_CLCDLNBUINTREN       2
#define DFLT_VAL_NX500_LCDIMSC_CLCDLNBUINTREN  0x00000000U
#define MSK_NX500_LCDIMSC_CLCDVCOMPINTREN      0x00000008U
#define SRT_NX500_LCDIMSC_CLCDVCOMPINTREN      3
#define DFLT_VAL_NX500_LCDIMSC_CLCDVCOMPINTREN 0x00000000U
#define MSK_NX500_LCDIMSC_CLCDMBEINTREN        0x00000010U
#define SRT_NX500_LCDIMSC_CLCDMBEINTREN        4
#define DFLT_VAL_NX500_LCDIMSC_CLCDMBEINTREN   0x00000000U

enum {
	BFW_NX500_LCDIMSC_Unused          = 1,  /* [0] */
	BFW_NX500_LCDIMSC_CLCDFUFINTREN   = 1,  /* [1] */
	BFW_NX500_LCDIMSC_CLCDLNBUINTREN  = 1,  /* [2] */
	BFW_NX500_LCDIMSC_CLCDVCOMPINTREN = 1,  /* [3] */
	BFW_NX500_LCDIMSC_CLCDMBEINTREN   = 1,  /* [4] */
	BFW_NX500_LCDIMSC_reserved1       = 27  /* [31:5] */
};

typedef struct NX500_LCDIMSC_BIT_Ttag {
	unsigned int Unused          : BFW_NX500_LCDIMSC_Unused;          /* Unused                                        */
	unsigned int CLCDFUFINTREN   : BFW_NX500_LCDIMSC_CLCDFUFINTREN;   /* DMA FIFO underflow interrupt enable           */
	unsigned int CLCDLNBUINTREN  : BFW_NX500_LCDIMSC_CLCDLNBUINTREN;  /* LCD next address base update interrupt enable */
	unsigned int CLCDVCOMPINTREN : BFW_NX500_LCDIMSC_CLCDVCOMPINTREN; /* Vertical compare interrupt enable             */
	unsigned int CLCDMBEINTREN   : BFW_NX500_LCDIMSC_CLCDMBEINTREN;   /* AHB master error interrupt enable             */
	unsigned int reserved1       : BFW_NX500_LCDIMSC_reserved1;       /* reserved                                      */
} NX500_LCDIMSC_BIT_T;

typedef union {
	unsigned int        val;
	NX500_LCDIMSC_BIT_T bf;
} NX500_LCDIMSC_T;

/* --------------------------------------------------------------------- */
/* Register LCDControl */
/* => LCD Control Register */
/*    This register controls the mode in which the LCD controller operates. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_LCDControl      0x0000001CU
#define Adr_NX500_lcd_ctrl_LCDControl 0x0010401CU
#define Adr_NX500_LCDControl          0x0010401CU
#define DFLT_VAL_NX500_LCDControl     0x00000000U

#define MSK_NX500_LCDControl_LcdEn          0x00000001U
#define SRT_NX500_LCDControl_LcdEn          0
#define DFLT_VAL_NX500_LCDControl_LcdEn     0x00000000U
#define MSK_NX500_LCDControl_LcdBpp         0x0000000eU
#define SRT_NX500_LCDControl_LcdBpp         1
#define DFLT_VAL_NX500_LCDControl_LcdBpp    0x00000000U
#define MSK_NX500_LCDControl_LcdBW          0x00000010U
#define SRT_NX500_LCDControl_LcdBW          4
#define DFLT_VAL_NX500_LCDControl_LcdBW     0x00000000U
#define MSK_NX500_LCDControl_LcdTFT         0x00000020U
#define SRT_NX500_LCDControl_LcdTFT         5
#define DFLT_VAL_NX500_LCDControl_LcdTFT    0x00000000U
#define MSK_NX500_LCDControl_LcdMono8       0x00000040U
#define SRT_NX500_LCDControl_LcdMono8       6
#define DFLT_VAL_NX500_LCDControl_LcdMono8  0x00000000U
#define MSK_NX500_LCDControl_LcdDual        0x00000080U
#define SRT_NX500_LCDControl_LcdDual        7
#define DFLT_VAL_NX500_LCDControl_LcdDual   0x00000000U
#define MSK_NX500_LCDControl_BGR            0x00000100U
#define SRT_NX500_LCDControl_BGR            8
#define DFLT_VAL_NX500_LCDControl_BGR       0x00000000U
#define MSK_NX500_LCDControl_BEBO           0x00000200U
#define SRT_NX500_LCDControl_BEBO           9
#define DFLT_VAL_NX500_LCDControl_BEBO      0x00000000U
#define MSK_NX500_LCDControl_BEPO           0x00000400U
#define SRT_NX500_LCDControl_BEPO           10
#define DFLT_VAL_NX500_LCDControl_BEPO      0x00000000U
#define MSK_NX500_LCDControl_LcdPwr         0x00000800U
#define SRT_NX500_LCDControl_LcdPwr         11
#define DFLT_VAL_NX500_LCDControl_LcdPwr    0x00000000U
#define MSK_NX500_LCDControl_LcdVComp       0x00003000U
#define SRT_NX500_LCDControl_LcdVComp       12
#define DFLT_VAL_NX500_LCDControl_LcdVComp  0x00000000U
#define MSK_NX500_LCDControl_WATERMARK      0x00010000U
#define SRT_NX500_LCDControl_WATERMARK      16
#define DFLT_VAL_NX500_LCDControl_WATERMARK 0x00000000U

enum {
	BFW_NX500_LCDControl_LcdEn     = 1,  /* [0] */
	BFW_NX500_LCDControl_LcdBpp    = 3,  /* [3:1] */
	BFW_NX500_LCDControl_LcdBW     = 1,  /* [4] */
	BFW_NX500_LCDControl_LcdTFT    = 1,  /* [5] */
	BFW_NX500_LCDControl_LcdMono8  = 1,  /* [6] */
	BFW_NX500_LCDControl_LcdDual   = 1,  /* [7] */
	BFW_NX500_LCDControl_BGR       = 1,  /* [8] */
	BFW_NX500_LCDControl_BEBO      = 1,  /* [9] */
	BFW_NX500_LCDControl_BEPO      = 1,  /* [10] */
	BFW_NX500_LCDControl_LcdPwr    = 1,  /* [11] */
	BFW_NX500_LCDControl_LcdVComp  = 2,  /* [13:12] */
	BFW_NX500_LCDControl_reserved1 = 2,  /* [15:14] */
	BFW_NX500_LCDControl_WATERMARK = 1,  /* [16] */
	BFW_NX500_LCDControl_reserved2 = 15  /* [31:17] */
};

typedef struct NX500_LCDCONTROL_BIT_Ttag {
	unsigned int LcdEn     : BFW_NX500_LCDControl_LcdEn;     /* LCD Controller Enable                                          */
	                                                         /*  0 : LCD Controller disabled                                   */
	unsigned int LcdBpp    : BFW_NX500_LCDControl_LcdBpp;    /* LCD Bits Per Pixel                                             */
	                                                         /*  000 :  1 bpp                                                  */
	unsigned int LcdBW     : BFW_NX500_LCDControl_LcdBW;     /* STN LCD is monochrome (black and white)                        */
	                                                         /*  0 : STN is colour                                             */
	unsigned int LcdTFT    : BFW_NX500_LCDControl_LcdTFT;    /* LCD is TFT                                                     */
	                                                         /*  0 : LCD is an STN display - use greyscaler                    */
	unsigned int LcdMono8  : BFW_NX500_LCDControl_LcdMono8;  /* Monochrome LCD has 8 bit interface                             */
	                                                         /* This bit controls whether monochrome STN LCD uses a 4 or 8 bit */
	unsigned int LcdDual   : BFW_NX500_LCDControl_LcdDual;   /* LCD interface is dual panel. This should only be used for STN  */
	                                                         /* panels, when TFT is 0.                                         */
	unsigned int BGR       : BFW_NX500_LCDControl_BGR;       /* Swap red and blue output                                       */
	                                                         /*  0 : RGB normal output                                         */
	unsigned int BEBO      : BFW_NX500_LCDControl_BEBO;      /* Big Endian Byte Order                                          */
	                                                         /*  0 : Little endian byte order                                  */
	unsigned int BEPO      : BFW_NX500_LCDControl_BEPO;      /* Big endian pixel ordering within a byte                        */
	                                                         /*  0 : Little endian pixel ordering within a byte                */
	unsigned int LcdPwr    : BFW_NX500_LCDControl_LcdPwr;    /* LCD power enable                                               */
	                                                         /*  0 : LCD is off                                                */
	unsigned int LcdVComp  : BFW_NX500_LCDControl_LcdVComp;  /* Generate Interrupt at:                                         */
	                                                         /*  00 : start of Vsync                                           */
	unsigned int reserved1 : BFW_NX500_LCDControl_reserved1; /* reserved                                                       */
	unsigned int WATERMARK : BFW_NX500_LCDControl_WATERMARK; /* LCD DMA FIFO Watermark level                                   */
	                                                         /*  0 : FIFO Watermark level will be set to 4-words               */
	unsigned int reserved2 : BFW_NX500_LCDControl_reserved2; /* reserved                                                       */
} NX500_LCDCONTROL_BIT_T;

typedef union {
	unsigned int           val;
	NX500_LCDCONTROL_BIT_T bf;
} NX500_LCDCONTROL_T;

/* --------------------------------------------------------------------- */
/* Register LCDRIS */
/* => LCD Raw Interrupt Status Register */
/*    On a read the register returns five bits that may generate interrupts when set. */
/*    Bits can be cleared by writing '1' to the appropriate bit in LCDICR register. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_LCDRIS      0x00000020U
#define Adr_NX500_lcd_ctrl_LCDRIS 0x00104020U
#define Adr_NX500_LCDRIS          0x00104020U

#define MSK_NX500_LCDRIS_Unused      0x00000001U
#define SRT_NX500_LCDRIS_Unused      0
#define MSK_NX500_LCDRIS_FUFSTAT     0x00000002U
#define SRT_NX500_LCDRIS_FUFSTAT     1
#define MSK_NX500_LCDRIS_LNBUSTAT    0x00000004U
#define SRT_NX500_LCDRIS_LNBUSTAT    2
#define MSK_NX500_LCDRIS_VCOMPSTAT   0x00000008U
#define SRT_NX500_LCDRIS_VCOMPSTAT   3
#define MSK_NX500_LCDRIS_MBERRORSTAT 0x00000010U
#define SRT_NX500_LCDRIS_MBERRORSTAT 4

enum {
	BFW_NX500_LCDRIS_Unused      = 1,  /* [0] */
	BFW_NX500_LCDRIS_FUFSTAT     = 1,  /* [1] */
	BFW_NX500_LCDRIS_LNBUSTAT    = 1,  /* [2] */
	BFW_NX500_LCDRIS_VCOMPSTAT   = 1,  /* [3] */
	BFW_NX500_LCDRIS_MBERRORSTAT = 1,  /* [4] */
	BFW_NX500_LCDRIS_reserved1   = 27  /* [31:5] */
};

typedef struct NX500_LCDRIS_BIT_Ttag {
	unsigned int Unused      : BFW_NX500_LCDRIS_Unused;      /* Unused                                                              */
	unsigned int FUFSTAT     : BFW_NX500_LCDRIS_FUFSTAT;     /* DMA FIFO underflow                                                  */
	unsigned int LNBUSTAT    : BFW_NX500_LCDRIS_LNBUSTAT;    /* LCD next address base update                                        */
	unsigned int VCOMPSTAT   : BFW_NX500_LCDRIS_VCOMPSTAT;   /* Vertical compare                                                    */
	unsigned int MBERRORSTAT : BFW_NX500_LCDRIS_MBERRORSTAT; /* AHB master error status, set to 1 when the AHB master encounters an */
	                                                         /* error response from the slave                                       */
	unsigned int reserved1   : BFW_NX500_LCDRIS_reserved1;   /* reserved                                                            */
} NX500_LCDRIS_BIT_T;

typedef union {
	unsigned int       val;
	NX500_LCDRIS_BIT_T bf;
} NX500_LCDRIS_T;

/* --------------------------------------------------------------------- */
/* Register LCDMIS */
/* => LCD Masked Interrupt Status Register */
/*    This register is a bit-by-bit logical AND of the LCDStatus register. Interrupt lines corresponding to each */
/*    interrupt addition to the logical OR of all interrupts are provided to the system interrupt controller. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_LCDMIS      0x00000024U
#define Adr_NX500_lcd_ctrl_LCDMIS 0x00104024U
#define Adr_NX500_LCDMIS          0x00104024U

#define MSK_NX500_LCDMIS_Unused          0x00000001U
#define SRT_NX500_LCDMIS_Unused          0
#define MSK_NX500_LCDMIS_CLCDFUFINTR     0x00000002U
#define SRT_NX500_LCDMIS_CLCDFUFINTR     1
#define MSK_NX500_LCDMIS_CLCDLNBUINTR    0x00000004U
#define SRT_NX500_LCDMIS_CLCDLNBUINTR    2
#define MSK_NX500_LCDMIS_CLCDVCOMPINTR   0x00000008U
#define SRT_NX500_LCDMIS_CLCDVCOMPINTR   3
#define MSK_NX500_LCDMIS_CLCDMBERRORINTR 0x00000010U
#define SRT_NX500_LCDMIS_CLCDMBERRORINTR 4

enum {
	BFW_NX500_LCDMIS_Unused          = 1,  /* [0] */
	BFW_NX500_LCDMIS_CLCDFUFINTR     = 1,  /* [1] */
	BFW_NX500_LCDMIS_CLCDLNBUINTR    = 1,  /* [2] */
	BFW_NX500_LCDMIS_CLCDVCOMPINTR   = 1,  /* [3] */
	BFW_NX500_LCDMIS_CLCDMBERRORINTR = 1,  /* [4] */
	BFW_NX500_LCDMIS_reserved1       = 27  /* [31:5] */
};

typedef struct NX500_LCDMIS_BIT_Ttag {
	unsigned int Unused          : BFW_NX500_LCDMIS_Unused;          /* Unused                                 */
	unsigned int CLCDFUFINTR     : BFW_NX500_LCDMIS_CLCDFUFINTR;     /* DMA FIFO underflow interrupt           */
	unsigned int CLCDLNBUINTR    : BFW_NX500_LCDMIS_CLCDLNBUINTR;    /* LCD next address base update interrupt */
	unsigned int CLCDVCOMPINTR   : BFW_NX500_LCDMIS_CLCDVCOMPINTR;   /* Vertical compare interrupt             */
	unsigned int CLCDMBERRORINTR : BFW_NX500_LCDMIS_CLCDMBERRORINTR; /* AHB master error interrupt             */
	unsigned int reserved1       : BFW_NX500_LCDMIS_reserved1;       /* reserved                               */
} NX500_LCDMIS_BIT_T;

typedef union {
	unsigned int       val;
	NX500_LCDMIS_BIT_T bf;
} NX500_LCDMIS_T;

/* --------------------------------------------------------------------- */
/* Register LCDICR */
/* => LCD Interrupt Clear Register */
/*    The LCDICR is a write only register. Writing logic 1 to the relevant bit clears the corresponding interrupt. */
/* => Mode: W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_LCDICR      0x00000028U
#define Adr_NX500_lcd_ctrl_LCDICR 0x00104028U
#define Adr_NX500_LCDICR          0x00104028U
#define DFLT_VAL_NX500_LCDICR     0x00000000U

#define MSK_NX500_LCDICR_Unused       0x00000001U
#define SRT_NX500_LCDICR_Unused       0
#define DFLT_VAL_NX500_LCDICR_Unused  0x00000000U
#define MSK_NX500_LCDICR_FUF          0x00000002U
#define SRT_NX500_LCDICR_FUF          1
#define DFLT_VAL_NX500_LCDICR_FUF     0x00000000U
#define MSK_NX500_LCDICR_LNBU         0x00000004U
#define SRT_NX500_LCDICR_LNBU         2
#define DFLT_VAL_NX500_LCDICR_LNBU    0x00000000U
#define MSK_NX500_LCDICR_VCOMP        0x00000008U
#define SRT_NX500_LCDICR_VCOMP        3
#define DFLT_VAL_NX500_LCDICR_VCOMP   0x00000000U
#define MSK_NX500_LCDICR_MBERROR      0x00000010U
#define SRT_NX500_LCDICR_MBERROR      4
#define DFLT_VAL_NX500_LCDICR_MBERROR 0x00000000U

enum {
	BFW_NX500_LCDICR_Unused    = 1,  /* [0] */
	BFW_NX500_LCDICR_FUF       = 1,  /* [1] */
	BFW_NX500_LCDICR_LNBU      = 1,  /* [2] */
	BFW_NX500_LCDICR_VCOMP     = 1,  /* [3] */
	BFW_NX500_LCDICR_MBERROR   = 1,  /* [4] */
	BFW_NX500_LCDICR_reserved1 = 27  /* [31:5] */
};

typedef struct NX500_LCDICR_BIT_Ttag {
	unsigned int Unused    : BFW_NX500_LCDICR_Unused;    /* Unused                                       */
	unsigned int FUF       : BFW_NX500_LCDICR_FUF;       /* Clear DMA FIFO underflow interrupt           */
	unsigned int LNBU      : BFW_NX500_LCDICR_LNBU;      /* Clear LCD next address base update interrupt */
	unsigned int VCOMP     : BFW_NX500_LCDICR_VCOMP;     /* Clear Vertical compare interrupt             */
	unsigned int MBERROR   : BFW_NX500_LCDICR_MBERROR;   /* Clear AHB master error interrupt             */
	unsigned int reserved1 : BFW_NX500_LCDICR_reserved1; /* reserved                                     */
} NX500_LCDICR_BIT_T;

typedef union {
	unsigned int       val;
	NX500_LCDICR_BIT_T bf;
} NX500_LCDICR_T;

/* --------------------------------------------------------------------- */
/* Register LCDUPCURR */
/* => LCD Upper panel DMA Channel Current Address */
/*    This register contains the current DMA address for display data read of TFT, single panel STN and upper panel */
/*    of dual STN displays. */
/*    This register's value may change at any moment, and is not normally read from, but can be read to determine */
/*    the approximate position within the buffer, or for test. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_LCDUPCURR      0x0000002CU
#define Adr_NX500_lcd_ctrl_LCDUPCURR 0x0010402CU
#define Adr_NX500_LCDUPCURR          0x0010402CU

#define MSK_NX500_LCDUPCURR_LCDUPCURR 0xffffffffU
#define SRT_NX500_LCDUPCURR_LCDUPCURR 0

enum {
	BFW_NX500_LCDUPCURR_LCDUPCURR = 32  /* [31:0] */
};

typedef struct NX500_LCDUPCURR_BIT_Ttag {
	unsigned int LCDUPCURR : BFW_NX500_LCDUPCURR_LCDUPCURR; /* Upper panel address */
} NX500_LCDUPCURR_BIT_T;

typedef union {
	unsigned int          val;
	NX500_LCDUPCURR_BIT_T bf;
} NX500_LCDUPCURR_T;

/* --------------------------------------------------------------------- */
/* Register LCDLPCURR */
/* => LCD Lower panel DMA Channel Current Address */
/*    This register contains the current DMA address for display data read of the lower panel of dual STN displays. */
/*    This register's value may change at any moment, and is not normally read from, but can be read to determine */
/*    the approximate position within the buffer, or for test. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_LCDLPCURR      0x00000030U
#define Adr_NX500_lcd_ctrl_LCDLPCURR 0x00104030U
#define Adr_NX500_LCDLPCURR          0x00104030U

#define MSK_NX500_LCDLPCURR_LCDLPCURR 0xffffffffU
#define SRT_NX500_LCDLPCURR_LCDLPCURR 0

enum {
	BFW_NX500_LCDLPCURR_LCDLPCURR = 32  /* [31:0] */
};

typedef struct NX500_LCDLPCURR_BIT_Ttag {
	unsigned int LCDLPCURR : BFW_NX500_LCDLPCURR_LCDLPCURR; /* Lower panel address */
} NX500_LCDLPCURR_BIT_T;

typedef union {
	unsigned int          val;
	NX500_LCDLPCURR_BIT_T bf;
} NX500_LCDLPCURR_T;

/* --------------------------------------------------------------------- */
/* Register LCDPaletteStart */
/* => 256 main palette entries organised as 128 locations x two entries per word */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_LCDPaletteStart      0x00000200U
#define Adr_NX500_lcd_ctrl_LCDPaletteStart 0x00104200U
#define Adr_NX500_LCDPaletteStart          0x00104200U
#define DFLT_VAL_NX500_LCDPaletteStart     0x00000000U

#define MSK_NX500_LCDPaletteStart_LCDPalette      0xffffffffU
#define SRT_NX500_LCDPaletteStart_LCDPalette      0
#define DFLT_VAL_NX500_LCDPaletteStart_LCDPalette 0x00000000U

enum {
	BFW_NX500_LCDPaletteStart_LCDPalette = 32  /* [31:0] */
};

typedef struct NX500_LCDPALETTESTART_BIT_Ttag {
	unsigned int LCDPalette : BFW_NX500_LCDPaletteStart_LCDPalette; /* 256 main palette entries organised as 128 locations x two */
	                                                                /* entries per word                                          */
} NX500_LCDPALETTESTART_BIT_T;

typedef union {
	unsigned int                val;
	NX500_LCDPALETTESTART_BIT_T bf;
} NX500_LCDPALETTESTART_T;

/* --------------------------------------------------------------------- */
/* Register LCDPaletteEnd */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_LCDPaletteEnd      0x000003FCU
#define Adr_NX500_lcd_ctrl_LCDPaletteEnd 0x001043FCU
#define Adr_NX500_LCDPaletteEnd          0x001043FCU
#define DFLT_VAL_NX500_LCDPaletteEnd     0x00000000U

#define MSK_NX500_LCDPaletteEnd_LCDPalette      0xffffffffU
#define SRT_NX500_LCDPaletteEnd_LCDPalette      0
#define DFLT_VAL_NX500_LCDPaletteEnd_LCDPalette 0x00000000U

enum {
	BFW_NX500_LCDPaletteEnd_LCDPalette = 32  /* [31:0] */
};

typedef struct NX500_LCDPALETTEEND_BIT_Ttag {
	unsigned int LCDPalette : BFW_NX500_LCDPaletteEnd_LCDPalette; /*  */
} NX500_LCDPALETTEEND_BIT_T;

typedef union {
	unsigned int              val;
	NX500_LCDPALETTEEND_BIT_T bf;
} NX500_LCDPALETTEEND_T;

/* --------------------------------------------------------------------- */
/* Register DMAFIFOStart */
/* => Test mode. LCD DMA FIFO Access path. Upper and lower FIFOs cascaded. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_DMAFIFOStart      0x00000400U
#define Adr_NX500_lcd_ctrl_DMAFIFOStart 0x00104400U
#define Adr_NX500_DMAFIFOStart          0x00104400U
#define DFLT_VAL_NX500_DMAFIFOStart     0x00000000U

#define MSK_NX500_DMAFIFOStart_LCDDMAFIFO      0xffffffffU
#define SRT_NX500_DMAFIFOStart_LCDDMAFIFO      0
#define DFLT_VAL_NX500_DMAFIFOStart_LCDDMAFIFO 0x00000000U

enum {
	BFW_NX500_DMAFIFOStart_LCDDMAFIFO = 32  /* [31:0] */
};

typedef struct NX500_DMAFIFOSTART_BIT_Ttag {
	unsigned int LCDDMAFIFO : BFW_NX500_DMAFIFOStart_LCDDMAFIFO; /* LCD DMA FIFO Access path. Upper and lower FIFOs cascaded. */
} NX500_DMAFIFOSTART_BIT_T;

typedef union {
	unsigned int             val;
	NX500_DMAFIFOSTART_BIT_T bf;
} NX500_DMAFIFOSTART_T;

/* --------------------------------------------------------------------- */
/* Register DMAFIFOEnd */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_DMAFIFOEnd      0x000007FCU
#define Adr_NX500_lcd_ctrl_DMAFIFOEnd 0x001047FCU
#define Adr_NX500_DMAFIFOEnd          0x001047FCU
#define DFLT_VAL_NX500_DMAFIFOEnd     0x00000000U

#define MSK_NX500_DMAFIFOEnd_LCDDMAFIFO      0xffffffffU
#define SRT_NX500_DMAFIFOEnd_LCDDMAFIFO      0
#define DFLT_VAL_NX500_DMAFIFOEnd_LCDDMAFIFO 0x00000000U

enum {
	BFW_NX500_DMAFIFOEnd_LCDDMAFIFO = 32  /* [31:0] */
};

typedef struct NX500_DMAFIFOEND_BIT_Ttag {
	unsigned int LCDDMAFIFO : BFW_NX500_DMAFIFOEnd_LCDDMAFIFO; /*  */
} NX500_DMAFIFOEND_BIT_T;

typedef union {
	unsigned int           val;
	NX500_DMAFIFOEND_BIT_T bf;
} NX500_DMAFIFOEND_T;

/* --------------------------------------------------------------------- */
/* Register CLCDPERIPHID0 */
/* => Peripheral Identification register 0 */
/*    The CLCDPERIPHID0 Register is hard-coded and the fields in the register determine the reset value. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_CLCDPERIPHID0      0x00000FE0U
#define Adr_NX500_lcd_ctrl_CLCDPERIPHID0 0x00104FE0U
#define Adr_NX500_CLCDPERIPHID0          0x00104FE0U

#define MSK_NX500_CLCDPERIPHID0_PartNumber0 0x000000ffU
#define SRT_NX500_CLCDPERIPHID0_PartNumber0 0

enum {
	BFW_NX500_CLCDPERIPHID0_PartNumber0 = 8,  /* [7:0] */
	BFW_NX500_CLCDPERIPHID0_reserved1   = 24  /* [31:8] */
};

typedef struct NX500_CLCDPERIPHID0_BIT_Ttag {
	unsigned int PartNumber0 : BFW_NX500_CLCDPERIPHID0_PartNumber0; /* These bits read back as 0x10 */
	unsigned int reserved1   : BFW_NX500_CLCDPERIPHID0_reserved1;   /* reserved                     */
} NX500_CLCDPERIPHID0_BIT_T;

typedef union {
	unsigned int              val;
	NX500_CLCDPERIPHID0_BIT_T bf;
} NX500_CLCDPERIPHID0_T;

/* --------------------------------------------------------------------- */
/* Register CLCDPERIPHID1 */
/* => Peripheral Identification register 1 */
/*    The CLCDPERIPHID1 Register is hard-coded and the fields in the register determine the reset value. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_CLCDPERIPHID1      0x00000FE4U
#define Adr_NX500_lcd_ctrl_CLCDPERIPHID1 0x00104FE4U
#define Adr_NX500_CLCDPERIPHID1          0x00104FE4U

#define MSK_NX500_CLCDPERIPHID1_PartNumber1 0x0000000fU
#define SRT_NX500_CLCDPERIPHID1_PartNumber1 0
#define MSK_NX500_CLCDPERIPHID1_Designer0   0x000000f0U
#define SRT_NX500_CLCDPERIPHID1_Designer0   4

enum {
	BFW_NX500_CLCDPERIPHID1_PartNumber1 = 4,  /* [3:0] */
	BFW_NX500_CLCDPERIPHID1_Designer0   = 4,  /* [7:4] */
	BFW_NX500_CLCDPERIPHID1_reserved1   = 24  /* [31:8] */
};

typedef struct NX500_CLCDPERIPHID1_BIT_Ttag {
	unsigned int PartNumber1 : BFW_NX500_CLCDPERIPHID1_PartNumber1; /* These bits read back as 0x1 */
	unsigned int Designer0   : BFW_NX500_CLCDPERIPHID1_Designer0;   /* These bits read back as 0x1 */
	unsigned int reserved1   : BFW_NX500_CLCDPERIPHID1_reserved1;   /* reserved                    */
} NX500_CLCDPERIPHID1_BIT_T;

typedef union {
	unsigned int              val;
	NX500_CLCDPERIPHID1_BIT_T bf;
} NX500_CLCDPERIPHID1_T;

/* --------------------------------------------------------------------- */
/* Register CLCDPERIPHID2 */
/* => Peripheral Identification register 2 */
/*    The CLCDPERIPHID2 Register is hard-coded and the fields in the register determine the reset value. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_CLCDPERIPHID2      0x00000FE8U
#define Adr_NX500_lcd_ctrl_CLCDPERIPHID2 0x00104FE8U
#define Adr_NX500_CLCDPERIPHID2          0x00104FE8U

#define MSK_NX500_CLCDPERIPHID2_Designer1 0x0000000fU
#define SRT_NX500_CLCDPERIPHID2_Designer1 0
#define MSK_NX500_CLCDPERIPHID2_Revision  0x000000f0U
#define SRT_NX500_CLCDPERIPHID2_Revision  4

enum {
	BFW_NX500_CLCDPERIPHID2_Designer1 = 4,  /* [3:0] */
	BFW_NX500_CLCDPERIPHID2_Revision  = 4,  /* [7:4] */
	BFW_NX500_CLCDPERIPHID2_reserved1 = 24  /* [31:8] */
};

typedef struct NX500_CLCDPERIPHID2_BIT_Ttag {
	unsigned int Designer1 : BFW_NX500_CLCDPERIPHID2_Designer1; /* These bits read back as 0x4 */
	unsigned int Revision  : BFW_NX500_CLCDPERIPHID2_Revision;  /* These bits read back as 0x0 */
	unsigned int reserved1 : BFW_NX500_CLCDPERIPHID2_reserved1; /* reserved                    */
} NX500_CLCDPERIPHID2_BIT_T;

typedef union {
	unsigned int              val;
	NX500_CLCDPERIPHID2_BIT_T bf;
} NX500_CLCDPERIPHID2_T;

/* --------------------------------------------------------------------- */
/* Register CLCDPERIPHID3 */
/* => Peripheral Identification register 3 */
/*    The CLCDPERIPHID3 Register is hard-coded and the fields in the register determine the reset value. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_CLCDPERIPHID3      0x00000FECU
#define Adr_NX500_lcd_ctrl_CLCDPERIPHID3 0x00104FECU
#define Adr_NX500_CLCDPERIPHID3          0x00104FECU

#define MSK_NX500_CLCDPERIPHID3_Configuration 0x000000ffU
#define SRT_NX500_CLCDPERIPHID3_Configuration 0

enum {
	BFW_NX500_CLCDPERIPHID3_Configuration = 8,  /* [7:0] */
	BFW_NX500_CLCDPERIPHID3_reserved1     = 24  /* [31:8] */
};

typedef struct NX500_CLCDPERIPHID3_BIT_Ttag {
	unsigned int Configuration : BFW_NX500_CLCDPERIPHID3_Configuration; /* These bits read back as 0x0 */
	unsigned int reserved1     : BFW_NX500_CLCDPERIPHID3_reserved1;     /* reserved                    */
} NX500_CLCDPERIPHID3_BIT_T;

typedef union {
	unsigned int              val;
	NX500_CLCDPERIPHID3_BIT_T bf;
} NX500_CLCDPERIPHID3_T;

/* --------------------------------------------------------------------- */
/* Register CLCDPCELLID0 */
/* => Primecell Identification register 0 */
/*    The CLCDPCELLID0 Register is hard-coded and the fields in the register determine the reset value. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_CLCDPCELLID0      0x00000FF0U
#define Adr_NX500_lcd_ctrl_CLCDPCELLID0 0x00104FF0U
#define Adr_NX500_CLCDPCELLID0          0x00104FF0U

#define MSK_NX500_CLCDPCELLID0_PCELLIDID0 0x000000ffU
#define SRT_NX500_CLCDPCELLID0_PCELLIDID0 0

enum {
	BFW_NX500_CLCDPCELLID0_PCELLIDID0 = 8,  /* [7:0] */
	BFW_NX500_CLCDPCELLID0_reserved1  = 24  /* [31:8] */
};

typedef struct NX500_CLCDPCELLID0_BIT_Ttag {
	unsigned int PCELLIDID0 : BFW_NX500_CLCDPCELLID0_PCELLIDID0; /* These bits read back as 0x0D */
	unsigned int reserved1  : BFW_NX500_CLCDPCELLID0_reserved1;  /* reserved                     */
} NX500_CLCDPCELLID0_BIT_T;

typedef union {
	unsigned int             val;
	NX500_CLCDPCELLID0_BIT_T bf;
} NX500_CLCDPCELLID0_T;

/* --------------------------------------------------------------------- */
/* Register CLCDPCELLID1 */
/* => Primecell Identification register 1 */
/*    The CLCDPCELLID1 Register is hard-coded and the fields in the register determine the reset value. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_CLCDPCELLID1      0x00000FF4U
#define Adr_NX500_lcd_ctrl_CLCDPCELLID1 0x00104FF4U
#define Adr_NX500_CLCDPCELLID1          0x00104FF4U

#define MSK_NX500_CLCDPCELLID1_PCELLIDID1 0x000000ffU
#define SRT_NX500_CLCDPCELLID1_PCELLIDID1 0

enum {
	BFW_NX500_CLCDPCELLID1_PCELLIDID1 = 8,  /* [7:0] */
	BFW_NX500_CLCDPCELLID1_reserved1  = 24  /* [31:8] */
};

typedef struct NX500_CLCDPCELLID1_BIT_Ttag {
	unsigned int PCELLIDID1 : BFW_NX500_CLCDPCELLID1_PCELLIDID1; /* These bits read back as 0xF0 */
	unsigned int reserved1  : BFW_NX500_CLCDPCELLID1_reserved1;  /* reserved                     */
} NX500_CLCDPCELLID1_BIT_T;

typedef union {
	unsigned int             val;
	NX500_CLCDPCELLID1_BIT_T bf;
} NX500_CLCDPCELLID1_T;

/* --------------------------------------------------------------------- */
/* Register CLCDPCELLID2 */
/* => Primecell Identification register 2 */
/*    The CLCDPCELLID2 Register is hard-coded and the fields in the register determine the reset value. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_CLCDPCELLID2      0x00000FF8U
#define Adr_NX500_lcd_ctrl_CLCDPCELLID2 0x00104FF8U
#define Adr_NX500_CLCDPCELLID2          0x00104FF8U

#define MSK_NX500_CLCDPCELLID2_PCELLIDID2 0x000000ffU
#define SRT_NX500_CLCDPCELLID2_PCELLIDID2 0

enum {
	BFW_NX500_CLCDPCELLID2_PCELLIDID2 = 8,  /* [7:0] */
	BFW_NX500_CLCDPCELLID2_reserved1  = 24  /* [31:8] */
};

typedef struct NX500_CLCDPCELLID2_BIT_Ttag {
	unsigned int PCELLIDID2 : BFW_NX500_CLCDPCELLID2_PCELLIDID2; /* These bits read back as 0x05 */
	unsigned int reserved1  : BFW_NX500_CLCDPCELLID2_reserved1;  /* reserved                     */
} NX500_CLCDPCELLID2_BIT_T;

typedef union {
	unsigned int             val;
	NX500_CLCDPCELLID2_BIT_T bf;
} NX500_CLCDPCELLID2_T;

/* --------------------------------------------------------------------- */
/* Register CLCDPCELLID3 */
/* => Primecell Identification register 3 */
/*    The CLCDPCELLID3 Register is hard-coded and the fields in the register determine the reset value. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_CLCDPCELLID3      0x00000FFCU
#define Adr_NX500_lcd_ctrl_CLCDPCELLID3 0x00104FFCU
#define Adr_NX500_CLCDPCELLID3          0x00104FFCU

#define MSK_NX500_CLCDPCELLID3_PCELLIDID3 0x000000ffU
#define SRT_NX500_CLCDPCELLID3_PCELLIDID3 0

enum {
	BFW_NX500_CLCDPCELLID3_PCELLIDID3 = 8,  /* [7:0] */
	BFW_NX500_CLCDPCELLID3_reserved1  = 24  /* [31:8] */
};

typedef struct NX500_CLCDPCELLID3_BIT_Ttag {
	unsigned int PCELLIDID3 : BFW_NX500_CLCDPCELLID3_PCELLIDID3; /* These bits read back as 0xb1 */
	unsigned int reserved1  : BFW_NX500_CLCDPCELLID3_reserved1;  /* reserved                     */
} NX500_CLCDPCELLID3_BIT_T;

typedef union {
	unsigned int             val;
	NX500_CLCDPCELLID3_BIT_T bf;
} NX500_CLCDPCELLID3_T;


/* ===================================================================== */

/* Area of usb_core */

/* ===================================================================== */

#define Addr_NX500_usb_core      0x00120000U
#define NX500_NETX_USB_CORE_AREA 0x00120000U

/* --------------------------------------------------------------------- */
/* Register ID */
/* => ID Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_ID      0x00000000U
#define Adr_NX500_usb_core_ID 0x00120000U
#define Adr_NX500_ID          0x00120000U

/* --------------------------------------------------------------------- */
/* Register USB_CTRL */
/* => USB Control Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_USB_CTRL      0x00000004U
#define Adr_NX500_usb_core_USB_CTRL 0x00120004U
#define Adr_NX500_USB_CTRL          0x00120004U

/* --------------------------------------------------------------------- */
/* Register FRM_TIMER */
/* => Frame Timer Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_FRM_TIMER      0x00000008U
#define Adr_NX500_usb_core_FRM_TIMER 0x00120008U
#define Adr_NX500_FRM_TIMER          0x00120008U

/* --------------------------------------------------------------------- */
/* Register MAIN_EV */
/* => Main Event Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_MAIN_EV      0x0000000CU
#define Adr_NX500_usb_core_MAIN_EV 0x0012000CU
#define Adr_NX500_MAIN_EV          0x0012000CU

/* --------------------------------------------------------------------- */
/* Register MAIN_EM */
/* => Main Event Mask Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_MAIN_EM      0x00000010U
#define Adr_NX500_usb_core_MAIN_EM 0x00120010U
#define Adr_NX500_MAIN_EM          0x00120010U

/* --------------------------------------------------------------------- */
/* Register PIPE_EV */
/* => Pipe Event Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_PIPE_EV      0x00000014U
#define Adr_NX500_usb_core_PIPE_EV 0x00120014U
#define Adr_NX500_PIPE_EV          0x00120014U

/* --------------------------------------------------------------------- */
/* Register PIPE_EM */
/* => Pipe Event Mask Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_PIPE_EM      0x00000018U
#define Adr_NX500_usb_core_PIPE_EM 0x00120018U
#define Adr_NX500_PIPE_EM          0x00120018U

/* --------------------------------------------------------------------- */
/* Register PIPE_SEL */
/* => Pipe Select Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_PIPE_SEL      0x00000024U
#define Adr_NX500_usb_core_PIPE_SEL 0x00120024U
#define Adr_NX500_PIPE_SEL          0x00120024U

/* --------------------------------------------------------------------- */
/* Register PORT_STAT */
/* => Port Statuus Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_PORT_STAT      0x0000002CU
#define Adr_NX500_usb_core_PORT_STAT 0x0012002CU
#define Adr_NX500_PORT_STAT          0x0012002CU

/* --------------------------------------------------------------------- */
/* Register PORT_CTRL */
/* => Port Control Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_PORT_CTRL      0x00000030U
#define Adr_NX500_usb_core_PORT_CTRL 0x00120030U
#define Adr_NX500_PORT_CTRL          0x00120030U

/* --------------------------------------------------------------------- */
/* Register PSC_EV */
/* => Port Status Change Event Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_PSC_EV      0x00000034U
#define Adr_NX500_usb_core_PSC_EV 0x00120034U
#define Adr_NX500_PSC_EV          0x00120034U

/* --------------------------------------------------------------------- */
/* Register PSC_EM */
/* => Port Status Change Event Mask Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_PSC_EM      0x00000038U
#define Adr_NX500_usb_core_PSC_EM 0x00120038U
#define Adr_NX500_PSC_EM          0x00120038U

/* --------------------------------------------------------------------- */
/* Register PIPE_CTRL */
/* => Pipe Control Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_PIPE_CTRL      0x00000040U
#define Adr_NX500_usb_core_PIPE_CTRL 0x00120040U
#define Adr_NX500_PIPE_CTRL          0x00120040U

/* --------------------------------------------------------------------- */
/* Register PIPE_CFG */
/* => Pipe Configuration Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_PIPE_CFG      0x00000044U
#define Adr_NX500_usb_core_PIPE_CFG 0x00120044U
#define Adr_NX500_PIPE_CFG          0x00120044U

/* --------------------------------------------------------------------- */
/* Register PIPE_ADDR */
/* => Pipe Address Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_PIPE_ADDR      0x00000048U
#define Adr_NX500_usb_core_PIPE_ADDR 0x00120048U
#define Adr_NX500_PIPE_ADDR          0x00120048U

/* --------------------------------------------------------------------- */
/* Register PIPE_STAT */
/* => Pipe Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_PIPE_STAT      0x0000004CU
#define Adr_NX500_usb_core_PIPE_STAT 0x0012004CU
#define Adr_NX500_PIPE_STAT          0x0012004CU

/* --------------------------------------------------------------------- */
/* Register PIPE_DATA_PTR */
/* => Pipe Data Pointer Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_PIPE_DATA_PTR      0x00000050U
#define Adr_NX500_usb_core_PIPE_DATA_PTR 0x00120050U
#define Adr_NX500_PIPE_DATA_PTR          0x00120050U

/* --------------------------------------------------------------------- */
/* Register PIPE_DATA_TBYTES */
/* => Pipe Total Bytes Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_PIPE_DATA_TBYTES      0x00000054U
#define Adr_NX500_usb_core_PIPE_DATA_TBYTES 0x00120054U
#define Adr_NX500_PIPE_DATA_TBYTES          0x00120054U

/* --------------------------------------------------------------------- */
/* Register PIPE_ADATA_PTR */
/* => Pipe Alternative Data Pointer Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_PIPE_ADATA_PTR      0x00000058U
#define Adr_NX500_usb_core_PIPE_ADATA_PTR 0x00120058U
#define Adr_NX500_PIPE_ADATA_PTR          0x00120058U

/* --------------------------------------------------------------------- */
/* Register PIPE_ADATA_TBYTES */
/* => Pipe Altenative Data Total Bytes Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_PIPE_ADATA_TBYTES      0x0000005CU
#define Adr_NX500_usb_core_PIPE_ADATA_TBYTES 0x0012005CU
#define Adr_NX500_PIPE_ADATA_TBYTES          0x0012005CU

/* --------------------------------------------------------------------- */
/* Register DEBUG_CTRL */
/* => Debug Control Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_DEBUG_CTRL      0x00000060U
#define Adr_NX500_usb_core_DEBUG_CTRL 0x00120060U
#define Adr_NX500_DEBUG_CTRL          0x00120060U

/* --------------------------------------------------------------------- */
/* Register DEBUG_PID */
/* => Debug PID Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_DEBUG_PID      0x00000064U
#define Adr_NX500_usb_core_DEBUG_PID 0x00120064U
#define Adr_NX500_DEBUG_PID          0x00120064U

/* --------------------------------------------------------------------- */
/* Register DEBUG_STAT */
/* => Debug Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_DEBUG_STAT      0x00000068U
#define Adr_NX500_usb_core_DEBUG_STAT 0x00120068U
#define Adr_NX500_DEBUG_STAT          0x00120068U

/* --------------------------------------------------------------------- */
/* Register TEST */
/* => Test Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_TEST      0x0000006CU
#define Adr_NX500_usb_core_TEST 0x0012006CU
#define Adr_NX500_TEST          0x0012006CU

/* --------------------------------------------------------------------- */
/* Register MAIN_CFG */
/* => Main Configuration Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_MAIN_CFG      0x00000080U
#define Adr_NX500_usb_core_MAIN_CFG 0x00120080U
#define Adr_NX500_MAIN_CFG          0x00120080U

/* --------------------------------------------------------------------- */
/* Register MODE_CFG */
/* => Mode Configuration Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_MODE_CFG      0x00000084U
#define Adr_NX500_usb_core_MODE_CFG 0x00120084U
#define Adr_NX500_MODE_CFG          0x00120084U

/* --------------------------------------------------------------------- */
/* Register usb_core_ctrl */
/* => USB core control and status register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_usb_core_ctrl      0x00000088U
#define Adr_NX500_usb_core_usb_core_ctrl 0x00120088U
#define Adr_NX500_usb_core_ctrl          0x00120088U
#define DFLT_VAL_NX500_usb_core_ctrl     0x0086b000U

#define MSK_NX500_usb_core_ctrl_reset                   0x00000001U
#define SRT_NX500_usb_core_ctrl_reset                   0
#define DFLT_VAL_NX500_usb_core_ctrl_reset              0x00000000U
#define MSK_NX500_usb_core_ctrl_dbg_support             0x00000002U
#define SRT_NX500_usb_core_ctrl_dbg_support             1
#define DFLT_VAL_NX500_usb_core_ctrl_dbg_support        0x00000000U
#define MSK_NX500_usb_core_ctrl_xtd_dbg_support         0x00000004U
#define SRT_NX500_usb_core_ctrl_xtd_dbg_support         2
#define DFLT_VAL_NX500_usb_core_ctrl_xtd_dbg_support    0x00000000U
#define MSK_NX500_usb_core_ctrl_soft_id_dig             0x00000008U
#define SRT_NX500_usb_core_ctrl_soft_id_dig             3
#define DFLT_VAL_NX500_usb_core_ctrl_soft_id_dig        0x00000000U
#define MSK_NX500_usb_core_ctrl_alt_buffer_support      0x00000ff0U
#define SRT_NX500_usb_core_ctrl_alt_buffer_support      4
#define DFLT_VAL_NX500_usb_core_ctrl_alt_buffer_support 0x00000000U
#define MSK_NX500_usb_core_ctrl_core_suspend_n          0x00001000U
#define SRT_NX500_usb_core_ctrl_core_suspend_n          12
#define DFLT_VAL_NX500_usb_core_ctrl_core_suspend_n     0x00001000U
#define MSK_NX500_usb_core_ctrl_xcvr_suspend_n          0x00002000U
#define SRT_NX500_usb_core_ctrl_xcvr_suspend_n          13
#define DFLT_VAL_NX500_usb_core_ctrl_xcvr_suspend_n     0x00002000U
#define MSK_NX500_usb_core_ctrl_over_current            0x00004000U
#define SRT_NX500_usb_core_ctrl_over_current            14
#define DFLT_VAL_NX500_usb_core_ctrl_over_current       0x00000000U
#define MSK_NX500_usb_core_ctrl_va_sess_vld             0x00008000U
#define SRT_NX500_usb_core_ctrl_va_sess_vld             15
#define DFLT_VAL_NX500_usb_core_ctrl_va_sess_vld        0x00008000U
#define MSK_NX500_usb_core_ctrl_vb_sess_end             0x00010000U
#define SRT_NX500_usb_core_ctrl_vb_sess_end             16
#define DFLT_VAL_NX500_usb_core_ctrl_vb_sess_end        0x00000000U
#define MSK_NX500_usb_core_ctrl_vb_sess_vld             0x00020000U
#define SRT_NX500_usb_core_ctrl_vb_sess_vld             17
#define DFLT_VAL_NX500_usb_core_ctrl_vb_sess_vld        0x00020000U
#define MSK_NX500_usb_core_ctrl_vbus_vld                0x00040000U
#define SRT_NX500_usb_core_ctrl_vbus_vld                18
#define DFLT_VAL_NX500_usb_core_ctrl_vbus_vld           0x00040000U
#define MSK_NX500_usb_core_ctrl_chrg_vbus               0x00080000U
#define SRT_NX500_usb_core_ctrl_chrg_vbus               19
#define DFLT_VAL_NX500_usb_core_ctrl_chrg_vbus          0x00000000U
#define MSK_NX500_usb_core_ctrl_dlp_active              0x00100000U
#define SRT_NX500_usb_core_ctrl_dlp_active              20
#define DFLT_VAL_NX500_usb_core_ctrl_dlp_active         0x00000000U
#define MSK_NX500_usb_core_ctrl_vb_on                   0x00200000U
#define SRT_NX500_usb_core_ctrl_vb_on                   21
#define DFLT_VAL_NX500_usb_core_ctrl_vb_on              0x00000000U
#define MSK_NX500_usb_core_ctrl_dischrg_vbus            0x00400000U
#define SRT_NX500_usb_core_ctrl_dischrg_vbus            22
#define DFLT_VAL_NX500_usb_core_ctrl_dischrg_vbus       0x00000000U
#define MSK_NX500_usb_core_ctrl_ucif_rdy                0x00800000U
#define SRT_NX500_usb_core_ctrl_ucif_rdy                23
#define DFLT_VAL_NX500_usb_core_ctrl_ucif_rdy           0x00800000U
#define MSK_NX500_usb_core_ctrl_usb_irq                 0x01000000U
#define SRT_NX500_usb_core_ctrl_usb_irq                 24
#define DFLT_VAL_NX500_usb_core_ctrl_usb_irq            0x00000000U

enum {
	BFW_NX500_usb_core_ctrl_reset              = 1, /* [0] */
	BFW_NX500_usb_core_ctrl_dbg_support        = 1, /* [1] */
	BFW_NX500_usb_core_ctrl_xtd_dbg_support    = 1, /* [2] */
	BFW_NX500_usb_core_ctrl_soft_id_dig        = 1, /* [3] */
	BFW_NX500_usb_core_ctrl_alt_buffer_support = 8, /* [11:4] */
	BFW_NX500_usb_core_ctrl_core_suspend_n     = 1, /* [12] */
	BFW_NX500_usb_core_ctrl_xcvr_suspend_n     = 1, /* [13] */
	BFW_NX500_usb_core_ctrl_over_current       = 1, /* [14] */
	BFW_NX500_usb_core_ctrl_va_sess_vld        = 1, /* [15] */
	BFW_NX500_usb_core_ctrl_vb_sess_end        = 1, /* [16] */
	BFW_NX500_usb_core_ctrl_vb_sess_vld        = 1, /* [17] */
	BFW_NX500_usb_core_ctrl_vbus_vld           = 1, /* [18] */
	BFW_NX500_usb_core_ctrl_chrg_vbus          = 1, /* [19] */
	BFW_NX500_usb_core_ctrl_dlp_active         = 1, /* [20] */
	BFW_NX500_usb_core_ctrl_vb_on              = 1, /* [21] */
	BFW_NX500_usb_core_ctrl_dischrg_vbus       = 1, /* [22] */
	BFW_NX500_usb_core_ctrl_ucif_rdy           = 1, /* [23] */
	BFW_NX500_usb_core_ctrl_usb_irq            = 1, /* [24] */
	BFW_NX500_usb_core_ctrl_reserved1          = 7  /* [31:25] */
};

typedef struct NX500_USB_CORE_CTRL_BIT_Ttag {
	unsigned int reset              : BFW_NX500_usb_core_ctrl_reset;              /* software reset (r/w)                 */
	unsigned int dbg_support        : BFW_NX500_usb_core_ctrl_dbg_support;        /* enables debug support (r/w)          */
	unsigned int xtd_dbg_support    : BFW_NX500_usb_core_ctrl_xtd_dbg_support;    /* enables extended debug support (r/w) */
	unsigned int soft_id_dig        : BFW_NX500_usb_core_ctrl_soft_id_dig;        /* to set id_dig via software (r/w)     */
	unsigned int alt_buffer_support : BFW_NX500_usb_core_ctrl_alt_buffer_support; /* alt buffer support (r/w)             */
	unsigned int core_suspend_n     : BFW_NX500_usb_core_ctrl_core_suspend_n;     /* reflects core_suspend_n (ro)         */
	unsigned int xcvr_suspend_n     : BFW_NX500_usb_core_ctrl_xcvr_suspend_n;     /* reflects xcvr_suspend_n (ro)         */
	unsigned int over_current       : BFW_NX500_usb_core_ctrl_over_current;       /* reflects over_current (ro)           */
	unsigned int va_sess_vld        : BFW_NX500_usb_core_ctrl_va_sess_vld;        /* reflects va_sess_vld (ro)            */
	unsigned int vb_sess_end        : BFW_NX500_usb_core_ctrl_vb_sess_end;        /* reflects vb_sess_end (ro)            */
	unsigned int vb_sess_vld        : BFW_NX500_usb_core_ctrl_vb_sess_vld;        /* reflects vb_sess_vld (ro)            */
	unsigned int vbus_vld           : BFW_NX500_usb_core_ctrl_vbus_vld;           /* reflects vbus_vld (ro)               */
	unsigned int chrg_vbus          : BFW_NX500_usb_core_ctrl_chrg_vbus;          /* reflects chrg_vbus (ro)              */
	unsigned int dlp_active         : BFW_NX500_usb_core_ctrl_dlp_active;         /* reflects dlp_active (ro)             */
	unsigned int vb_on              : BFW_NX500_usb_core_ctrl_vb_on;              /* reflects vb_on (ro)                  */
	unsigned int dischrg_vbus       : BFW_NX500_usb_core_ctrl_dischrg_vbus;       /* reflects dischrg_vbus (ro)           */
	unsigned int ucif_rdy           : BFW_NX500_usb_core_ctrl_ucif_rdy;           /* reflects ucif_rdy (ro)               */
	unsigned int usb_irq            : BFW_NX500_usb_core_ctrl_usb_irq;            /* reflects usb_irq (ro)                */
	unsigned int reserved1          : BFW_NX500_usb_core_ctrl_reserved1;          /* reserved                             */
} NX500_USB_CORE_CTRL_BIT_T;

typedef union {
	unsigned int              val;
	NX500_USB_CORE_CTRL_BIT_T bf;
} NX500_USB_CORE_CTRL_T;


/* ===================================================================== */

/* Area of usb_fifo */

/* ===================================================================== */

#define Addr_NX500_usb_fifo      0x00130000U
#define NX500_NETX_USB_FIFO_AREA 0x00130000U

/* --------------------------------------------------------------------- */
/* Register USB_FIFO_BASE */
/* => USB End Point 0 (IN) Base Address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_USB_FIFO_BASE      0x00000000U
#define Adr_NX500_usb_fifo_USB_FIFO_BASE 0x00130000U
#define Adr_NX500_USB_FIFO_BASE          0x00130000U


/* ===================================================================== */

/* Area of xc */

/* ===================================================================== */

#define Addr_NX500_xc      0x00140000U
#define NX500_NETX_XC_AREA 0x00140000U

/* --------------------------------------------------------------------- */
/* Register xc_base */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xc_base 0x00000000U
#define Adr_NX500_xc_xc_base  0x00140000U
#define Adr_NX500_xc_base     0x00140000U


/* ===================================================================== */

/* AREA xmac */
/* Area of xmac0, xmac1, xmac2, xmac3 */

/* ===================================================================== */

#define Addr_NX500_xmac0    0x00160000U
#define NX500_NETX_XM0_BASE 0x00160000U
#define Addr_NX500_xmac1    0x00161000U
#define NX500_NETX_XM1_BASE 0x00161000U
#define Addr_NX500_xmac2    0x00162000U
#define NX500_NETX_XM2_BASE 0x00162000U
#define Addr_NX500_xmac3    0x00163000U
#define NX500_NETX_XM3_BASE 0x00163000U

/* --------------------------------------------------------------------- */
/* Register xmac_rpu_program_start */
/* => xMAC RPU program-RAM start address. */
/*    The Program-RAM is not addressable for xMAC RPU and TPU ! */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rpu_program_start   0x00000000U
#define Adr_NX500_xmac0_xmac_rpu_program_start 0x00160000U
#define Adr_NX500_xmac1_xmac_rpu_program_start 0x00161000U
#define Adr_NX500_xmac2_xmac_rpu_program_start 0x00162000U
#define Adr_NX500_xmac3_xmac_rpu_program_start 0x00163000U

/* --------------------------------------------------------------------- */
/* Register xmac_rpu_program_end */
/* => xMAC RPU program-RAM end address. */
/*    This value is not used by design flow, only for documentation */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rpu_program_end   0x000003FFU
#define Adr_NX500_xmac0_xmac_rpu_program_end 0x001603FFU
#define Adr_NX500_xmac1_xmac_rpu_program_end 0x001613FFU
#define Adr_NX500_xmac2_xmac_rpu_program_end 0x001623FFU
#define Adr_NX500_xmac3_xmac_rpu_program_end 0x001633FFU

/* --------------------------------------------------------------------- */
/* Register xmac_tpu_program_start */
/* => xMAC TPU program-RAM start address. */
/*    The Program-RAM is not addressable for xMAC RPU and TPU ! */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tpu_program_start   0x00000400U
#define Adr_NX500_xmac0_xmac_tpu_program_start 0x00160400U
#define Adr_NX500_xmac1_xmac_tpu_program_start 0x00161400U
#define Adr_NX500_xmac2_xmac_tpu_program_start 0x00162400U
#define Adr_NX500_xmac3_xmac_tpu_program_start 0x00163400U

/* --------------------------------------------------------------------- */
/* Register xmac_tpu_program_end */
/* => xMAC TPU program-RAM end address. */
/*    This value is not used by design flow, only for documentation */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tpu_program_end   0x000007FFU
#define Adr_NX500_xmac0_xmac_tpu_program_end 0x001607FFU
#define Adr_NX500_xmac1_xmac_tpu_program_end 0x001617FFU
#define Adr_NX500_xmac2_xmac_tpu_program_end 0x001627FFU
#define Adr_NX500_xmac3_xmac_tpu_program_end 0x001637FFU

/* --------------------------------------------------------------------- */
/* Register xmac_sr0 */
/* => Shared Work Register 0 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sr0   0x00000800U
#define Adr_NX500_xmac0_xmac_sr0 0x00160800U
#define Adr_NX500_xmac1_xmac_sr0 0x00161800U
#define Adr_NX500_xmac2_xmac_sr0 0x00162800U
#define Adr_NX500_xmac3_xmac_sr0 0x00163800U
#define DFLT_VAL_NX500_xmac_sr0  0x00000000U

#define MSK_NX500_xmac_sr0_SR0      0x0000ffffU
#define SRT_NX500_xmac_sr0_SR0      0
#define DFLT_VAL_NX500_xmac_sr0_SR0 0x00000000U

enum {
	BFW_NX500_xmac_sr0_SR0       = 16, /* [15:0] */
	BFW_NX500_xmac_sr0_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SR0_BIT_Ttag {
	unsigned int SR0       : BFW_NX500_xmac_sr0_SR0;       /* Shared Register */
	unsigned int reserved1 : BFW_NX500_xmac_sr0_reserved1; /* reserved        */
} NX500_XMAC_SR0_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_SR0_BIT_T bf;
} NX500_XMAC_SR0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr1 */
/* => Shared Work Register 1 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sr1   0x00000804U
#define Adr_NX500_xmac0_xmac_sr1 0x00160804U
#define Adr_NX500_xmac1_xmac_sr1 0x00161804U
#define Adr_NX500_xmac2_xmac_sr1 0x00162804U
#define Adr_NX500_xmac3_xmac_sr1 0x00163804U
#define DFLT_VAL_NX500_xmac_sr1  0x00000000U

#define MSK_NX500_xmac_sr1_SR1      0x0000ffffU
#define SRT_NX500_xmac_sr1_SR1      0
#define DFLT_VAL_NX500_xmac_sr1_SR1 0x00000000U

enum {
	BFW_NX500_xmac_sr1_SR1       = 16, /* [15:0] */
	BFW_NX500_xmac_sr1_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SR1_BIT_Ttag {
	unsigned int SR1       : BFW_NX500_xmac_sr1_SR1;       /* Shared Register */
	unsigned int reserved1 : BFW_NX500_xmac_sr1_reserved1; /* reserved        */
} NX500_XMAC_SR1_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_SR1_BIT_T bf;
} NX500_XMAC_SR1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr2 */
/* => Shared Work Register 2 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sr2   0x00000808U
#define Adr_NX500_xmac0_xmac_sr2 0x00160808U
#define Adr_NX500_xmac1_xmac_sr2 0x00161808U
#define Adr_NX500_xmac2_xmac_sr2 0x00162808U
#define Adr_NX500_xmac3_xmac_sr2 0x00163808U
#define DFLT_VAL_NX500_xmac_sr2  0x00000000U

#define MSK_NX500_xmac_sr2_SR2      0x0000ffffU
#define SRT_NX500_xmac_sr2_SR2      0
#define DFLT_VAL_NX500_xmac_sr2_SR2 0x00000000U

enum {
	BFW_NX500_xmac_sr2_SR2       = 16, /* [15:0] */
	BFW_NX500_xmac_sr2_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SR2_BIT_Ttag {
	unsigned int SR2       : BFW_NX500_xmac_sr2_SR2;       /* Shared Register */
	unsigned int reserved1 : BFW_NX500_xmac_sr2_reserved1; /* reserved        */
} NX500_XMAC_SR2_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_SR2_BIT_T bf;
} NX500_XMAC_SR2_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr3 */
/* => Shared Work Register 3 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sr3   0x0000080CU
#define Adr_NX500_xmac0_xmac_sr3 0x0016080CU
#define Adr_NX500_xmac1_xmac_sr3 0x0016180CU
#define Adr_NX500_xmac2_xmac_sr3 0x0016280CU
#define Adr_NX500_xmac3_xmac_sr3 0x0016380CU
#define DFLT_VAL_NX500_xmac_sr3  0x00000000U

#define MSK_NX500_xmac_sr3_SR3      0x0000ffffU
#define SRT_NX500_xmac_sr3_SR3      0
#define DFLT_VAL_NX500_xmac_sr3_SR3 0x00000000U

enum {
	BFW_NX500_xmac_sr3_SR3       = 16, /* [15:0] */
	BFW_NX500_xmac_sr3_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SR3_BIT_Ttag {
	unsigned int SR3       : BFW_NX500_xmac_sr3_SR3;       /* Shared Register */
	unsigned int reserved1 : BFW_NX500_xmac_sr3_reserved1; /* reserved        */
} NX500_XMAC_SR3_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_SR3_BIT_T bf;
} NX500_XMAC_SR3_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr4 */
/* => Shared Work Register 4 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sr4   0x00000810U
#define Adr_NX500_xmac0_xmac_sr4 0x00160810U
#define Adr_NX500_xmac1_xmac_sr4 0x00161810U
#define Adr_NX500_xmac2_xmac_sr4 0x00162810U
#define Adr_NX500_xmac3_xmac_sr4 0x00163810U
#define DFLT_VAL_NX500_xmac_sr4  0x00000000U

#define MSK_NX500_xmac_sr4_SR4      0x0000ffffU
#define SRT_NX500_xmac_sr4_SR4      0
#define DFLT_VAL_NX500_xmac_sr4_SR4 0x00000000U

enum {
	BFW_NX500_xmac_sr4_SR4       = 16, /* [15:0] */
	BFW_NX500_xmac_sr4_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SR4_BIT_Ttag {
	unsigned int SR4       : BFW_NX500_xmac_sr4_SR4;       /* Shared Register */
	unsigned int reserved1 : BFW_NX500_xmac_sr4_reserved1; /* reserved        */
} NX500_XMAC_SR4_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_SR4_BIT_T bf;
} NX500_XMAC_SR4_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr5 */
/* => Shared Work Register 5 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sr5   0x00000814U
#define Adr_NX500_xmac0_xmac_sr5 0x00160814U
#define Adr_NX500_xmac1_xmac_sr5 0x00161814U
#define Adr_NX500_xmac2_xmac_sr5 0x00162814U
#define Adr_NX500_xmac3_xmac_sr5 0x00163814U
#define DFLT_VAL_NX500_xmac_sr5  0x00000000U

#define MSK_NX500_xmac_sr5_SR5      0x0000ffffU
#define SRT_NX500_xmac_sr5_SR5      0
#define DFLT_VAL_NX500_xmac_sr5_SR5 0x00000000U

enum {
	BFW_NX500_xmac_sr5_SR5       = 16, /* [15:0] */
	BFW_NX500_xmac_sr5_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SR5_BIT_Ttag {
	unsigned int SR5       : BFW_NX500_xmac_sr5_SR5;       /* Shared Register */
	unsigned int reserved1 : BFW_NX500_xmac_sr5_reserved1; /* reserved        */
} NX500_XMAC_SR5_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_SR5_BIT_T bf;
} NX500_XMAC_SR5_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr6 */
/* => Shared Work Register 6 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sr6   0x00000818U
#define Adr_NX500_xmac0_xmac_sr6 0x00160818U
#define Adr_NX500_xmac1_xmac_sr6 0x00161818U
#define Adr_NX500_xmac2_xmac_sr6 0x00162818U
#define Adr_NX500_xmac3_xmac_sr6 0x00163818U
#define DFLT_VAL_NX500_xmac_sr6  0x00000000U

#define MSK_NX500_xmac_sr6_SR6      0x0000ffffU
#define SRT_NX500_xmac_sr6_SR6      0
#define DFLT_VAL_NX500_xmac_sr6_SR6 0x00000000U

enum {
	BFW_NX500_xmac_sr6_SR6       = 16, /* [15:0] */
	BFW_NX500_xmac_sr6_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SR6_BIT_Ttag {
	unsigned int SR6       : BFW_NX500_xmac_sr6_SR6;       /* Shared Register */
	unsigned int reserved1 : BFW_NX500_xmac_sr6_reserved1; /* reserved        */
} NX500_XMAC_SR6_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_SR6_BIT_T bf;
} NX500_XMAC_SR6_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr7 */
/* => Shared Work Register 7 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sr7   0x0000081CU
#define Adr_NX500_xmac0_xmac_sr7 0x0016081CU
#define Adr_NX500_xmac1_xmac_sr7 0x0016181CU
#define Adr_NX500_xmac2_xmac_sr7 0x0016281CU
#define Adr_NX500_xmac3_xmac_sr7 0x0016381CU
#define DFLT_VAL_NX500_xmac_sr7  0x00000000U

#define MSK_NX500_xmac_sr7_SR7      0x0000ffffU
#define SRT_NX500_xmac_sr7_SR7      0
#define DFLT_VAL_NX500_xmac_sr7_SR7 0x00000000U

enum {
	BFW_NX500_xmac_sr7_SR7       = 16, /* [15:0] */
	BFW_NX500_xmac_sr7_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SR7_BIT_Ttag {
	unsigned int SR7       : BFW_NX500_xmac_sr7_SR7;       /* Shared Register */
	unsigned int reserved1 : BFW_NX500_xmac_sr7_reserved1; /* reserved        */
} NX500_XMAC_SR7_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_SR7_BIT_T bf;
} NX500_XMAC_SR7_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr8 */
/* => Shared Work Register 8 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sr8   0x00000820U
#define Adr_NX500_xmac0_xmac_sr8 0x00160820U
#define Adr_NX500_xmac1_xmac_sr8 0x00161820U
#define Adr_NX500_xmac2_xmac_sr8 0x00162820U
#define Adr_NX500_xmac3_xmac_sr8 0x00163820U
#define DFLT_VAL_NX500_xmac_sr8  0x00000000U

#define MSK_NX500_xmac_sr8_SR8      0x0000ffffU
#define SRT_NX500_xmac_sr8_SR8      0
#define DFLT_VAL_NX500_xmac_sr8_SR8 0x00000000U

enum {
	BFW_NX500_xmac_sr8_SR8       = 16, /* [15:0] */
	BFW_NX500_xmac_sr8_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SR8_BIT_Ttag {
	unsigned int SR8       : BFW_NX500_xmac_sr8_SR8;       /* Shared Register */
	unsigned int reserved1 : BFW_NX500_xmac_sr8_reserved1; /* reserved        */
} NX500_XMAC_SR8_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_SR8_BIT_T bf;
} NX500_XMAC_SR8_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr9 */
/* => Shared Work Register 9 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sr9   0x00000824U
#define Adr_NX500_xmac0_xmac_sr9 0x00160824U
#define Adr_NX500_xmac1_xmac_sr9 0x00161824U
#define Adr_NX500_xmac2_xmac_sr9 0x00162824U
#define Adr_NX500_xmac3_xmac_sr9 0x00163824U
#define DFLT_VAL_NX500_xmac_sr9  0x00000000U

#define MSK_NX500_xmac_sr9_SR9      0x0000ffffU
#define SRT_NX500_xmac_sr9_SR9      0
#define DFLT_VAL_NX500_xmac_sr9_SR9 0x00000000U

enum {
	BFW_NX500_xmac_sr9_SR9       = 16, /* [15:0] */
	BFW_NX500_xmac_sr9_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SR9_BIT_Ttag {
	unsigned int SR9       : BFW_NX500_xmac_sr9_SR9;       /* Shared Register */
	unsigned int reserved1 : BFW_NX500_xmac_sr9_reserved1; /* reserved        */
} NX500_XMAC_SR9_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_SR9_BIT_T bf;
} NX500_XMAC_SR9_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr10 */
/* => Shared Work Register 10 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sr10   0x00000828U
#define Adr_NX500_xmac0_xmac_sr10 0x00160828U
#define Adr_NX500_xmac1_xmac_sr10 0x00161828U
#define Adr_NX500_xmac2_xmac_sr10 0x00162828U
#define Adr_NX500_xmac3_xmac_sr10 0x00163828U
#define DFLT_VAL_NX500_xmac_sr10  0x00000000U

#define MSK_NX500_xmac_sr10_SR10      0x0000ffffU
#define SRT_NX500_xmac_sr10_SR10      0
#define DFLT_VAL_NX500_xmac_sr10_SR10 0x00000000U

enum {
	BFW_NX500_xmac_sr10_SR10      = 16, /* [15:0] */
	BFW_NX500_xmac_sr10_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SR10_BIT_Ttag {
	unsigned int SR10      : BFW_NX500_xmac_sr10_SR10;      /* Shared Register */
	unsigned int reserved1 : BFW_NX500_xmac_sr10_reserved1; /* reserved        */
} NX500_XMAC_SR10_BIT_T;

typedef union {
	unsigned int          val;
	NX500_XMAC_SR10_BIT_T bf;
} NX500_XMAC_SR10_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr11 */
/* => Shared Work Register 11 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sr11   0x0000082CU
#define Adr_NX500_xmac0_xmac_sr11 0x0016082CU
#define Adr_NX500_xmac1_xmac_sr11 0x0016182CU
#define Adr_NX500_xmac2_xmac_sr11 0x0016282CU
#define Adr_NX500_xmac3_xmac_sr11 0x0016382CU
#define DFLT_VAL_NX500_xmac_sr11  0x00000000U

#define MSK_NX500_xmac_sr11_SR11      0x0000ffffU
#define SRT_NX500_xmac_sr11_SR11      0
#define DFLT_VAL_NX500_xmac_sr11_SR11 0x00000000U

enum {
	BFW_NX500_xmac_sr11_SR11      = 16, /* [15:0] */
	BFW_NX500_xmac_sr11_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SR11_BIT_Ttag {
	unsigned int SR11      : BFW_NX500_xmac_sr11_SR11;      /* Shared Register */
	unsigned int reserved1 : BFW_NX500_xmac_sr11_reserved1; /* reserved        */
} NX500_XMAC_SR11_BIT_T;

typedef union {
	unsigned int          val;
	NX500_XMAC_SR11_BIT_T bf;
} NX500_XMAC_SR11_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr12 */
/* => Shared Work Register 12 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sr12   0x00000830U
#define Adr_NX500_xmac0_xmac_sr12 0x00160830U
#define Adr_NX500_xmac1_xmac_sr12 0x00161830U
#define Adr_NX500_xmac2_xmac_sr12 0x00162830U
#define Adr_NX500_xmac3_xmac_sr12 0x00163830U
#define DFLT_VAL_NX500_xmac_sr12  0x00000000U

#define MSK_NX500_xmac_sr12_SR12      0x0000ffffU
#define SRT_NX500_xmac_sr12_SR12      0
#define DFLT_VAL_NX500_xmac_sr12_SR12 0x00000000U

enum {
	BFW_NX500_xmac_sr12_SR12      = 16, /* [15:0] */
	BFW_NX500_xmac_sr12_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SR12_BIT_Ttag {
	unsigned int SR12      : BFW_NX500_xmac_sr12_SR12;      /* Shared Register */
	unsigned int reserved1 : BFW_NX500_xmac_sr12_reserved1; /* reserved        */
} NX500_XMAC_SR12_BIT_T;

typedef union {
	unsigned int          val;
	NX500_XMAC_SR12_BIT_T bf;
} NX500_XMAC_SR12_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr13 */
/* => Shared Work Register 13 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sr13   0x00000834U
#define Adr_NX500_xmac0_xmac_sr13 0x00160834U
#define Adr_NX500_xmac1_xmac_sr13 0x00161834U
#define Adr_NX500_xmac2_xmac_sr13 0x00162834U
#define Adr_NX500_xmac3_xmac_sr13 0x00163834U
#define DFLT_VAL_NX500_xmac_sr13  0x00000000U

#define MSK_NX500_xmac_sr13_SR13      0x0000ffffU
#define SRT_NX500_xmac_sr13_SR13      0
#define DFLT_VAL_NX500_xmac_sr13_SR13 0x00000000U

enum {
	BFW_NX500_xmac_sr13_SR13      = 16, /* [15:0] */
	BFW_NX500_xmac_sr13_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SR13_BIT_Ttag {
	unsigned int SR13      : BFW_NX500_xmac_sr13_SR13;      /* Shared Register */
	unsigned int reserved1 : BFW_NX500_xmac_sr13_reserved1; /* reserved        */
} NX500_XMAC_SR13_BIT_T;

typedef union {
	unsigned int          val;
	NX500_XMAC_SR13_BIT_T bf;
} NX500_XMAC_SR13_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr14 */
/* => Shared Work Register 14 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sr14   0x00000838U
#define Adr_NX500_xmac0_xmac_sr14 0x00160838U
#define Adr_NX500_xmac1_xmac_sr14 0x00161838U
#define Adr_NX500_xmac2_xmac_sr14 0x00162838U
#define Adr_NX500_xmac3_xmac_sr14 0x00163838U
#define DFLT_VAL_NX500_xmac_sr14  0x00000000U

#define MSK_NX500_xmac_sr14_SR14      0x0000ffffU
#define SRT_NX500_xmac_sr14_SR14      0
#define DFLT_VAL_NX500_xmac_sr14_SR14 0x00000000U

enum {
	BFW_NX500_xmac_sr14_SR14      = 16, /* [15:0] */
	BFW_NX500_xmac_sr14_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SR14_BIT_Ttag {
	unsigned int SR14      : BFW_NX500_xmac_sr14_SR14;      /* Shared Register */
	unsigned int reserved1 : BFW_NX500_xmac_sr14_reserved1; /* reserved        */
} NX500_XMAC_SR14_BIT_T;

typedef union {
	unsigned int          val;
	NX500_XMAC_SR14_BIT_T bf;
} NX500_XMAC_SR14_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr15 */
/* => Shared Work Register 15 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sr15   0x0000083CU
#define Adr_NX500_xmac0_xmac_sr15 0x0016083CU
#define Adr_NX500_xmac1_xmac_sr15 0x0016183CU
#define Adr_NX500_xmac2_xmac_sr15 0x0016283CU
#define Adr_NX500_xmac3_xmac_sr15 0x0016383CU
#define DFLT_VAL_NX500_xmac_sr15  0x00000000U

#define MSK_NX500_xmac_sr15_SR15      0x0000ffffU
#define SRT_NX500_xmac_sr15_SR15      0
#define DFLT_VAL_NX500_xmac_sr15_SR15 0x00000000U

enum {
	BFW_NX500_xmac_sr15_SR15      = 16, /* [15:0] */
	BFW_NX500_xmac_sr15_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SR15_BIT_Ttag {
	unsigned int SR15      : BFW_NX500_xmac_sr15_SR15;      /* Shared Register */
	unsigned int reserved1 : BFW_NX500_xmac_sr15_reserved1; /* reserved        */
} NX500_XMAC_SR15_BIT_T;

typedef union {
	unsigned int          val;
	NX500_XMAC_SR15_BIT_T bf;
} NX500_XMAC_SR15_T;

/* --------------------------------------------------------------------- */
/* Register xmac_status_shared0 */
/* => xMAC0 Shared Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_status_shared0   0x00000840U
#define Adr_NX500_xmac0_xmac_status_shared0 0x00160840U
#define Adr_NX500_xmac1_xmac_status_shared0 0x00161840U
#define Adr_NX500_xmac2_xmac_status_shared0 0x00162840U
#define Adr_NX500_xmac3_xmac_status_shared0 0x00163840U

#define MSK_NX500_xmac_status_shared0_gpio0_in  0x00000001U
#define SRT_NX500_xmac_status_shared0_gpio0_in  0
#define MSK_NX500_xmac_status_shared0_gpio1_in  0x00000002U
#define SRT_NX500_xmac_status_shared0_gpio1_in  1
#define MSK_NX500_xmac_status_shared0_rx_rdy    0x00000004U
#define SRT_NX500_xmac_status_shared0_rx_rdy    2
#define MSK_NX500_xmac_status_shared0_rx_ovf    0x00000008U
#define SRT_NX500_xmac_status_shared0_rx_ovf    3
#define MSK_NX500_xmac_status_shared0_tx_nxt    0x00000010U
#define SRT_NX500_xmac_status_shared0_tx_nxt    4
#define MSK_NX500_xmac_status_shared0_tx_ufl    0x00000020U
#define SRT_NX500_xmac_status_shared0_tx_ufl    5
#define MSK_NX500_xmac_status_shared0_utx_empty 0x00000040U
#define SRT_NX500_xmac_status_shared0_utx_empty 6
#define MSK_NX500_xmac_status_shared0_brec      0x00000080U
#define SRT_NX500_xmac_status_shared0_brec      7
#define MSK_NX500_xmac_status_shared0_btran     0x00000100U
#define SRT_NX500_xmac_status_shared0_btran     8
#define MSK_NX500_xmac_status_shared0_stat_rpu  0x00000200U
#define SRT_NX500_xmac_status_shared0_stat_rpu  9
#define MSK_NX500_xmac_status_shared0_stat_tpu  0x00000400U
#define SRT_NX500_xmac_status_shared0_stat_tpu  10
#define MSK_NX500_xmac_status_shared0_phy_led0  0x00001000U
#define SRT_NX500_xmac_status_shared0_phy_led0  12
#define MSK_NX500_xmac_status_shared0_phy_led1  0x00002000U
#define SRT_NX500_xmac_status_shared0_phy_led1  13
#define MSK_NX500_xmac_status_shared0_phy_led2  0x00004000U
#define SRT_NX500_xmac_status_shared0_phy_led2  14
#define MSK_NX500_xmac_status_shared0_phy_led3  0x00008000U
#define SRT_NX500_xmac_status_shared0_phy_led3  15

enum {
	BFW_NX500_xmac_status_shared0_gpio0_in  = 1,  /* [0] */
	BFW_NX500_xmac_status_shared0_gpio1_in  = 1,  /* [1] */
	BFW_NX500_xmac_status_shared0_rx_rdy    = 1,  /* [2] */
	BFW_NX500_xmac_status_shared0_rx_ovf    = 1,  /* [3] */
	BFW_NX500_xmac_status_shared0_tx_nxt    = 1,  /* [4] */
	BFW_NX500_xmac_status_shared0_tx_ufl    = 1,  /* [5] */
	BFW_NX500_xmac_status_shared0_utx_empty = 1,  /* [6] */
	BFW_NX500_xmac_status_shared0_brec      = 1,  /* [7] */
	BFW_NX500_xmac_status_shared0_btran     = 1,  /* [8] */
	BFW_NX500_xmac_status_shared0_stat_rpu  = 1,  /* [9] */
	BFW_NX500_xmac_status_shared0_stat_tpu  = 1,  /* [10] */
	BFW_NX500_xmac_status_shared0_reserved1 = 1,  /* [11] */
	BFW_NX500_xmac_status_shared0_phy_led0  = 1,  /* [12] */
	BFW_NX500_xmac_status_shared0_phy_led1  = 1,  /* [13] */
	BFW_NX500_xmac_status_shared0_phy_led2  = 1,  /* [14] */
	BFW_NX500_xmac_status_shared0_phy_led3  = 1,  /* [15] */
	BFW_NX500_xmac_status_shared0_reserved2 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_STATUS_SHARED0_BIT_Ttag {
	unsigned int gpio0_in  : BFW_NX500_xmac_status_shared0_gpio0_in;  /* value at external gpio1 pin                                           */
	unsigned int gpio1_in  : BFW_NX500_xmac_status_shared0_gpio1_in;  /* value at external gpio2 pin                                           */
	unsigned int rx_rdy    : BFW_NX500_xmac_status_shared0_rx_rdy;    /* received bytes are valid at output of URX_FIFO                        */
	unsigned int rx_ovf    : BFW_NX500_xmac_status_shared0_rx_ovf;    /* receive overflow (too much data in URX_FIFO)                          */
	unsigned int tx_nxt    : BFW_NX500_xmac_status_shared0_tx_nxt;    /* put next tx_word to UTX_FIFO: at least one entry of UTX_FIFO is empty */
	unsigned int tx_ufl    : BFW_NX500_xmac_status_shared0_tx_ufl;    /* transmit underflow (not enough data in UTX_FIFO)                      */
	unsigned int utx_empty : BFW_NX500_xmac_status_shared0_utx_empty; /* UTX_FIFO is empty                                                     */
	unsigned int brec      : BFW_NX500_xmac_status_shared0_brec;      /* bit_received (active for 1 cc)                                        */
	unsigned int btran     : BFW_NX500_xmac_status_shared0_btran;     /* bit_transmitted (active for 1 cc)                                     */
	unsigned int stat_rpu  : BFW_NX500_xmac_status_shared0_stat_rpu;  /* set and reset by RPU command bits                                     */
	unsigned int stat_tpu  : BFW_NX500_xmac_status_shared0_stat_tpu;  /* set and reset by TPU command bits                                     */
	unsigned int reserved1 : BFW_NX500_xmac_status_shared0_reserved1; /* reserved                                                              */
	unsigned int phy_led0  : BFW_NX500_xmac_status_shared0_phy_led0;  /* Internal Phy0 LED0, usually link_status                               */
	unsigned int phy_led1  : BFW_NX500_xmac_status_shared0_phy_led1;  /* Internal Phy0 LED1, usually activity                                  */
	unsigned int phy_led2  : BFW_NX500_xmac_status_shared0_phy_led2;  /* Internal Phy0 LED2, usually speed100                                  */
	unsigned int phy_led3  : BFW_NX500_xmac_status_shared0_phy_led3;  /* Internal Phy0 LED3, usually full_duplex                               */
	unsigned int reserved2 : BFW_NX500_xmac_status_shared0_reserved2; /* reserved                                                              */
} NX500_XMAC_STATUS_SHARED0_BIT_T;

typedef union {
	unsigned int                    val;
	NX500_XMAC_STATUS_SHARED0_BIT_T bf;
} NX500_XMAC_STATUS_SHARED0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_config_shared0 */
/* => xMAC0 Shared Config Register */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_config_shared0   0x00000844U
#define Adr_NX500_xmac0_xmac_config_shared0 0x00160844U
#define Adr_NX500_xmac1_xmac_config_shared0 0x00161844U
#define Adr_NX500_xmac2_xmac_config_shared0 0x00162844U
#define Adr_NX500_xmac3_xmac_config_shared0 0x00163844U
#define DFLT_VAL_NX500_xmac_config_shared0  0x00000088U

#define MSK_NX500_xmac_config_shared0_rx_nof_bits        0x0000000fU
#define SRT_NX500_xmac_config_shared0_rx_nof_bits        0
#define DFLT_VAL_NX500_xmac_config_shared0_rx_nof_bits   0x00000008U
#define MSK_NX500_xmac_config_shared0_tx_nof_bits        0x000000f0U
#define SRT_NX500_xmac_config_shared0_tx_nof_bits        4
#define DFLT_VAL_NX500_xmac_config_shared0_tx_nof_bits   0x00000080U
#define MSK_NX500_xmac_config_shared0_rx_shift_lr        0x00000100U
#define SRT_NX500_xmac_config_shared0_rx_shift_lr        8
#define DFLT_VAL_NX500_xmac_config_shared0_rx_shift_lr   0x00000000U
#define MSK_NX500_xmac_config_shared0_tx_shift_lr        0x00000200U
#define SRT_NX500_xmac_config_shared0_tx_shift_lr        9
#define DFLT_VAL_NX500_xmac_config_shared0_tx_shift_lr   0x00000000U
#define MSK_NX500_xmac_config_shared0_reset_rx_fifo      0x00000400U
#define SRT_NX500_xmac_config_shared0_reset_rx_fifo      10
#define DFLT_VAL_NX500_xmac_config_shared0_reset_rx_fifo 0x00000000U
#define MSK_NX500_xmac_config_shared0_reset_tx_fifo      0x00000800U
#define SRT_NX500_xmac_config_shared0_reset_tx_fifo      11
#define DFLT_VAL_NX500_xmac_config_shared0_reset_tx_fifo 0x00000000U
#define MSK_NX500_xmac_config_shared0_gpio0_out          0x00001000U
#define SRT_NX500_xmac_config_shared0_gpio0_out          12
#define DFLT_VAL_NX500_xmac_config_shared0_gpio0_out     0x00000000U
#define MSK_NX500_xmac_config_shared0_gpio0_oe           0x00002000U
#define SRT_NX500_xmac_config_shared0_gpio0_oe           13
#define DFLT_VAL_NX500_xmac_config_shared0_gpio0_oe      0x00000000U
#define MSK_NX500_xmac_config_shared0_gpio1_out          0x00004000U
#define SRT_NX500_xmac_config_shared0_gpio1_out          14
#define DFLT_VAL_NX500_xmac_config_shared0_gpio1_out     0x00000000U
#define MSK_NX500_xmac_config_shared0_gpio1_oe           0x00008000U
#define SRT_NX500_xmac_config_shared0_gpio1_oe           15
#define DFLT_VAL_NX500_xmac_config_shared0_gpio1_oe      0x00000000U

enum {
	BFW_NX500_xmac_config_shared0_rx_nof_bits   = 4,  /* [3:0] */
	BFW_NX500_xmac_config_shared0_tx_nof_bits   = 4,  /* [7:4] */
	BFW_NX500_xmac_config_shared0_rx_shift_lr   = 1,  /* [8] */
	BFW_NX500_xmac_config_shared0_tx_shift_lr   = 1,  /* [9] */
	BFW_NX500_xmac_config_shared0_reset_rx_fifo = 1,  /* [10] */
	BFW_NX500_xmac_config_shared0_reset_tx_fifo = 1,  /* [11] */
	BFW_NX500_xmac_config_shared0_gpio0_out     = 1,  /* [12] */
	BFW_NX500_xmac_config_shared0_gpio0_oe      = 1,  /* [13] */
	BFW_NX500_xmac_config_shared0_gpio1_out     = 1,  /* [14] */
	BFW_NX500_xmac_config_shared0_gpio1_oe      = 1,  /* [15] */
	BFW_NX500_xmac_config_shared0_reserved1     = 16  /* [31:16] */
};

typedef struct NX500_XMAC_CONFIG_SHARED0_BIT_Ttag {
	unsigned int rx_nof_bits   : BFW_NX500_xmac_config_shared0_rx_nof_bits;   /* Number of bits written by SBU to rx-register, only used for rx_hw_count        */
	unsigned int tx_nof_bits   : BFW_NX500_xmac_config_shared0_tx_nof_bits;   /* Number of bits read by OBU from tx-register                                    */
	unsigned int rx_shift_lr   : BFW_NX500_xmac_config_shared0_rx_shift_lr;   /* 1: SBU writes incoming bits to position 0 of register rx and shifts rx left,   */
	                                                                          /* 0: SBU writes incoming bits to position 15 of register rx and shifts rx right  */
	unsigned int tx_shift_lr   : BFW_NX500_xmac_config_shared0_tx_shift_lr;   /* 1: OBU reads outgoing bits from position 15 of register tx and shifts tx left, */
	                                                                          /* 0: OBU reads outgoing bits from position 0 of register tx and shifts tx right  */
	unsigned int reset_rx_fifo : BFW_NX500_xmac_config_shared0_reset_rx_fifo; /* reset URX_FIFO and rx_ovf bit inside status_shared register                    */
	unsigned int reset_tx_fifo : BFW_NX500_xmac_config_shared0_reset_tx_fifo; /* reset UTX_FIFO and tx_ufl bit inside status_shared register                    */
	unsigned int gpio0_out     : BFW_NX500_xmac_config_shared0_gpio0_out;     /* General Purpose IO 0 output                                                    */
	unsigned int gpio0_oe      : BFW_NX500_xmac_config_shared0_gpio0_oe;      /* General Purpose IO 0 output enable                                             */
	unsigned int gpio1_out     : BFW_NX500_xmac_config_shared0_gpio1_out;     /* General Purpose IO 1 output                                                    */
	unsigned int gpio1_oe      : BFW_NX500_xmac_config_shared0_gpio1_oe;      /* General Purpose IO 1 output enable                                             */
	unsigned int reserved1     : BFW_NX500_xmac_config_shared0_reserved1;     /* reserved                                                                       */
} NX500_XMAC_CONFIG_SHARED0_BIT_T;

typedef union {
	unsigned int                    val;
	NX500_XMAC_CONFIG_SHARED0_BIT_T bf;
} NX500_XMAC_CONFIG_SHARED0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_status_shared1 */
/* => xMAC1 Shared Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_status_shared1   0x00000848U
#define Adr_NX500_xmac0_xmac_status_shared1 0x00160848U
#define Adr_NX500_xmac1_xmac_status_shared1 0x00161848U
#define Adr_NX500_xmac2_xmac_status_shared1 0x00162848U
#define Adr_NX500_xmac3_xmac_status_shared1 0x00163848U

#define MSK_NX500_xmac_status_shared1_gpio0_in  0x00000001U
#define SRT_NX500_xmac_status_shared1_gpio0_in  0
#define MSK_NX500_xmac_status_shared1_gpio1_in  0x00000002U
#define SRT_NX500_xmac_status_shared1_gpio1_in  1
#define MSK_NX500_xmac_status_shared1_rx_rdy    0x00000004U
#define SRT_NX500_xmac_status_shared1_rx_rdy    2
#define MSK_NX500_xmac_status_shared1_rx_ovf    0x00000008U
#define SRT_NX500_xmac_status_shared1_rx_ovf    3
#define MSK_NX500_xmac_status_shared1_tx_nxt    0x00000010U
#define SRT_NX500_xmac_status_shared1_tx_nxt    4
#define MSK_NX500_xmac_status_shared1_tx_ufl    0x00000020U
#define SRT_NX500_xmac_status_shared1_tx_ufl    5
#define MSK_NX500_xmac_status_shared1_utx_empty 0x00000040U
#define SRT_NX500_xmac_status_shared1_utx_empty 6
#define MSK_NX500_xmac_status_shared1_brec      0x00000080U
#define SRT_NX500_xmac_status_shared1_brec      7
#define MSK_NX500_xmac_status_shared1_btran     0x00000100U
#define SRT_NX500_xmac_status_shared1_btran     8
#define MSK_NX500_xmac_status_shared1_stat_rpu  0x00000200U
#define SRT_NX500_xmac_status_shared1_stat_rpu  9
#define MSK_NX500_xmac_status_shared1_stat_tpu  0x00000400U
#define SRT_NX500_xmac_status_shared1_stat_tpu  10
#define MSK_NX500_xmac_status_shared1_phy_led0  0x00001000U
#define SRT_NX500_xmac_status_shared1_phy_led0  12
#define MSK_NX500_xmac_status_shared1_phy_led1  0x00002000U
#define SRT_NX500_xmac_status_shared1_phy_led1  13
#define MSK_NX500_xmac_status_shared1_phy_led2  0x00004000U
#define SRT_NX500_xmac_status_shared1_phy_led2  14
#define MSK_NX500_xmac_status_shared1_phy_led3  0x00008000U
#define SRT_NX500_xmac_status_shared1_phy_led3  15

enum {
	BFW_NX500_xmac_status_shared1_gpio0_in  = 1,  /* [0] */
	BFW_NX500_xmac_status_shared1_gpio1_in  = 1,  /* [1] */
	BFW_NX500_xmac_status_shared1_rx_rdy    = 1,  /* [2] */
	BFW_NX500_xmac_status_shared1_rx_ovf    = 1,  /* [3] */
	BFW_NX500_xmac_status_shared1_tx_nxt    = 1,  /* [4] */
	BFW_NX500_xmac_status_shared1_tx_ufl    = 1,  /* [5] */
	BFW_NX500_xmac_status_shared1_utx_empty = 1,  /* [6] */
	BFW_NX500_xmac_status_shared1_brec      = 1,  /* [7] */
	BFW_NX500_xmac_status_shared1_btran     = 1,  /* [8] */
	BFW_NX500_xmac_status_shared1_stat_rpu  = 1,  /* [9] */
	BFW_NX500_xmac_status_shared1_stat_tpu  = 1,  /* [10] */
	BFW_NX500_xmac_status_shared1_reserved1 = 1,  /* [11] */
	BFW_NX500_xmac_status_shared1_phy_led0  = 1,  /* [12] */
	BFW_NX500_xmac_status_shared1_phy_led1  = 1,  /* [13] */
	BFW_NX500_xmac_status_shared1_phy_led2  = 1,  /* [14] */
	BFW_NX500_xmac_status_shared1_phy_led3  = 1,  /* [15] */
	BFW_NX500_xmac_status_shared1_reserved2 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_STATUS_SHARED1_BIT_Ttag {
	unsigned int gpio0_in  : BFW_NX500_xmac_status_shared1_gpio0_in;  /* value at external gpio1 pin                                           */
	unsigned int gpio1_in  : BFW_NX500_xmac_status_shared1_gpio1_in;  /* value at external gpio2 pin                                           */
	unsigned int rx_rdy    : BFW_NX500_xmac_status_shared1_rx_rdy;    /* received bytes are valid at output of URX_FIFO                        */
	unsigned int rx_ovf    : BFW_NX500_xmac_status_shared1_rx_ovf;    /* receive overflow (too much data in URX_FIFO)                          */
	unsigned int tx_nxt    : BFW_NX500_xmac_status_shared1_tx_nxt;    /* put next tx_word to UTX_FIFO: at least one entry of UTX_FIFO is empty */
	unsigned int tx_ufl    : BFW_NX500_xmac_status_shared1_tx_ufl;    /* transmit underflow (not enough data in UTX_FIFO)                      */
	unsigned int utx_empty : BFW_NX500_xmac_status_shared1_utx_empty; /* UTX_FIFO is empty                                                     */
	unsigned int brec      : BFW_NX500_xmac_status_shared1_brec;      /* bit_received (active for 1 cc)                                        */
	unsigned int btran     : BFW_NX500_xmac_status_shared1_btran;     /* bit_transmitted (active for 1 cc)                                     */
	unsigned int stat_rpu  : BFW_NX500_xmac_status_shared1_stat_rpu;  /* set and reset by RPU command bits                                     */
	unsigned int stat_tpu  : BFW_NX500_xmac_status_shared1_stat_tpu;  /* set and reset by TPU command bits                                     */
	unsigned int reserved1 : BFW_NX500_xmac_status_shared1_reserved1; /* reserved                                                              */
	unsigned int phy_led0  : BFW_NX500_xmac_status_shared1_phy_led0;  /* Internal Phy1 LED0, usually link_status                               */
	unsigned int phy_led1  : BFW_NX500_xmac_status_shared1_phy_led1;  /* Internal Phy1 LED1, usually activity                                  */
	unsigned int phy_led2  : BFW_NX500_xmac_status_shared1_phy_led2;  /* Internal Phy1 LED2, usually speed100                                  */
	unsigned int phy_led3  : BFW_NX500_xmac_status_shared1_phy_led3;  /* Internal Phy1 LED3, usually full_duplex                               */
	unsigned int reserved2 : BFW_NX500_xmac_status_shared1_reserved2; /* reserved                                                              */
} NX500_XMAC_STATUS_SHARED1_BIT_T;

typedef union {
	unsigned int                    val;
	NX500_XMAC_STATUS_SHARED1_BIT_T bf;
} NX500_XMAC_STATUS_SHARED1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_config_shared1 */
/* => xMAC1 Shared Config Register */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_config_shared1   0x0000084CU
#define Adr_NX500_xmac0_xmac_config_shared1 0x0016084CU
#define Adr_NX500_xmac1_xmac_config_shared1 0x0016184CU
#define Adr_NX500_xmac2_xmac_config_shared1 0x0016284CU
#define Adr_NX500_xmac3_xmac_config_shared1 0x0016384CU
#define DFLT_VAL_NX500_xmac_config_shared1  0x00000088U

#define MSK_NX500_xmac_config_shared1_rx_nof_bits        0x0000000fU
#define SRT_NX500_xmac_config_shared1_rx_nof_bits        0
#define DFLT_VAL_NX500_xmac_config_shared1_rx_nof_bits   0x00000008U
#define MSK_NX500_xmac_config_shared1_tx_nof_bits        0x000000f0U
#define SRT_NX500_xmac_config_shared1_tx_nof_bits        4
#define DFLT_VAL_NX500_xmac_config_shared1_tx_nof_bits   0x00000080U
#define MSK_NX500_xmac_config_shared1_rx_shift_lr        0x00000100U
#define SRT_NX500_xmac_config_shared1_rx_shift_lr        8
#define DFLT_VAL_NX500_xmac_config_shared1_rx_shift_lr   0x00000000U
#define MSK_NX500_xmac_config_shared1_tx_shift_lr        0x00000200U
#define SRT_NX500_xmac_config_shared1_tx_shift_lr        9
#define DFLT_VAL_NX500_xmac_config_shared1_tx_shift_lr   0x00000000U
#define MSK_NX500_xmac_config_shared1_reset_rx_fifo      0x00000400U
#define SRT_NX500_xmac_config_shared1_reset_rx_fifo      10
#define DFLT_VAL_NX500_xmac_config_shared1_reset_rx_fifo 0x00000000U
#define MSK_NX500_xmac_config_shared1_reset_tx_fifo      0x00000800U
#define SRT_NX500_xmac_config_shared1_reset_tx_fifo      11
#define DFLT_VAL_NX500_xmac_config_shared1_reset_tx_fifo 0x00000000U
#define MSK_NX500_xmac_config_shared1_gpio0_out          0x00001000U
#define SRT_NX500_xmac_config_shared1_gpio0_out          12
#define DFLT_VAL_NX500_xmac_config_shared1_gpio0_out     0x00000000U
#define MSK_NX500_xmac_config_shared1_gpio0_oe           0x00002000U
#define SRT_NX500_xmac_config_shared1_gpio0_oe           13
#define DFLT_VAL_NX500_xmac_config_shared1_gpio0_oe      0x00000000U
#define MSK_NX500_xmac_config_shared1_gpio1_out          0x00004000U
#define SRT_NX500_xmac_config_shared1_gpio1_out          14
#define DFLT_VAL_NX500_xmac_config_shared1_gpio1_out     0x00000000U
#define MSK_NX500_xmac_config_shared1_gpio1_oe           0x00008000U
#define SRT_NX500_xmac_config_shared1_gpio1_oe           15
#define DFLT_VAL_NX500_xmac_config_shared1_gpio1_oe      0x00000000U

enum {
	BFW_NX500_xmac_config_shared1_rx_nof_bits   = 4,  /* [3:0] */
	BFW_NX500_xmac_config_shared1_tx_nof_bits   = 4,  /* [7:4] */
	BFW_NX500_xmac_config_shared1_rx_shift_lr   = 1,  /* [8] */
	BFW_NX500_xmac_config_shared1_tx_shift_lr   = 1,  /* [9] */
	BFW_NX500_xmac_config_shared1_reset_rx_fifo = 1,  /* [10] */
	BFW_NX500_xmac_config_shared1_reset_tx_fifo = 1,  /* [11] */
	BFW_NX500_xmac_config_shared1_gpio0_out     = 1,  /* [12] */
	BFW_NX500_xmac_config_shared1_gpio0_oe      = 1,  /* [13] */
	BFW_NX500_xmac_config_shared1_gpio1_out     = 1,  /* [14] */
	BFW_NX500_xmac_config_shared1_gpio1_oe      = 1,  /* [15] */
	BFW_NX500_xmac_config_shared1_reserved1     = 16  /* [31:16] */
};

typedef struct NX500_XMAC_CONFIG_SHARED1_BIT_Ttag {
	unsigned int rx_nof_bits   : BFW_NX500_xmac_config_shared1_rx_nof_bits;   /* Number of bits written by SBU to rx-register, only used for rx_hw_count        */
	unsigned int tx_nof_bits   : BFW_NX500_xmac_config_shared1_tx_nof_bits;   /* Number of bits read by OBU from tx-register                                    */
	unsigned int rx_shift_lr   : BFW_NX500_xmac_config_shared1_rx_shift_lr;   /* 1: SBU writes incoming bits to position 0 of register rx and shifts rx left,   */
	                                                                          /* 0: SBU writes incoming bits to position 15 of register rx and shifts rx right  */
	unsigned int tx_shift_lr   : BFW_NX500_xmac_config_shared1_tx_shift_lr;   /* 1: OBU reads outgoing bits from position 15 of register tx and shifts tx left, */
	                                                                          /* 0: OBU reads outgoing bits from position 0 of register tx and shifts tx right  */
	unsigned int reset_rx_fifo : BFW_NX500_xmac_config_shared1_reset_rx_fifo; /* reset URX_FIFO and rx_ovf bit inside status_shared register                    */
	unsigned int reset_tx_fifo : BFW_NX500_xmac_config_shared1_reset_tx_fifo; /* reset UTX_FIFO and tx_ufl bit inside status_shared register                    */
	unsigned int gpio0_out     : BFW_NX500_xmac_config_shared1_gpio0_out;     /* General Purpose IO 0 output                                                    */
	unsigned int gpio0_oe      : BFW_NX500_xmac_config_shared1_gpio0_oe;      /* General Purpose IO 0 output enable                                             */
	unsigned int gpio1_out     : BFW_NX500_xmac_config_shared1_gpio1_out;     /* General Purpose IO 1 output                                                    */
	unsigned int gpio1_oe      : BFW_NX500_xmac_config_shared1_gpio1_oe;      /* General Purpose IO 1 output enable                                             */
	unsigned int reserved1     : BFW_NX500_xmac_config_shared1_reserved1;     /* reserved                                                                       */
} NX500_XMAC_CONFIG_SHARED1_BIT_T;

typedef union {
	unsigned int                    val;
	NX500_XMAC_CONFIG_SHARED1_BIT_T bf;
} NX500_XMAC_CONFIG_SHARED1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_status_shared2 */
/* => xMAC2 Shared Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_status_shared2   0x00000850U
#define Adr_NX500_xmac0_xmac_status_shared2 0x00160850U
#define Adr_NX500_xmac1_xmac_status_shared2 0x00161850U
#define Adr_NX500_xmac2_xmac_status_shared2 0x00162850U
#define Adr_NX500_xmac3_xmac_status_shared2 0x00163850U

#define MSK_NX500_xmac_status_shared2_gpio0_in  0x00000001U
#define SRT_NX500_xmac_status_shared2_gpio0_in  0
#define MSK_NX500_xmac_status_shared2_gpio1_in  0x00000002U
#define SRT_NX500_xmac_status_shared2_gpio1_in  1
#define MSK_NX500_xmac_status_shared2_rx_rdy    0x00000004U
#define SRT_NX500_xmac_status_shared2_rx_rdy    2
#define MSK_NX500_xmac_status_shared2_rx_ovf    0x00000008U
#define SRT_NX500_xmac_status_shared2_rx_ovf    3
#define MSK_NX500_xmac_status_shared2_tx_nxt    0x00000010U
#define SRT_NX500_xmac_status_shared2_tx_nxt    4
#define MSK_NX500_xmac_status_shared2_tx_ufl    0x00000020U
#define SRT_NX500_xmac_status_shared2_tx_ufl    5
#define MSK_NX500_xmac_status_shared2_utx_empty 0x00000040U
#define SRT_NX500_xmac_status_shared2_utx_empty 6
#define MSK_NX500_xmac_status_shared2_brec      0x00000080U
#define SRT_NX500_xmac_status_shared2_brec      7
#define MSK_NX500_xmac_status_shared2_btran     0x00000100U
#define SRT_NX500_xmac_status_shared2_btran     8
#define MSK_NX500_xmac_status_shared2_stat_rpu  0x00000200U
#define SRT_NX500_xmac_status_shared2_stat_rpu  9
#define MSK_NX500_xmac_status_shared2_stat_tpu  0x00000400U
#define SRT_NX500_xmac_status_shared2_stat_tpu  10
#define MSK_NX500_xmac_status_shared2_phy_led0  0x00001000U
#define SRT_NX500_xmac_status_shared2_phy_led0  12
#define MSK_NX500_xmac_status_shared2_phy_led1  0x00002000U
#define SRT_NX500_xmac_status_shared2_phy_led1  13
#define MSK_NX500_xmac_status_shared2_phy_led2  0x00004000U
#define SRT_NX500_xmac_status_shared2_phy_led2  14
#define MSK_NX500_xmac_status_shared2_phy_led3  0x00008000U
#define SRT_NX500_xmac_status_shared2_phy_led3  15

enum {
	BFW_NX500_xmac_status_shared2_gpio0_in  = 1,  /* [0] */
	BFW_NX500_xmac_status_shared2_gpio1_in  = 1,  /* [1] */
	BFW_NX500_xmac_status_shared2_rx_rdy    = 1,  /* [2] */
	BFW_NX500_xmac_status_shared2_rx_ovf    = 1,  /* [3] */
	BFW_NX500_xmac_status_shared2_tx_nxt    = 1,  /* [4] */
	BFW_NX500_xmac_status_shared2_tx_ufl    = 1,  /* [5] */
	BFW_NX500_xmac_status_shared2_utx_empty = 1,  /* [6] */
	BFW_NX500_xmac_status_shared2_brec      = 1,  /* [7] */
	BFW_NX500_xmac_status_shared2_btran     = 1,  /* [8] */
	BFW_NX500_xmac_status_shared2_stat_rpu  = 1,  /* [9] */
	BFW_NX500_xmac_status_shared2_stat_tpu  = 1,  /* [10] */
	BFW_NX500_xmac_status_shared2_reserved1 = 1,  /* [11] */
	BFW_NX500_xmac_status_shared2_phy_led0  = 1,  /* [12] */
	BFW_NX500_xmac_status_shared2_phy_led1  = 1,  /* [13] */
	BFW_NX500_xmac_status_shared2_phy_led2  = 1,  /* [14] */
	BFW_NX500_xmac_status_shared2_phy_led3  = 1,  /* [15] */
	BFW_NX500_xmac_status_shared2_reserved2 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_STATUS_SHARED2_BIT_Ttag {
	unsigned int gpio0_in  : BFW_NX500_xmac_status_shared2_gpio0_in;  /* value at external gpio1 pin                                           */
	unsigned int gpio1_in  : BFW_NX500_xmac_status_shared2_gpio1_in;  /* value at external gpio2 pin                                           */
	unsigned int rx_rdy    : BFW_NX500_xmac_status_shared2_rx_rdy;    /* received bytes are valid at output of URX_FIFO                        */
	unsigned int rx_ovf    : BFW_NX500_xmac_status_shared2_rx_ovf;    /* receive overflow (too much data in URX_FIFO)                          */
	unsigned int tx_nxt    : BFW_NX500_xmac_status_shared2_tx_nxt;    /* put next tx_word to UTX_FIFO: at least one entry of UTX_FIFO is empty */
	unsigned int tx_ufl    : BFW_NX500_xmac_status_shared2_tx_ufl;    /* transmit underflow (not enough data in UTX_FIFO)                      */
	unsigned int utx_empty : BFW_NX500_xmac_status_shared2_utx_empty; /* UTX_FIFO is empty                                                     */
	unsigned int brec      : BFW_NX500_xmac_status_shared2_brec;      /* bit_received (active for 1 cc)                                        */
	unsigned int btran     : BFW_NX500_xmac_status_shared2_btran;     /* bit_transmitted (active for 1 cc)                                     */
	unsigned int stat_rpu  : BFW_NX500_xmac_status_shared2_stat_rpu;  /* set and reset by RPU command bits                                     */
	unsigned int stat_tpu  : BFW_NX500_xmac_status_shared2_stat_tpu;  /* set and reset by TPU command bits                                     */
	unsigned int reserved1 : BFW_NX500_xmac_status_shared2_reserved1; /* reserved                                                              */
	unsigned int phy_led0  : BFW_NX500_xmac_status_shared2_phy_led0;  /* not connected (zero)                                                  */
	unsigned int phy_led1  : BFW_NX500_xmac_status_shared2_phy_led1;  /* not connected (zero)                                                  */
	unsigned int phy_led2  : BFW_NX500_xmac_status_shared2_phy_led2;  /* not connected (zero)                                                  */
	unsigned int phy_led3  : BFW_NX500_xmac_status_shared2_phy_led3;  /* not connected (zero)                                                  */
	unsigned int reserved2 : BFW_NX500_xmac_status_shared2_reserved2; /* reserved                                                              */
} NX500_XMAC_STATUS_SHARED2_BIT_T;

typedef union {
	unsigned int                    val;
	NX500_XMAC_STATUS_SHARED2_BIT_T bf;
} NX500_XMAC_STATUS_SHARED2_T;

/* --------------------------------------------------------------------- */
/* Register xmac_config_shared2 */
/* => xMAC2 Shared Config Register */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_config_shared2   0x00000854U
#define Adr_NX500_xmac0_xmac_config_shared2 0x00160854U
#define Adr_NX500_xmac1_xmac_config_shared2 0x00161854U
#define Adr_NX500_xmac2_xmac_config_shared2 0x00162854U
#define Adr_NX500_xmac3_xmac_config_shared2 0x00163854U
#define DFLT_VAL_NX500_xmac_config_shared2  0x00000088U

#define MSK_NX500_xmac_config_shared2_rx_nof_bits        0x0000000fU
#define SRT_NX500_xmac_config_shared2_rx_nof_bits        0
#define DFLT_VAL_NX500_xmac_config_shared2_rx_nof_bits   0x00000008U
#define MSK_NX500_xmac_config_shared2_tx_nof_bits        0x000000f0U
#define SRT_NX500_xmac_config_shared2_tx_nof_bits        4
#define DFLT_VAL_NX500_xmac_config_shared2_tx_nof_bits   0x00000080U
#define MSK_NX500_xmac_config_shared2_rx_shift_lr        0x00000100U
#define SRT_NX500_xmac_config_shared2_rx_shift_lr        8
#define DFLT_VAL_NX500_xmac_config_shared2_rx_shift_lr   0x00000000U
#define MSK_NX500_xmac_config_shared2_tx_shift_lr        0x00000200U
#define SRT_NX500_xmac_config_shared2_tx_shift_lr        9
#define DFLT_VAL_NX500_xmac_config_shared2_tx_shift_lr   0x00000000U
#define MSK_NX500_xmac_config_shared2_reset_rx_fifo      0x00000400U
#define SRT_NX500_xmac_config_shared2_reset_rx_fifo      10
#define DFLT_VAL_NX500_xmac_config_shared2_reset_rx_fifo 0x00000000U
#define MSK_NX500_xmac_config_shared2_reset_tx_fifo      0x00000800U
#define SRT_NX500_xmac_config_shared2_reset_tx_fifo      11
#define DFLT_VAL_NX500_xmac_config_shared2_reset_tx_fifo 0x00000000U
#define MSK_NX500_xmac_config_shared2_gpio0_out          0x00001000U
#define SRT_NX500_xmac_config_shared2_gpio0_out          12
#define DFLT_VAL_NX500_xmac_config_shared2_gpio0_out     0x00000000U
#define MSK_NX500_xmac_config_shared2_gpio0_oe           0x00002000U
#define SRT_NX500_xmac_config_shared2_gpio0_oe           13
#define DFLT_VAL_NX500_xmac_config_shared2_gpio0_oe      0x00000000U
#define MSK_NX500_xmac_config_shared2_gpio1_out          0x00004000U
#define SRT_NX500_xmac_config_shared2_gpio1_out          14
#define DFLT_VAL_NX500_xmac_config_shared2_gpio1_out     0x00000000U
#define MSK_NX500_xmac_config_shared2_gpio1_oe           0x00008000U
#define SRT_NX500_xmac_config_shared2_gpio1_oe           15
#define DFLT_VAL_NX500_xmac_config_shared2_gpio1_oe      0x00000000U

enum {
	BFW_NX500_xmac_config_shared2_rx_nof_bits   = 4,  /* [3:0] */
	BFW_NX500_xmac_config_shared2_tx_nof_bits   = 4,  /* [7:4] */
	BFW_NX500_xmac_config_shared2_rx_shift_lr   = 1,  /* [8] */
	BFW_NX500_xmac_config_shared2_tx_shift_lr   = 1,  /* [9] */
	BFW_NX500_xmac_config_shared2_reset_rx_fifo = 1,  /* [10] */
	BFW_NX500_xmac_config_shared2_reset_tx_fifo = 1,  /* [11] */
	BFW_NX500_xmac_config_shared2_gpio0_out     = 1,  /* [12] */
	BFW_NX500_xmac_config_shared2_gpio0_oe      = 1,  /* [13] */
	BFW_NX500_xmac_config_shared2_gpio1_out     = 1,  /* [14] */
	BFW_NX500_xmac_config_shared2_gpio1_oe      = 1,  /* [15] */
	BFW_NX500_xmac_config_shared2_reserved1     = 16  /* [31:16] */
};

typedef struct NX500_XMAC_CONFIG_SHARED2_BIT_Ttag {
	unsigned int rx_nof_bits   : BFW_NX500_xmac_config_shared2_rx_nof_bits;   /* Number of bits written by SBU to rx-register, only used for rx_hw_count        */
	unsigned int tx_nof_bits   : BFW_NX500_xmac_config_shared2_tx_nof_bits;   /* Number of bits read by OBU from tx-register                                    */
	unsigned int rx_shift_lr   : BFW_NX500_xmac_config_shared2_rx_shift_lr;   /* 1: SBU reads incoming bits to position 0 of register rx and shifts rx left,    */
	                                                                          /* 0: SBU reads incoming bits to position 15 of register rx and shifts rx right   */
	unsigned int tx_shift_lr   : BFW_NX500_xmac_config_shared2_tx_shift_lr;   /* 1: OBU reads outgoing bits from position 15 of register tx and shifts tx left, */
	                                                                          /* 0: OBU reads outgoing bits from position 0 of register tx and shifts tx right  */
	unsigned int reset_rx_fifo : BFW_NX500_xmac_config_shared2_reset_rx_fifo; /* reset URX_FIFO and rx_ovf bit inside status_shared register                    */
	unsigned int reset_tx_fifo : BFW_NX500_xmac_config_shared2_reset_tx_fifo; /* reset UTX_FIFO and tx_ufl bit inside status_shared register                    */
	unsigned int gpio0_out     : BFW_NX500_xmac_config_shared2_gpio0_out;     /* General Purpose IO 0 output                                                    */
	unsigned int gpio0_oe      : BFW_NX500_xmac_config_shared2_gpio0_oe;      /* General Purpose IO 0 output enable                                             */
	unsigned int gpio1_out     : BFW_NX500_xmac_config_shared2_gpio1_out;     /* General Purpose IO 1 output                                                    */
	unsigned int gpio1_oe      : BFW_NX500_xmac_config_shared2_gpio1_oe;      /* General Purpose IO 1 output enable                                             */
	unsigned int reserved1     : BFW_NX500_xmac_config_shared2_reserved1;     /* reserved                                                                       */
} NX500_XMAC_CONFIG_SHARED2_BIT_T;

typedef union {
	unsigned int                    val;
	NX500_XMAC_CONFIG_SHARED2_BIT_T bf;
} NX500_XMAC_CONFIG_SHARED2_T;

/* --------------------------------------------------------------------- */
/* Register xmac_status_shared3 */
/* => xMAC3 Shared Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_status_shared3   0x00000858U
#define Adr_NX500_xmac0_xmac_status_shared3 0x00160858U
#define Adr_NX500_xmac1_xmac_status_shared3 0x00161858U
#define Adr_NX500_xmac2_xmac_status_shared3 0x00162858U
#define Adr_NX500_xmac3_xmac_status_shared3 0x00163858U

#define MSK_NX500_xmac_status_shared3_gpio0_in  0x00000001U
#define SRT_NX500_xmac_status_shared3_gpio0_in  0
#define MSK_NX500_xmac_status_shared3_gpio1_in  0x00000002U
#define SRT_NX500_xmac_status_shared3_gpio1_in  1
#define MSK_NX500_xmac_status_shared3_rx_rdy    0x00000004U
#define SRT_NX500_xmac_status_shared3_rx_rdy    2
#define MSK_NX500_xmac_status_shared3_rx_ovf    0x00000008U
#define SRT_NX500_xmac_status_shared3_rx_ovf    3
#define MSK_NX500_xmac_status_shared3_tx_nxt    0x00000010U
#define SRT_NX500_xmac_status_shared3_tx_nxt    4
#define MSK_NX500_xmac_status_shared3_tx_ufl    0x00000020U
#define SRT_NX500_xmac_status_shared3_tx_ufl    5
#define MSK_NX500_xmac_status_shared3_utx_empty 0x00000040U
#define SRT_NX500_xmac_status_shared3_utx_empty 6
#define MSK_NX500_xmac_status_shared3_brec      0x00000080U
#define SRT_NX500_xmac_status_shared3_brec      7
#define MSK_NX500_xmac_status_shared3_btran     0x00000100U
#define SRT_NX500_xmac_status_shared3_btran     8
#define MSK_NX500_xmac_status_shared3_stat_rpu  0x00000200U
#define SRT_NX500_xmac_status_shared3_stat_rpu  9
#define MSK_NX500_xmac_status_shared3_stat_tpu  0x00000400U
#define SRT_NX500_xmac_status_shared3_stat_tpu  10
#define MSK_NX500_xmac_status_shared3_phy_led0  0x00001000U
#define SRT_NX500_xmac_status_shared3_phy_led0  12
#define MSK_NX500_xmac_status_shared3_phy_led1  0x00002000U
#define SRT_NX500_xmac_status_shared3_phy_led1  13
#define MSK_NX500_xmac_status_shared3_phy_led2  0x00004000U
#define SRT_NX500_xmac_status_shared3_phy_led2  14
#define MSK_NX500_xmac_status_shared3_phy_led3  0x00008000U
#define SRT_NX500_xmac_status_shared3_phy_led3  15

enum {
	BFW_NX500_xmac_status_shared3_gpio0_in  = 1,  /* [0] */
	BFW_NX500_xmac_status_shared3_gpio1_in  = 1,  /* [1] */
	BFW_NX500_xmac_status_shared3_rx_rdy    = 1,  /* [2] */
	BFW_NX500_xmac_status_shared3_rx_ovf    = 1,  /* [3] */
	BFW_NX500_xmac_status_shared3_tx_nxt    = 1,  /* [4] */
	BFW_NX500_xmac_status_shared3_tx_ufl    = 1,  /* [5] */
	BFW_NX500_xmac_status_shared3_utx_empty = 1,  /* [6] */
	BFW_NX500_xmac_status_shared3_brec      = 1,  /* [7] */
	BFW_NX500_xmac_status_shared3_btran     = 1,  /* [8] */
	BFW_NX500_xmac_status_shared3_stat_rpu  = 1,  /* [9] */
	BFW_NX500_xmac_status_shared3_stat_tpu  = 1,  /* [10] */
	BFW_NX500_xmac_status_shared3_reserved1 = 1,  /* [11] */
	BFW_NX500_xmac_status_shared3_phy_led0  = 1,  /* [12] */
	BFW_NX500_xmac_status_shared3_phy_led1  = 1,  /* [13] */
	BFW_NX500_xmac_status_shared3_phy_led2  = 1,  /* [14] */
	BFW_NX500_xmac_status_shared3_phy_led3  = 1,  /* [15] */
	BFW_NX500_xmac_status_shared3_reserved2 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_STATUS_SHARED3_BIT_Ttag {
	unsigned int gpio0_in  : BFW_NX500_xmac_status_shared3_gpio0_in;  /* value at external gpio1 pin                                           */
	unsigned int gpio1_in  : BFW_NX500_xmac_status_shared3_gpio1_in;  /* value at external gpio2 pin                                           */
	unsigned int rx_rdy    : BFW_NX500_xmac_status_shared3_rx_rdy;    /* received bytes are valid at output of URX_FIFO                        */
	unsigned int rx_ovf    : BFW_NX500_xmac_status_shared3_rx_ovf;    /* receive overflow (too much data in URX_FIFO)                          */
	unsigned int tx_nxt    : BFW_NX500_xmac_status_shared3_tx_nxt;    /* put next tx_word to UTX_FIFO: at least one entry of UTX_FIFO is empty */
	unsigned int tx_ufl    : BFW_NX500_xmac_status_shared3_tx_ufl;    /* transmit underflow (not enough data in UTX_FIFO)                      */
	unsigned int utx_empty : BFW_NX500_xmac_status_shared3_utx_empty; /* UTX_FIFO is empty                                                     */
	unsigned int brec      : BFW_NX500_xmac_status_shared3_brec;      /* bit_received (active for 1 cc)                                        */
	unsigned int btran     : BFW_NX500_xmac_status_shared3_btran;     /* bit_transmitted (active for 1 cc)                                     */
	unsigned int stat_rpu  : BFW_NX500_xmac_status_shared3_stat_rpu;  /* set and reset by RPU command bits                                     */
	unsigned int stat_tpu  : BFW_NX500_xmac_status_shared3_stat_tpu;  /* set and reset by TPU command bits                                     */
	unsigned int reserved1 : BFW_NX500_xmac_status_shared3_reserved1; /* reserved                                                              */
	unsigned int phy_led0  : BFW_NX500_xmac_status_shared3_phy_led0;  /* not connected (zero)                                                  */
	unsigned int phy_led1  : BFW_NX500_xmac_status_shared3_phy_led1;  /* not connected (zero)                                                  */
	unsigned int phy_led2  : BFW_NX500_xmac_status_shared3_phy_led2;  /* not connected (zero)                                                  */
	unsigned int phy_led3  : BFW_NX500_xmac_status_shared3_phy_led3;  /* not connected (zero)                                                  */
	unsigned int reserved2 : BFW_NX500_xmac_status_shared3_reserved2; /* reserved                                                              */
} NX500_XMAC_STATUS_SHARED3_BIT_T;

typedef union {
	unsigned int                    val;
	NX500_XMAC_STATUS_SHARED3_BIT_T bf;
} NX500_XMAC_STATUS_SHARED3_T;

/* --------------------------------------------------------------------- */
/* Register xmac_config_shared3 */
/* => xMAC3 Shared Config Register */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_config_shared3   0x0000085CU
#define Adr_NX500_xmac0_xmac_config_shared3 0x0016085CU
#define Adr_NX500_xmac1_xmac_config_shared3 0x0016185CU
#define Adr_NX500_xmac2_xmac_config_shared3 0x0016285CU
#define Adr_NX500_xmac3_xmac_config_shared3 0x0016385CU
#define DFLT_VAL_NX500_xmac_config_shared3  0x00000088U

#define MSK_NX500_xmac_config_shared3_rx_nof_bits        0x0000000fU
#define SRT_NX500_xmac_config_shared3_rx_nof_bits        0
#define DFLT_VAL_NX500_xmac_config_shared3_rx_nof_bits   0x00000008U
#define MSK_NX500_xmac_config_shared3_tx_nof_bits        0x000000f0U
#define SRT_NX500_xmac_config_shared3_tx_nof_bits        4
#define DFLT_VAL_NX500_xmac_config_shared3_tx_nof_bits   0x00000080U
#define MSK_NX500_xmac_config_shared3_rx_shift_lr        0x00000100U
#define SRT_NX500_xmac_config_shared3_rx_shift_lr        8
#define DFLT_VAL_NX500_xmac_config_shared3_rx_shift_lr   0x00000000U
#define MSK_NX500_xmac_config_shared3_tx_shift_lr        0x00000200U
#define SRT_NX500_xmac_config_shared3_tx_shift_lr        9
#define DFLT_VAL_NX500_xmac_config_shared3_tx_shift_lr   0x00000000U
#define MSK_NX500_xmac_config_shared3_reset_rx_fifo      0x00000400U
#define SRT_NX500_xmac_config_shared3_reset_rx_fifo      10
#define DFLT_VAL_NX500_xmac_config_shared3_reset_rx_fifo 0x00000000U
#define MSK_NX500_xmac_config_shared3_reset_tx_fifo      0x00000800U
#define SRT_NX500_xmac_config_shared3_reset_tx_fifo      11
#define DFLT_VAL_NX500_xmac_config_shared3_reset_tx_fifo 0x00000000U
#define MSK_NX500_xmac_config_shared3_gpio0_out          0x00001000U
#define SRT_NX500_xmac_config_shared3_gpio0_out          12
#define DFLT_VAL_NX500_xmac_config_shared3_gpio0_out     0x00000000U
#define MSK_NX500_xmac_config_shared3_gpio0_oe           0x00002000U
#define SRT_NX500_xmac_config_shared3_gpio0_oe           13
#define DFLT_VAL_NX500_xmac_config_shared3_gpio0_oe      0x00000000U
#define MSK_NX500_xmac_config_shared3_gpio1_out          0x00004000U
#define SRT_NX500_xmac_config_shared3_gpio1_out          14
#define DFLT_VAL_NX500_xmac_config_shared3_gpio1_out     0x00000000U
#define MSK_NX500_xmac_config_shared3_gpio1_oe           0x00008000U
#define SRT_NX500_xmac_config_shared3_gpio1_oe           15
#define DFLT_VAL_NX500_xmac_config_shared3_gpio1_oe      0x00000000U

enum {
	BFW_NX500_xmac_config_shared3_rx_nof_bits   = 4,  /* [3:0] */
	BFW_NX500_xmac_config_shared3_tx_nof_bits   = 4,  /* [7:4] */
	BFW_NX500_xmac_config_shared3_rx_shift_lr   = 1,  /* [8] */
	BFW_NX500_xmac_config_shared3_tx_shift_lr   = 1,  /* [9] */
	BFW_NX500_xmac_config_shared3_reset_rx_fifo = 1,  /* [10] */
	BFW_NX500_xmac_config_shared3_reset_tx_fifo = 1,  /* [11] */
	BFW_NX500_xmac_config_shared3_gpio0_out     = 1,  /* [12] */
	BFW_NX500_xmac_config_shared3_gpio0_oe      = 1,  /* [13] */
	BFW_NX500_xmac_config_shared3_gpio1_out     = 1,  /* [14] */
	BFW_NX500_xmac_config_shared3_gpio1_oe      = 1,  /* [15] */
	BFW_NX500_xmac_config_shared3_reserved1     = 16  /* [31:16] */
};

typedef struct NX500_XMAC_CONFIG_SHARED3_BIT_Ttag {
	unsigned int rx_nof_bits   : BFW_NX500_xmac_config_shared3_rx_nof_bits;   /* Number of bits written by SBU to rx-register, only used for rx_hw_count        */
	unsigned int tx_nof_bits   : BFW_NX500_xmac_config_shared3_tx_nof_bits;   /* Number of bits read by OBU from tx-register                                    */
	unsigned int rx_shift_lr   : BFW_NX500_xmac_config_shared3_rx_shift_lr;   /* 1: SBU reads incoming bits to position 0 of register rx and shifts rx left,    */
	                                                                          /* 0: SBU reads incoming bits to position 15 of register rx and shifts rx right   */
	unsigned int tx_shift_lr   : BFW_NX500_xmac_config_shared3_tx_shift_lr;   /* 1: OBU reads outgoing bits from position 15 of register tx and shifts tx left, */
	                                                                          /* 0: OBU reads outgoing bits from position 0 of register tx and shifts tx right  */
	unsigned int reset_rx_fifo : BFW_NX500_xmac_config_shared3_reset_rx_fifo; /* reset URX_FIFO and rx_ovf bit inside status_shared register                    */
	unsigned int reset_tx_fifo : BFW_NX500_xmac_config_shared3_reset_tx_fifo; /* reset UTX_FIFO and tx_ufl bit inside status_shared register                    */
	unsigned int gpio0_out     : BFW_NX500_xmac_config_shared3_gpio0_out;     /* General Purpose IO 0 output                                                    */
	unsigned int gpio0_oe      : BFW_NX500_xmac_config_shared3_gpio0_oe;      /* General Purpose IO 0 output enable                                             */
	unsigned int gpio1_out     : BFW_NX500_xmac_config_shared3_gpio1_out;     /* General Purpose IO 1 output                                                    */
	unsigned int gpio1_oe      : BFW_NX500_xmac_config_shared3_gpio1_oe;      /* General Purpose IO 1 output enable                                             */
	unsigned int reserved1     : BFW_NX500_xmac_config_shared3_reserved1;     /* reserved                                                                       */
} NX500_XMAC_CONFIG_SHARED3_BIT_T;

typedef union {
	unsigned int                    val;
	NX500_XMAC_CONFIG_SHARED3_BIT_T bf;
} NX500_XMAC_CONFIG_SHARED3_T;

/* --------------------------------------------------------------------- */
/* Register xmac_urx_utx0 */
/* => xMAC0 URX/UTX Shared Register FIFO */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_urx_utx0   0x00000860U
#define Adr_NX500_xmac0_xmac_urx_utx0 0x00160860U
#define Adr_NX500_xmac1_xmac_urx_utx0 0x00161860U
#define Adr_NX500_xmac2_xmac_urx_utx0 0x00162860U
#define Adr_NX500_xmac3_xmac_urx_utx0 0x00163860U
#define DFLT_VAL_NX500_xmac_urx_utx0  0x00000000U

#define MSK_NX500_xmac_urx_utx0_UTX_XMAC0       0x000000ffU
#define SRT_NX500_xmac_urx_utx0_UTX_XMAC0       0
#define DFLT_VAL_NX500_xmac_urx_utx0_UTX_XMAC0  0x00000000U
#define MSK_NX500_xmac_urx_utx0_upper_bits      0x0000ff00U
#define SRT_NX500_xmac_urx_utx0_upper_bits      8
#define DFLT_VAL_NX500_xmac_urx_utx0_upper_bits 0x00000000U

enum {
	BFW_NX500_xmac_urx_utx0_UTX_XMAC0  = 8,  /* [7:0] */
	BFW_NX500_xmac_urx_utx0_upper_bits = 8,  /* [15:8] */
	BFW_NX500_xmac_urx_utx0_reserved1  = 16  /* [31:16] */
};

typedef struct NX500_XMAC_URX_UTX0_BIT_Ttag {
	unsigned int UTX_XMAC0  : BFW_NX500_xmac_urx_utx0_UTX_XMAC0;  /* read access:  Lastly received bits (output of URX_FIFO)                                 */
	                                                              /* write access: Bits to be transmitted next (input of UTX_FIFO)                           */
	unsigned int upper_bits : BFW_NX500_xmac_urx_utx0_upper_bits; /* FIFO is 8 bits wide only, thus the upper bits are always ignored (zero in case of read) */
	unsigned int reserved1  : BFW_NX500_xmac_urx_utx0_reserved1;  /* reserved                                                                                */
} NX500_XMAC_URX_UTX0_BIT_T;

typedef union {
	unsigned int              val;
	NX500_XMAC_URX_UTX0_BIT_T bf;
} NX500_XMAC_URX_UTX0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_urx_utx1 */
/* => xMAC1 URX/UTX Shared Register FIFO */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_urx_utx1   0x00000864U
#define Adr_NX500_xmac0_xmac_urx_utx1 0x00160864U
#define Adr_NX500_xmac1_xmac_urx_utx1 0x00161864U
#define Adr_NX500_xmac2_xmac_urx_utx1 0x00162864U
#define Adr_NX500_xmac3_xmac_urx_utx1 0x00163864U
#define DFLT_VAL_NX500_xmac_urx_utx1  0x00000000U

#define MSK_NX500_xmac_urx_utx1_UTX_XMAC1       0x000000ffU
#define SRT_NX500_xmac_urx_utx1_UTX_XMAC1       0
#define DFLT_VAL_NX500_xmac_urx_utx1_UTX_XMAC1  0x00000000U
#define MSK_NX500_xmac_urx_utx1_upper_bits      0x0000ff00U
#define SRT_NX500_xmac_urx_utx1_upper_bits      8
#define DFLT_VAL_NX500_xmac_urx_utx1_upper_bits 0x00000000U

enum {
	BFW_NX500_xmac_urx_utx1_UTX_XMAC1  = 8,  /* [7:0] */
	BFW_NX500_xmac_urx_utx1_upper_bits = 8,  /* [15:8] */
	BFW_NX500_xmac_urx_utx1_reserved1  = 16  /* [31:16] */
};

typedef struct NX500_XMAC_URX_UTX1_BIT_Ttag {
	unsigned int UTX_XMAC1  : BFW_NX500_xmac_urx_utx1_UTX_XMAC1;  /* read access:  Lastly received bits (output of URX_FIFO)                                 */
	                                                              /* write access: Bits to be transmitted next (input of UTX_FIFO)                           */
	unsigned int upper_bits : BFW_NX500_xmac_urx_utx1_upper_bits; /* FIFO is 8 bits wide only, thus the upper bits are always ignored (zero in case of read) */
	unsigned int reserved1  : BFW_NX500_xmac_urx_utx1_reserved1;  /* reserved                                                                                */
} NX500_XMAC_URX_UTX1_BIT_T;

typedef union {
	unsigned int              val;
	NX500_XMAC_URX_UTX1_BIT_T bf;
} NX500_XMAC_URX_UTX1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_urx_utx2 */
/* => xMAC2 URX/UTX Shared Register FIFO */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_urx_utx2   0x00000868U
#define Adr_NX500_xmac0_xmac_urx_utx2 0x00160868U
#define Adr_NX500_xmac1_xmac_urx_utx2 0x00161868U
#define Adr_NX500_xmac2_xmac_urx_utx2 0x00162868U
#define Adr_NX500_xmac3_xmac_urx_utx2 0x00163868U
#define DFLT_VAL_NX500_xmac_urx_utx2  0x00000000U

#define MSK_NX500_xmac_urx_utx2_UTX_XMAC2       0x000000ffU
#define SRT_NX500_xmac_urx_utx2_UTX_XMAC2       0
#define DFLT_VAL_NX500_xmac_urx_utx2_UTX_XMAC2  0x00000000U
#define MSK_NX500_xmac_urx_utx2_upper_bits      0x0000ff00U
#define SRT_NX500_xmac_urx_utx2_upper_bits      8
#define DFLT_VAL_NX500_xmac_urx_utx2_upper_bits 0x00000000U

enum {
	BFW_NX500_xmac_urx_utx2_UTX_XMAC2  = 8,  /* [7:0] */
	BFW_NX500_xmac_urx_utx2_upper_bits = 8,  /* [15:8] */
	BFW_NX500_xmac_urx_utx2_reserved1  = 16  /* [31:16] */
};

typedef struct NX500_XMAC_URX_UTX2_BIT_Ttag {
	unsigned int UTX_XMAC2  : BFW_NX500_xmac_urx_utx2_UTX_XMAC2;  /* read access:  Lastly received bits (output of URX_FIFO)                                 */
	                                                              /* write access: Bits to be transmitted next (input of UTX_FIFO)                           */
	unsigned int upper_bits : BFW_NX500_xmac_urx_utx2_upper_bits; /* FIFO is 8 bits wide only, thus the upper bits are always ignored (zero in case of read) */
	unsigned int reserved1  : BFW_NX500_xmac_urx_utx2_reserved1;  /* reserved                                                                                */
} NX500_XMAC_URX_UTX2_BIT_T;

typedef union {
	unsigned int              val;
	NX500_XMAC_URX_UTX2_BIT_T bf;
} NX500_XMAC_URX_UTX2_T;

/* --------------------------------------------------------------------- */
/* Register xmac_urx_utx3 */
/* => xMAC3 URX/UTX Shared Register FIFO */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_urx_utx3   0x0000086CU
#define Adr_NX500_xmac0_xmac_urx_utx3 0x0016086CU
#define Adr_NX500_xmac1_xmac_urx_utx3 0x0016186CU
#define Adr_NX500_xmac2_xmac_urx_utx3 0x0016286CU
#define Adr_NX500_xmac3_xmac_urx_utx3 0x0016386CU
#define DFLT_VAL_NX500_xmac_urx_utx3  0x00000000U

#define MSK_NX500_xmac_urx_utx3_UTX_XMAC3       0x000000ffU
#define SRT_NX500_xmac_urx_utx3_UTX_XMAC3       0
#define DFLT_VAL_NX500_xmac_urx_utx3_UTX_XMAC3  0x00000000U
#define MSK_NX500_xmac_urx_utx3_upper_bits      0x0000ff00U
#define SRT_NX500_xmac_urx_utx3_upper_bits      8
#define DFLT_VAL_NX500_xmac_urx_utx3_upper_bits 0x00000000U

enum {
	BFW_NX500_xmac_urx_utx3_UTX_XMAC3  = 8,  /* [7:0] */
	BFW_NX500_xmac_urx_utx3_upper_bits = 8,  /* [15:8] */
	BFW_NX500_xmac_urx_utx3_reserved1  = 16  /* [31:16] */
};

typedef struct NX500_XMAC_URX_UTX3_BIT_Ttag {
	unsigned int UTX_XMAC3  : BFW_NX500_xmac_urx_utx3_UTX_XMAC3;  /* read access:  Lastly received bits (output of URX_FIFO)                                 */
	                                                              /* write access: Bits to be transmitted next (input of UTX_FIFO)                           */
	unsigned int upper_bits : BFW_NX500_xmac_urx_utx3_upper_bits; /* FIFO is 8 bits wide only, thus the upper bits are always ignored (zero in case of read) */
	unsigned int reserved1  : BFW_NX500_xmac_urx_utx3_reserved1;  /* reserved                                                                                */
} NX500_XMAC_URX_UTX3_BIT_T;

typedef union {
	unsigned int              val;
	NX500_XMAC_URX_UTX3_BIT_T bf;
} NX500_XMAC_URX_UTX3_T;

/* --------------------------------------------------------------------- */
/* Register xmac_urx */
/* => xMAC URX FIFO input */
/*    URX FIFO is part of xMAC. It can be read (output) by all xMACs and xPECs, but only written (input) by the xMAC it belongs to. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_urx   0x00000870U
#define Adr_NX500_xmac0_xmac_urx 0x00160870U
#define Adr_NX500_xmac1_xmac_urx 0x00161870U
#define Adr_NX500_xmac2_xmac_urx 0x00162870U
#define Adr_NX500_xmac3_xmac_urx 0x00163870U
#define DFLT_VAL_NX500_xmac_urx  0x00000000U

#define MSK_NX500_xmac_urx_urx             0x000000ffU
#define SRT_NX500_xmac_urx_urx             0
#define DFLT_VAL_NX500_xmac_urx_urx        0x00000000U
#define MSK_NX500_xmac_urx_upper_bits      0x0000ff00U
#define SRT_NX500_xmac_urx_upper_bits      8
#define DFLT_VAL_NX500_xmac_urx_upper_bits 0x00000000U

enum {
	BFW_NX500_xmac_urx_urx        = 8,  /* [7:0] */
	BFW_NX500_xmac_urx_upper_bits = 8,  /* [15:8] */
	BFW_NX500_xmac_urx_reserved1  = 16  /* [31:16] */
};

typedef struct NX500_XMAC_URX_BIT_Ttag {
	unsigned int urx        : BFW_NX500_xmac_urx_urx;        /* Lastly received bits to be transmitted to xPEC (input of URX_FIFO) */
	unsigned int upper_bits : BFW_NX500_xmac_urx_upper_bits; /* FIFO is 8 bits wide only, thus the upper bits are always ignored   */
	unsigned int reserved1  : BFW_NX500_xmac_urx_reserved1;  /* reserved                                                           */
} NX500_XMAC_URX_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_URX_BIT_T bf;
} NX500_XMAC_URX_T;

/* --------------------------------------------------------------------- */
/* Register xmac_utx */
/* => xMAC UTX FIFO output */
/*    UTX FIFO is part of xMAC. It can be written (input) by all xMACs and xPECs, but only read (output) by the xMAC it belongs to. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_utx   0x00000874U
#define Adr_NX500_xmac0_xmac_utx 0x00160874U
#define Adr_NX500_xmac1_xmac_utx 0x00161874U
#define Adr_NX500_xmac2_xmac_utx 0x00162874U
#define Adr_NX500_xmac3_xmac_utx 0x00163874U

#define MSK_NX500_xmac_utx_utx        0x000000ffU
#define SRT_NX500_xmac_utx_utx        0
#define MSK_NX500_xmac_utx_upper_bits 0x0000ff00U
#define SRT_NX500_xmac_utx_upper_bits 8

enum {
	BFW_NX500_xmac_utx_utx        = 8,  /* [7:0] */
	BFW_NX500_xmac_utx_upper_bits = 8,  /* [15:8] */
	BFW_NX500_xmac_utx_reserved1  = 16  /* [31:16] */
};

typedef struct NX500_XMAC_UTX_BIT_Ttag {
	unsigned int utx        : BFW_NX500_xmac_utx_utx;        /* Bits to be transmitted next (output of UTX_FIFO)                             */
	                                                         /* read as src2 allows multiple reads, only read as src1 will change FIFO state */
	unsigned int upper_bits : BFW_NX500_xmac_utx_upper_bits; /* FIFO is 8 bits wide only, thus the upper bits are always zero                */
	unsigned int reserved1  : BFW_NX500_xmac_utx_reserved1;  /* reserved                                                                     */
} NX500_XMAC_UTX_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_UTX_BIT_T bf;
} NX500_XMAC_UTX_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx */
/* => xMAC RX Register */
/*    Sampled bits from SBU are collected in this register, */
/*    i.e. if a new bit arrives from SBU (sync), other bits are shifted (direction programmable). */
/*    Same behavior in MII-Modes (4 bits arrive in parallel and the other bits are shifted by 4). */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rx   0x00000878U
#define Adr_NX500_xmac0_xmac_rx 0x00160878U
#define Adr_NX500_xmac1_xmac_rx 0x00161878U
#define Adr_NX500_xmac2_xmac_rx 0x00162878U
#define Adr_NX500_xmac3_xmac_rx 0x00163878U

#define MSK_NX500_xmac_rx_rx 0x0000ffffU
#define SRT_NX500_xmac_rx_rx 0

enum {
	BFW_NX500_xmac_rx_rx        = 16, /* [15:0] */
	BFW_NX500_xmac_rx_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RX_BIT_Ttag {
	unsigned int rx        : BFW_NX500_xmac_rx_rx;        /* 16 previously received bits */
	unsigned int reserved1 : BFW_NX500_xmac_rx_reserved1; /* reserved                    */
} NX500_XMAC_RX_BIT_T;

typedef union {
	unsigned int        val;
	NX500_XMAC_RX_BIT_T bf;
} NX500_XMAC_RX_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_hw */
/* => xMAC RX_HW Register */
/*    rx_hw bit in RPU-code writes actually received bit from rx to this register. */
/*    Useful in case of bitwise format, to collect source bits from raw input bitstream (e.g. in HDLC-coding). */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rx_hw   0x0000087CU
#define Adr_NX500_xmac0_xmac_rx_hw 0x0016087CU
#define Adr_NX500_xmac1_xmac_rx_hw 0x0016187CU
#define Adr_NX500_xmac2_xmac_rx_hw 0x0016287CU
#define Adr_NX500_xmac3_xmac_rx_hw 0x0016387CU
#define DFLT_VAL_NX500_xmac_rx_hw  0x00000000U

#define MSK_NX500_xmac_rx_hw_rx_hw      0x0000ffffU
#define SRT_NX500_xmac_rx_hw_rx_hw      0
#define DFLT_VAL_NX500_xmac_rx_hw_rx_hw 0x00000000U

enum {
	BFW_NX500_xmac_rx_hw_rx_hw     = 16, /* [15:0] */
	BFW_NX500_xmac_rx_hw_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RX_HW_BIT_Ttag {
	unsigned int rx_hw     : BFW_NX500_xmac_rx_hw_rx_hw;     /* collected source bits from raw input bitstream                        */
	                                                         /* same orientation of bits as in rx register (depending on rx_shift_lr) */
	unsigned int reserved1 : BFW_NX500_xmac_rx_hw_reserved1; /* reserved                                                              */
} NX500_XMAC_RX_HW_BIT_T;

typedef union {
	unsigned int           val;
	NX500_XMAC_RX_HW_BIT_T bf;
} NX500_XMAC_RX_HW_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_hw_count */
/* => xMAC RX_HW_COUNT Register */
/*    Counts bits collected by rx_hw bit RPU-code. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rx_hw_count   0x00000880U
#define Adr_NX500_xmac0_xmac_rx_hw_count 0x00160880U
#define Adr_NX500_xmac1_xmac_rx_hw_count 0x00161880U
#define Adr_NX500_xmac2_xmac_rx_hw_count 0x00162880U
#define Adr_NX500_xmac3_xmac_rx_hw_count 0x00163880U
#define DFLT_VAL_NX500_xmac_rx_hw_count  0x00000000U

#define MSK_NX500_xmac_rx_hw_count_rx_hw_count      0x0000ffffU
#define SRT_NX500_xmac_rx_hw_count_rx_hw_count      0
#define DFLT_VAL_NX500_xmac_rx_hw_count_rx_hw_count 0x00000000U

enum {
	BFW_NX500_xmac_rx_hw_count_rx_hw_count = 16, /* [15:0] */
	BFW_NX500_xmac_rx_hw_count_reserved1   = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RX_HW_COUNT_BIT_Ttag {
	unsigned int rx_hw_count : BFW_NX500_xmac_rx_hw_count_rx_hw_count; /* counts down with rx_hw in RPU-code                               */
	                                                                   /* (from rx_nof_bits-1 to 0, 16-bit downcounter if rx_nof_bits = 0) */
	unsigned int reserved1   : BFW_NX500_xmac_rx_hw_count_reserved1;   /* reserved                                                         */
} NX500_XMAC_RX_HW_COUNT_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_XMAC_RX_HW_COUNT_BIT_T bf;
} NX500_XMAC_RX_HW_COUNT_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx */
/* => xMAC TX Register */
/*    Transmitted bits read automatically by OBU from this register, */
/*    i.e. if a bit is send (sync), other bits are rotated accordingly (direction programmable). */
/*    Same behavior in MII-Modes (4 bits arrive in parallel and the other bits are rotated by 4). */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tx   0x00000884U
#define Adr_NX500_xmac0_xmac_tx 0x00160884U
#define Adr_NX500_xmac1_xmac_tx 0x00161884U
#define Adr_NX500_xmac2_xmac_tx 0x00162884U
#define Adr_NX500_xmac3_xmac_tx 0x00163884U
#define DFLT_VAL_NX500_xmac_tx  0x00000000U

#define MSK_NX500_xmac_tx_tx0       0x00000001U
#define SRT_NX500_xmac_tx_tx0       0
#define DFLT_VAL_NX500_xmac_tx_tx0  0x00000000U
#define MSK_NX500_xmac_tx_tx        0x00007ffeU
#define SRT_NX500_xmac_tx_tx        1
#define DFLT_VAL_NX500_xmac_tx_tx   0x00000000U
#define MSK_NX500_xmac_tx_tx15      0x00008000U
#define SRT_NX500_xmac_tx_tx15      15
#define DFLT_VAL_NX500_xmac_tx_tx15 0x00000000U

enum {
	BFW_NX500_xmac_tx_tx0       = 1,  /* [0] */
	BFW_NX500_xmac_tx_tx        = 14, /* [14:1] */
	BFW_NX500_xmac_tx_tx15      = 1,  /* [15] */
	BFW_NX500_xmac_tx_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_TX_BIT_Ttag {
	unsigned int tx0       : BFW_NX500_xmac_tx_tx0;       /* bit to be transmitted next in case of tx_shift_lr = 0 */
	unsigned int tx        : BFW_NX500_xmac_tx_tx;        /* to be transmitted bits                                */
	unsigned int tx15      : BFW_NX500_xmac_tx_tx15;      /* bit to be transmitted next in case of tx_shift_lr = 1 */
	unsigned int reserved1 : BFW_NX500_xmac_tx_reserved1; /* reserved                                              */
} NX500_XMAC_TX_BIT_T;

typedef union {
	unsigned int        val;
	NX500_XMAC_TX_BIT_T bf;
} NX500_XMAC_TX_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_hw */
/* => xMAC TX_HW Register */
/*    tx_hw bit in TPU-code writes to be transmitted bit in tx register from this register */
/*    Useful in case of bitwise format, to insert source bits into output bitstream. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tx_hw   0x00000888U
#define Adr_NX500_xmac0_xmac_tx_hw 0x00160888U
#define Adr_NX500_xmac1_xmac_tx_hw 0x00161888U
#define Adr_NX500_xmac2_xmac_tx_hw 0x00162888U
#define Adr_NX500_xmac3_xmac_tx_hw 0x00163888U
#define DFLT_VAL_NX500_xmac_tx_hw  0x00000000U

#define MSK_NX500_xmac_tx_hw_tx_hw      0x0000ffffU
#define SRT_NX500_xmac_tx_hw_tx_hw      0
#define DFLT_VAL_NX500_xmac_tx_hw_tx_hw 0x00000000U

enum {
	BFW_NX500_xmac_tx_hw_tx_hw     = 16, /* [15:0] */
	BFW_NX500_xmac_tx_hw_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_TX_HW_BIT_Ttag {
	unsigned int tx_hw     : BFW_NX500_xmac_tx_hw_tx_hw;     /* bits to be inserted into output bitstream                             */
	                                                         /* same orientation of bits as in tx register (depending on tx_shift_lr) */
	unsigned int reserved1 : BFW_NX500_xmac_tx_hw_reserved1; /* reserved                                                              */
} NX500_XMAC_TX_HW_BIT_T;

typedef union {
	unsigned int           val;
	NX500_XMAC_TX_HW_BIT_T bf;
} NX500_XMAC_TX_HW_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_hw_count */
/* => xMAC TX_HW_COUNT Register */
/*    Counts bits collected by tx_hw bit TPU-code. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tx_hw_count   0x0000088CU
#define Adr_NX500_xmac0_xmac_tx_hw_count 0x0016088CU
#define Adr_NX500_xmac1_xmac_tx_hw_count 0x0016188CU
#define Adr_NX500_xmac2_xmac_tx_hw_count 0x0016288CU
#define Adr_NX500_xmac3_xmac_tx_hw_count 0x0016388CU
#define DFLT_VAL_NX500_xmac_tx_hw_count  0x00000000U

#define MSK_NX500_xmac_tx_hw_count_tx_hw_count      0x0000ffffU
#define SRT_NX500_xmac_tx_hw_count_tx_hw_count      0
#define DFLT_VAL_NX500_xmac_tx_hw_count_tx_hw_count 0x00000000U

enum {
	BFW_NX500_xmac_tx_hw_count_tx_hw_count = 16, /* [15:0] */
	BFW_NX500_xmac_tx_hw_count_reserved1   = 16  /* [31:16] */
};

typedef struct NX500_XMAC_TX_HW_COUNT_BIT_Ttag {
	unsigned int tx_hw_count : BFW_NX500_xmac_tx_hw_count_tx_hw_count; /* counts down with tx_hw in TPU-code                               */
	                                                                   /* (from tx_nof_bits-1 to 0, 16-bit downcounter if tx_nof_bits = 0) */
	unsigned int reserved1   : BFW_NX500_xmac_tx_hw_count_reserved1;   /* reserved                                                         */
} NX500_XMAC_TX_HW_COUNT_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_XMAC_TX_HW_COUNT_BIT_T bf;
} NX500_XMAC_TX_HW_COUNT_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_sent */
/* => xMAC TX Sent Register */
/*    Collects already transmitted bits. */
/*    Useful for pattern match. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tx_sent   0x00000890U
#define Adr_NX500_xmac0_xmac_tx_sent 0x00160890U
#define Adr_NX500_xmac1_xmac_tx_sent 0x00161890U
#define Adr_NX500_xmac2_xmac_tx_sent 0x00162890U
#define Adr_NX500_xmac3_xmac_tx_sent 0x00163890U
#define DFLT_VAL_NX500_xmac_tx_sent  0x00000000U

#define MSK_NX500_xmac_tx_sent_tx_sent      0x0000ffffU
#define SRT_NX500_xmac_tx_sent_tx_sent      0
#define DFLT_VAL_NX500_xmac_tx_sent_tx_sent 0x00000000U

enum {
	BFW_NX500_xmac_tx_sent_tx_sent   = 16, /* [15:0] */
	BFW_NX500_xmac_tx_sent_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_TX_SENT_BIT_Ttag {
	unsigned int tx_sent   : BFW_NX500_xmac_tx_sent_tx_sent;   /* already transmitted bits,                                          */
	                                                           /* bit 15 is always the oldest bit (shift direction not programmable) */
	unsigned int reserved1 : BFW_NX500_xmac_tx_sent_reserved1; /* reserved                                                           */
} NX500_XMAC_TX_SENT_BIT_T;

typedef union {
	unsigned int             val;
	NX500_XMAC_TX_SENT_BIT_T bf;
} NX500_XMAC_TX_SENT_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpu_pc */
/* => RPU Progamm counter */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rpu_pc   0x00000894U
#define Adr_NX500_xmac0_xmac_rpu_pc 0x00160894U
#define Adr_NX500_xmac1_xmac_rpu_pc 0x00161894U
#define Adr_NX500_xmac2_xmac_rpu_pc 0x00162894U
#define Adr_NX500_xmac3_xmac_rpu_pc 0x00163894U
#define DFLT_VAL_NX500_xmac_rpu_pc  0x00000000U

#define MSK_NX500_xmac_rpu_pc_rpu_pc      0x0000007fU
#define SRT_NX500_xmac_rpu_pc_rpu_pc      0
#define DFLT_VAL_NX500_xmac_rpu_pc_rpu_pc 0x00000000U

enum {
	BFW_NX500_xmac_rpu_pc_rpu_pc    = 7,  /* [6:0] */
	BFW_NX500_xmac_rpu_pc_reserved1 = 25  /* [31:7] */
};

typedef struct NX500_XMAC_RPU_PC_BIT_Ttag {
	unsigned int rpu_pc    : BFW_NX500_xmac_rpu_pc_rpu_pc;    /* Program Counter of RPU */
	unsigned int reserved1 : BFW_NX500_xmac_rpu_pc_reserved1; /* reserved               */
} NX500_XMAC_RPU_PC_BIT_T;

typedef union {
	unsigned int            val;
	NX500_XMAC_RPU_PC_BIT_T bf;
} NX500_XMAC_RPU_PC_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tpu_pc */
/* => TPU Progamm counter */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tpu_pc   0x00000898U
#define Adr_NX500_xmac0_xmac_tpu_pc 0x00160898U
#define Adr_NX500_xmac1_xmac_tpu_pc 0x00161898U
#define Adr_NX500_xmac2_xmac_tpu_pc 0x00162898U
#define Adr_NX500_xmac3_xmac_tpu_pc 0x00163898U
#define DFLT_VAL_NX500_xmac_tpu_pc  0x00000000U

#define MSK_NX500_xmac_tpu_pc_tpu_pc      0x0000007fU
#define SRT_NX500_xmac_tpu_pc_tpu_pc      0
#define DFLT_VAL_NX500_xmac_tpu_pc_tpu_pc 0x00000000U

enum {
	BFW_NX500_xmac_tpu_pc_tpu_pc    = 7,  /* [6:0] */
	BFW_NX500_xmac_tpu_pc_reserved1 = 25  /* [31:7] */
};

typedef struct NX500_XMAC_TPU_PC_BIT_Ttag {
	unsigned int tpu_pc    : BFW_NX500_xmac_tpu_pc_tpu_pc;    /* Program Counter of TPU */
	unsigned int reserved1 : BFW_NX500_xmac_tpu_pc_reserved1; /* reserved               */
} NX500_XMAC_TPU_PC_BIT_T;

typedef union {
	unsigned int            val;
	NX500_XMAC_TPU_PC_BIT_T bf;
} NX500_XMAC_TPU_PC_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr0 */
/* => xMAC internal Work Register 0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_wr0   0x0000089CU
#define Adr_NX500_xmac0_xmac_wr0 0x0016089CU
#define Adr_NX500_xmac1_xmac_wr0 0x0016189CU
#define Adr_NX500_xmac2_xmac_wr0 0x0016289CU
#define Adr_NX500_xmac3_xmac_wr0 0x0016389CU
#define DFLT_VAL_NX500_xmac_wr0  0x00000000U

#define MSK_NX500_xmac_wr0_WR0      0x0000ffffU
#define SRT_NX500_xmac_wr0_WR0      0
#define DFLT_VAL_NX500_xmac_wr0_WR0 0x00000000U

enum {
	BFW_NX500_xmac_wr0_WR0       = 16, /* [15:0] */
	BFW_NX500_xmac_wr0_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_WR0_BIT_Ttag {
	unsigned int WR0       : BFW_NX500_xmac_wr0_WR0;       /* Work Register */
	unsigned int reserved1 : BFW_NX500_xmac_wr0_reserved1; /* reserved      */
} NX500_XMAC_WR0_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_WR0_BIT_T bf;
} NX500_XMAC_WR0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr1 */
/* => xMAC internal Work Register 1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_wr1   0x000008A0U
#define Adr_NX500_xmac0_xmac_wr1 0x001608A0U
#define Adr_NX500_xmac1_xmac_wr1 0x001618A0U
#define Adr_NX500_xmac2_xmac_wr1 0x001628A0U
#define Adr_NX500_xmac3_xmac_wr1 0x001638A0U
#define DFLT_VAL_NX500_xmac_wr1  0x00000000U

#define MSK_NX500_xmac_wr1_WR1      0x0000ffffU
#define SRT_NX500_xmac_wr1_WR1      0
#define DFLT_VAL_NX500_xmac_wr1_WR1 0x00000000U

enum {
	BFW_NX500_xmac_wr1_WR1       = 16, /* [15:0] */
	BFW_NX500_xmac_wr1_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_WR1_BIT_Ttag {
	unsigned int WR1       : BFW_NX500_xmac_wr1_WR1;       /* Work Register */
	unsigned int reserved1 : BFW_NX500_xmac_wr1_reserved1; /* reserved      */
} NX500_XMAC_WR1_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_WR1_BIT_T bf;
} NX500_XMAC_WR1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr2 */
/* => xMAC internal Work Register 2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_wr2   0x000008A4U
#define Adr_NX500_xmac0_xmac_wr2 0x001608A4U
#define Adr_NX500_xmac1_xmac_wr2 0x001618A4U
#define Adr_NX500_xmac2_xmac_wr2 0x001628A4U
#define Adr_NX500_xmac3_xmac_wr2 0x001638A4U
#define DFLT_VAL_NX500_xmac_wr2  0x00000000U

#define MSK_NX500_xmac_wr2_WR2      0x0000ffffU
#define SRT_NX500_xmac_wr2_WR2      0
#define DFLT_VAL_NX500_xmac_wr2_WR2 0x00000000U

enum {
	BFW_NX500_xmac_wr2_WR2       = 16, /* [15:0] */
	BFW_NX500_xmac_wr2_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_WR2_BIT_Ttag {
	unsigned int WR2       : BFW_NX500_xmac_wr2_WR2;       /* Work Register */
	unsigned int reserved1 : BFW_NX500_xmac_wr2_reserved1; /* reserved      */
} NX500_XMAC_WR2_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_WR2_BIT_T bf;
} NX500_XMAC_WR2_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr3 */
/* => xMAC internal Work Register 3 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_wr3   0x000008A8U
#define Adr_NX500_xmac0_xmac_wr3 0x001608A8U
#define Adr_NX500_xmac1_xmac_wr3 0x001618A8U
#define Adr_NX500_xmac2_xmac_wr3 0x001628A8U
#define Adr_NX500_xmac3_xmac_wr3 0x001638A8U
#define DFLT_VAL_NX500_xmac_wr3  0x00000000U

#define MSK_NX500_xmac_wr3_WR3      0x0000ffffU
#define SRT_NX500_xmac_wr3_WR3      0
#define DFLT_VAL_NX500_xmac_wr3_WR3 0x00000000U

enum {
	BFW_NX500_xmac_wr3_WR3       = 16, /* [15:0] */
	BFW_NX500_xmac_wr3_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_WR3_BIT_Ttag {
	unsigned int WR3       : BFW_NX500_xmac_wr3_WR3;       /* Work Register */
	unsigned int reserved1 : BFW_NX500_xmac_wr3_reserved1; /* reserved      */
} NX500_XMAC_WR3_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_WR3_BIT_T bf;
} NX500_XMAC_WR3_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr4 */
/* => xMAC internal Work Register 4 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_wr4   0x000008ACU
#define Adr_NX500_xmac0_xmac_wr4 0x001608ACU
#define Adr_NX500_xmac1_xmac_wr4 0x001618ACU
#define Adr_NX500_xmac2_xmac_wr4 0x001628ACU
#define Adr_NX500_xmac3_xmac_wr4 0x001638ACU
#define DFLT_VAL_NX500_xmac_wr4  0x00000000U

#define MSK_NX500_xmac_wr4_WR4      0x0000ffffU
#define SRT_NX500_xmac_wr4_WR4      0
#define DFLT_VAL_NX500_xmac_wr4_WR4 0x00000000U

enum {
	BFW_NX500_xmac_wr4_WR4       = 16, /* [15:0] */
	BFW_NX500_xmac_wr4_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_WR4_BIT_Ttag {
	unsigned int WR4       : BFW_NX500_xmac_wr4_WR4;       /* Work Register */
	unsigned int reserved1 : BFW_NX500_xmac_wr4_reserved1; /* reserved      */
} NX500_XMAC_WR4_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_WR4_BIT_T bf;
} NX500_XMAC_WR4_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr5 */
/* => xMAC internal Work Register 5 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_wr5   0x000008B0U
#define Adr_NX500_xmac0_xmac_wr5 0x001608B0U
#define Adr_NX500_xmac1_xmac_wr5 0x001618B0U
#define Adr_NX500_xmac2_xmac_wr5 0x001628B0U
#define Adr_NX500_xmac3_xmac_wr5 0x001638B0U
#define DFLT_VAL_NX500_xmac_wr5  0x00000000U

#define MSK_NX500_xmac_wr5_WR5      0x0000ffffU
#define SRT_NX500_xmac_wr5_WR5      0
#define DFLT_VAL_NX500_xmac_wr5_WR5 0x00000000U

enum {
	BFW_NX500_xmac_wr5_WR5       = 16, /* [15:0] */
	BFW_NX500_xmac_wr5_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_WR5_BIT_Ttag {
	unsigned int WR5       : BFW_NX500_xmac_wr5_WR5;       /* Work Register */
	unsigned int reserved1 : BFW_NX500_xmac_wr5_reserved1; /* reserved      */
} NX500_XMAC_WR5_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_WR5_BIT_T bf;
} NX500_XMAC_WR5_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr6 */
/* => xMAC internal Work Register 6 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_wr6   0x000008B4U
#define Adr_NX500_xmac0_xmac_wr6 0x001608B4U
#define Adr_NX500_xmac1_xmac_wr6 0x001618B4U
#define Adr_NX500_xmac2_xmac_wr6 0x001628B4U
#define Adr_NX500_xmac3_xmac_wr6 0x001638B4U
#define DFLT_VAL_NX500_xmac_wr6  0x00000000U

#define MSK_NX500_xmac_wr6_WR6      0x0000ffffU
#define SRT_NX500_xmac_wr6_WR6      0
#define DFLT_VAL_NX500_xmac_wr6_WR6 0x00000000U

enum {
	BFW_NX500_xmac_wr6_WR6       = 16, /* [15:0] */
	BFW_NX500_xmac_wr6_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_WR6_BIT_Ttag {
	unsigned int WR6       : BFW_NX500_xmac_wr6_WR6;       /* Work Register */
	unsigned int reserved1 : BFW_NX500_xmac_wr6_reserved1; /* reserved      */
} NX500_XMAC_WR6_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_WR6_BIT_T bf;
} NX500_XMAC_WR6_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr7 */
/* => xMAC internal Work Register 7 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_wr7   0x000008B8U
#define Adr_NX500_xmac0_xmac_wr7 0x001608B8U
#define Adr_NX500_xmac1_xmac_wr7 0x001618B8U
#define Adr_NX500_xmac2_xmac_wr7 0x001628B8U
#define Adr_NX500_xmac3_xmac_wr7 0x001638B8U
#define DFLT_VAL_NX500_xmac_wr7  0x00000000U

#define MSK_NX500_xmac_wr7_WR7      0x0000ffffU
#define SRT_NX500_xmac_wr7_WR7      0
#define DFLT_VAL_NX500_xmac_wr7_WR7 0x00000000U

enum {
	BFW_NX500_xmac_wr7_WR7       = 16, /* [15:0] */
	BFW_NX500_xmac_wr7_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_WR7_BIT_Ttag {
	unsigned int WR7       : BFW_NX500_xmac_wr7_WR7;       /* Work Register */
	unsigned int reserved1 : BFW_NX500_xmac_wr7_reserved1; /* reserved      */
} NX500_XMAC_WR7_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_WR7_BIT_T bf;
} NX500_XMAC_WR7_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr8 */
/* => xMAC internal Work Register 7 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_wr8   0x000008BCU
#define Adr_NX500_xmac0_xmac_wr8 0x001608BCU
#define Adr_NX500_xmac1_xmac_wr8 0x001618BCU
#define Adr_NX500_xmac2_xmac_wr8 0x001628BCU
#define Adr_NX500_xmac3_xmac_wr8 0x001638BCU
#define DFLT_VAL_NX500_xmac_wr8  0x00000000U

#define MSK_NX500_xmac_wr8_WR7      0x0000ffffU
#define SRT_NX500_xmac_wr8_WR7      0
#define DFLT_VAL_NX500_xmac_wr8_WR7 0x00000000U

enum {
	BFW_NX500_xmac_wr8_WR7       = 16, /* [15:0] */
	BFW_NX500_xmac_wr8_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_WR8_BIT_Ttag {
	unsigned int WR7       : BFW_NX500_xmac_wr8_WR7;       /* Work Register */
	unsigned int reserved1 : BFW_NX500_xmac_wr8_reserved1; /* reserved      */
} NX500_XMAC_WR8_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_WR8_BIT_T bf;
} NX500_XMAC_WR8_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr9 */
/* => xMAC internal Work Register 7 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_wr9   0x000008C0U
#define Adr_NX500_xmac0_xmac_wr9 0x001608C0U
#define Adr_NX500_xmac1_xmac_wr9 0x001618C0U
#define Adr_NX500_xmac2_xmac_wr9 0x001628C0U
#define Adr_NX500_xmac3_xmac_wr9 0x001638C0U
#define DFLT_VAL_NX500_xmac_wr9  0x00000000U

#define MSK_NX500_xmac_wr9_WR7      0x0000ffffU
#define SRT_NX500_xmac_wr9_WR7      0
#define DFLT_VAL_NX500_xmac_wr9_WR7 0x00000000U

enum {
	BFW_NX500_xmac_wr9_WR7       = 16, /* [15:0] */
	BFW_NX500_xmac_wr9_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_WR9_BIT_Ttag {
	unsigned int WR7       : BFW_NX500_xmac_wr9_WR7;       /* Work Register */
	unsigned int reserved1 : BFW_NX500_xmac_wr9_reserved1; /* reserved      */
} NX500_XMAC_WR9_BIT_T;

typedef union {
	unsigned int         val;
	NX500_XMAC_WR9_BIT_T bf;
} NX500_XMAC_WR9_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sys_time */
/* => xMAC System Time */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sys_time   0x000008C4U
#define Adr_NX500_xmac0_xmac_sys_time 0x001608C4U
#define Adr_NX500_xmac1_xmac_sys_time 0x001618C4U
#define Adr_NX500_xmac2_xmac_sys_time 0x001628C4U
#define Adr_NX500_xmac3_xmac_sys_time 0x001638C4U

#define MSK_NX500_xmac_sys_time_sys_time 0x0000ffffU
#define SRT_NX500_xmac_sys_time_sys_time 0

enum {
	BFW_NX500_xmac_sys_time_sys_time  = 16, /* [15:0] */
	BFW_NX500_xmac_sys_time_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SYS_TIME_BIT_Ttag {
	unsigned int sys_time  : BFW_NX500_xmac_sys_time_sys_time;  /* 16 lower bits of 32 bit system time running on system clock */
	unsigned int reserved1 : BFW_NX500_xmac_sys_time_reserved1; /* reserved                                                    */
} NX500_XMAC_SYS_TIME_BIT_T;

typedef union {
	unsigned int              val;
	NX500_XMAC_SYS_TIME_BIT_T bf;
} NX500_XMAC_SYS_TIME_T;

/* --------------------------------------------------------------------- */
/* Register xmac_cmp0_status */
/* => xMAC Compare0 Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_cmp0_status   0x000008C8U
#define Adr_NX500_xmac0_xmac_cmp0_status 0x001608C8U
#define Adr_NX500_xmac1_xmac_cmp0_status 0x001618C8U
#define Adr_NX500_xmac2_xmac_cmp0_status 0x001628C8U
#define Adr_NX500_xmac3_xmac_cmp0_status 0x001638C8U

#define MSK_NX500_xmac_cmp0_status_sr0_z       0x00000001U
#define SRT_NX500_xmac_cmp0_status_sr0_z       0
#define MSK_NX500_xmac_cmp0_status_sr1_z       0x00000002U
#define SRT_NX500_xmac_cmp0_status_sr1_z       1
#define MSK_NX500_xmac_cmp0_status_sr2_z       0x00000004U
#define SRT_NX500_xmac_cmp0_status_sr2_z       2
#define MSK_NX500_xmac_cmp0_status_sr3_z       0x00000008U
#define SRT_NX500_xmac_cmp0_status_sr3_z       3
#define MSK_NX500_xmac_cmp0_status_sr4_z       0x00000010U
#define SRT_NX500_xmac_cmp0_status_sr4_z       4
#define MSK_NX500_xmac_cmp0_status_sr5_z       0x00000020U
#define SRT_NX500_xmac_cmp0_status_sr5_z       5
#define MSK_NX500_xmac_cmp0_status_sr6_z       0x00000040U
#define SRT_NX500_xmac_cmp0_status_sr6_z       6
#define MSK_NX500_xmac_cmp0_status_sr7_z       0x00000080U
#define SRT_NX500_xmac_cmp0_status_sr7_z       7
#define MSK_NX500_xmac_cmp0_status_cnt_rx_z    0x00000100U
#define SRT_NX500_xmac_cmp0_status_cnt_rx_z    8
#define MSK_NX500_xmac_cmp0_status_cnt_tx_z    0x00000200U
#define SRT_NX500_xmac_cmp0_status_cnt_tx_z    9
#define MSK_NX500_xmac_cmp0_status_cnt_rx_hw_z 0x00000400U
#define SRT_NX500_xmac_cmp0_status_cnt_rx_hw_z 10
#define MSK_NX500_xmac_cmp0_status_cnt_tx_hw_z 0x00000800U
#define SRT_NX500_xmac_cmp0_status_cnt_tx_hw_z 11
#define MSK_NX500_xmac_cmp0_status_cnt1_rpu_z  0x00001000U
#define SRT_NX500_xmac_cmp0_status_cnt1_rpu_z  12
#define MSK_NX500_xmac_cmp0_status_cnt2_rpu_z  0x00002000U
#define SRT_NX500_xmac_cmp0_status_cnt2_rpu_z  13
#define MSK_NX500_xmac_cmp0_status_cnt1_tpu_z  0x00004000U
#define SRT_NX500_xmac_cmp0_status_cnt1_tpu_z  14
#define MSK_NX500_xmac_cmp0_status_cnt2_tpu_z  0x00008000U
#define SRT_NX500_xmac_cmp0_status_cnt2_tpu_z  15

enum {
	BFW_NX500_xmac_cmp0_status_sr0_z       = 1,  /* [0] */
	BFW_NX500_xmac_cmp0_status_sr1_z       = 1,  /* [1] */
	BFW_NX500_xmac_cmp0_status_sr2_z       = 1,  /* [2] */
	BFW_NX500_xmac_cmp0_status_sr3_z       = 1,  /* [3] */
	BFW_NX500_xmac_cmp0_status_sr4_z       = 1,  /* [4] */
	BFW_NX500_xmac_cmp0_status_sr5_z       = 1,  /* [5] */
	BFW_NX500_xmac_cmp0_status_sr6_z       = 1,  /* [6] */
	BFW_NX500_xmac_cmp0_status_sr7_z       = 1,  /* [7] */
	BFW_NX500_xmac_cmp0_status_cnt_rx_z    = 1,  /* [8] */
	BFW_NX500_xmac_cmp0_status_cnt_tx_z    = 1,  /* [9] */
	BFW_NX500_xmac_cmp0_status_cnt_rx_hw_z = 1,  /* [10] */
	BFW_NX500_xmac_cmp0_status_cnt_tx_hw_z = 1,  /* [11] */
	BFW_NX500_xmac_cmp0_status_cnt1_rpu_z  = 1,  /* [12] */
	BFW_NX500_xmac_cmp0_status_cnt2_rpu_z  = 1,  /* [13] */
	BFW_NX500_xmac_cmp0_status_cnt1_tpu_z  = 1,  /* [14] */
	BFW_NX500_xmac_cmp0_status_cnt2_tpu_z  = 1,  /* [15] */
	BFW_NX500_xmac_cmp0_status_reserved1   = 16  /* [31:16] */
};

typedef struct NX500_XMAC_CMP0_STATUS_BIT_Ttag {
	unsigned int sr0_z       : BFW_NX500_xmac_cmp0_status_sr0_z;       /* sr0 = 0         */
	unsigned int sr1_z       : BFW_NX500_xmac_cmp0_status_sr1_z;       /* sr1 = 0         */
	unsigned int sr2_z       : BFW_NX500_xmac_cmp0_status_sr2_z;       /* sr2 = 0         */
	unsigned int sr3_z       : BFW_NX500_xmac_cmp0_status_sr3_z;       /* sr3 = 0         */
	unsigned int sr4_z       : BFW_NX500_xmac_cmp0_status_sr4_z;       /* sr4 = 0         */
	unsigned int sr5_z       : BFW_NX500_xmac_cmp0_status_sr5_z;       /* sr5 = 0         */
	unsigned int sr6_z       : BFW_NX500_xmac_cmp0_status_sr6_z;       /* sr6 = 0         */
	unsigned int sr7_z       : BFW_NX500_xmac_cmp0_status_sr7_z;       /* sr7 = 0         */
	unsigned int cnt_rx_z    : BFW_NX500_xmac_cmp0_status_cnt_rx_z;    /* count_rx = 0    */
	unsigned int cnt_tx_z    : BFW_NX500_xmac_cmp0_status_cnt_tx_z;    /* count_tx = 0    */
	unsigned int cnt_rx_hw_z : BFW_NX500_xmac_cmp0_status_cnt_rx_hw_z; /* rx_hw_count = 0 */
	unsigned int cnt_tx_hw_z : BFW_NX500_xmac_cmp0_status_cnt_tx_hw_z; /* tx_hw_count = 0 */
	unsigned int cnt1_rpu_z  : BFW_NX500_xmac_cmp0_status_cnt1_rpu_z;  /* rpu_count1 = 0  */
	unsigned int cnt2_rpu_z  : BFW_NX500_xmac_cmp0_status_cnt2_rpu_z;  /* rpu_count2 = 0  */
	unsigned int cnt1_tpu_z  : BFW_NX500_xmac_cmp0_status_cnt1_tpu_z;  /* tpu_count1 = 0  */
	unsigned int cnt2_tpu_z  : BFW_NX500_xmac_cmp0_status_cnt2_tpu_z;  /* tpu_count2 = 0  */
	unsigned int reserved1   : BFW_NX500_xmac_cmp0_status_reserved1;   /* reserved        */
} NX500_XMAC_CMP0_STATUS_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_XMAC_CMP0_STATUS_BIT_T bf;
} NX500_XMAC_CMP0_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_cmp1_status */
/* => xMAC Compare1 Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_cmp1_status   0x000008CCU
#define Adr_NX500_xmac0_xmac_cmp1_status 0x001608CCU
#define Adr_NX500_xmac1_xmac_cmp1_status 0x001618CCU
#define Adr_NX500_xmac2_xmac_cmp1_status 0x001628CCU
#define Adr_NX500_xmac3_xmac_cmp1_status 0x001638CCU

#define MSK_NX500_xmac_cmp1_status_wr0_z    0x00000001U
#define SRT_NX500_xmac_cmp1_status_wr0_z    0
#define MSK_NX500_xmac_cmp1_status_wr1_z    0x00000002U
#define SRT_NX500_xmac_cmp1_status_wr1_z    1
#define MSK_NX500_xmac_cmp1_status_wr2_z    0x00000004U
#define SRT_NX500_xmac_cmp1_status_wr2_z    2
#define MSK_NX500_xmac_cmp1_status_wr3_z    0x00000008U
#define SRT_NX500_xmac_cmp1_status_wr3_z    3
#define MSK_NX500_xmac_cmp1_status_wr4_z    0x00000010U
#define SRT_NX500_xmac_cmp1_status_wr4_z    4
#define MSK_NX500_xmac_cmp1_status_wr5_z    0x00000020U
#define SRT_NX500_xmac_cmp1_status_wr5_z    5
#define MSK_NX500_xmac_cmp1_status_wr6_z    0x00000040U
#define SRT_NX500_xmac_cmp1_status_wr6_z    6
#define MSK_NX500_xmac_cmp1_status_wr7_z    0x00000080U
#define SRT_NX500_xmac_cmp1_status_wr7_z    7
#define MSK_NX500_xmac_cmp1_status_wr8_z    0x00000100U
#define SRT_NX500_xmac_cmp1_status_wr8_z    8
#define MSK_NX500_xmac_cmp1_status_wr9_z    0x00000200U
#define SRT_NX500_xmac_cmp1_status_wr9_z    9
#define MSK_NX500_xmac_cmp1_status_wr0_wr1  0x00000400U
#define SRT_NX500_xmac_cmp1_status_wr0_wr1  10
#define MSK_NX500_xmac_cmp1_status_wr2_wr3  0x00000800U
#define SRT_NX500_xmac_cmp1_status_wr2_wr3  11
#define MSK_NX500_xmac_cmp1_status_wr4_wr5  0x00001000U
#define SRT_NX500_xmac_cmp1_status_wr4_wr5  12
#define MSK_NX500_xmac_cmp1_status_wr6_wr7  0x00002000U
#define SRT_NX500_xmac_cmp1_status_wr6_wr7  13
#define MSK_NX500_xmac_cmp1_status_wr8_wr9  0x00004000U
#define SRT_NX500_xmac_cmp1_status_wr8_wr9  14
#define MSK_NX500_xmac_cmp1_status_sys_time 0x00008000U
#define SRT_NX500_xmac_cmp1_status_sys_time 15

enum {
	BFW_NX500_xmac_cmp1_status_wr0_z     = 1,  /* [0] */
	BFW_NX500_xmac_cmp1_status_wr1_z     = 1,  /* [1] */
	BFW_NX500_xmac_cmp1_status_wr2_z     = 1,  /* [2] */
	BFW_NX500_xmac_cmp1_status_wr3_z     = 1,  /* [3] */
	BFW_NX500_xmac_cmp1_status_wr4_z     = 1,  /* [4] */
	BFW_NX500_xmac_cmp1_status_wr5_z     = 1,  /* [5] */
	BFW_NX500_xmac_cmp1_status_wr6_z     = 1,  /* [6] */
	BFW_NX500_xmac_cmp1_status_wr7_z     = 1,  /* [7] */
	BFW_NX500_xmac_cmp1_status_wr8_z     = 1,  /* [8] */
	BFW_NX500_xmac_cmp1_status_wr9_z     = 1,  /* [9] */
	BFW_NX500_xmac_cmp1_status_wr0_wr1   = 1,  /* [10] */
	BFW_NX500_xmac_cmp1_status_wr2_wr3   = 1,  /* [11] */
	BFW_NX500_xmac_cmp1_status_wr4_wr5   = 1,  /* [12] */
	BFW_NX500_xmac_cmp1_status_wr6_wr7   = 1,  /* [13] */
	BFW_NX500_xmac_cmp1_status_wr8_wr9   = 1,  /* [14] */
	BFW_NX500_xmac_cmp1_status_sys_time  = 1,  /* [15] */
	BFW_NX500_xmac_cmp1_status_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_CMP1_STATUS_BIT_Ttag {
	unsigned int wr0_z     : BFW_NX500_xmac_cmp1_status_wr0_z;     /* 1: work register 0 equals 0                                    */
	unsigned int wr1_z     : BFW_NX500_xmac_cmp1_status_wr1_z;     /* 1: work register 1 equals 0                                    */
	unsigned int wr2_z     : BFW_NX500_xmac_cmp1_status_wr2_z;     /* 1: work register 2 equals 0                                    */
	unsigned int wr3_z     : BFW_NX500_xmac_cmp1_status_wr3_z;     /* 1: work register 3 equals 0                                    */
	unsigned int wr4_z     : BFW_NX500_xmac_cmp1_status_wr4_z;     /* 1: work register 4 equals 0                                    */
	unsigned int wr5_z     : BFW_NX500_xmac_cmp1_status_wr5_z;     /* 1: work register 5 equals 0                                    */
	unsigned int wr6_z     : BFW_NX500_xmac_cmp1_status_wr6_z;     /* 1: work register 6 equals 0                                    */
	unsigned int wr7_z     : BFW_NX500_xmac_cmp1_status_wr7_z;     /* 1: work register 7 equals 0                                    */
	unsigned int wr8_z     : BFW_NX500_xmac_cmp1_status_wr8_z;     /* 1: work register 8 equals 0                                    */
	unsigned int wr9_z     : BFW_NX500_xmac_cmp1_status_wr9_z;     /* 1: work register 9 equals 0                                    */
	unsigned int wr0_wr1   : BFW_NX500_xmac_cmp1_status_wr0_wr1;   /* 1: wr0 equals wr1                                              */
	unsigned int wr2_wr3   : BFW_NX500_xmac_cmp1_status_wr2_wr3;   /* 1: wr2 equals wr3                                              */
	unsigned int wr4_wr5   : BFW_NX500_xmac_cmp1_status_wr4_wr5;   /* 1: wr4 equals wr5                                              */
	unsigned int wr6_wr7   : BFW_NX500_xmac_cmp1_status_wr6_wr7;   /* 1: wr6 equals wr7                                              */
	unsigned int wr8_wr9   : BFW_NX500_xmac_cmp1_status_wr8_wr9;   /* 1: wr8 equals wr9                                              */
	unsigned int sys_time  : BFW_NX500_xmac_cmp1_status_sys_time;  /* compare of sys_time with wr2(value) and wr3(mask):             */
	                                                               /* wr3 defines, which bits of sys_time and wr2 are to be compared */
	unsigned int reserved1 : BFW_NX500_xmac_cmp1_status_reserved1; /* reserved                                                       */
} NX500_XMAC_CMP1_STATUS_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_XMAC_CMP1_STATUS_BIT_T bf;
} NX500_XMAC_CMP1_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_cmp2_status */
/* => xMAC Compare2 Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_cmp2_status   0x000008D0U
#define Adr_NX500_xmac0_xmac_cmp2_status 0x001608D0U
#define Adr_NX500_xmac1_xmac_cmp2_status 0x001618D0U
#define Adr_NX500_xmac2_xmac_cmp2_status 0x001628D0U
#define Adr_NX500_xmac3_xmac_cmp2_status 0x001638D0U

#define MSK_NX500_xmac_cmp2_status_wr0_sr0  0x00000001U
#define SRT_NX500_xmac_cmp2_status_wr0_sr0  0
#define MSK_NX500_xmac_cmp2_status_wr1_sr1  0x00000002U
#define SRT_NX500_xmac_cmp2_status_wr1_sr1  1
#define MSK_NX500_xmac_cmp2_status_wr2_sr2  0x00000004U
#define SRT_NX500_xmac_cmp2_status_wr2_sr2  2
#define MSK_NX500_xmac_cmp2_status_wr3_sr3  0x00000008U
#define SRT_NX500_xmac_cmp2_status_wr3_sr3  3
#define MSK_NX500_xmac_cmp2_status_wr4_sr4  0x00000010U
#define SRT_NX500_xmac_cmp2_status_wr4_sr4  4
#define MSK_NX500_xmac_cmp2_status_wr5_sr5  0x00000020U
#define SRT_NX500_xmac_cmp2_status_wr5_sr5  5
#define MSK_NX500_xmac_cmp2_status_wr6_sr6  0x00000040U
#define SRT_NX500_xmac_cmp2_status_wr6_sr6  6
#define MSK_NX500_xmac_cmp2_status_wr7_sr7  0x00000080U
#define SRT_NX500_xmac_cmp2_status_wr7_sr7  7
#define MSK_NX500_xmac_cmp2_status_wr8_sr8  0x00000100U
#define SRT_NX500_xmac_cmp2_status_wr8_sr8  8
#define MSK_NX500_xmac_cmp2_status_wr9_sr9  0x00000200U
#define SRT_NX500_xmac_cmp2_status_wr9_sr9  9
#define MSK_NX500_xmac_cmp2_status_wr5_sr10 0x00000400U
#define SRT_NX500_xmac_cmp2_status_wr5_sr10 10
#define MSK_NX500_xmac_cmp2_status_wr6_sr11 0x00000800U
#define SRT_NX500_xmac_cmp2_status_wr6_sr11 11
#define MSK_NX500_xmac_cmp2_status_wr5_sr12 0x00001000U
#define SRT_NX500_xmac_cmp2_status_wr5_sr12 12
#define MSK_NX500_xmac_cmp2_status_wr6_sr13 0x00002000U
#define SRT_NX500_xmac_cmp2_status_wr6_sr13 13
#define MSK_NX500_xmac_cmp2_status_wr5_sr14 0x00004000U
#define SRT_NX500_xmac_cmp2_status_wr5_sr14 14
#define MSK_NX500_xmac_cmp2_status_wr6_sr15 0x00008000U
#define SRT_NX500_xmac_cmp2_status_wr6_sr15 15

enum {
	BFW_NX500_xmac_cmp2_status_wr0_sr0   = 1,  /* [0] */
	BFW_NX500_xmac_cmp2_status_wr1_sr1   = 1,  /* [1] */
	BFW_NX500_xmac_cmp2_status_wr2_sr2   = 1,  /* [2] */
	BFW_NX500_xmac_cmp2_status_wr3_sr3   = 1,  /* [3] */
	BFW_NX500_xmac_cmp2_status_wr4_sr4   = 1,  /* [4] */
	BFW_NX500_xmac_cmp2_status_wr5_sr5   = 1,  /* [5] */
	BFW_NX500_xmac_cmp2_status_wr6_sr6   = 1,  /* [6] */
	BFW_NX500_xmac_cmp2_status_wr7_sr7   = 1,  /* [7] */
	BFW_NX500_xmac_cmp2_status_wr8_sr8   = 1,  /* [8] */
	BFW_NX500_xmac_cmp2_status_wr9_sr9   = 1,  /* [9] */
	BFW_NX500_xmac_cmp2_status_wr5_sr10  = 1,  /* [10] */
	BFW_NX500_xmac_cmp2_status_wr6_sr11  = 1,  /* [11] */
	BFW_NX500_xmac_cmp2_status_wr5_sr12  = 1,  /* [12] */
	BFW_NX500_xmac_cmp2_status_wr6_sr13  = 1,  /* [13] */
	BFW_NX500_xmac_cmp2_status_wr5_sr14  = 1,  /* [14] */
	BFW_NX500_xmac_cmp2_status_wr6_sr15  = 1,  /* [15] */
	BFW_NX500_xmac_cmp2_status_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_CMP2_STATUS_BIT_Ttag {
	unsigned int wr0_sr0   : BFW_NX500_xmac_cmp2_status_wr0_sr0;   /* 1: wr0 equals sr0  */
	unsigned int wr1_sr1   : BFW_NX500_xmac_cmp2_status_wr1_sr1;   /* 1: wr1 equals sr1  */
	unsigned int wr2_sr2   : BFW_NX500_xmac_cmp2_status_wr2_sr2;   /* 1: wr2 equals sr2  */
	unsigned int wr3_sr3   : BFW_NX500_xmac_cmp2_status_wr3_sr3;   /* 1: wr3 equals sr3  */
	unsigned int wr4_sr4   : BFW_NX500_xmac_cmp2_status_wr4_sr4;   /* 1: wr4 equals sr4  */
	unsigned int wr5_sr5   : BFW_NX500_xmac_cmp2_status_wr5_sr5;   /* 1: wr5 equals sr5  */
	unsigned int wr6_sr6   : BFW_NX500_xmac_cmp2_status_wr6_sr6;   /* 1: wr6 equals sr6  */
	unsigned int wr7_sr7   : BFW_NX500_xmac_cmp2_status_wr7_sr7;   /* 1: wr7 equals sr7  */
	unsigned int wr8_sr8   : BFW_NX500_xmac_cmp2_status_wr8_sr8;   /* 1: wr8 equals sr8  */
	unsigned int wr9_sr9   : BFW_NX500_xmac_cmp2_status_wr9_sr9;   /* 1: wr9 equals sr9  */
	unsigned int wr5_sr10  : BFW_NX500_xmac_cmp2_status_wr5_sr10;  /* 1: wr5 equals sr10 */
	unsigned int wr6_sr11  : BFW_NX500_xmac_cmp2_status_wr6_sr11;  /* 1: wr6 equals sr11 */
	unsigned int wr5_sr12  : BFW_NX500_xmac_cmp2_status_wr5_sr12;  /* 1: wr5 equals sr12 */
	unsigned int wr6_sr13  : BFW_NX500_xmac_cmp2_status_wr6_sr13;  /* 1: wr6 equals sr13 */
	unsigned int wr5_sr14  : BFW_NX500_xmac_cmp2_status_wr5_sr14;  /* 1: wr5 equals sr14 */
	unsigned int wr6_sr15  : BFW_NX500_xmac_cmp2_status_wr6_sr15;  /* 1: wr6 equals sr15 */
	unsigned int reserved1 : BFW_NX500_xmac_cmp2_status_reserved1; /* reserved           */
} NX500_XMAC_CMP2_STATUS_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_XMAC_CMP2_STATUS_BIT_T bf;
} NX500_XMAC_CMP2_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_cmp3_status */
/* => xMAC Compare3 Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_cmp3_status   0x000008D4U
#define Adr_NX500_xmac0_xmac_cmp3_status 0x001608D4U
#define Adr_NX500_xmac1_xmac_cmp3_status 0x001618D4U
#define Adr_NX500_xmac2_xmac_cmp3_status 0x001628D4U
#define Adr_NX500_xmac3_xmac_cmp3_status 0x001638D4U

#define MSK_NX500_xmac_cmp3_status_rpucnt1_wr0 0x00000001U
#define SRT_NX500_xmac_cmp3_status_rpucnt1_wr0 0
#define MSK_NX500_xmac_cmp3_status_rpucnt1_wr1 0x00000002U
#define SRT_NX500_xmac_cmp3_status_rpucnt1_wr1 1
#define MSK_NX500_xmac_cmp3_status_rpucnt1_wr2 0x00000004U
#define SRT_NX500_xmac_cmp3_status_rpucnt1_wr2 2
#define MSK_NX500_xmac_cmp3_status_rpucnt1_wr3 0x00000008U
#define SRT_NX500_xmac_cmp3_status_rpucnt1_wr3 3
#define MSK_NX500_xmac_cmp3_status_rpucnt1_wr4 0x00000010U
#define SRT_NX500_xmac_cmp3_status_rpucnt1_wr4 4
#define MSK_NX500_xmac_cmp3_status_rpucnt1_wr5 0x00000020U
#define SRT_NX500_xmac_cmp3_status_rpucnt1_wr5 5
#define MSK_NX500_xmac_cmp3_status_rpucnt1_wr6 0x00000040U
#define SRT_NX500_xmac_cmp3_status_rpucnt1_wr6 6
#define MSK_NX500_xmac_cmp3_status_rpucnt1_wr7 0x00000080U
#define SRT_NX500_xmac_cmp3_status_rpucnt1_wr7 7
#define MSK_NX500_xmac_cmp3_status_tpucnt1_wr0 0x00000100U
#define SRT_NX500_xmac_cmp3_status_tpucnt1_wr0 8
#define MSK_NX500_xmac_cmp3_status_tpucnt1_wr1 0x00000200U
#define SRT_NX500_xmac_cmp3_status_tpucnt1_wr1 9
#define MSK_NX500_xmac_cmp3_status_tpucnt1_wr2 0x00000400U
#define SRT_NX500_xmac_cmp3_status_tpucnt1_wr2 10
#define MSK_NX500_xmac_cmp3_status_tpucnt1_wr3 0x00000800U
#define SRT_NX500_xmac_cmp3_status_tpucnt1_wr3 11
#define MSK_NX500_xmac_cmp3_status_tpucnt1_wr4 0x00001000U
#define SRT_NX500_xmac_cmp3_status_tpucnt1_wr4 12
#define MSK_NX500_xmac_cmp3_status_tpucnt1_wr5 0x00002000U
#define SRT_NX500_xmac_cmp3_status_tpucnt1_wr5 13
#define MSK_NX500_xmac_cmp3_status_tpucnt1_wr6 0x00004000U
#define SRT_NX500_xmac_cmp3_status_tpucnt1_wr6 14
#define MSK_NX500_xmac_cmp3_status_tpucnt1_wr7 0x00008000U
#define SRT_NX500_xmac_cmp3_status_tpucnt1_wr7 15

enum {
	BFW_NX500_xmac_cmp3_status_rpucnt1_wr0 = 1,  /* [0] */
	BFW_NX500_xmac_cmp3_status_rpucnt1_wr1 = 1,  /* [1] */
	BFW_NX500_xmac_cmp3_status_rpucnt1_wr2 = 1,  /* [2] */
	BFW_NX500_xmac_cmp3_status_rpucnt1_wr3 = 1,  /* [3] */
	BFW_NX500_xmac_cmp3_status_rpucnt1_wr4 = 1,  /* [4] */
	BFW_NX500_xmac_cmp3_status_rpucnt1_wr5 = 1,  /* [5] */
	BFW_NX500_xmac_cmp3_status_rpucnt1_wr6 = 1,  /* [6] */
	BFW_NX500_xmac_cmp3_status_rpucnt1_wr7 = 1,  /* [7] */
	BFW_NX500_xmac_cmp3_status_tpucnt1_wr0 = 1,  /* [8] */
	BFW_NX500_xmac_cmp3_status_tpucnt1_wr1 = 1,  /* [9] */
	BFW_NX500_xmac_cmp3_status_tpucnt1_wr2 = 1,  /* [10] */
	BFW_NX500_xmac_cmp3_status_tpucnt1_wr3 = 1,  /* [11] */
	BFW_NX500_xmac_cmp3_status_tpucnt1_wr4 = 1,  /* [12] */
	BFW_NX500_xmac_cmp3_status_tpucnt1_wr5 = 1,  /* [13] */
	BFW_NX500_xmac_cmp3_status_tpucnt1_wr6 = 1,  /* [14] */
	BFW_NX500_xmac_cmp3_status_tpucnt1_wr7 = 1,  /* [15] */
	BFW_NX500_xmac_cmp3_status_reserved1   = 16  /* [31:16] */
};

typedef struct NX500_XMAC_CMP3_STATUS_BIT_Ttag {
	unsigned int rpucnt1_wr0 : BFW_NX500_xmac_cmp3_status_rpucnt1_wr0; /* 1: rpu_count1 equals wr0 */
	unsigned int rpucnt1_wr1 : BFW_NX500_xmac_cmp3_status_rpucnt1_wr1; /* 1: rpu_count1 equals wr1 */
	unsigned int rpucnt1_wr2 : BFW_NX500_xmac_cmp3_status_rpucnt1_wr2; /* 1: rpu_count1 equals wr2 */
	unsigned int rpucnt1_wr3 : BFW_NX500_xmac_cmp3_status_rpucnt1_wr3; /* 1: rpu_count1 equals wr3 */
	unsigned int rpucnt1_wr4 : BFW_NX500_xmac_cmp3_status_rpucnt1_wr4; /* 1: rpu_count1 equals wr4 */
	unsigned int rpucnt1_wr5 : BFW_NX500_xmac_cmp3_status_rpucnt1_wr5; /* 1: rpu_count1 equals wr5 */
	unsigned int rpucnt1_wr6 : BFW_NX500_xmac_cmp3_status_rpucnt1_wr6; /* 1: rpu_count1 equals wr6 */
	unsigned int rpucnt1_wr7 : BFW_NX500_xmac_cmp3_status_rpucnt1_wr7; /* 1: rpu_count1 equals wr7 */
	unsigned int tpucnt1_wr0 : BFW_NX500_xmac_cmp3_status_tpucnt1_wr0; /* 1: tpu_count1 equals wr0 */
	unsigned int tpucnt1_wr1 : BFW_NX500_xmac_cmp3_status_tpucnt1_wr1; /* 1: tpu_count1 equals wr1 */
	unsigned int tpucnt1_wr2 : BFW_NX500_xmac_cmp3_status_tpucnt1_wr2; /* 1: tpu_count1 equals wr2 */
	unsigned int tpucnt1_wr3 : BFW_NX500_xmac_cmp3_status_tpucnt1_wr3; /* 1: tpu_count1 equals wr3 */
	unsigned int tpucnt1_wr4 : BFW_NX500_xmac_cmp3_status_tpucnt1_wr4; /* 1: tpu_count1 equals wr4 */
	unsigned int tpucnt1_wr5 : BFW_NX500_xmac_cmp3_status_tpucnt1_wr5; /* 1: tpu_count1 equals wr5 */
	unsigned int tpucnt1_wr6 : BFW_NX500_xmac_cmp3_status_tpucnt1_wr6; /* 1: tpu_count1 equals wr6 */
	unsigned int tpucnt1_wr7 : BFW_NX500_xmac_cmp3_status_tpucnt1_wr7; /* 1: tpu_count1 equals wr7 */
	unsigned int reserved1   : BFW_NX500_xmac_cmp3_status_reserved1;   /* reserved                 */
} NX500_XMAC_CMP3_STATUS_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_XMAC_CMP3_STATUS_BIT_T bf;
} NX500_XMAC_CMP3_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_alu_flags */
/* => xMAC RPU and TPU ALU Flags: */
/*    ALU Flags are only influenced by combinatonal commands like add, sub, rotate, shift. */
/*    Bitwise commands (e.g. and, or, ...) do not influence ALU-Flags. */
/*    In case of bitwise commands, ALU-Flags keep their old value. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_alu_flags   0x000008D8U
#define Adr_NX500_xmac0_xmac_alu_flags 0x001608D8U
#define Adr_NX500_xmac1_xmac_alu_flags 0x001618D8U
#define Adr_NX500_xmac2_xmac_alu_flags 0x001628D8U
#define Adr_NX500_xmac3_xmac_alu_flags 0x001638D8U

#define MSK_NX500_xmac_alu_flags_rpu_carry 0x00000001U
#define SRT_NX500_xmac_alu_flags_rpu_carry 0
#define MSK_NX500_xmac_alu_flags_rpu_zero  0x00000002U
#define SRT_NX500_xmac_alu_flags_rpu_zero  1
#define MSK_NX500_xmac_alu_flags_rpu_neg   0x00000004U
#define SRT_NX500_xmac_alu_flags_rpu_neg   2
#define MSK_NX500_xmac_alu_flags_rpu_ovf   0x00000008U
#define SRT_NX500_xmac_alu_flags_rpu_ovf   3
#define MSK_NX500_xmac_alu_flags_tpu_carry 0x00000010U
#define SRT_NX500_xmac_alu_flags_tpu_carry 4
#define MSK_NX500_xmac_alu_flags_tpu_zero  0x00000020U
#define SRT_NX500_xmac_alu_flags_tpu_zero  5
#define MSK_NX500_xmac_alu_flags_tpu_neg   0x00000040U
#define SRT_NX500_xmac_alu_flags_tpu_neg   6
#define MSK_NX500_xmac_alu_flags_tpu_ovf   0x00000080U
#define SRT_NX500_xmac_alu_flags_tpu_ovf   7
#define MSK_NX500_xmac_alu_flags_rxcnt_wr2 0x00004000U
#define SRT_NX500_xmac_alu_flags_rxcnt_wr2 14
#define MSK_NX500_xmac_alu_flags_txcnt_wr7 0x00008000U
#define SRT_NX500_xmac_alu_flags_txcnt_wr7 15

enum {
	BFW_NX500_xmac_alu_flags_rpu_carry = 1,  /* [0] */
	BFW_NX500_xmac_alu_flags_rpu_zero  = 1,  /* [1] */
	BFW_NX500_xmac_alu_flags_rpu_neg   = 1,  /* [2] */
	BFW_NX500_xmac_alu_flags_rpu_ovf   = 1,  /* [3] */
	BFW_NX500_xmac_alu_flags_tpu_carry = 1,  /* [4] */
	BFW_NX500_xmac_alu_flags_tpu_zero  = 1,  /* [5] */
	BFW_NX500_xmac_alu_flags_tpu_neg   = 1,  /* [6] */
	BFW_NX500_xmac_alu_flags_tpu_ovf   = 1,  /* [7] */
	BFW_NX500_xmac_alu_flags_reserved1 = 6,  /* [13:8] */
	BFW_NX500_xmac_alu_flags_rxcnt_wr2 = 1,  /* [14] */
	BFW_NX500_xmac_alu_flags_txcnt_wr7 = 1,  /* [15] */
	BFW_NX500_xmac_alu_flags_reserved2 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_ALU_FLAGS_BIT_Ttag {
	unsigned int rpu_carry : BFW_NX500_xmac_alu_flags_rpu_carry; /* RPU carry flag                                              */
	unsigned int rpu_zero  : BFW_NX500_xmac_alu_flags_rpu_zero;  /* RPU zero flag                                               */
	unsigned int rpu_neg   : BFW_NX500_xmac_alu_flags_rpu_neg;   /* RPU neg flag                                                */
	unsigned int rpu_ovf   : BFW_NX500_xmac_alu_flags_rpu_ovf;   /* RPU ovf flag                                                */
	unsigned int tpu_carry : BFW_NX500_xmac_alu_flags_tpu_carry; /* TPU carry flag                                              */
	unsigned int tpu_zero  : BFW_NX500_xmac_alu_flags_tpu_zero;  /* TPU zero flag                                               */
	unsigned int tpu_neg   : BFW_NX500_xmac_alu_flags_tpu_neg;   /* TPU neg flag                                                */
	unsigned int tpu_ovf   : BFW_NX500_xmac_alu_flags_tpu_ovf;   /* TPU ovf flag                                                */
	unsigned int reserved1 : BFW_NX500_xmac_alu_flags_reserved1; /* reserved                                                    */
	unsigned int rxcnt_wr2 : BFW_NX500_xmac_alu_flags_rxcnt_wr2; /* 1: rx_count equals wr2, no ALU-Flag, calculated every cycle */
	unsigned int txcnt_wr7 : BFW_NX500_xmac_alu_flags_txcnt_wr7; /* 1: tx_count equals wr7, no ALU-Flag, calculated every cycle */
	unsigned int reserved2 : BFW_NX500_xmac_alu_flags_reserved2; /* reserved                                                    */
} NX500_XMAC_ALU_FLAGS_BIT_T;

typedef union {
	unsigned int               val;
	NX500_XMAC_ALU_FLAGS_BIT_T bf;
} NX500_XMAC_ALU_FLAGS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_status_int */
/* => xMAC Status Internal Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_status_int   0x000008DCU
#define Adr_NX500_xmac0_xmac_status_int 0x001608DCU
#define Adr_NX500_xmac1_xmac_status_int 0x001618DCU
#define Adr_NX500_xmac2_xmac_status_int 0x001628DCU
#define Adr_NX500_xmac3_xmac_status_int 0x001638DCU

#define MSK_NX500_xmac_status_int_rpm_hit0    0x00000001U
#define SRT_NX500_xmac_status_int_rpm_hit0    0
#define MSK_NX500_xmac_status_int_rpm_hit1    0x00000002U
#define SRT_NX500_xmac_status_int_rpm_hit1    1
#define MSK_NX500_xmac_status_int_rpm_hit0or1 0x00000004U
#define SRT_NX500_xmac_status_int_rpm_hit0or1 2
#define MSK_NX500_xmac_status_int_tpm_hit0    0x00000008U
#define SRT_NX500_xmac_status_int_tpm_hit0    3
#define MSK_NX500_xmac_status_int_tpm_hit1    0x00000010U
#define SRT_NX500_xmac_status_int_tpm_hit1    4
#define MSK_NX500_xmac_status_int_tpm_hit0or1 0x00000020U
#define SRT_NX500_xmac_status_int_tpm_hit0or1 5
#define MSK_NX500_xmac_status_int_lbit_eq_bit 0x00000040U
#define SRT_NX500_xmac_status_int_lbit_eq_bit 6
#define MSK_NX500_xmac_status_int_tx_eq_wr45  0x00000080U
#define SRT_NX500_xmac_status_int_tx_eq_wr45  7
#define MSK_NX500_xmac_status_int_rx_crc_ok   0x00000100U
#define SRT_NX500_xmac_status_int_rx_crc_ok   8
#define MSK_NX500_xmac_status_int_tx_crc_ok   0x00000200U
#define SRT_NX500_xmac_status_int_tx_crc_ok   9
#define MSK_NX500_xmac_status_int_recbit      0x00000800U
#define SRT_NX500_xmac_status_int_recbit      11
#define MSK_NX500_xmac_status_int_brec        0x00001000U
#define SRT_NX500_xmac_status_int_brec        12
#define MSK_NX500_xmac_status_int_btran       0x00002000U
#define SRT_NX500_xmac_status_int_btran       13
#define MSK_NX500_xmac_status_int_arb_lost    0x00004000U
#define SRT_NX500_xmac_status_int_arb_lost    14
#define MSK_NX500_xmac_status_int_zero        0x00008000U
#define SRT_NX500_xmac_status_int_zero        15

enum {
	BFW_NX500_xmac_status_int_rpm_hit0    = 1,  /* [0] */
	BFW_NX500_xmac_status_int_rpm_hit1    = 1,  /* [1] */
	BFW_NX500_xmac_status_int_rpm_hit0or1 = 1,  /* [2] */
	BFW_NX500_xmac_status_int_tpm_hit0    = 1,  /* [3] */
	BFW_NX500_xmac_status_int_tpm_hit1    = 1,  /* [4] */
	BFW_NX500_xmac_status_int_tpm_hit0or1 = 1,  /* [5] */
	BFW_NX500_xmac_status_int_lbit_eq_bit = 1,  /* [6] */
	BFW_NX500_xmac_status_int_tx_eq_wr45  = 1,  /* [7] */
	BFW_NX500_xmac_status_int_rx_crc_ok   = 1,  /* [8] */
	BFW_NX500_xmac_status_int_tx_crc_ok   = 1,  /* [9] */
	BFW_NX500_xmac_status_int_reserved1   = 1,  /* [10] */
	BFW_NX500_xmac_status_int_recbit      = 1,  /* [11] */
	BFW_NX500_xmac_status_int_brec        = 1,  /* [12] */
	BFW_NX500_xmac_status_int_btran       = 1,  /* [13] */
	BFW_NX500_xmac_status_int_arb_lost    = 1,  /* [14] */
	BFW_NX500_xmac_status_int_zero        = 1,  /* [15] */
	BFW_NX500_xmac_status_int_reserved2   = 16  /* [31:16] */
};

typedef struct NX500_XMAC_STATUS_INT_BIT_Ttag {
	unsigned int rpm_hit0    : BFW_NX500_xmac_status_int_rpm_hit0;    /* receive pattern 0 matches                                */
	unsigned int rpm_hit1    : BFW_NX500_xmac_status_int_rpm_hit1;    /* receive pattern 1 matches                                */
	unsigned int rpm_hit0or1 : BFW_NX500_xmac_status_int_rpm_hit0or1; /* receive pattern 0 or pattern 1 matches                   */
	unsigned int tpm_hit0    : BFW_NX500_xmac_status_int_tpm_hit0;    /* transmit pattern 0 matches                               */
	unsigned int tpm_hit1    : BFW_NX500_xmac_status_int_tpm_hit1;    /* transmit pattern 1 matches                               */
	unsigned int tpm_hit0or1 : BFW_NX500_xmac_status_int_tpm_hit0or1; /* transmit pattern 0 or pattern 1 matches                  */
	unsigned int lbit_eq_bit : BFW_NX500_xmac_status_int_lbit_eq_bit; /* last received bit = actually received bit                */
	unsigned int tx_eq_wr45  : BFW_NX500_xmac_status_int_tx_eq_wr45;  /* compare of tx with wr4(value) and wr5(mask):             */
	                                                                  /* wr5 defines, which bits of tx and wr4 are to be compared */
	unsigned int rx_crc_ok   : BFW_NX500_xmac_status_int_rx_crc_ok;   /* compare of rx_crc_l/_h with wr0/1:                       */
	unsigned int tx_crc_ok   : BFW_NX500_xmac_status_int_tx_crc_ok;   /* compare of tx_crc_l/_h with wr8/9:                       */
	unsigned int reserved1   : BFW_NX500_xmac_status_int_reserved1;   /* reserved                                                 */
	unsigned int recbit      : BFW_NX500_xmac_status_int_recbit;      /* acutally received bit                                    */
	unsigned int brec        : BFW_NX500_xmac_status_int_brec;        /* bit received (active for 1 cc)                           */
	unsigned int btran       : BFW_NX500_xmac_status_int_btran;       /* bit transmitted (active for 1 cc)                        */
	unsigned int arb_lost    : BFW_NX500_xmac_status_int_arb_lost;    /* Arbitration Lost: transmitted bit <> received bit        */
	unsigned int zero        : BFW_NX500_xmac_status_int_zero;        /* always 0                                                 */
	unsigned int reserved2   : BFW_NX500_xmac_status_int_reserved2;   /* reserved                                                 */
} NX500_XMAC_STATUS_INT_BIT_T;

typedef union {
	unsigned int                val;
	NX500_XMAC_STATUS_INT_BIT_T bf;
} NX500_XMAC_STATUS_INT_T;

/* --------------------------------------------------------------------- */
/* Register xmac_stat_bits */
/* => xMAC stat_bits: */
/*    set and reset by hw_support bits (set_stat and reset_stat) and selected by src1_adr, */
/*    accessible by all RPUs and TPUs with higher set than reset priority */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_stat_bits   0x000008E0U
#define Adr_NX500_xmac0_xmac_stat_bits 0x001608E0U
#define Adr_NX500_xmac1_xmac_stat_bits 0x001618E0U
#define Adr_NX500_xmac2_xmac_stat_bits 0x001628E0U
#define Adr_NX500_xmac3_xmac_stat_bits 0x001638E0U

#define MSK_NX500_xmac_stat_bits_stat_bits 0x0000ffffU
#define SRT_NX500_xmac_stat_bits_stat_bits 0

enum {
	BFW_NX500_xmac_stat_bits_stat_bits = 16, /* [15:0] */
	BFW_NX500_xmac_stat_bits_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_STAT_BITS_BIT_Ttag {
	unsigned int stat_bits : BFW_NX500_xmac_stat_bits_stat_bits; /* seperate bits selected by lower bits of src1_adr, if set_stat/reset_stat are active */
	unsigned int reserved1 : BFW_NX500_xmac_stat_bits_reserved1; /* reserved                                                                            */
} NX500_XMAC_STAT_BITS_BIT_T;

typedef union {
	unsigned int               val;
	NX500_XMAC_STAT_BITS_BIT_T bf;
} NX500_XMAC_STAT_BITS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_status_mii */
/* => xMAC MII receive status register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_status_mii   0x000008E4U
#define Adr_NX500_xmac0_xmac_status_mii 0x001608E4U
#define Adr_NX500_xmac1_xmac_status_mii 0x001618E4U
#define Adr_NX500_xmac2_xmac_status_mii 0x001628E4U
#define Adr_NX500_xmac3_xmac_status_mii 0x001638E4U

#define MSK_NX500_xmac_status_mii_rx_dv       0x00000001U
#define SRT_NX500_xmac_status_mii_rx_dv       0
#define MSK_NX500_xmac_status_mii_rx_err      0x00000002U
#define SRT_NX500_xmac_status_mii_rx_err      1
#define MSK_NX500_xmac_status_mii_crs         0x00000004U
#define SRT_NX500_xmac_status_mii_crs         2
#define MSK_NX500_xmac_status_mii_col         0x00000008U
#define SRT_NX500_xmac_status_mii_col         3
#define MSK_NX500_xmac_status_mii_s_nc        0x00000010U
#define SRT_NX500_xmac_status_mii_s_nc        4
#define MSK_NX500_xmac_status_mii_v_ne_ns_nc  0x00000020U
#define SRT_NX500_xmac_status_mii_v_ne_ns_nc  5
#define MSK_NX500_xmac_status_mii_v_ne_nc     0x00000040U
#define SRT_NX500_xmac_status_mii_v_ne_nc     6
#define MSK_NX500_xmac_status_mii_v_ne_ns     0x00000080U
#define SRT_NX500_xmac_status_mii_v_ne_ns     7
#define MSK_NX500_xmac_status_mii_v_ne        0x00000100U
#define SRT_NX500_xmac_status_mii_v_ne        8
#define MSK_NX500_xmac_status_mii_v_ne_s_nc   0x00000200U
#define SRT_NX500_xmac_status_mii_v_ne_s_nc   9
#define MSK_NX500_xmac_status_mii_v_ne_s      0x00000400U
#define SRT_NX500_xmac_status_mii_v_ne_s      10
#define MSK_NX500_xmac_status_mii_v_ne_nc_p0  0x00000800U
#define SRT_NX500_xmac_status_mii_v_ne_nc_p0  11
#define MSK_NX500_xmac_status_mii_v_ne_nc_p1  0x00001000U
#define SRT_NX500_xmac_status_mii_v_ne_nc_p1  12
#define MSK_NX500_xmac_status_mii_v_ne_nc_p01 0x00002000U
#define SRT_NX500_xmac_status_mii_v_ne_nc_p01 13

enum {
	BFW_NX500_xmac_status_mii_rx_dv       = 1,  /* [0] */
	BFW_NX500_xmac_status_mii_rx_err      = 1,  /* [1] */
	BFW_NX500_xmac_status_mii_crs         = 1,  /* [2] */
	BFW_NX500_xmac_status_mii_col         = 1,  /* [3] */
	BFW_NX500_xmac_status_mii_s_nc        = 1,  /* [4] */
	BFW_NX500_xmac_status_mii_v_ne_ns_nc  = 1,  /* [5] */
	BFW_NX500_xmac_status_mii_v_ne_nc     = 1,  /* [6] */
	BFW_NX500_xmac_status_mii_v_ne_ns     = 1,  /* [7] */
	BFW_NX500_xmac_status_mii_v_ne        = 1,  /* [8] */
	BFW_NX500_xmac_status_mii_v_ne_s_nc   = 1,  /* [9] */
	BFW_NX500_xmac_status_mii_v_ne_s      = 1,  /* [10] */
	BFW_NX500_xmac_status_mii_v_ne_nc_p0  = 1,  /* [11] */
	BFW_NX500_xmac_status_mii_v_ne_nc_p1  = 1,  /* [12] */
	BFW_NX500_xmac_status_mii_v_ne_nc_p01 = 1,  /* [13] */
	BFW_NX500_xmac_status_mii_reserved1   = 18  /* [31:14] */
};

typedef struct NX500_XMAC_STATUS_MII_BIT_Ttag {
	unsigned int rx_dv       : BFW_NX500_xmac_status_mii_rx_dv;       /* mii or rmii receive data valid                         */
	unsigned int rx_err      : BFW_NX500_xmac_status_mii_rx_err;      /* mii rx_err                                             */
	unsigned int crs         : BFW_NX500_xmac_status_mii_crs;         /* mii crs                                                */
	unsigned int col         : BFW_NX500_xmac_status_mii_col;         /* mii col                                                */
	unsigned int s_nc        : BFW_NX500_xmac_status_mii_s_nc;        /* crs & !col                                             */
	unsigned int v_ne_ns_nc  : BFW_NX500_xmac_status_mii_v_ne_ns_nc;  /* rx_dv & !rx_err & !crs & !col                          */
	unsigned int v_ne_nc     : BFW_NX500_xmac_status_mii_v_ne_nc;     /* rx_dv & !rx_err &        !col                          */
	unsigned int v_ne_ns     : BFW_NX500_xmac_status_mii_v_ne_ns;     /* rx_dv & !rx_err & !crs                                 */
	unsigned int v_ne        : BFW_NX500_xmac_status_mii_v_ne;        /* rx_dv & !rx_err                                        */
	unsigned int v_ne_s_nc   : BFW_NX500_xmac_status_mii_v_ne_s_nc;   /* rx_dv & !rx_err &  crs & !col                          */
	unsigned int v_ne_s      : BFW_NX500_xmac_status_mii_v_ne_s;      /* rx_dv & !rx_err &  crs                                 */
	unsigned int v_ne_nc_p0  : BFW_NX500_xmac_status_mii_v_ne_nc_p0;  /* rx_dv & !rx_err &        !col &  rpm_hit0              */
	unsigned int v_ne_nc_p1  : BFW_NX500_xmac_status_mii_v_ne_nc_p1;  /* rx_dv & !rx_err &        !col &              rpm_hit1  */
	unsigned int v_ne_nc_p01 : BFW_NX500_xmac_status_mii_v_ne_nc_p01; /* rx_dv & !rx_err &        !col & (rpm_hit0 |  rpm_hit1) */
	unsigned int reserved1   : BFW_NX500_xmac_status_mii_reserved1;   /* reserved                                               */
} NX500_XMAC_STATUS_MII_BIT_T;

typedef union {
	unsigned int                val;
	NX500_XMAC_STATUS_MII_BIT_T bf;
} NX500_XMAC_STATUS_MII_T;

/* --------------------------------------------------------------------- */
/* Register xmac_status_mii2 */
/* => xMAC 2nd MII receive status register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_status_mii2   0x000008E8U
#define Adr_NX500_xmac0_xmac_status_mii2 0x001608E8U
#define Adr_NX500_xmac1_xmac_status_mii2 0x001618E8U
#define Adr_NX500_xmac2_xmac_status_mii2 0x001628E8U
#define Adr_NX500_xmac3_xmac_status_mii2 0x001638E8U

#define MSK_NX500_xmac_status_mii2_dv                   0x00000001U
#define SRT_NX500_xmac_status_mii2_dv                   0
#define MSK_NX500_xmac_status_mii2_miif_error           0x00000002U
#define SRT_NX500_xmac_status_mii2_miif_error           1
#define MSK_NX500_xmac_status_mii2_miif_ovfl            0x00000004U
#define SRT_NX500_xmac_status_mii2_miif_ovfl            2
#define MSK_NX500_xmac_status_mii2_miif_unfl            0x00000008U
#define SRT_NX500_xmac_status_mii2_miif_unfl            3
#define MSK_NX500_xmac_status_mii2_miif_error_short_dv  0x00000010U
#define SRT_NX500_xmac_status_mii2_miif_error_short_dv  4
#define MSK_NX500_xmac_status_mii2_miif_error_short_ifg 0x00000020U
#define SRT_NX500_xmac_status_mii2_miif_error_short_ifg 5
#define MSK_NX500_xmac_status_mii2_v_ne_nc              0x00000040U
#define SRT_NX500_xmac_status_mii2_v_ne_nc              6
#define MSK_NX500_xmac_status_mii2_v_ne                 0x00000080U
#define SRT_NX500_xmac_status_mii2_v_ne                 7
#define MSK_NX500_xmac_status_mii2_v_ne_nc_p0           0x00000100U
#define SRT_NX500_xmac_status_mii2_v_ne_nc_p0           8
#define MSK_NX500_xmac_status_mii2_v_ne_nc_p1           0x00000200U
#define SRT_NX500_xmac_status_mii2_v_ne_nc_p1           9
#define MSK_NX500_xmac_status_mii2_v_ne_nc_p01          0x00000400U
#define SRT_NX500_xmac_status_mii2_v_ne_nc_p01          10
#define MSK_NX500_xmac_status_mii2_rx_err_was_here      0x00002000U
#define SRT_NX500_xmac_status_mii2_rx_err_was_here      13
#define MSK_NX500_xmac_status_mii2_col_was_here         0x00004000U
#define SRT_NX500_xmac_status_mii2_col_was_here         14
#define MSK_NX500_xmac_status_mii2_crs_was_here         0x00008000U
#define SRT_NX500_xmac_status_mii2_crs_was_here         15

enum {
	BFW_NX500_xmac_status_mii2_dv                   = 1,  /* [0] */
	BFW_NX500_xmac_status_mii2_miif_error           = 1,  /* [1] */
	BFW_NX500_xmac_status_mii2_miif_ovfl            = 1,  /* [2] */
	BFW_NX500_xmac_status_mii2_miif_unfl            = 1,  /* [3] */
	BFW_NX500_xmac_status_mii2_miif_error_short_dv  = 1,  /* [4] */
	BFW_NX500_xmac_status_mii2_miif_error_short_ifg = 1,  /* [5] */
	BFW_NX500_xmac_status_mii2_v_ne_nc              = 1,  /* [6] */
	BFW_NX500_xmac_status_mii2_v_ne                 = 1,  /* [7] */
	BFW_NX500_xmac_status_mii2_v_ne_nc_p0           = 1,  /* [8] */
	BFW_NX500_xmac_status_mii2_v_ne_nc_p1           = 1,  /* [9] */
	BFW_NX500_xmac_status_mii2_v_ne_nc_p01          = 1,  /* [10] */
	BFW_NX500_xmac_status_mii2_reserved1            = 2,  /* [12:11] */
	BFW_NX500_xmac_status_mii2_rx_err_was_here      = 1,  /* [13] */
	BFW_NX500_xmac_status_mii2_col_was_here         = 1,  /* [14] */
	BFW_NX500_xmac_status_mii2_crs_was_here         = 1,  /* [15] */
	BFW_NX500_xmac_status_mii2_reserved2            = 16  /* [31:16] */
};

typedef struct NX500_XMAC_STATUS_MII2_BIT_Ttag {
	unsigned int dv                   : BFW_NX500_xmac_status_mii2_dv;                   /* MII-nibble-fifo data valid:                                                            */
	                                                                                     /* Fifo is automatically filled, if rx_dv=1. This bit gets active, if fifo contains data. */
	unsigned int miif_error           : BFW_NX500_xmac_status_mii2_miif_error;           /* any error at the MII-nibble-fifo occured,                                              */
	                                                                                     /* reset by setting xmac_config_nibble_fifo-fifo_depth=0                                  */
	unsigned int miif_ovfl            : BFW_NX500_xmac_status_mii2_miif_ovfl;            /* MII-nibble-fifo overflow,                                                              */
	                                                                                     /* reset by setting xmac_config_nibble_fifo-fifo_depth=0                                  */
	unsigned int miif_unfl            : BFW_NX500_xmac_status_mii2_miif_unfl;            /* MII-nibble-fifo underflow,                                                             */
	                                                                                     /* reset by setting xmac_config_nibble_fifo-fifo_depth=0                                  */
	unsigned int miif_error_short_dv  : BFW_NX500_xmac_status_mii2_miif_error_short_dv;  /* rx_dv was active for very short time,                                                  */
	                                                                                     /* reset by setting xmac_config_nibble_fifo-fifo_depth=0                                  */
	unsigned int miif_error_short_ifg : BFW_NX500_xmac_status_mii2_miif_error_short_ifg; /* rx_dv was inactive for very short time,                                                */
	                                                                                     /* reset by setting xmac_config_nibble_fifo-fifo_depth=0                                  */
	unsigned int v_ne_nc              : BFW_NX500_xmac_status_mii2_v_ne_nc;              /* dv & !rx_err & !col                                                                    */
	                                                                                     /* Useful, if rx_err and col have to be checked every cycle by software                   */
	unsigned int v_ne                 : BFW_NX500_xmac_status_mii2_v_ne;                 /* dv & !rx_err                                                                           */
	                                                                                     /* Useful, if rx_err has to be checked every cycle by software                            */
	unsigned int v_ne_nc_p0           : BFW_NX500_xmac_status_mii2_v_ne_nc_p0;           /* dv & !rx_err & !col &  rpm_hit0                                                        */
	                                                                                     /* Useful, if rx_err and col have to be checked every cycle by software                   */
	unsigned int v_ne_nc_p1           : BFW_NX500_xmac_status_mii2_v_ne_nc_p1;           /* dv & !rx_err & !col &             rpm_hit1                                             */
	                                                                                     /* Useful, if rx_err and col have to be checked every cycle by software                   */
	unsigned int v_ne_nc_p01          : BFW_NX500_xmac_status_mii2_v_ne_nc_p01;          /* dv & !rx_err & !col & (rpm_hit0 |  rpm_hit1)                                           */
	                                                                                     /* dv:     after fifo,  i.e. status_mii2(0)                                               */
	unsigned int reserved1            : BFW_NX500_xmac_status_mii2_reserved1;            /* reserved                                                                               */
	unsigned int rx_err_was_here      : BFW_NX500_xmac_status_mii2_rx_err_was_here;      /* rx_err was here:                                                                       */
	                                                                                     /* Useful, if rx_err needs only to be checked at end of frame.                            */
	unsigned int col_was_here         : BFW_NX500_xmac_status_mii2_col_was_here;         /* col was here:                                                                          */
	                                                                                     /* Useful, if col needs only to be checked at end of frame.                               */
	unsigned int crs_was_here         : BFW_NX500_xmac_status_mii2_crs_was_here;         /* crs was here:                                                                          */
	                                                                                     /* Useful, if crs needs only to be checked at end of frame.                               */
	unsigned int reserved2            : BFW_NX500_xmac_status_mii2_reserved2;            /* reserved                                                                               */
} NX500_XMAC_STATUS_MII2_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_XMAC_STATUS_MII2_BIT_T bf;
} NX500_XMAC_STATUS_MII2_T;

/* --------------------------------------------------------------------- */
/* Register xmac_config_mii */
/* => xMAC MII transmit config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_config_mii   0x000008ECU
#define Adr_NX500_xmac0_xmac_config_mii 0x001608ECU
#define Adr_NX500_xmac1_xmac_config_mii 0x001618ECU
#define Adr_NX500_xmac2_xmac_config_mii 0x001628ECU
#define Adr_NX500_xmac3_xmac_config_mii 0x001638ECU
#define DFLT_VAL_NX500_xmac_config_mii  0x00000000U

#define MSK_NX500_xmac_config_mii_tx_en       0x00000001U
#define SRT_NX500_xmac_config_mii_tx_en       0
#define DFLT_VAL_NX500_xmac_config_mii_tx_en  0x00000000U
#define MSK_NX500_xmac_config_mii_tx_err      0x00000002U
#define SRT_NX500_xmac_config_mii_tx_err      1
#define DFLT_VAL_NX500_xmac_config_mii_tx_err 0x00000000U

enum {
	BFW_NX500_xmac_config_mii_tx_en     = 1,  /* [0] */
	BFW_NX500_xmac_config_mii_tx_err    = 1,  /* [1] */
	BFW_NX500_xmac_config_mii_reserved1 = 30  /* [31:2] */
};

typedef struct NX500_XMAC_CONFIG_MII_BIT_Ttag {
	unsigned int tx_en     : BFW_NX500_xmac_config_mii_tx_en;     /* mii tx_en                  */
	                                                              /* Synchronized to mii tx_clk */
	unsigned int tx_err    : BFW_NX500_xmac_config_mii_tx_err;    /* mii tx_err                 */
	                                                              /* Synchronized to mii tx_clk */
	unsigned int reserved1 : BFW_NX500_xmac_config_mii_reserved1; /* reserved                   */
} NX500_XMAC_CONFIG_MII_BIT_T;

typedef union {
	unsigned int                val;
	NX500_XMAC_CONFIG_MII_BIT_T bf;
} NX500_XMAC_CONFIG_MII_T;

/* --------------------------------------------------------------------- */
/* Register xmac_config_nibble_fifo */
/* => xMAC mii nibble fifo config register */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_config_nibble_fifo   0x000008F0U
#define Adr_NX500_xmac0_xmac_config_nibble_fifo 0x001608F0U
#define Adr_NX500_xmac1_xmac_config_nibble_fifo 0x001618F0U
#define Adr_NX500_xmac2_xmac_config_nibble_fifo 0x001628F0U
#define Adr_NX500_xmac3_xmac_config_nibble_fifo 0x001638F0U
#define DFLT_VAL_NX500_xmac_config_nibble_fifo  0x00000280U

#define MSK_NX500_xmac_config_nibble_fifo_fifo_depth        0x0000000fU
#define SRT_NX500_xmac_config_nibble_fifo_fifo_depth        0
#define DFLT_VAL_NX500_xmac_config_nibble_fifo_fifo_depth   0x00000000U
#define MSK_NX500_xmac_config_nibble_fifo_read_phase        0x00000030U
#define SRT_NX500_xmac_config_nibble_fifo_read_phase        4
#define DFLT_VAL_NX500_xmac_config_nibble_fifo_read_phase   0x00000000U
#define MSK_NX500_xmac_config_nibble_fifo_sample_phase      0x000000c0U
#define SRT_NX500_xmac_config_nibble_fifo_sample_phase      6
#define DFLT_VAL_NX500_xmac_config_nibble_fifo_sample_phase 0x00000080U
#define MSK_NX500_xmac_config_nibble_fifo_output_phase      0x00000300U
#define SRT_NX500_xmac_config_nibble_fifo_output_phase      8
#define DFLT_VAL_NX500_xmac_config_nibble_fifo_output_phase 0x00000200U

enum {
	BFW_NX500_xmac_config_nibble_fifo_fifo_depth   = 4,  /* [3:0] */
	BFW_NX500_xmac_config_nibble_fifo_read_phase   = 2,  /* [5:4] */
	BFW_NX500_xmac_config_nibble_fifo_sample_phase = 2,  /* [7:6] */
	BFW_NX500_xmac_config_nibble_fifo_output_phase = 2,  /* [9:8] */
	BFW_NX500_xmac_config_nibble_fifo_reserved1    = 22  /* [31:10] */
};

typedef struct NX500_XMAC_CONFIG_NIBBLE_FIFO_BIT_Ttag {
	unsigned int fifo_depth   : BFW_NX500_xmac_config_nibble_fifo_fifo_depth;   /* Fill level (= number of nibbles) up to which mii-nibble-fifo is filled, before reading to rx register starts.                              */
	                                                                            /* 0 means, mii-nibble-fifo is turned off, data is sampled directly to rx register (with jitter), fifo is reset.                              */
	unsigned int read_phase   : BFW_NX500_xmac_config_nibble_fifo_read_phase;   /* Phases, in which nibbles from MII-nibble-fifo are read to rx register:                                                                     */
	                                                                            /* If mii-nibble-fifo is enabled (fifo_depth!=0), the sync-signal (copies data to rx register) is generated by a counter (instead of rx_clk), */
	unsigned int sample_phase : BFW_NX500_xmac_config_nibble_fifo_sample_phase; /* Phase of mii_rx_clk, where mii_rx_d, rx_dv, rx_err, crs, col are sampled:                                                                  */
	                                                                            /* Don't change default, unless you know what you are doing !                                                                                 */
	unsigned int output_phase : BFW_NX500_xmac_config_nibble_fifo_output_phase; /* Phase of mii_tx_clk, where mii_tx_d, tx_en, tx_err outputs are changed:                                                                    */
	                                                                            /* Don't change default, unless you know what you are doing !                                                                                 */
	unsigned int reserved1    : BFW_NX500_xmac_config_nibble_fifo_reserved1;    /* reserved                                                                                                                                   */
} NX500_XMAC_CONFIG_NIBBLE_FIFO_BIT_T;

typedef union {
	unsigned int                        val;
	NX500_XMAC_CONFIG_NIBBLE_FIFO_BIT_T bf;
} NX500_XMAC_CONFIG_NIBBLE_FIFO_T;

/* --------------------------------------------------------------------- */
/* Register xmac_config_sbu */
/* => xMAC Config Register for SBU */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_config_sbu   0x000008F4U
#define Adr_NX500_xmac0_xmac_config_sbu 0x001608F4U
#define Adr_NX500_xmac1_xmac_config_sbu 0x001618F4U
#define Adr_NX500_xmac2_xmac_config_sbu 0x001628F4U
#define Adr_NX500_xmac3_xmac_config_sbu 0x001638F4U
#define DFLT_VAL_NX500_xmac_config_sbu  0x00000000U

#define MSK_NX500_xmac_config_sbu_sync_to_eclk           0x00000001U
#define SRT_NX500_xmac_config_sbu_sync_to_eclk           0
#define DFLT_VAL_NX500_xmac_config_sbu_sync_to_eclk      0x00000000U
#define MSK_NX500_xmac_config_sbu_sync_to_bitstream      0x00000002U
#define SRT_NX500_xmac_config_sbu_sync_to_bitstream      1
#define DFLT_VAL_NX500_xmac_config_sbu_sync_to_bitstream 0x00000000U
#define MSK_NX500_xmac_config_sbu_sync_to_posedge        0x00000004U
#define SRT_NX500_xmac_config_sbu_sync_to_posedge        2
#define DFLT_VAL_NX500_xmac_config_sbu_sync_to_posedge   0x00000000U
#define MSK_NX500_xmac_config_sbu_sync_to_negedge        0x00000008U
#define SRT_NX500_xmac_config_sbu_sync_to_negedge        3
#define DFLT_VAL_NX500_xmac_config_sbu_sync_to_negedge   0x00000000U
#define MSK_NX500_xmac_config_sbu_count_modulo           0x00000010U
#define SRT_NX500_xmac_config_sbu_count_modulo           4
#define DFLT_VAL_NX500_xmac_config_sbu_count_modulo      0x00000000U
#define MSK_NX500_xmac_config_sbu_invert_bit             0x00000020U
#define SRT_NX500_xmac_config_sbu_invert_bit             5
#define DFLT_VAL_NX500_xmac_config_sbu_invert_bit        0x00000000U
#define MSK_NX500_xmac_config_sbu_predivide_clk          0x00000040U
#define SRT_NX500_xmac_config_sbu_predivide_clk          6
#define DFLT_VAL_NX500_xmac_config_sbu_predivide_clk     0x00000000U
#define MSK_NX500_xmac_config_sbu_ext_mode               0x00000300U
#define SRT_NX500_xmac_config_sbu_ext_mode               8
#define DFLT_VAL_NX500_xmac_config_sbu_ext_mode          0x00000000U
#define MSK_NX500_xmac_config_sbu_rx_err_low_active      0x00000400U
#define SRT_NX500_xmac_config_sbu_rx_err_low_active      10
#define DFLT_VAL_NX500_xmac_config_sbu_rx_err_low_active 0x00000000U
#define MSK_NX500_xmac_config_sbu_rx_err_reset           0x00000800U
#define SRT_NX500_xmac_config_sbu_rx_err_reset           11
#define DFLT_VAL_NX500_xmac_config_sbu_rx_err_reset      0x00000000U
#define MSK_NX500_xmac_config_sbu_col_low_active         0x00001000U
#define SRT_NX500_xmac_config_sbu_col_low_active         12
#define DFLT_VAL_NX500_xmac_config_sbu_col_low_active    0x00000000U
#define MSK_NX500_xmac_config_sbu_col_reset              0x00002000U
#define SRT_NX500_xmac_config_sbu_col_reset              13
#define DFLT_VAL_NX500_xmac_config_sbu_col_reset         0x00000000U
#define MSK_NX500_xmac_config_sbu_crs_low_active         0x00004000U
#define SRT_NX500_xmac_config_sbu_crs_low_active         14
#define DFLT_VAL_NX500_xmac_config_sbu_crs_low_active    0x00000000U
#define MSK_NX500_xmac_config_sbu_crs_reset              0x00008000U
#define SRT_NX500_xmac_config_sbu_crs_reset              15
#define DFLT_VAL_NX500_xmac_config_sbu_crs_reset         0x00000000U

enum {
	BFW_NX500_xmac_config_sbu_sync_to_eclk      = 1,  /* [0] */
	BFW_NX500_xmac_config_sbu_sync_to_bitstream = 1,  /* [1] */
	BFW_NX500_xmac_config_sbu_sync_to_posedge   = 1,  /* [2] */
	BFW_NX500_xmac_config_sbu_sync_to_negedge   = 1,  /* [3] */
	BFW_NX500_xmac_config_sbu_count_modulo      = 1,  /* [4] */
	BFW_NX500_xmac_config_sbu_invert_bit        = 1,  /* [5] */
	BFW_NX500_xmac_config_sbu_predivide_clk     = 1,  /* [6] */
	BFW_NX500_xmac_config_sbu_reserved1         = 1,  /* [7] */
	BFW_NX500_xmac_config_sbu_ext_mode          = 2,  /* [9:8] */
	BFW_NX500_xmac_config_sbu_rx_err_low_active = 1,  /* [10] */
	BFW_NX500_xmac_config_sbu_rx_err_reset      = 1,  /* [11] */
	BFW_NX500_xmac_config_sbu_col_low_active    = 1,  /* [12] */
	BFW_NX500_xmac_config_sbu_col_reset         = 1,  /* [13] */
	BFW_NX500_xmac_config_sbu_crs_low_active    = 1,  /* [14] */
	BFW_NX500_xmac_config_sbu_crs_reset         = 1,  /* [15] */
	BFW_NX500_xmac_config_sbu_reserved2         = 16  /* [31:16] */
};

typedef struct NX500_XMAC_CONFIG_SBU_BIT_Ttag {
	unsigned int sync_to_eclk      : BFW_NX500_xmac_config_sbu_sync_to_eclk;      /* Synchronize rate_multiplier to external clock,                             */
	                                                                              /* rate_mul is set to rate_mul_start at pos/negedge of eclk                   */
	unsigned int sync_to_bitstream : BFW_NX500_xmac_config_sbu_sync_to_bitstream; /* Synchronize rate_multiplier to data_in,                                    */
	                                                                              /* rate_mul is set to rate_mul_start at pos/negedge of data_in                */
	unsigned int sync_to_posedge   : BFW_NX500_xmac_config_sbu_sync_to_posedge;   /* Synchronization of rate_multiplier works on positive edges of data_in/eclk */
	unsigned int sync_to_negedge   : BFW_NX500_xmac_config_sbu_sync_to_negedge;   /* Synchronization of rate_multiplier works on negative edges of data_in/eclk */
	unsigned int count_modulo      : BFW_NX500_xmac_config_sbu_count_modulo;      /* rate_multiplier continues counting after maximum value is reached          */
	unsigned int invert_bit        : BFW_NX500_xmac_config_sbu_invert_bit;        /* invert incoming bit                                                        */
	unsigned int predivide_clk     : BFW_NX500_xmac_config_sbu_predivide_clk;     /* use a clock frequency divided by 256                                       */
	unsigned int reserved1         : BFW_NX500_xmac_config_sbu_reserved1;         /* reserved                                                                   */
	unsigned int ext_mode          : BFW_NX500_xmac_config_sbu_ext_mode;          /* 00 single bit, 01 mii, 10,11 reserved                                      */
	unsigned int rx_err_low_active : BFW_NX500_xmac_config_sbu_rx_err_low_active; /* to generate rx_err_was_here signal:                                        */
	                                                                              /* 0: activate rx_err_was_here if rx_err=1,                                   */
	unsigned int rx_err_reset      : BFW_NX500_xmac_config_sbu_rx_err_reset;      /* to reset rx_err_was_here signal                                            */
	unsigned int col_low_active    : BFW_NX500_xmac_config_sbu_col_low_active;    /* to generate col_was_here signal:                                           */
	                                                                              /* 0: activate col_was_here if col=1,                                         */
	unsigned int col_reset         : BFW_NX500_xmac_config_sbu_col_reset;         /* to reset col_was_here signal                                               */
	unsigned int crs_low_active    : BFW_NX500_xmac_config_sbu_crs_low_active;    /* to generate crs_was_here signal:                                           */
	                                                                              /* 0: activate crs_was_here if crs=1,                                         */
	unsigned int crs_reset         : BFW_NX500_xmac_config_sbu_crs_reset;         /* to reset crs_was_here signal                                               */
	unsigned int reserved2         : BFW_NX500_xmac_config_sbu_reserved2;         /* reserved                                                                   */
} NX500_XMAC_CONFIG_SBU_BIT_T;

typedef union {
	unsigned int                val;
	NX500_XMAC_CONFIG_SBU_BIT_T bf;
} NX500_XMAC_CONFIG_SBU_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sbu_rate_mul_add */
/* => xMAC SBU rate_mul_add: */
/*    Value added each cc to Rate Multiplier. */
/*    rate_mul_add = eclk / clk * 65536 */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sbu_rate_mul_add   0x000008F8U
#define Adr_NX500_xmac0_xmac_sbu_rate_mul_add 0x001608F8U
#define Adr_NX500_xmac1_xmac_sbu_rate_mul_add 0x001618F8U
#define Adr_NX500_xmac2_xmac_sbu_rate_mul_add 0x001628F8U
#define Adr_NX500_xmac3_xmac_sbu_rate_mul_add 0x001638F8U
#define DFLT_VAL_NX500_xmac_sbu_rate_mul_add  0x00000001U

#define MSK_NX500_xmac_sbu_rate_mul_add_rate_mul_add      0x0000ffffU
#define SRT_NX500_xmac_sbu_rate_mul_add_rate_mul_add      0
#define DFLT_VAL_NX500_xmac_sbu_rate_mul_add_rate_mul_add 0x00000001U

enum {
	BFW_NX500_xmac_sbu_rate_mul_add_rate_mul_add = 16, /* [15:0] */
	BFW_NX500_xmac_sbu_rate_mul_add_reserved1    = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SBU_RATE_MUL_ADD_BIT_Ttag {
	unsigned int rate_mul_add : BFW_NX500_xmac_sbu_rate_mul_add_rate_mul_add; /* Value added each cc to Rate Multiplier.                             */
	                                                                          /* If rate_mul_add=1:      rate_mul counts from [rate_mul_start:65535] */
	unsigned int reserved1    : BFW_NX500_xmac_sbu_rate_mul_add_reserved1;    /* reserved                                                            */
} NX500_XMAC_SBU_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int                      val;
	NX500_XMAC_SBU_RATE_MUL_ADD_BIT_T bf;
} NX500_XMAC_SBU_RATE_MUL_ADD_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sbu_rate_mul_start */
/* => xMAC SBU rate_mul_start */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sbu_rate_mul_start   0x000008FCU
#define Adr_NX500_xmac0_xmac_sbu_rate_mul_start 0x001608FCU
#define Adr_NX500_xmac1_xmac_sbu_rate_mul_start 0x001618FCU
#define Adr_NX500_xmac2_xmac_sbu_rate_mul_start 0x001628FCU
#define Adr_NX500_xmac3_xmac_sbu_rate_mul_start 0x001638FCU
#define DFLT_VAL_NX500_xmac_sbu_rate_mul_start  0x00000000U

#define MSK_NX500_xmac_sbu_rate_mul_start_rate_mul_start      0x0000ffffU
#define SRT_NX500_xmac_sbu_rate_mul_start_rate_mul_start      0
#define DFLT_VAL_NX500_xmac_sbu_rate_mul_start_rate_mul_start 0x00000000U

enum {
	BFW_NX500_xmac_sbu_rate_mul_start_rate_mul_start = 16, /* [15:0] */
	BFW_NX500_xmac_sbu_rate_mul_start_reserved1      = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SBU_RATE_MUL_START_BIT_Ttag {
	unsigned int rate_mul_start : BFW_NX500_xmac_sbu_rate_mul_start_rate_mul_start; /* Value, the Rate Multiplier is set to at sync */
	unsigned int reserved1      : BFW_NX500_xmac_sbu_rate_mul_start_reserved1;      /* reserved                                     */
} NX500_XMAC_SBU_RATE_MUL_START_BIT_T;

typedef union {
	unsigned int                        val;
	NX500_XMAC_SBU_RATE_MUL_START_BIT_T bf;
} NX500_XMAC_SBU_RATE_MUL_START_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sbu_rate_mul */
/* => xMAC SBU rate_mul */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_sbu_rate_mul   0x00000900U
#define Adr_NX500_xmac0_xmac_sbu_rate_mul 0x00160900U
#define Adr_NX500_xmac1_xmac_sbu_rate_mul 0x00161900U
#define Adr_NX500_xmac2_xmac_sbu_rate_mul 0x00162900U
#define Adr_NX500_xmac3_xmac_sbu_rate_mul 0x00163900U

#define MSK_NX500_xmac_sbu_rate_mul_rate_mul 0x0000ffffU
#define SRT_NX500_xmac_sbu_rate_mul_rate_mul 0

enum {
	BFW_NX500_xmac_sbu_rate_mul_rate_mul  = 16, /* [15:0] */
	BFW_NX500_xmac_sbu_rate_mul_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_SBU_RATE_MUL_BIT_Ttag {
	unsigned int rate_mul  : BFW_NX500_xmac_sbu_rate_mul_rate_mul;  /* current value of Rate Multiplier */
	unsigned int reserved1 : BFW_NX500_xmac_sbu_rate_mul_reserved1; /* reserved                         */
} NX500_XMAC_SBU_RATE_MUL_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_XMAC_SBU_RATE_MUL_BIT_T bf;
} NX500_XMAC_SBU_RATE_MUL_T;

/* --------------------------------------------------------------------- */
/* Register xmac_start_sample_pos */
/* => xMAC SBU start_sample_pos */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_start_sample_pos   0x00000904U
#define Adr_NX500_xmac0_xmac_start_sample_pos 0x00160904U
#define Adr_NX500_xmac1_xmac_start_sample_pos 0x00161904U
#define Adr_NX500_xmac2_xmac_start_sample_pos 0x00162904U
#define Adr_NX500_xmac3_xmac_start_sample_pos 0x00163904U
#define DFLT_VAL_NX500_xmac_start_sample_pos  0x00000000U

#define MSK_NX500_xmac_start_sample_pos_start_sample_pos      0x0000ffffU
#define SRT_NX500_xmac_start_sample_pos_start_sample_pos      0
#define DFLT_VAL_NX500_xmac_start_sample_pos_start_sample_pos 0x00000000U

enum {
	BFW_NX500_xmac_start_sample_pos_start_sample_pos = 16, /* [15:0] */
	BFW_NX500_xmac_start_sample_pos_reserved1        = 16  /* [31:16] */
};

typedef struct NX500_XMAC_START_SAMPLE_POS_BIT_Ttag {
	unsigned int start_sample_pos : BFW_NX500_xmac_start_sample_pos_start_sample_pos; /* data is sampled and averaged if start_sample_pos <= rate_mul < stop_sample_pos */
	unsigned int reserved1        : BFW_NX500_xmac_start_sample_pos_reserved1;        /* reserved                                                                       */
} NX500_XMAC_START_SAMPLE_POS_BIT_T;

typedef union {
	unsigned int                      val;
	NX500_XMAC_START_SAMPLE_POS_BIT_T bf;
} NX500_XMAC_START_SAMPLE_POS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_stop_sample_pos */
/* => xMAC SBU stop_sample_pos */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_stop_sample_pos   0x00000908U
#define Adr_NX500_xmac0_xmac_stop_sample_pos 0x00160908U
#define Adr_NX500_xmac1_xmac_stop_sample_pos 0x00161908U
#define Adr_NX500_xmac2_xmac_stop_sample_pos 0x00162908U
#define Adr_NX500_xmac3_xmac_stop_sample_pos 0x00163908U
#define DFLT_VAL_NX500_xmac_stop_sample_pos  0x00000000U

#define MSK_NX500_xmac_stop_sample_pos_stop_sample_pos      0x0000ffffU
#define SRT_NX500_xmac_stop_sample_pos_stop_sample_pos      0
#define DFLT_VAL_NX500_xmac_stop_sample_pos_stop_sample_pos 0x00000000U

enum {
	BFW_NX500_xmac_stop_sample_pos_stop_sample_pos = 16, /* [15:0] */
	BFW_NX500_xmac_stop_sample_pos_reserved1       = 16  /* [31:16] */
};

typedef struct NX500_XMAC_STOP_SAMPLE_POS_BIT_Ttag {
	unsigned int stop_sample_pos : BFW_NX500_xmac_stop_sample_pos_stop_sample_pos; /* data is sampled and averaged if start_sample_pos <= rate_mul < stop_sample_pos */
	unsigned int reserved1       : BFW_NX500_xmac_stop_sample_pos_reserved1;       /* reserved                                                                       */
} NX500_XMAC_STOP_SAMPLE_POS_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_XMAC_STOP_SAMPLE_POS_BIT_T bf;
} NX500_XMAC_STOP_SAMPLE_POS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_config_obu */
/* => xMAC Config Register for OBU */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_config_obu   0x0000090CU
#define Adr_NX500_xmac0_xmac_config_obu 0x0016090CU
#define Adr_NX500_xmac1_xmac_config_obu 0x0016190CU
#define Adr_NX500_xmac2_xmac_config_obu 0x0016290CU
#define Adr_NX500_xmac3_xmac_config_obu 0x0016390CU
#define DFLT_VAL_NX500_xmac_config_obu  0x00000180U

#define MSK_NX500_xmac_config_obu_sync_to_eclk               0x00000001U
#define SRT_NX500_xmac_config_obu_sync_to_eclk               0
#define DFLT_VAL_NX500_xmac_config_obu_sync_to_eclk          0x00000000U
#define MSK_NX500_xmac_config_obu_sync_to_bitstream          0x00000002U
#define SRT_NX500_xmac_config_obu_sync_to_bitstream          1
#define DFLT_VAL_NX500_xmac_config_obu_sync_to_bitstream     0x00000000U
#define MSK_NX500_xmac_config_obu_sync_to_posedge            0x00000004U
#define SRT_NX500_xmac_config_obu_sync_to_posedge            2
#define DFLT_VAL_NX500_xmac_config_obu_sync_to_posedge       0x00000000U
#define MSK_NX500_xmac_config_obu_sync_to_negedge            0x00000008U
#define SRT_NX500_xmac_config_obu_sync_to_negedge            3
#define DFLT_VAL_NX500_xmac_config_obu_sync_to_negedge       0x00000000U
#define MSK_NX500_xmac_config_obu_count_modulo               0x00000010U
#define SRT_NX500_xmac_config_obu_count_modulo               4
#define DFLT_VAL_NX500_xmac_config_obu_count_modulo          0x00000000U
#define MSK_NX500_xmac_config_obu_invert_bit                 0x00000020U
#define SRT_NX500_xmac_config_obu_invert_bit                 5
#define DFLT_VAL_NX500_xmac_config_obu_invert_bit            0x00000000U
#define MSK_NX500_xmac_config_obu_predivide_clk              0x00000040U
#define SRT_NX500_xmac_config_obu_predivide_clk              6
#define DFLT_VAL_NX500_xmac_config_obu_predivide_clk         0x00000000U
#define MSK_NX500_xmac_config_obu_tx_three_state             0x00000080U
#define SRT_NX500_xmac_config_obu_tx_three_state             7
#define DFLT_VAL_NX500_xmac_config_obu_tx_three_state        0x00000080U
#define MSK_NX500_xmac_config_obu_eclk_noe                   0x00000100U
#define SRT_NX500_xmac_config_obu_eclk_noe                   8
#define DFLT_VAL_NX500_xmac_config_obu_eclk_noe              0x00000100U
#define MSK_NX500_xmac_config_obu_sample_bitstream_eclk      0x00000200U
#define SRT_NX500_xmac_config_obu_sample_bitstream_eclk      9
#define DFLT_VAL_NX500_xmac_config_obu_sample_bitstream_eclk 0x00000000U
#define MSK_NX500_xmac_config_obu_arb_lost_delay             0x0000fc00U
#define SRT_NX500_xmac_config_obu_arb_lost_delay             10
#define DFLT_VAL_NX500_xmac_config_obu_arb_lost_delay        0x00000000U

enum {
	BFW_NX500_xmac_config_obu_sync_to_eclk          = 1,  /* [0] */
	BFW_NX500_xmac_config_obu_sync_to_bitstream     = 1,  /* [1] */
	BFW_NX500_xmac_config_obu_sync_to_posedge       = 1,  /* [2] */
	BFW_NX500_xmac_config_obu_sync_to_negedge       = 1,  /* [3] */
	BFW_NX500_xmac_config_obu_count_modulo          = 1,  /* [4] */
	BFW_NX500_xmac_config_obu_invert_bit            = 1,  /* [5] */
	BFW_NX500_xmac_config_obu_predivide_clk         = 1,  /* [6] */
	BFW_NX500_xmac_config_obu_tx_three_state        = 1,  /* [7] */
	BFW_NX500_xmac_config_obu_eclk_noe              = 1,  /* [8] */
	BFW_NX500_xmac_config_obu_sample_bitstream_eclk = 1,  /* [9] */
	BFW_NX500_xmac_config_obu_arb_lost_delay        = 6,  /* [15:10] */
	BFW_NX500_xmac_config_obu_reserved1             = 16  /* [31:16] */
};

typedef struct NX500_XMAC_CONFIG_OBU_BIT_Ttag {
	unsigned int sync_to_eclk          : BFW_NX500_xmac_config_obu_sync_to_eclk;          /* Synchronize rate_multiplier to external clock,                                      */
	                                                                                      /* rate_mul is set to rate_mul_start at pos/negedge of eclk                            */
	unsigned int sync_to_bitstream     : BFW_NX500_xmac_config_obu_sync_to_bitstream;     /* Synchronize rate_multiplier to data_in,                                             */
	                                                                                      /* rate_mul is set to rate_mul_start at pos/negedge of data_in                         */
	unsigned int sync_to_posedge       : BFW_NX500_xmac_config_obu_sync_to_posedge;       /* Synchronization of rate_multiplier works on positive edges of data_in/eclk          */
	unsigned int sync_to_negedge       : BFW_NX500_xmac_config_obu_sync_to_negedge;       /* Synchronization of rate_multiplier works on negative edges of data_in/eclk          */
	unsigned int count_modulo          : BFW_NX500_xmac_config_obu_count_modulo;          /* rate_multiplier continues counting after maximum value is reached                   */
	unsigned int invert_bit            : BFW_NX500_xmac_config_obu_invert_bit;            /* invert incoming bit                                                                 */
	unsigned int predivide_clk         : BFW_NX500_xmac_config_obu_predivide_clk;         /* use a clock frequency divided by 256                                                */
	unsigned int tx_three_state        : BFW_NX500_xmac_config_obu_tx_three_state;        /* deactivates output enable of actually transmitted bit (or nibble in mii-mode)       */
	unsigned int eclk_noe              : BFW_NX500_xmac_config_obu_eclk_noe;              /* inv. output enable of eclk: 0: eclk generated by xMAC, 1: eclk coming from external */
	unsigned int sample_bitstream_eclk : BFW_NX500_xmac_config_obu_sample_bitstream_eclk; /* 1: sample outgoing bitstream and its oe with eclk (posedge).                        */
	unsigned int arb_lost_delay        : BFW_NX500_xmac_config_obu_arb_lost_delay;        /* nof cc after start_trans_pos, before data_in is sampled for arb_lost                */
	unsigned int reserved1             : BFW_NX500_xmac_config_obu_reserved1;             /* reserved                                                                            */
} NX500_XMAC_CONFIG_OBU_BIT_T;

typedef union {
	unsigned int                val;
	NX500_XMAC_CONFIG_OBU_BIT_T bf;
} NX500_XMAC_CONFIG_OBU_T;

/* --------------------------------------------------------------------- */
/* Register xmac_obu_rate_mul_add */
/* => xMAC OBU rate_mul_add: */
/*    Value added each cc to Rate Multiplier. */
/*    rate_mul_add = eclk / clk * 65536 */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_obu_rate_mul_add   0x00000910U
#define Adr_NX500_xmac0_xmac_obu_rate_mul_add 0x00160910U
#define Adr_NX500_xmac1_xmac_obu_rate_mul_add 0x00161910U
#define Adr_NX500_xmac2_xmac_obu_rate_mul_add 0x00162910U
#define Adr_NX500_xmac3_xmac_obu_rate_mul_add 0x00163910U
#define DFLT_VAL_NX500_xmac_obu_rate_mul_add  0x00000001U

#define MSK_NX500_xmac_obu_rate_mul_add_rate_mul_add      0x0000ffffU
#define SRT_NX500_xmac_obu_rate_mul_add_rate_mul_add      0
#define DFLT_VAL_NX500_xmac_obu_rate_mul_add_rate_mul_add 0x00000001U

enum {
	BFW_NX500_xmac_obu_rate_mul_add_rate_mul_add = 16, /* [15:0] */
	BFW_NX500_xmac_obu_rate_mul_add_reserved1    = 16  /* [31:16] */
};

typedef struct NX500_XMAC_OBU_RATE_MUL_ADD_BIT_Ttag {
	unsigned int rate_mul_add : BFW_NX500_xmac_obu_rate_mul_add_rate_mul_add; /* Value added each cc to Rate Multiplier.                             */
	                                                                          /* If rate_mul_add=1:      rate_mul counts from [rate_mul_start:65535] */
	unsigned int reserved1    : BFW_NX500_xmac_obu_rate_mul_add_reserved1;    /* reserved                                                            */
} NX500_XMAC_OBU_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int                      val;
	NX500_XMAC_OBU_RATE_MUL_ADD_BIT_T bf;
} NX500_XMAC_OBU_RATE_MUL_ADD_T;

/* --------------------------------------------------------------------- */
/* Register xmac_obu_rate_mul_start */
/* => xMAC OBU rate_mul_start */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_obu_rate_mul_start   0x00000914U
#define Adr_NX500_xmac0_xmac_obu_rate_mul_start 0x00160914U
#define Adr_NX500_xmac1_xmac_obu_rate_mul_start 0x00161914U
#define Adr_NX500_xmac2_xmac_obu_rate_mul_start 0x00162914U
#define Adr_NX500_xmac3_xmac_obu_rate_mul_start 0x00163914U
#define DFLT_VAL_NX500_xmac_obu_rate_mul_start  0x00000000U

#define MSK_NX500_xmac_obu_rate_mul_start_rate_mul_start      0x0000ffffU
#define SRT_NX500_xmac_obu_rate_mul_start_rate_mul_start      0
#define DFLT_VAL_NX500_xmac_obu_rate_mul_start_rate_mul_start 0x00000000U

enum {
	BFW_NX500_xmac_obu_rate_mul_start_rate_mul_start = 16, /* [15:0] */
	BFW_NX500_xmac_obu_rate_mul_start_reserved1      = 16  /* [31:16] */
};

typedef struct NX500_XMAC_OBU_RATE_MUL_START_BIT_Ttag {
	unsigned int rate_mul_start : BFW_NX500_xmac_obu_rate_mul_start_rate_mul_start; /* Value, the Rate Multiplier is set to at sync */
	unsigned int reserved1      : BFW_NX500_xmac_obu_rate_mul_start_reserved1;      /* reserved                                     */
} NX500_XMAC_OBU_RATE_MUL_START_BIT_T;

typedef union {
	unsigned int                        val;
	NX500_XMAC_OBU_RATE_MUL_START_BIT_T bf;
} NX500_XMAC_OBU_RATE_MUL_START_T;

/* --------------------------------------------------------------------- */
/* Register xmac_obu_rate_mul */
/* => xMAC OBU rate_mul */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_obu_rate_mul   0x00000918U
#define Adr_NX500_xmac0_xmac_obu_rate_mul 0x00160918U
#define Adr_NX500_xmac1_xmac_obu_rate_mul 0x00161918U
#define Adr_NX500_xmac2_xmac_obu_rate_mul 0x00162918U
#define Adr_NX500_xmac3_xmac_obu_rate_mul 0x00163918U

#define MSK_NX500_xmac_obu_rate_mul_rate_mul 0x0000ffffU
#define SRT_NX500_xmac_obu_rate_mul_rate_mul 0

enum {
	BFW_NX500_xmac_obu_rate_mul_rate_mul  = 16, /* [15:0] */
	BFW_NX500_xmac_obu_rate_mul_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_OBU_RATE_MUL_BIT_Ttag {
	unsigned int rate_mul  : BFW_NX500_xmac_obu_rate_mul_rate_mul;  /* current value of Rate Multiplier */
	unsigned int reserved1 : BFW_NX500_xmac_obu_rate_mul_reserved1; /* reserved                         */
} NX500_XMAC_OBU_RATE_MUL_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_XMAC_OBU_RATE_MUL_BIT_T bf;
} NX500_XMAC_OBU_RATE_MUL_T;

/* --------------------------------------------------------------------- */
/* Register xmac_start_trans_pos */
/* => xMAC SBU start_trans_pos */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_start_trans_pos   0x0000091CU
#define Adr_NX500_xmac0_xmac_start_trans_pos 0x0016091CU
#define Adr_NX500_xmac1_xmac_start_trans_pos 0x0016191CU
#define Adr_NX500_xmac2_xmac_start_trans_pos 0x0016291CU
#define Adr_NX500_xmac3_xmac_start_trans_pos 0x0016391CU
#define DFLT_VAL_NX500_xmac_start_trans_pos  0x00000000U

#define MSK_NX500_xmac_start_trans_pos_start_trans_pos      0x0000ffffU
#define SRT_NX500_xmac_start_trans_pos_start_trans_pos      0
#define DFLT_VAL_NX500_xmac_start_trans_pos_start_trans_pos 0x00000000U

enum {
	BFW_NX500_xmac_start_trans_pos_start_trans_pos = 16, /* [15:0] */
	BFW_NX500_xmac_start_trans_pos_reserved1       = 16  /* [31:16] */
};

typedef struct NX500_XMAC_START_TRANS_POS_BIT_Ttag {
	unsigned int start_trans_pos : BFW_NX500_xmac_start_trans_pos_start_trans_pos; /* bitstream_out and bitstream_oe change their value at start_trans_pos = rate_mul */
	unsigned int reserved1       : BFW_NX500_xmac_start_trans_pos_reserved1;       /* reserved                                                                        */
} NX500_XMAC_START_TRANS_POS_BIT_T;

typedef union {
	unsigned int                     val;
	NX500_XMAC_START_TRANS_POS_BIT_T bf;
} NX500_XMAC_START_TRANS_POS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_stop_trans_pos */
/* => xMAC SBU stop_trans_pos */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_stop_trans_pos   0x00000920U
#define Adr_NX500_xmac0_xmac_stop_trans_pos 0x00160920U
#define Adr_NX500_xmac1_xmac_stop_trans_pos 0x00161920U
#define Adr_NX500_xmac2_xmac_stop_trans_pos 0x00162920U
#define Adr_NX500_xmac3_xmac_stop_trans_pos 0x00163920U
#define DFLT_VAL_NX500_xmac_stop_trans_pos  0x00000000U

#define MSK_NX500_xmac_stop_trans_pos_stop_trans_pos      0x0000ffffU
#define SRT_NX500_xmac_stop_trans_pos_stop_trans_pos      0
#define DFLT_VAL_NX500_xmac_stop_trans_pos_stop_trans_pos 0x00000000U

enum {
	BFW_NX500_xmac_stop_trans_pos_stop_trans_pos = 16, /* [15:0] */
	BFW_NX500_xmac_stop_trans_pos_reserved1      = 16  /* [31:16] */
};

typedef struct NX500_XMAC_STOP_TRANS_POS_BIT_Ttag {
	unsigned int stop_trans_pos : BFW_NX500_xmac_stop_trans_pos_stop_trans_pos; /* bitstream_oe becomes 0 if rate_mul >= stop_trans_pos */
	unsigned int reserved1      : BFW_NX500_xmac_stop_trans_pos_reserved1;      /* reserved                                             */
} NX500_XMAC_STOP_TRANS_POS_BIT_T;

typedef union {
	unsigned int                    val;
	NX500_XMAC_STOP_TRANS_POS_BIT_T bf;
} NX500_XMAC_STOP_TRANS_POS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpu_count1 */
/* => xMAC RPU Counter 1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rpu_count1   0x00000924U
#define Adr_NX500_xmac0_xmac_rpu_count1 0x00160924U
#define Adr_NX500_xmac1_xmac_rpu_count1 0x00161924U
#define Adr_NX500_xmac2_xmac_rpu_count1 0x00162924U
#define Adr_NX500_xmac3_xmac_rpu_count1 0x00163924U
#define DFLT_VAL_NX500_xmac_rpu_count1  0x00000000U

#define MSK_NX500_xmac_rpu_count1_rpu_count1      0x0000ffffU
#define SRT_NX500_xmac_rpu_count1_rpu_count1      0
#define DFLT_VAL_NX500_xmac_rpu_count1_rpu_count1 0x00000000U

enum {
	BFW_NX500_xmac_rpu_count1_rpu_count1 = 16, /* [15:0] */
	BFW_NX500_xmac_rpu_count1_reserved1  = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RPU_COUNT1_BIT_Ttag {
	unsigned int rpu_count1 : BFW_NX500_xmac_rpu_count1_rpu_count1; /* Counter incremented by rpu-hw_support bit cnt1 */
	unsigned int reserved1  : BFW_NX500_xmac_rpu_count1_reserved1;  /* reserved                                       */
} NX500_XMAC_RPU_COUNT1_BIT_T;

typedef union {
	unsigned int                val;
	NX500_XMAC_RPU_COUNT1_BIT_T bf;
} NX500_XMAC_RPU_COUNT1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpu_count2 */
/* => xMAC RPU Counter 2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rpu_count2   0x00000928U
#define Adr_NX500_xmac0_xmac_rpu_count2 0x00160928U
#define Adr_NX500_xmac1_xmac_rpu_count2 0x00161928U
#define Adr_NX500_xmac2_xmac_rpu_count2 0x00162928U
#define Adr_NX500_xmac3_xmac_rpu_count2 0x00163928U
#define DFLT_VAL_NX500_xmac_rpu_count2  0x00000000U

#define MSK_NX500_xmac_rpu_count2_rpu_count2      0x0000ffffU
#define SRT_NX500_xmac_rpu_count2_rpu_count2      0
#define DFLT_VAL_NX500_xmac_rpu_count2_rpu_count2 0x00000000U

enum {
	BFW_NX500_xmac_rpu_count2_rpu_count2 = 16, /* [15:0] */
	BFW_NX500_xmac_rpu_count2_reserved1  = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RPU_COUNT2_BIT_Ttag {
	unsigned int rpu_count2 : BFW_NX500_xmac_rpu_count2_rpu_count2; /* Counter incremented by rpu-hw_support bit cnt2 */
	unsigned int reserved1  : BFW_NX500_xmac_rpu_count2_reserved1;  /* reserved                                       */
} NX500_XMAC_RPU_COUNT2_BIT_T;

typedef union {
	unsigned int                val;
	NX500_XMAC_RPU_COUNT2_BIT_T bf;
} NX500_XMAC_RPU_COUNT2_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tpu_count1 */
/* => xMAC TPU Counter 1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tpu_count1   0x0000092CU
#define Adr_NX500_xmac0_xmac_tpu_count1 0x0016092CU
#define Adr_NX500_xmac1_xmac_tpu_count1 0x0016192CU
#define Adr_NX500_xmac2_xmac_tpu_count1 0x0016292CU
#define Adr_NX500_xmac3_xmac_tpu_count1 0x0016392CU
#define DFLT_VAL_NX500_xmac_tpu_count1  0x00000000U

#define MSK_NX500_xmac_tpu_count1_tpu_count1      0x0000ffffU
#define SRT_NX500_xmac_tpu_count1_tpu_count1      0
#define DFLT_VAL_NX500_xmac_tpu_count1_tpu_count1 0x00000000U

enum {
	BFW_NX500_xmac_tpu_count1_tpu_count1 = 16, /* [15:0] */
	BFW_NX500_xmac_tpu_count1_reserved1  = 16  /* [31:16] */
};

typedef struct NX500_XMAC_TPU_COUNT1_BIT_Ttag {
	unsigned int tpu_count1 : BFW_NX500_xmac_tpu_count1_tpu_count1; /* Counter incremented by tpu-hw_support bit cnt1 */
	unsigned int reserved1  : BFW_NX500_xmac_tpu_count1_reserved1;  /* reserved                                       */
} NX500_XMAC_TPU_COUNT1_BIT_T;

typedef union {
	unsigned int                val;
	NX500_XMAC_TPU_COUNT1_BIT_T bf;
} NX500_XMAC_TPU_COUNT1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tpu_count2 */
/* => xMAC TPU Counter 2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tpu_count2   0x00000930U
#define Adr_NX500_xmac0_xmac_tpu_count2 0x00160930U
#define Adr_NX500_xmac1_xmac_tpu_count2 0x00161930U
#define Adr_NX500_xmac2_xmac_tpu_count2 0x00162930U
#define Adr_NX500_xmac3_xmac_tpu_count2 0x00163930U
#define DFLT_VAL_NX500_xmac_tpu_count2  0x00000000U

#define MSK_NX500_xmac_tpu_count2_tpu_count2      0x0000ffffU
#define SRT_NX500_xmac_tpu_count2_tpu_count2      0
#define DFLT_VAL_NX500_xmac_tpu_count2_tpu_count2 0x00000000U

enum {
	BFW_NX500_xmac_tpu_count2_tpu_count2 = 16, /* [15:0] */
	BFW_NX500_xmac_tpu_count2_reserved1  = 16  /* [31:16] */
};

typedef struct NX500_XMAC_TPU_COUNT2_BIT_Ttag {
	unsigned int tpu_count2 : BFW_NX500_xmac_tpu_count2_tpu_count2; /* Counter incremented by tpu-hw_support bit cnt2 */
	unsigned int reserved1  : BFW_NX500_xmac_tpu_count2_reserved1;  /* reserved                                       */
} NX500_XMAC_TPU_COUNT2_BIT_T;

typedef union {
	unsigned int                val;
	NX500_XMAC_TPU_COUNT2_BIT_T bf;
} NX500_XMAC_TPU_COUNT2_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_count */
/* => xMAC RX Counter */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rx_count   0x00000934U
#define Adr_NX500_xmac0_xmac_rx_count 0x00160934U
#define Adr_NX500_xmac1_xmac_rx_count 0x00161934U
#define Adr_NX500_xmac2_xmac_rx_count 0x00162934U
#define Adr_NX500_xmac3_xmac_rx_count 0x00163934U
#define DFLT_VAL_NX500_xmac_rx_count  0x00000000U

#define MSK_NX500_xmac_rx_count_rx_count      0x0000ffffU
#define SRT_NX500_xmac_rx_count_rx_count      0
#define DFLT_VAL_NX500_xmac_rx_count_rx_count 0x00000000U

enum {
	BFW_NX500_xmac_rx_count_rx_count  = 16, /* [15:0] */
	BFW_NX500_xmac_rx_count_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RX_COUNT_BIT_Ttag {
	unsigned int rx_count  : BFW_NX500_xmac_rx_count_rx_count;  /* Counter running on eclk */
	unsigned int reserved1 : BFW_NX500_xmac_rx_count_reserved1; /* reserved                */
} NX500_XMAC_RX_COUNT_BIT_T;

typedef union {
	unsigned int              val;
	NX500_XMAC_RX_COUNT_BIT_T bf;
} NX500_XMAC_RX_COUNT_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_count */
/* => xMAC TX Counter */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tx_count   0x00000938U
#define Adr_NX500_xmac0_xmac_tx_count 0x00160938U
#define Adr_NX500_xmac1_xmac_tx_count 0x00161938U
#define Adr_NX500_xmac2_xmac_tx_count 0x00162938U
#define Adr_NX500_xmac3_xmac_tx_count 0x00163938U
#define DFLT_VAL_NX500_xmac_tx_count  0x00000000U

#define MSK_NX500_xmac_tx_count_tx_count      0x0000ffffU
#define SRT_NX500_xmac_tx_count_tx_count      0
#define DFLT_VAL_NX500_xmac_tx_count_tx_count 0x00000000U

enum {
	BFW_NX500_xmac_tx_count_tx_count  = 16, /* [15:0] */
	BFW_NX500_xmac_tx_count_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_TX_COUNT_BIT_Ttag {
	unsigned int tx_count  : BFW_NX500_xmac_tx_count_tx_count;  /* Counter running on eclk */
	unsigned int reserved1 : BFW_NX500_xmac_tx_count_reserved1; /* reserved                */
} NX500_XMAC_TX_COUNT_BIT_T;

typedef union {
	unsigned int              val;
	NX500_XMAC_TX_COUNT_BIT_T bf;
} NX500_XMAC_TX_COUNT_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpm_mask0 */
/* => xMAC Receive Pattern Match Mask 0 Register: */
/*    Defines, which bits are compared between xmac_rpm_val0 and xmac_rx. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rpm_mask0   0x0000093CU
#define Adr_NX500_xmac0_xmac_rpm_mask0 0x0016093CU
#define Adr_NX500_xmac1_xmac_rpm_mask0 0x0016193CU
#define Adr_NX500_xmac2_xmac_rpm_mask0 0x0016293CU
#define Adr_NX500_xmac3_xmac_rpm_mask0 0x0016393CU
#define DFLT_VAL_NX500_xmac_rpm_mask0  0x00000000U

#define MSK_NX500_xmac_rpm_mask0_PM_MASK0      0x0000ffffU
#define SRT_NX500_xmac_rpm_mask0_PM_MASK0      0
#define DFLT_VAL_NX500_xmac_rpm_mask0_PM_MASK0 0x00000000U

enum {
	BFW_NX500_xmac_rpm_mask0_PM_MASK0  = 16, /* [15:0] */
	BFW_NX500_xmac_rpm_mask0_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RPM_MASK0_BIT_Ttag {
	unsigned int PM_MASK0  : BFW_NX500_xmac_rpm_mask0_PM_MASK0;  /* Pattern Match Mask:                                   */
	                                                             /* 1: compare this position of xmac_rpm_val0 and xmac_rx */
	unsigned int reserved1 : BFW_NX500_xmac_rpm_mask0_reserved1; /* reserved                                              */
} NX500_XMAC_RPM_MASK0_BIT_T;

typedef union {
	unsigned int               val;
	NX500_XMAC_RPM_MASK0_BIT_T bf;
} NX500_XMAC_RPM_MASK0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpm_val0 */
/* => xMAC Receive Pattern Match Value 0 Register: */
/*    Defines value of bits to be compared with xmac_rx. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rpm_val0   0x00000940U
#define Adr_NX500_xmac0_xmac_rpm_val0 0x00160940U
#define Adr_NX500_xmac1_xmac_rpm_val0 0x00161940U
#define Adr_NX500_xmac2_xmac_rpm_val0 0x00162940U
#define Adr_NX500_xmac3_xmac_rpm_val0 0x00163940U
#define DFLT_VAL_NX500_xmac_rpm_val0  0x00000000U

#define MSK_NX500_xmac_rpm_val0_PM_VAL0      0x0000ffffU
#define SRT_NX500_xmac_rpm_val0_PM_VAL0      0
#define DFLT_VAL_NX500_xmac_rpm_val0_PM_VAL0 0x00000000U

enum {
	BFW_NX500_xmac_rpm_val0_PM_VAL0   = 16, /* [15:0] */
	BFW_NX500_xmac_rpm_val0_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RPM_VAL0_BIT_Ttag {
	unsigned int PM_VAL0   : BFW_NX500_xmac_rpm_val0_PM_VAL0;   /* Pattern Match Value */
	unsigned int reserved1 : BFW_NX500_xmac_rpm_val0_reserved1; /* reserved            */
} NX500_XMAC_RPM_VAL0_BIT_T;

typedef union {
	unsigned int              val;
	NX500_XMAC_RPM_VAL0_BIT_T bf;
} NX500_XMAC_RPM_VAL0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpm_mask1 */
/* => xMAC Receive Pattern Match Mask 1 Register: */
/*    Defines, which bits are compared between xmac_rpm_val1 and xmac_rx */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rpm_mask1   0x00000944U
#define Adr_NX500_xmac0_xmac_rpm_mask1 0x00160944U
#define Adr_NX500_xmac1_xmac_rpm_mask1 0x00161944U
#define Adr_NX500_xmac2_xmac_rpm_mask1 0x00162944U
#define Adr_NX500_xmac3_xmac_rpm_mask1 0x00163944U
#define DFLT_VAL_NX500_xmac_rpm_mask1  0x00000000U

#define MSK_NX500_xmac_rpm_mask1_PM_MASK1      0x0000ffffU
#define SRT_NX500_xmac_rpm_mask1_PM_MASK1      0
#define DFLT_VAL_NX500_xmac_rpm_mask1_PM_MASK1 0x00000000U

enum {
	BFW_NX500_xmac_rpm_mask1_PM_MASK1  = 16, /* [15:0] */
	BFW_NX500_xmac_rpm_mask1_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RPM_MASK1_BIT_Ttag {
	unsigned int PM_MASK1  : BFW_NX500_xmac_rpm_mask1_PM_MASK1;  /* Pattern Match Mask:                                   */
	                                                             /* 1: compare this position of xmac_rpm_val1 and xmac_rx */
	unsigned int reserved1 : BFW_NX500_xmac_rpm_mask1_reserved1; /* reserved                                              */
} NX500_XMAC_RPM_MASK1_BIT_T;

typedef union {
	unsigned int               val;
	NX500_XMAC_RPM_MASK1_BIT_T bf;
} NX500_XMAC_RPM_MASK1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpm_val1 */
/* => xMAC Receive Pattern Match Value 1 Register: */
/*    Defines value of bits to be compared with xmac_rx. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rpm_val1   0x00000948U
#define Adr_NX500_xmac0_xmac_rpm_val1 0x00160948U
#define Adr_NX500_xmac1_xmac_rpm_val1 0x00161948U
#define Adr_NX500_xmac2_xmac_rpm_val1 0x00162948U
#define Adr_NX500_xmac3_xmac_rpm_val1 0x00163948U
#define DFLT_VAL_NX500_xmac_rpm_val1  0x00000000U

#define MSK_NX500_xmac_rpm_val1_PM_VAL1      0x0000ffffU
#define SRT_NX500_xmac_rpm_val1_PM_VAL1      0
#define DFLT_VAL_NX500_xmac_rpm_val1_PM_VAL1 0x00000000U

enum {
	BFW_NX500_xmac_rpm_val1_PM_VAL1   = 16, /* [15:0] */
	BFW_NX500_xmac_rpm_val1_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RPM_VAL1_BIT_Ttag {
	unsigned int PM_VAL1   : BFW_NX500_xmac_rpm_val1_PM_VAL1;   /* Pattern Match Value */
	unsigned int reserved1 : BFW_NX500_xmac_rpm_val1_reserved1; /* reserved            */
} NX500_XMAC_RPM_VAL1_BIT_T;

typedef union {
	unsigned int              val;
	NX500_XMAC_RPM_VAL1_BIT_T bf;
} NX500_XMAC_RPM_VAL1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tpm_mask0 */
/* => xMAC Transmit Pattern Match Mask 0 Register: */
/*    Defines, which bits are compared between xmac_tpm_val0 and xmac_tx_sent. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tpm_mask0   0x0000094CU
#define Adr_NX500_xmac0_xmac_tpm_mask0 0x0016094CU
#define Adr_NX500_xmac1_xmac_tpm_mask0 0x0016194CU
#define Adr_NX500_xmac2_xmac_tpm_mask0 0x0016294CU
#define Adr_NX500_xmac3_xmac_tpm_mask0 0x0016394CU
#define DFLT_VAL_NX500_xmac_tpm_mask0  0x00000000U

#define MSK_NX500_xmac_tpm_mask0_PM_MASK0      0x0000ffffU
#define SRT_NX500_xmac_tpm_mask0_PM_MASK0      0
#define DFLT_VAL_NX500_xmac_tpm_mask0_PM_MASK0 0x00000000U

enum {
	BFW_NX500_xmac_tpm_mask0_PM_MASK0  = 16, /* [15:0] */
	BFW_NX500_xmac_tpm_mask0_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_TPM_MASK0_BIT_Ttag {
	unsigned int PM_MASK0  : BFW_NX500_xmac_tpm_mask0_PM_MASK0;  /* Pattern Match Mask:                                        */
	                                                             /* 1: compare this position of xmac_tpm_val0 and xmac_tx_sent */
	unsigned int reserved1 : BFW_NX500_xmac_tpm_mask0_reserved1; /* reserved                                                   */
} NX500_XMAC_TPM_MASK0_BIT_T;

typedef union {
	unsigned int               val;
	NX500_XMAC_TPM_MASK0_BIT_T bf;
} NX500_XMAC_TPM_MASK0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tpm_val0 */
/* => xMAC Transmit Pattern Match Value 0 Register: */
/*    Defines value of bits to be compared with xmac_tx_sent. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tpm_val0   0x00000950U
#define Adr_NX500_xmac0_xmac_tpm_val0 0x00160950U
#define Adr_NX500_xmac1_xmac_tpm_val0 0x00161950U
#define Adr_NX500_xmac2_xmac_tpm_val0 0x00162950U
#define Adr_NX500_xmac3_xmac_tpm_val0 0x00163950U
#define DFLT_VAL_NX500_xmac_tpm_val0  0x00000000U

#define MSK_NX500_xmac_tpm_val0_PM_VAL0      0x0000ffffU
#define SRT_NX500_xmac_tpm_val0_PM_VAL0      0
#define DFLT_VAL_NX500_xmac_tpm_val0_PM_VAL0 0x00000000U

enum {
	BFW_NX500_xmac_tpm_val0_PM_VAL0   = 16, /* [15:0] */
	BFW_NX500_xmac_tpm_val0_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_TPM_VAL0_BIT_Ttag {
	unsigned int PM_VAL0   : BFW_NX500_xmac_tpm_val0_PM_VAL0;   /* Pattern Match Value */
	unsigned int reserved1 : BFW_NX500_xmac_tpm_val0_reserved1; /* reserved            */
} NX500_XMAC_TPM_VAL0_BIT_T;

typedef union {
	unsigned int              val;
	NX500_XMAC_TPM_VAL0_BIT_T bf;
} NX500_XMAC_TPM_VAL0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tpm_mask1 */
/* => xMAC Transmit Pattern Match Mask 1 Register: */
/*    Defines, which bits are compared between xmac_tpm_val1 and xmac_tx_sent. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tpm_mask1   0x00000954U
#define Adr_NX500_xmac0_xmac_tpm_mask1 0x00160954U
#define Adr_NX500_xmac1_xmac_tpm_mask1 0x00161954U
#define Adr_NX500_xmac2_xmac_tpm_mask1 0x00162954U
#define Adr_NX500_xmac3_xmac_tpm_mask1 0x00163954U
#define DFLT_VAL_NX500_xmac_tpm_mask1  0x00000000U

#define MSK_NX500_xmac_tpm_mask1_PM_MASK1      0x0000ffffU
#define SRT_NX500_xmac_tpm_mask1_PM_MASK1      0
#define DFLT_VAL_NX500_xmac_tpm_mask1_PM_MASK1 0x00000000U

enum {
	BFW_NX500_xmac_tpm_mask1_PM_MASK1  = 16, /* [15:0] */
	BFW_NX500_xmac_tpm_mask1_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_TPM_MASK1_BIT_Ttag {
	unsigned int PM_MASK1  : BFW_NX500_xmac_tpm_mask1_PM_MASK1;  /* Pattern Match Mask:                                        */
	                                                             /* 1: compare this position of xmac_tpm_val1 and xmac_tx_sent */
	unsigned int reserved1 : BFW_NX500_xmac_tpm_mask1_reserved1; /* reserved                                                   */
} NX500_XMAC_TPM_MASK1_BIT_T;

typedef union {
	unsigned int               val;
	NX500_XMAC_TPM_MASK1_BIT_T bf;
} NX500_XMAC_TPM_MASK1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tpm_val1 */
/* => xMAC Transmit Pattern Match Value 1 Register: */
/*    Defines value of bits to be compared with xmac_tx_sent. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tpm_val1   0x00000958U
#define Adr_NX500_xmac0_xmac_tpm_val1 0x00160958U
#define Adr_NX500_xmac1_xmac_tpm_val1 0x00161958U
#define Adr_NX500_xmac2_xmac_tpm_val1 0x00162958U
#define Adr_NX500_xmac3_xmac_tpm_val1 0x00163958U
#define DFLT_VAL_NX500_xmac_tpm_val1  0x00000000U

#define MSK_NX500_xmac_tpm_val1_PM_VAL1      0x0000ffffU
#define SRT_NX500_xmac_tpm_val1_PM_VAL1      0
#define DFLT_VAL_NX500_xmac_tpm_val1_PM_VAL1 0x00000000U

enum {
	BFW_NX500_xmac_tpm_val1_PM_VAL1   = 16, /* [15:0] */
	BFW_NX500_xmac_tpm_val1_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_TPM_VAL1_BIT_Ttag {
	unsigned int PM_VAL1   : BFW_NX500_xmac_tpm_val1_PM_VAL1;   /* Pattern Match Value */
	unsigned int reserved1 : BFW_NX500_xmac_tpm_val1_reserved1; /* reserved            */
} NX500_XMAC_TPM_VAL1_BIT_T;

typedef union {
	unsigned int              val;
	NX500_XMAC_TPM_VAL1_BIT_T bf;
} NX500_XMAC_TPM_VAL1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pwm_config */
/* => PWM config register: */
/*    Allows to set and reset outputs manually or via counters (see pwm.doc for details). */
/*    This register is only available at xMAC2 and xMAC3, as there are only two PWM-units in netX100/500. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pwm_config   0x0000095CU
#define Adr_NX500_xmac0_xmac_pwm_config 0x0016095CU
#define Adr_NX500_xmac1_xmac_pwm_config 0x0016195CU
#define Adr_NX500_xmac2_xmac_pwm_config 0x0016295CU
#define Adr_NX500_xmac3_xmac_pwm_config 0x0016395CU
#define DFLT_VAL_NX500_xmac_pwm_config  0x00000000U

#define MSK_NX500_xmac_pwm_config_val_u          0x00000001U
#define SRT_NX500_xmac_pwm_config_val_u          0
#define DFLT_VAL_NX500_xmac_pwm_config_val_u     0x00000000U
#define MSK_NX500_xmac_pwm_config_val_un         0x00000002U
#define SRT_NX500_xmac_pwm_config_val_un         1
#define DFLT_VAL_NX500_xmac_pwm_config_val_un    0x00000000U
#define MSK_NX500_xmac_pwm_config_val_v          0x00000004U
#define SRT_NX500_xmac_pwm_config_val_v          2
#define DFLT_VAL_NX500_xmac_pwm_config_val_v     0x00000000U
#define MSK_NX500_xmac_pwm_config_val_vn         0x00000008U
#define SRT_NX500_xmac_pwm_config_val_vn         3
#define DFLT_VAL_NX500_xmac_pwm_config_val_vn    0x00000000U
#define MSK_NX500_xmac_pwm_config_val_w          0x00000010U
#define SRT_NX500_xmac_pwm_config_val_w          4
#define DFLT_VAL_NX500_xmac_pwm_config_val_w     0x00000000U
#define MSK_NX500_xmac_pwm_config_val_wn         0x00000020U
#define SRT_NX500_xmac_pwm_config_val_wn         5
#define DFLT_VAL_NX500_xmac_pwm_config_val_wn    0x00000000U
#define MSK_NX500_xmac_pwm_config_fo_mode        0x00000040U
#define SRT_NX500_xmac_pwm_config_fo_mode        6
#define DFLT_VAL_NX500_xmac_pwm_config_fo_mode   0x00000000U
#define MSK_NX500_xmac_pwm_config_mpwm_mode      0x00000080U
#define SRT_NX500_xmac_pwm_config_mpwm_mode      7
#define DFLT_VAL_NX500_xmac_pwm_config_mpwm_mode 0x00000000U
#define MSK_NX500_xmac_pwm_config_auto_u         0x00000100U
#define SRT_NX500_xmac_pwm_config_auto_u         8
#define DFLT_VAL_NX500_xmac_pwm_config_auto_u    0x00000000U
#define MSK_NX500_xmac_pwm_config_auto_v         0x00000200U
#define SRT_NX500_xmac_pwm_config_auto_v         9
#define DFLT_VAL_NX500_xmac_pwm_config_auto_v    0x00000000U
#define MSK_NX500_xmac_pwm_config_auto_w         0x00000400U
#define SRT_NX500_xmac_pwm_config_auto_w         10
#define DFLT_VAL_NX500_xmac_pwm_config_auto_w    0x00000000U
#define MSK_NX500_xmac_pwm_config_run_mp         0x00004000U
#define SRT_NX500_xmac_pwm_config_run_mp         14
#define DFLT_VAL_NX500_xmac_pwm_config_run_mp    0x00000000U
#define MSK_NX500_xmac_pwm_config_run_rp         0x00008000U
#define SRT_NX500_xmac_pwm_config_run_rp         15
#define DFLT_VAL_NX500_xmac_pwm_config_run_rp    0x00000000U

enum {
	BFW_NX500_xmac_pwm_config_val_u     = 1,  /* [0] */
	BFW_NX500_xmac_pwm_config_val_un    = 1,  /* [1] */
	BFW_NX500_xmac_pwm_config_val_v     = 1,  /* [2] */
	BFW_NX500_xmac_pwm_config_val_vn    = 1,  /* [3] */
	BFW_NX500_xmac_pwm_config_val_w     = 1,  /* [4] */
	BFW_NX500_xmac_pwm_config_val_wn    = 1,  /* [5] */
	BFW_NX500_xmac_pwm_config_fo_mode   = 1,  /* [6] */
	BFW_NX500_xmac_pwm_config_mpwm_mode = 1,  /* [7] */
	BFW_NX500_xmac_pwm_config_auto_u    = 1,  /* [8] */
	BFW_NX500_xmac_pwm_config_auto_v    = 1,  /* [9] */
	BFW_NX500_xmac_pwm_config_auto_w    = 1,  /* [10] */
	BFW_NX500_xmac_pwm_config_reserved1 = 3,  /* [13:11] */
	BFW_NX500_xmac_pwm_config_run_mp    = 1,  /* [14] */
	BFW_NX500_xmac_pwm_config_run_rp    = 1,  /* [15] */
	BFW_NX500_xmac_pwm_config_reserved2 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_PWM_CONFIG_BIT_Ttag {
	unsigned int val_u     : BFW_NX500_xmac_pwm_config_val_u;     /* value of pin U  = gpo_pins[0] if auto_u  = 0                                    */
	unsigned int val_un    : BFW_NX500_xmac_pwm_config_val_un;    /* value of pin Un = gpo_pins[1] if auto_un = 0                                    */
	unsigned int val_v     : BFW_NX500_xmac_pwm_config_val_v;     /* value of pin V  = gpo_pins[2] if auto_v  = 0                                    */
	unsigned int val_vn    : BFW_NX500_xmac_pwm_config_val_vn;    /* value of pin Vn = gpo_pins[3] if auto_vn = 0                                    */
	unsigned int val_w     : BFW_NX500_xmac_pwm_config_val_w;     /* value of pin W  = gpo_pins[4] if auto_w  = 0                                    */
	unsigned int val_wn    : BFW_NX500_xmac_pwm_config_val_wn;    /* value of pin Wn = gpo_pins[5] if auto_wn = 0                                    */
	unsigned int fo_mode   : BFW_NX500_xmac_pwm_config_fo_mode;   /* Fiber Optic Mode:                                                               */
	                                                              /* sets gpo_pins[5:0] = xmac_pwm_config[5:0] in case that tx_data[0] = 1           */
	unsigned int mpwm_mode : BFW_NX500_xmac_pwm_config_mpwm_mode; /* Motor PWM Mode                                                                  */
	                                                              /* Motor PWM Mode has higher Priority than Fiber Optic Mode                        */
	unsigned int auto_u    : BFW_NX500_xmac_pwm_config_auto_u;    /* 0: set gpo_pins[1:0] to val_u/n;  1: set gpo_pins[1:0] to output of channel U/n */
	unsigned int auto_v    : BFW_NX500_xmac_pwm_config_auto_v;    /* 0: set gpo_pins[3:2] to val_v/n;  1: set gpo_pins[3:2] to output of channel V/n */
	unsigned int auto_w    : BFW_NX500_xmac_pwm_config_auto_w;    /* 0: set gpo_pins[5/4] to val_w/n;  1: set gpo_pins[5:4] to output of channel W/n */
	unsigned int reserved1 : BFW_NX500_xmac_pwm_config_reserved1; /* reserved                                                                        */
	unsigned int run_mp    : BFW_NX500_xmac_pwm_config_run_mp;    /* 0: stop Motor PWM after the actual cycle;  1: run Motor PWM                     */
	unsigned int run_rp    : BFW_NX500_xmac_pwm_config_run_rp;    /* 0: reset/stop Resolver PWM immediately;  1: run Resolver PWM                    */
	unsigned int reserved2 : BFW_NX500_xmac_pwm_config_reserved2; /* reserved                                                                        */
} NX500_XMAC_PWM_CONFIG_BIT_T;

typedef union {
	unsigned int                val;
	NX500_XMAC_PWM_CONFIG_BIT_T bf;
} NX500_XMAC_PWM_CONFIG_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pwm_status */
/* => Status of PWMs: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC2 and xMAC3, as there are only two PWM-units in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pwm_status   0x00000960U
#define Adr_NX500_xmac0_xmac_pwm_status 0x00160960U
#define Adr_NX500_xmac1_xmac_pwm_status 0x00161960U
#define Adr_NX500_xmac2_xmac_pwm_status 0x00162960U
#define Adr_NX500_xmac3_xmac_pwm_status 0x00163960U
#define DFLT_VAL_NX500_xmac_pwm_status  0x00000000U

#define MSK_NX500_xmac_pwm_status_systc            0x00000001U
#define SRT_NX500_xmac_pwm_status_systc            0
#define DFLT_VAL_NX500_xmac_pwm_status_systc       0x00000000U
#define MSK_NX500_xmac_pwm_status_pwmerr           0x00000040U
#define SRT_NX500_xmac_pwm_status_pwmerr           6
#define DFLT_VAL_NX500_xmac_pwm_status_pwmerr      0x00000000U
#define MSK_NX500_xmac_pwm_status_pwmerr_req       0x00000080U
#define SRT_NX500_xmac_pwm_status_pwmerr_req       7
#define DFLT_VAL_NX500_xmac_pwm_status_pwmerr_req  0x00000000U
#define MSK_NX500_xmac_pwm_status_systime_reg      0x00000100U
#define SRT_NX500_xmac_pwm_status_systime_reg      8
#define DFLT_VAL_NX500_xmac_pwm_status_systime_reg 0x00000000U

enum {
	BFW_NX500_xmac_pwm_status_systc       = 1,  /* [0] */
	BFW_NX500_xmac_pwm_status_reserved1   = 5,  /* [5:1] */
	BFW_NX500_xmac_pwm_status_pwmerr      = 1,  /* [6] */
	BFW_NX500_xmac_pwm_status_pwmerr_req  = 1,  /* [7] */
	BFW_NX500_xmac_pwm_status_systime_reg = 1,  /* [8] */
	BFW_NX500_xmac_pwm_status_reserved2   = 23  /* [31:9] */
};

typedef struct NX500_XMAC_PWM_STATUS_BIT_Ttag {
	unsigned int systc       : BFW_NX500_xmac_pwm_status_systc;       /* Systime captured at PWM = 0  */
	unsigned int reserved1   : BFW_NX500_xmac_pwm_status_reserved1;   /* reserved                     */
	unsigned int pwmerr      : BFW_NX500_xmac_pwm_status_pwmerr;      /* Actual PWM failure signal    */
	unsigned int pwmerr_req  : BFW_NX500_xmac_pwm_status_pwmerr_req;  /* Latched PWM failure signal   */
	unsigned int systime_reg : BFW_NX500_xmac_pwm_status_systime_reg; /* Systime captured at RPWM = 0 */
	unsigned int reserved2   : BFW_NX500_xmac_pwm_status_reserved2;   /* reserved                     */
} NX500_XMAC_PWM_STATUS_BIT_T;

typedef union {
	unsigned int                val;
	NX500_XMAC_PWM_STATUS_BIT_T bf;
} NX500_XMAC_PWM_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pwm_tp */
/* => PWM period: */
/*    See pwm.doc for details. */
/*    This register is only available at xMAC2 and xMAC3, as there are only two PWM-units in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pwm_tp   0x00000964U
#define Adr_NX500_xmac0_xmac_pwm_tp 0x00160964U
#define Adr_NX500_xmac1_xmac_pwm_tp 0x00161964U
#define Adr_NX500_xmac2_xmac_pwm_tp 0x00162964U
#define Adr_NX500_xmac3_xmac_pwm_tp 0x00163964U
#define DFLT_VAL_NX500_xmac_pwm_tp  0x00000000U

#define MSK_NX500_xmac_pwm_tp_tp      0x0000ffffU
#define SRT_NX500_xmac_pwm_tp_tp      0
#define DFLT_VAL_NX500_xmac_pwm_tp_tp 0x00000000U

enum {
	BFW_NX500_xmac_pwm_tp_tp        = 16, /* [15:0] */
	BFW_NX500_xmac_pwm_tp_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_PWM_TP_BIT_Ttag {
	unsigned int tp        : BFW_NX500_xmac_pwm_tp_tp;        /* Length of PWM period (bit 0 unused due to triangular counting) in clockcycles */
	unsigned int reserved1 : BFW_NX500_xmac_pwm_tp_reserved1; /* reserved                                                                      */
} NX500_XMAC_PWM_TP_BIT_T;

typedef union {
	unsigned int            val;
	NX500_XMAC_PWM_TP_BIT_T bf;
} NX500_XMAC_PWM_TP_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pwm_tu */
/* => PWM channel U low phase width: */
/*    See pwm.doc for details. */
/*    This register is only available at xMAC2 and xMAC3, as there are only two PWM-units in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pwm_tu   0x00000968U
#define Adr_NX500_xmac0_xmac_pwm_tu 0x00160968U
#define Adr_NX500_xmac1_xmac_pwm_tu 0x00161968U
#define Adr_NX500_xmac2_xmac_pwm_tu 0x00162968U
#define Adr_NX500_xmac3_xmac_pwm_tu 0x00163968U
#define DFLT_VAL_NX500_xmac_pwm_tu  0x00000000U

#define MSK_NX500_xmac_pwm_tu_level_u      0x0000ffffU
#define SRT_NX500_xmac_pwm_tu_level_u      0
#define DFLT_VAL_NX500_xmac_pwm_tu_level_u 0x00000000U

enum {
	BFW_NX500_xmac_pwm_tu_level_u   = 16, /* [15:0] */
	BFW_NX500_xmac_pwm_tu_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_PWM_TU_BIT_Ttag {
	unsigned int level_u   : BFW_NX500_xmac_pwm_tu_level_u;   /* width of cannel U low phase in clockcycles */
	unsigned int reserved1 : BFW_NX500_xmac_pwm_tu_reserved1; /* reserved                                   */
} NX500_XMAC_PWM_TU_BIT_T;

typedef union {
	unsigned int            val;
	NX500_XMAC_PWM_TU_BIT_T bf;
} NX500_XMAC_PWM_TU_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pwm_tv */
/* => PWM channel V low phase width: */
/*    See pwm.doc for details. */
/*    This register is only available at xMAC2 and xMAC3, as there are only two PWM-units in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pwm_tv   0x0000096CU
#define Adr_NX500_xmac0_xmac_pwm_tv 0x0016096CU
#define Adr_NX500_xmac1_xmac_pwm_tv 0x0016196CU
#define Adr_NX500_xmac2_xmac_pwm_tv 0x0016296CU
#define Adr_NX500_xmac3_xmac_pwm_tv 0x0016396CU
#define DFLT_VAL_NX500_xmac_pwm_tv  0x00000000U

#define MSK_NX500_xmac_pwm_tv_level_u      0x0000ffffU
#define SRT_NX500_xmac_pwm_tv_level_u      0
#define DFLT_VAL_NX500_xmac_pwm_tv_level_u 0x00000000U

enum {
	BFW_NX500_xmac_pwm_tv_level_u   = 16, /* [15:0] */
	BFW_NX500_xmac_pwm_tv_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_PWM_TV_BIT_Ttag {
	unsigned int level_u   : BFW_NX500_xmac_pwm_tv_level_u;   /* width of cannel U low phase in clockcycles */
	unsigned int reserved1 : BFW_NX500_xmac_pwm_tv_reserved1; /* reserved                                   */
} NX500_XMAC_PWM_TV_BIT_T;

typedef union {
	unsigned int            val;
	NX500_XMAC_PWM_TV_BIT_T bf;
} NX500_XMAC_PWM_TV_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pwm_tw */
/* => PWM channel W low phase width: */
/*    See pwm.doc for details. */
/*    This register is only available at xMAC2 and xMAC3, as there are only two PWM-units in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pwm_tw   0x00000970U
#define Adr_NX500_xmac0_xmac_pwm_tw 0x00160970U
#define Adr_NX500_xmac1_xmac_pwm_tw 0x00161970U
#define Adr_NX500_xmac2_xmac_pwm_tw 0x00162970U
#define Adr_NX500_xmac3_xmac_pwm_tw 0x00163970U
#define DFLT_VAL_NX500_xmac_pwm_tw  0x00000000U

#define MSK_NX500_xmac_pwm_tw_level_u      0x0000ffffU
#define SRT_NX500_xmac_pwm_tw_level_u      0
#define DFLT_VAL_NX500_xmac_pwm_tw_level_u 0x00000000U

enum {
	BFW_NX500_xmac_pwm_tw_level_u   = 16, /* [15:0] */
	BFW_NX500_xmac_pwm_tw_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_PWM_TW_BIT_Ttag {
	unsigned int level_u   : BFW_NX500_xmac_pwm_tw_level_u;   /* width of cannel U low phase in clockcycles */
	unsigned int reserved1 : BFW_NX500_xmac_pwm_tw_reserved1; /* reserved                                   */
} NX500_XMAC_PWM_TW_BIT_T;

typedef union {
	unsigned int            val;
	NX500_XMAC_PWM_TW_BIT_T bf;
} NX500_XMAC_PWM_TW_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pwm_td */
/* => PWM dead time counter preload: */
/*    See pwm.doc for details. */
/*    This register is only available at xMAC2 and xMAC3, as there are only two PWM-units in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pwm_td   0x00000974U
#define Adr_NX500_xmac0_xmac_pwm_td 0x00160974U
#define Adr_NX500_xmac1_xmac_pwm_td 0x00161974U
#define Adr_NX500_xmac2_xmac_pwm_td 0x00162974U
#define Adr_NX500_xmac3_xmac_pwm_td 0x00163974U
#define DFLT_VAL_NX500_xmac_pwm_td  0x00000000U

#define MSK_NX500_xmac_pwm_td_preload_d      0x0000ffffU
#define SRT_NX500_xmac_pwm_td_preload_d      0
#define DFLT_VAL_NX500_xmac_pwm_td_preload_d 0x00000000U

enum {
	BFW_NX500_xmac_pwm_td_preload_d = 16, /* [15:0] */
	BFW_NX500_xmac_pwm_td_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_PWM_TD_BIT_Ttag {
	unsigned int preload_d : BFW_NX500_xmac_pwm_td_preload_d; /* counter preload for dead time in clockcycles */
	unsigned int reserved1 : BFW_NX500_xmac_pwm_td_reserved1; /* reserved                                     */
} NX500_XMAC_PWM_TD_BIT_T;

typedef union {
	unsigned int            val;
	NX500_XMAC_PWM_TD_BIT_T bf;
} NX500_XMAC_PWM_TD_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpwm_tp */
/* => Resolver PWM period: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC2 and xMAC3, as there are only two PWM-units in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rpwm_tp   0x00000978U
#define Adr_NX500_xmac0_xmac_rpwm_tp 0x00160978U
#define Adr_NX500_xmac1_xmac_rpwm_tp 0x00161978U
#define Adr_NX500_xmac2_xmac_rpwm_tp 0x00162978U
#define Adr_NX500_xmac3_xmac_rpwm_tp 0x00163978U
#define DFLT_VAL_NX500_xmac_rpwm_tp  0x00000000U

#define MSK_NX500_xmac_rpwm_tp_res_tp      0x0000ffffU
#define SRT_NX500_xmac_rpwm_tp_res_tp      0
#define DFLT_VAL_NX500_xmac_rpwm_tp_res_tp 0x00000000U

enum {
	BFW_NX500_xmac_rpwm_tp_res_tp    = 16, /* [15:0] */
	BFW_NX500_xmac_rpwm_tp_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RPWM_TP_BIT_Ttag {
	unsigned int res_tp    : BFW_NX500_xmac_rpwm_tp_res_tp;    /* Resolver PWM period */
	unsigned int reserved1 : BFW_NX500_xmac_rpwm_tp_reserved1; /* reserved            */
} NX500_XMAC_RPWM_TP_BIT_T;

typedef union {
	unsigned int             val;
	NX500_XMAC_RPWM_TP_BIT_T bf;
} NX500_XMAC_RPWM_TP_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpwm_tr */
/* => Resolver PWM Pulse: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC2 and xMAC3, as there are only two PWM-units in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rpwm_tr   0x0000097CU
#define Adr_NX500_xmac0_xmac_rpwm_tr 0x0016097CU
#define Adr_NX500_xmac1_xmac_rpwm_tr 0x0016197CU
#define Adr_NX500_xmac2_xmac_rpwm_tr 0x0016297CU
#define Adr_NX500_xmac3_xmac_rpwm_tr 0x0016397CU
#define DFLT_VAL_NX500_xmac_rpwm_tr  0x00000000U

#define MSK_NX500_xmac_rpwm_tr_res_tr      0x0000ffffU
#define SRT_NX500_xmac_rpwm_tr_res_tr      0
#define DFLT_VAL_NX500_xmac_rpwm_tr_res_tr 0x00000000U

enum {
	BFW_NX500_xmac_rpwm_tr_res_tr    = 16, /* [15:0] */
	BFW_NX500_xmac_rpwm_tr_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RPWM_TR_BIT_Ttag {
	unsigned int res_tr    : BFW_NX500_xmac_rpwm_tr_res_tr;    /* Resolver PWM Pulse */
	unsigned int reserved1 : BFW_NX500_xmac_rpwm_tr_reserved1; /* reserved           */
} NX500_XMAC_RPWM_TR_BIT_T;

typedef union {
	unsigned int             val;
	NX500_XMAC_RPWM_TR_BIT_T bf;
} NX500_XMAC_RPWM_TR_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pwm_cnt */
/* => Actual counter Motor PWM period: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC2 and xMAC3, as there are only two PWM-units in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pwm_cnt   0x00000980U
#define Adr_NX500_xmac0_xmac_pwm_cnt 0x00160980U
#define Adr_NX500_xmac1_xmac_pwm_cnt 0x00161980U
#define Adr_NX500_xmac2_xmac_pwm_cnt 0x00162980U
#define Adr_NX500_xmac3_xmac_pwm_cnt 0x00163980U

#define MSK_NX500_xmac_pwm_cnt_pwm_cnt 0x0000ffffU
#define SRT_NX500_xmac_pwm_cnt_pwm_cnt 0

enum {
	BFW_NX500_xmac_pwm_cnt_pwm_cnt   = 16, /* [15:0] */
	BFW_NX500_xmac_pwm_cnt_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_PWM_CNT_BIT_Ttag {
	unsigned int pwm_cnt   : BFW_NX500_xmac_pwm_cnt_pwm_cnt;   /* Actual counter Motor PWM period */
	unsigned int reserved1 : BFW_NX500_xmac_pwm_cnt_reserved1; /* reserved                        */
} NX500_XMAC_PWM_CNT_BIT_T;

typedef union {
	unsigned int             val;
	NX500_XMAC_PWM_CNT_BIT_T bf;
} NX500_XMAC_PWM_CNT_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpwm_cnt */
/* => Actual counter Resolver PWM period: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC2 and xMAC3, as there are only two PWM-units in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rpwm_cnt   0x00000984U
#define Adr_NX500_xmac0_xmac_rpwm_cnt 0x00160984U
#define Adr_NX500_xmac1_xmac_rpwm_cnt 0x00161984U
#define Adr_NX500_xmac2_xmac_rpwm_cnt 0x00162984U
#define Adr_NX500_xmac3_xmac_rpwm_cnt 0x00163984U

#define MSK_NX500_xmac_rpwm_cnt_rpwm_cnt 0x0000ffffU
#define SRT_NX500_xmac_rpwm_cnt_rpwm_cnt 0

enum {
	BFW_NX500_xmac_rpwm_cnt_rpwm_cnt  = 16, /* [15:0] */
	BFW_NX500_xmac_rpwm_cnt_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RPWM_CNT_BIT_Ttag {
	unsigned int rpwm_cnt  : BFW_NX500_xmac_rpwm_cnt_rpwm_cnt;  /* Actual counter Resolver PWM period */
	unsigned int reserved1 : BFW_NX500_xmac_rpwm_cnt_reserved1; /* reserved                           */
} NX500_XMAC_RPWM_CNT_BIT_T;

typedef union {
	unsigned int              val;
	NX500_XMAC_RPWM_CNT_BIT_T bf;
} NX500_XMAC_RPWM_CNT_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pwm_strtime */
/* => Captured Systime at start point of Motor PWM period: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC2 and xMAC3, as there are only two PWM-units in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pwm_strtime   0x00000988U
#define Adr_NX500_xmac0_xmac_pwm_strtime 0x00160988U
#define Adr_NX500_xmac1_xmac_pwm_strtime 0x00161988U
#define Adr_NX500_xmac2_xmac_pwm_strtime 0x00162988U
#define Adr_NX500_xmac3_xmac_pwm_strtime 0x00163988U

#define MSK_NX500_xmac_pwm_strtime_pwm_strtime 0x0000ffffU
#define SRT_NX500_xmac_pwm_strtime_pwm_strtime 0

enum {
	BFW_NX500_xmac_pwm_strtime_pwm_strtime = 16, /* [15:0] */
	BFW_NX500_xmac_pwm_strtime_reserved1   = 16  /* [31:16] */
};

typedef struct NX500_XMAC_PWM_STRTIME_BIT_Ttag {
	unsigned int pwm_strtime : BFW_NX500_xmac_pwm_strtime_pwm_strtime; /* Captured Systime at start point of Motor PWM period */
	unsigned int reserved1   : BFW_NX500_xmac_pwm_strtime_reserved1;   /* reserved                                            */
} NX500_XMAC_PWM_STRTIME_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_XMAC_PWM_STRTIME_BIT_T bf;
} NX500_XMAC_PWM_STRTIME_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpwm_strtime */
/* => Captured Systime at start point of Resolver PWM period: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC2 and xMAC3, as there are only two PWM-units in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rpwm_strtime   0x0000098CU
#define Adr_NX500_xmac0_xmac_rpwm_strtime 0x0016098CU
#define Adr_NX500_xmac1_xmac_rpwm_strtime 0x0016198CU
#define Adr_NX500_xmac2_xmac_rpwm_strtime 0x0016298CU
#define Adr_NX500_xmac3_xmac_rpwm_strtime 0x0016398CU

#define MSK_NX500_xmac_rpwm_strtime_rpwm_strtime 0x0000ffffU
#define SRT_NX500_xmac_rpwm_strtime_rpwm_strtime 0

enum {
	BFW_NX500_xmac_rpwm_strtime_rpwm_strtime = 16, /* [15:0] */
	BFW_NX500_xmac_rpwm_strtime_reserved1    = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RPWM_STRTIME_BIT_Ttag {
	unsigned int rpwm_strtime : BFW_NX500_xmac_rpwm_strtime_rpwm_strtime; /* Captured Systime at start point of Resolver PWM period */
	unsigned int reserved1    : BFW_NX500_xmac_rpwm_strtime_reserved1;    /* reserved                                               */
} NX500_XMAC_RPWM_STRTIME_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_XMAC_RPWM_STRTIME_BIT_T bf;
} NX500_XMAC_RPWM_STRTIME_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pos_config_encoder */
/* => Configuration encoder register: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC3, as there is only one POS-unit in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pos_config_encoder   0x00000990U
#define Adr_NX500_xmac0_xmac_pos_config_encoder 0x00160990U
#define Adr_NX500_xmac1_xmac_pos_config_encoder 0x00161990U
#define Adr_NX500_xmac2_xmac_pos_config_encoder 0x00162990U
#define Adr_NX500_xmac3_xmac_pos_config_encoder 0x00163990U
#define DFLT_VAL_NX500_xmac_pos_config_encoder  0x00000000U

#define MSK_NX500_xmac_pos_config_encoder_enc0_filter_sample_rate      0x00000007U
#define SRT_NX500_xmac_pos_config_encoder_enc0_filter_sample_rate      0
#define DFLT_VAL_NX500_xmac_pos_config_encoder_enc0_filter_sample_rate 0x00000000U
#define MSK_NX500_xmac_pos_config_encoder_enc0_count_dir               0x00000008U
#define SRT_NX500_xmac_pos_config_encoder_enc0_count_dir               3
#define DFLT_VAL_NX500_xmac_pos_config_encoder_enc0_count_dir          0x00000000U
#define MSK_NX500_xmac_pos_config_encoder_enc0_n_quant                 0x00000030U
#define SRT_NX500_xmac_pos_config_encoder_enc0_n_quant                 4
#define DFLT_VAL_NX500_xmac_pos_config_encoder_enc0_n_quant            0x00000000U
#define MSK_NX500_xmac_pos_config_encoder_enc1_filter_sample_rate      0x00000700U
#define SRT_NX500_xmac_pos_config_encoder_enc1_filter_sample_rate      8
#define DFLT_VAL_NX500_xmac_pos_config_encoder_enc1_filter_sample_rate 0x00000000U
#define MSK_NX500_xmac_pos_config_encoder_enc1_count_dir               0x00000800U
#define SRT_NX500_xmac_pos_config_encoder_enc1_count_dir               11
#define DFLT_VAL_NX500_xmac_pos_config_encoder_enc1_count_dir          0x00000000U
#define MSK_NX500_xmac_pos_config_encoder_enc1_n_quant                 0x00003000U
#define SRT_NX500_xmac_pos_config_encoder_enc1_n_quant                 12
#define DFLT_VAL_NX500_xmac_pos_config_encoder_enc1_n_quant            0x00000000U

enum {
	BFW_NX500_xmac_pos_config_encoder_enc0_filter_sample_rate = 3,  /* [2:0] */
	BFW_NX500_xmac_pos_config_encoder_enc0_count_dir          = 1,  /* [3] */
	BFW_NX500_xmac_pos_config_encoder_enc0_n_quant            = 2,  /* [5:4] */
	BFW_NX500_xmac_pos_config_encoder_reserved1               = 2,  /* [7:6] */
	BFW_NX500_xmac_pos_config_encoder_enc1_filter_sample_rate = 3,  /* [10:8] */
	BFW_NX500_xmac_pos_config_encoder_enc1_count_dir          = 1,  /* [11] */
	BFW_NX500_xmac_pos_config_encoder_enc1_n_quant            = 2,  /* [13:12] */
	BFW_NX500_xmac_pos_config_encoder_reserved2               = 18  /* [31:14] */
};

typedef struct NX500_XMAC_POS_CONFIG_ENCODER_BIT_Ttag {
	unsigned int enc0_filter_sample_rate : BFW_NX500_xmac_pos_config_encoder_enc0_filter_sample_rate; /* Encoder 0 filter sample rate        */
	                                                                                                  /* 0: none                             */
	unsigned int enc0_count_dir          : BFW_NX500_xmac_pos_config_encoder_enc0_count_dir;          /* Encoder 0 count direction # 0       */
	                                                                                                  /* 0: up, 1: down                      */
	unsigned int enc0_n_quant            : BFW_NX500_xmac_pos_config_encoder_enc0_n_quant;            /* Encoder 0 N-qualifier               */
	                                                                                                  /* 0: none, sampled with every N pulse */
	unsigned int reserved1               : BFW_NX500_xmac_pos_config_encoder_reserved1;               /* reserved                            */
	unsigned int enc1_filter_sample_rate : BFW_NX500_xmac_pos_config_encoder_enc1_filter_sample_rate; /* Encoder 1 filter sample rate        */
	                                                                                                  /* 0: none                             */
	unsigned int enc1_count_dir          : BFW_NX500_xmac_pos_config_encoder_enc1_count_dir;          /* Encoder 1 count direction # 0       */
	                                                                                                  /* 0: up, 1: down                      */
	unsigned int enc1_n_quant            : BFW_NX500_xmac_pos_config_encoder_enc1_n_quant;            /* Encoder 1 N-qualifier               */
	                                                                                                  /* 0: none, sampled with every N pulse */
	unsigned int reserved2               : BFW_NX500_xmac_pos_config_encoder_reserved2;               /* reserved                            */
} NX500_XMAC_POS_CONFIG_ENCODER_BIT_T;

typedef union {
	unsigned int                        val;
	NX500_XMAC_POS_CONFIG_ENCODER_BIT_T bf;
} NX500_XMAC_POS_CONFIG_ENCODER_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pos_config_capture */
/* => Configuration capture register: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC3, as there is only one POS-unit in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pos_config_capture   0x00000994U
#define Adr_NX500_xmac0_xmac_pos_config_capture 0x00160994U
#define Adr_NX500_xmac1_xmac_pos_config_capture 0x00161994U
#define Adr_NX500_xmac2_xmac_pos_config_capture 0x00162994U
#define Adr_NX500_xmac3_xmac_pos_config_capture 0x00163994U
#define DFLT_VAL_NX500_xmac_pos_config_capture  0x00000000U

#define MSK_NX500_xmac_pos_config_capture_creg0_cw       0x00000003U
#define SRT_NX500_xmac_pos_config_capture_creg0_cw       0
#define DFLT_VAL_NX500_xmac_pos_config_capture_creg0_cw  0x00000000U
#define MSK_NX500_xmac_pos_config_capture_creg0_src      0x0000000cU
#define SRT_NX500_xmac_pos_config_capture_creg0_src      2
#define DFLT_VAL_NX500_xmac_pos_config_capture_creg0_src 0x00000000U
#define MSK_NX500_xmac_pos_config_capture_creg1_cw       0x00000030U
#define SRT_NX500_xmac_pos_config_capture_creg1_cw       4
#define DFLT_VAL_NX500_xmac_pos_config_capture_creg1_cw  0x00000000U
#define MSK_NX500_xmac_pos_config_capture_creg1_src      0x000000c0U
#define SRT_NX500_xmac_pos_config_capture_creg1_src      6
#define DFLT_VAL_NX500_xmac_pos_config_capture_creg1_src 0x00000000U
#define MSK_NX500_xmac_pos_config_capture_creg2_cw       0x00000300U
#define SRT_NX500_xmac_pos_config_capture_creg2_cw       8
#define DFLT_VAL_NX500_xmac_pos_config_capture_creg2_cw  0x00000000U
#define MSK_NX500_xmac_pos_config_capture_creg2_src      0x00000c00U
#define SRT_NX500_xmac_pos_config_capture_creg2_src      10
#define DFLT_VAL_NX500_xmac_pos_config_capture_creg2_src 0x00000000U
#define MSK_NX500_xmac_pos_config_capture_creg3_cw       0x00003000U
#define SRT_NX500_xmac_pos_config_capture_creg3_cw       12
#define DFLT_VAL_NX500_xmac_pos_config_capture_creg3_cw  0x00000000U
#define MSK_NX500_xmac_pos_config_capture_creg3_src      0x0000c000U
#define SRT_NX500_xmac_pos_config_capture_creg3_src      14
#define DFLT_VAL_NX500_xmac_pos_config_capture_creg3_src 0x00000000U

enum {
	BFW_NX500_xmac_pos_config_capture_creg0_cw  = 2,  /* [1:0] */
	BFW_NX500_xmac_pos_config_capture_creg0_src = 2,  /* [3:2] */
	BFW_NX500_xmac_pos_config_capture_creg1_cw  = 2,  /* [5:4] */
	BFW_NX500_xmac_pos_config_capture_creg1_src = 2,  /* [7:6] */
	BFW_NX500_xmac_pos_config_capture_creg2_cw  = 2,  /* [9:8] */
	BFW_NX500_xmac_pos_config_capture_creg2_src = 2,  /* [11:10] */
	BFW_NX500_xmac_pos_config_capture_creg3_cw  = 2,  /* [13:12] */
	BFW_NX500_xmac_pos_config_capture_creg3_src = 2,  /* [15:14] */
	BFW_NX500_xmac_pos_config_capture_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_POS_CONFIG_CAPTURE_BIT_Ttag {
	unsigned int creg0_cw  : BFW_NX500_xmac_pos_config_capture_creg0_cw;  /* Capture register0, capture with */
	                                                                      /* 0: mp0 positive edge            */
	unsigned int creg0_src : BFW_NX500_xmac_pos_config_capture_creg0_src; /* Capture register0, source       */
	                                                                      /* 0: none                         */
	unsigned int creg1_cw  : BFW_NX500_xmac_pos_config_capture_creg1_cw;  /* Capture register1, capture with */
	                                                                      /* 0: mp0 positive edge            */
	unsigned int creg1_src : BFW_NX500_xmac_pos_config_capture_creg1_src; /* Capture register1, source       */
	                                                                      /* 0: none                         */
	unsigned int creg2_cw  : BFW_NX500_xmac_pos_config_capture_creg2_cw;  /* Capture register2, capture with */
	                                                                      /* 0: mp0 positive edge            */
	unsigned int creg2_src : BFW_NX500_xmac_pos_config_capture_creg2_src; /* Capture register2, source       */
	                                                                      /* 0: none                         */
	unsigned int creg3_cw  : BFW_NX500_xmac_pos_config_capture_creg3_cw;  /* Capture register3, capture with */
	                                                                      /* 0: mp0 positive edge            */
	unsigned int creg3_src : BFW_NX500_xmac_pos_config_capture_creg3_src; /* Capture register3, source       */
	                                                                      /* 0: none                         */
	unsigned int reserved1 : BFW_NX500_xmac_pos_config_capture_reserved1; /* reserved                        */
} NX500_XMAC_POS_CONFIG_CAPTURE_BIT_T;

typedef union {
	unsigned int                        val;
	NX500_XMAC_POS_CONFIG_CAPTURE_BIT_T bf;
} NX500_XMAC_POS_CONFIG_CAPTURE_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pos_command */
/* => Command register: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC3, as there is only one POS-unit in netX100/500. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pos_command   0x00000998U
#define Adr_NX500_xmac0_xmac_pos_command 0x00160998U
#define Adr_NX500_xmac1_xmac_pos_command 0x00161998U
#define Adr_NX500_xmac2_xmac_pos_command 0x00162998U
#define Adr_NX500_xmac3_xmac_pos_command 0x00163998U
#define DFLT_VAL_NX500_xmac_pos_command  0x00000000U

#define MSK_NX500_xmac_pos_command_enc0_en            0x00000001U
#define SRT_NX500_xmac_pos_command_enc0_en            0
#define DFLT_VAL_NX500_xmac_pos_command_enc0_en       0x00000000U
#define MSK_NX500_xmac_pos_command_enc0_res_pos       0x00000002U
#define SRT_NX500_xmac_pos_command_enc0_res_pos       1
#define DFLT_VAL_NX500_xmac_pos_command_enc0_res_pos  0x00000000U
#define MSK_NX500_xmac_pos_command_enc0_res_zpos      0x00000004U
#define SRT_NX500_xmac_pos_command_enc0_res_zpos      2
#define DFLT_VAL_NX500_xmac_pos_command_enc0_res_zpos 0x00000000U
#define MSK_NX500_xmac_pos_command_enc1_en            0x00000100U
#define SRT_NX500_xmac_pos_command_enc1_en            8
#define DFLT_VAL_NX500_xmac_pos_command_enc1_en       0x00000000U
#define MSK_NX500_xmac_pos_command_enc1_res_pos       0x00000200U
#define SRT_NX500_xmac_pos_command_enc1_res_pos       9
#define DFLT_VAL_NX500_xmac_pos_command_enc1_res_pos  0x00000000U
#define MSK_NX500_xmac_pos_command_enc1_res_zpos      0x00000400U
#define SRT_NX500_xmac_pos_command_enc1_res_zpos      10
#define DFLT_VAL_NX500_xmac_pos_command_enc1_res_zpos 0x00000000U

enum {
	BFW_NX500_xmac_pos_command_enc0_en       = 1,  /* [0] */
	BFW_NX500_xmac_pos_command_enc0_res_pos  = 1,  /* [1] */
	BFW_NX500_xmac_pos_command_enc0_res_zpos = 1,  /* [2] */
	BFW_NX500_xmac_pos_command_reserved1     = 5,  /* [7:3] */
	BFW_NX500_xmac_pos_command_enc1_en       = 1,  /* [8] */
	BFW_NX500_xmac_pos_command_enc1_res_pos  = 1,  /* [9] */
	BFW_NX500_xmac_pos_command_enc1_res_zpos = 1,  /* [10] */
	BFW_NX500_xmac_pos_command_reserved2     = 21  /* [31:11] */
};

typedef struct NX500_XMAC_POS_COMMAND_BIT_Ttag {
	unsigned int enc0_en       : BFW_NX500_xmac_pos_command_enc0_en;       /* Encoder0 enable              */
	unsigned int enc0_res_pos  : BFW_NX500_xmac_pos_command_enc0_res_pos;  /* Encoder0 reset position      */
	unsigned int enc0_res_zpos : BFW_NX500_xmac_pos_command_enc0_res_zpos; /* Encoder0 reset null position */
	unsigned int reserved1     : BFW_NX500_xmac_pos_command_reserved1;     /* reserved                     */
	unsigned int enc1_en       : BFW_NX500_xmac_pos_command_enc1_en;       /* Encoder1 enable              */
	unsigned int enc1_res_pos  : BFW_NX500_xmac_pos_command_enc1_res_pos;  /* Encoder1 reset position      */
	unsigned int enc1_res_zpos : BFW_NX500_xmac_pos_command_enc1_res_zpos; /* Encoder1 reset null position */
	unsigned int reserved2     : BFW_NX500_xmac_pos_command_reserved2;     /* reserved                     */
} NX500_XMAC_POS_COMMAND_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_XMAC_POS_COMMAND_BIT_T bf;
} NX500_XMAC_POS_COMMAND_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pos_status */
/* => Position and capture status: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC3, as there is only one POS-unit in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pos_status   0x0000099CU
#define Adr_NX500_xmac0_xmac_pos_status 0x0016099CU
#define Adr_NX500_xmac1_xmac_pos_status 0x0016199CU
#define Adr_NX500_xmac2_xmac_pos_status 0x0016299CU
#define Adr_NX500_xmac3_xmac_pos_status 0x0016399CU
#define DFLT_VAL_NX500_xmac_pos_status  0x00000000U

#define MSK_NX500_xmac_pos_status_enc0_ovfl_pos       0x00000001U
#define SRT_NX500_xmac_pos_status_enc0_ovfl_pos       0
#define DFLT_VAL_NX500_xmac_pos_status_enc0_ovfl_pos  0x00000000U
#define MSK_NX500_xmac_pos_status_enc0_ovfl_neg       0x00000002U
#define SRT_NX500_xmac_pos_status_enc0_ovfl_neg       1
#define DFLT_VAL_NX500_xmac_pos_status_enc0_ovfl_neg  0x00000000U
#define MSK_NX500_xmac_pos_status_enc0_cap_zpos       0x00000004U
#define SRT_NX500_xmac_pos_status_enc0_cap_zpos       2
#define DFLT_VAL_NX500_xmac_pos_status_enc0_cap_zpos  0x00000000U
#define MSK_NX500_xmac_pos_status_enc0_cap_etime      0x00000008U
#define SRT_NX500_xmac_pos_status_enc0_cap_etime      3
#define DFLT_VAL_NX500_xmac_pos_status_enc0_cap_etime 0x00000000U
#define MSK_NX500_xmac_pos_status_enc1_ovfl_pos       0x00000010U
#define SRT_NX500_xmac_pos_status_enc1_ovfl_pos       4
#define DFLT_VAL_NX500_xmac_pos_status_enc1_ovfl_pos  0x00000000U
#define MSK_NX500_xmac_pos_status_enc1_ovfl_neg       0x00000020U
#define SRT_NX500_xmac_pos_status_enc1_ovfl_neg       5
#define DFLT_VAL_NX500_xmac_pos_status_enc1_ovfl_neg  0x00000000U
#define MSK_NX500_xmac_pos_status_enc1_cap_zpos       0x00000040U
#define SRT_NX500_xmac_pos_status_enc1_cap_zpos       6
#define DFLT_VAL_NX500_xmac_pos_status_enc1_cap_zpos  0x00000000U
#define MSK_NX500_xmac_pos_status_enc1_cap_etime      0x00000080U
#define SRT_NX500_xmac_pos_status_enc1_cap_etime      7
#define DFLT_VAL_NX500_xmac_pos_status_enc1_cap_etime 0x00000000U
#define MSK_NX500_xmac_pos_status_cap0                0x00000100U
#define SRT_NX500_xmac_pos_status_cap0                8
#define DFLT_VAL_NX500_xmac_pos_status_cap0           0x00000000U
#define MSK_NX500_xmac_pos_status_cap1                0x00000200U
#define SRT_NX500_xmac_pos_status_cap1                9
#define DFLT_VAL_NX500_xmac_pos_status_cap1           0x00000000U
#define MSK_NX500_xmac_pos_status_cap2                0x00000400U
#define SRT_NX500_xmac_pos_status_cap2                10
#define DFLT_VAL_NX500_xmac_pos_status_cap2           0x00000000U
#define MSK_NX500_xmac_pos_status_cap3                0x00000800U
#define SRT_NX500_xmac_pos_status_cap3                11
#define DFLT_VAL_NX500_xmac_pos_status_cap3           0x00000000U
#define MSK_NX500_xmac_pos_status_enc0_sign           0x00001000U
#define SRT_NX500_xmac_pos_status_enc0_sign           12
#define DFLT_VAL_NX500_xmac_pos_status_enc0_sign      0x00000000U
#define MSK_NX500_xmac_pos_status_enc1_sign           0x00002000U
#define SRT_NX500_xmac_pos_status_enc1_sign           13
#define DFLT_VAL_NX500_xmac_pos_status_enc1_sign      0x00000000U
#define MSK_NX500_xmac_pos_status_mp0                 0x00004000U
#define SRT_NX500_xmac_pos_status_mp0                 14
#define DFLT_VAL_NX500_xmac_pos_status_mp0            0x00000000U
#define MSK_NX500_xmac_pos_status_mp1                 0x00008000U
#define SRT_NX500_xmac_pos_status_mp1                 15
#define DFLT_VAL_NX500_xmac_pos_status_mp1            0x00000000U

enum {
	BFW_NX500_xmac_pos_status_enc0_ovfl_pos  = 1,  /* [0] */
	BFW_NX500_xmac_pos_status_enc0_ovfl_neg  = 1,  /* [1] */
	BFW_NX500_xmac_pos_status_enc0_cap_zpos  = 1,  /* [2] */
	BFW_NX500_xmac_pos_status_enc0_cap_etime = 1,  /* [3] */
	BFW_NX500_xmac_pos_status_enc1_ovfl_pos  = 1,  /* [4] */
	BFW_NX500_xmac_pos_status_enc1_ovfl_neg  = 1,  /* [5] */
	BFW_NX500_xmac_pos_status_enc1_cap_zpos  = 1,  /* [6] */
	BFW_NX500_xmac_pos_status_enc1_cap_etime = 1,  /* [7] */
	BFW_NX500_xmac_pos_status_cap0           = 1,  /* [8] */
	BFW_NX500_xmac_pos_status_cap1           = 1,  /* [9] */
	BFW_NX500_xmac_pos_status_cap2           = 1,  /* [10] */
	BFW_NX500_xmac_pos_status_cap3           = 1,  /* [11] */
	BFW_NX500_xmac_pos_status_enc0_sign      = 1,  /* [12] */
	BFW_NX500_xmac_pos_status_enc1_sign      = 1,  /* [13] */
	BFW_NX500_xmac_pos_status_mp0            = 1,  /* [14] */
	BFW_NX500_xmac_pos_status_mp1            = 1,  /* [15] */
	BFW_NX500_xmac_pos_status_reserved1      = 16  /* [31:16] */
};

typedef struct NX500_XMAC_POS_STATUS_BIT_Ttag {
	unsigned int enc0_ovfl_pos  : BFW_NX500_xmac_pos_status_enc0_ovfl_pos;  /* Encoder0 overflow positive      */
	unsigned int enc0_ovfl_neg  : BFW_NX500_xmac_pos_status_enc0_ovfl_neg;  /* Encoder0 overflow negative      */
	unsigned int enc0_cap_zpos  : BFW_NX500_xmac_pos_status_enc0_cap_zpos;  /* Encoder0 captured null position */
	unsigned int enc0_cap_etime : BFW_NX500_xmac_pos_status_enc0_cap_etime; /* Encoder0 captured edge time     */
	unsigned int enc1_ovfl_pos  : BFW_NX500_xmac_pos_status_enc1_ovfl_pos;  /* Encoder1 overflow positive      */
	unsigned int enc1_ovfl_neg  : BFW_NX500_xmac_pos_status_enc1_ovfl_neg;  /* Encoder1 overflow negative      */
	unsigned int enc1_cap_zpos  : BFW_NX500_xmac_pos_status_enc1_cap_zpos;  /* Encoder1 captured null position */
	unsigned int enc1_cap_etime : BFW_NX500_xmac_pos_status_enc1_cap_etime; /* Encoder1 captured edge time     */
	unsigned int cap0           : BFW_NX500_xmac_pos_status_cap0;           /* Captured register 0             */
	unsigned int cap1           : BFW_NX500_xmac_pos_status_cap1;           /* Captured register 1             */
	unsigned int cap2           : BFW_NX500_xmac_pos_status_cap2;           /* Captured register 2             */
	unsigned int cap3           : BFW_NX500_xmac_pos_status_cap3;           /* Captured register 3             */
	unsigned int enc0_sign      : BFW_NX500_xmac_pos_status_enc0_sign;      /* Encoder 0 signal N              */
	unsigned int enc1_sign      : BFW_NX500_xmac_pos_status_enc1_sign;      /* Encoder 1 signal N              */
	unsigned int mp0            : BFW_NX500_xmac_pos_status_mp0;            /* Measurement Point 0             */
	unsigned int mp1            : BFW_NX500_xmac_pos_status_mp1;            /* Measurement Point 1             */
	unsigned int reserved1      : BFW_NX500_xmac_pos_status_reserved1;      /* reserved                        */
} NX500_XMAC_POS_STATUS_BIT_T;

typedef union {
	unsigned int                val;
	NX500_XMAC_POS_STATUS_BIT_T bf;
} NX500_XMAC_POS_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pos_enc0_position */
/* => Actual position encoder 0: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC3, as there is only one POS-unit in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pos_enc0_position   0x000009A0U
#define Adr_NX500_xmac0_xmac_pos_enc0_position 0x001609A0U
#define Adr_NX500_xmac1_xmac_pos_enc0_position 0x001619A0U
#define Adr_NX500_xmac2_xmac_pos_enc0_position 0x001629A0U
#define Adr_NX500_xmac3_xmac_pos_enc0_position 0x001639A0U

#define MSK_NX500_xmac_pos_enc0_position_pos_enc0_position 0x0000ffffU
#define SRT_NX500_xmac_pos_enc0_position_pos_enc0_position 0

enum {
	BFW_NX500_xmac_pos_enc0_position_pos_enc0_position = 16, /* [15:0] */
	BFW_NX500_xmac_pos_enc0_position_reserved1         = 16  /* [31:16] */
};

typedef struct NX500_XMAC_POS_ENC0_POSITION_BIT_Ttag {
	unsigned int pos_enc0_position : BFW_NX500_xmac_pos_enc0_position_pos_enc0_position; /* Actual position encoder 0 */
	unsigned int reserved1         : BFW_NX500_xmac_pos_enc0_position_reserved1;         /* reserved                  */
} NX500_XMAC_POS_ENC0_POSITION_BIT_T;

typedef union {
	unsigned int                       val;
	NX500_XMAC_POS_ENC0_POSITION_BIT_T bf;
} NX500_XMAC_POS_ENC0_POSITION_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pos_enc0_nullposition */
/* => Last position encoder 0 sampled by enc0_n: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC3, as there is only one POS-unit in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pos_enc0_nullposition   0x000009A4U
#define Adr_NX500_xmac0_xmac_pos_enc0_nullposition 0x001609A4U
#define Adr_NX500_xmac1_xmac_pos_enc0_nullposition 0x001619A4U
#define Adr_NX500_xmac2_xmac_pos_enc0_nullposition 0x001629A4U
#define Adr_NX500_xmac3_xmac_pos_enc0_nullposition 0x001639A4U

#define MSK_NX500_xmac_pos_enc0_nullposition_pos_enc0_nullposition 0x0000ffffU
#define SRT_NX500_xmac_pos_enc0_nullposition_pos_enc0_nullposition 0

enum {
	BFW_NX500_xmac_pos_enc0_nullposition_pos_enc0_nullposition = 16, /* [15:0] */
	BFW_NX500_xmac_pos_enc0_nullposition_reserved1             = 16  /* [31:16] */
};

typedef struct NX500_XMAC_POS_ENC0_NULLPOSITION_BIT_Ttag {
	unsigned int pos_enc0_nullposition : BFW_NX500_xmac_pos_enc0_nullposition_pos_enc0_nullposition; /* Last position encoder 0 sampled by enc0_n */
	unsigned int reserved1             : BFW_NX500_xmac_pos_enc0_nullposition_reserved1;             /* reserved                                  */
} NX500_XMAC_POS_ENC0_NULLPOSITION_BIT_T;

typedef union {
	unsigned int                           val;
	NX500_XMAC_POS_ENC0_NULLPOSITION_BIT_T bf;
} NX500_XMAC_POS_ENC0_NULLPOSITION_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pos_enc1_position */
/* => Actual position encoder 1: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC3, as there is only one POS-unit in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pos_enc1_position   0x000009A8U
#define Adr_NX500_xmac0_xmac_pos_enc1_position 0x001609A8U
#define Adr_NX500_xmac1_xmac_pos_enc1_position 0x001619A8U
#define Adr_NX500_xmac2_xmac_pos_enc1_position 0x001629A8U
#define Adr_NX500_xmac3_xmac_pos_enc1_position 0x001639A8U

#define MSK_NX500_xmac_pos_enc1_position_pos_enc1_position 0x0000ffffU
#define SRT_NX500_xmac_pos_enc1_position_pos_enc1_position 0

enum {
	BFW_NX500_xmac_pos_enc1_position_pos_enc1_position = 16, /* [15:0] */
	BFW_NX500_xmac_pos_enc1_position_reserved1         = 16  /* [31:16] */
};

typedef struct NX500_XMAC_POS_ENC1_POSITION_BIT_Ttag {
	unsigned int pos_enc1_position : BFW_NX500_xmac_pos_enc1_position_pos_enc1_position; /* Actual position encoder 1 */
	unsigned int reserved1         : BFW_NX500_xmac_pos_enc1_position_reserved1;         /* reserved                  */
} NX500_XMAC_POS_ENC1_POSITION_BIT_T;

typedef union {
	unsigned int                       val;
	NX500_XMAC_POS_ENC1_POSITION_BIT_T bf;
} NX500_XMAC_POS_ENC1_POSITION_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pos_enc1_nullposition */
/* => Last position encoder 1 sampled by enc1_n: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC3, as there is only one POS-unit in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pos_enc1_nullposition   0x000009ACU
#define Adr_NX500_xmac0_xmac_pos_enc1_nullposition 0x001609ACU
#define Adr_NX500_xmac1_xmac_pos_enc1_nullposition 0x001619ACU
#define Adr_NX500_xmac2_xmac_pos_enc1_nullposition 0x001629ACU
#define Adr_NX500_xmac3_xmac_pos_enc1_nullposition 0x001639ACU

#define MSK_NX500_xmac_pos_enc1_nullposition_pos_enc1_nullposition 0x0000ffffU
#define SRT_NX500_xmac_pos_enc1_nullposition_pos_enc1_nullposition 0

enum {
	BFW_NX500_xmac_pos_enc1_nullposition_pos_enc1_nullposition = 16, /* [15:0] */
	BFW_NX500_xmac_pos_enc1_nullposition_reserved1             = 16  /* [31:16] */
};

typedef struct NX500_XMAC_POS_ENC1_NULLPOSITION_BIT_Ttag {
	unsigned int pos_enc1_nullposition : BFW_NX500_xmac_pos_enc1_nullposition_pos_enc1_nullposition; /* Last position encoder 1 sampled by enc1_n */
	unsigned int reserved1             : BFW_NX500_xmac_pos_enc1_nullposition_reserved1;             /* reserved                                  */
} NX500_XMAC_POS_ENC1_NULLPOSITION_BIT_T;

typedef union {
	unsigned int                           val;
	NX500_XMAC_POS_ENC1_NULLPOSITION_BIT_T bf;
} NX500_XMAC_POS_ENC1_NULLPOSITION_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pos_enc0_edgetime */
/* => System time at last edge of encoder 0: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC3, as there is only one POS-unit in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pos_enc0_edgetime   0x000009B0U
#define Adr_NX500_xmac0_xmac_pos_enc0_edgetime 0x001609B0U
#define Adr_NX500_xmac1_xmac_pos_enc0_edgetime 0x001619B0U
#define Adr_NX500_xmac2_xmac_pos_enc0_edgetime 0x001629B0U
#define Adr_NX500_xmac3_xmac_pos_enc0_edgetime 0x001639B0U

#define MSK_NX500_xmac_pos_enc0_edgetime_pos_enc0_edgetime 0x0000ffffU
#define SRT_NX500_xmac_pos_enc0_edgetime_pos_enc0_edgetime 0

enum {
	BFW_NX500_xmac_pos_enc0_edgetime_pos_enc0_edgetime = 16, /* [15:0] */
	BFW_NX500_xmac_pos_enc0_edgetime_reserved1         = 16  /* [31:16] */
};

typedef struct NX500_XMAC_POS_ENC0_EDGETIME_BIT_Ttag {
	unsigned int pos_enc0_edgetime : BFW_NX500_xmac_pos_enc0_edgetime_pos_enc0_edgetime; /* System time at last edge of encoder 0 */
	unsigned int reserved1         : BFW_NX500_xmac_pos_enc0_edgetime_reserved1;         /* reserved                              */
} NX500_XMAC_POS_ENC0_EDGETIME_BIT_T;

typedef union {
	unsigned int                       val;
	NX500_XMAC_POS_ENC0_EDGETIME_BIT_T bf;
} NX500_XMAC_POS_ENC0_EDGETIME_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pos_enc1_edgetime */
/* => System time at last edge of encoder 0: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC3, as there is only one POS-unit in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pos_enc1_edgetime   0x000009B4U
#define Adr_NX500_xmac0_xmac_pos_enc1_edgetime 0x001609B4U
#define Adr_NX500_xmac1_xmac_pos_enc1_edgetime 0x001619B4U
#define Adr_NX500_xmac2_xmac_pos_enc1_edgetime 0x001629B4U
#define Adr_NX500_xmac3_xmac_pos_enc1_edgetime 0x001639B4U

#define MSK_NX500_xmac_pos_enc1_edgetime_pos_enc1_edgetime 0x0000ffffU
#define SRT_NX500_xmac_pos_enc1_edgetime_pos_enc1_edgetime 0

enum {
	BFW_NX500_xmac_pos_enc1_edgetime_pos_enc1_edgetime = 16, /* [15:0] */
	BFW_NX500_xmac_pos_enc1_edgetime_reserved1         = 16  /* [31:16] */
};

typedef struct NX500_XMAC_POS_ENC1_EDGETIME_BIT_Ttag {
	unsigned int pos_enc1_edgetime : BFW_NX500_xmac_pos_enc1_edgetime_pos_enc1_edgetime; /* System time at last edge of encoder 0 */
	unsigned int reserved1         : BFW_NX500_xmac_pos_enc1_edgetime_reserved1;         /* reserved                              */
} NX500_XMAC_POS_ENC1_EDGETIME_BIT_T;

typedef union {
	unsigned int                       val;
	NX500_XMAC_POS_ENC1_EDGETIME_BIT_T bf;
} NX500_XMAC_POS_ENC1_EDGETIME_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pos_capture0 */
/* => Capture register 0: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC3, as there is only one POS-unit in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pos_capture0   0x000009B8U
#define Adr_NX500_xmac0_xmac_pos_capture0 0x001609B8U
#define Adr_NX500_xmac1_xmac_pos_capture0 0x001619B8U
#define Adr_NX500_xmac2_xmac_pos_capture0 0x001629B8U
#define Adr_NX500_xmac3_xmac_pos_capture0 0x001639B8U

#define MSK_NX500_xmac_pos_capture0_pos_capture0 0x0000ffffU
#define SRT_NX500_xmac_pos_capture0_pos_capture0 0

enum {
	BFW_NX500_xmac_pos_capture0_pos_capture0 = 16, /* [15:0] */
	BFW_NX500_xmac_pos_capture0_reserved1    = 16  /* [31:16] */
};

typedef struct NX500_XMAC_POS_CAPTURE0_BIT_Ttag {
	unsigned int pos_capture0 : BFW_NX500_xmac_pos_capture0_pos_capture0; /* Capture register 0 */
	unsigned int reserved1    : BFW_NX500_xmac_pos_capture0_reserved1;    /* reserved           */
} NX500_XMAC_POS_CAPTURE0_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_XMAC_POS_CAPTURE0_BIT_T bf;
} NX500_XMAC_POS_CAPTURE0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pos_capture1 */
/* => Capture register 1: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC3, as there is only one POS-unit in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pos_capture1   0x000009BCU
#define Adr_NX500_xmac0_xmac_pos_capture1 0x001609BCU
#define Adr_NX500_xmac1_xmac_pos_capture1 0x001619BCU
#define Adr_NX500_xmac2_xmac_pos_capture1 0x001629BCU
#define Adr_NX500_xmac3_xmac_pos_capture1 0x001639BCU

#define MSK_NX500_xmac_pos_capture1_pos_capture1 0x0000ffffU
#define SRT_NX500_xmac_pos_capture1_pos_capture1 0

enum {
	BFW_NX500_xmac_pos_capture1_pos_capture1 = 16, /* [15:0] */
	BFW_NX500_xmac_pos_capture1_reserved1    = 16  /* [31:16] */
};

typedef struct NX500_XMAC_POS_CAPTURE1_BIT_Ttag {
	unsigned int pos_capture1 : BFW_NX500_xmac_pos_capture1_pos_capture1; /* Capture register 1 */
	unsigned int reserved1    : BFW_NX500_xmac_pos_capture1_reserved1;    /* reserved           */
} NX500_XMAC_POS_CAPTURE1_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_XMAC_POS_CAPTURE1_BIT_T bf;
} NX500_XMAC_POS_CAPTURE1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pos_capture2 */
/* => Capture register 2: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC3, as there is only one POS-unit in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pos_capture2   0x000009C0U
#define Adr_NX500_xmac0_xmac_pos_capture2 0x001609C0U
#define Adr_NX500_xmac1_xmac_pos_capture2 0x001619C0U
#define Adr_NX500_xmac2_xmac_pos_capture2 0x001629C0U
#define Adr_NX500_xmac3_xmac_pos_capture2 0x001639C0U

#define MSK_NX500_xmac_pos_capture2_pos_capture2 0x0000ffffU
#define SRT_NX500_xmac_pos_capture2_pos_capture2 0

enum {
	BFW_NX500_xmac_pos_capture2_pos_capture2 = 16, /* [15:0] */
	BFW_NX500_xmac_pos_capture2_reserved1    = 16  /* [31:16] */
};

typedef struct NX500_XMAC_POS_CAPTURE2_BIT_Ttag {
	unsigned int pos_capture2 : BFW_NX500_xmac_pos_capture2_pos_capture2; /* Capture register 2 */
	unsigned int reserved1    : BFW_NX500_xmac_pos_capture2_reserved1;    /* reserved           */
} NX500_XMAC_POS_CAPTURE2_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_XMAC_POS_CAPTURE2_BIT_T bf;
} NX500_XMAC_POS_CAPTURE2_T;

/* --------------------------------------------------------------------- */
/* Register xmac_pos_capture3 */
/* => Capture register 3: */
/*    See PWM_POS.doc for details. */
/*    This register is only available at xMAC3, as there is only one POS-unit in netX100/500. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_pos_capture3   0x000009C4U
#define Adr_NX500_xmac0_xmac_pos_capture3 0x001609C4U
#define Adr_NX500_xmac1_xmac_pos_capture3 0x001619C4U
#define Adr_NX500_xmac2_xmac_pos_capture3 0x001629C4U
#define Adr_NX500_xmac3_xmac_pos_capture3 0x001639C4U

#define MSK_NX500_xmac_pos_capture3_pos_capture3 0x0000ffffU
#define SRT_NX500_xmac_pos_capture3_pos_capture3 0

enum {
	BFW_NX500_xmac_pos_capture3_pos_capture3 = 16, /* [15:0] */
	BFW_NX500_xmac_pos_capture3_reserved1    = 16  /* [31:16] */
};

typedef struct NX500_XMAC_POS_CAPTURE3_BIT_Ttag {
	unsigned int pos_capture3 : BFW_NX500_xmac_pos_capture3_pos_capture3; /* Capture register 3 */
	unsigned int reserved1    : BFW_NX500_xmac_pos_capture3_reserved1;    /* reserved           */
} NX500_XMAC_POS_CAPTURE3_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_XMAC_POS_CAPTURE3_BIT_T bf;
} NX500_XMAC_POS_CAPTURE3_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_crc_polynomial_l */
/* => xMAC RX CRC Polynomial lower part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rx_crc_polynomial_l   0x000009D8U
#define Adr_NX500_xmac0_xmac_rx_crc_polynomial_l 0x001609D8U
#define Adr_NX500_xmac1_xmac_rx_crc_polynomial_l 0x001619D8U
#define Adr_NX500_xmac2_xmac_rx_crc_polynomial_l 0x001629D8U
#define Adr_NX500_xmac3_xmac_rx_crc_polynomial_l 0x001639D8U
#define DFLT_VAL_NX500_xmac_rx_crc_polynomial_l  0x00000000U

#define MSK_NX500_xmac_rx_crc_polynomial_l_RX_POL_L      0x0000ffffU
#define SRT_NX500_xmac_rx_crc_polynomial_l_RX_POL_L      0
#define DFLT_VAL_NX500_xmac_rx_crc_polynomial_l_RX_POL_L 0x00000000U

enum {
	BFW_NX500_xmac_rx_crc_polynomial_l_RX_POL_L  = 16, /* [15:0] */
	BFW_NX500_xmac_rx_crc_polynomial_l_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RX_CRC_POLYNOMIAL_L_BIT_Ttag {
	unsigned int RX_POL_L  : BFW_NX500_xmac_rx_crc_polynomial_l_RX_POL_L;  /* lower bits of RX-CRC Polynomial */
	unsigned int reserved1 : BFW_NX500_xmac_rx_crc_polynomial_l_reserved1; /* reserved                        */
} NX500_XMAC_RX_CRC_POLYNOMIAL_L_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_XMAC_RX_CRC_POLYNOMIAL_L_BIT_T bf;
} NX500_XMAC_RX_CRC_POLYNOMIAL_L_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_crc_polynomial_h */
/* => xMAC RX CRC Polynomial lower part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rx_crc_polynomial_h   0x000009DCU
#define Adr_NX500_xmac0_xmac_rx_crc_polynomial_h 0x001609DCU
#define Adr_NX500_xmac1_xmac_rx_crc_polynomial_h 0x001619DCU
#define Adr_NX500_xmac2_xmac_rx_crc_polynomial_h 0x001629DCU
#define Adr_NX500_xmac3_xmac_rx_crc_polynomial_h 0x001639DCU
#define DFLT_VAL_NX500_xmac_rx_crc_polynomial_h  0x00000000U

#define MSK_NX500_xmac_rx_crc_polynomial_h_RX_POL_H      0x0000ffffU
#define SRT_NX500_xmac_rx_crc_polynomial_h_RX_POL_H      0
#define DFLT_VAL_NX500_xmac_rx_crc_polynomial_h_RX_POL_H 0x00000000U

enum {
	BFW_NX500_xmac_rx_crc_polynomial_h_RX_POL_H  = 16, /* [15:0] */
	BFW_NX500_xmac_rx_crc_polynomial_h_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RX_CRC_POLYNOMIAL_H_BIT_Ttag {
	unsigned int RX_POL_H  : BFW_NX500_xmac_rx_crc_polynomial_h_RX_POL_H;  /* upper bits of RX-CRC Polynomial */
	unsigned int reserved1 : BFW_NX500_xmac_rx_crc_polynomial_h_reserved1; /* reserved                        */
} NX500_XMAC_RX_CRC_POLYNOMIAL_H_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_XMAC_RX_CRC_POLYNOMIAL_H_BIT_T bf;
} NX500_XMAC_RX_CRC_POLYNOMIAL_H_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_crc_l */
/* => xMAC RX CRC lower part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rx_crc_l   0x000009E0U
#define Adr_NX500_xmac0_xmac_rx_crc_l 0x001609E0U
#define Adr_NX500_xmac1_xmac_rx_crc_l 0x001619E0U
#define Adr_NX500_xmac2_xmac_rx_crc_l 0x001629E0U
#define Adr_NX500_xmac3_xmac_rx_crc_l 0x001639E0U
#define DFLT_VAL_NX500_xmac_rx_crc_l  0x00000000U

#define MSK_NX500_xmac_rx_crc_l_RX_CRC_L      0x0000ffffU
#define SRT_NX500_xmac_rx_crc_l_RX_CRC_L      0
#define DFLT_VAL_NX500_xmac_rx_crc_l_RX_CRC_L 0x00000000U

enum {
	BFW_NX500_xmac_rx_crc_l_RX_CRC_L  = 16, /* [15:0] */
	BFW_NX500_xmac_rx_crc_l_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RX_CRC_L_BIT_Ttag {
	unsigned int RX_CRC_L  : BFW_NX500_xmac_rx_crc_l_RX_CRC_L;  /* lower bits of RX-CRC */
	unsigned int reserved1 : BFW_NX500_xmac_rx_crc_l_reserved1; /* reserved             */
} NX500_XMAC_RX_CRC_L_BIT_T;

typedef union {
	unsigned int              val;
	NX500_XMAC_RX_CRC_L_BIT_T bf;
} NX500_XMAC_RX_CRC_L_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_crc_h */
/* => xMAC RX CRC upper part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rx_crc_h   0x000009E4U
#define Adr_NX500_xmac0_xmac_rx_crc_h 0x001609E4U
#define Adr_NX500_xmac1_xmac_rx_crc_h 0x001619E4U
#define Adr_NX500_xmac2_xmac_rx_crc_h 0x001629E4U
#define Adr_NX500_xmac3_xmac_rx_crc_h 0x001639E4U
#define DFLT_VAL_NX500_xmac_rx_crc_h  0x00000000U

#define MSK_NX500_xmac_rx_crc_h_RX_CRC_H      0x0000ffffU
#define SRT_NX500_xmac_rx_crc_h_RX_CRC_H      0
#define DFLT_VAL_NX500_xmac_rx_crc_h_RX_CRC_H 0x00000000U

enum {
	BFW_NX500_xmac_rx_crc_h_RX_CRC_H  = 16, /* [15:0] */
	BFW_NX500_xmac_rx_crc_h_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RX_CRC_H_BIT_Ttag {
	unsigned int RX_CRC_H  : BFW_NX500_xmac_rx_crc_h_RX_CRC_H;  /* upper bits of RX-CRC */
	unsigned int reserved1 : BFW_NX500_xmac_rx_crc_h_reserved1; /* reserved             */
} NX500_XMAC_RX_CRC_H_BIT_T;

typedef union {
	unsigned int              val;
	NX500_XMAC_RX_CRC_H_BIT_T bf;
} NX500_XMAC_RX_CRC_H_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_crc_cfg */
/* => xMAC RX CRC Config Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rx_crc_cfg   0x000009E8U
#define Adr_NX500_xmac0_xmac_rx_crc_cfg 0x001609E8U
#define Adr_NX500_xmac1_xmac_rx_crc_cfg 0x001619E8U
#define Adr_NX500_xmac2_xmac_rx_crc_cfg 0x001629E8U
#define Adr_NX500_xmac3_xmac_rx_crc_cfg 0x001639E8U
#define DFLT_VAL_NX500_xmac_rx_crc_cfg  0x00000000U

#define MSK_NX500_xmac_rx_crc_cfg_shift_right      0x00000001U
#define SRT_NX500_xmac_rx_crc_cfg_shift_right      0
#define DFLT_VAL_NX500_xmac_rx_crc_cfg_shift_right 0x00000000U
#define MSK_NX500_xmac_rx_crc_cfg_zero             0x00000002U
#define SRT_NX500_xmac_rx_crc_cfg_zero             1
#define DFLT_VAL_NX500_xmac_rx_crc_cfg_zero        0x00000000U
#define MSK_NX500_xmac_rx_crc_cfg_invert           0x00000004U
#define SRT_NX500_xmac_rx_crc_cfg_invert           2
#define DFLT_VAL_NX500_xmac_rx_crc_cfg_invert      0x00000000U
#define MSK_NX500_xmac_rx_crc_cfg_len              0x000000f8U
#define SRT_NX500_xmac_rx_crc_cfg_len              3
#define DFLT_VAL_NX500_xmac_rx_crc_cfg_len         0x00000000U
#define MSK_NX500_xmac_rx_crc_cfg_nof_bits         0x00000300U
#define SRT_NX500_xmac_rx_crc_cfg_nof_bits         8
#define DFLT_VAL_NX500_xmac_rx_crc_cfg_nof_bits    0x00000000U
#define MSK_NX500_xmac_rx_crc_cfg_direct_div       0x00000400U
#define SRT_NX500_xmac_rx_crc_cfg_direct_div       10
#define DFLT_VAL_NX500_xmac_rx_crc_cfg_direct_div  0x00000000U

enum {
	BFW_NX500_xmac_rx_crc_cfg_shift_right = 1,  /* [0] */
	BFW_NX500_xmac_rx_crc_cfg_zero        = 1,  /* [1] */
	BFW_NX500_xmac_rx_crc_cfg_invert      = 1,  /* [2] */
	BFW_NX500_xmac_rx_crc_cfg_len         = 5,  /* [7:3] */
	BFW_NX500_xmac_rx_crc_cfg_nof_bits    = 2,  /* [9:8] */
	BFW_NX500_xmac_rx_crc_cfg_direct_div  = 1,  /* [10] */
	BFW_NX500_xmac_rx_crc_cfg_reserved1   = 21  /* [31:11] */
};

typedef struct NX500_XMAC_RX_CRC_CFG_BIT_Ttag {
	unsigned int shift_right : BFW_NX500_xmac_rx_crc_cfg_shift_right; /* Shift RX CRC from left to right                                      */
	unsigned int zero        : BFW_NX500_xmac_rx_crc_cfg_zero;        /* Set input of RX CRC to zero (before invert)                          */
	unsigned int invert      : BFW_NX500_xmac_rx_crc_cfg_invert;      /* Invert input of RX CRC                                               */
	unsigned int len         : BFW_NX500_xmac_rx_crc_cfg_len;         /* Length of RX_CRC minus 1 (0-31)                                      */
	unsigned int nof_bits    : BFW_NX500_xmac_rx_crc_cfg_nof_bits;    /* 1(0),2(1),4(2),8(3) Bits from rx register to be executed in parallel */
	unsigned int direct_div  : BFW_NX500_xmac_rx_crc_cfg_direct_div;  /* calculate direct polynomial division without n zeros after frame     */
	unsigned int reserved1   : BFW_NX500_xmac_rx_crc_cfg_reserved1;   /* reserved                                                             */
} NX500_XMAC_RX_CRC_CFG_BIT_T;

typedef union {
	unsigned int                val;
	NX500_XMAC_RX_CRC_CFG_BIT_T bf;
} NX500_XMAC_RX_CRC_CFG_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_crc_polynomial_l */
/* => xMAC TX CRC Polynomial lower part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tx_crc_polynomial_l   0x000009ECU
#define Adr_NX500_xmac0_xmac_tx_crc_polynomial_l 0x001609ECU
#define Adr_NX500_xmac1_xmac_tx_crc_polynomial_l 0x001619ECU
#define Adr_NX500_xmac2_xmac_tx_crc_polynomial_l 0x001629ECU
#define Adr_NX500_xmac3_xmac_tx_crc_polynomial_l 0x001639ECU
#define DFLT_VAL_NX500_xmac_tx_crc_polynomial_l  0x00000000U

#define MSK_NX500_xmac_tx_crc_polynomial_l_TX_POL_L      0x0000ffffU
#define SRT_NX500_xmac_tx_crc_polynomial_l_TX_POL_L      0
#define DFLT_VAL_NX500_xmac_tx_crc_polynomial_l_TX_POL_L 0x00000000U

enum {
	BFW_NX500_xmac_tx_crc_polynomial_l_TX_POL_L  = 16, /* [15:0] */
	BFW_NX500_xmac_tx_crc_polynomial_l_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_TX_CRC_POLYNOMIAL_L_BIT_Ttag {
	unsigned int TX_POL_L  : BFW_NX500_xmac_tx_crc_polynomial_l_TX_POL_L;  /* lower bits of TX-CRC Polynomial */
	unsigned int reserved1 : BFW_NX500_xmac_tx_crc_polynomial_l_reserved1; /* reserved                        */
} NX500_XMAC_TX_CRC_POLYNOMIAL_L_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_XMAC_TX_CRC_POLYNOMIAL_L_BIT_T bf;
} NX500_XMAC_TX_CRC_POLYNOMIAL_L_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_crc_polynomial_h */
/* => xMAC TX CRC Polynomial lower part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tx_crc_polynomial_h   0x000009F0U
#define Adr_NX500_xmac0_xmac_tx_crc_polynomial_h 0x001609F0U
#define Adr_NX500_xmac1_xmac_tx_crc_polynomial_h 0x001619F0U
#define Adr_NX500_xmac2_xmac_tx_crc_polynomial_h 0x001629F0U
#define Adr_NX500_xmac3_xmac_tx_crc_polynomial_h 0x001639F0U
#define DFLT_VAL_NX500_xmac_tx_crc_polynomial_h  0x00000000U

#define MSK_NX500_xmac_tx_crc_polynomial_h_TX_POL_H      0x0000ffffU
#define SRT_NX500_xmac_tx_crc_polynomial_h_TX_POL_H      0
#define DFLT_VAL_NX500_xmac_tx_crc_polynomial_h_TX_POL_H 0x00000000U

enum {
	BFW_NX500_xmac_tx_crc_polynomial_h_TX_POL_H  = 16, /* [15:0] */
	BFW_NX500_xmac_tx_crc_polynomial_h_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_TX_CRC_POLYNOMIAL_H_BIT_Ttag {
	unsigned int TX_POL_H  : BFW_NX500_xmac_tx_crc_polynomial_h_TX_POL_H;  /* upper bits of TX-CRC Polynomial */
	unsigned int reserved1 : BFW_NX500_xmac_tx_crc_polynomial_h_reserved1; /* reserved                        */
} NX500_XMAC_TX_CRC_POLYNOMIAL_H_BIT_T;

typedef union {
	unsigned int                         val;
	NX500_XMAC_TX_CRC_POLYNOMIAL_H_BIT_T bf;
} NX500_XMAC_TX_CRC_POLYNOMIAL_H_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_crc_l */
/* => xMAC TX CRC lower part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tx_crc_l   0x000009F4U
#define Adr_NX500_xmac0_xmac_tx_crc_l 0x001609F4U
#define Adr_NX500_xmac1_xmac_tx_crc_l 0x001619F4U
#define Adr_NX500_xmac2_xmac_tx_crc_l 0x001629F4U
#define Adr_NX500_xmac3_xmac_tx_crc_l 0x001639F4U
#define DFLT_VAL_NX500_xmac_tx_crc_l  0x00000000U

#define MSK_NX500_xmac_tx_crc_l_TX_CRC_L      0x0000ffffU
#define SRT_NX500_xmac_tx_crc_l_TX_CRC_L      0
#define DFLT_VAL_NX500_xmac_tx_crc_l_TX_CRC_L 0x00000000U

enum {
	BFW_NX500_xmac_tx_crc_l_TX_CRC_L  = 16, /* [15:0] */
	BFW_NX500_xmac_tx_crc_l_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_TX_CRC_L_BIT_Ttag {
	unsigned int TX_CRC_L  : BFW_NX500_xmac_tx_crc_l_TX_CRC_L;  /* lower bits of TX-CRC */
	unsigned int reserved1 : BFW_NX500_xmac_tx_crc_l_reserved1; /* reserved             */
} NX500_XMAC_TX_CRC_L_BIT_T;

typedef union {
	unsigned int              val;
	NX500_XMAC_TX_CRC_L_BIT_T bf;
} NX500_XMAC_TX_CRC_L_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_crc_h */
/* => xMAC TX CRC upper part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tx_crc_h   0x000009F8U
#define Adr_NX500_xmac0_xmac_tx_crc_h 0x001609F8U
#define Adr_NX500_xmac1_xmac_tx_crc_h 0x001619F8U
#define Adr_NX500_xmac2_xmac_tx_crc_h 0x001629F8U
#define Adr_NX500_xmac3_xmac_tx_crc_h 0x001639F8U
#define DFLT_VAL_NX500_xmac_tx_crc_h  0x00000000U

#define MSK_NX500_xmac_tx_crc_h_TX_CRC_H      0x0000ffffU
#define SRT_NX500_xmac_tx_crc_h_TX_CRC_H      0
#define DFLT_VAL_NX500_xmac_tx_crc_h_TX_CRC_H 0x00000000U

enum {
	BFW_NX500_xmac_tx_crc_h_TX_CRC_H  = 16, /* [15:0] */
	BFW_NX500_xmac_tx_crc_h_reserved1 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_TX_CRC_H_BIT_Ttag {
	unsigned int TX_CRC_H  : BFW_NX500_xmac_tx_crc_h_TX_CRC_H;  /* upper bits of TX-CRC */
	unsigned int reserved1 : BFW_NX500_xmac_tx_crc_h_reserved1; /* reserved             */
} NX500_XMAC_TX_CRC_H_BIT_T;

typedef union {
	unsigned int              val;
	NX500_XMAC_TX_CRC_H_BIT_T bf;
} NX500_XMAC_TX_CRC_H_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_crc_cfg */
/* => xMAC TX CRC Config Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tx_crc_cfg   0x000009FCU
#define Adr_NX500_xmac0_xmac_tx_crc_cfg 0x001609FCU
#define Adr_NX500_xmac1_xmac_tx_crc_cfg 0x001619FCU
#define Adr_NX500_xmac2_xmac_tx_crc_cfg 0x001629FCU
#define Adr_NX500_xmac3_xmac_tx_crc_cfg 0x001639FCU
#define DFLT_VAL_NX500_xmac_tx_crc_cfg  0x00000000U

#define MSK_NX500_xmac_tx_crc_cfg_shift_right      0x00000001U
#define SRT_NX500_xmac_tx_crc_cfg_shift_right      0
#define DFLT_VAL_NX500_xmac_tx_crc_cfg_shift_right 0x00000000U
#define MSK_NX500_xmac_tx_crc_cfg_zero             0x00000002U
#define SRT_NX500_xmac_tx_crc_cfg_zero             1
#define DFLT_VAL_NX500_xmac_tx_crc_cfg_zero        0x00000000U
#define MSK_NX500_xmac_tx_crc_cfg_invert           0x00000004U
#define SRT_NX500_xmac_tx_crc_cfg_invert           2
#define DFLT_VAL_NX500_xmac_tx_crc_cfg_invert      0x00000000U
#define MSK_NX500_xmac_tx_crc_cfg_len              0x000000f8U
#define SRT_NX500_xmac_tx_crc_cfg_len              3
#define DFLT_VAL_NX500_xmac_tx_crc_cfg_len         0x00000000U
#define MSK_NX500_xmac_tx_crc_cfg_nof_bits         0x00000300U
#define SRT_NX500_xmac_tx_crc_cfg_nof_bits         8
#define DFLT_VAL_NX500_xmac_tx_crc_cfg_nof_bits    0x00000000U
#define MSK_NX500_xmac_tx_crc_cfg_direct_div       0x00000400U
#define SRT_NX500_xmac_tx_crc_cfg_direct_div       10
#define DFLT_VAL_NX500_xmac_tx_crc_cfg_direct_div  0x00000000U

enum {
	BFW_NX500_xmac_tx_crc_cfg_shift_right = 1,  /* [0] */
	BFW_NX500_xmac_tx_crc_cfg_zero        = 1,  /* [1] */
	BFW_NX500_xmac_tx_crc_cfg_invert      = 1,  /* [2] */
	BFW_NX500_xmac_tx_crc_cfg_len         = 5,  /* [7:3] */
	BFW_NX500_xmac_tx_crc_cfg_nof_bits    = 2,  /* [9:8] */
	BFW_NX500_xmac_tx_crc_cfg_direct_div  = 1,  /* [10] */
	BFW_NX500_xmac_tx_crc_cfg_reserved1   = 21  /* [31:11] */
};

typedef struct NX500_XMAC_TX_CRC_CFG_BIT_Ttag {
	unsigned int shift_right : BFW_NX500_xmac_tx_crc_cfg_shift_right; /* Shift TX CRC from left to right                                      */
	unsigned int zero        : BFW_NX500_xmac_tx_crc_cfg_zero;        /* Set input of TX CRC to zero (before invert)                          */
	unsigned int invert      : BFW_NX500_xmac_tx_crc_cfg_invert;      /* Invert input of TX CRC                                               */
	unsigned int len         : BFW_NX500_xmac_tx_crc_cfg_len;         /* Length of TX_CRC minus 1 (0-31)                                      */
	unsigned int nof_bits    : BFW_NX500_xmac_tx_crc_cfg_nof_bits;    /* 1(0),2(1),4(2),8(3) Bits from tx_register to be executed in parallel */
	unsigned int direct_div  : BFW_NX500_xmac_tx_crc_cfg_direct_div;  /* calculate direct polynomial division without n zeros after frame     */
	unsigned int reserved1   : BFW_NX500_xmac_tx_crc_cfg_reserved1;   /* reserved                                                             */
} NX500_XMAC_TX_CRC_CFG_BIT_T;

typedef union {
	unsigned int                val;
	NX500_XMAC_TX_CRC_CFG_BIT_T bf;
} NX500_XMAC_TX_CRC_CFG_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpu_hold_pc */
/* => xMAC RPU hold_pc register: */
/*    rpu_hold_pc and tpu_hold_pc are the only registers accessible by ARM-CPU, */
/*    while RPU or TPU are running (hold=0). */
/*    To access other registers of xMAC, first hold RPU and TPU. */
/*    This register is not visible for xMAC RPU and TPU. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_rpu_hold_pc   0x00000A00U
#define Adr_NX500_xmac0_xmac_rpu_hold_pc 0x00160A00U
#define Adr_NX500_xmac1_xmac_rpu_hold_pc 0x00161A00U
#define Adr_NX500_xmac2_xmac_rpu_hold_pc 0x00162A00U
#define Adr_NX500_xmac3_xmac_rpu_hold_pc 0x00163A00U
#define DFLT_VAL_NX500_xmac_rpu_hold_pc  0x00008000U

#define MSK_NX500_xmac_rpu_hold_pc_rpu_pc        0x0000007fU
#define SRT_NX500_xmac_rpu_hold_pc_rpu_pc        0
#define DFLT_VAL_NX500_xmac_rpu_hold_pc_rpu_pc   0x00000000U
#define MSK_NX500_xmac_rpu_hold_pc_rpu_hold      0x00008000U
#define SRT_NX500_xmac_rpu_hold_pc_rpu_hold      15
#define DFLT_VAL_NX500_xmac_rpu_hold_pc_rpu_hold 0x00008000U

enum {
	BFW_NX500_xmac_rpu_hold_pc_rpu_pc    = 7,  /* [6:0] */
	BFW_NX500_xmac_rpu_hold_pc_reserved1 = 8,  /* [14:7] */
	BFW_NX500_xmac_rpu_hold_pc_rpu_hold  = 1,  /* [15] */
	BFW_NX500_xmac_rpu_hold_pc_reserved2 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_RPU_HOLD_PC_BIT_Ttag {
	unsigned int rpu_pc    : BFW_NX500_xmac_rpu_hold_pc_rpu_pc;    /* Program counter (read only, write can happen via adr_xmac_rpu_pc) */
	unsigned int reserved1 : BFW_NX500_xmac_rpu_hold_pc_reserved1; /* reserved                                                          */
	unsigned int rpu_hold  : BFW_NX500_xmac_rpu_hold_pc_rpu_hold;  /* to hold RPU                                                       */
	unsigned int reserved2 : BFW_NX500_xmac_rpu_hold_pc_reserved2; /* reserved                                                          */
} NX500_XMAC_RPU_HOLD_PC_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_XMAC_RPU_HOLD_PC_BIT_T bf;
} NX500_XMAC_RPU_HOLD_PC_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tpu_hold_pc */
/* => xMAC TPU hold_pc register: */
/*    rpu_hold_pc and tpu_hold_pc are the only registers accessible by ARM-CPU, */
/*    while RPU or TPU are running (hold=0). */
/*    To access other registers of xMAC, first hold RPU and TPU. */
/*    This register is not visible for xMAC RPU and TPU. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_xmac_tpu_hold_pc   0x00000A04U
#define Adr_NX500_xmac0_xmac_tpu_hold_pc 0x00160A04U
#define Adr_NX500_xmac1_xmac_tpu_hold_pc 0x00161A04U
#define Adr_NX500_xmac2_xmac_tpu_hold_pc 0x00162A04U
#define Adr_NX500_xmac3_xmac_tpu_hold_pc 0x00163A04U
#define DFLT_VAL_NX500_xmac_tpu_hold_pc  0x00008000U

#define MSK_NX500_xmac_tpu_hold_pc_tpu_pc        0x0000007fU
#define SRT_NX500_xmac_tpu_hold_pc_tpu_pc        0
#define DFLT_VAL_NX500_xmac_tpu_hold_pc_tpu_pc   0x00000000U
#define MSK_NX500_xmac_tpu_hold_pc_tpu_hold      0x00008000U
#define SRT_NX500_xmac_tpu_hold_pc_tpu_hold      15
#define DFLT_VAL_NX500_xmac_tpu_hold_pc_tpu_hold 0x00008000U

enum {
	BFW_NX500_xmac_tpu_hold_pc_tpu_pc    = 7,  /* [6:0] */
	BFW_NX500_xmac_tpu_hold_pc_reserved1 = 8,  /* [14:7] */
	BFW_NX500_xmac_tpu_hold_pc_tpu_hold  = 1,  /* [15] */
	BFW_NX500_xmac_tpu_hold_pc_reserved2 = 16  /* [31:16] */
};

typedef struct NX500_XMAC_TPU_HOLD_PC_BIT_Ttag {
	unsigned int tpu_pc    : BFW_NX500_xmac_tpu_hold_pc_tpu_pc;    /* Program counter (read only, write can happen via adr_xmac_tpu_pc) */
	unsigned int reserved1 : BFW_NX500_xmac_tpu_hold_pc_reserved1; /* reserved                                                          */
	unsigned int tpu_hold  : BFW_NX500_xmac_tpu_hold_pc_tpu_hold;  /* to hold TPU                                                       */
	unsigned int reserved2 : BFW_NX500_xmac_tpu_hold_pc_reserved2; /* reserved                                                          */
} NX500_XMAC_TPU_HOLD_PC_BIT_T;

typedef union {
	unsigned int                 val;
	NX500_XMAC_TPU_HOLD_PC_BIT_T bf;
} NX500_XMAC_TPU_HOLD_PC_T;


/* ===================================================================== */

/* Area of pointer_fifo */

/* ===================================================================== */

#define Addr_NX500_pointer_fifo  0x00164000U
#define NX500_NETX_PTR_FIFO_AREA 0x00164000U

/* --------------------------------------------------------------------- */
/* Register pfifo_base */
/* => Pointer FIFO table: */
/*    Each of the following 32 addresses accesses a FIFO. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pfifo_base          0x00000000U
#define Adr_NX500_pointer_fifo_pfifo_base 0x00164000U
#define Adr_NX500_pfifo_base              0x00164000U
#define DFLT_VAL_NX500_pfifo_base         0x00000000U

#define MSK_NX500_pfifo_base_fifo_data      0xffffffffU
#define SRT_NX500_pfifo_base_fifo_data      0
#define DFLT_VAL_NX500_pfifo_base_fifo_data 0x00000000U

enum {
	BFW_NX500_pfifo_base_fifo_data = 32  /* [31:0] */
};

typedef struct NX500_PFIFO_BASE_BIT_Ttag {
	unsigned int fifo_data : BFW_NX500_pfifo_base_fifo_data; /* In/output data to/from FIFO:     */
	                                                         /* write access: write data to FIFO */
} NX500_PFIFO_BASE_BIT_T;

typedef union {
	unsigned int           val;
	NX500_PFIFO_BASE_BIT_T bf;
} NX500_PFIFO_BASE_T;

/* --------------------------------------------------------------------- */
/* Register pfifo_border_base */
/* => Pointer FIFO Upper Borders table: */
/*    The sizes of all FIFOs are programmable. The total size of all FIFOs must not exceed 2048 dwords. \ */
/*    Each of the following 32 addresses accesses the upper border of the appropriate FIFO in a 2048x32 bit RAM. \ */
/*    All upper borders should be rising with number of FIFO. \ */
/*    Each FIFO starts at the upper border + 1 of the preceding FIFO and ends at its upper border. */
/*    If a border between two FIFOs is moved, the adjacent FIFOs should be reset first. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX500_pfifo_border_base          0x00000080U
#define Adr_NX500_pointer_fifo_pfifo_border_base 0x00164080U
#define Adr_NX500_pfifo_border_base              0x00164080U
#define DFLT_VAL_NX500_pfifo_border_base         0x00000000U

#define MSK_NX500_pfifo_border_base_border      0x000007ffU
#define SRT_NX500_pfifo_border_base_border      0
#define DFLT_VAL_NX500_pfifo_border_base_border 0x00000000U

enum {
	BFW_NX500_pfifo_border_base_border    = 11, /* [10:0] */
	BFW_NX500_pfifo_border_base_reserved1 = 21  /* [31:11] */
};

typedef struct NX500_PFIFO_BORDER_BASE_BIT_Ttag {
	unsigned int border    : BFW_NX500_pfifo_border_base_border;    /* last address of RAM used by appropriate FIFO, = (first address - 1) of next FIFO */
	                                                                /* FIFO 0 default depth:     1024                                                   */
	unsigned int reserved1 : BFW_NX500_pfifo_border_base_reserved1; /* reserved                                                                         */
} NX500_PFIFO_BORDER_BASE_BIT_T;

typedef union {
	unsigned int                  val;
	NX500_PFIFO_BORDER_BASE_BIT_T bf;
} NX500_PFIFO_BORDER_BASE_T;

/* --------------------------------------------------------------------- */
/* Register pfifo_reset */
/* => Pointer FIFO Reset Vector: */
/*    This register allows to reset each of 32 FIFOs, \ */
/*    i.e. set read and write pointer to lower border of FIFO, reset full, overflow, und